<?php
/**
 * @version    2.0
 * @package    com_tlpportfolio
 * @author     TechLabPro <info@techlabpro.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

// No direct access.
defined( '_JEXEC' ) or die;

jimport( 'joomla.application.component.modeladmin' );

/**
 * Tlpportfolio model.
 *
 * @since  1.6
 */
class TlpportfolioModelPortfolio extends JModelAdmin {
	/**
	 * @var      string    The prefix to use with controller messages.
	 * @since    1.6
	 */
	protected $text_prefix = 'COM_TLPPORTFOLIO';

	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param   string $type The table type to instantiate
	 * @param   string $prefix A prefix for the table class name. Optional.
	 * @param   array $config Configuration array for model. Optional.
	 *
	 * @return    JTable    A database object
	 *
	 * @since    1.6
	 */
	public function getTable( $type = 'Portfolio', $prefix = 'TlpportfolioTable', $config = array() ) {
		return JTable::getInstance( $type, $prefix, $config );
	}

	/**
	 * Method to get the record form.
	 *
	 * @param   array $data An optional array of data for the form to interogate.
	 * @param   boolean $loadData True if the form is to load its own data (default case), false if not.
	 *
	 * @return  JForm  A JForm object on success, false on failure
	 *
	 * @since    1.6
	 */
	public function getForm( $data = array(), $loadData = true ) {
		// Initialise variables.
		$app = JFactory::getApplication();

		// Get the form.
		$form = $this->loadForm(
			'com_tlpportfolio.portfolio', 'portfolio',
			array(
				'control'   => 'jform',
				'load_data' => $loadData
			)
		);

		if ( empty( $form ) ) {
			return false;
		}

		return $form;
	}

	/**
	 * Method to get the data that should be injected in the form.
	 *
	 * @return   mixed  The data for the form.
	 *
	 * @since    1.6
	 */
	protected function loadFormData() {
		// Check the session for previously entered form data.
		$data = JFactory::getApplication()->getUserState( 'com_tlpportfolio.edit.portfolio.data', array() );

		if ( empty( $data ) ) {
			$data = $this->getItem();
		}

		return $data;
	}

	/**
	 * Method to get a single record.
	 *
	 * @param   integer $pk The id of the primary key.
	 *
	 * @return  mixed    Object on success, false on failure.
	 *
	 * @since    1.6
	 */
	public function getItem( $pk = null ) {
		if ( $item = parent::getItem( $pk ) ) {
			// Do any procesing on fields here if needed
		}

		return $item;
	}

	/**
	 * Prepare and sanitise the table prior to saving.
	 *
	 * @param   JTable $table Table Object
	 *
	 * @return void
	 *
	 * @since    1.6
	 */
	protected function prepareTable( $table ) {
		jimport( 'joomla.filter.output' );

		if ( empty( $table->id ) ) {
			// Set ordering to the last item if not set
			if ( @$table->ordering === '' ) {
				$db = JFactory::getDbo();
				$db->setQuery( 'SELECT MAX(ordering) FROM #__tlpportfolio_portfolio' );
				$max             = $db->loadResult();
				$table->ordering = $max + 1;
			}
		}
	}

	public function save( $data ) {

		//Support for file field: pgallery
		$input   = JFactory::getApplication()->input;
		$files   = $input->files->get( 'jform', array(), 'raw' );
		$fInput  = $input->post->get( 'jform', array(), 'raw' );
		$oldImgs = array();
		if ( is_array( $fInput['pghidden'] ) && ! empty( $fInput['pghidden'] ) ) {
			$oldImgs = $fInput['pghidden'];
		}
		$pgfiles = array();
		$pgImgA  = array();
		if ( ! empty( $files['pgallery'] ) ) {
			jimport( 'joomla.filesystem.file' );
			$pgfiles = $files['pgallery'];
		}

		if ( $pgfiles ) {

			foreach ( $pgfiles as $pgimg ) {

				//upload Banner 1- 3
				jimport( 'joomla.filesystem.file' );
				jimport( 'joomla.filesystem.folder' );
				//Check if the server found any error.
				$fileError = $pgimg['error'];
				$message   = '';
				if ( $fileError > 0 && $fileError != 4 ) {
					switch ( $fileError ) {
						case 1:
							$message = JText::_( 'File size exceeds allowed by the server' );
							break;
						case 2:
							$message = JText::_( 'File size exceeds allowed by the html form' );
							break;
						case 3:
							$message = JText::_( 'Partial upload error' );
							break;
					}
					if ( $message != '' ) {
						JError::raiseWarning( 500, $message );

						return false;
					}
				} else if ( $fileError == 4 ) {
					if ( isset( $array['portfolio_image_hidden'] ) ) {
						$array['portfolio_image'] = $array['portfolio_image_hidden'];
					}
				} else {
					$tlpportfolio_params   = JComponentHelper::getParams( 'com_tlpportfolio' );
					$image_large_width     = $tlpportfolio_params->get( 'largeimage_width' );
					$image_large_height    = $tlpportfolio_params->get( 'largeimage_height' );
					$image_storiage_path   = $tlpportfolio_params->get( 'image_path' );
					$image_storiage_folder = JPATH_ROOT . '/' . $image_storiage_path . '/';


					$folder = $image_storiage_folder;
					if ( ! file_exists( $folder ) ) {
						mkdir( $folder, 0777, true );
					}//else
					//chmod($folder, 0777);

					jimport( 'joomla.filter.output' );
					$filename    = explode( '.', $pgimg['name'] );
					$filename[0] = preg_replace( "/[^A-Za-z0-9]/i", "-", $filename[0] );
					$filename    = md5( time() ) . '-' . implode( '.', $filename );
					$tmpfilename = 'tmp_' . $filename;
					ini_set( 'memory_limit', '-1' );
					$imageSrc = $pgimg['tmp_name'];
					if ( move_uploaded_file( $imageSrc, $folder . $tmpfilename ) ) {
						if ( self::resizeImage( $folder . $tmpfilename, $folder . $filename, $image_large_width,
							$image_large_height )
						) {
							if ( file_exists( $folder . $tmpfilename ) ) {
								unlink( $folder . $tmpfilename );
							}
						}

						$pgImgA[] = $filename;
					}
				}
			}

		}
		$newImgA = array_merge( $oldImgs, $pgImgA );
		$imgList = implode( ",", $newImgA );
		$data['pgallery'] = $imgList;
		return parent::save($data);

	}


	public static function resizeImage(
		$src_file,
		$dest_file,
		$max_width,
		$max_height,
		$method = 'gd2',
		$dest_qual = '95'
	) {
		$imagetype = array(
			1  => 'GIF',
			2  => 'JPG',
			3  => 'PNG',
			4  => 'SWF',
			5  => 'PSD',
			6  => 'BMP',
			7  => 'TIFF',
			8  => 'TIFF',
			9  => 'JPC',
			10 => 'JP2',
			11 => 'JPX',
			12 => 'JB2',
			13 => 'SWC',
			14 => 'IFF'
		);
		$imginfo   = getimagesize( $src_file );

		if ( $imginfo == null ) {
			die( "ERROR: Source file not found!" );
		}

		$imginfo[2] = $imagetype[ $imginfo[2] ];

		# GD can only handle JPG & PNG images
		if ( $imginfo[2] != 'JPG' && $imginfo[2] != 'PNG' && $imginfo[2] != 'GIF' && ( $method == 'gd1' || $method == 'gd2' ) ) {
			die( "ERROR: GD can only handle GIF, JPG and PNG files!" );
		}

		# height/width
		$srcWidth  = $imginfo[0];
		$srcHeight = $imginfo[1];

		if ( $srcWidth > $srcHeight ) {
			$ratio      = $srcWidth / $max_width;
			$ratio      = max( $ratio, 1.0 );
			$destWidth  = (int) ( $srcWidth / $ratio );
			$destHeight = (int) ( $srcHeight / $ratio );
		} else {
			$ratio      = $srcHeight / $max_height;
			$ratio      = max( $ratio, 1.0 );
			$destWidth  = (int) ( $srcWidth / $ratio );
			$destHeight = (int) ( $srcHeight / $ratio );
		}

		# Method for thumbnails creation
		switch ( $method ) {

			case "gd1" :

				if ( ! function_exists( 'imagecreatefromjpeg' ) ) {
					die( 'GD image library not installed!' );
				}
				if ( $imginfo[2] == 'GIF' ) {
					$src_img = imagecreatefromgif( $src_file );
				} else if ( $imginfo[2] == 'JPG' ) {
					$src_img = imagecreatefromjpeg( $src_file );
				} else {
					$src_img = imagecreatefrompng( $src_file );
				}
				if ( ! $src_img ) {
					return false;
				}
				$dst_img = imagecreate( $destWidth, $destHeight );
				imagecopyresized( $dst_img, $src_img, 0, 0, 0, 0, $destWidth, (int) $destHeight, $srcWidth,
					$srcHeight );
				imagejpeg( $dst_img, $dest_file, $dest_qual );
				imagedestroy( $src_img );
				imagedestroy( $dst_img );
				break;

			case "gd2" :

				$gdinfo = gd_info();
				if ( empty( $gdinfo['GD Version'] ) ) {
					die( 'GD2 image library not installed!' );
				}

				if ( $imginfo[2] == 'GIF' ) {
					$src_img = imagecreatefromgif( $src_file );
				} else if ( $imginfo[2] == 'JPG' ) {
					$src_img = imagecreatefromjpeg( $src_file );
				} else {
					$src_img = imagecreatefrompng( $src_file );
				}
				if ( ! $src_img ) {
					return false;
				}
				$dst_img = imagecreatetruecolor( $destWidth, $destHeight );
				imagecopyresampled( $dst_img, $src_img, 0, 0, 0, 0, $destWidth, (int) $destHeight, $srcWidth,
					$srcHeight );
				imagejpeg( $dst_img, $dest_file, $dest_qual );
				imagedestroy( $src_img );
				imagedestroy( $dst_img );
				break;
		}

		# Set mode of uploaded picture
		chmod( $dest_file, octdec( '755' ) );

		# We check that the image is valid
		$imginfo = getimagesize( $dest_file );
		if ( $imginfo == null ) {
			return false;
		} else {
			return true;
		}
	}
}
