<?php
/**
 * @version    2.0
 * @package    com_tlpportfolio
 * @author     TechLabPro <info@techlabpro.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Methods supporting a list of Tlpportfolio records.
 *
 * @since  1.6
 */
class TlpportfolioModelPortfolios extends JModelList
{
/**
	* Constructor.
	*
	* @param   array  $config  An optional associative array of configuration settings.
	*
	* @see        JController
	* @since      1.6
	*/
	public function __construct($config = array())
	{
		if (empty($config['filter_fields']))
		{
			$config['filter_fields'] = array(
				'id', 'a.`id`',
				'title', 'a.`title`',
				'alias', 'a.`alias`',
				'category', 'a.`category`',
				'short_description', 'a.`short_description`',
				'tools_used', 'a.`tools_used`',
				'project_url', 'a.`project_url`',
				'client_name', 'a.`client_name`',
				'description', 'a.`description`',
				'portfolio_image', 'a.`portfolio_image`',
				'completed_date', 'a.`completed_date`',
				'tags', 'a.`tags`',
				'related_projects', 'a.`related_projects`',
				'language', 'a.`language`',
				'access', 'a.`access`',
				'ordering', 'a.`ordering`',
				'state', 'a.`state`',
				'created_by', 'a.`created_by`',
			);
		}

		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   Elements order
	 * @param   string  $direction  Order direction
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		// Initialise variables.
		$app = JFactory::getApplication('administrator');

		// Load the filter state.
		$search = $app->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$published = $app->getUserStateFromRequest($this->context . '.filter.state', 'filter_published', '', 'string');
		$this->setState('filter.state', $published);
		// Filtering category
		$this->setState('filter.category', $app->getUserStateFromRequest($this->context.'.filter.category', 'filter_category', '', 'string'));

		// Filtering tools_used
		$this->setState('filter.tools_used', $app->getUserStateFromRequest($this->context.'.filter.tools_used', 'filter_tools_used', '', 'string'));

		// Filtering language
		// Language filters for all languages is a * make it empty
		if (JFactory::getApplication()->input->getVar('filter_language') == '*')
		{
			JFactory::getApplication()->input->set('filter_language', '');
		}
		$this->setState('filter.language', $app->getUserStateFromRequest($this->context.'.filter.language', 'filter_language', '', 'string'));


		// Load the parameters.
		$params = JComponentHelper::getParams('com_tlpportfolio');
		$this->setState('params', $params);

		// List state information.
		parent::populateState('a.title', 'asc');
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param   string  $id  A prefix for the store id.
	 *
	 * @return   string A store id.
	 *
	 * @since    1.6
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . $this->getState('filter.search');
		$id .= ':' . $this->getState('filter.state');

		return parent::getStoreId($id);
	}

	/**
	 * Build an SQL query to load the list data.
	 *
	 * @return   JDatabaseQuery
	 *
	 * @since    1.6
	 */
	protected function getListQuery()
	{
		// Create a new query object.
		$db    = $this->getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select(
			$this->getState(
				'list.select', 'DISTINCT a.*'
			)
		);
		$query->from('`#__tlpportfolio_portfolio` AS a');

		// Join over the users for the checked out user
		$query->select("uc.name AS editor");
		$query->join("LEFT", "#__users AS uc ON uc.id=a.checked_out");
		// Join over the category 'category'
		$query->select('`category`.title AS `category`');
		$query->join('LEFT', '#__categories AS `category` ON `category`.id = a.`category`');
		// Join over the foreign key 'tools_used'
		$query->select('#__tlpportfolio_tools_1712705.`title` AS tools_title_1712705');
		$query->join('LEFT', '#__tlpportfolio_tools AS #__tlpportfolio_tools_1712705 ON #__tlpportfolio_tools_1712705.`id` = a.`tools_used`');
		// Join over the foreign key 'related_projects'
		$query->select('#__tlpportfolio_portfolio_2156804.`title` AS portfolios_title_2156804');
		$query->join('LEFT', '#__tlpportfolio_portfolio AS #__tlpportfolio_portfolio_2156804 ON #__tlpportfolio_portfolio_2156804.`id` = a.`related_projects`');

		// Join over the access level field 'access'
		$query->select('`access`.title AS `access`');
		$query->join('LEFT', '#__viewlevels AS access ON `access`.id = a.`access`');

		// Join over the user field 'created_by'
		$query->select('`created_by`.name AS `created_by`');
		$query->join('LEFT', '#__users AS `created_by` ON `created_by`.id = a.`created_by`');

		// Filter by published state
		$published = $this->getState('filter.state');

		if (is_numeric($published))
		{
			$query->where('a.state = ' . (int) $published);
		}
		elseif ($published === '')
		{
			$query->where('(a.state IN (0, 1))');
		}

		// Filter by search in title
		$search = $this->getState('filter.search');

		if (!empty($search))
		{
			if (stripos($search, 'id:') === 0)
			{
				$query->where('a.id = ' . (int) substr($search, 3));
			}
			else
			{
				$search = $db->Quote('%' . $db->escape($search, true) . '%');
				$query->where('( a.`title` LIKE ' . $search . '  OR  a.`category` LIKE ' . $search . '  OR  a.`tools_used` LIKE ' . $search . '  OR  a.`client_name` LIKE ' . $search . ' )');
			}
		}


		//Filtering category
		$filter_category = $this->state->get("filter.category");
		if ($filter_category) {
			$query->where("a.`category` = '".$db->escape($filter_category)."'");
		}

		//Filtering tools_used
		$filter_tools_used = $this->state->get("filter.tools_used");
		if ($filter_tools_used) {
			$query->where("FIND_IN_SET('" . $db->escape($filter_tools_used) . "',a.tools_used)");
		}

		//Filtering language
		$filter_language = $this->state->get("filter.language");
		if ($filter_language) {
			$query->where("a.`language` = '".$db->escape($filter_language)."'");
		}
		// Add the list ordering clause.
		$orderCol  = $this->state->get('list.ordering');
		$orderDirn = $this->state->get('list.direction');

		if ($orderCol && $orderDirn)
		{
			$query->order($db->escape($orderCol . ' ' . $orderDirn));
		}

		return $query;
	}

	/**
	 * Get an array of data items
	 *
	 * @return mixed Array of data items on success, false on failure.
	 */
	public function getItems()
	{
		$items = parent::getItems();

		foreach ($items as $oneItem) {

			if (isset($oneItem->tools_used)) {
				$values = explode(',', $oneItem->tools_used);

				$textValue = array();
				foreach ($values as $value){
					$db = JFactory::getDbo();
					$query = $db->getQuery(true);
					$query
							->select($db->quoteName('title'))
							->from('`#__tlpportfolio_tools`')
							->where($db->quoteName('id') . ' = '. $db->quote($db->escape($value)));
					$db->setQuery($query);
					$results = $db->loadObject();
					if ($results) {
						$textValue[] = $results->title;
					}
				}

			$oneItem->tools_used = !empty($textValue) ? implode(', ', $textValue) : $oneItem->tools_used;

			}

			if ( isset($oneItem->tags) ) {
				// Catch the item tags (string with ',' coma glue)
				$tags = explode(",",$oneItem->tags);

				$db = JFactory::getDbo();
					$namedTags = array(); // Cleaning and initalization of named tags array

					// Get the tag names of each tag id
					foreach ($tags as $tag) {

						$query = $db->getQuery(true);
						$query->select("title");
						$query->from('`#__tags`');
						$query->where( "id=" . intval($tag) );

						$db->setQuery($query);
						$row = $db->loadObjectList();

						// Read the row and get the tag name (title)
						if (!is_null($row)) {
							foreach ($row as $value) {
								if ( $value && isset($value->title) ) {
									$namedTags[] = trim($value->title);
								}
							}
						}

					}

					// Finally replace the data object with proper information
					$oneItem->tags = !empty($namedTags) ? implode(', ',$namedTags) : $oneItem->tags;
				}

			if (isset($oneItem->related_projects)) {
				$values = explode(',', $oneItem->related_projects);

				$textValue = array();
				foreach ($values as $value){
					$db = JFactory::getDbo();
					$query = $db->getQuery(true);
					$query
							->select($db->quoteName('title'))
							->from('`#__tlpportfolio_portfolio`')
							->where($db->quoteName('id') . ' = '. $db->quote($db->escape($value)));
					$db->setQuery($query);
					$results = $db->loadObject();
					if ($results) {
						$textValue[] = $results->title;
					}
				}

			$oneItem->related_projects = !empty($textValue) ? implode(', ', $textValue) : $oneItem->related_projects;

			}
		}
		return $items;
	}
}
