<?php
/**
 * @version    1.0.0
 * @package    Com_Tlpportfolio
 * @author     TechLabPro <info@techlabpro.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');

// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet('components/com_tlpportfolio/assets/css/tlpportfolio.css');
?>
<script type="text/javascript">
	js = jQuery.noConflict();
	js(document).ready(function () {

	js('input:hidden.tools_used').each(function(){
		var name = js(this).attr('name');
		if(name.indexOf('tools_usedhidden')){
			js('#jform_tools_used option[value="'+js(this).val()+'"]').attr('selected',true);
		}
	});
	js("#jform_tools_used").trigger("liszt:updated");
	js('input:hidden.related_projects').each(function(){
		var name = js(this).attr('name');
		if(name.indexOf('related_projectshidden')){
			js('#jform_related_projects option[value="'+js(this).val()+'"]').attr('selected',true);
		}
	});
	js("#jform_related_projects").trigger("liszt:updated");
	});

	Joomla.submitbutton = function (task) {
		if (task == 'portfolio.cancel') {
			Joomla.submitform(task, document.getElementById('portfolio-form'));
		}
		else {

				js = jQuery.noConflict();
				if(js('#jform_portfolio_image').val() != ''){
					js('#jform_portfolio_image_hidden').val(js('#jform_portfolio_image').val());
				}
			if (task != 'portfolio.cancel' && document.formvalidator.isValid(document.id('portfolio-form'))) {

	if(js('#jform_tools_used option:selected').length == 0){
		js("#jform_tools_used option[value=0]").attr('selected','selected');
	}
	if(js('#jform_related_projects option:selected').length == 0){
		js("#jform_related_projects option[value=0]").attr('selected','selected');
	}
				Joomla.submitform(task, document.getElementById('portfolio-form'));
			}
			else {
				alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
			}
		}
	}
</script>

<form
	action="<?php echo JRoute::_('index.php?option=com_tlpportfolio&layout=edit&id=' . (int) $this->item->id); ?>"
	method="post" enctype="multipart/form-data" name="adminForm" id="portfolio-form" class="form-validate">
<?php echo JLayoutHelper::render('joomla.edit.title_alias', $this); ?>
	<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'general')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'general', JText::_('COM_TLPPORTFOLIO_TITLE_PORTFOLIO', true)); ?>
		<div class="row-fluid">
			<div class="span10 form-horizontal">
				<fieldset class="adminform">

				<input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>" />

			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('category'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('category'); ?></div>
			</div>
			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('short_description'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('short_description'); ?></div>
			</div>
			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('tools_used'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('tools_used'); ?></div>
			</div>

			<?php
				foreach((array)$this->item->tools_used as $value):
					if(!is_array($value)):
						echo '<input type="hidden" class="tools_used" name="jform[tools_usedhidden]['.$value.']" value="'.$value.'" />';
					endif;
				endforeach;
			?>
			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('project_url'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('project_url'); ?></div>
			</div>
			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('custom_url'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('custom_url'); ?></div>
			</div>
			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('client_name'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('client_name'); ?></div>
			</div>
			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('description'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('description'); ?></div>
			</div>
			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('portfolio_image'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('portfolio_image'); ?></div>
			</div>
			<?php 
			if($this->item->id>0){
				$pgallery=TlpportfolioHelper::getPortfolioGallery($this->item->id);
			}
				
				$tlpportfolio_params = JComponentHelper::getParams('com_tlpportfolio');
				$image_storiage_path = $tlpportfolio_params->get('image_path','images/tlpportfolio');
				$image_storiage_folder = JURI::root(). $image_storiage_path.'/';
				
			?>
			<div class="control-group">
				<div class="control-label"></div>
				<div class="controls">
				<?php if($this->item->portfolio_image){ //echo $this->item->portfolio_image;?>
				<img src="<?php echo $image_storiage_folder.'s_'.$this->item->portfolio_image;?>">
				<?php }?>
				</div>
			</div>

			<div class="control-group">
				<div class="control-label">Gallery</div>
				<div class="controls port-gallery-holder">
					<div id="pg-new-upload">
						<a href="#" class="add-new-images btn btn-small btn-success">Add New Image</a>
					</div>
					<div id="port-gallery">
						<?php
						if($this->item->id){
						
						$html = null;
						if(isset($pgallery)){
							if($pgallery) {
								$pgImgs = explode(',', $pgallery);
							}else{
								$pgImgs = array();
							}
							if(is_array($pgImgs) && !empty($pgImgs)){
								foreach($pgImgs as $img){
									$html .= "<div class='img-holder'>";
										$html .= "<button class='btn btn-small portGImageDelete'>";
										$html .= "<span class='icon-cancel'></span>Delete</button>";
										$html .= "<div class='image-preview'>";
												$html .= "<img src='{$image_storiage_folder}{$img}' />";
										$html .= "</div>";
										$html .= "<input type='hidden' name='jform[pghidden][]' value='{$img}' />";
									$html .="</div>";
								}
							}
						}
						echo $html;
					}
						?>
					</div>
				</div>
			</div>

				<input type="hidden" name="jform[portfolio_image]" id="jform_portfolio_image_hidden" value="<?php echo $this->item->portfolio_image ?>" />			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('completed_date'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('completed_date'); ?></div>
			</div>

			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('tags'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('tags'); ?></div>
			</div>
			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('related_projects'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('related_projects'); ?></div>
			</div>

			<?php
				foreach((array)$this->item->related_projects as $value):
					if(!is_array($value)):
						echo '<input type="hidden" class="related_projects" name="jform[related_projectshidden]['.$value.']" value="'.$value.'" />';
					endif;
				endforeach;
			?>			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('language'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('language'); ?></div>
			</div>
			<div class="control-group">
				<div class="control-label"><?php echo $this->form->getLabel('access'); ?></div>
				<div class="controls"><?php echo $this->form->getInput('access'); ?></div>
			</div>
				<input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>" />
				<input type="hidden" name="jform[state]" value="<?php echo $this->item->state; ?>" />
				<input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>" />
				<input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>" />

				<?php if(empty($this->item->created_by)){ ?>
					<input type="hidden" name="jform[created_by]" value="<?php echo JFactory::getUser()->id; ?>" />

				<?php }
				else{ ?>
					<input type="hidden" name="jform[created_by]" value="<?php echo $this->item->created_by; ?>" />

				<?php } ?>

				</fieldset>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>



		<?php echo JHtml::_('bootstrap.endTabSet'); ?>

		<input type="hidden" name="task" value=""/>
		<?php echo JHtml::_('form.token'); ?>

	</div>
</form>

<script type="text/javascript">

	(function($){
			'use strict';

		$(".add-new-images").on('click', function(){
			var imgHolder = "<div class='img-holder'>" +
					"<button class='btn btn-small portGImageDelete'>" +
						"<span class='icon-cancel'></span>Delete</button>"+
					"<div class='port-file-holder'><input type='file' class='port-file' name='jform[pgallery][]' /></div>" +
					"<div class='image-preview'></div>" +
				"</div>";

			$("#port-gallery").append(imgHolder);

			return false;
		});

		$(".portGImageDelete").live('click', function(e){
			if(confirm("Really want to delete this!!!")) {
				$(this).parent('.img-holder').remove();
			}
			return false;
		});

		$(".port-file").live("change", function(){
			//Get count of selected files

			var imgPath = $(this)[0].value;
			var extn = imgPath.substring(imgPath.lastIndexOf('.') + 1).toLowerCase();
			var image_holder = $(this).parent(".port-file-holder").next(".image-preview");
			console.log(image_holder);
			image_holder.empty();

			if (extn == "gif" || extn == "png" || extn == "jpg" || extn == "jpeg") {
				if (typeof (FileReader) != "undefined") {

					image_holder.empty();

					var reader = new FileReader();
					reader.onload = function (e) {
						$("<img />", {
							"src": e.target.result,
							"class": "thumb-image"
						}).appendTo(image_holder);

					}
					reader.readAsDataURL($(this)[0].files[0]);
				} else {
					alert("This browser does not support FileReader.");
				}
			} else {
				alert("Pls select only images");
			}
		});

	})(jQuery);

</script>
<style>
	div#port-gallery {
		width: 100%;
		display: inline-block;
	}
	#port-gallery .img-holder {
		float: left;
		margin: 10px 10px 15px 10px;
		min-height: 200px;
		width: 150px;
		overflow: hidden;
	}
	.image-preview .thumb-image{
		width: 150px;
		height: 150px;
	}
</style>