<?php
/**
 * @version    2.0
 * @package    com_rtlogoshowcase
 * @author     RadiusTheme <support@radiustheme.com>
 * @copyright  Copyright (C) 2016. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user       = JFactory::getUser();
$userId     = $user->get('id');
$listOrder  = $this->state->get('list.ordering');
$listDirn   = $this->state->get('list.direction');
$canCreate  = $user->authorise('core.create', 'com_rtlogoshowcase');
$canEdit    = $user->authorise('core.edit', 'com_rtlogoshowcase');
$canCheckin = $user->authorise('core.manage', 'com_rtlogoshowcase');
$canChange  = $user->authorise('core.edit.state', 'com_rtlogoshowcase');
$canDelete  = $user->authorise('core.delete', 'com_rtlogoshowcase');
$app = JFactory::getApplication();
$logoshowcase_params 		= JComponentHelper::getParams('com_rtlogoshowcase');
$image_storiage_path 		= $logoshowcase_params->get('image_path','images/rtlogoshowcase');
$g_primary_color 			= $logoshowcase_params->get('g_primary_color','');
$g_display_no 				= $logoshowcase_params->get('g_display_no','');
$g_display_no_tab 			= $logoshowcase_params->get('g_display_no_tab','');
$g_display_no_mob 			= $logoshowcase_params->get('g_display_no_mob','');
$g_layout 					= $logoshowcase_params->get('g_layout','grid');
$g_link_type 				= $logoshowcase_params->get('g_link_type','');
$g_link_url 				= $logoshowcase_params->get('g_link_url','0');
$g_show_title 				= $logoshowcase_params->get('g_show_title','');
$g_title_size 				= $logoshowcase_params->get('g_title_size','14px');
$g_title_align 				= $logoshowcase_params->get('g_title_align','');
$g_title_color 				= $logoshowcase_params->get('g_title_color','');
$g_title_font_weight 		= $logoshowcase_params->get('g_title_font_weight','');
$g_short_desc 				= $logoshowcase_params->get('g_short_desc','0');
$g_short_desc_text_size 	= $logoshowcase_params->get('g_short_desc_text_size');
$g_short_desc_text_align 	= $logoshowcase_params->get('g_short_desc_text_align');
$g_box_highlight 			= $logoshowcase_params->get('g_box_highlight');
$g_box_border 				= $logoshowcase_params->get('g_box_border');
$g_box_border_style 		= $logoshowcase_params->get('g_box_border_style');
$g_box_border_color 		= $logoshowcase_params->get('g_box_border_color');
$g_box_border_color_hover 	= $logoshowcase_params->get('g_box_border_color_hover');
$g_box_shadow 				= $logoshowcase_params->get('g_box_shadow');
$g_box_shadow_color 		= $logoshowcase_params->get('g_box_shadow_color');
$g_gutter 					= $logoshowcase_params->get('g_gutter');
$g_grayscale 				= $logoshowcase_params->get('g_grayscale');
$g_tooltip 					= $logoshowcase_params->get('g_tooltip');


// get the menu parameters for use
$app                     	= JFactory::getApplication();
$menu                    	= $app->getMenu();
$active                  	= $menu->getActive();
$itemId                  	= $active->id;
$menuparams              	= $menu->getParams( $itemId );
$cat_id			 			= $menuparams->get('category','');
$m_primary_color 			= $menuparams->get('m_primary_color','');
$m_display_no 				= $menuparams->get('m_display_no','');
$m_display_no_tab 			= $menuparams->get('m_display_no_tab','');
$m_display_no_mob 			= $menuparams->get('m_display_no_mob','');
$m_layout 					= $menuparams->get('m_layout','');
$m_link_type 				= $menuparams->get('m_link_type','');
$m_link_url 				= $menuparams->get('m_link_url','');
$m_show_title 				= $menuparams->get('m_show_title','');
$m_title_size 				= $menuparams->get('m_title_size','');
$m_title_align 				= $menuparams->get('m_title_align','');
$m_title_color 				= $menuparams->get('m_title_color','');
$m_title_font_weight 		= $menuparams->get('m_title_font_weight','');
$m_short_desc 				= $menuparams->get('m_short_desc','');
$m_short_desc_text_size 	= $menuparams->get('m_short_desc_text_size');
$m_short_desc_text_align 	= $menuparams->get('m_short_desc_text_align');
$m_box_border 				= $menuparams->get('m_box_border');
$m_box_highlight 			= $menuparams->get('m_box_highlight');
$m_box_border_style 		= $menuparams->get('m_box_border_style');
$m_box_border_color 		= $menuparams->get('m_box_border_color');
$m_box_border_color_hover 	= $menuparams->get('m_box_border_color_hover');
$m_box_shadow 				= $menuparams->get('m_box_shadow');
$m_box_shadow_color 		= $menuparams->get('m_box_shadow_color');
$m_gutter 					= $menuparams->get('m_gutter');
$m_grayscale 				= $menuparams->get('m_grayscale');
$m_tooltip 					= $menuparams->get('m_tooltip');
@$hide_showall            	= $menuparams->get('m_hide_showall','');
@$selected_category       	= $menuparams->get('m_selected_category','');

if($m_primary_color!=''){
	$primary_color=$m_primary_color;
}else{
	$primary_color=$g_primary_color;
}
if($m_display_no!=''){
	$display_no=$m_display_no;
}else{
	$display_no=$g_display_no;
}
if($m_layout!=''){
	$layout=$m_layout;
}else{
	$layout=$g_layout;
}
if($m_link_type!=''){
	$link_type=$m_link_type;
}else{
	$link_type=$g_link_type;
}
if($m_link_url!=''){
	$link_url=$m_link_url;
}else{
	$link_url=$g_link_url;
}
if($m_show_title!=''){
	$show_title=$m_show_title;
}else{
	$show_title=$g_show_title;
}
if($m_title_size!=''){
	$title_size=$m_title_size;
}else{
	$title_size=$g_title_size;
}
if($m_title_align!=''){
	$title_align=$m_title_align;
}else{
	$title_align=$g_title_align;
}
if($m_title_color!=''){
	$title_color=$m_title_color;
}else{
	$title_color=$g_title_color;
}
if($m_title_font_weight!=''){
	$title_font_weight=$m_title_font_weight;
}else{
	$title_font_weight=$g_title_font_weight;
}
if($m_short_desc!=''){
	$short_desc=$m_short_desc;
}else{
	$short_desc=$g_short_desc;
}
if($m_short_desc_text_size!=''){
	$short_desc_text_size=$m_short_desc_text_size;
}else{
	$short_desc_text_size=$g_short_desc_text_size;
}
if($m_short_desc_text_align!=''){
	$short_desc_text_align=$m_short_desc_text_align;
}else{
	$short_desc_text_align=$g_short_desc_text_align;
}
if($m_box_border!=''){
	$box_border=$m_box_border;
}else{
	$box_border=$g_box_border;
}
if($m_box_border_style!=''){
	$box_border_style=$m_box_border_style;
}else{
	$box_border_style=$g_box_border_style;
}
if($m_box_border_color!=''){
	$box_border_color=$m_box_border_color;
}else{
	$box_border_color=$g_box_border_color;
}
if($m_box_border_color_hover!=''){
	$box_border_color_hover=$m_box_border_color_hover ;
}else{
	$box_border_color_hover=$g_box_border_color_hover;
}
if($m_box_shadow!=''){
	$box_shadow=$m_box_shadow;
}else{
	$box_shadow=$g_box_shadow;
}
if($m_box_shadow_color!=''){
	$box_shadow_color=$m_box_shadow_color;
}else{
	$box_shadow_color=$g_box_shadow_color;
}
if($m_box_highlight!=''){
	$box_highlight=$m_box_highlight;
}else{
	$box_highlight=$g_box_highlight;
}
if($m_tooltip!=''){
	$tooltip=$m_tooltip;
}else{
	$tooltip=$g_tooltip;
}
if($m_grayscale!=''){
	$grayscale=$m_grayscale;
}else{
	$grayscale=$g_grayscale;
}
if($m_gutter!=''){
	$gutter=$m_gutter;
}else{
	$gutter=$g_gutter;
}

if($m_display_no!=''){
  $display_no=$m_display_no; 
  $md_grid=(12/$m_display_no);
}else{
  $display_no=$g_display_no; 
  $md_grid=(12/$g_display_no);
}

if($m_display_no_tab != '' ) {
  $sm_grid = ( 12 / $m_display_no_tab );
} else {
  $sm_grid = ( 12 / $g_display_no_tab );
}
if($m_display_no_mob != '' ) {
  $xs_grid = ( 12 / $m_display_no_mob );
} else {
  $xs_grid = ( 12 / $g_display_no_mob );
}
if($grayscale==1) {
	$grayscale_class = 'rt-grayscale';
}else{
	$grayscale_class = '';
}

if($display_no==5){
	$grid=15;
	$bss="rt-col-md-".$grid." rt-col-lg-".$grid ;
}else{
	$bss = "rt-col-md-".$md_grid." rt-col-lg-".$md_grid." rt-col-sm-". $sm_grid. " rt-col-xs-".$xs_grid;

}
if($box_shadow_color){
	$hex = str_replace("#", "", $box_shadow_color);
   if(strlen($hex) == 3) {
      $r = hexdec($hex[0].$hex[0]);
      $g = hexdec($hex[1].$hex[1]);
      $b = hexdec($hex[2].$hex[2]);
   } else {
      $r = hexdec($hex[0].$hex[1]);
      $g = hexdec($hex[2].$hex[3]);
      $b = hexdec($hex[4].$hex[5]);
	}
}

$this->rtconfig= array(
	'image_storiage_path' =>$image_storiage_path,
	'bss' =>$bss,
	'display_no' 	=>$display_no,
	'link_url' 		=>$link_url,
	'link_type' 	=>$link_type,
	'show_title'	=>$show_title,
	'short_desc'	=>$short_desc,
	'tooltip'		=>$tooltip,
	'grayscale'		=>$grayscale_class
	
	);
$document = JFactory::getDocument();
$style ='';
if($gutter){
  $style .= '.rt-logo-showcase .rt-logo-item { margin-bottom: 0px;}';
  $style .= '.rt-logo-showcase [class*=rt-col-] { padding-left : '.$gutter.'px; padding-right : '.$gutter.'px; margin-bottom : '.($gutter*2).'px; }';
  $style .= '.rt-row { margin-left : -'.$gutter.'px!important; margin-right : -'.$gutter.'px!important;}';
}
$style .= '.rt-logo-showcase .rt-logo-item { border: ' . $box_border .' '.$box_border_style.' '.$box_border_color.'; }';
$style .= '.rt-logo-showcase .rt-logo-item:hover { border: ' . $box_border .' '.$box_border_style.' '.$box_border_color_hover.'; }';
$style .= '.rt-logo-showcase .rt-logo-item h3,.rt-logo-showcase .rt-logo-item h3 a { color: ' . $title_color . '; font-size: '. $title_size. '; text-align: '. $title_align .'; font-weight:'.$title_font_weight .'; }';
$style .= '.rt-logo-showcase .rt-logo-item p { font-size: '. $short_desc_text_size. '; text-align: '. $short_desc_text_align .'; }';
if(isset($box_shadow_color)){
	if($box_highlight==1){
		$style .= '.rt-logo-showcase .rt-logo-item:hover { box-shadow: rgba('.$r .','. $g. ','. $b. ','. '0.90)'. $box_shadow.';}';
	}else{
		$style .= '.rt-logo-showcase .rt-logo-item { box-shadow: rgba('.$r .','. $g. ','. $b. ','. '0.90)'. $box_shadow.';}';
	}
}
$style .='.rt-logo-showcase .isotope .button-group .selected,body > .rt-tooltip, body > .rt-tooltip .rt-tooltip-bottom:after { background: '. $primary_color.'; }';

$document->addStyleDeclaration( $style );

?>
<form action="<?php echo JRoute::_('index.php?option=com_rtlogoshowcase&view=logos');?>" method="post" name="adminForm" id="adminForm">
    <div class="rt-container-fluid">
	  	<div class="rt-row rt-logo-showcase">
		  	<div class="<?php echo $layout;?>">
		      
		      <?php if($layout=='isotope'){ ?>
		      	<div class="isotop-container">
					<div class="button-group filter-button-group">
					<?php
					if(!$hide_showall){
						$selected = $selected_category ? null : " class='selected'" ;
						echo '<button data-filter="*" '.$selected.'>'.JText::_('COM_RTLOGOSHOWCASE_LABEL_SHOWALL').'</button>';
					}
					$category=RtlogoshowcaseHelpersRtlogoshowcase::getCategoryName($cat_id);
					
					foreach ($category as $key => $value) {
						$selected = null;
						if($value->id == $selected_category){
							$selected = " class='selected'";
						}
						echo '<button '.$selected.' data-filter=".cat'.strtolower($value->id).'">'.$value->title.'</button>';
						}
					?>
					</div>
					<div class="rt-logo-item-container">
					<?php 
						foreach ($this->items as &$item) : 
							$this->item = & $item;
							echo $this->loadTemplate($layout);
						endforeach; 
					?>
					</div>
				</div>

		      	<?php }else{
				echo '<div class="rt-logo-item-container">';
				    foreach ($this->items as &$item) : 
						$this->item = & $item;
						echo $this->loadTemplate($layout);
					endforeach; 
				echo '</div>';
				}
				?>
				</div>
			</div>
		</div>
		<?php if($layout!='isotope'){ ?>
		<div class="rt-container-fluid">
			<div class="rt-row">
		     	<?php echo $this->pagination->getListFooter(); ?>
			</div>
		</div>
		<?php }?>
	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>"/>
	<?php echo JHtml::_('form.token'); ?>
</form>
<script src="<?php echo JURI::root();?>components/com_rtlogoshowcase/assets/js/imagesloaded.pkgd.min.js" type="text/javascript"></script>
<script src="<?php echo JURI::root();?>components/com_rtlogoshowcase/assets/js/isotope.pkgd.min.js" type="text/javascript"></script>
<script src="<?php echo JURI::root();?>components/com_rtlogoshowcase/assets/js/jquery.actual.min.js" type="text/javascript"></script>
<script src="<?php echo JURI::root();?>components/com_rtlogoshowcase/assets/js/rtlogoshowcase.js" type="text/javascript"></script>
