<?php
/**
 * @version    2.0
 * @package    com_Tlpportfolio
 * @author     TechLabPro <info@techlabpro.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user       = JFactory::getUser();
$userId     = $user->get('id');
$listOrder  = $this->state->get('list.ordering');
$listDirn   = $this->state->get('list.direction');
$canCreate  = $user->authorise('core.create', 'com_tlpportfolio');
$canEdit    = $user->authorise('core.edit', 'com_tlpportfolio');
$canCheckin = $user->authorise('core.manage', 'com_tlpportfolio');
$canChange  = $user->authorise('core.edit.state', 'com_tlpportfolio');
$canDelete  = $user->authorise('core.delete', 'com_tlpportfolio');

$app = JFactory::getApplication();
$tlpportfolio_params                = JComponentHelper::getParams('com_tlpportfolio');
$image_storiage_path                = $tlpportfolio_params->get('image_path','images/tlpportfolio');
$link_detail                        = $tlpportfolio_params->get('link_detail','1');
$bootstrap_version                  = $tlpportfolio_params->get('bootstrap_version','1');
$enable_social_share                = $tlpportfolio_params->get('enable_social_share','1');
$link_type                          = $tlpportfolio_params->get('link_type','2');
$image_grid                         = $tlpportfolio_params->get('image_grid','10');
$create_date_format                 = $tlpportfolio_params->get('create_date_format','m-d-Y');
$short_desc_limit                   = $tlpportfolio_params->get('short_desc_limit','150');
$g_layout                           = $tlpportfolio_params->get('g_layout','layout1');
$g_display_no                       = $tlpportfolio_params->get('g_display_no','');
$g_display_no_tab                   = $tlpportfolio_params->get('g_display_no_tab','');
$g_display_no_mob                   = $tlpportfolio_params->get('g_display_no_mob','');
$g_grid_type                        = $tlpportfolio_params->get('g_grid_type','1');
$g_item_to_item_margin              = $tlpportfolio_params->get('g_item_to_item_margin','');
$g_gutter                           = $tlpportfolio_params->get('g_gutter');
$g_image_style                      = $tlpportfolio_params->get('g_image_style');
$g_primary_color                    = $tlpportfolio_params->get('g_primary_color');
$g_overlay_color                    = $tlpportfolio_params->get('g_overlay_color');
$g_overlay_opacity                  = $tlpportfolio_params->get('g_overlay_opacity');
$g_project_name_font_size           = $tlpportfolio_params->get('g_project_name_font_size');
$g_project_name_font_color          = $tlpportfolio_params->get('g_project_name_font_color');
$g_project_name_font_color_hover    = $tlpportfolio_params->get('g_project_name_font_color_hover');
$g_project_name_text_align          = $tlpportfolio_params->get('g_project_name_text_align');
$g_short_desc_font_size             = $tlpportfolio_params->get('g_short_desc_font_size');
$g_short_desc_font_color            = $tlpportfolio_params->get('g_short_desc_font_color');
$g_short_desc_text_align            = $tlpportfolio_params->get('g_short_desc_text_align');
$g_icon_font_size                   = $tlpportfolio_params->get('g_icon_font_size');
$g_icon_font_color                  = $tlpportfolio_params->get('g_icon_font_color');
//field control
$g_project_name_field               = $tlpportfolio_params->get('g_project_name_field','1');
$g_short_desc_field                 = $tlpportfolio_params->get('g_short_desc_field','1');
$g_tools_field                      = $tlpportfolio_params->get('g_tools_field','1');
$g_category_field                   = $tlpportfolio_params->get('g_category_field','1');
$g_client_field                     = $tlpportfolio_params->get('g_client_field','');
$g_project_url_field                = $tlpportfolio_params->get('g_project_url_field','1');
$g_btn_bg                           = $tlpportfolio_params->get('g_btn_bg','');
$g_btn_text_color                   = $tlpportfolio_params->get('g_btn_text_color','');
$g_btn_bg_hover                     = $tlpportfolio_params->get('g_btn_bg_hover');

// get the menu parameters for use
// $input = JFactory::getApplication()->input;
// $menuitemid = $input->getInt( 'Itemid' );
// @$menu = JSite::getMenu();
$app = JFactory::getApplication();
$menu = $app->getMenu();
$active = $menu->getActive();
$itemId = $active->id;
$menuparams                         = $menu->getParams($itemId);
$m_display_no                       = $menuparams->get("m_display_no");
$m_display_no_tab                   = $menuparams->get("m_display_no_tab");
$m_display_no_mob                   = $menuparams->get("m_display_no_mob");
$m_layout                           = $menuparams->get("m_layout");
$m_grid_type                        = $menuparams->get('m_grid_type');
$m_item_to_item_margin              = $menuparams->get('m_item_to_item_margin');
$m_gutter                           = $menuparams->get('m_gutter');
$m_image_style                      = $menuparams->get('m_image_style');
$m_primary_color                    = $menuparams->get('m_primary_color');
$m_overlay_color                    = $menuparams->get('m_overlay_color');
$m_overlay_opacity                  = $menuparams->get('m_overlay_opacity');
$m_project_name_font_size           = $menuparams->get('m_project_name_font_size');
$m_project_name_font_color          = $menuparams->get('m_project_name_font_color');
$m_project_name_font_color_hover    = $menuparams->get('m_project_name_font_color_hover');
$m_project_name_text_align          = $menuparams->get('m_project_name_text_align');
$m_short_desc_font_size             = $menuparams->get('m_short_desc_font_size');
$m_short_desc_font_color            = $menuparams->get('m_short_desc_font_color');
$m_short_desc_text_align            = $menuparams->get('m_short_desc_text_align');
$m_icon_font_size                   = $menuparams->get('m_icon_font_size');
$m_icon_font_color                  = $menuparams->get('m_icon_font_color');
$m_project_name_field               = $menuparams->get('m_project_name_field');
$m_short_desc_field                 = $menuparams->get('m_short_desc_field');
$m_tools_field                      = $menuparams->get('m_tools_field');
$m_category_field                   = $menuparams->get('m_category_field');
$m_client_field                     = $menuparams->get('m_client_field');
$m_project_url_field                = $menuparams->get('m_project_url_field');
$category_id                        = $menuparams->get('category');
$m_btn_bg                           = $menuparams->get('m_btn_bg');
$m_btn_text_color                   = $menuparams->get('m_btn_text_color');
$m_btn_bg_hover                     = $menuparams->get('m_btn_bg_hover');
@$layout2_image_area                = $menuparams->get('m_layout2_image_area','');
@$m_hide_showall                    = $menuparams->get('m_hide_showall','');
@$m_selected_category               = $menuparams->get('m_selected_category','');
$m_link_detail                      = $menuparams->get('m_link_detail','');
$m_link_type                        = $menuparams->get('m_link_type','');
$m_hide_count                       = $menuparams->get('m_hide_count','');


if($m_grid_type!=''){
   $grid_type=$m_grid_type;
}else{
   $grid_type=$g_grid_type;
}
if($m_item_to_item_margin!=''){
   $item_to_item_margin=$m_item_to_item_margin;
}else{
   $item_to_item_margin=$g_item_to_item_margin;
}
if($m_image_style!=''){
   $image_style=$m_image_style;
}else{
   $image_style=$g_image_style;
}
if($m_primary_color!=''){
   $primary_color=$m_primary_color;
}else{
   $primary_color=$g_primary_color;
}
if($m_overlay_color!=''){
   $overlay_color=$m_overlay_color;
}else{
   $overlay_color=$g_overlay_color;
}
if($m_overlay_opacity!=''){
   $overlay_opacity=$m_overlay_opacity;
}else{
   $overlay_opacity=$g_overlay_opacity;
}
if($m_project_name_font_size!=''){
   $project_name_font_size=$m_project_name_font_size;
}else{
   $project_name_font_size=$g_project_name_font_size;
}
if($m_project_name_font_color!=''){
   $project_name_font_color=$m_project_name_font_color;
}else{
   $project_name_font_color=$g_project_name_font_color;
}
if($m_project_name_font_color_hover!=''){
   $project_name_font_color_hover=$m_project_name_font_color_hover;
}else{
   $project_name_font_color_hover=$g_project_name_font_color_hover;
}
if($m_project_name_text_align!=''){
   $project_name_text_align=$m_project_name_text_align;
}else{
   $project_name_text_align=$g_project_name_text_align;
}
if($m_short_desc_font_size!=''){
   $short_desc_font_size=$m_short_desc_font_size;
}else{
   $short_desc_font_size=$g_short_desc_font_size;
}
if($m_short_desc_font_color!=''){
   $short_desc_font_color=$m_short_desc_font_color;
}else{
   $short_desc_font_color=$g_short_desc_font_color;
}
if($m_short_desc_text_align!=''){
   $short_desc_text_align=$m_short_desc_text_align;
}else{
   $short_desc_text_align=$g_short_desc_text_align;
}
if($m_icon_font_size!=''){
   $icon_font_size=$m_icon_font_size;
}else{
   $icon_font_size=$g_icon_font_size;
}
if($m_icon_font_color!=''){
   $icon_font_color=$m_icon_font_color;
}else{
   $icon_font_color=$g_icon_font_color;
}
if($m_project_name_field!=''){
   $project_name_field=$m_project_name_field ;
}else{
   $project_name_field=$g_project_name_field;
}
if($m_short_desc_field!=''){
   $short_desc_field=$m_short_desc_field;
}else{
   $short_desc_field=$g_short_desc_field;
}
if($m_tools_field!=''){
   $tools_field=$m_tools_field;
}else{
   $tools_field=$g_tools_field;
}
if($m_category_field!=''){
   $category_field=$m_category_field;
}else{
   $category_field=$g_category_field;
}
if($m_client_field!=''){
   $client_field=$m_client_field;
}else{
   $client_field=$g_client_field;
}
if($m_project_url_field!=''){
   $project_url_field=$m_project_url_field;
}else{
   $project_url_field=$g_project_url_field;
}
if($m_layout!=''){ 
   $layout=$m_layout;
}else{
   $layout=$g_layout;
}
if($m_btn_bg!=''){
  $btn_bg=$m_btn_bg;
}else{
  $btn_bg=$g_btn_bg;
}
if($m_btn_bg_hover!=''){
  $btn_bg_hover=$m_btn_bg_hover;
}else{
  $btn_bg_hover=$g_btn_bg_hover;
}
if($m_btn_text_color!=''){
  $btn_text_color=$m_btn_text_color;
}else{
  $btn_text_color=$g_btn_text_color;
}
if($m_display_no!=''){
  $display_no=$m_display_no; 
  $md_grid=(12/$m_display_no);
}else{
  $display_no=$g_display_no; 
  $md_grid=(12/$g_display_no);
}

if ($m_display_no_tab != '' ) {
  $sm_grid = ( 12 / $m_display_no_tab );
} else {
  $sm_grid = ( 12 / $g_display_no_tab );
}
if ( $m_display_no_mob != '' ) {
  $xs_grid = ( 12 / $m_display_no_mob );
} else {
  $xs_grid = ( 12 / $g_display_no_mob );
}

if($m_gutter !='') {
  $gutter = $m_gutter;
}else {
  $gutter = $g_gutter;
}

if($item_to_item_margin!=1){
  $item_to_item_margin = ' allmargin0';
}else{
  $item_to_item_margin = '';
}
if($m_link_type!=''){
  $link_type = $m_link_type;
}else {
  $link_type = $link_type;
}
$bss = "tlp-col-md-".$md_grid." tlp-col-lg-".$md_grid." tlp-col-sm-". $sm_grid. " tlp-col-xs-".$xs_grid;


@$layout2_content_area = (12-$layout2_image_area);
$image_area = "tlp-col-md-".$layout2_image_area." tlp-col-lg-".$layout2_image_area." tlp-col-sm-6 tlp-col-xs-6";
$content_area = "tlp-col-md-".$layout2_content_area." tlp-col-lg-".$layout2_content_area." tlp-col-sm-6 tlp-col-xs-6";

if($overlay_color){
	$hex = str_replace("#", "", $overlay_color);
   if(strlen($hex) == 3) {
      $r = hexdec($hex[0].$hex[0]);
      $g = hexdec($hex[1].$hex[1]);
      $b = hexdec($hex[2].$hex[2]);
   } else {
      $r = hexdec($hex[0].$hex[1]);
      $g = hexdec($hex[2].$hex[3]);
      $b = hexdec($hex[4].$hex[5]);
	}
}

$document = JFactory::getDocument();
$style ='';

$style .= '.tlp-popup-wrap .tlp-popup-navigation-wrap { background:' .$primary_color.';}';
$style .= '.tlp-portfolio button:hover { background: '. $primary_color.'}';
$style .= '.tlp-portfolio button.selected { background: '. $primary_color.'}';
$style .= '.tlp-portfolio .button-group button { background:'.$btn_bg.' !important; color:'.$btn_text_color.';}';
$style .= '.tlp-portfolio .button-group button:hover, .tlp-portfolio .button-group button.selected { background:'.$btn_bg_hover.'!important;}';
if($gutter){
  $style .= '.tlp-portfolio .tlp-equal-height { margin-bottom: 0px;}';
  $style .= '.tlp-portfolio [class*=tlp-col-] { padding-left : '.$gutter.'px; padding-right : '.$gutter.'px; margin-bottom : '.($gutter*2).'px; }';
  $style .= '.tlp-row { margin-left : -'.$gutter.'px!important; margin-right : -'.$gutter.'px!important;}';
  
}

if($layout=='layout1'){
$style .='.tlp-portfolio .layout1 .tlp-portfolio-item { background:'.$primary_color.';}';
$style .='.tlp-portfolio .layout1 .tlp-content h3,.tlp-portfolio .layout1 .tlp-content h3 a { font-size: '. $project_name_font_size .'px; color: '. $project_name_font_color.'; text-align: '.$project_name_text_align.';}';$style .='.tlp-portfolio .layout1 .tlp-content h3 a:hover { color: '. $project_name_font_color_hover.';}';
$style .= '.tlp-portfolio .layout1 .tlp-content p { font-size: '.$short_desc_font_size .'px; color:'. $short_desc_font_color.';  text-align: '. $short_desc_text_align .';}';
if($overlay_color){
$style .= '.tlp-portfolio .layout1 .tlp-portfolio-item .tlp-overlay { background-color: rgba('. $r.','. $g.','.$b .','.$overlay_opacity.');}';
}
$style .= '.tlp-portfolio .layout1 .tlp-overlay .link-icon li, .tlp-portfolio .layout1 .tlp-overlay .link-icon li a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}

if($layout=='layout2'){ 
$style .= '.tlp-portfolio .layout2 .tlp-content h3,.tlp-portfolio .layout2 .tlp-content h3 a { font-size:'. $project_name_font_size. 'px; color: '. $project_name_font_color.'; text-align:'. $project_name_text_align .';}';
$style .= '.tlp-portfolio .layout2 .tlp-content h3 a:hover { color: '. $project_name_font_color_hover.'; }';
if($overlay_color){
$style .= '.tlp-portfolio .layout2 .tlp-overlay { background-color: rgba('.$r.', '.$g.', '.$b .','. $overlay_opacity.');}';
}
if($icon_font_color){
$style .= '.tlp-portfolio .layout2 .tlp-overlay .link-icon li,.tlp-portfolio .layout2 .tlp-overlay .link-icon li a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
$style .= '.tlp-portfolio .layout2 .tlp-content .read-more a { border: 1px solid '. $primary_color.'; color:'. $primary_color.'; }';
}

if($layout=='layout3'){
$style .= '.tlp-portfolio .layout3 .tlp-content h3,.tlp-portfolio .layout3 .tlp-content h3 a { font-size:'. $project_name_font_size .'px; color:'. $project_name_font_color.'; text-align:'. $project_name_text_align.';}';
$style .= '.tlp-portfolio .layout3 .tlp-content h3 a:hover { color:'. $project_name_font_color_hover.';}';
$style .= '.tlp-portfolio .layout3 .tlp-content p { font-size:'. $short_desc_font_size .'px; color:'. $short_desc_font_color.'; text-align:'.$short_desc_text_align.';}';
if($overlay_color){
$style .= '.tlp-portfolio .layout3 .tlp-portfolio-item .tlp-overlay { background-color: rgba('. $r.','. $g.','.$b.', '. $overlay_opacity.');}';
}
if($icon_font_color){
$style .= '.tlp-portfolio .layout3 .tlp-overlay .link-icon li,.tlp-portfolio .layout3 .tlp-overlay .link-icon li a  { ffont-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
}

if($layout=='layout4'){ 
if($overlay_color){
$style .= '.tlp-portfolio .layout4 .image-container .tlp-overlay { background-color: rgba('. $r.','.$g .','.$b.','.$overlay_opacity.');}';
}
$style .= '.tlp-portfolio .layout4 .image-container .tlp-overlay p { font-size: '.$short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.';}';
$style .= '.tlp-portfolio .layout4 .tlp-portfolio-item .tlp-info h3, .tlp-portfolio .layout4 .tlp-portfolio-item .tlp-info h3 a{font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.';}';
$style .= '.tlp-portfolio .layout4 .tlp-portfolio-item .tlp-info h3 a:hover { color: '. $project_name_font_color.';}';
$style .= '.tlp-portfolio .layout4 .image-container .tlp-overlay .tlp-title h3,.tlp-portfolio .layout4 .image-container .tlp-overlay .tlp-title h3 a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; }';
$style .= '.tlp-portfolio .layout4 .image-container .tlp-overlay .tlp-title h3 a:hover { color: '. $project_name_font_color_hover.'; }';
}

if($layout=='layout5'){
$style .= '.tlp-portfolio .layout5 .tlp-overlay h3,.tlp-portfolio .layout5 .tlp-overlay h3 a {font-size: '. $project_name_font_size .'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.'}';
$style .= '.tlp-portfolio .layout5 .tlp-overlay h3 a:hover { color: '. $project_name_font_color_hover.';}';
if($overlay_color){
$style .= '.tlp-portfolio .layout5 .tlp-overlay { background-color: rgba('. $r.','. $g.','. $b.','. $overlay_opacity.');}';
$style .= '.tlp-portfolio .layout5 .tlp-overlay .tlp-title { background-color: rgba('. $r.', '. $g.','. $b.','. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .layout5 .tlp-overlay p.description { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.';}';
if($icon_font_color){
$style .= '.tlp-portfolio .layout5 .tlp-overlay p.link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
}

if($layout=='layout6'){
if($overlay_color){
$style .= '.tlp-portfolio .layout6 .tlp-portfolio-thum:hover .tlp-content { background-color: rgba('. $r.','. $g.','. $b.','. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .layout6 .tlp-portfolio-thum h3, .tlp-portfolio .layout6 .tlp-portfolio-thum h3 a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.'}';
$style .= '.tlp-portfolio .layout6 .tlp-portfolio-thum h3 a:hover { color: '. $project_name_font_color_hover.';}';
$style .= '.tlp-portfolio .layout6 .tlp-portfolio-thum .tlp-content p{text-align: '. $project_name_text_align.';}';
$style .= '.tlp-portfolio .layout6 .tlp-portfolio-thum { background: '. $primary_color.'}';
$style .= '.tlp-portfolio .layout6 .tlp-portfolio-thum p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.'}';
if($icon_font_color){
$style .= '.tlp-portfolio .layout6 .tlp-overlay .link-icon li a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
}

if($layout=='layout7'){ 
$style .= '.tlp-portfolio .layout7 .tlp-portfolio-thum h3, .tlp-portfolio .layout7 .tlp-portfolio-thum h3 a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.';}';
$style .= '.tlp-portfolio .layout7 .tlp-portfolio-thum h3 a:hover { color: '. $project_name_font_color_hover.';}';
$style .= '.tlp-portfolio .layout7 .tlp-portfolio-thum p { background: '. $primary_color.'; font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.'}';

$style .= '.tlp-portfolio .layout7 .tlp-portfolio-thum:hover .tlp-overlay { background-color: rgba('. $r.', '.$g.', '. $b.', '. $overlay_opacity.'); font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.';  text-align: '. $short_desc_text_align.'}';
if($icon_font_color){
$style .= '.tlp-portfolio .layout7 .tlp-portfolio-thum .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
}

if($layout=='layout8'){ 
$style .= '.tlp-portfolio .layout8 .tlp-portfolio-thum h3, .tlp-portfolio .layout8 .tlp-portfolio-thum h3 a { font-size: '. $project_name_font_size .'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.'}';
$style .= '.tlp-portfolio .layout8 .tlp-portfolio-thum h3 a:hover { color: '. $project_name_font_color_hover.';}';
if($overlay_color){
$style .= '.tlp-portfolio .layout8 .tlp-portfolio-thum:hover .tlp-overlay { background-color: rgba('. $r.','. $g.', '. $b.', '. $overlay_opacity.');}';
}
if($icon_font_color){
$style .= '.tlp-portfolio .layout8 .tlp-portfolio-thum .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
$style .= '.tlp-portfolio .layout8 .tlp-portfolio-thum p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.'}';
}

if($layout=='layout9'){ 
$style .= '.tlp-portfolio .layout9 .tlp-portfolio-item h3, .tlp-portfolio .layout9 .tlp-portfolio-item h3 a { font-size: '. $project_name_font_size .'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.'}';
$style .= '.tlp-portfolio .layout9 .tlp-portfolio-item h3 a:hover { color: '. $project_name_font_color_hover.';}';
if($overlay_color){
$style .= '.tlp-portfolio .layout9 figcaption:hover { background-color: rgba('. $r.','. $g.', '. $b.', '. $overlay_opacity.');}';
}
if($icon_font_color){
$style .= '.tlp-portfolio .layout9 .tlp-portfolio-item .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
$style .= '.tlp-portfolio .layout9 .tlp-portfolio-item p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.'}';
}
if($layout=='layout10'){ 
$style .= '.tlp-portfolio .layout10 .tlp-overlay h3, .tlp-portfolio .layout10 .tlp-overlay h3 a { font-size: '. $project_name_font_size .'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.'}';
$style .= '.tlp-portfolio .layout10 .tlp-overlay h3 a:hover { color: '. $project_name_font_color_hover.';}';
if($overlay_color){
$style .= '.tlp-portfolio .layout10 .tlp-overlay .tlp-title { background-color: rgba('. $r.','. $g.', '. $b.', '. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .layout10 .tlp-portfolio-item .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
$style .= '.tlp-portfolio .layout10 .tlp-portfolio-item p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.'}';
}
if($layout=='layout11'){ 
$style .= '.tlp-portfolio .layout11 .tlp-overlay h3, .tlp-portfolio .layout11 .tlp-overlay h3 a { font-size: '. $project_name_font_size .'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.'}';
$style .= '.tlp-portfolio .layout11 .tlp-overlay h3 a:hover { color: '. $project_name_font_color_hover.'; }';
if($overlay_color){
$style .= '.tlp-portfolio .layout11 .tlp-overlay { background-color: rgba('. $r.','. $g.', '. $b.', '. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .layout11 .tlp-portfolio-item .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
$style .= '.tlp-portfolio .layout11 .tlp-portfolio-item p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.'}';
}
if($layout=='layout12'){ 
$style .= '.tlp-portfolio .layout12 .tlp-overlay h3, .tlp-portfolio .layout12 .tlp-overlay h3 a { font-size: '. $project_name_font_size .'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.'}';
$style .= '.tlp-portfolio .layout12 .tlp-overlay h3 a:hover { color: '. $project_name_font_color_hover.';}';
if($overlay_color){
$style .= '.tlp-portfolio .layout12 .tlp-overlay { background-color: rgba('. $r.','. $g.', '. $b.', '. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .layout12 .tlp-portfolio-item .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
$style .= '.tlp-portfolio .layout12 .tlp-portfolio-item p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.'}';
}
if($layout=='isotope1'){ 
$style .= '.tlp-portfolio .isotope1 .tlp-item-bg { background: '. $primary_color.'}';
$style .= '.tlp-portfolio .isotope1 .tlp-content h3, .tlp-portfolio .isotope1 .tlp-content h3 a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.'}';
$style .= '.tlp-portfolio .isotope1 .tlp-content h3 a:hover { color: '. $project_name_font_color_hover.'; }';
$style .= '.tlp-portfolio .isotope1 .tlp-content p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.'}';
if($overlay_color){
$style .= '.tlp-portfolio .isotope1 .tlp-portfolio-item .tlp-overlay { background-color: rgba('. $r.', '. $g.', '. $b.', '. $overlay_opacity.');}';
}
if($icon_font_color){
$style .= '.tlp-portfolio .isotope1 .tlp-overlay .link-icon li, .tlp-portfolio .isotope1 .tlp-overlay .link-icon li a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
}

if($layout=='isotope2'){ 
if($overlay_color){
$style .= '.tlp-portfolio .isotope2 .image-container .tlp-overlay { background-color: rgba('. $r.', '. $g.', '. $b.', '. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .isotope2 .image-container .tlp-overlay p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.'}';
$style .= '.tlp-portfolio .isotope2 .tlp-portfolio-item .tlp-info h3, .tlp-portfolio .isotope2 .tlp-portfolio-item .tlp-info h3 a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.'}';
$style .= '.tlp-portfolio .isotope2 .image-container .tlp-overlay .tlp-title h3, .tlp-portfolio .isotope2 .image-container .tlp-overlay .tlp-title h3 a { font-size: '. $project_name_font_size .'px; color: '. $project_name_font_color.'; }';
if($icon_font_color){
$style .= '.tlp-portfolio .isotope2 .tlp-overlay .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
}

if($layout=='isotope3'){ 
$style .= '.tlp-portfolio .isotope3 .tlp-overlay .tlp-title { background: '. $primary_color.'}';
$style .= '.tlp-portfolio .isotope3 .tlp-overlay h3,.tlp-portfolio .isotope3 .tlp-overlay h3 a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.'}';
$style .= '.tlp-portfolio .isotope3 .tlp-overlay h3 a:hover { color: '. $project_name_font_color_hover.'; }';
if($overlay_color){
$style .= '.tlp-portfolio .isotope3 .tlp-overlay { background-color: rgba('. $r.', '. $g.', '. $b.', '. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .isotope3 .tlp-overlay p.description { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.'}';
if($icon_font_color){
$style .= '.tlp-portfolio .isotope3 .tlp-overlay p.link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
}

if($layout=='isotope4'){
if($overlay_color){
$style .= '.tlp-portfolio .isotope4 .tlp-portfolio-thum:hover .tlp-content { background-color: rgba('. $r.', '. $g.', '. $b.', '. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .isotope4 .tlp-portfolio-thum .tlp-content p { text-align: '. $project_name_text_align.';}';
$style .= '.tlp-portfolio .isotope4 .tlp-portfolio-thum h3 ,.tlp-portfolio .isotope4 .tlp-portfolio-thum h3 a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.';}';
$style .= '.tlp-portfolio .isotope4 .tlp-portfolio-thum h3 a:hover { color: '. $project_name_font_color_hover.';}';
$style .= '.tlp-portfolio .isotope4 .tlp-portfolio-thum { background: '. $primary_color.'}';
$style .= '.tlp-portfolio .isotope4 .tlp-portfolio-thum p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.';}';
if($icon_font_color){
$style .= '.tlp-portfolio .isotope4 .tlp-overlay .link-icon li a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
}

if($layout=='isotope5'){ 
$style .= '.tlp-portfolio .isotope5 .tlp-portfolio-thum h3, .tlp-portfolio .isotope5 .tlp-portfolio-thum h3 a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.';}';
$style .= '.tlp-portfolio .isotope5 .tlp-portfolio-thum h3 a:hover { color: '. $project_name_font_color_hover.';}';
$style .= '.tlp-portfolio .isotope5 .tlp-portfolio-thum p { background: '. $primary_color.'; font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.'}';
$style .= '.tlp-portfolio .isotope5 .tlp-portfolio-thum:hover .tlp-overlay { background-color: rgba('. $r.', '. $g.', '. $b.', '. $overlay_opacity.'); font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.';  text-align: '. $short_desc_text_align.';}';
if($icon_font_color){
$style .= '.tlp-portfolio .isotope5 .tlp-portfolio-thum .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
}
}

if($layout=='isotope6'){ 
$style .= '.tlp-portfolio .isotope6 .tlp-portfolio-thum h3, .tlp-portfolio .isotope6 .tlp-portfolio-thum h3 a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.';}';
$style .= '.tlp-portfolio .isotope6 .tlp-portfolio-thum h3 a:hover { color: '. $project_name_font_color_hover.';}';
if($overlay_color){
$style .= '.tlp-portfolio .isotope6 .tlp-portfolio-thum:hover .tlp-overlay { background-color: rgba('. $r.', '. $g.', '. $b.', '. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .isotope6 .tlp-portfolio-thum .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';

$style .= '.tlp-portfolio .isotope6 .tlp-portfolio-thum p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.';}';
}
if($layout=='isotope7'){
$style .= '.tlp-portfolio .isotope7 .tlp-portfolio-item:hover h3, .tlp-portfolio .isotope7 .tlp-portfolio-item:hover h3 a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.';}';
$style .= '.tlp-portfolio .isotope7 .tlp-portfolio-item:hover h3 a:hover { color: '. $project_name_font_color_hover.';}';
if($overlay_color){
$style .= '.tlp-portfolio .isotope7 figcaption:hover { background-color: rgba('. $r.', '. $g.', '. $b.', '. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .isotope7 .tlp-portfolio-thum .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
$style .= '.tlp-portfolio .isotope7 .tlp-portfolio-thum p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.';}';
}
if($layout=='isotope8'){
$style .= '.tlp-portfolio .isotope8 .tlp-overlay h3, .tlp-portfolio .isotope8 .tlp-overlay h3 a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.';}';
$style .= '.tlp-portfolio .isotope8 .tlp-overlay h3 a:hover { color: '. $project_name_font_color_hover.';}';
if($overlay_color){
$style .= '.tlp-portfolio .isotope8 .tlp-overlay .tlp-title { background-color: rgba('. $r.', '. $g.', '. $b.', '. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .isotope8 .tlp-overlay .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
$style .= '.tlp-portfolio .isotope8 .tlp-overlay p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.';}';
}
if($layout=='isotope9'){
$style .= '.tlp-portfolio .isotope9 .tlp-portfolio-item h3 , .tlp-portfolio .isotope9 .tlp-portfolio-item h3  a { font-size: '. $project_name_font_size.'px; color: '. $project_name_font_color.'; text-align: '. $project_name_text_align.';}';
$style .= '.tlp-portfolio .isotope9 .tlp-portfolio-item h3 a:hover { color: '. $project_name_font_color_hover.';}';
if($overlay_color){
$style .= '.tlp-portfolio .isotope9 .tlp-overlay { background-color: rgba('. $r.', '. $g.', '. $b.', '. $overlay_opacity.');}';
}
$style .= '.tlp-portfolio .isotope9 .tlp-portfolio-item .link-icon a { font-size: '. $icon_font_size .'px; color: '. $icon_font_color.'; border: 1px solid '.$icon_font_color.';}';
$style .= '.tlp-portfolio .isotope9 .tlp-overlay .item-info p { font-size: '. $short_desc_font_size.'px; color: '. $short_desc_font_color.'; text-align: '. $short_desc_text_align.';}';
}

$document->addStyleDeclaration( $style );

$mIsoLayout = " even-grid ";
$ItemClass = ' tlp-equal-height';

if ($grid_type == 2) {
	$mIsoLayout = " masonry-grid ";
	$ItemClass = ' masonry-item ';
}

$this->tlpconfig= array(
		'image_storiage_path' => $image_storiage_path,
		'bss' =>$bss,
		'display_no' =>$display_no,
		'link_detail' => $link_detail,
		'link_type' =>$link_type,
		'bootstrap_version'=>$bootstrap_version,
		'project_name_field'=>$project_name_field,
		'short_desc_field'=>$short_desc_field,
		'tools_field'=>$tools_field,
		'category_field'=>$category_field,
		'client_field'=>$client_field,
		'project_url_field'=>$project_url_field,
		'create_date_format'=>$create_date_format,
		'item_to_item_margin'=>$item_to_item_margin,
		'short_desc_limit'=>$short_desc_limit,
		'ItemClass' => $ItemClass,
    'category_id' => $category_id,
    'image_area' => $image_area,
    'content_area' => $content_area,
    'hide_all_btn' => $m_hide_showall,
    'selected_category' => $m_selected_category,
    'hide_count' => $m_hide_count
	);


if(($layout=='isotope1')||($layout=='isotope2')||($layout=='isotope3')||($layout=='isotope4')||($layout=='isotope5')||($layout=='isotope6')||($layout=='isotope7')||($layout=='isotope8')||($layout=='isotope9')||($layout=='isotope10')){ ?>
<div class="container-fluid">
	<div class="tlp-row tlp-portfolio">
		<div class="tlp-portfolio-isotope <?php echo $layout.$mIsoLayout;?>">
		<?php

			echo $this->loadTemplate($layout);
		?>
		</div>
	</div>
</div>

<?php }else{?>
<form action="<?php echo JRoute::_('index.php?option=com_tlpportfolio&view=portfolios'); ?>" method="post" name="adminForm" id="adminForm">
<div class="container-fluid">
<div class="tlp-row tlp-portfolio">

	<div class="tlp-layout <?php echo $layout . $mIsoLayout;?>">

		<?php
		$itemIdsHtml = null;
		foreach ($this->items as $i => $item) :
			$itemIdsHtml .="<span>{$item->id}</span>";
			?>

			<div class="<?php echo $bss.$ItemClass.$item_to_item_margin;?> ">
				<?php
					$this->item = & $item;

					echo $this->loadTemplate($layout);
				?>
			</div>
		<?php endforeach; ?>
	</div>
</div>
</div>
<div class="container-fluid">
<div class="tlp-row">
	<?php echo $this->pagination->getListFooter(); ?>
</div>
</div>
</form>
<?php }?>
<?php
   $allitems=TlpportfolioFrontendHelper::getAllitemsCount($category_id);
      $itemIdsHtml = null;
      foreach($allitems as $mc){
        $itemIdsHtml .="<span>{$mc->id}</span>";
      }
        if(count($allitems) > 0){
          $html = null;
            $html .= "<span id='tlp-port-item-count'>";
              $html .=  $itemIdsHtml;
            $html .=  "</span>";
          echo $html;
        }
?>


<script src="<?php echo JURI::root();?>components/com_tlpportfolio/assets/js/imagesloaded.pkgd.min.js" type="text/javascript"></script>
<script src="<?php echo JURI::root();?>components/com_tlpportfolio/assets/js/isotope.pkgd.min.js" type="text/javascript"></script>
<script src="<?php echo JURI::root();?>components/com_tlpportfolio/assets/owlcarousel/owl.carousel.min.js" type="text/javascript"></script>
<script src="<?php echo JURI::root();?>components/com_tlpportfolio/assets/js/tlp-portfolio.js?v=3" type="text/javascript"></script>
