<?php
/**
 * @version    1.1
 * @package    Com_Tlptestimonial
 * @author     RadiusTheme <support@radiustheme.com>
 * @copyright  Copyright (C) 2017. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

$canEdit = JFactory::getUser()->authorise('core.edit', 'com_tlptestimonial');

if (!$canEdit && JFactory::getUser()->authorise('core.edit.own', 'com_tlptestimonial'))
{
	$canEdit = JFactory::getUser()->id == $this->item->created_by;
}
$app                     = JFactory::getApplication();
$tlptestimonial_params   = JComponentHelper::getParams( 'com_tlptestimonial' );
$image_storiage_path     = $tlptestimonial_params->get( 'image_path', 'images/tlptestimonial' );
$image_grid_width     	 = $tlptestimonial_params->get( 'image_grid' );
$content_grid_width		 = (12-$image_grid_width);

$image_grid = "rt-col-lg-" . $image_grid_width . " rt-col-md-" . $image_grid_width . " rt-col-sm-" . $image_grid_width . " rt-col-xs-12" ;
$content_grid = "rt-col-lg-" . $content_grid_width . " rt-col-md-" . $content_grid_width . " rt-col-sm-" . $content_grid_width . " rt-col-xs-12" ;

$html ='';
$html .='<div class="rt-container-fluid">';
	$html .='<div class="rt-row">';
		$html .='<div class="'.$image_grid.'">';
			$html .='<img class="rt-responsive-img" src="'.JURI::root().$image_storiage_path.'/'.'l_'.$this->item->profile_image.'" alt="'.$this->item->name.'">';
		$html .='</div>';
		$html .='<div class="'.$content_grid.'">';
			$html .='<h3>'.$this->item->name.'<h3>';
			$itemArray = array();
			if(!empty($this->item->designation)){
				$itemArray[]=$this->item->designation;
			}
			if(!empty($this->item->company)){
				$itemArray[]=$this->item->company;
			}
			if(!empty($this->item->location)){
				$itemArray[]=$this->item->location;
			}

			//$array = array($this->item->designation, $this->item->company, $this->item->location);
			$designation = implode(", ", $itemArray);
			
			$html .= '<h4 class="author-bio">'.$designation.'</h4>';

			$html .=nl2br($this->item->testimonial);
		$html .='</div>';

	$html .='</div>';
$html .='</div>';

echo $html;
?>

<?php if($canEdit && $this->item->checked_out == 0): ?>

	<a class="btn" href="<?php echo JRoute::_('index.php?option=com_tlptestimonial&task=testimonial.edit&id='.$this->item->id); ?>"><?php echo JText::_("COM_TLPTESTIMONIAL_EDIT_ITEM"); ?></a>

<?php endif; ?>

<?php if (JFactory::getUser()->authorise('core.delete','com_tlptestimonial.testimonial.'.$this->item->id)) : ?>

	<a class="btn btn-danger" href="#deleteModal" role="button" data-toggle="modal">
		<?php echo JText::_("COM_TLPTESTIMONIAL_DELETE_ITEM"); ?>
	</a>

	<div id="deleteModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="deleteModal" aria-hidden="true">
		<div class="modal-header">
			<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
			<h3><?php echo JText::_('COM_TLPTESTIMONIAL_DELETE_ITEM'); ?></h3>
		</div>
		<div class="modal-body">
			<p><?php echo JText::sprintf('COM_TLPTESTIMONIAL_DELETE_CONFIRM', $this->item->id); ?></p>
		</div>
		<div class="modal-footer">
			<button class="btn" data-dismiss="modal">Close</button>
			<a href="<?php echo JRoute::_('index.php?option=com_tlptestimonial&task=testimonial.remove&id=' . $this->item->id, false, 2); ?>" class="btn btn-danger">
				<?php echo JText::_('COM_TLPTESTIMONIAL_DELETE_ITEM'); ?>
			</a>
		</div>
	</div>

<?php endif; ?>