<?php
/**
 * @version    1.0
 * @package    Com_Tlptestimonial
 * @author     RadiusTheme <support@radiustheme.com>
 * @copyright  Copyright (C) 2017. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

JHtml::_('behavior.keepalive');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');

// Load admin language file
$lang = JFactory::getLanguage();
$lang->load('com_tlptestimonial', JPATH_SITE);
$doc = JFactory::getDocument();
$doc->addScript(JUri::base() . '/media/com_tlptestimonial/js/form.js');

$user    = JFactory::getUser();
$canEdit = TlptestimonialHelpersTlptestimonial::canUserEdit($this->item, $user);

JPluginHelper::importPlugin('captcha');
$dispatcher = JDispatcher::getInstance();

// This will put the code to load reCAPTCHA's JavaScript file into your <head>
$dispatcher->trigger('onInit', 'dynamic_recaptcha_1');

// This will return the array of HTML code.
$recaptcha = $dispatcher->trigger('onDisplay', array(null, 'dynamic_recaptcha_1', 'class="required"'));
$app                     = JFactory::getApplication();
$tlptestimonial_params   = JComponentHelper::getParams( 'com_tlptestimonial' );
$app                     	= JFactory::getApplication();
$menu                    	= $app->getMenu();
$active                  	= $menu->getActive();
$itemId                  	= $active->id;
$menuparams              	= $menu->getParams( $itemId );
$fprofileimage 			= $menuparams->get( 'fprofileimage' );
$fcategory      		= $menuparams->get( 'fcategory' );
$fdesignation 			= $menuparams->get( 'fdesignation' );
$fcompany      			= $menuparams->get( 'fcompany' );
$flocation 				= $menuparams->get( 'flocation' );


?>

<div class="testimonial-edit front-end-edit">
	<?php if (!$canEdit) : ?>
		<h3>
			<?php throw new Exception(JText::_('COM_TLPTESTIMONIAL_ERROR_MESSAGE_NOT_AUTHORISED'), 403); ?>
		</h3>
	<?php else : ?>
		<?php if (!empty($this->item->id)): ?>
			<h1><?php echo JText::sprintf('COM_TLPTESTIMONIAL_EDIT_ITEM_TITLE', $this->item->id); ?></h1>
		<?php else: ?>
			<h1><?php echo JText::_('COM_TLPTESTIMONIAL_ADD_ITEM_TITLE'); ?></h1>
		<?php endif; ?>

		<form id="form-testimonial"
			  action="<?php echo JRoute::_('index.php?option=com_tlptestimonial&task=testimonial.save'); ?>"
			  method="post" class="form-validate form-horizontal" enctype="multipart/form-data">
			
		<input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>" />

		<?php echo $this->form->renderField('name'); ?>

		<?php echo $this->form->renderField('alias'); ?>

		<?php 
		if($fcategory) {
			echo $this->form->renderField('category'); 
		}
		?>

		<?php foreach((array)$this->item->category as $value): ?>
			<?php if(!is_array($value)): ?>
				<input type="hidden" class="category" name="jform[categoryhidden][<?php echo $value; ?>]" value="<?php echo $value; ?>" />
			<?php endif; ?>
		<?php endforeach; ?>
		<?php if($fdesignation==1) { 
			echo $this->form->renderField('designation'); 
			}
		?>

		<?php if($fcompany==1) {
			echo $this->form->renderField('company'); 
			}
		?>
		<?php if($flocation==1) { 
			echo $this->form->renderField('location'); 
			}
		?>

		<?php if($fprofileimage==1) { ?>
		
		<?php echo $this->form->renderField('profile_image'); ?>
	

		<?php if (!empty($this->item->profile_image)) :
			foreach ((array) $this->item->profile_image as $singleFile) : 
				if (!is_array($singleFile)) :
					echo '<a href="' . JRoute::_(JUri::root() . 'images/testimonial' . DIRECTORY_SEPARATOR . $singleFile, false) . '">' . $singleFile . '</a> ';
				endif;
			endforeach;
		endif; ?>
		<input type="hidden" name="jform[profile_image_hidden]" id="jform_profile_image_hidden" value="<?php echo str_replace('Array,', '', implode(',', (array) $this->item->profile_image)); ?>" />

		<?php } //end fcondition?>
		<?php echo $this->form->renderField('testimonial'); ?>
		<?php if($recaptcha){?>
		<div class="control-group">
			<div class="controls"></div>
			<div class="controls"><?php echo (isset($recaptcha[0])) ? $recaptcha[0] : '';?></div>
		</div>
		<?php }?>
		<input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>" />

		<input type="hidden" name="jform[state]" value="<?php if($this->item->state==1){ echo $this->item->state;}else { echo '0';} ?>" />

		<input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>" />

		<input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>" />

				<?php echo $this->form->getInput('created_by'); ?>
			<div class="control-group">
				<div class="controls">

					<?php if ($this->canSave): ?>
						<button type="submit" class="validate btn btn-primary">
							<?php echo JText::_('JSUBMIT'); ?>
						</button>
					<?php endif; ?>
					<a class="btn"
					   href="<?php echo JRoute::_('index.php?option=com_tlptestimonial&task=testimonialform.cancel'); ?>"
					   title="<?php echo JText::_('JCANCEL'); ?>">
						<?php echo JText::_('JCANCEL'); ?>
					</a>
				</div>
			</div>

			<input type="hidden" name="option" value="com_tlptestimonial"/>
			<input type="hidden" name="task"
				   value="testimonialform.save"/>
			<?php echo JHtml::_('form.token'); ?>
		</form>
	<?php endif; ?>
</div>
