<?php
/**
 * @version    1.0
 * @package    Com_Tlptestimonial
 * @author     RadiusTheme <support@radiustheme.com>
 * @copyright  Copyright (C) 2017. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
JHtml::_('formbehavior.chosen', 'select');

$user       = JFactory::getUser();
$userId     = $user->get('id');
$listOrder  = $this->state->get('list.ordering');
$listDirn   = $this->state->get('list.direction');
$canCreate  = $user->authorise('core.create', 'com_tlptestimonial') && file_exists(JPATH_COMPONENT . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR . 'testimonialform.xml');
$canEdit    = $user->authorise('core.edit', 'com_tlptestimonial') && file_exists(JPATH_COMPONENT . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'forms' . DIRECTORY_SEPARATOR . 'testimonialform.xml');
$canCheckin = $user->authorise('core.manage', 'com_tlptestimonial');
$canChange  = $user->authorise('core.edit.state', 'com_tlptestimonial');
$canDelete  = $user->authorise('core.delete', 'com_tlptestimonial');

$app                     = JFactory::getApplication();
$tlptestimonial_params   = JComponentHelper::getParams( 'com_tlptestimonial' );
$image_storiage_path     = $tlptestimonial_params->get( 'image_path', 'images/tlptestimonial' );

$app                     	= JFactory::getApplication();
$menu                    	= $app->getMenu();
$active                  	= $menu->getActive();
$itemId                  	= $active->id;
$menuparams              	= $menu->getParams( $itemId );
$category_id             	= $menuparams->get( "category" );
$layout                	 	= $menuparams->get( 'layout');
$desktop_per_row       		= $menuparams->get( 'desktop_per_row' );
$tab_per_row           		= $menuparams->get( 'tab_per_row' );
$phone_per_row         		= $menuparams->get( 'phone_per_row' );
$gutter           			= $menuparams->get( 'gutter' );
$testimonial_limit      	= $menuparams->get( 'testimonial_limit' );
$image_style           		= $menuparams->get( 'image_style' );
$image_width           		= $menuparams->get( 'image_width' );
$image_size           		= $menuparams->get( 'image_size' );
$image_alignment           	= $menuparams->get( 'image_alignment' );
$image_border           	= $menuparams->get( 'image_border' );
$image_border_color         = $menuparams->get( 'image_border_color' );
$primary_color         		= $menuparams->get( 'primary_color' );
$name_font_size      		= $menuparams->get( 'name_font_size' );
$name_font_color      		= $menuparams->get( 'name_font_color' );
$name_text_align      		= $menuparams->get( 'name_text_align' );
$name_font_weight     		= $menuparams->get( 'name_font_weight' );
$designation_font_size  	= $menuparams->get( 'designation_font_size' );
$designation_font_color 	= $menuparams->get( 'designation_font_color' );
$designation_text_align 	= $menuparams->get( 'designation_text_align' );
$testimonial_font_size      = $menuparams->get( 'testimonial_font_size' );
$testimonial_font_color     = $menuparams->get( 'testimonial_font_color' );
$testimonial_text_align     = $menuparams->get( 'testimonial_text_align' );
$testimonial_text_style     = $menuparams->get( 'testimonial_text_style' );
$button_color          		= $menuparams->get( 'button_color' );
$button_text_color     		= $menuparams->get( 'button_text_color' );
$button_hover_color    		= $menuparams->get( 'button_hover_color' );
$link_detail      			= $menuparams->get( 'link_detail' );
$list_image 				= $menuparams->get( 'list_image' );
$list_designation      		= $menuparams->get( 'list_designation' );
$list_readmore            	= $menuparams->get( 'list_readmore' );

$md_grid= (12/$desktop_per_row);
$sm_grid = (12/$tab_per_row);
$xs_grid = (12/$phone_per_row);

if ( $image_style == 2 ) {
	$image_style_class = ' tss-img-circle tlp-equal-height';
} else {
	$image_style_class = ' img-responsive tlp-equal-height';
}

$grid = "rt-col-lg-" . $md_grid . " rt-col-md-" . $md_grid . " rt-col-sm-" . $sm_grid . " rt-col-xs-" . $xs_grid;

$this->rtfconfig = array(
	'image_storiage_path'   => $image_storiage_path,
	'grid'                  => $grid,
	'class'     			=> $image_style_class,
	'image_size'     		=> $image_size,
	'list_image'      		=> $list_image,
	'list_designation' 		=> $list_designation,
	'testimonial_limit'		=> $testimonial_limit,
	'list_readmore'      	=> $list_readmore,
	'link_detail'          	=> $link_detail
	
);

$document = JFactory::getDocument();

$style ='';
$style .='.tss-read-more a { color:'.$button_text_color.'; background:'.$button_color.';}';
$style .='.tss-read-more:hover a { color:'.$button_text_color.'; background:'.$button_hover_color.';}';
if(($image_border_color)&&($image_border)){
$style .='.tss-wrapper .profile-img-wrapper img { border:'.$image_border.' solid '.$image_border_color.'!important;}';
}
if($image_width){
	$style .='.tss-wrapper .profile-img-wrapper img { width:'.$image_width.'!important; height:auto;}';
}
if($gutter>0){
  $style .= '.tss-wrapper .tlp-equal-height { margin-bottom: 0px;}';
  $style .= '.tss-wrapper [class*=rt-col-] { padding-left : '.$gutter.'; padding-right : '.$gutter.'; margin-bottom : '.( ((int)$gutter) *2).'px; }';
  $style .= '.rt-row { margin-left : -'.$gutter.'!important; margin-right : -'.$gutter.'!important;}'; 
}

if($layout=='layout1'){
$style .='.tss-wrapper .tss-layout1 .single-item-wrapper h3.author-name, .tss-wrapper .tss-layout1 .single-item-wrapper h3.author-name a { color:'.$name_font_color.'; font-size:'.$name_font_size.'; font-weight:'.$name_font_weight.'; text-align:'.$name_text_align.';}';
$style .='.tss-wrapper .tss-layout1 .single-item-wrapper h4.author-bio { color:'.$designation_font_color.'; font-size:'.$designation_font_size.'; text-align:'.$designation_text_align.';}';
if($primary_color){
$style .='.tss-wrapper .tss-layout1 .item-content-wrapper { background-color:'.$primary_color.';}';
$style .='.tss-wrapper .tss-layout1 .item-content-wrapper:after { border-right: 15px solid '.$primary_color.';}';
}
$style .='.tss-wrapper .tss-layout1 .item-content p { color:'.$testimonial_font_color.'; font-size:'.$testimonial_font_size.'; font-style:'.$testimonial_text_style.'; text-align:'.$testimonial_text_align.';}';

}
if($layout=='layout2'){
$style .='.tss-wrapper .tss-layout2 .single-item-wrapper h3.author-name, .tss-wrapper .tss-layout2 .single-item-wrapper h3.author-name a { color:'.$name_font_color.'; font-size:'.$name_font_size.'; font-weight:'.$name_font_weight.'; text-align:'.$name_text_align.';}';
$style .='.tss-wrapper .tss-layout2 .single-item-wrapper h4.author-bio { color:'.$designation_font_color.'; font-size:'.$designation_font_size.'; text-align:'.$designation_text_align.';}';
if($primary_color){
$style .='.tss-wrapper .tss-layout2 .item-content-wrapper { background-color:'.$primary_color.';}';
$style .='.tss-wrapper .tss-layout2 .item-content-wrapper:after { border-right: 15px solid '.$primary_color.';}';
}
$style .='.tss-wrapper .tss-layout2 .item-content p { color:'.$testimonial_font_color.'; font-size:'.$testimonial_font_size.'; font-style:'.$testimonial_text_style.'; text-align:'.$testimonial_text_align.';}';
$style .='.tss-wrapper .tss-layout2 .profile-img-wrapper { text-align:'.$image_alignment.'!important;}';

}
if($layout=='layout3'){
$style .='.tss-wrapper .tss-layout3 .single-item-wrapper h3.author-name, .tss-wrapper .tss-layout3 .single-item-wrapper h3.author-name a { color:'.$name_font_color.'; font-size:'.$name_font_size.'; font-weight:'.$name_font_weight.'; text-align:'.$name_text_align.';}';
$style .='.tss-wrapper .tss-layout3 .single-item-wrapper h4.author-bio { color:'.$designation_font_color.'; font-size:'.$designation_font_size.'; text-align:'.$designation_text_align.';}';
if($primary_color){
$style .='.tss-wrapper .tss-layout3 .single-item-wrapper { background-color:'.$primary_color.';}';
$style .='.tss-wrapper .tss-layout3 .item-content-wrapper:after { border-right: 15px solid '.$primary_color.';}';
}
$style .='.tss-wrapper .tss-layout3 .item-content p { color:'.$testimonial_font_color.'; font-size:'.$testimonial_font_size.'; font-style:'.$testimonial_text_style.'; text-align:'.$testimonial_text_align.';}';
}
if($layout=='layout4'){
$style .='.tss-wrapper .tss-layout4 .single-item-wrapper h3.author-name, .tss-wrapper .tss-layout4 .single-item-wrapper h3.author-name a { color:'.$name_font_color.'; font-size:'.$name_font_size.'; font-weight:'.$name_font_weight.'; text-align:'.$name_text_align.';}';
$style .='.tss-wrapper .tss-layout4 .single-item-wrapper h4.author-bio { color:'.$designation_font_color.'; font-size:'.$designation_font_size.'; text-align:'.$designation_text_align.';}';
if($primary_color){
$style .='.tss-wrapper .tss-layout4 .item-content-wrapper { background-color:'.$primary_color.';}';
$style .='.tss-wrapper .tss-layout4 .item-content-wrapper:after { border-top: 15px solid '.$primary_color.';}';
}
$style .='.tss-wrapper .tss-layout4 .item-content p { color:'.$testimonial_font_color.'; font-size:'.$testimonial_font_size.'; font-style:'.$testimonial_text_style.'; text-align:'.$testimonial_text_align.';}';
}
if($layout=='layout5'){
$style .='.tss-wrapper .tss-layout5 .single-item-wrapper h3.author-name, .tss-wrapper .tss-layout5 .single-item-wrapper h3.author-name a { color:'.$name_font_color.'; font-size:'.$name_font_size.'; font-weight:'.$name_font_weight.'; text-align:'.$name_text_align.';}';
$style .='.tss-wrapper .tss-layout5 .single-item-wrapper h4.author-bio { color:'.$designation_font_color.'; font-size:'.$designation_font_size.'; text-align:'.$designation_text_align.';}';
if($primary_color){
$style .='.tss-wrapper .tss-layout5 .single-item-wrapper { background-color:'.$primary_color.';}';
}
$style .='.tss-wrapper .tss-layout5 .item-content p { color:'.$testimonial_font_color.'; font-size:'.$testimonial_font_size.'; font-style:'.$testimonial_text_style.'; text-align:'.$testimonial_text_align.';}';
$style .='.tss-wrapper .tss-layout5 .profile-img-wrapper { text-align:'.$image_alignment.'!important;}';

}
if($layout=='layout6'){
$style .='.tss-wrapper .tss-layout6 .single-item-wrapper h3.author-name, .tss-wrapper .tss-layout6 .single-item-wrapper h3.author-name a { color:'.$name_font_color.'; font-size:'.$name_font_size.'; font-weight:'.$name_font_weight.'; text-align:'.$name_text_align.';}';
$style .='.tss-wrapper .tss-layout6 .single-item-wrapper h4.author-bio { color:'.$designation_font_color.'; font-size:'.$designation_font_size.'; text-align:'.$designation_text_align.';}';
if($primary_color){
$style .='.tss-wrapper .tss-layout6 .single-item-wrapper { background-color:'.$primary_color.';}';
}
$style .='.tss-wrapper .tss-layout6 .item-content p { color:'.$testimonial_font_color.'; font-size:'.$testimonial_font_size.'; font-style:'.$testimonial_text_style.'; text-align:'.$testimonial_text_align.';}';
$style .='.tss-wrapper .tss-layout6 .profile-img-wrapper { text-align:'.$image_alignment.'!important;}';

}

$document->addStyleDeclaration( $style );

?>

<form action="<?php echo JRoute::_('index.php?option=com_tlptestimonial&view=testimonials'); ?>" method="post"
      name="adminForm" id="adminForm">

	<div class="container-fluid tss-wrapper">
		<div class="<?php echo 'tss-'.$layout; ?>">
			<div class="rt-row">
				<?php
					foreach ( $this->items as &$item ) :
						$this->item = &$item;
						echo $this->loadTemplate( $layout );
					endforeach; ?>
			</div>
			<?php $total_ites= count($this->items);
				$perpage=(int) JFactory::getConfig()->get('list_limit', 20);
				if($total_ites>$perpage){
				?>
				<div class="rt-row">
					<?php echo $this->pagination->getListFooter(); ?>
				</div>
			<?php }?>
		</div>
	</div>


	<input type="hidden" name="task" value=""/>
	<input type="hidden" name="boxchecked" value="0"/>
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>"/>
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>"/>
	<?php echo JHtml::_('form.token'); ?>
</form>

<?php if($canDelete) : ?>
<script type="text/javascript">

	jQuery(document).ready(function () {
		jQuery('.delete-button').click(deleteItem);
	});

	function deleteItem() {

		if (!confirm("<?php echo JText::_('COM_TLPTESTIMONIAL_DELETE_MESSAGE'); ?>")) {
			return false;
		}
	}
</script>
<?php endif; ?>

<script src="<?php echo JURI::root(); ?>components/com_tlptestimonial/assets/js/jquery.actual.min.js" type="text/javascript"></script>
<script src="<?php echo JURI::root(); ?>components/com_tlptestimonial/assets/js/imagesloaded.pkgd.min.js" type="text/javascript"></script>
<script src="<?php echo JURI::root();?>components/com_tlptestimonial/assets/js/tlptestimonial.js" type="text/javascript"></script>

