<?php
/**
 * @version    2.0
 * @package    com_rtlogoshowcase
 * @subpackage  mod_rtlogoshowcase
 * @author      RadiusTheme <support@radiustheme.com>
 * @copyright   Copyright (C) 2016. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

/**
 * Helper for mod_rtlogoshowcase
 *
 * @package     com_rtlogoshowcase
 * @subpackage  mod_rtlogoshowcase
 * @since       1.6
 */
class ModRtlogoshowcaseHelper
{
	/**
	 * Retrieve component items
	 *
	 * @param   Joomla\Registry\Registry &$params module parameters
	 *
	 * @return array Array with all the elements
	 */
	public static function getLists(&$params)
	{
		$db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $category=$params->get('category');
        $multilang=JLanguageMultilang::isEnabled();
        $category = implode(",", $category);

        $query
                ->select('a.*,category.id')
                ->from('#__rtlogoshowcase_logos a');
        if($category>0){
            $query->where("a.state = 1 AND a.category IN({$category})");
        }else{
            $query->where('a.state = 1');
        }
        // Join over the category 'category'
		$query->select('category.title AS category_title');
		$query->join('LEFT', '#__categories AS category ON category.id = a.category');

        // Filter by language
        if ($multilang)
        {
            $query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
        }
        $query->order('a.ordering');
        

        $db->setQuery($query, 0, $params->get('mod_logocount'));
        $rows = $db->loadObjectList();
        return $rows;
	}

	
	
}
