<?php
/**
 * @version    1.0.0
 * @package    com_rtlogoshowcase
 * @author     RadiusTheme <support@radiustheme.com>
 * @copyright  Copyright (C) 2016. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

/**
 * Rtlogoshowcase helper.
 *
 * @since  1.6
 */
class RtlogoshowcaseHelpersRtlogoshowcase
{
	/**
	 * Configure the Linkbar.
	 *
	 * @param   string  $vName  string
	 *
	 * @return void
	 */
	public static function addSubmenu($vName = '')
	{
		JHtmlSidebar::addEntry(
			JText::_('COM_RTLOGOSHOWCASE_TITLE_LOGOS'),
			'index.php?option=com_rtlogoshowcase&view=logos',
			$vName == 'logos'
		);

		JHtmlSidebar::addEntry(
			JText::_('JCATEGORIES') . ' (' . JText::_('COM_RTLOGOSHOWCASE_TITLE_LOGOS') . ')',
			"index.php?option=com_categories&extension=com_rtlogoshowcase",
			$vName == 'categories'
		);
		if ($vName=='categories') {
			JToolBarHelper::title('RT Logo Showcase: JCATEGORIES (COM_RTLOGOSHOWCASE_TITLE_LOGOS)');
		}

	}

	/**
	 * Gets a list of the actions that can be performed.
	 *
	 * @return    JObject
	 *
	 * @since    1.6
	 */
	public static function getActions()
	{
		$user   = JFactory::getUser();
		$result = new JObject;

		$assetName = 'com_rtlogoshowcase';

		$actions = array(
			'core.admin', 'core.manage', 'core.create', 'core.edit', 'core.edit.own', 'core.edit.state', 'core.delete'
		);

		foreach ($actions as $action)
		{
			$result->set($action, $user->authorise($action, $assetName));
		}

		return $result;
	}
}
