<?php
/**
 * @version    2.0
 * @package    com_rtlogoshowcase
 * @author     RadiusTheme <support@radiustheme.com>
 * @copyright  Copyright (C) 2016. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;
/**
 * logo Table class
 *
 * @since  1.6
 */
class RtlogoshowcaseTablelogo extends JTable
{
	/**
	 * Constructor
	 *
	 * @param   JDatabase  &$db  A database connector object
	 */
	public function __construct(&$db)
	{
		JObserverMapper::addObserverClassToClass('JTableObserverContenthistory', 'RtlogoshowcaseTablelogo', array('typeAlias' => 'com_rtlogoshowcase.logo'));
		parent::__construct('#__rtlogoshowcase_logos', 'id', $db);
	}

	/**
	 * Overloaded bind function to pre-process the params.
	 *
	 * @param   array  $array   Named array
	 * @param   mixed  $ignore  Optional array or list of parameters to ignore
	 *
	 * @return  null|string  null is operation was satisfactory, otherwise returns an error
	 *
	 * @see     JTable:bind
	 * @since   1.5
	 */
	public function bind($array, $ignore = '')
	{

	
			
		// Support for multi file field: logo_image
		if (!empty($array['logo_image']))
		{
			if (is_array($array['logo_image']))
			{
				$array['logo_image'] = implode(',', $array['logo_image']);
			}
			elseif (strpos($array['logo_image'], ',') != false)
			{
				$array['logo_image'] = explode(',', $array['logo_image']);
			}
		}
		else
		{
			$array['logo_image'] = '';
		}

		$input = JFactory::getApplication()->input;
		$task = $input->getString('task', '');

		if ($array['id'] == 0)
		{
			$array['created_by'] = JFactory::getUser()->id;
		}

		if (isset($array['params']) && is_array($array['params']))
		{
			$registry = new JRegistry;
			$registry->loadArray($array['params']);
			$array['params'] = (string) $registry;
		}

		if (isset($array['metadata']) && is_array($array['metadata']))
		{
			$registry = new JRegistry;
			$registry->loadArray($array['metadata']);
			$array['metadata'] = (string) $registry;
		}

		if (!JFactory::getUser()->authorise('core.admin', 'com_rtlogoshowcase.logo.' . $array['id']))
		{
			$actions         = JAccess::getActionsFromFile(
				JPATH_ADMINISTRATOR . '/components/com_rtlogoshowcase/access.xml',
				"/access/section[@name='logo']/"
			);
			$default_actions = JAccess::getAssetRules('com_rtlogoshowcase.logo.' . $array['id'])->getData();
			$array_jaccess   = array();

			foreach ($actions as $action)
			{
				$array_jaccess[$action->name] = $default_actions[$action->name];
			}

			$array['rules'] = $this->JAccessRulestoArray($array_jaccess);
		}

		// Bind the rules for ACL where supported.
		if (isset($array['rules']) && is_array($array['rules']))
		{
			$this->setRules($array['rules']);
		}

		return parent::bind($array, $ignore);
	}

	/**
	 * This function convert an array of JAccessRule objects into an rules array.
	 *
	 * @param   array  $jaccessrules  An array of JAccessRule objects.
	 *
	 * @return  array
	 */
	private function JAccessRulestoArray($jaccessrules)
	{
		$rules = array();

		foreach ($jaccessrules as $action => $jaccess)
		{
			$actions = array();

			foreach ($jaccess->getData() as $group => $allow)
			{
				$actions[$group] = ((bool) $allow);
			}

			$rules[$action] = $actions;
		}

		return $rules;
	}

	/**
	 * Overloaded check function
	 *
	 * @return bool
	 */
	public function check()
	{
		// Check for existing name
		$query = $this->_db->getQuery(true)
			->select($this->_db->quoteName('id'))
			->from($this->_db->quoteName('#__rtlogoshowcase_logos'))
			->where($this->_db->quoteName('title') . ' = ' . $this->_db->quote($this->title));
			
		$this->_db->setQuery($query);

		$xid = (int) $this->_db->loadResult();
		if ($xid && $xid != (int) $this->id)
		{
			$this->setError(JText::_('Title or alias already exist!!'));
			//$this->alias = $this->name.$this->id;
			return false;
		}
		
		if (empty($this->alias))
		{
		   $this->alias = $this->title;
		}
		$this->alias = JFilterOutput::stringURLSafe($this->alias);

		// If there is an ordering column and this is a new row then get the next ordering value
		if (property_exists($this, 'ordering') && $this->id == 0)
		{
			$this->ordering = self::getNextOrder();
		}
		$app = JFactory::getApplication();
    	$input = $app ->input;
    	$rtlogoshowcase_params = JComponentHelper::getParams('com_rtlogoshowcase');
    	$image_storiage_path = $rtlogoshowcase_params->get('image_path','images/rtlogoshowcase');
    	$logo_resize = $rtlogoshowcase_params->get('logo_resize','0');

		// Support multi file field: logo_image
		$app = JFactory::getApplication();
		$files = $app->input->files->get('jform', array(), 'raw');
		$array = $app->input->get('jform', array(), 'ARRAY');

		if (!empty($files['logo_image']))
		{
			$this->logo_image = "";

			foreach ($files['logo_image'] as $singleFile )
			{
				jimport('joomla.filesystem.file');

				// Check if the server found any error.
				$fileError = $singleFile['error'];
				$message = '';

				if ($fileError > 0 && $fileError != 4)
				{
					switch ($fileError)
					{
						case 1:
							$message = JText::_('File size exceeds allowed by the server');
							break;
						case 2:
							$message = JText::_('File size exceeds allowed by the html form');
							break;
						case 3:
							$message = JText::_('Partial upload error');
							break;
					}

					if ($message != '')
					{
						$app->enqueueMessage($message, 'warning');

						return false;
					}
				}
				elseif ($fileError == 4)
				{
					if (isset($array['logo_image']))
					{
						$this->logo_image = $array['logo_image'];
					}
				}
				else
				{

					// Replace any special characters in the filename
					jimport('joomla.filesystem.file');
					$filename = JFile::stripExt($singleFile['name']);
					$extension = JFile::getExt($singleFile['name']);
					$filename = preg_replace("/[^A-Za-z0-9]/i", "-", $filename);
					$filename = $filename . '.' . $extension;
					$uploadPath = JPATH_ROOT .'/'. $image_storiage_path .'/'. $filename;
				 	$image_storiage_folder = JPATH_ROOT .'/'. $image_storiage_path .'/';
					$fileTemp = $singleFile['tmp_name'];

					$folder = $image_storiage_folder;
						if(!file_exists($folder)){
							mkdir($folder, 0777, true);
						}

					
				if($logo_resize){

					$image_small_width = $rtlogoshowcase_params->get('smallimage_width','200');
				    $image_small_height = $rtlogoshowcase_params->get('smallimage_height','100');
					$image_medium_width = $rtlogoshowcase_params->get('mediumimage_width','400');
					$image_medium_height = $rtlogoshowcase_params->get('mediumimage_height','300');
					$image_large_width = $rtlogoshowcase_params->get('largeimage_width','600');
					$image_large_height = $rtlogoshowcase_params->get('largeimage_height','500');

					jimport('joomla.filter.output');
						if ($array['id'] == 0)
							{
								$db = JFactory::getDbo();
								$query = $db->getQuery(true);

								$query->select($db->quoteName('id'))
								->from($db->quoteName('#__rtlogoshowcase_logos'))
								->order($db->quoteName('id') . ' DESC');

								$db->setQuery($query);
								$result = $db->loadResult();
								$result1=$result+1;
								$img_name='logo_'.$result1;
							}else{
								$img_name='logo_'.$array['id'];
							}
										
						$image_name = $img_name.".jpg";
						$image_small = $image_name;
						$image_medium = 'm_'.$image_name;
						$image_large = 'l_'.$image_name;

					self::createImage($fileTemp,$image_small,$image_medium,$image_large,$image_small_width, $image_small_height, $image_medium_width, $image_medium_height, $image_large_width, $image_large_height, '', $image_storiage_folder, $singleFile['name']);
					
					$this->logo_image .= (!empty($this->logo_image)) ? "," : "";
					$this->logo_image .= $image_name;
				}else{

					if (!JFile::exists($uploadPath))
					{
						if (!JFile::upload($fileTemp, $uploadPath))
						{
							$app->enqueueMessage('Error moving file', 'warning');

							return false;
						}
					}
					$this->logo_image .= (!empty($this->logo_image)) ? "," : "";
					$this->logo_image .= $filename;
				}
			}
			}
		}

		return parent::check();
	}

	/**
	 * Method to set the publishing state for a row or list of rows in the database
	 * table.  The method respects checked out rows by other users and will attempt
	 * to checkin rows that it can after adjustments are made.
	 *
	 * @param   mixed    $pks     An optional array of primary key values to update.  If not
	 *                            set the instance property value is used.
	 * @param   integer  $state   The publishing state. eg. [0 = unpublished, 1 = published]
	 * @param   integer  $userId  The user id of the user performing the operation.
	 *
	 * @return   boolean  True on success.
	 *
	 * @since    1.0.4
	 *
	 * @throws Exception
	 */
	public function publish($pks = null, $state = 1, $userId = 0)
	{
		// Initialise variables.
		$k = $this->_tbl_key;

		// Sanitize input.
		ArrayHelper::toInteger($pks);
		$userId = (int) $userId;
		$state  = (int) $state;

		// If there are no primary keys set check to see if the instance key is set.
		if (empty($pks))
		{
			if ($this->$k)
			{
				$pks = array($this->$k);
			}
			// Nothing to set publishing state on, return false.
			else
			{
				throw new Exception(500, JText::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));
			}
		}

		// Build the WHERE clause for the primary keys.
		$where = $k . '=' . implode(' OR ' . $k . '=', $pks);

		// Determine if there is checkin support for the table.
		if (!property_exists($this, 'checked_out') || !property_exists($this, 'checked_out_time'))
		{
			$checkin = '';
		}
		else
		{
			$checkin = ' AND (checked_out = 0 OR checked_out = ' . (int) $userId . ')';
		}

		// Update the publishing state for rows with the given primary keys.
		$this->_db->setQuery(
			'UPDATE `' . $this->_tbl . '`' .
			' SET `state` = ' . (int) $state .
			' WHERE (' . $where . ')' .
			$checkin
		);
		$this->_db->execute();

		// If checkin is supported and all rows were adjusted, check them in.
		if ($checkin && (count($pks) == $this->_db->getAffectedRows()))
		{
			// Checkin each row.
			foreach ($pks as $pk)
			{
				$this->checkin($pk);
			}
		}

		// If the JTable instance value is in the list of primary keys that were set, set the instance.
		if (in_array($this->$k, $pks))
		{
			$this->state = $state;
		}

		return true;
	}

	/**
	 * Define a namespaced asset name for inclusion in the #__assets table
	 *
	 * @return string The asset name
	 *
	 * @see JTable::_getAssetName
	 */
	protected function _getAssetName()
	{
		$k = $this->_tbl_key;

		return 'com_rtlogoshowcase.logo.' . (int) $this->$k;
	}

	/**
	 * Returns the parent asset's id. If you have a tree structure, retrieve the parent's id using the external key field
	 *
	 * @param   JTable   $table  Table name
	 * @param   integer  $id     Id
	 *
	 * @see JTable::_getAssetParentId
	 *
	 * @return mixed The id on success, false on failure.
	 */
	protected function _getAssetParentId(JTable $table = null, $id = null)
	{
		// We will retrieve the parent-asset from the Asset-table
		$assetParent = JTable::getInstance('Asset');

		// Default: if no asset-parent can be found we take the global asset
		$assetParentId = $assetParent->getRootId();

		// The item has the component as asset-parent
		$assetParent->loadByName('com_rtlogoshowcase');

		// Return the found asset-parent-id
		if ($assetParent->id)
		{
			$assetParentId = $assetParent->id;
		}

		return $assetParentId;
	}

	/**
	 * Delete a record by id
	 *
	 * @param   mixed  $pk  Primary key value to delete. Optional
	 *
	 * @return bool
	 */
	public function delete($pk = null)
	{
		$this->load($pk);
		$result = parent::delete($pk);
		
		if ($result)
		{
			jimport('joomla.filesystem.file');

			foreach ($this->logo_image as $logo_imageFile)
			{
				JFile::delete(JPATH_ROOT . '/images/tlplogoshowcase/' . $logo_imageFile);
			}
		}

		return $result;
	}
/*
    * Create Thumbnail
    */
    
    public  function createImage($src_file,$small_name,$medium_name,$large_name,
                                        $max_width_s,
                                        $max_height_s,
                                        $max_width_m,
                                        $max_height_m,
                                        $max_width_l,
                                        $max_height_l,
                                        $tag,
                                        $path,
                                        $orig_name)
            {
                ini_set('memory_limit', '200M');
                
                echo $src_file = urldecode($src_file);
                //exit;
                
                    $orig_name = strtolower($orig_name);
                    $findme  = '.jpg';
                    $pos = strpos($orig_name, $findme);
                    if ($pos === false)
                    {
                        $findme  = '.jpeg';
                        $pos = strpos($orig_name, $findme);
                        if ($pos === false)
                        {
                            $findme  = '.gif';
                            $pos = strpos($orig_name, $findme);
                            if ($pos === false)
                            {
                                $findme  = '.png';
                                $pos = strpos($orig_name, $findme);
                                if ($pos === false)
                                {
                                    return;
                                }
                                else
                                {
                                    $type = "png";
                                }
                            }
                            else
                            {
                                $type = "gif";
                            }
                        }
                        else
                        {
                            $type = "jpeg";
                        }
                    }
                    else
                    {
                        $type = "jpeg";
                    }
                //}
                
                $max_small_h = $max_height_s;
                $max_small_w = $max_width_s;
                $max_medium_h = $max_height_m;
                $max_medium_w = $max_width_m;
                $max_large_h = $max_height_l;
                $max_large_w = $max_width_l;
                
                if ( file_exists( "$path/$small_name")) {
                    unlink( "$path/$small_name");
                }
                
                if ( file_exists( "$path/$medium_name")) {
                    unlink( "$path/$medium_name");
                }
                
                if ( file_exists( "$path/$large_name")) {
                    unlink( "$path/$large_name");
                }
                
                $read = 'imagecreatefrom' . $type; 
                $write = 'image' . $type; 
                
                $src_img = $read($src_file);
                
                // height/width
                $imginfo = getimagesize($src_file);
                $src_w = $imginfo[0];
                $src_h = $imginfo[1];
                
                $zoom_h = $max_small_h / $src_h;
                $zoom_w = $max_small_w / $src_w;
                $zoom   = min($zoom_h, $zoom_w);
                $dst_small_h  = $zoom<1 ? round($src_h*$zoom) : $src_h;
                $dst_small_w  = $zoom<1 ? round($src_w*$zoom) : $src_w;
                
                $zoom_h = $max_medium_h / $src_h;
                $zoom_w = $max_medium_w / $src_w;
                $zoom   = min($zoom_h, $zoom_w);
                $dst_medium_h  = $zoom<1 ? round($src_h*$zoom) : $src_h;
                $dst_medium_w  = $zoom<1 ? round($src_w*$zoom) : $src_w;
                
                $zoom_h = $max_large_h / $src_h;
                $zoom_w = $max_large_w / $src_w;
                $zoom   = min($zoom_h, $zoom_w);
                $dst_large_h  = $zoom<1 ? round($src_h*$zoom) : $src_h;
                $dst_large_w  = $zoom<1 ? round($src_w*$zoom) : $src_w;
                
                
                $dst_s_img = imagecreatetruecolor($dst_small_w,$dst_small_h);
                $white = imagecolorallocate($dst_s_img,255,255,255);
                imagefill($dst_s_img,0,0,$white);
                imagecopyresampled($dst_s_img,$src_img, 0,0,0,0, $dst_small_w,$dst_small_h,$src_w,$src_h);
                $textcolor = imagecolorallocate($dst_s_img, 255, 255, 255);
                if (isset($tag))
                    imagestring($dst_s_img, 2, 2, 2, "$tag", $textcolor);
                if($type == 'jpeg'){
                    $desc_img = $write($dst_s_img,"$path/$small_name", 75);
                }else{
                    $desc_img = $write($dst_s_img,"$path/$small_name", 2);
                }
                
                
                $dst_m_img = imagecreatetruecolor($dst_medium_w,$dst_medium_h);
                $white = imagecolorallocate($dst_m_img,255,255,255);
                imagefill($dst_m_img,0,0,$white);
                imagecopyresampled($dst_m_img,$src_img, 0,0,0,0, $dst_medium_w,$dst_medium_h,$src_w,$src_h);
                $textcolor = imagecolorallocate($dst_m_img, 255, 255, 255);
                if (isset($tag))
                    imagestring($dst_m_img, 2, 2, 2, "$tag", $textcolor);
                if($type == 'jpeg'){
                    $desc_img = $write($dst_m_img,"$path/$medium_name", 75);
                }else{
                    $desc_img = $write($dst_m_img,"$path/$medium_name", 2);
                }
                
                $dst_l_img = imagecreatetruecolor($dst_large_w,$dst_large_h);
                $white = imagecolorallocate($dst_l_img,255,255,255);
                imagefill($dst_l_img,0,0,$white);
                imagecopyresampled($dst_l_img,$src_img, 0,0,0,0, $dst_large_w,$dst_large_h,$src_w,$src_h);

                $textcolor = imagecolorallocate($dst_l_img, 255, 255, 255);
                if (isset($tag))
                    imagestring($dst_l_img, 2, 2, 2, "$tag", $textcolor);
                if($type == 'jpeg'){
                    $desc_img = $write($dst_l_img,"$path/$large_name", 75);
                }else{
                    $desc_img = $write($dst_l_img,"$path/$large_name", 2);
                }
                
                
            
            }       

}

