<?php
/**
 * @version    2.0
 * @package    com_tlpportfolio
 * @author     TechLabPro <info@techlabpro.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

use Joomla\Utilities\ArrayHelper;
require_once(JPATH_ROOT . "/administrator/components/com_tlpportfolio/helpers/tlpportfolio.php");
/**
 * portfolio Table class
 *
 * @since  1.6
 */
class TlpportfolioTableportfolio extends JTable
{
	/**
	 * Constructor
	 *
	 * @param   JDatabase  &$db  A database connector object
	 */
	public function __construct(&$db)
	{
		parent::__construct('#__tlpportfolio_portfolio', 'id', $db);
	}

	/**
	 * Overloaded bind function to pre-process the params.
	 *
	 * @param   array  $array   Named array
	 * @param   mixed  $ignore  Optional array or list of parameters to ignore
	 *
	 * @return  null|string  null is operation was satisfactory, otherwise returns an error
	 *
	 * @see     JTable:bind
	 * @since   1.5
	 */
	public function bind($array, $ignore = '')
	{
		$app = JFactory::getApplication();
    	$input = $app ->input;
   
    	$tlpportfolio_params = JComponentHelper::getParams('com_tlpportfolio');
    	//print_r($tlpportfolio_params);

		//Support for multiple or not foreign key field: tools_used
			if(!empty($array['tools_used'])){
				if(is_array($array['tools_used'])){
					$array['tools_used'] = implode(',',$array['tools_used']);
				}
				else if(strrpos($array['tools_used'], ',') != false){
					$array['tools_used'] = explode(',',$array['tools_used']);
				}
			}
			else {
				$array['tools_used'] = '';
			}

			//created date
			if(!empty($array['completed_date'])){
				//$array['completed_date']='';
			}else{
				$array['completed_date']=date("Y-m-d"); ;
			}


				//Support for file field: portfolio_image
				$input = JFactory::getApplication()->input;
				$files = $input->files->get('jform', array(), 'raw');

				if(!empty($files['portfolio_image'])){
					jimport('joomla.filesystem.file');
					$file = $files['portfolio_image'];

					//Check if the server found any error.
					$fileError = $file['error'];
					$message = '';
					if($fileError > 0 && $fileError != 4) {
						switch ($fileError) {
							case 1:
								$message = JText::_( 'File size exceeds allowed by the server');
								break;
							case 2:
								$message = JText::_( 'File size exceeds allowed by the html form');
								break;
							case 3:
								$message = JText::_( 'Partial upload error');
								break;
						}
						if($message != '') {
							JError::raiseWarning(500, $message);
							return false;
						}
					}
					else if($fileError == 4){
						if(isset($array['portfolio_image_hidden'])){
							$array['portfolio_image'] = $array['portfolio_image_hidden'];
						}
					}
					else{

						$app = JFactory::getApplication();
						$tlpportfolio_params = JComponentHelper::getParams('com_tlpportfolio');

						$image_small_width 		= $tlpportfolio_params->get('smallimage_width','200');
				    	$image_small_height 	= $tlpportfolio_params->get('smallimage_height','200');
						$image_medium_width 	= $tlpportfolio_params->get('mediumimage_width','600');
						$image_medium_height 	= $tlpportfolio_params->get('mediumimage_height','400');
						$image_large_width 		= $tlpportfolio_params->get('largeimage_width','800');
						$image_large_height 	= $tlpportfolio_params->get('largeimage_height','600');
				   		$image_storiage_path 	= $tlpportfolio_params->get('image_path','images/tlpportfolio');
						$image_storiage_folder 	= JPATH_ROOT.'/'. $image_storiage_path.'/';
						

						$folder = $image_storiage_folder;
						if(!file_exists($folder)){
							mkdir($folder, 0777, true);
						}

						jimport('joomla.filter.output');
						if ($array['id'] == 0)
							{
								$db = JFactory::getDbo();
								$query = $db->getQuery(true);

								$query->select($db->quoteName('id'))
								->from($db->quoteName('#__tlpportfolio_portfolio'))
								->order($db->quoteName('id') . ' DESC');

								$db->setQuery($query);
								$result = $db->loadResult();
								$result1=$result+1;
								$img_name='portfolio_'.$result1;
							}else{
								$img_name='portfolio_'.$array['id'];
							}		


						$image_name = $img_name.".jpg";
						$image_small = 's_'.$image_name;
						$image_medium = 'm_'.$image_name;
						$image_large = 'l_'.$image_name;
					
						self::createImage($file['tmp_name'],$image_small,$image_medium,$image_large,$image_small_width, $image_small_height, $image_medium_width, $image_medium_height, $image_large_width, $image_large_height, '', $image_storiage_folder, $file['name']);

						
						$array['portfolio_image'] = $image_name;
					}
				}

				//Support for file field: pgallery
				$input = JFactory::getApplication()->input;
				$files = $input->files->get('jform', array(), 'raw');
				$fInput = $input->post->get('jform', array(), 'raw');
				$oldImgs = array();
				if(isset($fInput['pghidden']) && is_array($fInput['pghidden']) && !empty($fInput['pghidden'])){
					$oldImgs = $fInput['pghidden'];
				}
				$pgfiles = array();
				$pgImgA = array();
				if(!empty($files['pgallery'])){
					jimport('joomla.filesystem.file');
					$pgfiles = $files['pgallery'];
				}

		if($pgfiles){

			foreach($pgfiles as $pgimg){

				//upload Banner 1- 3
				jimport('joomla.filesystem.file');
				jimport('joomla.filesystem.folder' );
				//Check if the server found any error.
				$fileError = $pgimg['error'];
				$message = '';
				if($fileError > 0 && $fileError != 4) {
					switch ($fileError) {
						case 1:
							$message = JText::_( 'File size exceeds allowed by the server');
							break;
						case 2:
							$message = JText::_( 'File size exceeds allowed by the html form');
							break;
						case 3:
							$message = JText::_( 'Partial upload error');
							break;
					}
					if($message != '') {
						JError::raiseWarning(500, $message);
						return false;
					}
				}else if($fileError == 4){
					if(isset($array['portfolio_image_hidden'])){
						$array['portfolio_image'] = $array['portfolio_image_hidden'];
					}
				}else{
					$tlpportfolio_params = JComponentHelper::getParams('com_tlpportfolio');
					$image_large_width = $tlpportfolio_params->get('largeimage_width','800');
					$image_large_height = $tlpportfolio_params->get('largeimage_height','600');
				   	$image_storiage_path = $tlpportfolio_params->get('image_path','images/tlpportfolio');
					$image_storiage_folder = JPATH_ROOT.'/'. $image_storiage_path.'/';


					$folder = $image_storiage_folder;
					if(!file_exists($folder)){
						mkdir($folder, 0777, true);
					}//else
						//chmod($folder, 0777);

					jimport('joomla.filter.output');
					$filename = explode('.', $pgimg['name']);
					$filename[0] = preg_replace("/[^A-Za-z0-9]/i", "-", $filename[0]);
					$filename = md5(time()) . '-' . implode('.',$filename);
					//$filename = 'pp'. '-' . implode('.',$filename);
					$tmpfilename = 'tmp_'.$filename;
					ini_set('memory_limit', '-1');
					$imageSrc = $pgimg['tmp_name'];
					if( move_uploaded_file($imageSrc, $folder.$tmpfilename) )
					{
						if( self::resizeImage($folder.$tmpfilename,  $folder.$filename, $image_large_width, $image_large_height ) )
						{
							if(file_exists($folder.$tmpfilename))
								unlink($folder.$tmpfilename);
						}

						$pgImgA[] =  $filename;
					}
				}
			}

		}

		$pgImgA = array_merge($oldImgs,$pgImgA);
		$pgImgA = implode(",", $pgImgA);
//$pgImgA='pp-pexels-photo.jpg,pp-dolls-high-res.JPG,pp-team7.jpg';

		if(isset($pgImgA) && !empty($pgImgA)){
			$array['pgallery'] = (string)$pgImgA;
			print_r($pgImgA);
			//exit;
		}

		if ( isset($array['tags']) && !empty($array['tags']) ) {
			// Load the tags helper.
			require_once JPATH_ADMINISTRATOR . '/components/com_tags/helpers/tags.php';

			// Get the allowed actions for the user
			$canDo = TagsHelper::getActions('com_tags'); // The helper get the user and the component name itself

			// Load the tags model.
			require_once JPATH_ADMINISTRATOR . '/components/com_tags/models/tag.php';
			JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_tags/tables');

			// Get an instance of the table for insertion the new tags
			$tagsModel = TagsModelTag::getInstance('Tag','TagsModel');

			$tags = array(); // Initialization of the tag container must be processed

			// If tags is an array, store-mode
			if ( is_array($array['tags']) ) {
				// "Allow user creation" mode must be activated (default) in the component creation field
				// Save the tags does not exist into the table tags and get its id for save the entire Item with the proper data
				foreach ($array['tags'] as $singleTag) {
					// If there is any new tag... create it to get the id and save into the table #__COMPONENT_NAME_TABLE_NAME
					if ( strpos($singleTag, "#new#") !== FALSE ) {
						$user           = JFactory::getUser();
						$userId         = $user->id; // For writting permissions 
						$tagName        = str_replace("#new#", "", $singleTag);
						$tagAlias       = $tagPath = preg_replace('/[\s\W\.]+/', '-', $tagName); // Tags alias filter
						$tagMetadata    = array(
								"author"=>""
								, "robots"=>""
								, "tags"=>null
						);

						// The data tag field row
						$data = array(
								"parent_id" => 0
								, "path" => $tagPath
								, "title" => $tagName
								, "alias" => $tagAlias
								, "created_by_alias" => $user
								, "created_user_id" => $userId
								, "published" => 1
								, "checked_out"=> 0
								, "metadata" => json_encode($tagMetadata)
						);

						// Finally, store the tag if the user is granted for that
						if ( $canDo->get('core.create') ) {
							$table = $tagsModel->getTable();
							$table->bind($data) ? $table->store($data) : exit;
							$tags[] = $table->id; // And store the insert_id
						}
					}

				// NOT new Tag (already exists)
				// $singleTag is the tag id
				else
					$tags[] = intval($singleTag);
				}

				// Overrride the tags array, because we should need to change the id before field saving
				// The field in database will look like "299,345,567,567"
				$array['tags'] = implode(',',$tags);
			}
		}
		else {
			$array['tags'] = '';
		}

		//Support for multiple or not foreign key field: related_projects
			if(!empty($array['related_projects'])){
				if(is_array($array['related_projects'])){
					$array['related_projects'] = implode(',',$array['related_projects']);
				}
				else if(strrpos($array['related_projects'], ',') != false){
					$array['related_projects'] = explode(',',$array['related_projects']);
				}
			}
			else {
				$array['related_projects'] = '';
			}
		$input = JFactory::getApplication()->input;
		$task = $input->getString('task', '');

		if (($task == 'save' || $task == 'apply') && (!JFactory::getUser()->authorise('core.edit.state', 'com_tlpportfolio') && $array['state'] == 1))
		{
			$array['state'] = 0;
		}

		if ($array['id'] == 0)
		{
			$array['created_by'] = JFactory::getUser()->id;
		}

		if (isset($array['params']) && is_array($array['params']))
		{
			$registry = new JRegistry;
			$registry->loadArray($array['params']);
			$array['params'] = (string) $registry;
		}

		if (isset($array['metadata']) && is_array($array['metadata']))
		{
			$registry = new JRegistry;
			$registry->loadArray($array['metadata']);
			$array['metadata'] = (string) $registry;
		}

		if (!JFactory::getUser()->authorise('core.admin', 'com_tlpportfolio.portfolio.' . $array['id']))
		{
			$actions         = JAccess::getActionsFromFile(
				JPATH_ADMINISTRATOR . '/components/com_tlpportfolio/access.xml',
				"/access/section[@name='portfolio']/"
			);
			$default_actions = JAccess::getAssetRules('com_tlpportfolio.portfolio.' . $array['id'])->getData();
			$array_jaccess   = array();

			foreach ($actions as $action)
			{
				$array_jaccess[$action->name] = $default_actions[$action->name];
			}

			$array['rules'] = $this->JAccessRulestoArray($array_jaccess);
		}

		// Bind the rules for ACL where supported.
		if (isset($array['rules']) && is_array($array['rules']))
		{
			$this->setRules($array['rules']);
		}

		return parent::bind($array, $ignore);
	}

	/**
	 * This function convert an array of JAccessRule objects into an rules array.
	 *
	 * @param   array  $jaccessrules  An array of JAccessRule objects.
	 *
	 * @return  array
	 */
	private function JAccessRulestoArray($jaccessrules)
	{
		$rules = array();

		foreach ($jaccessrules as $action => $jaccess)
		{
			$actions = array();

			foreach ($jaccess->getData() as $group => $allow)
			{
				$actions[$group] = ((bool) $allow);
			}

			$rules[$action] = $actions;
		}

		return $rules;
	}

	/**
	 * Overloaded check function
	 *
	 * @return bool
	 */
	public function check()
	{
		// Check for existing name
		$query = $this->_db->getQuery(true)
			->select($this->_db->quoteName('id'))
			->from($this->_db->quoteName('#__tlpportfolio_portfolio'))
			->where($this->_db->quoteName('title') . ' = ' . $this->_db->quote($this->title));
			
		$this->_db->setQuery($query);

		$xid = (int) $this->_db->loadResult();
		if ($xid && $xid != (int) $this->id)
		{
			$this->setError(JText::_('COM_TLPPORTFOLIO_EXIT_MESSAGE'));
			//$this->alias = $this->name.$this->id;
			return false;
		}
		
		if (empty($this->alias))
		{
		   $this->alias = $this->title;
		}
		$this->alias = JFilterOutput::stringURLSafe($this->alias);
		// If there is an ordering column and this is a new row then get the next ordering value
		if (property_exists($this, 'ordering') && $this->id == 0)
		{
			$this->ordering = self::getNextOrder();
		}

		return parent::check();
	}

	/**
	 * Method to set the publishing state for a row or list of rows in the database
	 * table.  The method respects checked out rows by other users and will attempt
	 * to checkin rows that it can after adjustments are made.
	 *
	 * @param   mixed    $pks     An optional array of primary key values to update.  If not
	 *                            set the instance property value is used.
	 * @param   integer  $state   The publishing state. eg. [0 = unpublished, 1 = published]
	 * @param   integer  $userId  The user id of the user performing the operation.
	 *
	 * @return   boolean  True on success.
	 *
	 * @since    1.0.4
	 *
	 * @throws Exception
	 */
	public function publish($pks = null, $state = 1, $userId = 0)
	{
		// Initialise variables.
		$k = $this->_tbl_key;

		// Sanitize input.
		ArrayHelper::toInteger($pks);
		$userId = (int) $userId;
		$state  = (int) $state;

		// If there are no primary keys set check to see if the instance key is set.
		if (empty($pks))
		{
			if ($this->$k)
			{
				$pks = array($this->$k);
			}
			// Nothing to set publishing state on, return false.
			else
			{
				throw new Exception(500, JText::_('JLIB_DATABASE_ERROR_NO_ROWS_SELECTED'));
			}
		}

		// Build the WHERE clause for the primary keys.
		$where = $k . '=' . implode(' OR ' . $k . '=', $pks);

		// Determine if there is checkin support for the table.
		if (!property_exists($this, 'checked_out') || !property_exists($this, 'checked_out_time'))
		{
			$checkin = '';
		}
		else
		{
			$checkin = ' AND (checked_out = 0 OR checked_out = ' . (int) $userId . ')';
		}

		// Update the publishing state for rows with the given primary keys.
		$this->_db->setQuery(
			'UPDATE `' . $this->_tbl . '`' .
			' SET `state` = ' . (int) $state .
			' WHERE (' . $where . ')' .
			$checkin
		);
		$this->_db->execute();

		// If checkin is supported and all rows were adjusted, check them in.
		if ($checkin && (count($pks) == $this->_db->getAffectedRows()))
		{
			// Checkin each row.
			foreach ($pks as $pk)
			{
				$this->checkin($pk);
			}
		}

		// If the JTable instance value is in the list of primary keys that were set, set the instance.
		if (in_array($this->$k, $pks))
		{
			$this->state = $state;
		}

		return true;
	}

	/**
	 * Define a namespaced asset name for inclusion in the #__assets table
	 *
	 * @return string The asset name
	 *
	 * @see JTable::_getAssetName
	 */
	protected function _getAssetName()
	{
		$k = $this->_tbl_key;

		return 'com_tlpportfolio.portfolio.' . (int) $this->$k;
	}

	/**
	 * Returns the parent asset's id. If you have a tree structure, retrieve the parent's id using the external key field
	 *
	 * @param   JTable   $table  Table name
	 * @param   integer  $id     Id
	 *
	 * @see JTable::_getAssetParentId
	 *
	 * @return mixed The id on success, false on failure.
	 */
	protected function _getAssetParentId(JTable $table = null, $id = null)
	{
		// We will retrieve the parent-asset from the Asset-table
		$assetParent = JTable::getInstance('Asset');

		// Default: if no asset-parent can be found we take the global asset
		$assetParentId = $assetParent->getRootId();

		// The item has the component as asset-parent
		$assetParent->loadByName('com_tlpportfolio');

		// Return the found asset-parent-id
		if ($assetParent->id)
		{
			$assetParentId = $assetParent->id;
		}

		return $assetParentId;
	}

	/**
	 * Delete a record by id
	 *
	 * @param   mixed  $pk  Primary key value to delete. Optional
	 *
	 * @return bool
	 */
	public function delete($pk = null)
	{
		$this->load($pk);
		$result = parent::delete($pk);
		
		
		if ($result)
		{
			jimport('joomla.filesystem.file');
			$result = JFile::delete(JPATH_ROOT . '/images/portfolio/' . $this->portfolio_image);
		}
		return $result;
	}

	public static function resizeImage($src_file, $dest_file, $max_width, $max_height, $method = 'gd2', $dest_qual = '95')
	{
		$imagetype = array( 1 => 'GIF', 2 => 'JPG', 3 => 'PNG', 4 => 'SWF', 5 => 'PSD', 6 => 'BMP', 7 => 'TIFF', 8 => 'TIFF', 9 => 'JPC', 10 => 'JP2', 11 => 'JPX', 12 => 'JB2', 13 => 'SWC', 14 => 'IFF');
		$imginfo = getimagesize($src_file);

		if ($imginfo == null) die("ERROR: Source file not found!");

		$imginfo[2] = $imagetype[$imginfo[2]];

		# GD can only handle JPG & PNG images
		if ($imginfo[2] != 'JPG' && $imginfo[2] != 'PNG'  && $imginfo[2] != 'GIF' && ($method == 'gd1' || $method == 'gd2')) die("ERROR: GD can only handle GIF, JPG and PNG files!");

		# height/width
		$srcWidth = $imginfo[0];
		$srcHeight = $imginfo[1];

		if( $srcWidth > $srcHeight ) {
			$ratio = $srcWidth / $max_width;
			$ratio = max($ratio, 1.0);
			$destWidth = (int)($srcWidth / $ratio);
			$destHeight = (int)($srcHeight / $ratio);
		} else {
			$ratio = $srcHeight / $max_height;
			$ratio = max($ratio, 1.0);
			$destWidth = (int)($srcWidth / $ratio);
			$destHeight = (int)($srcHeight / $ratio);
		}

		# Method for thumbnails creation
		switch ($method) {

			case "gd1" :

				if (!function_exists('imagecreatefromjpeg')) {
					die('GD image library not installed!');
				}
				if ($imginfo[2] == 'GIF')
					$src_img = imagecreatefromgif($src_file);
				else if ($imginfo[2] == 'JPG')
					$src_img = imagecreatefromjpeg($src_file);
				else
					$src_img = imagecreatefrompng($src_file);
				if (!$src_img){
					return false;
				}
				$dst_img = imagecreate($destWidth, $destHeight);
				imagecopyresized($dst_img, $src_img, 0, 0, 0, 0, $destWidth, (int)$destHeight, $srcWidth, $srcHeight);
				imagejpeg($dst_img, $dest_file, $dest_qual);
				imagedestroy($src_img);
				imagedestroy($dst_img);
				break;

			case "gd2" :

				$gdinfo = gd_info();
				if( empty($gdinfo['GD Version']) ) {
					die('GD2 image library not installed!');
				}

				if ($imginfo[2] == 'GIF')
					$src_img = imagecreatefromgif($src_file);
				else if ($imginfo[2] == 'JPG')
					$src_img = imagecreatefromjpeg($src_file);
				else
					$src_img = imagecreatefrompng($src_file);
				if (!$src_img){
					return false;
				}
				$dst_img = imagecreatetruecolor($destWidth, $destHeight);
				imagecopyresampled($dst_img, $src_img, 0, 0, 0, 0, $destWidth, (int)$destHeight, $srcWidth, $srcHeight);
				imagejpeg($dst_img, $dest_file, $dest_qual);
				imagedestroy($src_img);
				imagedestroy($dst_img);
				break;
		}

		# Set mode of uploaded picture
		chmod($dest_file, octdec('755'));

		# We check that the image is valid
		$imginfo = getimagesize($dest_file);
		if ($imginfo == null){
			return false;
		} else {
			return true;
		}
	}

	/*
    * Create Thumbnail
    */
    
    public  function createImage($src_file,$small_name,$medium_name,$large_name,
                                        $max_width_s,
                                        $max_height_s,
                                        $max_width_m,
                                        $max_height_m,
                                        $max_width_l,
                                        $max_height_l,
                                        $tag,
                                        $path,
                                        $orig_name)
            {
                ini_set('memory_limit', '200M');
                
                echo $src_file = urldecode($src_file);
                //exit;
                
                    $orig_name = strtolower($orig_name);
                    $findme  = '.jpg';
                    $pos = strpos($orig_name, $findme);
                    if ($pos === false)
                    {
                        $findme  = '.jpeg';
                        $pos = strpos($orig_name, $findme);
                        if ($pos === false)
                        {
                            $findme  = '.gif';
                            $pos = strpos($orig_name, $findme);
                            if ($pos === false)
                            {
                                $findme  = '.png';
                                $pos = strpos($orig_name, $findme);
                                if ($pos === false)
                                {
                                    return;
                                }
                                else
                                {
                                    $type = "png";
                                }
                            }
                            else
                            {
                                $type = "gif";
                            }
                        }
                        else
                        {
                            $type = "jpeg";
                        }
                    }
                    else
                    {
                        $type = "jpeg";
                    }
                //}
                
                $max_small_h = $max_height_s;
                $max_small_w = $max_width_s;
                $max_medium_h = $max_height_m;
                $max_medium_w = $max_width_m;
                $max_large_h = $max_height_l;
                $max_large_w = $max_width_l;
                
                if ( file_exists( "$path/$small_name")) {
                    unlink( "$path/$small_name");
                }
                
                if ( file_exists( "$path/$medium_name")) {
                    unlink( "$path/$medium_name");
                }
                
                if ( file_exists( "$path/$large_name")) {
                    unlink( "$path/$large_name");
                }
                
                $read = 'imagecreatefrom' . $type; 
                $write = 'image' . $type; 
                
                $src_img = $read($src_file);
                
                // height/width
                $imginfo = getimagesize($src_file);
                $src_w = $imginfo[0];
                $src_h = $imginfo[1];
                
                $zoom_h = $max_small_h / $src_h;
                $zoom_w = $max_small_w / $src_w;
                $zoom   = min($zoom_h, $zoom_w);
                $dst_small_h  = $zoom<1 ? round($src_h*$zoom) : $src_h;
                $dst_small_w  = $zoom<1 ? round($src_w*$zoom) : $src_w;
                
                $zoom_h = $max_medium_h / $src_h;
                $zoom_w = $max_medium_w / $src_w;
                $zoom   = min($zoom_h, $zoom_w);
                $dst_medium_h  = $zoom<1 ? round($src_h*$zoom) : $src_h;
                $dst_medium_w  = $zoom<1 ? round($src_w*$zoom) : $src_w;
                
                $zoom_h = $max_large_h / $src_h;
                $zoom_w = $max_large_w / $src_w;
                $zoom   = min($zoom_h, $zoom_w);
                $dst_large_h  = $zoom<1 ? round($src_h*$zoom) : $src_h;
                $dst_large_w  = $zoom<1 ? round($src_w*$zoom) : $src_w;
                
                
                $dst_s_img = imagecreatetruecolor($dst_small_w,$dst_small_h);
                $white = imagecolorallocate($dst_s_img,255,255,255);
                imagefill($dst_s_img,0,0,$white);
                imagecopyresampled($dst_s_img,$src_img, 0,0,0,0, $dst_small_w,$dst_small_h,$src_w,$src_h);
                $textcolor = imagecolorallocate($dst_s_img, 255, 255, 255);
                if (isset($tag))
                    imagestring($dst_s_img, 2, 2, 2, "$tag", $textcolor);
                if($type == 'jpeg'){
                    $desc_img = $write($dst_s_img,"$path/$small_name", 75);
                }else{
                    $desc_img = $write($dst_s_img,"$path/$small_name", 2);
                }
                
                
                $dst_m_img = imagecreatetruecolor($dst_medium_w,$dst_medium_h);
                $white = imagecolorallocate($dst_m_img,255,255,255);
                imagefill($dst_m_img,0,0,$white);
                imagecopyresampled($dst_m_img,$src_img, 0,0,0,0, $dst_medium_w,$dst_medium_h,$src_w,$src_h);
                $textcolor = imagecolorallocate($dst_m_img, 255, 255, 255);
                if (isset($tag))
                    imagestring($dst_m_img, 2, 2, 2, "$tag", $textcolor);
                if($type == 'jpeg'){
                    $desc_img = $write($dst_m_img,"$path/$medium_name", 75);
                }else{
                    $desc_img = $write($dst_m_img,"$path/$medium_name", 2);
                }
                
                $dst_l_img = imagecreatetruecolor($dst_large_w,$dst_large_h);
                $white = imagecolorallocate($dst_l_img,255,255,255);
                imagefill($dst_l_img,0,0,$white);
                imagecopyresampled($dst_l_img,$src_img, 0,0,0,0, $dst_large_w,$dst_large_h,$src_w,$src_h);

                $textcolor = imagecolorallocate($dst_l_img, 255, 255, 255);
                if (isset($tag))
                    imagestring($dst_l_img, 2, 2, 2, "$tag", $textcolor);
                if($type == 'jpeg'){
                    $desc_img = $write($dst_l_img,"$path/$large_name", 75);
                }else{
                    $desc_img = $write($dst_l_img,"$path/$large_name", 2);
                }
                
                
            
            }       

}


