<?php
/**
 * @version    1.0
 * @package    Com_Tlptestimonial
 * @author     RadiusTheme <support@radiustheme.com>
 * @copyright  Copyright (C) 2017. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT . '/helpers/html');
JHtml::_('behavior.tooltip');
JHtml::_('behavior.formvalidation');
JHtml::_('formbehavior.chosen', 'select');
JHtml::_('behavior.keepalive');
$tlptestimonial_params = JComponentHelper::getParams('com_tlptestimonial');
$image_storiage_path = $tlptestimonial_params->get('image_path','images/tlptestimonial');
// Import CSS
$document = JFactory::getDocument();
$document->addStyleSheet(JUri::root() . 'media/com_tlptestimonial/css/form.css');
?>
<script type="text/javascript">
	js = jQuery.noConflict();
	js(document).ready(function () {
		
	js('input:hidden.category').each(function(){
		var name = js(this).attr('name');
		if(name.indexOf('categoryhidden')){
			js('#jform_category option[value="'+js(this).val()+'"]').attr('selected',true);
		}
	});
	js("#jform_category").trigger("liszt:updated");
	});

	Joomla.submitbutton = function (task) {
		if (task == 'testimonial.cancel') {
			Joomla.submitform(task, document.getElementById('testimonial-form'));
		}
		else {
			
			if (task != 'testimonial.cancel' && document.formvalidator.isValid(document.id('testimonial-form'))) {
				
				Joomla.submitform(task, document.getElementById('testimonial-form'));
			}
			else {
				alert('<?php echo $this->escape(JText::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
			}
		}
	}
</script>

<form
	action="<?php echo JRoute::_('index.php?option=com_tlptestimonial&layout=edit&id=' . (int) $this->item->id); ?>"
	method="post" enctype="multipart/form-data" name="adminForm" id="testimonial-form" class="form-validate">

	<div class="form-horizontal">
		<?php echo JHtml::_('bootstrap.startTabSet', 'myTab', array('active' => 'general')); ?>

		<?php echo JHtml::_('bootstrap.addTab', 'myTab', 'general', JText::_('COM_TLPTESTIMONIAL_TITLE_TESTIMONIAL', true)); ?>
		<div class="row-fluid">
			<div class="span10 form-horizontal">
				<fieldset class="adminform">

				<input type="hidden" name="jform[id]" value="<?php echo $this->item->id; ?>" />
				<?php echo $this->form->renderField('name'); ?>
				<?php echo $this->form->renderField('alias'); ?>
				<?php echo $this->form->renderField('category'); ?>

			<?php
				foreach((array)$this->item->category as $value): 
					if(!is_array($value)):
						echo '<input type="hidden" class="category" name="jform[categoryhidden]['.$value.']" value="'.$value.'" />';
					endif;
				endforeach;
			?>	<?php echo $this->form->renderField('designation'); ?>
				<?php echo $this->form->renderField('company'); ?>
				<?php echo $this->form->renderField('location'); ?>
				<?php echo $this->form->renderField('profile_image'); ?>

				<?php if (!empty($this->item->profile_image)) : ?>
					<?php foreach ((array)$this->item->profile_image as $fileSingle) : ?>
						<?php if (!is_array($fileSingle)) : ?>
							<img class="img-responsive" src="<?php echo JURI::root().$image_storiage_path.'/s_'.$fileSingle; ?> " alt="<?php echo $fileSingle; ?>" style="width:60px;"/>
						<?php endif; ?>
					<?php endforeach; ?>
				<?php endif; ?>
				<input type="hidden" name="jform[profile_image_hidden]" id="jform_profile_image_hidden" value="<?php echo implode(',', (array)$this->item->profile_image); ?>" />				
				<?php echo $this->form->renderField('testimonial'); ?>
				<?php echo $this->form->renderField('language'); ?>
				<input type="hidden" name="jform[ordering]" value="<?php echo $this->item->ordering; ?>" />
				<input type="hidden" name="jform[state]" value="<?php echo $this->item->state; ?>" />
				<input type="hidden" name="jform[checked_out]" value="<?php echo $this->item->checked_out; ?>" />
				<input type="hidden" name="jform[checked_out_time]" value="<?php echo $this->item->checked_out_time; ?>" />

				<?php echo $this->form->renderField('created_by'); ?>

					<?php if ($this->state->params->get('save_history', 1)) : ?>
					<div class="control-group">
						<div class="control-label"><?php echo $this->form->getLabel('version_note'); ?></div>
						<div class="controls"><?php echo $this->form->getInput('version_note'); ?></div>
					</div>
					<?php endif; ?>
				</fieldset>
			</div>
		</div>
		<?php echo JHtml::_('bootstrap.endTab'); ?>

		

		<?php echo JHtml::_('bootstrap.endTabSet'); ?>

		<input type="hidden" name="task" value=""/>
		<?php echo JHtml::_('form.token'); ?>

	</div>
</form>
