<?php
/**
 * @version    1.0
 * @package    Com_Tlptestimonial
 * @author     RadiusTheme <support@radiustheme.com>
 * @copyright  Copyright (C) 2017. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.view');

/**
 * View class for a list of Tlptestimonial.
 *
 * @since  1.6
 */
class TlptestimonialViewTestimonials extends JViewLegacy
{
	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 *
	 * @param   string  $tpl  Template name
	 *
	 * @return void
	 *
	 * @throws Exception
	 */
	public function display($tpl = null)
	{
		$this->state = $this->get('State');
		$this->items = $this->get('Items');
		$this->pagination = $this->get('Pagination');

		// Check for errors.
		if (count($errors = $this->get('Errors')))
		{
			throw new Exception(implode("\n", $errors));
		}

		TlptestimonialHelpersTlptestimonialadmin::addSubmenu('testimonials');

		$this->addToolbar();

		$this->sidebar = JHtmlSidebar::render();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @return void
	 *
	 * @since    1.6
	 */
	protected function addToolbar()
	{
		$state = $this->get('State');
		$canDo = TlptestimonialHelpersTlptestimonialadmin::getActions();

		JToolBarHelper::title(JText::_('COM_TLPTESTIMONIAL_TITLE_TESTIMONIALS'), 'testimonials.png');

		// Check if the form exists before showing the add/edit buttons
		$formPath = JPATH_COMPONENT_ADMINISTRATOR . '/views/testimonial';

		if (file_exists($formPath))
		{
			if ($canDo->get('core.create'))
			{
				JToolBarHelper::addNew('testimonial.add', 'JTOOLBAR_NEW');

				if (isset($this->items[0]))
				{
					JToolbarHelper::custom('testimonials.duplicate', 'copy.png', 'copy_f2.png', 'JTOOLBAR_DUPLICATE', true);
				}
			}

			if ($canDo->get('core.edit') && isset($this->items[0]))
			{
				JToolBarHelper::editList('testimonial.edit', 'JTOOLBAR_EDIT');
			}
		}

		if ($canDo->get('core.edit.state'))
		{
			if (isset($this->items[0]->state))
			{
				JToolBarHelper::divider();
				JToolBarHelper::custom('testimonials.publish', 'publish.png', 'publish_f2.png', 'JTOOLBAR_PUBLISH', true);
				JToolBarHelper::custom('testimonials.unpublish', 'unpublish.png', 'unpublish_f2.png', 'JTOOLBAR_UNPUBLISH', true);
			}
			elseif (isset($this->items[0]))
			{
				// If this component does not use state then show a direct delete button as we can not trash
				JToolBarHelper::deleteList('', 'testimonials.delete', 'JTOOLBAR_DELETE');
			}

			if (isset($this->items[0]->state))
			{
				JToolBarHelper::divider();
				JToolBarHelper::archiveList('testimonials.archive', 'JTOOLBAR_ARCHIVE');
			}

			if (isset($this->items[0]->checked_out))
			{
				JToolBarHelper::custom('testimonials.checkin', 'checkin.png', 'checkin_f2.png', 'JTOOLBAR_CHECKIN', true);
			}
		}

		// Show trash and delete for components that uses the state field
		if (isset($this->items[0]->state))
		{
			if ($state->get('filter.state') == -2 && $canDo->get('core.delete'))
			{
				JToolBarHelper::deleteList('', 'testimonials.delete', 'JTOOLBAR_EMPTY_TRASH');
				JToolBarHelper::divider();
			}
			elseif ($canDo->get('core.edit.state'))
			{
				JToolBarHelper::trash('testimonials.trash', 'JTOOLBAR_TRASH');
				JToolBarHelper::divider();
			}
		}

		if ($canDo->get('core.admin'))
		{
			JToolBarHelper::preferences('com_tlptestimonial');
		}

		// Set sidebar action - New in 3.0
		JHtmlSidebar::setAction('index.php?option=com_tlptestimonial&view=testimonials');

		$this->extra_sidebar = '';                                                
        //Filter for the field category;
        jimport('joomla.form.form');
        $options = array();
        JForm::addFormPath(JPATH_COMPONENT . '/models/forms');
        $form = JForm::getInstance('com_tlptestimonial.testimonial', 'testimonial');

        $field = $form->getField('category');

        $query = $form->getFieldAttribute('filter_category','query');
        $translate = $form->getFieldAttribute('filter_category','translate');
        $key = $form->getFieldAttribute('filter_category','key_field');
        $value = $form->getFieldAttribute('filter_category','value_field');

        // Get the database object.
        $db = JFactory::getDbo();

        // Set the query and get the result list.
        $db->setQuery($query);
        $items = $db->loadObjectlist();

        // Build the field options.
        if (!empty($items))
        {
            foreach ($items as $item)
            {
                if ($translate == true)
                {
                    $options[] = JHtml::_('select.option', $item->$key, JText::_($item->$value));
                }
                else
                {
                    $options[] = JHtml::_('select.option', $item->$key, $item->$value);
                }
            }
        }

        JHtmlSidebar::addFilter(
            '$Category',
            'filter_category',
            JHtml::_('select.options', $options, "value", "text", $this->state->get('filter.category')),
            true
        );
        JHtmlSidebar::addFilter(
			JText::_("JOPTION_SELECT_LANGUAGE"),
			'filter_language',
			JHtml::_('select.options', JHtml::_("contentlanguage.existing", true, true), "value", "text", $this->state->get('filter.language'), true)
		);

		JHtmlSidebar::addFilter(

			JText::_('JOPTION_SELECT_PUBLISHED'),

			'filter_published',

			JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), "value", "text", $this->state->get('filter.state'), true)

		);
	}

	/**
	 * Method to order fields 
	 *
	 * @return void 
	 */
	protected function getSortFields()
	{
		return array(
			'a.`id`' => JText::_('JGRID_HEADING_ID'),
			'a.`name`' => JText::_('COM_TLPTESTIMONIAL_TESTIMONIALS_NAME'),
			'a.`category`' => JText::_('COM_TLPTESTIMONIAL_TESTIMONIALS_CATEGORY'),
			'a.`designation`' => JText::_('COM_TLPTESTIMONIAL_TESTIMONIALS_DESIGNATION'),
			'a.`company`' => JText::_('COM_TLPTESTIMONIAL_TESTIMONIALS_COMPANY'),
			'a.`location`' => JText::_('COM_TLPTESTIMONIAL_TESTIMONIALS_LOCATION'),
			'a.`profile_image`' => JText::_('COM_TLPTESTIMONIAL_TESTIMONIALS_PROFILE_IMAGE'),
			'a.`testimonial`' => JText::_('COM_TLPTESTIMONIAL_TESTIMONIALS_TESTIMONIAL'),
			'a.`ordering`' => JText::_('JGRID_HEADING_ORDERING'),
			'a.`state`' => JText::_('JSTATUS'),
		);
	}
}
