<?php
/**
 * @version    2.0
 * @package    com_tlpportfolio
 * @author     TechLabPro <info@techlabpro.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
// No direct access
defined( '_JEXEC' ) or die;

jimport( 'joomla.application.component.controller' );

/**
 * Class TlpportfolioController
 *
 * @since  1.6
 */
class TlpportfolioController extends JControllerLegacy {
	/**
	 * Method to display a view.
	 *
	 * @param   boolean $cachable If true, the view output will be cached
	 * @param   mixed $urlparams An array of safe url parameters and their variable types, for valid values see {@link JFilterInput::clean()}.
	 *
	 * @return  JController   This object to support chaining.
	 *
	 * @since    1.5
	 */
	public function display( $cachable = false, $urlparams = false ) {
		require_once JPATH_COMPONENT . '/helpers/tlpportfolio.php';

		$view = JFactory::getApplication()->input->getCmd( 'view', 'portfolios' );
		JFactory::getApplication()->input->set( 'view', $view );

		parent::display( $cachable, $urlparams );

		return $this;
	}

	public function portfolioSingleItem() {
		$tlpportfolio_params   = JComponentHelper::getParams( 'com_tlpportfolio' );
		$image_storiage_path   = $tlpportfolio_params->get( 'image_path', 'images/tlpportfolio/' );
		$enable_social_share   = $tlpportfolio_params->get( 'enable_social_share', '' );
		$image_storiage_folder = JURI::root() . $image_storiage_path . '/';

		$jinput = JFactory::getApplication()->input;
		$data   = $jinput->post->getArray( array() );
		$id     = (int) $data['id'];
		$html   = null;
		if ( $id ) {

			$db    = JFactory::getDbo();
			$query = $db->getQuery( true );
			$query
				->select( 'a.*,c.title as category_title' )
				->from( '#__tlpportfolio_portfolio a' );

			$query->where( "a.id = $id" );

			$query->join( 'LEFT', '#__categories AS c ON c.id = a.category' );
			// echo  $query;

			$db->setQuery( $query );
			$item = $db->loadObject();

			//tools
			$values = ( is_array( $item->tools_used ) ) ? $item->tools_used : explode( ',', $item->tools_used );

			$textValue = array();
			foreach ( $values as $value ) {
				$db    = JFactory::getDbo();
				$query = $db->getQuery( true );
				$query
					->select( 'title' )
					->from( '`#__tlpportfolio_tools`' )
					->where( 'id = ' . $item->id );
				$db->setQuery( $query );
				$results = $db->loadObject();
				if ( $results ) {
					$textValue[] = $results->title;
				}
			}

			$tools_used = ! empty( $textValue ) ? implode( ', ', $textValue ) : $item->tools_used;
			// end tools
			// Start Tags
			if ( isset( $item->tags ) ) {
				// Catch the item tags (string with ',' coma glue)
				$tags = explode( ",", $item->tags );

				$db        = JFactory::getDbo();
				$namedTags = array(); // Cleaning and initalization of named tags array

				// Get the tag names of each tag id
				foreach ( $tags as $tag ) {

					$query = $db->getQuery( true );
					$query->select( "title" );
					$query->from( '`#__tags`' );
					$query->where( "id=" . intval( $tag ) );

					$db->setQuery( $query );
					$row = $db->loadObjectList();

					// Read the row and get the tag name (title)
					if ( ! is_null( $row ) ) {
						foreach ( $row as $value ) {
							if ( $value && isset( $value->title ) ) {
								$namedTags[] = trim( $value->title );
							}
						}
					}

				}

				// Finally replace the data object with proper information
				if ( ! empty( $namedTags ) ) {
					$tags = implode( ', ', $namedTags );
				} else {
					$tags = ! empty( $item->my_tags ) ? ( $item->my_tags ) : ( "" );
				}
			}
			//end Tags
			//Related Project
			$textValue = array();
			if ( isset( $item->related_projects ) && $item->related_projects != '' ) {

				$values = ( is_array( $item->related_projects ) ) ? $item->related_projects : explode( ',', $item->related_projects );

				foreach ( $values as $value ) {
					$db    = JFactory::getDbo();
					$query = $db->getQuery( true );
					$query
						->select( 'id,title,portfolio_image' )
						->from( '`#__tlpportfolio_portfolio`' )
						->where( 'id = ' . $db->quote( $db->escape( $value ) ) . '' );
					$db->setQuery( $query );
					$results = $db->loadObject();
					if ( $results ) {
						$textValue[] = array(
							'id'    => $results->id,
							'img'   => $results->portfolio_image,
							'title' => $results->title
						);

					}
				}
			}
			$pLink = JRoute::_( 'index.php?option=com_tlpportfolio&view=portfolio&id=' . (int) $item->id );

			//End Related Project

			if ( $item ) {
				$html .= '<div class="container tlp-portfolio-detail">';
				$html .= '<div class="row">';
				$html .= '<h2>' . $item->title . '</h2>';
				$html .= '<div class="col-md-12 col-lg-12 col-sm-12 image-area">';
				$html .= '<div class="item_fields single-portfolio">';
				$html .= "<div class='portfolio-slider'>";
				$image_ids = isset( $item->pgallery ) ? ( $item->pgallery ? explode( ',', $item->pgallery ) : array() ) : array();
				if ( $item->portfolio_image ) {
					array_unshift( $image_ids, 'l_' . $item->portfolio_image );
				}
				if ( ! empty( $image_ids ) && is_array( $image_ids ) ) {

					$html .= '<div id="single-page-slider" class="owl-carousel owl-theme">';
					foreach ( $image_ids as $img ) {
						$html .= "<div><img src='{$image_storiage_folder}{$img}' /></div>";
					}
					$html .= '</div>';


				}
				$html .= "</div>";
				$html .= '</div>';
				$html .= "</div>";
				$html .= '<div class="tlp-col-md-8 tlp-col-lg-8 tlp-col-sm-6 desc-area">';
				$html .= '<h3>' . JText::_( 'COM_TLPPORTFOLIO_PROJECT_DESCRIPTION' ) . '</h3>';
				$html .= $item->description;
				if($enable_social_share==1){
				$html .= "<div class='single-portfolio-share'>
                        <div class='fb-share'>
                            <div class='fb-share-button' data-href='{$pLink}' data-layout='button_count'></div>
                        </div>
                        <div class='twitter-share'>
                            <a href='{$pLink}' class='twitter-share-button'{count} data-url='https://about.twitter.com/resources/buttons#tweet'>Tweet</a>
                        </div>
                        <div class='googleplus-share'>
                            <div class='g-plusone'></div>
                        </div>
                        <div class='linkedin-share'>
                            <script type='IN/Share' data-counter='right'></script>
                        </div>
                        <div class='linkedin-share'>
                            <a data-pin-do='buttonPin' data-pin-count='beside' href='https://www.pinterest.com/pin/create/button/?url=https%3A%2F%2Fwww.flickr.com%2Fphotos%2Fkentbrew%2F6851755809%2F&media=https%3A%2F%2Ffarm8.staticflickr.com%2F7027%2F6851755809_df5b2051c9_z.jpg&description=Next%20stop%3A%20Pinterest'><img src='//assets.pinterest.com/images/pidgets/pinit_fg_en_rect_gray_20.png' /></a>
                        </div>
                   </div>";
				$html .= '<div id="fb-root"></div>
                <script>(function(d, s, id) {
                    var js, fjs = d.getElementsByTagName(s)[0];
                        if (d.getElementById(id)) return;
                        js = d.createElement(s); js.id = id;
                        js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.5";
                        fjs.parentNode.insertBefore(js, fjs);
                    }(document, "script", "facebook-jssdk"));</script>';
				$html .= "<script>!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');</script>
                <script>window.___gcfg = { lang: 'en-US', parsetags: 'onload', };</script>";
				$html .= "<script src='https://apis.google.com/js/platform.js' async defer></script>";
				$html .= '<script src="//platform.linkedin.com/in.js" type="text/javascript"> lang: en_US</script>';
				$html .= '<script async defer src="//assets.pinterest.com/js/pinit.js"></script>';

				$html .= "</div>";
				}
				$html .= '<div class="tlp-col-md-4 tlp-col-lg-4 tlp-col-sm-6 attribute-area">';
				$html .= '<h3>' . JText::_( 'COM_TLPPORTFOLIO_PROJECT_DETAIL' ) . '</h3>';
				$html .= '<div class="detail-page-items">';
				$html .= '<ul>';
				$html .= '<li><label>' . JText::_( 'COM_TLPPORTFOLIO_FORM_LBL_PORTFOLIO_CATEGORY' ) . ': </label>&nbsp;' . $item->category_title . '</li>';
				$html .= '<li><label>' . JText::_( 'COM_TLPPORTFOLIO_FORM_LBL_PORTFOLIO_TOOLS_USED' ) . ': </label>&nbsp;' . $tools_used . '</li>';
				$html .= '<li><label>' . JText::_( 'COM_TLPPORTFOLIO_FORM_LBL_PORTFOLIO_PROJECT_URL' ) . ': </label>&nbsp;<a href="' . $item->project_url . '" target="_blank">' . $item->project_url . '</a></li>';
				$html .= '<li><label>' . JText::_( 'COM_TLPPORTFOLIO_FORM_LBL_PORTFOLIO_CLIENT_NAME' ) . ': </label>&nbsp;' . $item->client_name . '</li>';
				$html .= '<li><label>' . JText::_( 'COM_TLPPORTFOLIO_FORM_LBL_PORTFOLIO_COMPLETED_DATE' ) . ': </label>&nbsp;' . $item->completed_date . '</li>';
				$html .= '</ul>';
				$html .= "</div>";
				$html .= "</div>";
				$html .= "</div>";
				if ( $item->related_projects ) {
					$html .= '<div class="tlp-row">';
					$html .= '<div class="related-project">';
					$html .= '<h3 class="title">' . JText::_( 'COM_TLPPORTFOLIO_PROJECT_RELATED' ) . '</h3>';

					foreach ( $textValue as $rproject ) {
						$html .= "<div class='tlp-col-md-3 tlp-col-lg-3 tlp-col-sm-6'>";
						@$sid = $rproject['id'];
						$detail_link = JRoute::_( 'index.php?option=com_tlpportfolio&view=portfolio&id=' . (int) $sid );

						@$img = $rproject['img'];
						$html .= "<img src='$image_storiage_folder" . 'm_' . "$img' >";

						$html .= '<h3><a href="' . $detail_link . '">' . $rproject['title'] . '</a></h3>';

						$html .= '</div>';
					}
					$html .= '</div>';
					$html .= '</div>';
				}
				$html .= '</div>';
				$html .= "<script>(function($){ 
							    $(document).ready(function(){
								  loadPortfolioSingleSlider();
					            });
						})(jQuery);</script>";
			} else {
				$html .= JText::_( 'COM_TLPPORTFOLIO_ITEM_NOT_LOADED' );
			}
			echo $html;
		}
	}
}

