<?php

/**
 * @package     Joomla.Plugin
 * @subpackage  content
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;
$app = JFactory::getApplication();
$tlpportfolio_params = JComponentHelper::getParams('com_tlpportfolio');

$enable_font_awsame = $tlpportfolio_params->get('enable_font_awsame');


require_once JPATH_SITE . '/components/com_tlpportfolio/router.php';
$document = JFactory::getDocument();

$document->addStyleSheet('components/com_tlpportfolio/assets/css/tlpportfolio.css');

if($enable_font_awsame==1){
    $document->addStyleSheet('components/com_tlpportfolio/assets/css/font-awesome.min.css');
}
/**
 * Content search plugin.
 *
 * @package     Joomla.Plugin
 * @subpackage  Search.content
 * @since       1.6
 */
class PlgContentTlpportfolio extends JPlugin {


    /**
     * Load the language file on instantiation.
     *
     * @var    boolean
     * @since  3.1
     */
    protected $autoloadLanguage = true;

    public $configs = null;

    function __construct( &$subject, $params ) {
        parent::__construct( $subject, $params );
    }

    /**
     * Plugin that retrieves contact information for contact
     *
     * @param   string   $context  The context of the content being passed to the plugin.
     * @param   mixed    &$row     An object with a "text" property
     * @param   mixed    $params   Additional parameters. See {@see PlgContentContent()}.
     * @param   integer  $page     Optional page number. Unused. Defaults to zero.
     *
     * @return  boolean True on success.
     */
    public function onContentPrepare($context, &$article, &$params, $page = 0)
    {

        $allowed_contexts = array('com_content.category', 'com_content.article', 'com_content.featured', 'mod_custom.content');

        if (!in_array($context, $allowed_contexts))
        {
            return true;
        }

        // Simple performance check to determine whether bot should process further
        if (strpos($article->text, 'tlpportfolio') === false && strpos($article->text, 'tlpportfolio') === false)
        {
            return true;
        }

        JFactory::getLanguage()->getTag();
        $multilang=JLanguageMultilang::isEnabled();

        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $document = JFactory::getDocument();
        $app = JFactory::getApplication();
        $tlpportfolio_params = JComponentHelper::getParams('com_tlpportfolio');
        $image_storiage_path = $tlpportfolio_params->get('image_path','images/tlpportfolio');
        $link_detail = $tlpportfolio_params->get('link_detail','1');
        $bootstrap_version = $tlpportfolio_params->get('bootstrap_version','1');
        $enable_font_awsame = $tlpportfolio_params->get('enable_font_awsame');
        $enable_social_share = $tlpportfolio_params->get('enable_social_share');
        $link_type = $tlpportfolio_params->get('link_type');
        $image_grid = $tlpportfolio_params->get('image_grid');
        $create_date_format = $tlpportfolio_params->get('create_date_format');

        $layout = $tlpportfolio_params->get('g_layout');
        $display_no = $tlpportfolio_params->get('g_display_no');
        $grid_type = $tlpportfolio_params->get('g_grid_type');
        $item_to_item_margin = $tlpportfolio_params->get('g_item_to_item_margin');
        $image_style = $tlpportfolio_params->get('g_image_style');
        $primary_color = $tlpportfolio_params->get('g_primary_color');
        $overlay_color = $tlpportfolio_params->get('g_overlay_color');
        $overlay_opacity = $tlpportfolio_params->get('g_overlay_opacity');
        $project_name_font_size = $tlpportfolio_params->get('g_project_name_font_size');
        $project_name_font_color = $tlpportfolio_params->get('g_project_name_font_color');
        $project_name_text_align = $tlpportfolio_params->get('g_project_name_text_align');
        $short_desc_font_size = $tlpportfolio_params->get('g_short_desc_font_size');
        $short_desc_font_color = $tlpportfolio_params->get('g_short_desc_font_color');
        $short_desc_text_align = $tlpportfolio_params->get('g_short_desc_text_align');
        $icon_font_size = $tlpportfolio_params->get('g_icon_font_size');
        $icon_font_color = $tlpportfolio_params->get('g_icon_font_color');
        //field control
        $project_name_field = $tlpportfolio_params->get('g_project_name_field');
        $short_desc_field = $tlpportfolio_params->get('g_short_desc_field');
        $tools_field = $tlpportfolio_params->get('g_tools_field');
        $category_field = $tlpportfolio_params->get('g_category_field');
        $client_field = $tlpportfolio_params->get('g_client_field');
        $project_url_field = $tlpportfolio_params->get('g_project_url_field');

        // Expression to search for(tlpportfolio id)
        $regex = '/{tlpportfolio\s*.*?}/i';
        // find all instances of mambot and put in $matches
        preg_match_all($regex, $article->text, $matches_v, PREG_SET_ORDER);
        //if we have mambot on txt replace them
        // No matches, skip this 
          foreach($matches_v as $match){
            $matches_v = $match[0];
                $matches_v = str_replace("{", "", $matches_v);
                $matches_v = str_replace("}", "", $matches_v);
                $search = explode(" ", $matches_v);

              //print_r($search);
                //Array ( [0] => team [1] => id=1 )
                foreach($search as $s_row => $s_value){
                    $final = explode("=",$s_value);
                    if(isset($final[1])){
                        $replace[$final[0]] = $final[1];
                    }
                }

                $whereQ = null;
                $memberIds = explode(',', $replace['id']);
                //print_r($memberIds);
                $i= 1; 
                foreach ($memberIds as $id) {
                    $or = ($i > 1 ? "OR " : null);
                    $whereQ .= " $or a.id = '$id' "; 
                    $i++;
                }
                //$detail_link='mmmmm';
                // Select the required fields from the table.
                $query->select( 'DISTINCT a.*,c.title AS category_title');
                $query->from('`#__tlpportfolio_portfolio` AS a');
                // Join over the category 'category'
                $query->join('LEFT', '#__categories AS c ON c.id = a.category');
                
                $query->where($whereQ);

                // Filter by language
                if ($multilang)
                {
                    $query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
                }

                //$query = "SELECT * FROM #__tlpteam_team WHERE $whereQ";
                $db->setQuery($query);
                $items = $db->loadObjectList();
                //echo $query;
                //echo $items=count($item_total);
               // echo $limit = $this->params->def('search_limit', 50);
                 $output = null;
                 $output .='<div class="row plg-tlp-portfolio tlp-portfolio ">';
                 $output .='<div class="layout5">';
               foreach($items as $item){
                $detail_link=JRoute::_('index.php?option=com_tlpportfolio&view=portfolio&id='.(int) $item->id);
                $output .='<div class="tlp-col-lg-4 tlp-col-md4 col-md-4 span4">';
                
                $output .='<div class="tlp-portfolio-item">
                   <div class="tlp-portfolio-thum">  
                       <figure>';
                $output .='<img class="tlp-img-responsive" src="'.JURI::root().$image_storiage_path.'/m_'.$item->portfolio_image.'" alt="'. $item->title.'"/> ';            
                $output .='</figure>
                   </div>
                   <div class="tlp-overlay">
                     <div class="tlp-title">';
                       if($link_detail==1){
                $output .='<h3><a href="'.$detail_link.'">'. substr($item->title,0, 33).'</a></h3>';
                        }else{
                            $output .='<h3>'.substr($item->title,0, 33) .'</h3>';
                        }
                     $output .='</div>';

                     $output .='<div class="tlp-content">';  
                          if(($short_desc_field==1)&&($item->short_description!='')){
                    $output .='<p class="description">'. substr($item->short_description,0,150).'</p>';
                          }
                       if(($category_field==1)&&($item->category_title!='')){
                     $output .='<p class="description">'.$item->category_title.'</p>';
                          }
                          if(($tools_field==1)&&($item->tools_used!='')){
                    $output .='<p class="description">'. TlpportfolioFrontendHelper::getTools($item->tools_used).'</p>';
                           }
                    $output .='<p class="link-icon">';
                            if($link_detail==1){
                    $output .='<a href="'. $detail_link.'"><i class="fa fa-info"></i></a>';
                            }
                   if(($project_url_field==1)&&($item->project_url)){
                     $output .='<a href="'.$item->project_url.'" target="_blank"><i class="fa fa-external-link"></i></a> '; 
                             }
                     $output .='</div>';   
                   $output .='</div>
               </div>';
                $output .='</div>';
             }
                $output .='</div>';
 $output .='</div>';  


                 $matchesfull = '{'. $matches_v . '}';
                // We should replace only first occurrence in order to allow positions with the same name to regenerate their content:
                $article->text = preg_replace("|$matchesfull|", $output, $article->text, 1);
        }

        
        
    }

}
