<?php
/*
	*	
	* OxyClassifieds.com : PHP Classifieds (http://www.oxyclassifieds.com)
	* version 8
	* (c) 2014 OxyClassifieds.com (office@oxyclassifieds.com).
	*
*/

class seo {

	var $links;

	function seo() {

	global $sef_links, $sef_links_aliases, $sef_fields_aliases, $keyword_name;
	$this->links = $sef_links;

	$this->keyword = $keyword_name;
	
	}

	function init(&$smarty) {

		$smarty->assign("sef_links", $this->links);
		$smarty->assign("sef_keyword", $this->keyword);

	}

	// make a SEF search category page
	// used for: first page category display links, categories path links
	function makeSearchCategoryLink ($id, $name='') {

		global $config_live_site;
		if(!$name) $name = cleanHtml(categories::getName($id));
		$search_link = $config_live_site."/".$id."-"._urlencode($name)."/".$this->links["listings"];
		return $search_link;
	}

	// make a SEF search link for 1 or 2 key - value pairs
	// used for: tag cloud, browse by location and browse by make modules links
	function makeKeyValueLink ($key, $value, $key2='', $value2='') {

		global $config_live_site, $settings;
		$kv1 = $kv2 = '';
		if($settings['enable_subdomains'] && ($key==$settings['subdomain_field'] || $key2==$settings['subdomain_field'])) {
		    $loc = new locations;
		    global $main_domain;
		    if($key==$settings['subdomain_field']) {
			$loc_val = $value;
			if($key2 && $value2) $kv2 = "/".$key2."-".rawurlencode(trim($value2));
		    }
		    else {
			$loc_val = $value2;
			if($key && $value) $kv2 = "/".$key."-".rawurlencode(trim($value));
		    
		    }
		    $search_link = "http://".$loc->buildLocationSubdomain($loc_val).".".$main_domain.$kv2."/".$this->links["listings"];
		    return $search_link;
		}

		$kv1 = "/".$key."-".rawurlencode(trim($value));
		if($key2 && $value2) $kv2 = "/".$key2."-".rawurlencode(trim($value2));
		$search_link = $config_live_site.$kv1.$kv2."/".$this->links["listings"];
		return $search_link;

	}

	// make a SEF search page link using the search array values
	function makeSearchLink($search_array, $page=1, $exclude_str = '', $current = '', $category_name='') {

		// $search array
		// $exclude_str (page|category|xxx)
		// $page
		// $current ##$current## - for delete links

		global $config_live_site;
		$current_str = "";
		if($current) $current_str = "##$current##/";
		$exclude_array = array(); 
		if($exclude_str) $exclude_array = explode("|", $exclude_str);

		// start assembling the search string
		$refine_search_link = $config_live_site."/";

		if(isset($search_array) && $search_array) {

			// if category
			if(isset($search_array['category']) && $search_array['category'] && $current != "cat") { 
				global $config_abs_path;
				require_once $config_abs_path."/classes/categories.php";
				if(!$category_name) $category_name = cleanHtml(categories::getName($search_array['category']));
				$refine_search_link.=$search_array['category']."-"._urlencode($category_name)."/";
			}

			global $settings;
			$array_loc = explode(",", $settings['location_fields']);

			foreach($search_array as $key => $value) {
				if($key=="category" || $key=="cat" || $key=="show") continue;
				if($value=='' || in_array($key, $exclude_array)) continue;
				if(($key=="order" && $value=="date_added") || ($key=="order_way" && $value=="desc")) continue;
				if($value=='' && $key!="area") continue;
				if($settings['enable_locations'] && in_array($key, $array_loc)) continue;
				if($settings['enable_locations'] && $key=="crt_city") continue;

				$refine_search_link .= $key."-"._urlencode( str_replace("/", "_", $value), 0)."/";

			}
	
		} // end if $search_array
	//echo $refine_search_link;
	//exit(0);

		// if delete link
		$refine_search_link .= $current_str;

		// add page 
		if($page>1) $refine_search_link .= $page."/";
		$refine_search_link .= $this->links["listings"];

		return $refine_search_link;

	}

	// SEF search pages links
	// used on paginator
	function makeSearchPagesLink() {

		global $config_live_site, $settings;
		$current_page = 1;
		$pag_array = array("pages_link" => "", "order_by_link" =>"", "order_way_link" => "", "crt_page_link" => "", "show_link" => "", "order_by" => "", "order_way" => "", "page" => "1");
		$search_array = array();

		// make search array
		if($_SERVER['QUERY_STRING'])
		{
			$i=0;

			$query_string = $_SERVER['QUERY_STRING'];
			$args_arr = explode("&", $_SERVER['QUERY_STRING']);
			foreach ($args_arr as $a) {
				if(strstr($a, "listings.html"))  {$query_string = $a; break; }
			}
		
			$args = explode("/", $query_string);


			$get_array = array();
			foreach($args as $arg)
			{
				// page will stand out as a numeric value separately written
				if(is_numeric($arg)) { 
					$pag_array["page"] = $arg; 
					$i++; continue; 
				}

				// if the first argument, check if category is set
				if($i==0) {
					$keyval = explode("-",$arg,2);
					if(is_numeric($keyval[0])) { 
						$search_array['category'] = $keyval[0]; 
						$search_array['category_name'] = $keyval[1];
						$i++; 
						continue; 
					}
				}

				$keyval = explode("-",$arg,2);
		
				if(count($keyval)>1) {
					$key = $keyval[0];
					if($key=="show") continue;
					$value = rawurlencode($keyval[1]); // 
					$search_array[$key] = $value;
					$i++;
				}
			}
		}

		$pag_array['crt_page_link'] =  $pag_array['pages_link'] = $pag_array['order_by_link'] = $pag_array['order_way_link'] = $pag_array['show_link'] = $config_live_site."/";

		// add category to url
		if( isset($search_array['category']) && $search_array['category']) { 
			$str = $search_array['category']."-".$search_array['category_name']."/";
			$pag_array['crt_page_link'].=$str;
			$pag_array['pages_link'].=$str;
			$pag_array['order_by_link'].=$str;
			$pag_array['order_way_link'].=$str;
			$pag_array['show_link'].=$str;
		}

		// add the rest of search values
		foreach($search_array as $key=>$value) {

			if($key=="category" || $key=="category_name" || $key=="page") continue;
			$pag_array['pages_link'].="$key-$value/";
			$pag_array['crt_page_link'].= "$key-$value/";
			$pag_array['show_link'].="$key-$value/";
			if($key!="order") $pag_array['order_by_link'].="$key-$value/";
			if($key!="order_way") $pag_array['order_way_link'].="$key-$value/";

			if($key=="order_way") $pag_array['order_way'] = $value;
			if($key=="order") $pag_array['order_by'] = $value;

		}

		$pag_array['order_by_link'].="order-##order##/";
		$pag_array['order_way_link'].="order_way-##order_way##/";
		$pag_array['show_link'].="show-##show##/";

		// add page to url
		if($current_page!=1) {
			$pag_array['crt_page_link'].=$pag_array["page"]."/";
			$pag_array['order_by_link'].=$pag_array["page"]."/";
			$pag_array['order_way_link'].=$current_page."/";
			$pag_array['show_link'].=$current_page."/";
		}
		$pag_array['pages_link'].="##page##/";

		// add html page name
		$pag_array['crt_page_link'].=$this->links["listings"];
		$pag_array['pages_link'].=$this->links["listings"];
		$pag_array['order_by_link'].=$this->links["listings"];
		$pag_array['order_way_link'].=$this->links["listings"];
		$pag_array['show_link'].=$this->links["listings"];

		return $pag_array;

	}

	// SEF details page link 
	function makeDetailsLink($id, $title='') {

		if(isset($title) && $title) $url_title = _urlencode($title);
		else { 
			global $config_abs_path;
			require_once $config_abs_path."/classes/listings.php";
			$url_title = listings::getUrlTitle($id);
		}

		global $config_live_site;
		$details_link=$config_live_site."/".$id."-".$url_title."/".$this->links["details"];

		return $details_link;
	}


	// SEF subdomain details page link 
	function makeSubdomainDetailsLink($id, $title='', $subdomain='', $cannonical=0) {

		if($title) $url_title = _urlencode($title);
		else $url_title = listings::getUrlTitle($id);

		$cloc = new locations();
		if($subdomain) $url_subdomain = $cloc->buildLocationSubdomain($subdomain);
		else {
			global $db; 
			$url_subdomain = $db->fetchRow("select `{$settings['location_subdomain']}` from ".TABLE_ADS." where id='$id'");
		}

		global $config_live_site;

		// check if not added already
		if(stristr($config_live_site, $url_subdomain)) {
			// if subdomain is included cannonical url is not needed
			if($cannonical)  return '';
			
			$subdomain_link = $config_live_site;
		}
		else {
			if(stristr($config_live_site, "www"))
				$subdomain_link = str_replace("http://www.", "http://".$url_subdomain.".", $config_live_site);
			else 
				$subdomain_link = str_replace("http://", "http://".$url_subdomain.".", $config_live_site);
		}
		
		$details_link=$subdomain_link."/".$id."-".$url_title."/".$this->links["details"];

		return $details_link;
	}

	// SEF dealer page link
	function makeDealerLink($id, $dealer_name='', $page='', $canonical=0) {

		if($dealer_name) $url_dealer = _urlencode($dealer_name);
		else $url_dealer = _urlencode(users::getContactName($id));

		global $config_live_site;
		$site_url = $config_live_site;
		if($canonical) { global $main_domain; $site_url = "http://".$main_domain; }

		$page_str="";
		if($page) $page_str=$page."/";
		$dealer_link=$site_url."/".$id."-".$url_dealer."/".$page_str.$this->links["store"];

		return $dealer_link;

	}

	// SEF dealer page link
	function makeUserListingsLink($id, $dealer_name='', $page='', $canonical=0) {

		if($dealer_name) $url_dealer = _urlencode($dealer_name);
		else $url_dealer = _urlencode(users::getContactName($id));

		global $config_live_site;
		$site_url = $config_live_site;
		if($canonical) { global $main_domain; $site_url = "http://".$main_domain; }
		$page_str="";
		if($page) $page_str=$page."/";
		$dealer_link=$site_url."/".$id."-".$url_dealer."/".$page_str.$this->links["user_listings"];

		return $dealer_link;

	}

	// SEF contact details page link
	function makeUserDetailLink($id, $contact_name='', $canonical=0) {

		global $config_live_site;
		$site_url = $config_live_site;
		if($canonical) { global $main_domain; $site_url = "http://".$main_domain; }

		if($contact_name) $url_contact = _urlencode($contact_name);
		else $url_contact = _urlencode(users::getContactName($id));
		$contact_link=$site_url."/".$id."-".$url_contact."/".$this->links["contact_details"];

		return $contact_link;

	}

	// SEF affiliate link
	function makeAffiliateLink($user_id, $affiliate_id='') {

		if(!$affiliate_id) $affiliate_id = users::getAffiliateId($user_id);
		global $config_live_site, $seo_settings;
		$link = $config_live_site."/";
		if($seo_settings['enable_mod_rewrite']) $link.="aff-".$affiliate_id;
		else $link.="?aff=".$affiliate_id;
		
		return $link;
	}


	// set meta info 
	function setMetaInfo($crt_page, $smarty) {

		global $page_info, $seo_settings, $settings, $cat, $meta_format;

		// get meta information pattern
		// will be used to get the page meta information, based on the current page type
		$meta_formats = common::getCachedObject("base_meta_info");

		// only content pages don't need processing
		if( !isset($meta_formats[$crt_page]) && $crt_page!="content") {

			$page_info=array( 'title' => '', 'meta_keywords' => '', 'meta_description' => '', 'canonical' => '', 'noindex' => '', 'canonical' => '' );
			$smarty->assign("page_info",$page_info);
			return;
		}

		if($crt_page!="content") {

			$meta_format = $meta_formats[$crt_page];
			$smarty->assign("seo_settings",$seo_settings);

			$page_info = $meta_format;

		}

		if(!isset($page_info['title'])) $page_info['title']=$settings['site_name'];
		if(!isset($page_info['meta_keywords'])) $page_info['meta_keywords']='';
		if(!isset($page_info['meta_description'])) $page_info['meta_description']='';
		if(!isset($page_info['noindex'])) $page_info['noindex'] = '';
		if(!isset($page_info['canonical'])) $page_info['canonical'] = ''; 


		// set location values first
		$page_info = $this->replaceLocationMetaInfo();

		switch($crt_page) {
			case "details":
				if(!isset($_GET['id']) || !is_numeric($_GET['id'])) break;
				$page_info = $this->getListingMetaInfo(escape($_GET['id']));
				break;

			case "listings":
				$page_info= $this->getSearchMetaInfo();
				break;

			case "content":

				if(!isset($_GET['id']) || !is_numeric($_GET['id'])) break;
				// get page content meta info
				$page_info = $this->getCustomPageMetaInfo(escape($_GET['id']));
				break;

			case "index":

				if($cat) {
					$page_info = $this->getCategoryMetaInfo($cat);
				}

				break;

			case "recent_ads":
				$page_info = $this->getRecentAdsMetaInfo();
				break;

			case "contact_details":
			case "store":
			case "user_listings":

				if(!isset($_GET['id']) || !is_numeric($_GET['id'])) break;
				$page_info = $this->getUserPageMetaInfo(escape($_GET['id']));
				break;

			case "login":
			case "register":
			case "pre-register":
			case "pre-submit":
			case "refine":
			case "notfound":
			case "contact":
			case "favorites":

				// no replacements needed, use the default meta info

				// canonical
				$canonical_subdomains = 0;
				if($settings['enable_locations'] && $settings['enable_subdomains'] && isset($_GET['crt_city']) && $_GET['crt_city']) $canonical_subdomains = 1;
				if($canonical_subdomains) { 

					global $main_domain, $sef_links; 
					$site_url = "http://".$main_domain; 

					if($seo_settings['enable_mod_rewrite']) {
						$page_info['canonical'] = $site_url."/".$sef_links[$crt_page];

					} else 

						$page_info['canonical'] = $site_url."/".$crt_page.".php";

				} // end canonical subdomains

				break;

			default:
				break;

		}

		if($crt_page!="content") {
			// clean invalid %key tags
			$page_info = $this->cleanMetaInfo();
		}

		$smarty->assign("page_info",$page_info);

	}

	// set meta info for details page
	function getListingMetaInfo($id) {
		
		global $db;
		global $ads_settings, $seo_settings, $meta_format, $settings;
		global $crt_lang;
		$page_info=array( 'title' => '', 'meta_keywords' => '', 'meta_description' => '', 'canonical' => '', 'noindex' => '' );

		// if translate title & description
		$title_field ="`title`";
		$description_field ="`description`";
		if($ads_settings['translate_title_description']) {
			global $languages;
			if(empty($languages)) $languages = common::getCachedObject("base_languages");
			if(count($languages)>1) {
				$title_field = "`title_$crt_lang` as `title`";
				$description_field = "`description_$crt_lang` as `description`";
			}
		}

// LOCATION SUBDOMAINS
$location_str='';
if($settings['enable_locations'] && $settings['enable_subdomains']) {
	$location_str=", {$settings['subdomain_field']}";
}

		global $title_length, $meta_description_length, $meta_keywords_length;

		// get all fields from title format
		$matches = array();
		preg_match_all("/%[a-z_0-9]*/i", $meta_format['title'], $matches);
		$title_fields_array = $matches[0];

		// get all fields from meta keywords format
		$matches = array();
		preg_match_all("/%[a-z_0-9]*/i", $meta_format['meta_keywords'], $matches);
		$meta_keywords_fields_array = $matches[0];

		// get all fields from meta description format
		$matches = array();
		preg_match_all("/%[a-z_0-9]*/i", $meta_format['meta_description'], $matches);
		$meta_description_fields_array = $matches[0];

		// possible fields
		$possible_fields = $db->getTableFields(TABLE_ADS);
		if(!in_array("title", $possible_fields)) array_push($possible_fields, "title");
		array_push($possible_fields, "category_name");
		array_push($possible_fields, "category_meta_description");
		array_push($possible_fields, "category_meta_keywords");

		// get listing data
		$listing_info = $db->fetchAssoc("select $title_field, ".TABLE_ADS.".$description_field, ".TABLE_ADS.".*,  ".TABLE_ADS.".`meta_description` as `meta_description`, ".TABLE_ADS.".`meta_keywords` as `meta_keywords`, ".TABLE_CATEGORIES."_lang.`name` as `category_name`, ".TABLE_CATEGORIES."_lang.`meta_description` as `category_meta_description`, ".TABLE_CATEGORIES."_lang.`meta_keywords` as `category_meta_keywords` $location_str from ".TABLE_ADS." left join ".TABLE_CATEGORIES."_lang on ".TABLE_ADS.".category_id=".TABLE_CATEGORIES."_lang.id where ".TABLE_ADS.".id='".$id."' and `lang_id`='$crt_lang';");

		// if the listing has meta info
		if($ads_settings['add_meta_with_listings']) {
			$page_info['meta_keywords'] = cleanHtml($listing_info['meta_keywords']);
			$page_info['meta_description'] = cleanHtml($listing_info['meta_description']);
		}

		// build title
		$title_values = array();
		foreach($title_fields_array as $f) {
			if(!in_array(substr($f, 1), $possible_fields)) continue;
			$title_values[$f] = cleanHtml($listing_info[substr($f, 1)]); 
		}

		$page_info['title'] = start_words(trim(str_replace(array_keys($title_values), array_values($title_values), $meta_format['title'])), $title_length);

		if(!in_array("description", $possible_fields)) array_push($possible_fields, "description");

		if(!$page_info['meta_keywords'] || !$ads_settings['add_meta_with_listings']){

			// build meta keywords
			$meta_keywords_values = array();

			foreach($meta_keywords_fields_array as $f) {

				if(!in_array(substr($f, 1), $possible_fields)) continue;
				if($f=="%title" || $f=="%description") { 
					$meta_keywords_values[$f] = shuffle_keys(cleanHtml($listing_info[substr($f, 1)]));
					continue;
				}
				$meta_keywords_values[$f] = cleanHtml($listing_info[substr($f, 1)]); 
			}

			$page_info['meta_keywords'] = start_words(trim(str_replace(array_keys($meta_keywords_values), array_values($meta_keywords_values), $meta_format['meta_keywords'])), $meta_keywords_length);

		}

		if(!$page_info['meta_description'] || !$ads_settings['add_meta_with_listings']){

			// build meta description
			$meta_description_values = array();
			foreach($meta_description_fields_array as $f) {

				if(!in_array(substr($f, 1), $possible_fields)) continue;
				$meta_description_values[$f] = cleanHtml($listing_info[substr($f, 1)]); 
			}

			$page_info['meta_description'] = start_words(trim(str_replace(array_keys($meta_description_values), array_values($meta_description_values), $meta_format['meta_description'])), $meta_description_length);

		}

		// cannonical url
		if($settings['enable_locations'] && $settings['enable_subdomains'] && $listing_info[$settings['subdomain_field']]) {
				$page_info['canonical'] = $this->makeSubdomainDetailsLink($id, $listing_info['title'], $listing_info[$settings['subdomain_field']], 1);

		}

		return $page_info;

	}


	// set meta info for category page
	function getCategoryMetaInfo($id) {

		global $page_info;
		if(!$id) return$page_info;

		if(!isset($page_info)) $page_info=array( 'title' => '', 'meta_keywords' => '', 'meta_description' => '', 'canonical' => '', 'noindex' => '' );

		global $db;
		global $crt_lang, $config_abs_path;
		$row = $db->fetchAssoc("select `name`, `page_title`, `meta_keywords`, `meta_description` from ".TABLE_CATEGORIES."_lang where `lang_id`='$crt_lang' and id=$id");

		if(!$row) return array();

		global $title_length, $meta_description_length, $meta_keywords_length;
		require_once $config_abs_path."/classes/categories.php";

		$category_info = array("%category_name" => cleanHtml($row['name'])." ".categories::getParentName($id), 
			"%category_title" => cleanHtml($row['page_title']),
			"%category_meta_keywords" => cleanHtml($row['meta_keywords']), 
			"%category_meta_descrption" => cleanHtml($row['meta_description'])
			);
		// default meta keywords and description

		$page_info['title'] = start_words(trim(str_replace(array_keys($category_info), array_values($category_info), $page_info['title'])), $title_length);

		$page_info['meta_keywords'] = start_words(trim(str_replace(array_keys($category_info), array_values($category_info), $page_info['meta_keywords'])), $meta_keywords_length);

		$page_info['meta_description'] = start_words(trim(str_replace(array_keys($category_info), array_values($category_info), $page_info['meta_description'])), $meta_description_length);

		return $page_info;

	}

	function cleanMetaInfo() {

		global $page_info;

		$find = array("/%[a-z_0-9]*/i", "/^[(\s)?,]+/i", "/[,(\s)?]+$/i", "/,(\s*,)+/i");
		$replace = array("", "", "", ",");

		
		
		$page_info['title'] = preg_replace($find,$replace,$page_info['title']);
		$page_info['meta_keywords'] = preg_replace($find,$replace,$page_info['meta_keywords']);
		$page_info['meta_description'] = preg_replace($find,$replace,$page_info['meta_description']);
		
		return $page_info;

	}

	// set meta info for custom page
	function getCustomPageMetaInfo($id) {

		global $db;
		global $crt_lang, $settings;

		$result=$db->fetchAssoc("select `title`, `meta_description`, `meta_keywords` from ".TABLE_CUSTOM_PAGES."_lang where `lang_id`='$crt_lang' and id=$id");

		$result['noindex'] = 0;

		foreach ($result as $key=>$value)
			$result[$key] = cleanHtml($value);

		// cannonical url
		$result['canonical'] = '';
		if($settings['enable_locations'] && $settings['enable_subdomains'] && isset($_GET['crt_city']) && $_GET['crt_city']) {

			// build canonical without subdomain 
			global $main_domain, $seo_settings, $sef_links;
			if($seo_settings['enable_mod_rewrite']) 
				$result['canonical'] = "http://".$main_domain."/".$id."-"._urlencode($result['title'])."/".$sef_links['content'];
			else
				$result['canonical'] = "http://".$main_domain."/content.php?id=".$id;

		}

		return $result;

	}

	// set meta info for recent ads page
	function getRecentAdsMetaInfo() {

		global $seo_settings, $page_info;

		// non canonical links
		if( (!empty($_GET['order']) && $_GET['order'] != "date_added") || ( !empty($_GET['order_way']) && $_GET['order_way'] != "desc") ) {
			global $config_live_site;
			$page = get_numeric("page", 1);
			if($seo_settings['enable_mod_rewrite']) {
				$page_str="";
				if($page>1) $page_str = "/".$page;
				$page_info['canonical'] = $config_live_site.$page_str."/".$this->sef_links['recent_ads'].".html";
			} else {
				$page_info['canonical'] = $config_live_site."/recent_ads.php";
				if($page>1) $page_info['canonical'].="?page=".$page;
			}

		}

		return $page_info;

	}

	// set meta info for user page
	function getUserPageMetaInfo($id) {

		global $db;
		global $crt_lang, $seo_settings, $settings, $page_info, $meta_format;
		global $title_length, $meta_description_length, $meta_keywords_length;

		// get all fields from title format
		$matches = array();
		preg_match_all("/%[a-z_0-9]*/i", $meta_format['title'], $matches);
		$title_fields_array = $matches[0];

		// get all fields from meta keywords format
		$matches = array();
		preg_match_all("/%[a-z_0-9]*/i", $meta_format['meta_keywords'], $matches);
		$meta_keywords_fields_array = $matches[0];

		// get all fields from meta description format
		$matches = array();
		preg_match_all("/%[a-z_0-9]*/i", $meta_format['meta_description'], $matches);
		$meta_description_fields_array = $matches[0];

		// possible fields
		$possible_fields = $db->getTableFields(TABLE_USERS);

		// get user data
		$user_info = users::getUserInfo($id);

		// build title
		$title_values = array();
		foreach($title_fields_array as $f) {
			if(!in_array(substr($f, 1), $possible_fields)) continue;
			$title_values[$f] = cleanHtml($user_info[substr($f, 1)]); 
		}

		$page_info['title'] = start_words(trim(str_replace(array_keys($title_values), array_values($title_values), $meta_format['title'])), $title_length);


		// build meta keywords
		$meta_keywords_values = array();

		foreach($meta_keywords_fields_array as $f) {

			if(!in_array(substr($f, 1), $possible_fields)) continue;
			$meta_keywords_values[$f] = cleanHtml($user_info[substr($f, 1)]); 
		}

		$page_info['meta_keywords'] = start_words(trim(str_replace(array_keys($meta_keywords_values), array_values($meta_keywords_values), $meta_format['meta_keywords'])), $meta_keywords_length);


		// build meta description
		$meta_description_values = array();
		foreach($meta_description_fields_array as $f) {

			if(!in_array(substr($f, 1), $possible_fields)) continue;
			$meta_description_values[$f] = cleanHtml($user_info[substr($f, 1)]); 
		}

		$page_info['meta_description'] = start_words(trim(str_replace(array_keys($meta_description_values), array_values($meta_description_values), $meta_format['meta_description'])), $meta_description_length);

		$canonical_subdomains = 0;
		if($settings['enable_locations'] && $settings['enable_subdomains'] && isset($_GET['crt_city']) && $_GET['crt_city']) $canonical_subdomains = 1;

		global $config_live_site;
		$site_url = $config_live_site;
		if($canonical_subdomains) { global $main_domain; $site_url = "http://".$main_domain; }

		$page = get_numeric("page", 1);

		// canonical links
		if( (!empty($_GET['order']) && $_GET['order'] != "date_added") || ( !empty($_GET['order_way']) && $_GET['order_way'] != "desc") || $canonical_subdomains ) {

			global $self_noext;
			if($seo_settings['enable_mod_rewrite']) {
				if($self_noext=="user_listings") $page_info['canonical'] = $this->makeUserListingsLink($id, '', $page, $canonical_subdomains );
				else if($self_noext=="store") $page_info['canonical'] = $this->makeDealerLink($id, '', $page, $canonical_subdomains );
				else $page_info['canonical'] = $this->makeUserDetailLink($id, '', $canonical_subdomains );
			} else {
				global $config_live_site;
				$page_info['canonical'] = $site_url."/".$self_noext.".php?id=".$id;
				if($page>1) $page_info['canonical'].="&page=".$page;
			}

		}

		return $page_info;

	}

	// set meta info for search page
	function getSearchMetaInfo() {

		global $post_array, $location_array, $page_info, $lng, $page, $meta_format;
		// get category and parent category name
		$category_name = "";
		if($post_array['category']) { 

			global $config_abs_path;
			require_once($config_abs_path.'/classes/categories.php');
			$categ_info = categories::getForSeo($post_array['category']);
			$category_name = $categ_info['name'];
			$category_title = $categ_info['page_title'];
			$category_meta_description = $categ_info['meta_description'];
			$category_meta_keywords = $categ_info['meta_keywords'];
			$parent = categories::getParentName($post_array['category']);
			if($parent) $category_name.=" ".$parent;
 
		}

		global $title_length, $meta_description_length, $meta_keywords_length;
		// get ad title format
		global $seo_settings;

		// get all fields from title format
		$matches = array();
		preg_match_all("/%[a-z_0-9]*/i", $meta_format['title'], $matches);
		$title_fields_array = $matches[0];

		// get all fields from meta keywords format
		$matches = array();
		preg_match_all("/%[a-z_0-9]*/i", $meta_format['meta_keywords'], $matches);
		$meta_keywords_fields_array = $matches[0];

		// get all fields from meta description format
		$matches = array();
		preg_match_all("/%[a-z_0-9]*/i", $meta_format['meta_description'], $matches);
		$meta_description_fields_array = $matches[0];

		// possible fields
		global $db;
		$possible_fields = $db->getTableFields(TABLE_ADS);
		if(!in_array("title", $possible_fields)) array_push($possible_fields, "title");
		array_push($possible_fields, "category_name");
		array_push($possible_fields, "category_title");
		array_push($possible_fields, "category_meta_description");
		array_push($possible_fields, "category_meta_keywords");
		array_push($possible_fields, "page");
		array_push($possible_fields, $this->keyword);

		// build title
		$title_values = array();
		foreach($title_fields_array as $f) {

			if(!in_array(substr($f, 1), $possible_fields)) continue;
			if($f=="%category_title" ) { if($post_array['category']) $title_values[$f] = $category_title; else $title_values[$f] =''; continue; }
			if($f=="%category_name") { if($post_array['category']) $title_values[$f] = $category_name; else $title_values[$f] = ''; continue; }
			if($f=="%page") { $title_values[$f] = $lng['general']['page']." ".$page; continue; }
			if(isset($post_array[substr($f, 1)])) $title_values[$f] = cleanHtml($post_array[substr($f, 1)]); 
			//else if(isset($location_array[substr($f, 1)])) $title_values[$f] = cleanHtml($location_array[substr($f, 1)]); 
			else $title_values[$f] = "";
		}

		$page_info['title'] = start_words(trim(str_replace(array_keys($title_values), array_values($title_values), $meta_format['title'])), $title_length);
		$page_info['title'] = preg_replace("/ +/", " ", $page_info['title']);

		// build meta keywords
		$meta_keywords_values = array();
		foreach($meta_keywords_fields_array as $f) {

			if(!in_array(substr($f, 1), $possible_fields)) continue;
			if($f=="%category_name") { if($post_array['category']) $meta_keywords_values[$f] = $category_name.","; else $meta_keywords_values[$f] = ''; continue; }
			if($f=="%category_title") { if($post_array['category']) $meta_keywords_values[$f] = $category_title.","; else $meta_keywords_values[$f] = ''; continue; }
			if($f=="%category_meta_keywords") { if($post_array['category']) $meta_keywords_values[$f] = $category_meta_keywords.","; else $meta_keywords_values[$f] = ''; continue; }
			if($f=="%page") { $meta_keywords_values[$f] = $lng['general']['page']." ".$page; continue; }
			if(isset($post_array[substr($f, 1)])) $meta_keywords_values[$f] = cleanHtml($post_array[substr($f, 1)]).","; 
			//else if(isset($location_array[substr($f, 1)])) $meta_keywords_values[$f] = cleanHtml($location_array[substr($f, 1)]); 
			else $meta_keywords_values[$f] = "";
		}

		$page_info['meta_keywords'] = trim(str_replace(array_keys($meta_keywords_values), array_values($meta_keywords_values), $meta_format['meta_keywords']));
		$page_info['meta_keywords'] = preg_replace("/ +/", " ", $page_info['meta_keywords']);

		// build meta description
		$meta_description_values = array();
		foreach($meta_description_fields_array as $f) {

			if(!in_array(substr($f, 1), $possible_fields)) continue;
			if($f=="%category_name") { if($post_array['category']) $meta_description_values[$f] = $category_name; else $meta_description_values[$f] = ''; continue; }
			if($f=="%category_title") { if($post_array['category']) $meta_description_values[$f] = $category_title; else $meta_description_values[$f] = ''; continue; }
			if($f=="%category_meta_description") { if($post_array['category']) $meta_description_values[$f] = $category_meta_description.","; else $meta_description_values[$f] = ''; continue; }
			if($f=="%page") { $meta_description_values[$f] = $lng['general']['page']." ".$page; continue; }
			if(isset($post_array[substr($f, 1)])) $meta_description_values[$f] = cleanHtml($post_array[substr($f, 1)]); 
			//else if(isset($location_array[substr($f, 1)])) $meta_description_values[$f] = cleanHtml($location_array[substr($f, 1)]); 
			else $meta_description_values[$f] = "";
		}

		$page_info['meta_description'] = trim(str_replace(array_keys($meta_description_values), array_values($meta_description_values), $meta_format['meta_description']));
		$page_info['meta_description'] = preg_replace("/ +/", " ", $page_info['meta_description']);

		// non canonical links
		if( (!empty($post_array['order']) && $post_array['order'] != "date_added") || ( !empty($post_array['order_way']) && $post_array['order_way'] != "desc") ) {

			if($seo_settings['enable_mod_rewrite'])
				$page_info['canonical'] = $this->makeSearchLink($post_array, $page, "order|order_way");
			else {
				global $config_live_site;
				$page_info['canonical'] = preg_replace("/\&order(_way)?=[a-z]+/i" ,"", $config_live_site."/listings.php?".$_SERVER['QUERY_STRING']);
			}
		}

		return $page_info;

	}

	function replaceLocationMetaInfo() {

		global $settings, $page_info;
		if(!$settings['enable_locations']) return $page_info;

		global $location_array;
		$location_values = array();
		foreach($location_array as $key=>$value) {
			if(!$value) continue;
			$location_values['%'.$key] = $value;
		}

		$page_info['title'] = str_replace(array_keys($location_values), array_values($location_values), $page_info['title']);
		$page_info['meta_keywords'] = str_replace(array_keys($location_values), array_values($location_values), $page_info['meta_keywords']);
		$page_info['meta_description'] = str_replace(array_keys($location_values), array_values($location_values), $page_info['meta_description']);

		return $page_info;

	}


}
?>
