<?php
/*
	*	
	* OxyClassifieds.com : PHP Classifieds (http://www.oxyclassifieds.com)
	* version 8
	* (c) 2014 OxyClassifieds.com (office@oxyclassifieds.com).
	*
*/

require_once "include.php";
require_once "../classes/locations.php";
require_once "../classes/fields.php";
require_once "../classes/depending_fields.php";

global $db;
global $lng;
$info='';
$smarty = new Smarty;
$smarty->caching = 0;
$smarty = common($smarty);
$smarty->assign("lng",$lng);
//_print_r($_COOKIE);

global $appearance_settings, $settings, $crt_lang, $location_array;

header('Content-type: text/html; charset='.$appearance_settings['charset']);

$loc_fields_array = explode(",", $settings['location_fields']);
$fields = array();
$i = 0;
$no_columns = 3;

foreach($loc_fields_array as $loc) {
	// check what type of field it is
	$f = new fields("cf");
	$type = $f->getTypeByCaption($loc);
	if($type) { 
		global $db;
		$row = $db->fetchAssoc("select `name`, `elements` from ".TABLE_FIELDS." left join ".TABLE_FIELDS."_lang on ".TABLE_FIELDS.".id = ".TABLE_FIELDS."_lang.id where `caption`='$loc' and `lang_id` = '$crt_lang'");
		$elements = explode("|", cleanHtml($row['elements']));
		$name = $row['name'];
	}
	else
	{
		$type="depending";
		$elements='';
		global $db;
		$dep_array = $db->fetchAssoc("select * from ".TABLE_DEPENDING_FIELDS." left join ".TABLE_DEPENDING_FIELDS."_lang on ".TABLE_DEPENDING_FIELDS.".id=".TABLE_DEPENDING_FIELDS."_lang.id where (`caption1` like '$loc' or `caption2` like '$loc' or `caption3` like '$loc' or `caption4` like '$loc') and `lang_id`='$crt_lang'");

		if($dep_array) {
			$fields[$i]['dep_id'] = $dep_array['id'];
			$fields[$i]['prev_field'] = ''; $fields[$i]['next_field'] = '';

			if($dep_array['caption1']==$loc) { $table = $dep_array['table1']; if($dep_array['caption2']) $fields[$i]['next_field'] = $dep_array['caption2']; $name = $dep_array['name1'];}
			if($dep_array['caption2']==$loc) { $table = $dep_array['table2']; $fields[$i]['prev_field'] = $dep_array['caption1']; if($dep_array['caption3']) $fields[$i]['next_field'] = $dep_array['caption3']; $prev_table = $dep_array['table1']; $name = $dep_array['name2'];}
			if($dep_array['caption3']==$loc) { $table = $dep_array['table3']; $fields[$i]['prev_field'] = $dep_array['caption2']; if($dep_array['caption4']) $fields[$i]['next_field'] = $dep_array['caption4']; $prev_table = $dep_array['table2']; $name = $dep_array['name3'];}
			if($dep_array['caption4']==$loc) { $table = $dep_array['table4']; $fields[$i]['prev_field'] = $dep_array['caption3']; $prev_table = $dep_array['table3']; $name = $dep_array['name4']; }
			$dep = new depending_fields();

			// for first field simply get all elements
			if($dep_array['caption1']==$loc) $elements = $dep->getIdNameNo($loc, $table, $crt_lang); //explode("|", $dep->getElements($table, $crt_lang));
			else {
				$elements=array();
				// if previous depending field is set as a location
				if($location_array[$fields[$i]['prev_field']]) {
					$set = $dep->getIdByName($prev_table, escape($location_array[$fields[$i]['prev_field']]));
					$elements = $dep->getIdNameNo($loc, $table, $crt_lang, $set); //explode("|", $dep->getElements($table, $crt_lang, $set));
				}
				
			}
			
		}
		
	$fields[$i]['table'] = $table;
	}// end if depending

	$fields[$i]['caption'] = $loc;
	$fields[$i]['type'] = $type;
	$fields[$i]['elements'] = $elements;
	$fields[$i]['no_per_column'] = ceil(count($elements)/$no_columns);
	$fields[$i]['name'] = $name;
	/*$no_array = $db->fetchAssocList("select * from ".TABLE_LOCATION_NO_ADS." where `field` like '$loc'");
	foreach($no_array as $n) {
		$fields[$i]['no'][$n['val']] = $n['no'];
	}*/
	$i++;

}

//_print_r($fields);
$smarty->assign("fields", $fields);
$smarty->assign("no_columns", $no_columns);

$db->close();
if($db->error!='') { $db_error = $db->getError(); $smarty->assign('db_error',$db_error); }

$smarty->display('show_locations.html');
close();
?>