<?php
/*
	*	
	* OxyClassifieds.com : PHP Classifieds (http://www.oxyclassifieds.com)
	* version 8
	* (c) 2014 OxyClassifieds.com (office@oxyclassifieds.com).
	*
*/

class spam_prevention {

	var $table;
	var $log_table;
	var $no_logs;

	function spam_prevention() {

		global $config_table_prefix;
		$this->table = $config_table_prefix."spam_prevention";
		$this->log_table = $config_table_prefix."spam_prevention_log";
		$this->error = array();
		$this->info = '';
		$this->no_logs = 0;

	}

	function setInfo($str){

		$this->info = $str;

	}

	function getInfo() {

		return $this->info;

	}

	function saveSettings() {

		global $config_demo;
		if($config_demo==1) { 
			$this->addError($lng['general']['errors']['demo'].'<br />');
			return 0;
		}

		global $db;
		$this->clean=array();

		$str_update = '';

		$array_checkboxes = array("check_registration", "check_contact_forms", "check_comments", "check_reviews", "block_tor_ips", "block_networks");

		foreach ($array_checkboxes as $field) {

			$this->clean[$field] = checkbox_value($field);
			$str_update.=" `$field` = '".$this->clean[$field]."', ";
		}

		if(isset($_POST["block_limit"]) && is_numeric($_POST["block_limit"]) && $_POST["block_limit"]>0 && $_POST["block_limit"]<=100) $this->clean["block_limit"]=$_POST["block_limit"]; else $this->clean["block_limit"]=50;
		$str_update.=" `block_limit` = '".$this->clean["block_limit"]."', ";

		if(isset($_POST["block_for"]) && is_numeric($_POST["block_for"]) && $_POST["block_for"]>0) $this->clean["block_for"]=$_POST["block_for"]; else $this->clean["block_for"]=60;
		$str_update.=" `block_for` = '".$this->clean["block_for"]."'";

		$db->query("update ".$this->table." set ".$str_update);

		// clear cache
		$lc_cache = new cache();
		$lc_cache->clearCache("mod_spam_prevention");

	}

	function getSettings($overwrite=0) {

		// overwrite = 1 => when settings have been changed the cache is not to be considered 
		$lc_cache = new cache();
		global $crt_lang;
		if($overwrite || !$sp_settings = $lc_cache->readCache("mod_spam_prevention", $crt_lang)) {

			global $db;
			$sp_settings = $db->fetchAssoc("select * from ".$this->table);
			$lc_cache->writeCache("mod_spam_prevention", $sp_settings, $crt_lang);

		}
		return $sp_settings;

	}

	function initTemplatesVals($smarty) {

	}

	function deleteLogsOlderThan($date) {

		global $db;
		$db->query("delete from ".$this->log_table." where `date` < '$date'");

	}
	
	function spamCheck($ip='', $email='', $type) {

		$sp_settings = $this->getSettings();
		$url = $this->createBaseURL($sp_settings);
	    
		if(isset($ip) && $ip) $url.="&ip=$ip";
		if(isset($email) && $email) $url.="&email=$email";
	
		$sp_ret = array();

		if(_isCurl()) {
 
			$ch = curl_init();
		
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

			if(curl_error($ch)) return 0;
		
			$data = curl_exec($ch);
			curl_close($ch);

		} else 
			$data = file_get_contents($url);
	      
		if($data) {
	// test data
	//$data = '{"success":1,"email":{"lastseen":"2016-02-24 08:27:00","frequency":1568,"appears":1,"confidence":99.67},"ip":{"lastseen":"2016-02-24 08:27:00","frequency":203,"appears":1,"confidence":97.54}}';
			$response = json_decode($data, true);

			// email will just be added to block list
			if($email) {
	 
				if( isset($response['email']) && $response['email']['appears']==1 && $sp_settings['block_limit']<=$response['email']['confidence']) { 
	    
					$this->addToLog('', $email, $response['email']['confidence'], $type);
		
					// block email
					global $config_abs_path;
					require_once $config_abs_path."/classes/blocked_emails.php";
					$be = new blocked_emails();
						
					$info = 'Spam Prevention Module';
					$be->add($email, $info);
		 
				} // end spam==1
			} // end if email

			// ip will be added to block list but it will also return an answer so it can be redirected to access declined page
			if($ip) {
	 
				if( isset($response['ip']) && $response['ip']['appears']==1 && $sp_settings['block_limit']<=$response['ip']['confidence']) { 

					$this->addToLog($ip, '', $response['ip']['confidence'], $type);
		
					// block ip 
					global $config_abs_path;
					require_once $config_abs_path."/classes/blocked_ips.php";
					$bi = new blocked_ips();
					
					$is_spam = 0;
					$info = 'Spam Prevention Module';
					if($sp_settings['block_for']==0) 
						$is_spam = $bi->add($ip, $info);
					else
						$is_spam = $bi->addTemporary($ip, $sp_settings['block_for'], $info);

					global $lng;
					if($is_spam) $sp_ret = array("field"=>"alert_window", "error" => $lng['general']['access_restricted']);
					
				} // end spam=1
			} // end if ip
	 
		} // end if $data
	 
		return $sp_ret;
	    
	}

	function createBaseURL($sp_settings) {

	  $url = "http://api.stopforumspam.org/api?f=json";
	  
	  if(!$sp_settings['block_tor_ips']) $url.="&notorexit";
	  if(!$sp_settings['block_networks']) $url.="&nobadip";
	  
	  return $url;
  
	}

	function addToLog($ip='', $email='', $confidence, $type) {
	
	    global $db;
	    $timestamp = date("Y-m-d H:i:s");
	    $db->query("insert into ".$this->log_table." set `date`='$timestamp', `email`='$email', `ip`='$ip', `confidence`='$confidence', `type`='$type'");
	    return;
	
	}

	function getNo() {
	
		global $db;
		$no=$db->fetchRow('select count(*) from '.$this->log_table);
		return $no;

	}

	function searchLogs($post_array, $page, $no_per_page) {

		global $db;
		$start=($page-1)*$no_per_page;

		$found = 0; $where = '';
		$ext_join = ''; $join_users = '';

		foreach($post_array as $key=>$value) {
			if( !$key || $value=='' ) continue;
			
			switch($key) {
				case "ip": 
				case "email": 
				case "type": 
					if($found) $where.=" and "; else $where = " where ";
					$where .= " ".$this->log_table.".`$key` = '$value' ";
					$found = 1;
				break;
				case "date_from": 
					if($found) $where.=" and "; else $where = " where ";
					$where .= " ".$this->log_table.".`date` >= '$value' ";
					$found = 1;
				break;

				case "date_to": 
					if($found) $where.=" and "; else $where = " where ";
					$where .= " ".$this->log_table.".`date` <= '$value' ";
					$found = 1;
				break;
				case "confidence_from": 
					if($found) $where.=" and "; else $where = " where ";
					$where .= " ".$this->log_table.".`confidence` >= '$value' ";
					$found = 1;
				break;

				case "confidence_to": 
					if($found) $where.=" and "; else $where = " where ";
					$where .= " ".$this->log_table.".`confidence` <= '$value' ";
					$found = 1;
				break;

			}
		}

		$no_logs = $this->getNoLogs($where);
		$this->setNoLogs($no_logs);
		
		global $appearance_settings;
		$date_format=$appearance_settings["date_format_long"];

		$result=$db->fetchAssocList("select *, date_format(".$this->log_table.".`date`,'$date_format') as `date_nice` from ".$this->log_table.$where." order by `date` desc limit $start, $no_per_page");

		return $result;

	}
	
	
	function getNoLogs($where){

		global $db, $settings;
		$sql = "select count(*) 
		from ".$this->log_table.$where;
		$no_logs = $db->fetchRow($sql);

		return $no_logs;
	}

	function setNoLogs($no) {

		$this->no_logs = $no;

	}

	function noLogs() {

		return $this->no_logs;

	}

	function getLogId($id) {
	
		global $db;
		$result = $db->fetchAssoc("select * from ".$this->log_table." where id='$id'" );
		return $result;
		
	}
	
	function unblock($id) {
	
		$logId = $this->getLogId($id);
		
		// unblock email
		if($logId['email']) {

			global $config_abs_path;
			require_once $config_abs_path."/classes/blocked_emails.php";
			$be = new blocked_emails();
			$be->deleteEmail($logId['email']);
		
		}
	
		// unblock ip
		if($logId['ip']) {
		
			global $config_abs_path;
			require_once $config_abs_path."/classes/blocked_ips.php";
			$bi = new blocked_ips();
			$bi->deleteIP($logId['ip']);

		}

	}

	function whitelist($id) {
	
		$logId = $this->getLogId($id);
		
		// unblock email
		if($logId['email']) {

			global $config_abs_path;
			require_once $config_abs_path."/classes/blocked_emails.php";
			$be = new blocked_emails();
			$be->addToWhitelist($logId['email']);
		
		}
	
		// unblock ip
		if($logId['ip']) {
		
			global $config_abs_path;
			require_once $config_abs_path."/classes/blocked_ips.php";
			$bi = new blocked_ips();
			$bi->addToWhitelist($logId['ip']);

		}

	}

}
?>
