<?php
/*
	*	
	* OxyClassifieds.com : PHP Classifieds (http://www.oxyclassifieds.com)
	* version 8
	* (c) 2014 OxyClassifieds.com (office@oxyclassifieds.com).
	*
*/
require_once "include/include.php";
require_once "classes/groups.php";
require_once "classes/images.php";
require_once "include/gmaps_util.php";
require_once "classes/users.php";
require_once "classes/info.php";

global $db;
global $lng;

$post = 0;
if(isset($_GET['post']) && $_GET['post']==1) $post = 1;

if(!$post) {
	$smarty = new Smarty;
	$smarty = common($smarty);
}
else 	
	common_no_template();

global $logged_in, $is_admin;
if($logged_in || $is_admin) { if(!$post) header("Location: ./"); exit(0); }

if(isset($_GET['group']) && is_numeric($_GET['group'])) { 
	$group = escape($_GET['group']);
	if(!groups::exists($group) && $group!=-2) {
		if(!$post) header("Location: pre-register.php"); 
		exit(0);
	}
}
else {
	$group='';
	global $config_vars;
	$no_groups = $config_vars['no_groups'];
	if($no_groups==1) $group = $config_vars['default_register_group'];
}
if(!$group && $no_groups>1) { if(!$post) header("Location: pre-register.php"); exit(0); } else if(!$group) exit(0);

if($group>0) {
	$gr = new groups();
	$group_settings = $gr->getGroup($group);
}

if(!$post) {
	$smarty->assign("lng",$lng);
	$smarty->assign("section","login-register");

	$smarty->assign("group",$group);
	$smarty->assign("group_settings",$group_settings);

	$registration_info=info::getVal("registration");
	$smarty->assign("registration_info",$registration_info);

	$user_fields=common::getCachedObject("base_user_fields", array("group" => $group));
	$smarty->assign("user_fields",$user_fields);

	setGmaps('uf', $group, $smarty);

	$uf=new fields('uf');
	$htmlarea = $uf->HTMLAreaFieldExists($group);
	$smarty->assign("htmlarea_exists",$htmlarea);
	$smarty->assign("tmp", array());
}

if( $post ){

	require_once "classes/fields.php";
	require_once "classes/fields_process.php";
	require_once "classes/validator.php";
	require_once "classes/blocked_emails.php";
	global $config_abs_path;
	require_once $config_abs_path."/libs/JSON.php";


	// send the following response back:
	// response = 1 / 0
	// error - array containing errors strings and fields which contain the error
	$ret = array("response" => 0, "error" => array(), "info" => null);

	$sp_response = array();
	do_action("register_post", array(&$sp_response, $_SERVER['REMOTE_ADDR'], $_POST['email']));
	if($sp_response && is_array($sp_response)) { array_push($ret['error'], $sp_response); echo json_encode($ret); return;}

	$user=new users();
	if(!$user->add($group)) {

		require_once "classes/mails.php";
		require_once "classes/mail_templates.php";

		$ret['error'] = array_merge ( $ret['error'], $user->getError());
		$ret['response'] = 0;

	}
	else {
		// if SMS verification
		if($group_settings['activate_account']==2) {
		
			$ret['response'] = 2; // redirect case
			global $settings;
			$user_details = $user->getUser($user->last);
			if($settings['enable_username']) $account = urlencode($user_details['username']);
			else $account = urlencode($user_details['email']);
	
			$act_link=$config_live_site.'/activate_account.php?account='.$account.'&type=sms';
			$ret['redirect'] = $act_link;
			
			echo json_encode($ret);
			exit(0);
			
		}
		
		$ret['response'] = 1;
		$ret['info']=$user->getInfo();
	}

	echo json_encode($ret);
}

$db->close();

if(!$post) {
if($db->error!='') { $db_error = $db->getError(); $smarty->assign('db_error',$db_error); }
$smarty->display('register.html');
}

if(!$post) close();
?>
