<?php
/*
	*	
	* OxyClassifieds.com : PHP Classifieds (http://www.oxyclassifieds.com)
	* version 8
	* (c) 2014 OxyClassifieds.com (office@oxyclassifieds.com).
	*
*/
require_once "include/include.php";
require_once "classes/paginator.php";
require_once "classes/pictures.php";
require_once "classes/users.php";
require_once "include/gmaps_util.php";

global $db;
global $lng;
$smarty = new Smarty;
$smarty = common($smarty);
$smarty->assign("lng",$lng);
$smarty->assign("section","user_listings");

$id = get_numeric_only("id");
$smarty->assign("id",$id);

$array_order_way= array("asc", "desc");
$array_order= array("date_added", "price", "title");
$page = get_numeric("page", 1);
if(isset($_GET['order']) && in_array($_GET['order'],$array_order)) $order=$_GET['order']; else $order='date_added';
if(isset($_GET['order_way']) && in_array($_GET['order_way'],$array_order_way)) $order_way=$_GET['order_way']; else $order_way='desc';

global $appearance_settings;
$ads_per_page=$appearance_settings["ads_per_page"];

$usr = new users();
$user = $usr->getUser($id);
$invalid_user = 0;
if(!$user) {

	$invalid_user = 1;
	

} else {

$smarty->assign("user",$user);
$smarty->assign("tmp", $user);

$listings=new listings();
$no_listings=$listings->getNoActiveListings($id);
$smarty->assign("no_listings",$no_listings);

$listings_array=$listings->getStoreListings($page, $ads_per_page, $order, $order_way, $id);
$smarty->assign("listings_array",$listings_array);

$paginator = new paginator();
$paginator->setItemsNo($no_listings);

global $seo_settings;
// if seo urls
if($seo_settings['enable_mod_rewrite']) {
	global $settings;
	if($user[$settings['contact_name_field']]) $paginator->setSeoUrlStr($id."-"._urlencode($user[$settings['contact_name_field']]));
	else $paginator->setSeoUrlStr($id."-"._urlencode($user['username']));
	$paginator->setExcludeArray(array("id"));
}
$paginator->paginate($smarty);


$usr = new users();
$group = $usr->getGroup($id);
$uf=new fields('uf');
$user_fields_array=$uf->getFieldsArray($group);
$smarty->assign("user_fields_array",$user_fields_array);

$smarty->assign("page",$page);

setGmaps('uf', $group, $smarty, '', $user);

// do actions for "user_page"
do_action("user_page", array($smarty, $id, $user));

} // end if valid user

$smarty->assign("invalid_user",$invalid_user);

$db->close();
if($db->error!='') { $db_error = $db->getError(); $smarty->assign('db_error',$db_error); }

$post_json = "";
$smarty->assign("post_json",$post_json);

do_action("listings_page", array($smarty));

$smarty->display('user_listings.html');
close();
?>
