<?php
/*
	*	
	* OxyClassifieds.com : PHP Classifieds (http://www.oxyclassifieds.com)
	* version 9
	* (c) 2017 OxyClassifieds.com (office@oxyclassifieds.com).
	*
*/

global $config_abs_path;
require_once $config_abs_path."/classes/payment/Mobilpay/Payment/Request/Abstract.php";
require_once $config_abs_path."/classes/payment/Mobilpay/Payment/Request/Sms.php";
require_once $config_abs_path."/classes/payment/Mobilpay/Payment/Request/Notify.php";

class mobilpay {

	var $params;
	var $item;
	var $order;
	var $result;
	var $sub;
	var $ins;
	var $isSub;
	var $postback_url;
	var $user_key;
	var $mobilpay_keys;
	var $pending;
	var $invoice_no;
	var $pay_settings;
	var $table;
	var $error;
	var $tmp;
	var $formTitle;
	var $subscrId;
	var $name;
	var $objPmReqSms;

	public function __construct()
	{
		global $db;
		global $config_table_prefix;
		$arr = $db->fetchAssoc("select `processor_table`, `processor_ret_table` from ".TABLE_PAYMENT_PROCESSORS." where `processor_code` like 'mobilpay'");

		$this->table = $config_table_prefix.$arr['processor_table'];
		$this->ret_table = $config_table_prefix.$arr['processor_ret_table'];
		$this->products_table = $config_table_prefix."mobilpay_products";
		$this->subscrAutoRenew = 0;
		$this->subscrId = 0;
		$this->name = "mobilpay";

	}
	

	function getTable() {
		
		global $db;
		global $config_table_prefix;
		$table = $config_table_prefix.$db->fetchRow("select `processor_table` from ".TABLE_PAYMENT_PROCESSORS." where `processor_code` like 'mobilpay'");
		return $table;
	}

	function setTable($table) {

		$this->table = $table;
	
	}

	function init($key = '') {

		global $config_live_site;
		$this->pending = 0;
		if($key) $this->user_key = $key;
		else $this->user_key = isset($_GET['ukey'])?$_GET['ukey']:md5(uniqid(rand(), true));
		$this->postback_url = $config_live_site."/payment_return/mobilpay.php";

		$this->pay_settings = $this->getSettings();
		
		$this->mobilpay_keys = array( "purchase", "action", "timestamp", "error" );

		$this->objPmReqSms = new Mobilpay_Payment_Request_Sms();
		#merchant account signature - generated by mobilpay.ro for every merchant account
		#semnatura contului de comerciant - mergi pe www.mobilpay.ro Admin -> Conturi de comerciant -> Detalii -> Setari securitate
		
		$this->objPmReqSms->signature 	= $this->pay_settings['mobilpay_signature'];

		#supply return_url and/or confirm_url only if you want to overwrite the ones configured for the service/product when it was created
		#if you don't want to supply a different return/confirm URL, just let it null
		$this->objPmReqSms->returnUrl 	= $this->postback_url.'?mode=success&amp;ukey='.$this->user_key;
		$this->objPmReqSms->confirmUrl 	= $this->postback_url.'?mode=process&amp;ukey='.$this->user_key;

		
			       
	}

	function getUserKey() {

		return $this->user_key;

	}

	function setDebug($val) {

		$this->debug = $val;

	}

	function getPost() {
	    return;
	}

	function setFormTitle($val) {

		$this->formTitle = $val;

	}

	// recurring payments
	function setSubscription($total, $days) {

	}

	function setFirstSubscription($amount, $days) {

	}

	function setInvoiceNo($val) {

		$this->invoice_no = $val;
		
		#you should assign here the transaction ID registered by your application for this commercial operation
		#order_id should be unique for a merchant account
		$this->objPmReqSms->orderId = $val;

		// last step before constructing the form
		// encrypt and create the form variables
		$this->objPmReqSms->encrypt($this->pay_settings['mobilpay_certificate']);
		$this->post['env_key'] = $this->objPmReqSms->getEnvKey();
		$this->post['data'] = $this->objPmReqSms->getEncData();
		
	}

	function setPostBack($str) {

		$this->postback_url = $str;

	}


	function setAmount($str) {

		global $db;
		$product = $db->fetchAssoc("select * from ".$this->products_table." where `price` = '".$str."' limit 1");
		if(!$product) {
			$product = $db->fetchAssoc("select * from ".$this->products_table." where `price` > '".$str."' order by `price` asc limit 1");
		}
		$this->objPmReqSms->service = $product['service'];

		$amount = number_format($product['price'], 2, '.', '');
		$this->amount = $amount;

	}

	function setDemo($value) {

		if($value==1) $this->mobilpay_url = 'http://sandboxsecure.mobilpay.ro';
		else $this->mobilpay_url = 'https://secure.mobilpay.ro';
		return 1;

	}

	function setPending($val) {

		$this->pending = $val;

	}

	function getPending() {

		return $this->pending;

	}

	function getSettings() {

		global $db;
		$result = $db->fetchAssoc("select * from ".$this->table);
		$result['products'] = $db->fetchAssocList("select * from ".$this->products_table);
		return $result;

	}

	function getForm()
	{

		$form = <<<ENDFORM
<form method="post" name="payment_form" id="payment_form" action="%s">
%s
<input type="submit" name="submit_payment" />
</form>
ENDFORM;

		$inputs = '';
		foreach($this->post as $key => $val) 
		{
			$inputs .= '<input type="hidden" name="'.$key.'" value="'.$val.'"/>
';
		}

		$str =  sprintf($form, $this->mobilpay_url, $inputs);
		return $str;

	}

	function process()
	{

		if (strcasecmp($_SERVER['REQUEST_METHOD'], 'post') == 0) { $this->log("Invalid request metod for payment confirmation"); return 0; }
		
		if(!isset($_POST['env_key']) || !isset($_POST['data']))  { $this->log("mobilpay.ro posted invalid parameters"); return 0; }

		$ret = $this->validateData();

		$success = $this->saveToDB();
		if(!$success) $this->log("saveToDB: ERROR: Cannot save to db!");

		$this->logIt($ret);

		return $ret;
		
	}

	function validateData() {
		
		try
		{
			$objPmReq = Mobilpay_Payment_Request_Abstract::factoryFromEncrypted($_POST['env_key'], $_POST['data'], $this->pay_settings['mobilpay_private_key']);
	    	switch($objPmReq->objPmNotify->action)
	    	{
	        case 'confirmed':
	        	//$errorMessage = $objPmReq->objPmNotify->getCrc();
	        	return 1;
	            break;
	        default:
	            $this->log("validateData - ERROR: mobilpay_refference_action paramater is invalid");
	            return 0;
	            break;
	    	}
		}
		catch(Exception $e)
		{
			$errorType 		= Mobilpay_Payment_Request_Abstract::CONFIRM_ERROR_TYPE_TEMPORARY;
			$errorCode		= $e->getCode();
			$errorMessage 	= $e->getMessage();
			$this->log("validateData - ERROR: ".$errorMessage);
			return 0;
		}

		return 1;
	}
	
	
	function saveToDB()
	{

		global $db;
		$addtosql = '';
		$entirepost = '';

		global $config_abs_path;

		foreach($this->result as $key => $val) 
		{
			if(in_array($key, $this->mobilpay_keys)) 
			{
				$addtosql .= $key."='".$val."',";
			}
			$entirepost .= "[".$key."]=\'".$val."\',";
		}
		$addtosql = rtrim($addtosql,','); 

		$res_upd = $db->query("update ".TABLE_PAYMENT_ACTIONS." SET completed='1' where ukey='".$this->user_key."'");

		$timestamp = date("Y-m-d H:i:s");
		$res = $db->query("INSERT INTO ".$this->ret_table." SET date='$timestamp', entirepost='".$entirepost."', ".$addtosql.",ukey='".$this->user_key."'");

		return 1;

	}

	function isAutoRenew() {

		return $this->isSub;

	}

	function subscrAutoRenew() {

		return $this->isSub;

	}

	function getSubscriptionId() {

		return $this->subscrId;

	}

	function logIt($success)
	{
		if(!$this->debug) return;
		// Generate content
		$content = "-----------------------------------\n".date("r")."\n";

		$content .= "\nRECEIVED POST:\n";

		foreach($_POST as $key => $val)
		{
			$content .= $key."=".$val."\n";
		}
		$content .= "-----------------------------------\n";

		// Create File
		global $config_abs_path;
		$file = $config_abs_path."/log/mobilpay_transaction";
		if(!$success) $file = $config_abs_path."/log/mobilpay_error";

		$handle = fopen($file, "a");
		fwrite($handle, $content);
		fclose($handle);
	}

	function log($msg)
	{
		if(!$this->debug) return;

		$content = "-----------------------------------\n".date("r")."\n";
		$content .= $msg."\n";
		$content .= "-----------------------------------\n";

		global $config_abs_path;
		$file = $config_abs_path."/log/mobilpay_debug";

		$handle = fopen($file, "a");
		fwrite($handle, $content);
		fclose($handle);
	}

	function getError() {
	
		return $this->error;

	}

	function addError($str) {

		$this->error.=	$str;

	}

	function setError($str) {

		$this->error=$str;

	}

	function getTmp() {
	
		return $this->tmp;

	}

	function saveSettings() {

		global $lng;
		$this->error='';
		$this->tmp=array();

		$this->clean=array();

		global $config_demo;
		if($config_demo==1) $this->addError($lng['general']['errors']['demo'].'<br />');

		global $db;
		$test = checkbox_value("mobilpay_test");
		$sql = "update ".$this->table." set `mobilpay_test`=$test";

		$array_fields = array( "mobilpay_signature", "mobilpay_certificate", "mobilpay_private_key" );
		$i = 0;
		foreach ($array_fields as $field) {

			if(isset($_POST[$field])) $this->clean[$field] = escape($_POST[$field]); else $this->clean[$field] = '';
			$sql.=", `$field` = '".$this->clean[$field]."'";
			$i++;

		}

		$db->query($sql);
		return 1;
	}

	function correctSettings() {
		return true;
	}

	
	function deleteProduct($id) {

		global $config_demo;
		if($config_demo==1) return;
		
		global $db;
		$db->query("delete from ".$this->products_table." where id='$id'");
		return 1;
	}

	function addProduct() {

		global $lng;
		$this->error='';
		$this->tmp=array();

		$this->clean=array();
		//$this->check_form();
		//if($this->getError()!='') return 0;

		global $config_demo;
		if($config_demo==1) $this->addError($lng['general']['errors']['demo'].'<br />');

		global $db;
		$sql = "insert into ".$this->products_table." set ";

		$array_fields = array( "service", "price" );

		$i = 0;
		foreach ($array_fields as $field) {
			if(isset($_POST[$field])) $this->clean[$field] = escape($_POST[$field]); else $this->clean[$field] = '';
			if($i) $sql.=", ";
			$sql.="`$field` = '".$this->clean[$field]."'";
			$i++;
		}

		$db->query($sql);
		return 1;

	}
}
?>
