<?php
/*
	*	
	* OxyClassifieds.com : PHP Classifieds (http://www.oxyclassifieds.com)
	* version 9
	* (c) 2017 OxyClassifieds.com (office@oxyclassifieds.com).
	*
*/

$minimal = 0;
if($_POST) {
//print_r($_POST); exit(0);
	global $minimal;
	$minimal = 1;
}
if($minimal) {
	require_once "include/include_min.php";
	global $config_abs_path;
	require_once $config_abs_path."/add_hooks.php";
}
else
	require_once "include/include.php";

global $config_abs_path;
global $db;
global $post_array;

$seo = new seo();
global $keyword_name, $non_latin_url;
$post_array = array($keyword_name =>"", "category" =>"", "user_id"=>"", "price_low" =>"", "price_high" =>"", "currency" =>"", "order" => "", "order_way" => "", "with_pic" => "", "show" => "", "with_auction" => "");

$order1_array = array("date_added", "price","title");
$order2_array = array("desc", "asc");
$show_array = array("list", "gallery");

global $page;
$page=1;
global $seo_settings, $settings, $ads_settings;

// if post, generate the url and redirect to that url
if($_POST) {
	$post_locations_array = array();
	// get post values
	foreach($_POST as $key=>$val)
	{

		// slash signs will be replaced with underscore signs
		$val = str_replace("/", "__", $val);
		// $ sign will be replaced with ~~
		$val = str_replace("$", "~~", $val);
		// & sign will be replaced with ||
		$val = str_replace("&", "||", $val);


		switch($key) {

			case "search":
			case "Search":
			case "Save-search":
			case "x":
			case "y":
			case "page":
			case "qs_category1":
			case "qs_category2":
			case "qs_category3":
			case "qs_category4":
			case "qs_category5":
				break;
			case "category":
			case "user_id":
			case "price_low":
			case "price_high":
				if($val && is_numeric($val)) $post_array[$key] = $val;
				break;
			case "currency":
			case $keyword_name:
				if($val) $post_array[$key] = $val;//_mb_strtolower(urlencode(strip_tags($val)));
				break;
			case "order":
				if($_POST['order'] &&  in_array($_POST['order'],$order1_array)) $post_array['order'] = $_POST['order'];
				break;
			case "order_way":
				if($_POST['order_way'] &&  in_array($_POST['order_way'],$order2_array)) $post_array['order_way'] = $_POST['order_way'];
				break;
			case "show":
				if($_POST['show'] &&  in_array($_POST['show'],$show_array)) $post_array['show'] = $_POST['show'];
				break;
			case "with_pic":
				$post_array['with_pic'] = checkbox_value('with_pic');
				break;
			case "with_auction":
				$post_array['with_auction'] = checkbox_value('with_auction');
				break;
			default: 
				// temporary fields for date fields
				if(preg_match ('/^([^\/])+(_low_vis)$/', $key) || preg_match ('/^([^\/])+(_high_vis)$/', $key) || preg_match ('/^([^\/])+(_vis)$/', $key) || preg_match ('/^(dep_id)([^\/])+$/', $key)) break;
				// remove qs_ if the search was made with quick search
				if(preg_match ('/^(qs_)([^\/])+$/', $key)) $key = substr($key, 3);
				
				if($val!='') $post_array["$key"] =  $val;//_mb_strtolower(strip_tags($val));

				// save location fields 
				if($settings['enable_locations'] && in_array($key, explode(",", $settings['location_fields'])) ) {
					$post_locations_array[$key] = rawurldecode($val);
				}
				break;

		} // end switch
		
	} // end foreach post

	if($settings['enable_locations']) 
	{ 
		require_once $config_abs_path."/classes/locations.php";
		$lclass = new locations();
		$lclass->init();
		$lclass->initLiveSiteUrl();
		$lclass->setPostLocation($post_locations_array);
	}


	// generate the url 
	if($seo_settings['enable_mod_rewrite']) {

		require_once $config_abs_path."/classes/categories.php";
		$url_str = $seo->makeSearchLink($post_array, 1);

	}
	else {

		$query = "";
		foreach ($post_array as $key=>$value) {

			// skip area field from areasearch module
			if($value=='' && $key!="area") continue;
			// don't add show and order elements if default values
			if($key=="show" || ($key=="order" && $value=="date_added") || ($key=="order_way" && $value=="desc")) continue;
			// don't add location fields to the url
			if(in_array($key, explode(",", $settings['location_fields']))) continue;

			if(($key!="order" || $value!="date_added") && ($key!="order_way" || $value!="desc"))
				$sign="&";

			$query.=$sign.$key."="._urlencode($value, 0);
		}

		global $config_live_site;
		$url_str = $config_live_site;
		$url_str.="/listings.php?page=1".$query;
	}

	do_action("search_keyword", array($post_array[$keyword_name]));

	header("Location: $url_str");
	exit(0);

} // end if $_POST

require_once "classes/pictures.php";
require_once "classes/paginator.php";
require_once $config_abs_path."/libs/JSON.php";

// you get here by browsing pages or refining the search

if($settings['enable_locations']) { 
	require_once $config_abs_path."/classes/locations.php";
	$lclass = new locations();
	$lclass->init();
}

$has_search_fields = 0;
if($_SERVER['QUERY_STRING']) {

	if($seo_settings['enable_mod_rewrite']) {
		$query_string = $_SERVER['QUERY_STRING'];
		$args_arr = explode("&", $_SERVER['QUERY_STRING']);
		foreach ($args_arr as $a) {
			if(strstr($a, "listings.html"))  {$query_string = $a; break; }
		}
		
		$args = explode("/", $query_string);
	} else {
		$page = get_numeric("page");
		$args = explode("&",$_SERVER['QUERY_STRING']);
	}

	$i = 0;
	foreach($args as $arg)
	{

		if($seo_settings['enable_mod_rewrite']) {
			// check for page string
			if(is_numeric($arg)) { $page = $arg; $i++; continue; }

			// if the first argument, check if category is set
			if($i==0) {

				$keyval = explode("-",$arg);
				if(is_numeric($keyval[0])) { $post_array['category'] = $keyval[0]; $i++;  $has_search_fields = 1; continue; }
				if(preg_match("/^crt_city=(.*)+$/", $keyval[0]) ) continue;
	
			}

			$keyval = explode("-",$arg,2);

		} 
		else {

			$keyval = explode("=",$arg);

		}

		if(!$seo_settings['enable_mod_rewrite'] || count($keyval)>1) {

		// get slashes back 
		$keyval[1] = str_replace("__", "/", $keyval[1]);

		// get $ sign back
		$keyval[1] = str_replace("~~", "$", $keyval[1]);

		// get & sign back
		$keyval[1] = str_replace("||", "&", $keyval[1]);

		switch($keyval[0]) {

			case "search":
			case "Search":
			case "x":
			case "y":
				break;
			// quick search
			case "qs_".$keyword_name:
				if($keyval[1]) $post_array[$keyword_name] = cleanSearchString($keyval[1]);
  				$has_search_fields = 1;
				break;
			case "qs_category":
			case "qs_user_id":
			case "qs_price_low":
			case "qs_price_high":
				$keyval[0] = substr($keyval[0], 3);
				if($keyval[1]) $post_array[$keyval[0]] = cleanSearchString($keyval[1]);
  				$has_search_fields = 1;
				break;
			case "qs_currency":
				$keyval[0] = 'currency';
				$currency_val = cleanSearchString($keyval[1]);
				if($keyval[1]) $post_array[$keyval[0]] = $currency_val;
  				$has_search_fields = 1;

				global $modules_array;
  				if(in_array("multicurrency", $modules_array)) {
					$mc = new multicurrency();
					$mc->setMulticurrencyCookie($keyval[1]);
  				}

  				break;
			// refine search
			case $keyword_name:
				if($keyval[1]) $post_array[$keyword_name] = cleanSearchString($keyval[1]);
  				$has_search_fields = 1;
				break;
			case "category":// only when mod rewrite is not on
			case "user_id":
			case "price_low":
			case "price_high":
				if($keyval[1] && is_numeric($keyval[1])) $post_array[$keyval[0]] = $keyval[1];
  				$has_search_fields = 1;
				break;
			case "currency":
				$currency_val = cleanSearchString($keyval[1]);
				if($keyval[1]) $post_array[$keyval[0]] = $currency_val;
  				$has_search_fields = 1;
  				
  				global $modules_array;
  				if(in_array("multicurrency", $modules_array)) {
					$mc = new multicurrency();
					$mc->setMulticurrencyCookie($keyval[1]);
  				}
  				
				break;
			case "order":
				if($keyval[1] &&  in_array($keyval[1],$order1_array)) $post_array['order'] = $keyval[1];
  				$has_search_fields = 1;
				break;
			case "order_way":
				if($keyval[1] &&  in_array($keyval[1],$order2_array)) $post_array['order_way'] = $keyval[1];
  				$has_search_fields = 1;
				break;
			case "with_pic":
				if($keyval[1]==0 || $keyval[1]==1) $post_array['with_pic'] = $keyval[1];
  				$has_search_fields = 1;
				break;
			case "with_auction":
				if($keyval[1]==0 || $keyval[1]==1) $post_array['with_auction'] = $keyval[1];
  				$has_search_fields = 1;
				break;
			case "show":
				if($keyval[1] &&  in_array($keyval[1],$show_array)) $post_array['show'] = $keyval[1]; else break;
				global $main_domain;
				$expire = time() + 60*60*24*365;
				setcookie('show', $post_array['show'], $expire, '/', ".".$main_domain);
  				$has_search_fields = 1;
				break;
			default: 

  				$has_search_fields = 1;
				$post_array[$keyval[0]] = cleanSearchString($keyval[1]);

				// can only be set with refine search, only one at once
				if($settings['enable_locations'] && in_array($keyval[0], explode(",", $settings['location_fields']))) { 

					$lclass->setLocation($keyval[0], cleanSearchString($keyval[1]));

				}

				break;

		} // end switch

		} // end if(!$seo_settings['enable_mod_rewrite'] || count($keyval)>1)
	}

}

// set value for show page type
global $is_mobile;
if(!$is_mobile) {
    if( !$post_array['show'] && isset($_COOKIE['show']) && $_COOKIE['show'] && in_array($_COOKIE['show'], $show_array)) $post_array['show'] = $_COOKIE['show'];
    if(!$post_array['show']) $post_array['show'] = $ads_settings['default_search_view']?"gallery":"list";
}

global $lng;
$smarty = new Smarty;
$smarty = common($smarty);
$smarty->assign("lng",$lng);
$smarty->assign("section","listings");
$smarty->assign("crt_uri",$_SERVER['REQUEST_URI']);

$groups_list = common::getCachedObject("base_short_groups");
$smarty->assign("groups_list",$groups_list);

if($is_mobile) {
	global $mobile_settings;
	$ads_per_page=$mobile_settings["mobile_ads_per_page"];
} else {
	global $appearance_settings;
	$ads_per_page=$appearance_settings["ads_per_page"];
}

$listings=new listings();
if(!$page) $page=1;

if($post_array['category']) { 
	require_once $config_abs_path."/classes/categories.php";
	$categ = new categories();
	$cat_name = cleanStr(categories::getName($cat));
	
}
else { 
	$cat_name = '';
	$cat=0;
}
$smarty->assign("category_name",$cat_name);


if($cat) $fset = categories::getFieldset($cat);
else $fset = 0;
// fields list 
$base_refine_fields_list = common::getCachedObject("base_refine_fields_list", array("fieldset" => $fset));

// if a location field is set as a cookie, set it for $post_array
if($settings['enable_locations'] && $base_refine_fields_list) {
	$post_array = $lclass->checkPostArray($base_refine_fields_list, $post_array);
}

if(!$is_mobile) {

	// compile subcategories list
	global $short_categories;
	$subcategories_array = array();
	$i=0;
	$parent_id = 0;
	foreach($short_categories as $crt_cat) {
		if($crt_cat['id']==$cat) { $parent_id = $crt_cat['parent_id']; }
		if($crt_cat['parent_id']==$cat) {

			$subcategories_array[$i++] = $crt_cat;

		}
	}// end foreach $short_categories
	$smarty->assign("categories_array",$subcategories_array);

	$cat_path ="";
	// category_path
	if($cat) {
		if($parent_id) $cat_path = $categ->catPath($parent_id,$cat_name);
		else $cat_path = $cat_name;
		$smarty->assign("category_path",$cat_path);

	} // end if $cat


	$base_refine_fields = common::getCachedObject("base_refine_fields", array("fieldset" => $fset));

	//get values for next depending fields if one field is selected
	require_once $config_abs_path."/classes/fields.php";
	require_once $config_abs_path."/classes/depending_fields.php";
	$cf = new fields('cf');
	if($post_array && $base_refine_fields)
		$base_refine_fields = $cf->getSearchDepValues($base_refine_fields, $post_array);

	$smarty->assign("fields", $base_refine_fields);

} // end if not mobile

// add subcategories list instead of just category for advanced search query
$post_array_sql = $post_array;

if($cat) {
	// subcategories list for search ads belonging to subcategories
	$s = "";
	$post_array_sql['category'] = $categ->subcatList($cat, $s);
}

// prepare for mysql
foreach($post_array_sql as $key=>$value) {
	$post_array_sql[$key] = escape($value);
}

$listings_array=$listings->getAdvSearch($post_array_sql, $page, $ads_per_page);
$no_listings = $listings->noListings();
//_print_r($listings_array);
// ---------- randomize prioritized ads -----------
if($ads_settings['random_priorities']) {
	// get number of priority ads
	$no_prioritized = 0;
	$start_prioritized = 0;
	$pos=0;
	foreach($listings_array as $l) {
		if($l['priority'] && $l['priority']!=100) { // not bumped ads 
			if(!$start_prioritized) $start_prioritized = $pos;
			$no_prioritized++; 
		} 
		$pos++;
	}

	if($no_prioritized) {
		// get subarray of prioritized ads
		$prioritized = array_slice($listings_array, $start_prioritized, $no_prioritized);

		// shuffle order for prioritized ads
		$numbers = range(0, $no_prioritized-1);
		shuffle($numbers);
		//$i = 0;
		foreach($numbers as $j) {
			$listings_array[$start_prioritized] = $prioritized[$j];
			$start_prioritized++;
		}
	}
}
// ---------- end randomize prioritized ads -----------
$smarty->assign("listings_array",$listings_array);
$smarty->assign("no_listings",$no_listings);

// if no search result mark page as noindex, nofollow
$noindex=0;
if(!$no_listings) $noindex=1;
$smarty->assign("noindex", $noindex);

// allow only a limited number of pages to display
$new_page = checkPageNo($page, $ads_per_page);
$info = '';
if($new_page<$page) {
	$page = $new_page;
	$info = $lng['search']['high_no_results'];
}
$smarty->assign("info", $info);

$paginator = new paginator($ads_per_page);
$paginator->setItemsNo($no_listings);
$paginator->paginate($smarty);

$smarty->assign("post_array",$post_array);
$smarty->assign("has_search_fields",$has_search_fields);


// set meta info 
// after cofiguring location filter and after setting the current page
$seo->setMetaInfo($self_noext, $smarty);

// do actions for "search_meta", after setMetaInfo !
do_action("search_meta", array($smarty, $post_array));

// save search & email alerts

if(!$is_mobile && ($ads_settings['alerts_enabled'] || $ads_settings['saved_searches_enabled'])) {

	$post_clear = array();
	foreach($post_array as $key => $value) {
		if($value=='') continue;
		if($key=="page" || $key=="order_way" || $key=="order" || $key=="show") continue;
		$post_clear[$key] = base64_encode($value);
	}

	$post_json = "";
	if($post_clear) {
		$post_json = json_encode($post_clear);
	}
	$smarty->assign("post_json",$post_json);
}

// email alerts
if(!$is_mobile && $ads_settings['alerts_enabled']) {

	require_once "classes/alerts.php";
	require_once "classes/categories.php";
	$str_search = "";
	$alerts = new alerts();
	$str_search = $alerts->makeSearchString($post_array);
	$smarty->assign("str_search",$str_search);
	
}

// if search maps enabled
if(!$is_mobile && $ads_settings['enable_map_search']) {
	$gmap_field = common::getCachedObject("base_gmap_fields", array("fieldset" => $fset));
	$smarty->assign("gmap_field",$gmap_field);
}

// do search actions
// not sql escaped array
do_action("search1", array($smarty, $post_array));
do_action("listings_page", array($smarty));

$db->close();
if($db->error!='') { $db_error = $db->getError(); $smarty->assign('db_error',$db_error); }

$smarty->display('listings.html');
close();
?>
