(function($){

  'use restrict';

  $(document).ready(function(){
      $('.rt-logo-item.rt-tooltip').hover(
          function() {
              var $this = $( this );
              var $title = $this.attr('data-title');
              $tooltip = '<div class="rt-tooltip">' +
                  '<div class="rt-tooltip-content">'+$title+'</div>'+
                  '<div class="rt-tooltip-bottom"></div>'+
                  '</div>';
              $('body').append( $tooltip );
              var $tooltip = $('body > .rt-tooltip');
              var tHeight = $tooltip.outerHeight();
              var tBottomHeight = $tooltip.find('.rt-tooltip-bottom').outerHeight();
              var tWidth = $tooltip.outerWidth();
              var tHolderWidth = $this.outerWidth();
              var top = $this.offset().top - (tHeight + tBottomHeight);
              var left = $this.offset().left;
              $tooltip.css('top',top+'px');
              $tooltip.css('left',left+'px');
              $tooltip.css('opacity', 1);
              $tooltip.show();
              if(tWidth <= tHolderWidth){
                  var itemLeft = (tHolderWidth - tWidth)/2;
                  left = left + itemLeft;
                  $tooltip.css('left',left+'px');
              }else{
                  var itemLeft = (tWidth - tHolderWidth)/2;
                  left = left - itemLeft;
                  if(left < 0){
                      left = 0;
                  }
                  $tooltip.css('left',left+'px');
              }
          }, function() {
              $( 'body > .rt-tooltip' ).remove();
          }
      );
  });
 /* isotope */
if($(".rt-logo-isotop-container").length){
  var $isotop = $('.rt-logo-item-container').imagesLoaded( function() {
    $isotop.isotope({
          // options
          itemSelector: '.isotope-item',
          layoutMode: 'fitRows'
        });
    });

   $('.filter-button-group').on( 'click', 'button', function(e) {
       e.preventDefault();
     var filterValue = $(this).attr('data-filter');
     $isotop.isotope({ filter: filterValue });
     $(this).parent().find('.selected').removeClass('selected');
     $(this).addClass('selected');
       return false;
   });
 }

   $(window).resize(heightResize);
   $(window).load(heightResize);
    $(".rt-logo-showcase").each(function(){
        var $carousel = $( this ).find('.rt-logo-item-container.rt-carousel');
        if($carousel.length) {
            $.when( heightResize() ).done(function() {
                $carousel.slick({
                    responsive: [
                        {
                            breakpoint: 600,
                            settings: {
                                slidesToShow: 2,
                                slidesToScroll: 2
                            }
                        },
                        {
                            breakpoint: 480,
                            settings: {
                                slidesToShow: 1,
                                slidesToScroll: 1
                            }
                        }
                    ]
                })
            });
        }
    });

  /*Start from here */

})(jQuery);


function heightResize(){
  jQuery(".rt-logo-item-container").each(function(){

    var maxH=0;
    jQuery(this).find(".rt-logo-item" ).height("auto");
    jQuery(this).find(".rt-logo-item" ).each(function( ) {
        var cH = jQuery(this).actual( 'outerHeight' );
        if(cH > maxH){
              maxH = cH;
         }

    });

    jQuery(this).find(".rt-logo-item" ).css('height',maxH+"px");

  });
}