<?php
/**
 * @version    2.0
 * @package    com_rtlogoshowcase
 * @author     RadiusTheme <support@radiustheme.com>
 * @copyright  Copyright (C) 2016. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

/**
 * Class RtlogoshowcaseFrontendHelper
 *
 * @since  1.6
 */
class RtlogoshowcaseHelpersRtlogoshowcase
{
	/**
	* Get category name using category ID
	* @param integer $category_id Category ID
	* @return mixed category name if the category was found, null otherwise
	*/
	public static function getCategoryNameByCategoryId($category_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query
			->select('title')
			->from('#__categories')
			->where('id = ' . intval($category_id));

		$db->setQuery($query);
		return $db->loadResult();
	}

	/**
	 * Get Gategory for isotope
	 */
	public static function getCategoryName($cat_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		JFactory::getLanguage()->getTag();
	 	$multilang=JLanguageMultilang::isEnabled();

	 	@$category = implode(",", $cat_id);

		$query->select('a.id,a.title,a.lft');
		$query->from('#__categories a');
		if($category){
		$query->where("a.id IN({$category})");
		}
		$query->where('extension = "com_rtlogoshowcase"');
		
		$query->where('a.published = 1');
		// Filter by language
		if ($multilang)
		{
			$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}
		$query->order('a.lft');
		//echo $query;
		$db->setQuery($query);
		return $db->loadobjectlist();
	}
	/**
	 * Get an instance of the named model
	 *
	 * @param   string  $name  Model name
	 *
	 * @return null|object
	 */
	public static function getModel($name)
	{
		$model = null;

		// If the file exists, let's
		if (file_exists(JPATH_SITE . '/components/com_rtlogoshowcase/models/' . strtolower($name) . '.php'))
		{
			require_once JPATH_SITE . '/components/com_rtlogoshowcase/models/' . strtolower($name) . '.php';
			$model = JModelLegacy::getInstance($name, 'RtlogoshowcaseModel');
		}

		return $model;
	}
}
