(function ($) {

    'use strict';


    $(function () {
        /* Fixing for hover effect at IOS */
        $('*').on('touchstart', function () {
            $(this).trigger('hover');
        }).on('touchend', function () {
            $(this).trigger('hover');
        });

        loadPortfolioSingleSlider();
    });

    $(window).resize(navResize);
    $('.tlp-single-item-popup').on('click', function () {

        var current;
        var baseURL = "index.php?option=com_tlpportfolio&task=portfolioSingleItem&format=raw";
        var id = $(this).attr("data-id");
        current = id;
        var itemArray;
        if ($("#tlp-port-item-count").length) {
            itemArray = $("#tlp-port-item-count span").map(function () {
                return $(this).text();
            }).get();
        }
        $.ajax({
            type: "post",
            url: baseURL,
            data: "id=" + current,
            beforeSend: function () {
                initPopup();
                setLevel(current, itemArray);
            },
            success: function (data) {
                $("#tlp-popup-wrap .tlp-popup-content").html(data);
            },
            error: function () {
                $("#tlp-popup-wrap .tlp-popup-content").html("<p>Loading error!!!</p>");
            }
        });
        $('.tlp-popup-next').on('click', function () {
            rightClick();
        });
        $('.tlp-popup-prev').on('click', function () {
            leftClick();
        });
        $('.tlp-popup-close').on('click', function () {
            animation();
        });

        $(window).bind('keydown', function (event) {
            if (event.keyCode === 27) { // Esc
                animation();
            } else if (event.keyCode === 37) { // left arrow
                leftClick();
            } else if (event.keyCode === 39) { // right arrow
                rightClick();
            }
        });

        function rightClick() {
            var nextId = nextItem(current, itemArray);
            current = nextId;
            $.ajax({
                type: "post",
                url: baseURL,
                data: "id=" + current,
                beforeSend: function () {
                    setLevel(current, itemArray);
                    $('#tlp-popup-wrap .tlp-popup-content').html('<div class="tlp-popup-loading"></div>');
                },
                success: function (data) {
                    $('#tlp-popup-wrap .tlp-popup-content').html(data);
                }
            });
        }

        function leftClick() {
            var prevId = prevItem(current, itemArray);
            current = prevId;
            //console.log(current);
            $.ajax({
                type: "post",
                url: baseURL,
                data: "id=" + current,
                beforeSend: function () {
                    setLevel(current, itemArray);
                    $('#tlp-popup-wrap .tlp-popup-content').html('<div class="tlp-popup-loading"></div>');
                },
                success: function (data) {
                    $('#tlp-popup-wrap .tlp-popup-content').html(data);
                }
            });
        }

        return false;
    });
    var $isotop = $('.portfolio-grid');
    if($isotop.length) {
        $isotop.imagesLoaded(function () {
            $isotop.isotope({
                // options
                itemSelector: '.tlp-portfolio-item',
                layoutMode: 'fitRows'
            });
        });

        $('.filter-button-group').on('click', 'button', function () {
            var filterValue = $(this).attr('data-filter');
            $isotop.isotope({filter: filterValue});
            $(this).parent().find('.selected').removeClass('selected');
            $(this).addClass('selected');
        });
    }
    var $gisotop = $('.tlp-portfolio > .masonry-grid');
    if($gisotop.length) {
        $gisotop.imagesLoaded(function () {
            $gisotop.isotope({
                itemSelector: '.masonry-item',
                layoutMode: 'masonry',
                masonry: {
                    columnWidth: '.masonry-item'
                }
            });
        });
        $('.filter-button-group').on('click', 'button', function () {
            var filterValue = $(this).attr('data-filter');
            $gisotop.isotope({filter: filterValue});
            $(this).parent().find('.selected').removeClass('selected');
            $(this).addClass('selected');
        });
    }
    $(window).on('resize load', function(){
        HeightResize();
        overlayIcon();
    })

})(jQuery);

function overlayIcon() {
    jQuery('.tlp-item').each(function () {
        var holder_height = jQuery(this).height();
        var a_height = jQuery(this).find('.tlp-overlay .link-icon').height();
        var h = (holder_height - a_height) / 2;
        jQuery(this).find('.link-icon').css('margin-top', h + 'px');
    });
}

function HeightResize() {
    var maxH = 0;
    jQuery(".tlp-portfolio .tlp-equal-height").height("auto");
    jQuery(".tlp-portfolio .tlp-equal-height").each(function () {
        var cH = jQuery(this).height();
        if (cH > maxH) {
            maxH = cH;
        }
        //console.log(maxH);
    });
    jQuery(".tlp-portfolio .tlp-equal-height").height(maxH + "px");
}

function initPopup() {
    var html = '<div id="tlp-popup-wrap" class="tlp-popup-wrap tlp-popup-singlePage-sticky tlp-popup-singlePage">' +
        '<div class="tlp-popup-content">' +
        '<div class="tlp-popup-loading"></div>' +
        '</div>' +
        '<div class="tlp-popup-navigation-wrap">' +
        '<div class="tlp-popup-navigation">' +
        '<div class="tlp-popup-prev" title="Previous (Left arrow key)" data-action="prev"></div>' +
        '<div class="tlp-popup-close" title="Close (Esc arrow key)" data-action="close"></div>' +
        '<div class="tlp-popup-next" title="Next (Right arrow key)" data-action="next"></div>' +
        '<div class="tlp-popup-singlePage-counter"><span class="ccurrent"></span> of <span class="ctotal"></span></div>' +
        '</div>' +
        '</div>' +
        '</div>';
    jQuery("body").append(html);
    var $pHolder = jQuery('#tlp-popup-wrap');
    $pHolder.css('display', 'block');
    var navHeight = $pHolder.find('.tlp-popup-navigation-wrap').height();
    var navHeightA = $pHolder.find('.tlp-popup-navigation-wrap').height() - 32;
    $pHolder.find('.tlp-popup-content').css('padding-top', navHeight + "px");
    jQuery('.admin-bar #tlp-popup-wrap .tlp-popup-content').css('padding-top', navHeightA + "px");
    animation();
}

function animation() {
    var $pHolder = jQuery('#tlp-popup-wrap');
    $pHolder.animate({
        marginLeft: parseInt($pHolder.css('marginLeft'), 10) == 0 ?
            $pHolder.outerWidth() : 0,
    }).promise().done(function () {
        if (parseInt($pHolder.css('marginLeft')) > 0) {
            jQuery('#tlp-popup-wrap').remove();
        }
    });
}

function nextItem(current, list) {
    var index = list.indexOf(current);
    index++;
    if (index >= list.length)
        index = 0;
    return list[index];
}
function prevItem(current, list) {
    var index = list.indexOf(current);
    index--;
    if (index < 0)
        index = list.length - 1;
    return list[index];
}

function setLevel(current, list) {
    var index = list.indexOf(current) + 1;
    var count = list.length;
    jQuery(".ccurrent").text(index);
    jQuery(".ctotal").text(count);
}

function loadPortfolioSingleSlider() {
    var sId = jQuery("#single-page-slider");
    if(sId.length) {
        sId.imagesLoaded(function () {
            sId.owlCarousel({
                items: 1,
                autoplay: true,
                navText: ['<i class="fa fa-chevron-left"></i>', '<i class="fa fa-chevron-right"></i>'],
                nav: true,
                dots: false,
                autoHeight: true
            });
        });
    }
}

function navResize() {
    var $pHolder = jQuery('#tlp-popup-wrap');
    $pHolder.css('display', 'block');
}
