<?php
/**
 * @version    2.0
 * @package    com_tlpportfolio
 * @author     TechLabPro <info@techlabpro.com>
 * @copyright  Copyright (C) 2015. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

/**
 * Class TlpportfolioFrontendHelper
 *
 * @since  1.6
 */
class TlpportfolioFrontendHelper
{
	/**
	* Get category name using category ID
	* @param integer $category_id Category ID
	* @return mixed category name if the category was found, null otherwise
	*/
	public static function getCategoryNameByCategoryId($category_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);

		$query
			->select('title')
			->from('#__categories')
			->where('id = ' . intval($category_id));

		$db->setQuery($query);
		return $db->loadResult();
	}
	/**
	 * Get Gategory for isotope
	 */
	public static function getCategoryName($category_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		JFactory::getLanguage()->getTag();
	 	$multilang=JLanguageMultilang::isEnabled();

	 	@$category = implode(",", $category_id);

		$query->select('a.id,a.title,a.lft');
		$query->from('#__categories a');
		$query->where('extension = "com_tlpportfolio"');
		$query->where('a.published = 1');
		// Filter by language
		if ($multilang)
		{
			$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}
		if($category>0){
			$query->where("a.id IN ($category)");
		}
		$query->order('a.lft');
		//echo $query;
		$db->setQuery($query);
		return $db->loadobjectlist();
	}

	/**
	 * Get all profile for isotope
	 */
	public static function getallPortfolio($category_id) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
	
		JFactory::getLanguage()->getTag();
	 	$multilang=JLanguageMultilang::isEnabled();

	 	@$category = implode(",", $category_id);

		// Select the required fields from the table.
		$query->select( 'DISTINCT a.*,c.title AS category_title,t.title AS tools_title');
		$query->from('`#__tlpportfolio_portfolio` AS a');
		// Join over the category 'category'
		$query->join('LEFT', '#__categories AS c ON c.id = a.category');
		// Join over the foreign key 'tools_used'
		$query->join('LEFT', '#__tlpportfolio_tools AS t ON t.id = a.tools_used');

		if($category>0){
			$query->where("a.category IN ($category)");
		}

		$query->where('a.state = 1');
		// Filter by language
		if ($multilang)
		{
			$query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
		}
		$query->order('a.ordering');


		$db->setQuery($query);
		//echo $query;
		return $db->loadobjectlist();
	}

	/******* */

	public static function getAllitemsCount($cid) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		@$cid = implode(",", $cid);
		$query
             	->select('a.*')
                ->from('#__tlpportfolio_portfolio a');
        $query->where('a.state = 1');
        
        if($cid>0){
            $query->where(" a.category IN($cid)");
        }
        //$query->where('a.state = 1 AND ');

		$db->setQuery($query);
		$rows=$db->loadobjectlist();
		return $rows;
	}
	public static function getCountbyCat($cid) {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
	
		$query
             	->select('a.*')
                ->from('#__tlpportfolio_portfolio a');
        $query->where('a.state = 1');
        $query->where(" a.category = $cid");

        //$query->where('a.state = 1 AND ');

		$db->setQuery($query);
		$rows=$db->loadobjectlist();
		return $rows;
	}

		public static function getTools($tools) {


			$values = (is_array($tools)) ? $tools : explode(',',$tools);

				$textValue = array();
				foreach ($values as $value){
					$db = JFactory::getDbo();
					$query = $db->getQuery(true);
					$query
							->select($db->quoteName('title'))
							->from('`#__tlpportfolio_tools`')
							->where($db->quoteName('id') . ' = ' . $db->quote($db->escape($value)));
					$db->setQuery($query);
					$results = $db->loadObject();
					if ($results) {
						$textValue[] = $results->title;
					}
				}

			return $tools_used = !empty($textValue) ? implode(', ', $textValue) : $tools;
		}
	/*******/

	/**
	 * Get an instance of the named model
	 *
	 * @param   string  $name  Model name
	 *
	 * @return null|object
	 */
	public static function getModel($name)
	{
		$model = null;

		// If the file exists, let's
		if (file_exists(JPATH_SITE . '/components/com_tlpportfolio/models/' . strtolower($name) . '.php'))
		{
			require_once JPATH_SITE . '/components/com_tlpportfolio/models/' . strtolower($name) . '.php';
			$model = JModelLegacy::getInstance($name, 'TlpportfolioModel');
		}

		return $model;
	}
}
