<?php
/**
 * @version     2
 * @package     com_tlpportfolio
 * @subpackage  mod_tlpportfolio
 * @author      TechLabPro <info@techlabpro.com>
 * @copyright   Copyright (C) 2015. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

/**
 * Helper for mod_tlpportfolio
 *
 * @package     com_tlpportfolio
 * @subpackage  mod_tlpportfolio
 * @since       1.6
 */
class ModTlpportfolioHelper
{
	/**
     * Retrieve component items
     * @param Joomla\Registry\Registry  &$params  module parameters
     * @return array Array with all the elements
     */
    public static function getLists(&$params) {
        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $mod_category=$params->get('mod_category');
        @$category = implode(",", $mod_category);

        JFactory::getLanguage()->getTag();
        $multilang=JLanguageMultilang::isEnabled();

        // Select the required fields from the table.
		$query->select( 'DISTINCT a.*,c.title AS category_title,t.title AS tools_title');
		$query->from('`#__tlpportfolio_portfolio` AS a');
		// Join over the category 'category'
		$query->join('LEFT', '#__categories AS c ON c.id = a.category');
		// Join over the foreign key 'tools_used'
		$query->join('LEFT', '#__tlpportfolio_tools AS t ON t.id = a.tools_used');
		$query->where('a.state = 1');

        if($category>0){
            $query->where("a.category IN ($category)");
        }
        // Filter by language
        if ($multilang)
        {
            $query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
        }
        $query->order('a.ordering');

        $db->setQuery($query, 0, $params->get('mod_projectcount'));

        $rows = $db->loadObjectList();
        return $rows;
    }
    
}
