<?php
/**
 * @version     1.0
 * @package     com_tlptestimonial
 * @subpackage  mod_tlptestimonial
 * @author      RadiusTheme <support@radiustheme.com>
 * @copyright   Copyright (C) 2017. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

/**
 * Helper for mod_tlptestimonial
 *
 * @package     com_tlptestimonial
 * @subpackage  mod_tlptestimonial
 * @since       1.6
 */
class ModTlptestimonialHelper
{
	/**
	 * Retrieve component items
	 *
	 * @param   Joomla\Registry\Registry &$params module parameters
	 *
	 * @return array Array with all the elements
	 */
	public static function getLists(&$params)
	{
		$db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $category=$params->get('category');
        $multilang=JLanguageMultilang::isEnabled();

        if(!is_array($category)){
            $category=array($category);
        }
        $category = implode(",", $category);

        $tlporder = $params->get('mod_tlporder');

        $query
                ->select('a.*,category.id')
                ->from('#__tlptestimonial_testimonial a');
        if($category>0){
            $query->where("a.state = 1 AND a.category IN({$category})");
        }else{
            $query->where('a.state = 1');
        }
        // Join over the category 'category'
		$query->select('category.category_name AS category_title');
		$query->join('LEFT', '#__tlptestimonial_category AS category ON category.id = a.category');

        // Filter by language
        if ($multilang)
        {
            $query->where('a.language in (' . $db->quote(JFactory::getLanguage()->getTag()) . ',' . $db->quote('*') . ')');
        }
        if($tlporder=='rand'){
            $query->order('RAND()');
        }else{  
            $query->order("a.$tlporder");
        }
        
        $db->setQuery($query, 0, $params->get('mod_testimonialcount'));
       //echo $query;
        $rows = $db->loadObjectList();
    
        return $rows;

	}


}
