<?php
/*
	*	
	* OxyClassifieds.com : PHP Classifieds (http://www.oxyclassifieds.com)
	* version 9
	* (c) 2017 OxyClassifieds.com (office@oxyclassifieds.com).
	*
*/

global $modules_array;
if(!isset($modules_array) || !in_array("spam_prevention", $modules_array)) return;

global $config_abs_path;
require_once $config_abs_path."/modules/spam_prevention/classes/spam_prevention.php";

function spam_check_mailto(&$sp_response, $ip='', $email='') {

	$type="mailto";
    $sp = new spam_prevention();
    $sp_settings = $sp->getSettings();
    
    if(!$sp_settings['check_contact_forms']) return;
    
    // check and block if the case
    $sp_response = $sp->spamCheck($ip, $email, $type);

}

function spam_check_register(&$sp_response, $ip='', $email='') {

	$type="register";
    $sp = new spam_prevention();
    $sp_settings = $sp->getSettings();
    
    if(!$sp_settings['check_registration']) return;
    
    // check and block if the case
    $sp_response = $sp->spamCheck($ip, $email, $type);

}

function spam_check_comments(&$sp_response, $ip='', $email='') {

	$type="comments";
    $sp = new spam_prevention();
    $sp_settings = $sp->getSettings();
    
    if(!$sp_settings['check_comments']) return;
    
    // check and block if the case
    $sp_response = $sp->spamCheck($ip, $email, $type);

}

function spam_check_reviews(&$sp_response, $ip='', $email='') {

	$type="reviews";
    $sp = new spam_prevention();
    $sp_settings = $sp->getSettings();
    
    if(!$sp_settings['check_reviews']) return;
    
    // check and block if the case
    $sp_response = $sp->spamCheck($ip, $email, $type);

}

function spam_check_post_ad_nologin(&$sp_response, $ip='', $email='') {

	$type="post_ad";
    $sp = new spam_prevention();
    $sp_settings = $sp->getSettings();
    
    //if(!$sp_settings['check_post_nologin']) return;
    
    // check and block if the case
    $sp_response = $sp->spamCheck($ip, $email, $type);

}

add_action('mailto_post', 'spam_check_mailto');
add_action('nologin_ad_post', 'spam_check_post_ad_nologin');
add_action('register_post', 'spam_check_register');
add_action('comments_post', 'spam_check_comments');
add_action('reviews_post', 'spam_check_reviews');

?>