<!-- <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"> -->
<html>
<head>
<title>OxyClassifieds Update 9.3 to 9.4 version</title>
<META HTTP-EQUIV="Pragma" CONTENT="no-cache"> 
<META HTTP-EQUIV="Cache-Control" CONTENT="no-cache"> 
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=utf8">
<style type="text/css">
* { margin:0; padding: 0; }
body {
    font-size: 100.01%;
    color: #000;
    background: #D7C4B5;
    text-align: center;
    padding: 0;
    margin: 0;
    font-family: Verdana, Helvetica, Geneva, Arial,sans-serif;
    font-size: 13px;
}
* html body * { overflow:visible;  z-index: 1; }
html { height: 100%; margin-bottom: 1px; font-size: 100.01%; }
h3 { margin: 20px 0; line-height: 25px; }
ol { width: 400px; text-align: left; margin: 0 auto;}
li { margin-top: 10px; }
em { color: #819c2e; }
.page_margins { text-align: center; margin: 0 auto; background: transparent; width: 700px; background: #fff; margin-top: 20px; border-radius: 10px; padding-top: 20px }
.main { min-height: 500px; margin-top: 40px;}
.error { color: #F8785A; }
.message { color: #999; }
.finish { margin: 40px 0; }
.footer { border-top: 1px solid #e0e0e0; color: #999; margin: 0 20px; padding: 20px 0; }
.button { background-color: #b7a495; border: 0 none; border-radius: 5px; color: #fff; cursor: pointer; display: inline-block; font-size: 1.2em; height: 42px; line-height: 42px; margin-bottom: 20px; padding: 0 40px; text-align: center; text-decoration: none; }
.button:hover { opacity: 0.8; }
</style>
<script type="text/javascript" src="libs/jQuery/jquery.js"></script>
</head>
<body>
<div class="page_margins">

	<div id="header"> 
		<h1>OxyClassifieds</h1>
		<h2>9.4 update</h2>
	</div>

	<div class="main">
	
<?php
ini_set("display_errors", "On");

require_once "include/include.php";

global $db, $config_table_prefix, $config_db_charset, $config_db_collation;
global $modules_array;
global $config_abs_path;

print_message("Updating banners table...");

$db->query("ALTER TABLE `".TABLE_BANNERS."` ADD `open_new` tinyint(1) DEFAULT '1';");

if($error = mysqli_error($db->link)) print_error($error);

if(in_array("news",$modules_array)) {
	print_message("Updating news table...");
	$db->query("alter table `".$config_table_prefix."news` add `order_no` int(3)");
	$db->query("update `".$config_table_prefix."news` set `order_no`=`id`");
	require_once $config_abs_path."/modules/news/classes/news.php";
	$n = new news();
	$n->reOrder();
	if($error = mysqli_error($db->link)) print_error($error);
}

print_message("Adding slugs table...");

$db->query("DROP TABLE if exists `".$config_table_prefix."slugs`");
$db->query("CREATE TABLE `".$config_table_prefix."slugs` (
  `id` int(10) NOT NULL auto_increment,
  `object_id` int(10) NOT NULL,
  `type` varchar(20) default 'listing',
  `slug` varchar(200),
  PRIMARY KEY  (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_object_id` (`object_id`)
) ENGINE=InnoDB  AUTO_INCREMENT=1 DEFAULT CHARSET=$config_db_charset COLLATE=$config_db_collation;");

if($error = mysqli_error($db->link)) print_error($error);

$s = new slugs();
$s->generate();

print_message("Updating seo_settings table...");

$db->query("alter table ".TABLE_SEO_SETTINGS." add `sef_legacy_mode` tinyint(1) default 1, add `sef_links` text, add `maximum_slug_width` int(3) default 0");

if($error = mysqli_error($db->link)) print_error($error);

$db->query("update ".TABLE_SEO_SETTINGS." set `sef_links`='{\"listings\":\"search\",\"user_listings\":\"users\",\"store\":\"store\",\"content\":\"content\",\"affiliate\":\"affiliate\",\"recent_ads\":\"recent_ads\",\"featured_ads\":\"featured_ads\",\"auctions\":\"auctions\",\"login\":\"login\",\"register\":\"register\",\"logout\":\"logout\",\"favorites\":\"favorites\",\"contact\":\"contact\",\"pre_submit\":\"pre_submit\",\"refine\":\"refine\",\"contact_details\":\"contact-details\"}'");

if($error = mysqli_error($db->link)) print_error($error);

print_message("Adding Stripe to payment processors...");

$db->query("INSERT INTO `".$config_table_prefix."payment_processors` (`processor_name`, `processor_title`, `processor_code`, `processor_table`, `processor_class`, `processor_ret_table`, `enabled`, `manual`, `free`, `pending`, `recurring`) VALUES ('Stripe', 'Stripe', 'stripe', 'stripe_settings', 'stripe', 'stripe_return', '0', '0', '0', '0', '-1');") or die("Could not add Stripe");

if($error = mysqli_error($db->link)) print_error($error);

$db->query("DROP TABLE if exists `".$config_table_prefix."stripe_settings`");
$db->query("CREATE TABLE `".$config_table_prefix."stripe_settings` (
  `secret_key` varchar(100),
  `publishable_key` varchar(100),
  `item_name` varchar(100),
  `currency` varchar(3)
);") or die("Could not add stripe_settings");

if($error = mysqli_error($db->link)) print_error($error);

$db->query("insert into `".$config_table_prefix."stripe_settings` set `item_name`='Classifieds ad';") or die("Could not add to stripe_settigs");

if($error = mysqli_error($db->link)) print_error($error);

$db->query("DROP TABLE if exists `".$config_table_prefix."stripe_return`");
$db->query("CREATE TABLE `".$config_table_prefix."stripe_return` (
  `id` bigint(20) NOT NULL auto_increment,
  `ukey` varchar(255) default '0',
  `date` timestamp default '0000-00-00 00:00:00',
  `charge_id` varchar(100),
  `amount` int(10),
  `currency` varchar(3),
  `customer` varchar(40),
  `livemode` varchar(5),
  `paid` varchar(5),
  PRIMARY KEY  (`id`),
  KEY `date` (`date`),
  KEY `ukey` (`ukey`)
) ENGINE=InnoDB AUTO_INCREMENT=1 ;") or die("Could not add stripe_return");

if($error = mysqli_error($db->link)) print_error($error);

$db->query("UPDATE `".$config_table_prefix."version` SET `ver`='9', `subver` =  '4', `last_update` = now()");

$cache = new cache();
$cache->clearAllCacheFiles();

print_finish_message();

print_back_button();

function print_message($str) {

	echo '<span class="message">'.$str."</span><br/>";

}

function print_error($str) {

	echo '<span class="error">'.$str."</span><br/>";
	
}

function print_finish_message() {

	echo '<div class="finish">
	<h3>The database update is complete!<br/>
	To finish please complete the following steps:</h3>

	<ol>
	<li>Remove the <i>update.php</i> file from your server.</li>
	<li>Edit your <i>.htaccess</i> file and after the line:<br/><em>#RewriteBase /</em><br/>add the following block:<br/><em># start SEF links structure<br/><br/>

RewriteRule ^recent_ads recent_ads.php [nc,qsa]<br/>
RewriteRule ^featured_ads featured_ads.php [nc,qsa]<br/>
RewriteRule ^auctions auctions.php [nc,qsa]<br/>
RewriteRule ^register register.php [nc,qsa]<br/>
RewriteRule ^login login.php [nc,qsa]<br/>
RewriteRule ^logout logout.php [nc,qsa]<br/>
RewriteRule ^favorites favorites.php [nc,qsa]<br/>
RewriteRule ^contact contact.php [nc,qsa]<br/>
RewriteRule ^pre-submit pre-submit.php [nc,qsa]<br/>
RewriteRule ^refine refine.php [nc,qsa]<br/>
RewriteRule ^search/?$ listings.php [nc,qsa]<br/>
RewriteRule ^search/([^./]+) listings.php?category_slug=$1 [nc,qsa]<br/>
RewriteRule ^users/([^./]+) user_listings.php?user_slug=$1 [nc,qsa]<br/>
RewriteRule ^store/([^./]+) store.php?user_slug=$1 [nc,qsa]<br/>
RewriteRule ^contact-details/([^./]+) contact_details.php?user_slug=$1 [nc,qsa]<br/>
RewriteRule ^content/([^./]+) content.php?cp_slug=$1 [nc,qsa]<br/>
RewriteRule ^([^./]+)$ index.php?category_slug=$1 [nc,qsa]<br/>
RewriteRule ^([^./]+)/([^./]+)/?$ details.php?category_slug=$1&listing_slug=$2 [nc,qsa]<br/>
RewriteRule ^affiliate/([^./]+)$ index.php?aff=$1 [nc,qsa]<br/><br/>

# end SEF links structure<br/>
</em></li>
	<li>Note that <i>URL legacy mode</i> is enabled, so your URLs will be the same as before. If you want to use the new URL types, then login to Administrator interface, go to <i>Settings / Seo Settings</i> section and disable the <i>"Search engine friendly URLs legacy mode"</i> option. After you do this, if you use Google sitemap file then regenerate it from <em>Tools / Google Sitemap</em> section, and then submit the new URL sitemap to search engines.
	</li>
	</ol>
	</div>';

}

function print_back_button() {

	echo '<a class="button" href="index.php">Back to main site</a>';

}

?>

    </div>
    <!-- end: #main -->

    <!-- begin: #footer -->
	<div class="footer">Copyright &copy; http://www.oxyclassifieds.com 2006-<?php echo date("Y"); ?></div>
	<div class="bottom-page">&nbsp;</div>
    <!-- end: #footer -->
</div>
</body>
</html>
