#
# Table structure for table `class_2co_return`
#

DROP TABLE IF EXISTS `class_2co_return`;
CREATE TABLE `class_2co_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `x_login` varchar(16) DEFAULT NULL,
  `key` varchar(50) DEFAULT NULL,
  `ukey` varchar(255) DEFAULT '0',
  `x_amount` varchar(50) DEFAULT NULL,
  `X_Email` varchar(50) DEFAULT NULL,
  `X_Address` varchar(50) DEFAULT NULL,
  `X_City` varchar(50) DEFAULT NULL,
  `X_State` varchar(50) DEFAULT NULL,
  `X_Country` varchar(50) DEFAULT NULL,
  `X_ZIP` varchar(30) DEFAULT NULL,
  `x_invoice_num` varchar(255) DEFAULT '0',
  `order_number` varchar(30) DEFAULT NULL,
  `merchant_order_id` varchar(50) DEFAULT NULL,
  `ip_country` varchar(50) DEFAULT NULL,
  `lang` varchar(20) DEFAULT NULL,
  `cart_id` varchar(50) DEFAULT NULL,
  `demo` varchar(1) DEFAULT NULL,
  `pay_method` varchar(10) DEFAULT NULL,
  `credit_card_processed` char(1) DEFAULT 'Y',
  `card_holder_name` varchar(100) DEFAULT NULL,
  `merchant_product_id` int(10) DEFAULT NULL,
  `entirepost` text,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_2co_return`
#



#
# Table structure for table `class_2co_settings`
#

DROP TABLE IF EXISTS `class_2co_settings`;
CREATE TABLE `class_2co_settings` (
  `to_checkout_sid` varchar(20) DEFAULT NULL,
  `to_checkout_secret` varchar(16) DEFAULT NULL,
  `to_checkout_demo` int(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_2co_settings`
#

INSERT INTO class_2co_settings VALUES ('', '', '0');


#
# Table structure for table `class_actions`
#

DROP TABLE IF EXISTS `class_actions`;
CREATE TABLE `class_actions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `object_id` int(10) NOT NULL,
  `user_id` int(10) NOT NULL,
  `invoice` int(10) DEFAULT NULL,
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `extra` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_object` (`object_id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_invoice` (`invoice`),
  KEY `idx_type` (`type`),
  KEY `idx_date` (`date`),
  KEY `idx_pending` (`pending`)
) ENGINE=MyISAM AUTO_INCREMENT=71 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_actions`
#

INSERT INTO class_actions VALUES ('1', 'newad', '1', '0', '1', '0', '2017-02-12 19:38:38', '');
INSERT INTO class_actions VALUES ('27', 'newad', '14', '0', '14', '0', '2017-02-17 07:28:24', '');
INSERT INTO class_actions VALUES ('3', 'newad', '2', '0', '2', '0', '2017-02-12 19:44:15', '');
INSERT INTO class_actions VALUES ('47', 'newad', '24', '0', '24', '0', '2017-03-06 10:18:13', '');
INSERT INTO class_actions VALUES ('5', 'newad', '3', '0', '3', '0', '2017-02-12 19:56:22', '');
INSERT INTO class_actions VALUES ('25', 'newad', '13', '0', '13', '0', '2017-02-17 06:53:58', '');
INSERT INTO class_actions VALUES ('7', 'newad', '4', '0', '4', '0', '2017-02-12 19:58:55', '');
INSERT INTO class_actions VALUES ('49', 'newad', '25', '0', '25', '0', '2017-03-10 10:57:16', '');
INSERT INTO class_actions VALUES ('9', 'newad', '5', '0', '5', '0', '2017-02-13 11:39:08', '');
INSERT INTO class_actions VALUES ('23', 'newad', '12', '0', '12', '0', '2017-02-17 06:49:29', '');
INSERT INTO class_actions VALUES ('11', 'newad', '6', '0', '6', '0', '2017-02-13 20:40:28', '');
INSERT INTO class_actions VALUES ('45', 'newad', '23', '0', '23', '0', '2017-03-06 10:13:44', '');
INSERT INTO class_actions VALUES ('13', 'newad', '7', '0', '7', '0', '2017-02-14 19:21:38', '');
INSERT INTO class_actions VALUES ('21', 'newad', '11', '0', '11', '0', '2017-02-17 06:42:45', '');
INSERT INTO class_actions VALUES ('15', 'newad', '8', '0', '8', '0', '2017-02-14 19:29:31', '');
INSERT INTO class_actions VALUES ('41', 'newad', '21', '0', '21', '0', '2017-02-27 09:01:53', '');
INSERT INTO class_actions VALUES ('17', 'newad', '9', '0', '9', '0', '2017-02-14 19:49:14', '');
INSERT INTO class_actions VALUES ('19', 'newad', '10', '0', '10', '0', '2017-02-17 06:39:29', '');
INSERT INTO class_actions VALUES ('53', 'newad', '27', '0', '27', '0', '2017-03-14 10:13:19', '');
INSERT INTO class_actions VALUES ('29', 'newad', '15', '0', '15', '0', '2017-02-17 08:32:42', '');
INSERT INTO class_actions VALUES ('51', 'newad', '26', '0', '26', '0', '2017-03-10 11:02:43', '');
INSERT INTO class_actions VALUES ('31', 'newad', '16', '0', '16', '0', '2017-02-17 09:53:14', '');
INSERT INTO class_actions VALUES ('33', 'newad', '17', '0', '17', '0', '2017-02-17 14:05:51', '');
INSERT INTO class_actions VALUES ('55', 'newad', '28', '0', '28', '0', '2017-03-14 10:15:58', '');
INSERT INTO class_actions VALUES ('35', 'newad', '18', '0', '18', '0', '2017-02-18 06:04:48', '');
INSERT INTO class_actions VALUES ('43', 'newad', '22', '0', '22', '0', '2017-03-02 09:13:26', '');
INSERT INTO class_actions VALUES ('37', 'newad', '19', '0', '19', '0', '2017-02-18 06:09:15', '');
INSERT INTO class_actions VALUES ('39', 'newad', '20', '0', '20', '0', '2017-02-27 07:48:56', '');
INSERT INTO class_actions VALUES ('65', 'newad', '33', '0', '33', '0', '2017-03-28 06:43:53', '');
INSERT INTO class_actions VALUES ('57', 'newad', '29', '0', '29', '0', '2017-03-14 10:19:22', '');
INSERT INTO class_actions VALUES ('63', 'newad', '32', '0', '32', '0', '2017-03-24 12:52:31', '');
INSERT INTO class_actions VALUES ('59', 'newad', '30', '0', '30', '0', '2017-03-16 09:54:48', '');
INSERT INTO class_actions VALUES ('61', 'newad', '31', '0', '31', '0', '2017-03-24 12:50:05', '');
INSERT INTO class_actions VALUES ('67', 'newad', '34', '0', '34', '0', '2017-03-28 06:48:05', '');
INSERT INTO class_actions VALUES ('69', 'newad', '35', '0', '35', '0', '2017-03-28 07:10:14', '');


#
# Table structure for table `class_ads`
#

DROP TABLE IF EXISTS `class_ads`;
CREATE TABLE `class_ads` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `category_id` int(3) NOT NULL,
  `package_id` int(2) NOT NULL,
  `usr_pkg` int(10) DEFAULT NULL,
  `date_added` datetime NOT NULL,
  `date_expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `title` varchar(150) NOT NULL,
  `description` text NOT NULL,
  `price` double DEFAULT '-1',
  `currency` varchar(10) DEFAULT NULL,
  `meta_description` varchar(256) DEFAULT NULL,
  `meta_keywords` varchar(256) DEFAULT NULL,
  `sold` tinyint(1) NOT NULL DEFAULT '0',
  `rented` tinyint(1) NOT NULL DEFAULT '0',
  `viewed` int(10) NOT NULL DEFAULT '0',
  `user_approved` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `pending` tinyint(1) NOT NULL DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `highlited` tinyint(1) NOT NULL DEFAULT '0',
  `priority` int(1) NOT NULL DEFAULT '0',
  `video` text,
  `rating` double(4,2) NOT NULL DEFAULT '0.00',
  `language` varchar(30) NOT NULL DEFAULT 'eng',
  `unique_id` varchar(30) DEFAULT NULL,
  `auction` int(1) DEFAULT '0',
  `marca` varchar(100) DEFAULT NULL,
  `model` varchar(100) DEFAULT NULL,
  `anul_fabricatiei` varchar(128) DEFAULT NULL,
  `rulaj` float DEFAULT NULL,
  `vin` varchar(255) DEFAULT NULL,
  `caroserie` varchar(128) DEFAULT NULL,
  `culoare` varchar(128) DEFAULT NULL,
  `combustibil` varchar(128) DEFAULT NULL,
  `tip_pret` varchar(128) DEFAULT NULL,
  `cilindree` varchar(255) DEFAULT NULL,
  `putere` float DEFAULT NULL,
  `tractiune` varchar(128) DEFAULT NULL,
  `dotari_siguranta` text,
  `dotari_comfoty` text,
  `cutie_de_viteze` varchar(128) DEFAULT NULL,
  `norma_poluare` varchar(128) DEFAULT NULL,
  `emisii_co2` float DEFAULT NULL,
  `detalii_istoric` text,
  `design_si_performanta` text,
  `tara` varchar(100) DEFAULT NULL,
  `judet` varchar(100) DEFAULT NULL,
  `negotiable` tinyint(1) DEFAULT '0',
  `price_tag` varchar(40) DEFAULT NULL,
  `unit_price` float DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_category` (`category_id`),
  KEY `idx_package` (`package_id`),
  KEY `idx_price` (`price`),
  KEY `idx_title` (`title`),
  KEY `idx_viewed` (`viewed`),
  KEY `date_added` (`date_added`),
  KEY `date_expires` (`date_expires`),
  KEY `idx_featured` (`featured`),
  KEY `idx_active` (`active`),
  KEY `idx_pending` (`pending`),
  KEY `idx_highlited` (`highlited`),
  KEY `idx_priority` (`priority`),
  KEY `idx_sold` (`sold`),
  KEY `idx_rented` (`rented`),
  KEY `usr_pkg` (`usr_pkg`),
  KEY `priority_2` (`priority`,`date_added`),
  KEY `active_2` (`active`,`date_added`),
  KEY `active_3` (`active`,`priority`),
  KEY `active_4` (`active`,`priority`,`date_added`),
  KEY `user_approved` (`user_approved`),
  KEY `app` (`active`,`priority`,`price`),
  KEY `priority_3` (`priority`,`price`),
  KEY `priority_4` (`priority`,`title`),
  KEY `marca` (`marca`),
  KEY `model` (`model`),
  KEY `tara` (`tara`),
  KEY `judet` (`judet`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_ads`
#

INSERT INTO class_ads VALUES ('1', '0', '14', '4', '2', '2017-02-12 19:39:09', '0000-00-00 00:00:00', 'Jante Audi pe 17', 'Vand jante pentru Audi A6 rial pe 17, fara cauciucuri.\r\nJentiile sunt in stare foarte buna.', '120', '', '', '', '0', '0', '825', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', 'Tractiune Integrala', '', '', '', '', '', '', '', 'Romania', 'Salaj', '0', '', '120');
INSERT INTO class_ads VALUES ('2', '0', '14', '4', '3', '2017-02-12 19:44:39', '0000-00-00 00:00:00', 'Jante Audi noi pe 17 inch', 'Vand Jante Audi noi pe 17 inch, jantele nu au fost montate pe masina niciodata.', '300', '', '', '', '1', '0', '5074', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Romania', 'Cluj', '0', '', '300');
INSERT INTO class_ads VALUES ('3', '0', '14', '4', '4', '2017-02-12 19:59:34', '0000-00-00 00:00:00', 'Injectoare Ford Monde 2.0 TDCI', 'Vand injectoare Ford Mondeo 2.0 TdCi.\r\nPretul este pe bucata.', '120', '', '', '', '0', '0', '1450', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Romania', 'Brasov', '1', '', '120');
INSERT INTO class_ads VALUES ('4', '0', '14', '4', '5', '2017-02-12 19:59:34', '0000-00-00 00:00:00', 'Motor M47T BMW E46 320d 150 Cai', 'Vand Motor M47T pentru BMW E46 320d 150 cai.\r\nMotorul este in stare exceptionala, se poate verifica.', '700', '', '', '', '0', '0', '840', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Romania', 'Bucuresti', '1', '', '700');
INSERT INTO class_ads VALUES ('5', '0', '14', '4', '6', '2017-02-13 20:40:49', '0000-00-00 00:00:00', 'INJECTOR VW CRAFTER 2.5TDI', 'Cod piesa -\r\n\r\n076130855X\r\nDescriere -\r\n\r\nINJECTOR COMBUSTIBIL DIESEL\r\nAplicatie -\r\n\r\nCRAFTER 2006-11 (2E) CU 5 CILINDRII DIESEL\r\n\r\nCRAFTER 2011 (2E) CU 5 CILINDRII DIESEL COD MOTOR - BJJ, BJK, BJL, BJM, CEBA, CEBB, CECA, CECB\r\n\r\nPRET PRODUCATOR RRP -\r\n400 EUR\r\nPRET PIESA VANZARE -\r\nONLY 120 EUR! NEGOCIABIL', '120', '', '', '', '0', '0', '1199', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Romania', 'Cluj', '1', '', '120');
INSERT INTO class_ads VALUES ('6', '0', '7', '4', '7', '2017-02-13 20:41:16', '0000-00-00 00:00:00', 'Volkswagen Sharan Diesel 1.9 TDI', 'Volkswagen Sharan transmisie manuala 6+1 trepte, 6 ceasuri in bord, volan piele, sistem ISOFIX, scaune spate individuale, scaun copil incorporat in bancheta spate, cotiere fata individuale, 2 chei, geamuri colorate din fabrica, torpedou frigorific, anvelope iarna, provenienta Germania, proprietar Germania nascut in 1934, inmatriculata in Romania in februarie 2017, unic proprietar, carte service, fara rugina, arata si functioneaza impecabil ABS; alarm?; c', '3500', '', '', '', '0', '0', '1295', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Volkswagen', 'Sharan', '2002', '210000', '', 'Minivan', '', 'Diesel', '', '1900', '116', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat|CD-player|Servodirectie|Inchidere Centralizata', 'Manuala', 'Euro 3', '154', 'Inmatriculat', '', 'Romania', 'Galati', '0', '', '3500');
INSERT INTO class_ads VALUES ('7', '0', '7', '4', '8', '2017-02-14 19:30:04', '0000-00-00 00:00:00', 'Renault Clio 2000 Benzin', 'Renault Clio Adusa din Italia, functionala . pentru piese.', '500', '', '', '', '0', '0', '1229', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Renault', 'Clio', '2000', '145000', '', 'Hatchback', '', 'Benzina', '', '1200', '75', 'Tractiune fata', '', '', 'Manuala', '', '', '', '', 'Romania', 'Neamt', '1', '', '500');
INSERT INTO class_ads VALUES ('8', '0', '7', '4', '9', '2017-02-14 19:30:02', '0000-00-00 00:00:00', 'Audi A6 diesel 136 cp 2007', 'Audi A6 Model speciale pachet sportif S6 American Full optionn extra Motor cod -BRF foarte bun economiq 136cp original reprogramata software 6- vitesse pilot auto Jantele RS6 Slline original germany 19, tolli Suspensie original Slline sport Interior Milano edition fara usura sau rupturi Carrosserie sportif impecabil 100% Accesorii recent schimbate noii - Facturii + garantie Stare perfecta de functionare 100% 8700,euro NEG Tele 0758840951 Int+whatspp -0032466085130 Poze reale ABD; ABS; alarm?; ASR; carkit; climatronic; comenzi volan; computer bord; cotier?; crom; ESP; full electric; geamuri electrice;', '8700', '', '', '', '0', '0', '980', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Audi', 'A6', '2007', '231000', '', 'Berlina', 'Gri', 'Diesel', '', '1898', '136', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Airbag-uri Laterale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat doua zone|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice|Geamuri spate electrice|Comenzi Volan|Navigatie|Oglinzi electrice|Oglinzi incalzite|Scaune fata incalzite', 'Manuala', '', '', '', 'Cip-tuning', 'Romania', 'Bihor', '0', '', '8700');
INSERT INTO class_ads VALUES ('9', '0', '7', '4', '10', '2017-02-14 19:50:05', '0000-00-00 00:00:00', 'Ford Focus euro 4 recent adus', 'Ford Focus Recent adusa serie trend face lift 2/ break Motor 116cp EURO.4 6- vitesse tempomat pilot auto AC ESP asr radio CD mp3 original multifonction etc.. Stare perfecta de functionare nu bate volanta nu patineaza ambreiaj Mici reparatii la carrosserie photo Actele sant ok Accesorii recent schimbate noii etc Interior foarte bun fara rupturi Mai multe detali Tele -0758840951 Sau pe international -0032/466.08.51.30 whatsapp Occasie pret usor NEG ABD; ABS; AC; alarm; ASR; comenzi volan; computer bord; cotier; crom; ESP; geamuri electrice;', '1850', '', '', '', '0', '0', '1039', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Ford', 'Focus', '2008', '210000', '', 'Break', '', 'Diesel', '', '1800', '116', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat|CD-player|Computer de bord|Geamuri fata electrice', 'Manuala', 'Euro 4', '', '', '', 'Romania', 'Bihor', '0', '', '1850');
INSERT INTO class_ads VALUES ('10', '0', '7', '4', '11', '2017-02-17 06:43:42', '0000-00-00 00:00:00', 'Volkswagen Golf V 1.9 TDI', 'Volkswagen Golf aer conditionat climatic, 4 geamuri electrice, 2 chei, bluetooth, senzori parcare spate, senzori ploaie si lumini, oglinda retrovizoare cu senzori antiorbire, cotiera fata, bare portbagaj, torpedou frigorific, cheie tip briceag, recent adusa din Germania, carte service, arata si functioneaza foarte bine, nu raspund la mesaje ABS; computer bord; ESP;', '4880', '', '', '', '0', '0', '1008', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Volkswagen', 'Golf', '2008', '172000', '', 'Break', 'Albastru', 'Diesel', '', '1900', '105', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)', 'Aer conditionat|CD-player|Computer de bord|Servodirectie|Geamuri fata electrice', 'Manuala', '', '', '', '', 'Romania', 'Galati', '0', '', '4880');
INSERT INTO class_ads VALUES ('11', '0', '7', '4', '12', '2017-02-17 06:43:41', '0000-00-00 00:00:00', 'Audi TT 1.8t 180 cp cu xenon piele climatronic', 'Audi Ocazie. Audi TT 1.8t 180 cp cu xenon piele climatronic. Urgent. Bucuresti', '2650', '', '', '', '0', '0', '904', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Audi', 'TT', '2001', '200000', '', 'Coupe', 'Negru', 'Benzina', '', '1800', '180', 'Tractiune fata', 'ABS|Airbag-uri Frontale', 'Aer conditionat doua zone|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice|Faruri Xenon|Oglinzi electrice|Oglinzi incalzite', 'Manuala', '', '', '', '', 'Romania', 'Bucuresti', '0', '', '2650');
INSERT INTO class_ads VALUES ('12', '0', '14', '4', '13', '2017-02-17 06:54:32', '0000-00-00 00:00:00', 'Faruri Peugeot 307 an 2006', 'Faruri Peugeot 307 an 2006 farurile arata foarte bine singura problema este ca un far are o ureche rupta, se p[oate monta fara probleme sunt echipate cu toate becurile oferta 249 lei perechea, urgent,', '220', 'RON', '', '', '0', '0', '1171', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Romania', 'Bucuresti', '0', '', '48.4');
INSERT INTO class_ads VALUES ('13', '0', '14', '4', '14', '2017-02-17 06:54:31', '0000-00-00 00:00:00', 'Pompa de injectie Bosch PES6P120', 'Pompa de injectie Bosch 59202 00085 C 0 402 796 834 . Pret negociabil . PES6P120A720A720RS7462 988 5982 . Produsa in Germania . Stare : noua .', '1800', '', '', '', '0', '0', '1082', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Romania', 'Brasov', '1', '', '1800');
INSERT INTO class_ads VALUES ('14', '0', '14', '4', '15', '2017-02-17 08:41:38', '0000-00-00 00:00:00', 'Capota fata VW Golf 6 2012-2016', 'Capota fata VW Golf 6 2012-2016 lovita foarte usor (nu se vede din poza) utilizat', '500', 'RON', '', '', '0', '0', '1017', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Romania', 'Bucuresti', '0', '', '110');
INSERT INTO class_ads VALUES ('15', '0', '14', '4', '16', '2017-02-17 08:41:37', '0000-00-00 00:00:00', 'Bara fata Mercedes ML W166', 'vand bara fata Mercedes ML W166 cu absorbant daylight, masca (emblema)', '500', '', '', '', '0', '0', '1028', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Romania', 'Bucuresti', '1', '', '500');
INSERT INTO class_ads VALUES ('16', '0', '7', '4', '17', '2017-02-17 13:56:38', '0000-00-00 00:00:00', 'Volkswagen Passat model Highline diesel', 'Volkswagen Passat model Highline, dublu climatronic, ASC, cauciucuri iarna M+S, interior de plus ca nou, senzori ploaie si lumini, cotiera fata spate reglabila, multe optiuni - toate functionale, linie audio cu 8 boxe, fara vicii ascunse, ATENTIE! - super OCAZIE - cartea de Romania facuta de 3 zile - se poate inmatricula - la cererea clientului asiguram inmatricularea RO in maxim 4 zile lucratoare, vopsea originala, numere rosii valabile ABS; computer bord; cotier?; crom; ESP; geamuri electrice;', '5699', '', '', '', '0', '0', '1165', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Volkswagen', 'Passat', '2007', '193000', '', 'Berlina', 'Negru', 'Diesel', '', '1900', '116', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat doua zone|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice|Geamuri spate electrice|Comenzi Volan', 'Manuala', '', '', '', '', 'Romania', 'Timis', '0', '', '5699');
INSERT INTO class_ads VALUES ('17', '0', '7', '4', '18', '2017-02-17 19:46:31', '0000-00-00 00:00:00', 'Citroen C4 Picasso Import recent Franta', 'Citroen C4 Picasso Import recent Franta / nu este rulat in Romania Grand C4 Picasso 7 locuri 1.6hdi 110cp 6+1 viteze Cutie Automata PRIMA INMATRICULARE 28/01/2008 Euro 4 KM REALI VF7UA9HZH45236242', '4290', '', '', '', '0', '0', '1006', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Citroen', 'C4 Picasso', '2008', '197000', 'VF7UA9HZH45236242', 'Minivan', 'Gri', 'Diesel', '', '1600', '110', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat|Computer de bord|Servodirectie|Geamuri fata electrice|Geamuri spate electrice|Comenzi Volan|Pilot automat', 'Automata', 'Euro 4', '', '', '', 'Romania', 'Bucuresti', '0', '', '4290');
INSERT INTO class_ads VALUES ('18', '0', '7', '4', '19', '2017-02-18 06:10:28', '0000-00-00 00:00:00', 'Citroen C5 1.6 HDI 110 cp 2010', 'Citroen C5 - 1.6 HDI, anul 2010, 1598 cmc, 110 CP, 220.000 KM, culoare gri metalizat, transmisie manuala (5+1 trepte). Dotari: servodirectie, climatronic, computer bord, pilot automat, volan reglabil, cd player, oglinzi electrice si incalzite, 4 geamuri electrice, inchidere centralizata, comenzi volan, cotiera, proiectoare ceata, air-bag, EPS, ABS. Euro 4 Acte de Franta Recent Stare foarte buna Totul functional Mai multe informatii la telefon Pret 4.700 EUR neg. Tel. 0757873591 ABS; climatronic; ESP; geamuri electrice;', '4700', '', '', '', '0', '0', '883', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Citroen', 'C5', '2010', '220000', '', 'Break', 'Gri', 'Diesel', '', '1600', '110', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice|Geamuri spate electrice|Comenzi Volan|Oglinzi electrice|Oglinzi incalzite', 'Manuala', '', '', '', '', 'Romania', 'Arad', '0', '', '4700');
INSERT INTO class_ads VALUES ('19', '0', '7', '4', '20', '2017-02-18 06:10:28', '0000-00-00 00:00:00', 'Mazda CX-5', 'URGENT,OCAZIE MAZDA CX5. Vand sau schimb+diferenta .rog seriozitate\r\nPIELE CREM.NAVIGATIE.FALLOW MY HOME. COMMING HOME. LEAVING HOME..PORNIRE DE LA DISTANTA..AUTOMATA..VARIANTA DE 175CP...PACHET CROM...ROTI PE 19...4X4... PARTRONIC.....SCAUNE ELEC. INCALZITE.OGLINZI RABATABIL ELEC. TOUCH SCREEM . BI XENON. LED... ALARMA VIPER. START/ STOP, variante schimb. Cu auto+ diferenta. Rog seriozitate. Masina este in stare perfecta si se accepta orice testare', '16000', '', '', '', '0', '0', '725', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Mazda', 'CX-5', '2013', '120000', '', 'Suv', 'Negru', 'Diesel', '', '2200', '175', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice|Geamuri spate electrice|Faruri Bi-Xenon|Lumini de zi|Oglinzi electrice|Oglinzi incalzite|Senzori parcare fata-spate', '', '', '', '', '', 'Romania', 'Bucuresti', '0', '', '16000');
INSERT INTO class_ads VALUES ('20', '0', '7', '4', '21', '2017-02-27 07:49:37', '0000-00-00 00:00:00', 'Opel Astra diesel an 2004', 'DEALER AUTO - SE OFERA FACTURA + BON FISCAL -1 Singur Proprietar Austria -Opel Astra Station Wagon 1.3 CDTI -6+1 viteze 90 Cp -154.200 km CARTE SERVICE -fabricatie 18.07.2006 -euro 4 -central din telecomanda -130G co2 TAXA 290 euro -KLIMA -a.b.s -TEMPOMAT - PILOT AUTOMAT -CD -senzori lumina -geamuri electrice -PROECTOARE CEATA -spalator faruri -CARLIG REMORCARE -oglinzi electrice si incalzite -STARE IREPROSABILA!!! MASINA INGRIJITA OBSESI ABD; ABS; AC; ASR;', '2890', '', '', '', '0', '0', '440', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Opel', 'Astra', '2007', '154200', '', 'Break', 'Negru', 'Diesel', '', '1300', '90', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice', 'Manuala', '', '', '', '', 'Romania', 'Arad', '0', '', '2890');
INSERT INTO class_ads VALUES ('21', '0', '7', '4', '22', '2017-02-27 09:02:38', '0000-00-00 00:00:00', 'Ford Fiesta euro 4 inmatriculat', 'inmatriculata RO 02. 2017 ( Unic Proprietar persoana fizica ) * fabricatie 2003 / EURO 4 * motor 1300 cmc benzina * rulaj = 144000 km reali / accept orice verificare * KIT DISTRIBUTIE NOU - AER CONDITIONAT functional - geamuri electrice - oglinzi electrice incalzite - computer bord - scaune reglabile - servo, ABS, ESP - airbaguri frontale si laterale - inchidere centralizata / 2 chei - volan PIELE reglabil 3 pozitii - radio-cd - comenzi la volan - JAN', '2900', '', '', '', '0', '0', '518', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Ford', 'Fiesta', '2003', '144000', '', 'Hatchback', 'argintiu', 'Benzina', '', '1300', '69', 'Tractiune fata', 'ABS|Airbag-uri Frontale', '', 'Manuala', '', '', '', '', 'Romania', 'Dolj', '0', '', '2900');
INSERT INTO class_ads VALUES ('22', '0', '7', '4', '23', '2017-03-02 13:56:05', '0000-00-00 00:00:00', 'Volkswagen Passat B6 2.0 TDI 2006 taxa platita', 'Vw Passat TAXA PLATITA DETIN DOVADA ANAF\r\n\r\nPassat 2.0 140CP\r\n\r\n-faruri cu lupa si xenon\r\n\r\n6+1 trepte viteza\r\n\r\n-climatronic pe 2 zone\r\n\r\n-pilot automat tempomat\r\n\r\n-computer bord\r\n\r\n-esp\r\n\r\n-4 geamuri electrice cu modul confort\r\n\r\n-oglinzi electrice incalzite\r\n\r\n-retrovizoare electrocromatica\r\n\r\n-cotiera fata spate\r\n\r\n-torpedo si cotiera cu r?cire\r\n\r\n-scaune cu reglaj electric\r\n\r\n-scaune incalizite fata\r\n\r\n- radio-CD\r\n\r\n-senzori ploaie si lumini\r\n\r\n-lumini ambientale interior-exterior\r\n\r\n-suport ochelari in plafoniera\r\n\r\n-pachet crom interior&exterior\r\n\r\n-proiectoare ceata\r\n\r\n-jante aliaj\r\n\r\n-2 chei\r\n\r\nTel 0773.968.992', '5199', '', '', '', '0', '0', '507', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Volkswagen', 'Passat', '2006', '240000', '', 'Berlina', 'Gri', 'Diesel', '', '1989', '140', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat doua zone|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice|Geamuri spate electrice|Faruri Xenon|Navigatie|Oglinzi electrice|Pilot automat|Scaune fata incalzite', 'Manuala', '', '', '', '', 'Romania', 'Bucuresti', '1', '', '5199');
INSERT INTO class_ads VALUES ('23', '0', '7', '4', '24', '2017-03-06 10:18:34', '0000-00-00 00:00:00', 'Mitsubishi L200 Warrior 4x4 2006', 'Mitsubishi L200 Warrior 4x4 mic/mare, an 2006, motor 2.5 tdi, 174 cp, 5 locuri mixt, climatronic, full electric, portbagaj, jante 20 inch, carlig, recent adus anglia, distributie noua,filtre noi, revizii la zi, volan dreapta, acte valabile 12.2017, impecabil, pret negociabil abs; ac; asr; esp;', '4300', '', '', '', '0', '0', '466', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Mitsubishi', 'L200', '2006', '150000', '', 'Off-Road', 'Negru', 'Diesel', '', '2500', '174', 'Tractiune 4x4', 'ABS|Airbag-uri Frontale', 'Aer conditionat|Servodirectie|Inchidere Centralizata|Geamuri fata electrice', 'Manuala', '', '', '', '', 'Romania', 'Suceava', '0', '', '4300');
INSERT INTO class_ads VALUES ('24', '0', '7', '4', '25', '2017-03-06 10:18:33', '0000-00-00 00:00:00', 'Lexus CT 200H hibrid', 'Lexus CT 200H hibrid (benzina + electric) CC 1.8, prima inm 2013, 72500 km. full option. Consum mic. Mod condus: Eco/ Normal/ Sport Taxa si impozit zero 8 Jante originale + Caucicuri de vara+iarna.\r\numparat de la reprezentanta Lexus Romania, cu toate reviziile facute la service autorizat Lexus.\r\n\r\nDOTARI FULL OPTION:\r\n\r\nMod: Eco/Normal/Sport\r\n\r\nMod EV (Electric Vehicle)\r\n\r\nABS\r\n\r\nAirbag sofer, pasager, genunchi, laterale cortin?\r\n\r\nScaune cu design sport\r\n\r\nSistem ISOFIX\r\n\r\nGeamuri fumurii spate si luneta\r\n\r\nComenzi pe volan\r\n\r\nUSB, AUX, Bluetooth\r\n\r\nRadio-CD-MP3\r\n\r\nSistem audio premium cu 6 difuzoare\r\n\r\nAer conditionat DUAL zone\r\n\r\nStergatoare automate\r\n\r\nFaruri cu senzor automat de lumina\r\n\r\nBara fata F SPORT remodelata aerodinamic\r\n\r\nProiectoare ceata LED F SPORT\r\n\r\nJante aliaj 17\" in design SPORT 215/45 R17\r\n\r\nCruise control\r\n\r\nLevier design SPORT piele\r\n\r\nAlarma (+ sistem antifurt + senzor de intruziune)\r\n\r\nCamera video marsalier\r\n\r\nPedale sport\r\n\r\nTapiserie velour in culoare neagra\r\n\r\nScaune fata incalzite\r\n\r\nOglinzi incalzite\r\n\r\nSistem de acces si pornire cu cheie inteligenta (buton START/STOP)\r\n\r\nHotspot WI-FI original Lexus (functioneaza cu orice cartela SIM)', '15400', '', '', '', '0', '0', '477', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Lexus', 'CT', '2012', '72500', '', 'Hatchback', 'Rosu', 'Hibrid', '', '1800', '160', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul tractiunii(ASR)', 'Aer conditionat|CD-player|Computer de bord|Inchidere Centralizata|Geamuri fata electrice|Geamuri spate electrice', 'Manuala', '', '', '', '', 'Romania', 'Bucuresti', '0', '', '15400');
INSERT INTO class_ads VALUES ('25', '0', '7', '4', '26', '2017-03-10 11:03:49', '0000-00-00 00:00:00', 'Volkswagen Sharan 2.0 TDI 2007', 'Vand Vw Sharan 2.0 TDI an 2007 Pret 6500 euro negociabil. Masina arata si functioneaza perfect, 280.000 km, nu bate, nu troncane. Accept schimburi cu auto mai inguste tot diesel. Inmatriculat RO 2014.\r\nParbriz electric, oglinzi electrice, geamuri electrice(toate 4), scaune incalzite fata, Webasto, distributie schimbata la 260.000 km, revizie facuta la 280.000 km.Masina este foarte bine intretinuta, de nefumatori. 2 chei tip briceag.\r\n\r\nVand masina datorita drumului de acces in curte care este foarte ingust.', '6500', '', '', '', '0', '0', '452', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Volkswagen', 'Sharan', '2007', '280000', '', 'Minivan', '', 'Diesel', '', '2000', '136', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)', 'Aer conditionat|Computer de bord|Inchidere Centralizata|Geamuri fata electrice|Navigatie|Oglinzi incalzite|Parbriz incalzit|Pilot automat|Scaune fata incalzite|Senzori parcare spate', 'Manuala', '', '', '', '', 'Romania', 'Ilfov', '1', '', '6500');
INSERT INTO class_ads VALUES ('26', '0', '7', '4', '27', '2017-03-10 11:03:49', '0000-00-00 00:00:00', 'Volkswagen Touran transmisie automata DSG', 'Volkswagen Touran transmisie automata DSG 2, dublu climatronic, navigatie profesionala cu touchscreen, comenzi vocale, bluetooth, auxiliar, radio/CD + MP3, USB, slot card, 4 geamuri electrice, 2 chei, ofer suplimentar set jante aliaj cu anvelope de vara, senzori parcare spate cu afisaj, senzori ploaie si lumini, oglinda retrovizoare cu senzori antiorbire,carte service, unic proprietar, taxa platita si nerecuperata, inmatriculata in Romania in noiembrie 2016, provenienta Germania, arata si functioneaza foarte bine ABS; comenzi volan; computer bord; ESP;', '10900', '', '', '', '0', '0', '437', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Volkswagen', 'Touran', '2013', '214000', '', 'Minivan', 'Alb', 'Diesel', '', '2000', '140', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Airbag-uri Laterale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat|Aer conditionat doua zone|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice|Geamuri spate electrice|Bluetooth|Comenzi Volan|Navigatie|Oglinzi electrice|Oglinda centrala electrocromatica|Oglinzi retrovizoare electrocromatice|Oglinzi incalzite|Pilot automat|Scaune fata incalzite', 'Automata', '', '', 'Carte Service', '', 'Romania', 'Galati', '0', '', '10900');
INSERT INTO class_ads VALUES ('27', '0', '7', '4', '28', '2017-03-14 10:19:59', '0000-00-00 00:00:00', 'Volkswagen Passat High Line-2.0 TDI', 'Volkswagen Passat High Line - 2.0 TDI, anul 2008, 1998 cmc, 140 CP, 200.000 KM, culoare neagra, transmisie manuala (6+1 trepte). Dotari: servodirectie, clima, computer bord, pilot automat, volan reglabil, cd player, imobilizator, antifurt, oglinzi electrice si incalzite, 4 geamuri electrice, inchidere centralizata, comenzi volan, cotiera, jante aluminiu, scaun cu reglaj electrice, incalzire scaune, air-bag, EPS, ABS. Euro 4 Acte valabile Recent adus Arata si functioneaza foarte bine', '2800', '', '', '', '0', '0', '399', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Volkswagen', 'Passat', '2008', '200000', '', 'Berlina', 'Negru', 'Diesel', '', '2000', '140', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice|Geamuri spate electrice|Oglinzi electrice|Scaune fata incalzite', 'Manuala', '', '', '', '', 'Romania', 'Arad', '0', '', '2800');
INSERT INTO class_ads VALUES ('28', '0', '14', '4', '29', '2017-03-14 10:19:57', '0000-00-00 00:00:00', 'Modul pompa combustibil bmw', 'Modul pompa combustibil bmw Modul pompa combustibil bmw serie 5, 520D,120kw', '250', 'RON', '', '', '0', '0', '252', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Romania', 'Bucuresti', '0', '', '55');
INSERT INTO class_ads VALUES ('29', '0', '7', '4', '30', '2017-03-14 10:19:56', '0000-00-00 00:00:00', 'Renault Trafic', 'Renault Trafic dotari ac, inchidere centralizata cauciucuri iarna, geamuri electrice, taxa platita, scaune incalzite, 6 locuri,', '5700', '', '', '', '0', '0', '385', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Renault', 'Trafic', '2009', '250000', '', '', '', 'Diesel', '', '2000', '115', 'Tractiune fata', '', 'Aer conditionat|Geamuri fata electrice|Scaune fata incalzite', '', '', '', 'Inmatriculat', '', 'Romania', 'Bucuresti', '0', '', '5700');
INSERT INTO class_ads VALUES ('30', '0', '7', '4', '31', '2017-03-16 09:55:08', '0000-00-00 00:00:00', 'Audi a 4 in stare exceptionala an fabricatie 2008', 'Audi A4 Audi a 4 in stare exceptionala an fabricatie 2008, 2700 cm3, 140kv, rulaj 170 000 km euro 5; tapiterie piele cu catifea, impecabila, revizie efectuata, discuri, placute schimbate, taxa platita\r\n\r\nAudi a 4 in stare exceptionala an fabricatie 2008, 2700 cm3, 140kv,\r\n\r\nrulaj 170 000 km euro 5; tapiterie piele cu catifea, impecabila, revizie efectuata, discuri,\r\n\r\nplacute schimbate, taxa platita nerecuperata pret fara comcurenta 9 000 euro,\r\n\r\ndotari: comenzi pe volan;senzor lumina; senzor ploaie; 4 geamuri electrice;\r\n\r\nvolan reglabil pe inaltime; oglinzi incalzite; xenon; proiectoare; scaune incalzite;\r\n\r\npilot automat; navigatie;clima; cutie automata in 8 trepte; jante pe 18\";,', '9000', '', '', '', '0', '0', '226', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Audi', 'A4', '2008', '170000', '', 'Berlina', 'Negru', 'Diesel', '', '2700', '188', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Airbag-uri Laterale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat doua zone|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice|Geamuri spate electrice|Comenzi Volan|Faruri Xenon|Lumini de zi|Oglinzi electrice|Oglinzi incalzite|Pilot automat|Scaune fata incalzite|Senzori parcare spate', 'Automata', 'Euro 5', '', 'Inmatriculat', '', 'Romania', 'Bucuresti', '0', '', '9000');
INSERT INTO class_ads VALUES ('31', '0', '14', '4', '32', '2017-03-24 12:52:55', '0000-00-00 00:00:00', 'Butuc roata fata Dacia logan 2004-2012', 'Butuc roata fata compatibil cu\r\n\r\nDacia logan 2004-2012\r\n\r\nDacia sandero\r\n\r\nDacia logan mcv\r\n\r\nNu ezitati sa ne contactati pentru alte informatii/intrebari!!\r\n\r\nLIVRAM ORIUNDE IN TARA!!!', '69', 'RON', '', '', '0', '0', '263', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Romania', 'Bucuresti', '0', '', '15.18');
INSERT INTO class_ads VALUES ('32', '0', '14', '4', '33', '2017-03-24 12:52:54', '0000-00-00 00:00:00', 'Anvelope Vara DAYTON Touring 165/70 R14 81 T', 'Anvelope Vara DAYTON Touring 165/70 R14 81 T .Producator: DAYTON Model: Touring Sezon: Vara Dimensiune: 165/70 R14 Indice viteza: T (190 km/h) Indice sarcina: 81 Destinatie: Turisme/4x4\r\nAnvelopele DAYTON Touring sunt anvelope vara cu profil simetric proiectate pentru autoturisme compacte, mijlocii si familiale, testate in cele mai dificile conditii, oferind soferilor de zi cu zi o constructie robusta cu caracteristici de conducere si performante echilibrate in toate privintele, precizie superioara de directie, rezistenta la uzura, un confort excelent si plimbare linistita. Profilul benzii de rulare are doua siruri central-circumferentiale de blocuri masive si dense de forma unor sectoare de cerc cu striuri semicirculare pe suprafata lor, asigurand o suprafata de contact mare, oferind cresterea rezistentei hidroplanarii, tractiune extrema, protectie impotriva tuturor tipurilor de uzura si imbunatatind performanta pe carosabil umed si uscat. Blocurile de umar largi sunt si ele masive, prezentand caneluri adanci si striuri duble, unite pe cate doua blocuri, asigurand dispersia usoara a apei, o manevrabilitate mai buna si o franare eficienta.', '138', 'RON', '', '', '0', '0', '184', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', 'Romania', 'Bucuresti', '0', '', '30.36');
INSERT INTO class_ads VALUES ('33', '0', '7', '4', '34', '2017-03-28 07:10:41', '0000-00-00 00:00:00', 'Ford Kuga 2.0 tdci 4x4 automat', 'Ford Kuga 2.0 tdci 4x4 automat. Titan capacitate 1.997 cc putere 103 kw (140 cp), diesel, 6,8 l / 100 km (combinat), 8,5 l/ 100 km (urban), 5,8 l / 100 km. Pretul este fix,', '67500', 'RON', '', '', '0', '0', '99', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Ford', 'Kuga', '2012', '153900', '', 'Suv', 'Negru', 'Diesel', '', '2000', '140', 'Tractiune 4x4', 'ABS|Airbag-uri Frontale', 'Aer conditionat|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice', 'Automata', '', '', '', '', 'Romania', 'Bucuresti', '0', '', '14850');
INSERT INTO class_ads VALUES ('34', '0', '7', '4', '35', '2017-03-28 07:10:40', '0000-00-00 00:00:00', 'Audi A4 3.0 TDI - anul 2008', 'Audi A4 3.0 TDI, anul 2008, 2998 cmc, 180.000 KM, transmisie manuala (6+1 trepte). Dotari: servodirectie, climatronic, inchidere centralizata, cd player, navigatie, cotiera, geamuri si oglinzi electrice, oglinzi incalzite, jante aluminiu, carlig, proiectoare ceata, air-bag, ABS. Euro 4 Acte valabile Recent adus Arata si functioneaza perfect', '6000', '', '', '', '0', '0', '139', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Audi', 'A4', '2008', '180000', '', 'Berlina', 'Gri', 'Diesel', '', '2998', '230', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Airbag-uri Laterale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat|Aer conditionat doua zone|CD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice|Geamuri spate electrice|Oglinzi electrice|Oglinzi incalzite|Pilot automat|Senzori parcare spate', 'Manuala', '', '', '', '', 'Romania', 'Arad', '0', '', '6000');
INSERT INTO class_ads VALUES ('35', '0', '7', '4', '36', '2017-03-28 07:10:39', '0000-00-00 00:00:00', 'Volkswagen Golf VW Golf 5 - 1.9 TDI', 'Volkswagen Golf VW Golf 5 - 1.9 TDI, anul 2005, 1896 cmc, 105 CP, 217.000 KM, culoare neagra, transmisie manuala (5+1 trepte). Dotari: servodirectie, climatronic, computer bord, faruri day-line (led), volan reglabil, oglinzi electrice si incalzite, 4 geamuri electrice, inchidere centralizata, air-bag, EPS, ABS. Euro 4 Recent adusa in tara Arata si functioneaza foarte bine Nu s-au scos numere rosii Mai multe informatii la telefon Pret 3.550 EUR neg. Tel. 0740427683, Arad Proprietar PERSOANA ABS; geamuri electrice;', '3550', '', '', '', '0', '0', '6486', '1', '1', '0', '1', '1', '3', '', '0.00', 'ro', '', '0', 'Volkswagen', 'Golf', '2005', '217000', '', 'Hatchback', 'Negru', 'Diesel', '', '1898', '105', 'Tractiune fata', 'ABS|Airbag-uri Frontale|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)', 'Aer conditionat|Aer conditionat doua zone|Geamuri fata electrice', 'Manuala', '', '', '', '', 'Romania', 'Arad', '0', '', '3550');


#
# Table structure for table `class_ads_extension`
#

DROP TABLE IF EXISTS `class_ads_extension`;
CREATE TABLE `class_ads_extension` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `mgm_email` varchar(60) NOT NULL,
  `mgm_name` varchar(60) DEFAULT NULL,
  `mgm_phone` varchar(60) DEFAULT NULL,
  `activation` varchar(60) DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `pb_mgm_name` tinyint(1) DEFAULT '1',
  `pb_mgm_phone` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_activation` (`activation`),
  KEY `idx_ip` (`ip`),
  KEY `idx_mgm_email` (`mgm_email`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_ads_extension`
#

INSERT INTO class_ads_extension VALUES ('1', 'ads@weltcars.com', 'Andrei', '0755537773', 'ae6b1509cfea15d75b1e7bb002b4c989', '5.2.177.248', '1', '1');
INSERT INTO class_ads_extension VALUES ('2', 'ads@weltcars.com', 'Radu', '', '7e3b33b58a9dac97aa4e112e70590416', '5.2.177.248', '1', '1');
INSERT INTO class_ads_extension VALUES ('3', 'ads@weltcars.com', 'Farad', '', '68dbf3af02908724511c794fef78e0a3', '5.2.177.248', '1', '1');
INSERT INTO class_ads_extension VALUES ('4', 'ads@weltcars.com', 'TransAm', '', '33542302c4cd83abff2101d64f5159de', '5.2.177.248', '1', '1');
INSERT INTO class_ads_extension VALUES ('5', 'ads@weltcars.com', 'INJECTOR CRAFTER', '', '614e144258168d9afb98005b7cb08b66', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('6', 'ads@weltcars.com', 'Volkswagen Sharan', '0740797852', '6b06dadb898b6970e0dec213303f4665', '5.2.177.248', '1', '1');
INSERT INTO class_ads_extension VALUES ('7', 'ads@weltcars.com', '', '0721123113', 'e7b7c0b2736a7582868b484fcfe5b68e', '5.2.177.248', '1', '1');
INSERT INTO class_ads_extension VALUES ('8', 'ads@weltcars.com', '', '0758840951', '36f2e1e3c402497eaf067ce0f1faf922', '5.2.177.248', '1', '1');
INSERT INTO class_ads_extension VALUES ('9', 'ads@weltcars.com', '', '0758840951', '4a2388873629e24302cc66f48207c344', '5.2.177.248', '1', '1');
INSERT INTO class_ads_extension VALUES ('10', 'ads@weltcars.com', '', '0743121781', 'eb01b9f99c7dfada31d93cdf0d7deacb', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('11', 'ads@weltcars.com', '', '0741436604', '344a5445e47d416eaaf9de81e5d33b27', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('12', 'ads@weltcars.com', 'Faruri Peugeot', '0724688276', '61ddb99d3515e703c66c3e9ca9ea97e9', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('13', 'ads@weltcars.com', '', '0744332506', '2b222949fb275e5c31c2337894f8cdc2', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('14', 'ads@weltcars.com', '', '0737926232', '3b0fff9b85831f7ab787970c5a3a9dad', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('15', 'ads@weltcars.com', '', '0744398718', '109ed300bd8a517647a25bb06a6391c4', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('16', 'ads@weltcars.com', '', '0747936742', '9e88f5d6a94a27c178d2b683f99f1e2d', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('17', 'ads@weltcars.com', '', '0758905716', '093112a3a3be571babe42a1c3c155318', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('18', 'ads@weltcars.com', '', '0757873591', '61e4c915c1d140b4cd4af14d91555092', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('19', 'ads@weltcars.com', '', '0723002049', 'f400bac6abaca57d1678f044c31601ff', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('20', 'ads@weltcars.com', '', '0774483196', '90ea8a734e4daf31f59b9c81d904bf36', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('21', 'ads@weltcars.com', '', '0766 335 869', '9ed6824d073c2ff81428730dfcc6ecb6', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('22', 'ads@weltcars.com', 'Passat B6', '0773968992', 'a067dc2718af1203e4c237b4bce33622', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('23', 'ads@weltcars.com', 'Mitsubishi L200', '+447476290902', '0e8be45fe854cebdea5f87aa2d098e22', '85.120.67.173', '1', '1');
INSERT INTO class_ads_extension VALUES ('24', 'ads@weltcars.com', 'Lexus CT200 Hibrid', '0749147403', 'eb88a208449da1f77d1a3a590f133ec7', '85.120.67.173', '1', '1');
INSERT INTO class_ads_extension VALUES ('25', 'ads@weltcars.com', 'Volkswagen Sharan', '0763952074', 'de25138f21064f51b74ef362f3b5360d', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('26', 'ads@weltcars.com', 'Touran DSG', '0745338492', '3ff34d14c741e472066f360ca5e23f5e', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('27', 'ads@weltcars.com', 'Passat Highline', '0753500029', 'b0399edb13311eb923ac750cb5fcda6a', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('28', 'ads@weltcars.com', 'Pompa BMW', '0723733233', '05cc8272f5782d5effe2b8c9f22e9677', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('29', 'ads@weltcars.com', 'Renault Trafic', '0786352205', 'edba392b1ae0d49ed3db2fd7f855227c', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('30', 'ads@weltcars.com', '', '0725110001', '913adf1bfb2b7d7597228719b537a38c', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('31', 'ads@weltcars.com', 'Butuc logan', '0768444420 | 0768555999', '92759775ee29d074bf5aafc9bf1b989a', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('32', 'ads@weltcars.com', 'Anvelope Dayton', '0215395399', '8a3ed2bb4e399adbd39c3331ecb14324', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('33', 'ads@weltcars.com', '', '0722233085', 'fcb41b7ceb64872e2ace7a14ff5368fb', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('34', 'ads@weltcars.com', 'Audi A4 Arad', '0747970325', '61c49615c6a0ac548f3dc08cd4014388', '94.53.210.21', '1', '1');
INSERT INTO class_ads_extension VALUES ('35', 'ads@weltcars.com', '', '0740427683', '4c3a4840f8f69a7a2cfd75767424c55c', '94.53.210.21', '1', '1');


#
# Table structure for table `class_ads_pictures`
#

DROP TABLE IF EXISTS `class_ads_pictures`;
CREATE TABLE `class_ads_pictures` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ad_id` int(11) NOT NULL,
  `picture` varchar(128) NOT NULL,
  `folder` varchar(20) DEFAULT NULL,
  `order_no` int(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_ad` (`ad_id`),
  KEY `idx_order` (`order_no`)
) ENGINE=MyISAM AUTO_INCREMENT=183 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_ads_pictures`
#

INSERT INTO class_ads_pictures VALUES ('1', '2', 'jante_audi_noi_pe_17_inch-1486935852-326-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('2', '3', 'injectoare_ford_monde_20_tdci-1486936581-242-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('3', '4', 'motor_m47t_bmw_e46_320d_150_cai-1486936733-177-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('4', '5', 'injector_vw_crafter_25tdi-1486993144-988-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('5', '6', 'volkswagen_sharan_diesel_19_tdi-1487025622-239-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('6', '6', 'volkswagen_sharan_diesel_19_tdi-1487025622-494-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('7', '6', 'volkswagen_sharan_diesel_19_tdi-1487025622-351-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('8', '6', 'volkswagen_sharan_diesel_19_tdi-1487025622-662-e.jpg', '2017-02', '4');
INSERT INTO class_ads_pictures VALUES ('9', '6', 'volkswagen_sharan_diesel_19_tdi-1487025622-64-e.jpg', '2017-02', '5');
INSERT INTO class_ads_pictures VALUES ('10', '6', 'volkswagen_sharan_diesel_19_tdi-1487025622-915-e.jpg', '2017-02', '6');
INSERT INTO class_ads_pictures VALUES ('11', '6', 'volkswagen_sharan_diesel_19_tdi-1487025622-457-e.jpg', '2017-02', '7');
INSERT INTO class_ads_pictures VALUES ('12', '6', 'volkswagen_sharan_diesel_19_tdi-1487025622-471-e.jpg', '2017-02', '8');
INSERT INTO class_ads_pictures VALUES ('13', '7', 'renault_clio_2000_benzin-1487107249-808-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('14', '7', 'renault_clio_2000_benzin-1487107249-114-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('15', '7', 'renault_clio_2000_benzin-1487107249-970-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('16', '7', 'renault_clio_2000_benzin-1487107249-642-e.jpg', '2017-02', '4');
INSERT INTO class_ads_pictures VALUES ('17', '8', 'audi_a6_diesel_136_cp_2007-1487107718-102-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('18', '8', 'audi_a6_diesel_136_cp_2007-1487107718-604-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('19', '8', 'audi_a6_diesel_136_cp_2007-1487107718-344-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('20', '8', 'audi_a6_diesel_136_cp_2007-1487107718-999-e.jpg', '2017-02', '4');
INSERT INTO class_ads_pictures VALUES ('21', '8', 'audi_a6_diesel_136_cp_2007-1487107718-409-e.jpg', '2017-02', '5');
INSERT INTO class_ads_pictures VALUES ('22', '8', 'audi_a6_diesel_136_cp_2007-1487107718-489-e.jpg', '2017-02', '6');
INSERT INTO class_ads_pictures VALUES ('23', '8', 'audi_a6_diesel_136_cp_2007-1487107718-637-e.jpg', '2017-02', '7');
INSERT INTO class_ads_pictures VALUES ('24', '8', 'audi_a6_diesel_136_cp_2007-1487107718-439-e.jpg', '2017-02', '8');
INSERT INTO class_ads_pictures VALUES ('25', '9', 'ford_focus_euro_4_recent_adus-1487108948-15-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('26', '9', 'ford_focus_euro_4_recent_adus-1487108948-391-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('27', '9', 'ford_focus_euro_4_recent_adus-1487108948-631-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('28', '10', 'volkswagen_golf_v_19_tdi-1487320764-687-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('29', '10', 'volkswagen_golf_v_19_tdi-1487320764-821-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('30', '10', 'volkswagen_golf_v_19_tdi-1487320764-572-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('31', '10', 'volkswagen_golf_v_19_tdi-1487320765-226-e.jpg', '2017-02', '4');
INSERT INTO class_ads_pictures VALUES ('32', '10', 'volkswagen_golf_v_19_tdi-1487320765-697-e.jpg', '2017-02', '5');
INSERT INTO class_ads_pictures VALUES ('33', '10', 'volkswagen_golf_v_19_tdi-1487320765-553-e.jpg', '2017-02', '6');
INSERT INTO class_ads_pictures VALUES ('34', '10', 'volkswagen_golf_v_19_tdi-1487320765-124-e.jpg', '2017-02', '7');
INSERT INTO class_ads_pictures VALUES ('35', '10', 'volkswagen_golf_v_19_tdi-1487320765-723-e.jpg', '2017-02', '8');
INSERT INTO class_ads_pictures VALUES ('36', '11', 'audi_tt_18t_180_cp_cu_xenon_piele_climat-1487320959-743-e.jpeg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('37', '11', 'audi_tt_18t_180_cp_cu_xenon_piele_climat-1487320959-825-e.jpeg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('38', '11', 'audi_tt_18t_180_cp_cu_xenon_piele_climat-1487320959-818-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('39', '11', 'audi_tt_18t_180_cp_cu_xenon_piele_climat-1487320960-173-e.jpeg', '2017-02', '4');
INSERT INTO class_ads_pictures VALUES ('40', '11', 'audi_tt_18t_180_cp_cu_xenon_piele_climat-1487320960-279-e.jpeg', '2017-02', '5');
INSERT INTO class_ads_pictures VALUES ('41', '11', 'audi_tt_18t_180_cp_cu_xenon_piele_climat-1487320960-268-e.jpg', '2017-02', '6');
INSERT INTO class_ads_pictures VALUES ('42', '11', 'audi_tt_18t_180_cp_cu_xenon_piele_climat-1487320960-616-e.jpg', '2017-02', '7');
INSERT INTO class_ads_pictures VALUES ('43', '12', 'faruri_peugeot_307_an_2006-1487321364-539-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('44', '12', 'faruri_peugeot_307_an_2006-1487321364-595-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('45', '13', 'pompa_de_injectie_bosch_pes6p120-1487321623-156-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('46', '13', 'pompa_de_injectie_bosch_pes6p120-1487321623-677-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('47', '13', 'pompa_de_injectie_bosch_pes6p120-1487321623-706-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('48', '13', 'pompa_de_injectie_bosch_pes6p120-1487321623-67-e.jpg', '2017-02', '4');
INSERT INTO class_ads_pictures VALUES ('49', '13', 'pompa_de_injectie_bosch_pes6p120-1487321623-491-e.jpg', '2017-02', '5');
INSERT INTO class_ads_pictures VALUES ('50', '13', 'pompa_de_injectie_bosch_pes6p120-1487321623-836-e.jpg', '2017-02', '6');
INSERT INTO class_ads_pictures VALUES ('51', '14', 'capota_fata_vw_golf_6_2012_2016-1487323701-461-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('52', '14', 'capota_fata_vw_golf_6_2012_2016-1487323701-24-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('53', '15', 'bara_fata_mercedes_ml_w166-1487327560-485-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('54', '16', 'volkswagen_passat_model_highline_diesel-1487332390-920-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('55', '16', 'volkswagen_passat_model_highline_diesel-1487332390-664-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('56', '16', 'volkswagen_passat_model_highline_diesel-1487332390-15-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('57', '16', 'volkswagen_passat_model_highline_diesel-1487332390-741-e.jpg', '2017-02', '4');
INSERT INTO class_ads_pictures VALUES ('58', '16', 'volkswagen_passat_model_highline_diesel-1487332390-638-e.jpg', '2017-02', '5');
INSERT INTO class_ads_pictures VALUES ('59', '16', 'volkswagen_passat_model_highline_diesel-1487332390-269-e.jpg', '2017-02', '6');
INSERT INTO class_ads_pictures VALUES ('60', '16', 'volkswagen_passat_model_highline_diesel-1487332390-547-e.jpg', '2017-02', '7');
INSERT INTO class_ads_pictures VALUES ('61', '16', 'volkswagen_passat_model_highline_diesel-1487332390-734-e.jpg', '2017-02', '8');
INSERT INTO class_ads_pictures VALUES ('62', '17', 'citroen_c4_picasso_import_recent_franta-1487347545-681-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('63', '17', 'citroen_c4_picasso_import_recent_franta-1487347545-292-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('64', '17', 'citroen_c4_picasso_import_recent_franta-1487347545-623-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('65', '17', 'citroen_c4_picasso_import_recent_franta-1487347545-657-e.jpg', '2017-02', '4');
INSERT INTO class_ads_pictures VALUES ('66', '17', 'citroen_c4_picasso_import_recent_franta-1487347546-908-e.jpg', '2017-02', '5');
INSERT INTO class_ads_pictures VALUES ('67', '17', 'citroen_c4_picasso_import_recent_franta-1487347546-362-e.jpg', '2017-02', '6');
INSERT INTO class_ads_pictures VALUES ('68', '17', 'citroen_c4_picasso_import_recent_franta-1487347546-198-e.jpg', '2017-02', '7');
INSERT INTO class_ads_pictures VALUES ('69', '17', 'citroen_c4_picasso_import_recent_franta-1487347546-387-e.jpg', '2017-02', '8');
INSERT INTO class_ads_pictures VALUES ('70', '17', 'citroen_c4_picasso_import_recent_franta-1487347546-168-e.jpg', '2017-02', '9');
INSERT INTO class_ads_pictures VALUES ('71', '18', 'citroen_c5_16_hdi_110_cp_2010-1487405081-9-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('72', '18', 'citroen_c5_16_hdi_110_cp_2010-1487405081-960-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('73', '18', 'citroen_c5_16_hdi_110_cp_2010-1487405081-744-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('74', '18', 'citroen_c5_16_hdi_110_cp_2010-1487405081-726-e.jpg', '2017-02', '4');
INSERT INTO class_ads_pictures VALUES ('75', '18', 'citroen_c5_16_hdi_110_cp_2010-1487405081-541-e.jpg', '2017-02', '5');
INSERT INTO class_ads_pictures VALUES ('76', '18', 'citroen_c5_16_hdi_110_cp_2010-1487405081-26-e.jpg', '2017-02', '6');
INSERT INTO class_ads_pictures VALUES ('77', '18', 'citroen_c5_16_hdi_110_cp_2010-1487405081-929-e.jpg', '2017-02', '7');
INSERT INTO class_ads_pictures VALUES ('78', '18', 'citroen_c5_16_hdi_110_cp_2010-1487405082-858-e.jpg', '2017-02', '8');
INSERT INTO class_ads_pictures VALUES ('79', '19', 'mazda_cx_5-1487405342-934-e.png', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('80', '19', 'mazda_cx_5-1487405343-45-e.png', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('81', '19', 'mazda_cx_5-1487405341-892-e.png', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('82', '20', 'opel_astra_diesel_an_2004-1488188917-17-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('83', '20', 'opel_astra_diesel_an_2004-1488188917-444-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('84', '20', 'opel_astra_diesel_an_2004-1488188917-554-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('85', '20', 'opel_astra_diesel_an_2004-1488188918-313-e.jpg', '2017-02', '4');
INSERT INTO class_ads_pictures VALUES ('86', '20', 'opel_astra_diesel_an_2004-1488188918-191-e.jpg', '2017-02', '5');
INSERT INTO class_ads_pictures VALUES ('87', '20', 'opel_astra_diesel_an_2004-1488188917-716-e.jpg', '2017-02', '6');
INSERT INTO class_ads_pictures VALUES ('88', '20', 'opel_astra_diesel_an_2004-1488188918-523-e.jpg', '2017-02', '7');
INSERT INTO class_ads_pictures VALUES ('89', '20', 'opel_astra_diesel_an_2004-1488188917-261-e.jpg', '2017-02', '8');
INSERT INTO class_ads_pictures VALUES ('90', '21', 'ford_fiesta_euro_4_inmatriculat-1488193305-463-e.jpg', '2017-02', '1');
INSERT INTO class_ads_pictures VALUES ('91', '21', 'ford_fiesta_euro_4_inmatriculat-1488193305-683-e.jpg', '2017-02', '2');
INSERT INTO class_ads_pictures VALUES ('92', '21', 'ford_fiesta_euro_4_inmatriculat-1488193305-416-e.jpg', '2017-02', '3');
INSERT INTO class_ads_pictures VALUES ('93', '21', 'ford_fiesta_euro_4_inmatriculat-1488193305-957-e.jpg', '2017-02', '4');
INSERT INTO class_ads_pictures VALUES ('94', '21', 'ford_fiesta_euro_4_inmatriculat-1488193305-411-e.jpg', '2017-02', '5');
INSERT INTO class_ads_pictures VALUES ('95', '21', 'ford_fiesta_euro_4_inmatriculat-1488193306-322-e.jpg', '2017-02', '6');
INSERT INTO class_ads_pictures VALUES ('96', '21', 'ford_fiesta_euro_4_inmatriculat-1488193306-75-e.jpg', '2017-02', '7');
INSERT INTO class_ads_pictures VALUES ('97', '21', 'ford_fiesta_euro_4_inmatriculat-1488193306-838-e.jpg', '2017-02', '8');
INSERT INTO class_ads_pictures VALUES ('98', '22', 'volkswagen_passat_b6_20_tdi_2006_taxa_pl-1488453191-912-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('99', '22', 'volkswagen_passat_b6_20_tdi_2006_taxa_pl-1488453192-51-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('100', '22', 'volkswagen_passat_b6_20_tdi_2006_taxa_pl-1488453191-588-e.jpg', '2017-03', '3');
INSERT INTO class_ads_pictures VALUES ('101', '22', 'volkswagen_passat_b6_20_tdi_2006_taxa_pl-1488453192-24-e.jpg', '2017-03', '4');
INSERT INTO class_ads_pictures VALUES ('102', '22', 'volkswagen_passat_b6_20_tdi_2006_taxa_pl-1488453192-925-e.jpg', '2017-03', '5');
INSERT INTO class_ads_pictures VALUES ('103', '22', 'volkswagen_passat_b6_20_tdi_2006_taxa_pl-1488453192-260-e.jpg', '2017-03', '6');
INSERT INTO class_ads_pictures VALUES ('104', '22', 'volkswagen_passat_b6_20_tdi_2006_taxa_pl-1488453192-719-e.jpg', '2017-03', '7');
INSERT INTO class_ads_pictures VALUES ('105', '23', 'mitsubishi_l200_warrior_4x4_2006-1488802355-222-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('106', '23', 'mitsubishi_l200_warrior_4x4_2006-1488802355-494-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('107', '23', 'mitsubishi_l200_warrior_4x4_2006-1488802355-612-e.jpg', '2017-03', '3');
INSERT INTO class_ads_pictures VALUES ('108', '23', 'mitsubishi_l200_warrior_4x4_2006-1488802356-557-e.jpg', '2017-03', '4');
INSERT INTO class_ads_pictures VALUES ('109', '23', 'mitsubishi_l200_warrior_4x4_2006-1488802356-708-e.jpg', '2017-03', '5');
INSERT INTO class_ads_pictures VALUES ('110', '23', 'mitsubishi_l200_warrior_4x4_2006-1488802356-676-e.jpg', '2017-03', '6');
INSERT INTO class_ads_pictures VALUES ('111', '23', 'mitsubishi_l200_warrior_4x4_2006-1488802356-519-e.jpg', '2017-03', '7');
INSERT INTO class_ads_pictures VALUES ('112', '23', 'mitsubishi_l200_warrior_4x4_2006-1488802356-305-e.jpg', '2017-03', '8');
INSERT INTO class_ads_pictures VALUES ('113', '24', 'lexus_ct_200h_hibrid-1488802683-719-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('114', '24', 'lexus_ct_200h_hibrid-1488802683-464-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('115', '24', 'lexus_ct_200h_hibrid-1488802683-203-e.jpg', '2017-03', '3');
INSERT INTO class_ads_pictures VALUES ('116', '24', 'lexus_ct_200h_hibrid-1488802683-295-e.jpg', '2017-03', '4');
INSERT INTO class_ads_pictures VALUES ('117', '24', 'lexus_ct_200h_hibrid-1488802683-68-e.jpg', '2017-03', '5');
INSERT INTO class_ads_pictures VALUES ('118', '24', 'lexus_ct_200h_hibrid-1488802683-407-e.jpg', '2017-03', '6');
INSERT INTO class_ads_pictures VALUES ('119', '24', 'lexus_ct_200h_hibrid-1488802684-700-e.jpg', '2017-03', '7');
INSERT INTO class_ads_pictures VALUES ('120', '25', 'volkswagen_sharan_20_tdi_2007-1489150628-588-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('121', '25', 'volkswagen_sharan_20_tdi_2007-1489150628-570-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('122', '25', 'volkswagen_sharan_20_tdi_2007-1489150628-804-e.jpg', '2017-03', '3');
INSERT INTO class_ads_pictures VALUES ('123', '25', 'volkswagen_sharan_20_tdi_2007-1489150628-656-e.jpg', '2017-03', '4');
INSERT INTO class_ads_pictures VALUES ('124', '25', 'volkswagen_sharan_20_tdi_2007-1489150628-463-e.jpg', '2017-03', '5');
INSERT INTO class_ads_pictures VALUES ('125', '25', 'volkswagen_sharan_20_tdi_2007-1489150628-928-e.jpg', '2017-03', '6');
INSERT INTO class_ads_pictures VALUES ('126', '25', 'volkswagen_sharan_20_tdi_2007-1489150629-932-e.jpg', '2017-03', '7');
INSERT INTO class_ads_pictures VALUES ('127', '25', 'volkswagen_sharan_20_tdi_2007-1489150629-878-e.jpg', '2017-03', '8');
INSERT INTO class_ads_pictures VALUES ('128', '25', 'volkswagen_sharan_20_tdi_2007-1489150629-254-e.jpg', '2017-03', '9');
INSERT INTO class_ads_pictures VALUES ('129', '25', 'volkswagen_sharan_20_tdi_2007-1489150629-580-e.jpg', '2017-03', '10');
INSERT INTO class_ads_pictures VALUES ('130', '25', 'volkswagen_sharan_20_tdi_2007-1489150629-92-e.jpg', '2017-03', '11');
INSERT INTO class_ads_pictures VALUES ('131', '26', 'volkswagen_touran_transmisie_automata_ds-1489150953-651-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('132', '26', 'volkswagen_touran_transmisie_automata_ds-1489150953-971-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('133', '26', 'volkswagen_touran_transmisie_automata_ds-1489150953-385-e.jpg', '2017-03', '3');
INSERT INTO class_ads_pictures VALUES ('134', '26', 'volkswagen_touran_transmisie_automata_ds-1489150953-233-e.jpg', '2017-03', '4');
INSERT INTO class_ads_pictures VALUES ('135', '26', 'volkswagen_touran_transmisie_automata_ds-1489150953-401-e.jpg', '2017-03', '5');
INSERT INTO class_ads_pictures VALUES ('136', '26', 'volkswagen_touran_transmisie_automata_ds-1489150953-758-e.jpg', '2017-03', '6');
INSERT INTO class_ads_pictures VALUES ('137', '26', 'volkswagen_touran_transmisie_automata_ds-1489150954-394-e.jpg', '2017-03', '7');
INSERT INTO class_ads_pictures VALUES ('138', '26', 'volkswagen_touran_transmisie_automata_ds-1489150954-258-e.jpg', '2017-03', '8');
INSERT INTO class_ads_pictures VALUES ('139', '27', 'volkswagen_passat_high_line_20_tdi-1489493584-558-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('140', '27', 'volkswagen_passat_high_line_20_tdi-1489493584-261-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('141', '27', 'volkswagen_passat_high_line_20_tdi-1489493584-757-e.jpg', '2017-03', '3');
INSERT INTO class_ads_pictures VALUES ('142', '27', 'volkswagen_passat_high_line_20_tdi-1489493585-950-e.jpg', '2017-03', '4');
INSERT INTO class_ads_pictures VALUES ('143', '27', 'volkswagen_passat_high_line_20_tdi-1489493585-10-e.jpg', '2017-03', '5');
INSERT INTO class_ads_pictures VALUES ('144', '27', 'volkswagen_passat_high_line_20_tdi-1489493585-273-e.jpg', '2017-03', '6');
INSERT INTO class_ads_pictures VALUES ('145', '27', 'volkswagen_passat_high_line_20_tdi-1489493585-404-e.jpg', '2017-03', '7');
INSERT INTO class_ads_pictures VALUES ('146', '28', 'modul_pompa_combustibil_bmw-1489493750-140-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('147', '28', 'modul_pompa_combustibil_bmw-1489493750-357-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('148', '29', 'renault_trafic-1489493946-107-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('149', '29', 'renault_trafic-1489493947-344-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('150', '29', 'renault_trafic-1489493946-707-e.jpg', '2017-03', '3');
INSERT INTO class_ads_pictures VALUES ('151', '29', 'renault_trafic-1489493946-442-e.jpg', '2017-03', '4');
INSERT INTO class_ads_pictures VALUES ('152', '29', 'renault_trafic-1489493947-783-e.jpg', '2017-03', '5');
INSERT INTO class_ads_pictures VALUES ('153', '29', 'renault_trafic-1489493947-380-e.jpg', '2017-03', '6');
INSERT INTO class_ads_pictures VALUES ('154', '30', 'audi_a_4_in_stare_exceptionala_an_fabric-1489665273-77-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('155', '30', 'audi_a_4_in_stare_exceptionala_an_fabric-1489665271-284-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('156', '30', 'audi_a_4_in_stare_exceptionala_an_fabric-1489665271-879-e.png', '2017-03', '3');
INSERT INTO class_ads_pictures VALUES ('157', '30', 'audi_a_4_in_stare_exceptionala_an_fabric-1489665272-594-e.png', '2017-03', '4');
INSERT INTO class_ads_pictures VALUES ('158', '30', 'audi_a_4_in_stare_exceptionala_an_fabric-1489665272-732-e.jpg', '2017-03', '5');
INSERT INTO class_ads_pictures VALUES ('159', '30', 'audi_a_4_in_stare_exceptionala_an_fabric-1489665272-44-e.jpg', '2017-03', '6');
INSERT INTO class_ads_pictures VALUES ('160', '30', 'audi_a_4_in_stare_exceptionala_an_fabric-1489665273-256-e.jpg', '2017-03', '7');
INSERT INTO class_ads_pictures VALUES ('161', '30', 'audi_a_4_in_stare_exceptionala_an_fabric-1489665273-528-e.jpg', '2017-03', '8');
INSERT INTO class_ads_pictures VALUES ('162', '31', 'butuc_roata_fata_dacia_logan_2004_2012-1490367001-56-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('163', '32', 'anvelope_vara_dayton_touring_16570_r14_8-1490367148-754-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('164', '33', 'ford_kuga_20_tdci_4x4_automat-1490690627-728-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('165', '33', 'ford_kuga_20_tdci_4x4_automat-1490690626-362-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('166', '33', 'ford_kuga_20_tdci_4x4_automat-1490690627-971-e.jpg', '2017-03', '3');
INSERT INTO class_ads_pictures VALUES ('167', '34', 'audi_a4_30_tdi_anul_2008-1490690879-306-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('168', '34', 'audi_a4_30_tdi_anul_2008-1490690879-406-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('169', '34', 'audi_a4_30_tdi_anul_2008-1490690879-277-e.jpg', '2017-03', '3');
INSERT INTO class_ads_pictures VALUES ('170', '34', 'audi_a4_30_tdi_anul_2008-1490690879-851-e.jpg', '2017-03', '4');
INSERT INTO class_ads_pictures VALUES ('171', '34', 'audi_a4_30_tdi_anul_2008-1490690879-997-e.jpg', '2017-03', '5');
INSERT INTO class_ads_pictures VALUES ('172', '34', 'audi_a4_30_tdi_anul_2008-1490690879-760-e.jpg', '2017-03', '6');
INSERT INTO class_ads_pictures VALUES ('173', '34', 'audi_a4_30_tdi_anul_2008-1490690879-376-e.jpg', '2017-03', '7');
INSERT INTO class_ads_pictures VALUES ('174', '34', 'audi_a4_30_tdi_anul_2008-1490690879-164-e.jpg', '2017-03', '8');
INSERT INTO class_ads_pictures VALUES ('175', '35', 'volkswagen_golf_vw_golf_5_19_tdi-1490692204-208-e.jpg', '2017-03', '1');
INSERT INTO class_ads_pictures VALUES ('176', '35', 'volkswagen_golf_vw_golf_5_19_tdi-1490692204-966-e.jpg', '2017-03', '2');
INSERT INTO class_ads_pictures VALUES ('177', '35', 'volkswagen_golf_vw_golf_5_19_tdi-1490692204-869-e.jpg', '2017-03', '3');
INSERT INTO class_ads_pictures VALUES ('178', '35', 'volkswagen_golf_vw_golf_5_19_tdi-1490692204-960-e.jpg', '2017-03', '4');
INSERT INTO class_ads_pictures VALUES ('179', '35', 'volkswagen_golf_vw_golf_5_19_tdi-1490692204-716-e.jpg', '2017-03', '5');
INSERT INTO class_ads_pictures VALUES ('180', '35', 'volkswagen_golf_vw_golf_5_19_tdi-1490692205-397-e.jpg', '2017-03', '6');
INSERT INTO class_ads_pictures VALUES ('181', '35', 'volkswagen_golf_vw_golf_5_19_tdi-1490692205-610-e.jpg', '2017-03', '7');
INSERT INTO class_ads_pictures VALUES ('182', '35', 'volkswagen_golf_vw_golf_5_19_tdi-1490692205-838-e.jpg', '2017-03', '8');


#
# Table structure for table `class_ads_settings`
#

DROP TABLE IF EXISTS `class_ads_settings`;
CREATE TABLE `class_ads_settings` (
  `thmb_width` int(4) DEFAULT '120',
  `thmb_height` int(4) DEFAULT '80',
  `big_thmb_width` int(4) DEFAULT '510',
  `big_thmb_height` int(4) DEFAULT '340',
  `nopic` varchar(128) DEFAULT NULL,
  `big_nopic` varchar(128) DEFAULT NULL,
  `pic_max_size` int(5) DEFAULT '1500',
  `pic_max_width` int(5) DEFAULT '2000',
  `pic_max_height` int(5) DEFAULT '1600',
  `resize_image` tinyint(1) DEFAULT '0',
  `resize_width` int(5) DEFAULT '800',
  `resize_height` int(5) DEFAULT '600',
  `watermark` varchar(60) DEFAULT NULL,
  `watermark_position` varchar(4) DEFAULT 'br',
  `watermark_transparency` int(3) DEFAULT '50',
  `days_recent` int(5) DEFAULT '0',
  `badwords_check` tinyint(1) DEFAULT '1',
  `badwords_check_type` tinyint(1) DEFAULT '1',
  `enable_price` tinyint(1) DEFAULT NULL,
  `enable_stock` tinyint(1) DEFAULT '1',
  `enable_sold` tinyint(1) DEFAULT '1',
  `enable_rented` tinyint(1) DEFAULT '0',
  `sold_image` varchar(60) DEFAULT NULL,
  `rented_image` varchar(60) DEFAULT NULL,
  `hide_contact_when_sold` tinyint(1) DEFAULT '0',
  `hide_contact_when_rented` tinyint(1) DEFAULT '0',
  `description_editor` tinyint(1) DEFAULT '0',
  `no_featured` int(2) DEFAULT '2',
  `no_featured_on_row` int(2) DEFAULT '1',
  `enable_latest` tinyint(1) DEFAULT '1',
  `no_latest` int(2) DEFAULT '3',
  `no_latest_on_row` int(2) DEFAULT '3',
  `show_more_link` tinyint(1) DEFAULT '1',
  `enable_featured` tinyint(1) DEFAULT '1',
  `enable_highlited` tinyint(1) DEFAULT '1',
  `enable_priorities` tinyint(1) DEFAULT '1',
  `random_priorities` tinyint(1) DEFAULT '0',
  `enable_video` tinyint(1) DEFAULT '1',
  `highlited_color` varchar(7) DEFAULT NULL,
  `featured_expires` int(4) DEFAULT '0',
  `highlited_expires` int(4) DEFAULT '0',
  `priorities_expires` int(4) DEFAULT '0',
  `video_expires` int(4) DEFAULT '0',
  `featured_price` double DEFAULT '0',
  `highlited_price` double DEFAULT '0',
  `video_price` double DEFAULT '0',
  `store_availability` int(4) DEFAULT '30',
  `store_price` double DEFAULT '0',
  `resize_store_image` tinyint(1) DEFAULT '0',
  `resize_store_width` int(5) DEFAULT '200',
  `resize_store_height` int(5) DEFAULT '100',
  `add_meta_with_listings` tinyint(1) DEFAULT '1',
  `allowed_html` varchar(250) DEFAULT NULL,
  `search_in_fields` varchar(250) DEFAULT NULL,
  `location_fields` varchar(250) DEFAULT NULL,
  `translate_title_description` tinyint(1) DEFAULT '0',
  `show_ad_date_for_everybody` tinyint(1) DEFAULT '1',
  `alerts_enabled` tinyint(1) DEFAULT '1',
  `alerts_ask_adv_key` tinyint(1) DEFAULT '0',
  `alerts_days_delete` int(4) DEFAULT '30',
  `alerts_require_login` tinyint(1) DEFAULT '0',
  `alerts_activation` tinyint(1) DEFAULT '2',
  `saved_searches_enabled` tinyint(1) DEFAULT '1',
  `enable_map_search` tinyint(1) DEFAULT '0',
  `map_visible` tinyint(1) DEFAULT '0',
  `default_search_view` tinyint(1) DEFAULT '0',
  `search_location_fields` varchar(250) DEFAULT NULL,
  `search_type` varchar(10) NOT NULL DEFAULT 'any',
  `hide_contact_when_not_logged` tinyint(1) NOT NULL DEFAULT '0',
  `featured_autoscroll` tinyint(1) DEFAULT '1',
  `date_time_ago_format` tinyint(1) DEFAULT '0',
  `date_time_ago_days` int(3) DEFAULT '7',
  `pending_edited` tinyint(1) DEFAULT '0',
  `enable_auctions` tinyint(1) DEFAULT '0',
  `notify_when_new_bid` tinyint(1) DEFAULT '1',
  `prioritize_featured` tinyint(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_ads_settings`
#

INSERT INTO class_ads_settings VALUES ('120', '80', '510', '340', 'noimage.jpg', 'big_nopic.gif', '30000', '9000', '9000', '1', '1920', '1080', '', 'br', '50', '0', '1', '1', '1', '1', '1', '1', 'sold.gif', 'rented.gif', '1', '0', '0', '10', '5', '1', '10', '1', '1', '1', '1', '1', '0', '1', '#f5f5f5', '0', '0', '0', '0', '5', '2', '2', '120', '10', '1', '200', '100', '0', 'b,br,center,div,em,font,i,p,span,strong,u', 'title,description', '', '0', '1', '1', '0', '30', '0', '2', '1', '0', '0', '0', '', 'any', '0', '1', '0', '7', '0', '0', '1', '1');


#
# Table structure for table `class_affiliates`
#

DROP TABLE IF EXISTS `class_affiliates`;
CREATE TABLE `class_affiliates` (
  `id` int(10) NOT NULL,
  `affiliate_id` varchar(8) NOT NULL,
  `affiliate_paypal_email` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_affiliates`
#



#
# Table structure for table `class_affiliates_payments`
#

DROP TABLE IF EXISTS `class_affiliates_payments`;
CREATE TABLE `class_affiliates_payments` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `affiliate_id` varchar(8) NOT NULL,
  `amount` float DEFAULT NULL,
  `date` datetime NOT NULL,
  `processor` varchar(40) DEFAULT 'paypal',
  `paid_to` varchar(200) DEFAULT NULL,
  `completed` int(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_affiliate_id` (`affiliate_id`),
  KEY `idx_date` (`date`),
  KEY `idx_released` (`completed`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_affiliates_payments`
#



#
# Table structure for table `class_affiliates_revenue`
#

DROP TABLE IF EXISTS `class_affiliates_revenue`;
CREATE TABLE `class_affiliates_revenue` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `affiliate_id` varchar(8) NOT NULL,
  `amount` float DEFAULT NULL,
  `date` datetime NOT NULL,
  `order_id` int(20) NOT NULL,
  `paid` int(1) DEFAULT '0',
  `released` int(1) DEFAULT '0',
  `payment_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_affiliate_id` (`affiliate_id`),
  KEY `idx_date` (`date`),
  KEY `idx_paid` (`paid`),
  KEY `idx_released` (`released`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_affiliates_revenue`
#



#
# Table structure for table `class_appearance`
#

DROP TABLE IF EXISTS `class_appearance`;
CREATE TABLE `class_appearance` (
  `template` varchar(50) DEFAULT 'default',
  `template_colorscheme` varchar(50) DEFAULT NULL,
  `admin_template` varchar(50) DEFAULT 'default',
  `admin_language` varchar(20) DEFAULT 'eng',
  `show_header` tinyint(1) DEFAULT '1',
  `header_pic` varchar(128) DEFAULT NULL,
  `small_header_pic` varchar(128) DEFAULT NULL,
  `header_pic_link` varchar(128) DEFAULT NULL,
  `show_footer` tinyint(1) DEFAULT '0',
  `footer_pic` varchar(128) DEFAULT NULL,
  `footer_pic_link` varchar(128) DEFAULT NULL,
  `show_footer_categ` tinyint(1) DEFAULT '1',
  `outer_table` int(4) DEFAULT NULL,
  `max_cat_per_row` tinyint(1) DEFAULT '3',
  `categ_count_ads` tinyint(1) DEFAULT '1',
  `ads_per_page` int(2) DEFAULT '5',
  `first_page_type` int(2) DEFAULT '1',
  `timezone` varchar(50) DEFAULT 'GMT',
  `time_offset` int(5) DEFAULT '0',
  `maintenance_mode` int(1) DEFAULT '0',
  `maintenance_ips` text,
  `enable_impressions_count` int(1) DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_appearance`
#

INSERT INTO class_appearance VALUES ('momentum', 'dark_blue', 'default', 'eng', '1', 'logonou2.png', '', 'https://weltcars.com', '1', '', '', '0', '1200', '2', '0', '20', '1', 'Etc/GMT+2', '0', '1', '94.53.210.21', '1');


#
# Table structure for table `class_appearance_lang`
#

DROP TABLE IF EXISTS `class_appearance_lang`;
CREATE TABLE `class_appearance_lang` (
  `lang_id` varchar(20) DEFAULT 'eng',
  `footer_text` varchar(255) DEFAULT '',
  `charset` varchar(50) DEFAULT 'UTF-8',
  `default_currency` varchar(10) DEFAULT '$',
  `currency_pos` tinyint(1) DEFAULT '0',
  `date_format` varchar(30) DEFAULT NULL,
  `date_format_long` varchar(30) DEFAULT NULL,
  `number_format_decimals` int(2) DEFAULT '2',
  `number_format_point` varchar(5) DEFAULT '.',
  `number_format_separator` varchar(5) DEFAULT ',',
  `price_format_decimals` int(2) DEFAULT '0',
  `price_format_point` varchar(5) DEFAULT '.',
  `price_format_separator` varchar(5) DEFAULT ','
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_appearance_lang`
#

INSERT INTO class_appearance_lang VALUES ('eng', 'Copyright 2016, Weltcars.com', 'UTF-8', '', '0', '%b %d, %Y', '%b %d, %Y %H:%i', '2', '.', ',', '2', '.', ',');
INSERT INTO class_appearance_lang VALUES ('esp', 'Copyright 2016, YourDomain.com', 'UTF-8', '$', '0', '%b %d, %Y', '%b %d, %Y %H:%i', '2', '.', ',', '2', '.', ',');
INSERT INTO class_appearance_lang VALUES ('french', 'Copyright 2016, YourDomain.com', 'UTF-8', '$', '0', '%b %d, %Y', '%b %d, %Y %H:%i', '2', '.', ',', '2', '.', ',');
INSERT INTO class_appearance_lang VALUES ('italian', 'Copyright 2016, YourDomain.com', 'UTF-8', '$', '0', '%b %d, %Y', '%b %d, %Y %H:%i', '2', '.', ',', '2', '.', ',');
INSERT INTO class_appearance_lang VALUES ('german', 'Copyright 2016, Weltcars.com', 'UTF-8', '', '1', '%b %d, %Y', '%b %d, %Y %H:%i', '2', '.', ',', '2', '.', ',');
INSERT INTO class_appearance_lang VALUES ('ro', 'Copyright 2016, Weltcars.com', 'UTF-8', '', '1', '%b %d, %Y', '%b %d, %Y %H:%i', '2', '.', ',', '2', '.', ',');
INSERT INTO class_appearance_lang VALUES ('hr', 'Copyright 2016, YourDomain.com', 'UTF-8', '$', '0', '%b %d, %Y', '%b %d, %Y %H:%i', '2', '.', ',', '2', '.', ',');
INSERT INTO class_appearance_lang VALUES ('hu', 'Copyright 2016, YourDomain.com', 'UTF-8', '$', '0', '%b %d, %Y', '%b %d, %Y %H:%i', '2', '.', ',', '2', '.', ',');
INSERT INTO class_appearance_lang VALUES ('bg', 'Copyright 2016, YourDomain.com', 'UTF-8', '$', '0', '%b %d, %Y', '%b %d, %Y %H:%i', '2', '.', ',', '2', '.', ',');


#
# Table structure for table `class_auctions`
#

DROP TABLE IF EXISTS `class_auctions`;
CREATE TABLE `class_auctions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ad_id` int(10) NOT NULL,
  `starting_price` double NOT NULL,
  `unit_starting_price` double DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `max_bid` double NOT NULL,
  `date` datetime NOT NULL,
  `active` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ad_id` (`ad_id`),
  KEY `date` (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_auctions`
#



#
# Table structure for table `class_authorize_return`
#

DROP TABLE IF EXISTS `class_authorize_return`;
CREATE TABLE `class_authorize_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `x_response_code` int(3) DEFAULT NULL,
  `x_response_subcode` int(3) DEFAULT NULL,
  `x_response_reason_code` int(3) DEFAULT NULL,
  `x_response_reason_text` text,
  `x_auth_code` varchar(6) DEFAULT NULL,
  `x_avs_code` char(1) DEFAULT NULL,
  `x_trans_id` varchar(40) DEFAULT NULL,
  `x_invoice_num` int(5) DEFAULT NULL,
  `x_description` varchar(100) DEFAULT NULL,
  `x_amount` float DEFAULT NULL,
  `x_method` varchar(10) DEFAULT NULL,
  `x_type` varchar(20) DEFAULT NULL,
  `x_cust_id` varchar(20) DEFAULT NULL,
  `x_first_name` varchar(50) DEFAULT NULL,
  `x_last_name` varchar(50) DEFAULT NULL,
  `x_company` varchar(60) DEFAULT NULL,
  `x_address` varchar(60) DEFAULT NULL,
  `x_city` varchar(40) DEFAULT NULL,
  `x_state` varchar(50) DEFAULT NULL,
  `x_zip` varchar(20) DEFAULT NULL,
  `x_country` varchar(60) DEFAULT NULL,
  `x_phone` varchar(25) DEFAULT NULL,
  `x_fax` varchar(25) DEFAULT NULL,
  `x_email` varchar(255) DEFAULT NULL,
  `x_ship_to_first_name` varchar(50) DEFAULT NULL,
  `x_ship_to_last_name` varchar(50) DEFAULT NULL,
  `x_ship_to_company` varchar(50) DEFAULT NULL,
  `x_ship_to_address` varchar(60) DEFAULT NULL,
  `x_ship_to_city` varchar(40) DEFAULT NULL,
  `x_ship_to_state` varchar(50) DEFAULT NULL,
  `x_ship_to_zip` varchar(20) DEFAULT NULL,
  `x_ship_to_country` varchar(60) DEFAULT NULL,
  `x_tax` float DEFAULT NULL,
  `x_duty` float DEFAULT NULL,
  `x_freight` float DEFAULT NULL,
  `x_tax_exempt` varchar(10) DEFAULT NULL,
  `x_po_num` varchar(25) DEFAULT NULL,
  `x_MD5_Hash` varchar(50) DEFAULT NULL,
  `x_cvv2_resp_code` varchar(2) DEFAULT NULL,
  `x_cavv_response` varchar(2) DEFAULT NULL,
  `x_test_request` varchar(20) DEFAULT NULL,
  `entirepost` text,
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_authorize_return`
#



#
# Table structure for table `class_authorize_settings`
#

DROP TABLE IF EXISTS `class_authorize_settings`;
CREATE TABLE `class_authorize_settings` (
  `authorize_login` varchar(20) DEFAULT NULL,
  `authorize_tkey` varchar(30) DEFAULT NULL,
  `authorize_secret` varchar(30) DEFAULT NULL,
  `authorize_pay_title` varchar(128) DEFAULT NULL,
  `authorize_demo` tinyint(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_authorize_settings`
#

INSERT INTO class_authorize_settings VALUES ('', '', '', 'Classifieds Payment', '0');


#
# Table structure for table `class_badwords`
#

DROP TABLE IF EXISTS `class_badwords`;
CREATE TABLE `class_badwords` (
  `word` varchar(50) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_badwords`
#



#
# Table structure for table `class_banners`
#

DROP TABLE IF EXISTS `class_banners`;
CREATE TABLE `class_banners` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `filename` varchar(128) DEFAULT NULL,
  `title` varchar(128) DEFAULT NULL,
  `code` text,
  `position` varchar(30) DEFAULT NULL,
  `sections` varchar(250) DEFAULT NULL,
  `link` varchar(128) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `date_start` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `max_impressions` int(11) NOT NULL DEFAULT '0',
  `max_clicks` int(11) NOT NULL DEFAULT '0',
  `impressions` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `categories` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_position` (`position`),
  KEY `idx_date_start` (`date_start`),
  KEY `idx_date_end` (`date_end`),
  KEY `idx_max_impressions` (`max_impressions`),
  KEY `idx_max_clicks` (`max_clicks`),
  KEY `idx_impressions` (`impressions`),
  KEY `idx_clicks` (`clicks`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_banners`
#

INSERT INTO class_banners VALUES ('3', '', 'Adsesne Firspage 1', '<script async src=\"//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js\"></script>\r\n<!-- firspage weltcars -->\r\n<ins class=\"adsbygoogle\"\r\n     style=\"display:block\"\r\n     data-ad-client=\"ca-pub-6868554487628056\"\r\n     data-ad-slot=\"9795199325\"\r\n     data-ad-format=\"auto\"></ins>\r\n<script>\r\n(adsbygoogle = window.adsbygoogle || []).push({});\r\n</script>', 'firstpage1', '0', '', '2017-02-14 19:58:51', '', '', '0', '0', '1715', '0', '0');
INSERT INTO class_banners VALUES ('4', '', 'Footer adsense', '<script async src=\"//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js\"></script>\r\n<!-- Footer weltcars -->\r\n<ins class=\"adsbygoogle\"\r\n     style=\"display:block\"\r\n     data-ad-client=\"ca-pub-6868554487628056\"\r\n     data-ad-slot=\"2271932521\"\r\n     data-ad-format=\"auto\"></ins>\r\n<script>\r\n(adsbygoogle = window.adsbygoogle || []).push({});\r\n</script>', 'footer', '0', '', '2017-02-14 19:59:57', '', '', '0', '0', '1449521', '0', '0');
INSERT INTO class_banners VALUES ('5', '', 'Adsense details 1', '    <script async src=\"//pagead2.googlesyndication.com/pagead/js/adsbygoogle.js\"></script>\r\n<!-- details1 weltcars -->\r\n<ins class=\"adsbygoogle\"\r\n     style=\"display:block\"\r\n     data-ad-client=\"ca-pub-6868554487628056\"\r\n     data-ad-slot=\"6422930526\"\r\n     data-ad-format=\"auto\"></ins>\r\n<script>\r\n(adsbygoogle = window.adsbygoogle || []).push({});\r\n</script>', 'details1', '0', '', '2017-02-14 20:15:43', '', '', '0', '0', '1146', '0', '0');


#
# Table structure for table `class_banners_positions`
#

DROP TABLE IF EXISTS `class_banners_positions`;
CREATE TABLE `class_banners_positions` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) DEFAULT NULL,
  `specific_section` tinyint(1) DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `no_banners` int(2) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_active` (`active`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_banners_positions`
#

INSERT INTO class_banners_positions VALUES ('1', 'header', '0', '1', '1');
INSERT INTO class_banners_positions VALUES ('2', 'footer', '0', '1', '1');
INSERT INTO class_banners_positions VALUES ('3', 'left', '0', '1', '1');
INSERT INTO class_banners_positions VALUES ('4', 'right', '0', '1', '1');
INSERT INTO class_banners_positions VALUES ('5', 'details1', '1', '1', '1');
INSERT INTO class_banners_positions VALUES ('6', 'details2', '1', '1', '1');
INSERT INTO class_banners_positions VALUES ('7', 'details3', '1', '0', '1');
INSERT INTO class_banners_positions VALUES ('8', 'details4', '1', '0', '1');
INSERT INTO class_banners_positions VALUES ('9', 'firstpage1', '1', '1', '1');
INSERT INTO class_banners_positions VALUES ('10', 'firstpage2', '1', '1', '1');
INSERT INTO class_banners_positions VALUES ('11', 'firstpage3', '1', '1', '1');
INSERT INTO class_banners_positions VALUES ('12', 'firstpage4', '1', '1', '1');
INSERT INTO class_banners_positions VALUES ('13', 'listings1', '1', '1', '1');
INSERT INTO class_banners_positions VALUES ('14', 'listings2', '1', '1', '1');
INSERT INTO class_banners_positions VALUES ('15', 'listings3', '1', '1', '1');
INSERT INTO class_banners_positions VALUES ('16', 'listings4', '1', '1', '1');
INSERT INTO class_banners_positions VALUES ('17', 'footer-mobile', '0', '1', '1');
INSERT INTO class_banners_positions VALUES ('18', 'background', '0', '1', '1');
INSERT INTO class_banners_positions VALUES ('19', 'header-mobile', '0', '0', '1');


#
# Table structure for table `class_bids`
#

DROP TABLE IF EXISTS `class_bids`;
CREATE TABLE `class_bids` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `aid` int(10) NOT NULL,
  `user_id` int(10) NOT NULL,
  `bid` double NOT NULL,
  `unit_bid` double DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `date` datetime NOT NULL,
  `message` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_bids`
#



#
# Table structure for table `class_blocked_emails`
#

DROP TABLE IF EXISTS `class_blocked_emails`;
CREATE TABLE `class_blocked_emails` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `email` varchar(64) DEFAULT NULL,
  `info` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_blocked_emails`
#



#
# Table structure for table `class_blocked_ips`
#

DROP TABLE IF EXISTS `class_blocked_ips`;
CREATE TABLE `class_blocked_ips` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `ip` varchar(15) DEFAULT NULL,
  `type` tinyint(1) DEFAULT '1',
  `date_expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `blocked_for` int(2) DEFAULT NULL,
  `info` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_blocked_ips`
#



#
# Table structure for table `class_blocked_phones`
#

DROP TABLE IF EXISTS `class_blocked_phones`;
CREATE TABLE `class_blocked_phones` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `phone` varchar(64) DEFAULT NULL,
  `info` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_blocked_phones`
#



#
# Table structure for table `class_browse_location`
#

DROP TABLE IF EXISTS `class_browse_location`;
CREATE TABLE `class_browse_location` (
  `title_ro` varchar(100) DEFAULT NULL,
  `no_rows` int(2) DEFAULT '3',
  `type` varchar(10) DEFAULT 'double',
  `field_id` int(4) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_browse_location`
#

INSERT INTO class_browse_location VALUES ('Cauta dupa locatie', '3', 'double', '6');


#
# Table structure for table `class_browse_make`
#

DROP TABLE IF EXISTS `class_browse_make`;
CREATE TABLE `class_browse_make` (
  `title_ro` varchar(100) DEFAULT NULL,
  `no_rows` int(2) DEFAULT '3',
  `type` varchar(10) DEFAULT 'double',
  `field_id` int(4) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_browse_make`
#

INSERT INTO class_browse_make VALUES ('Cautare dupa marca', '4', 'double', '3');


#
# Table structure for table `class_bulksms`
#

DROP TABLE IF EXISTS `class_bulksms`;
CREATE TABLE `class_bulksms` (
  `bulksms_username` varchar(50) DEFAULT NULL,
  `bulksms_password` varchar(50) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_bulksms`
#

INSERT INTO class_bulksms VALUES ('admin', 'admin#21#');


#
# Table structure for table `class_bulksms_log`
#

DROP TABLE IF EXISTS `class_bulksms_log`;
CREATE TABLE `class_bulksms_log` (
  `object_id` int(8) DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `success` tinyint(1) DEFAULT '0',
  `api_batch_id` varchar(50) DEFAULT NULL,
  `api_message` varchar(50) DEFAULT NULL,
  `api_status_code` varchar(20) DEFAULT NULL,
  `http_status_code` varchar(4) DEFAULT NULL,
  `details` text,
  `transient_error` varchar(20) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_bulksms_log`
#



#
# Table structure for table `class_categories`
#

DROP TABLE IF EXISTS `class_categories`;
CREATE TABLE `class_categories` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `picture` varchar(64) DEFAULT NULL,
  `icon` varchar(50) DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `fieldset` int(2) DEFAULT NULL,
  `order_no` int(5) DEFAULT NULL,
  `groups` varchar(250) NOT NULL DEFAULT '0',
  `ads` int(10) NOT NULL DEFAULT '0',
  `level` int(1) NOT NULL DEFAULT '1',
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_order` (`order_no`),
  KEY `idx_parent` (`parent_id`),
  KEY `idx_fieldset` (`fieldset`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_categories`
#

INSERT INTO class_categories VALUES ('10', 'motoatv.png', '', '0', '10', '4', '0', '0', '1', '1');
INSERT INTO class_categories VALUES ('9', 'camioane.png', '', '0', '9', '3', '0', '0', '1', '1');
INSERT INTO class_categories VALUES ('8', 'autoutilitare.jpg', '', '0', '8', '2', '0', '0', '1', '1');
INSERT INTO class_categories VALUES ('7', 'autoturisme.jpg', '', '0', '7', '1', '0', '32', '1', '1');
INSERT INTO class_categories VALUES ('11', 'remorci.png', '', '0', '11', '5', '0', '0', '1', '1');
INSERT INTO class_categories VALUES ('12', 'autobuse.png', '', '0', '12', '6', '0', '0', '1', '1');
INSERT INTO class_categories VALUES ('13', 'utilaje.png', '', '0', '13', '7', '0', '0', '1', '1');
INSERT INTO class_categories VALUES ('14', 'piese.png', '', '0', '14', '8', '0', '14', '1', '1');


#
# Table structure for table `class_categories_lang`
#

DROP TABLE IF EXISTS `class_categories_lang`;
CREATE TABLE `class_categories_lang` (
  `id` int(4) NOT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  `name` varchar(128) DEFAULT NULL,
  `description` text,
  `page_title` varchar(250) DEFAULT NULL,
  `meta_keywords` text,
  `meta_description` text,
  KEY `idx_id` (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_lang` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_categories_lang`
#

INSERT INTO class_categories_lang VALUES ('11', 'ro', 'Remorci si rulote', 'Anunturi remorci si rulote, anunturi vanzari si cumparari remorci si rulote!', 'Anunturi remorci si rulote', '', 'Anunturi remorci si rulote, anunturi vanzari si cumparari remorci si rulote!');
INSERT INTO class_categories_lang VALUES ('12', 'eng', 'Buses', 'Bus ads, buy and sell buses!', 'Bus ads', '', 'Bus ads, buy and sell buses!');
INSERT INTO class_categories_lang VALUES ('12', 'german', 'Busse', 'Bus-Anzeigen, kaufen und verkaufen Busse!', 'Bus-Anzeigen', '', 'Bus-Anzeigen, kaufen und verkaufen Busse!');
INSERT INTO class_categories_lang VALUES ('12', 'ro', 'Autobuse', 'Anunturi autobuse, vanzari si cumparari autobuse!', 'Anunturi autobuse', '', 'Anunturi autobuse, vanzari si cumparari autobuse!');
INSERT INTO class_categories_lang VALUES ('13', 'eng', 'Equipment', 'Construction and agro ads, buy and sell equipment!', 'Buy and sell construction and agro equipment', '', 'Construction and agro ads, buy and sell equipment!');
INSERT INTO class_categories_lang VALUES ('13', 'german', 'Maschinen', 'Bau- und Landanzeigen, Kauf und Verkauf von Ausrstung!', 'Kauf und Verkauf von Ausrstung', '', 'Bau- und Landanzeigen, Kauf und Verkauf von Ausrstung!');
INSERT INTO class_categories_lang VALUES ('13', 'ro', 'Utilaje', 'Anunturi utilaje constructii si agro, vanzari si cumparari utilaje!', 'Anunturi utilaje constructii si agro', '', 'Anunturi utilaje constructii si agro, vanzari si cumparari utilaje!');
INSERT INTO class_categories_lang VALUES ('14', 'eng', 'Auto parts', 'Ads for new and used auto parts, buy or sell new and used auto parts !', 'Ads for new and used auto parts', '', 'Ads for new and used auto parts, buy or sell new and used auto parts !');
INSERT INTO class_categories_lang VALUES ('14', 'german', 'Autoteile', 'Anzeigen fr neue und gebrauchte autoteile ,kaufen und verkaufen neue und gebrauchte autoteile!', 'Anzeigen fr neue und gebrauchte autoteile', '', 'Anzeigen fr neue und gebrauchte autoteile ,kaufen und verkaufen neue und gebrauchte autoteile!');
INSERT INTO class_categories_lang VALUES ('14', 'ro', 'Piese auto', 'Anunturi piese auto noi si second hand, vanzari si cumparari piese auto noi si second hand!', 'Anunturi piese auto noi si second hand', '', 'Anunturi piese auto noi si second hand, vanzari si cumparari piese auto noi si second hand!');
INSERT INTO class_categories_lang VALUES ('8', 'eng', 'Vans', 'Vans classifieds, vans buying and selling ads!', 'Vans classifieds', '', 'Vans classifieds, vans buying and selling ads!');
INSERT INTO class_categories_lang VALUES ('8', 'german', 'Lieferwagen', 'Ankndigungen Lieferwagen, Anzeige fur lieferwgen kaufen und verkaufen!', 'Ankndigungen Lieferwagen', '', 'Ankndigungen Lieferwagen, Anzeige fur lieferwgen kaufen und verkaufen!');
INSERT INTO class_categories_lang VALUES ('8', 'ro', 'Autoutilitare', 'Anunturi autoutilitare, anunturi vanzari si cumparari autoutilitare!', 'Anunturi autoutilitare', '', 'Anunturi autoutilitare, anunturi vanzari si cumparari autoutilitare!');
INSERT INTO class_categories_lang VALUES ('9', 'eng', 'Trucks', 'Trucks classifieds, buying and selling trucks ads!', 'Trucks classifieds', '', 'Trucks classifieds, buying and selling trucks ads!');
INSERT INTO class_categories_lang VALUES ('9', 'german', 'LKW\'s', 'Ankndigungen LKW, Anzeigen fur kaufen und verkaufen LKW\'s!', 'Ankndigungen LKW', '', 'Ankndigungen LKW, Anzeigen fur kaufen und verkaufen LKW\'s!');
INSERT INTO class_categories_lang VALUES ('9', 'ro', 'Camioane', 'Anunturi camioane, anunturi vanzari si cumparari camioane!', 'Anunturi camioane', '', 'Anunturi camioane, anunturi vanzari si cumparari camioane!');
INSERT INTO class_categories_lang VALUES ('10', 'eng', 'Moto & ATV', 'Ads motorcycles and ATVs, motorcycles and ATVs buying and selling ads!', 'Ads motorcycles and ATVs', '', 'Ads motorcycles and ATVs, motorcycles and ATVs buying and selling ads!');
INSERT INTO class_categories_lang VALUES ('10', 'german', 'Moto & ATV', 'Anzeigen Motorrder und Quads, Anzeigen fur kaufen und verkaufen Motorrder un Quads !', 'Anzeigen Motorrder und Quads', '', 'Anzeigen Motorrder und Quads, Anzeigen fur kaufen und verkaufen Motorrder un Quads !');
INSERT INTO class_categories_lang VALUES ('10', 'ro', 'Moto & ATV', 'Anunturi pentru motociclete si ATV, anunturi vanzari si cumparari motociclete si ATVuri!', 'Anunturi pentru motociclete si ATV', '', 'Anunturi pentru motociclete si ATV, anunturi vanzari si cumparari motociclete si ATVuri!');
INSERT INTO class_categories_lang VALUES ('11', 'eng', 'Trailers and caravans', 'Trailers and caravans ads, buy and sell ads trailers and caravans!', 'Trailers and caravans ads', '', 'Trailers and caravans ads, buy and sell ads trailers and caravans!');
INSERT INTO class_categories_lang VALUES ('11', 'german', 'Anhnger und Wohnwagen', 'Anhnger und Wohnwagen -Anzeigen, kaufen und verkaufen Anhnger und Wohnwagen anzeige!', 'Anhnger und Wohnwagen -Anzeigen', '', 'Anhnger und Wohnwagen -Anzeigen, kaufen und verkaufen Anhnger und Wohnwagen anzeige!');
INSERT INTO class_categories_lang VALUES ('7', 'eng', 'Cars', 'Classifieds cars, car buying and selling ads!', 'Classifieds cars', '', 'Classifieds cars, car buying and selling ads!');
INSERT INTO class_categories_lang VALUES ('7', 'german', 'Autos', 'Kleinanzeigen Autos,Anzeigen fur kaufen und verkaufen autos!', 'Kleinanzeigen Autos', '', 'Kleinanzeigen Autos,Anzeigen fur kaufen und verkaufen autos!');
INSERT INTO class_categories_lang VALUES ('7', 'ro', 'Autoturisme', 'Anunturi autoturisme, anunturi vanzare si cumparare autoturisme!', 'Anunturi autoturisme', '', 'Anunturi autoturisme, anunturi vanzare si cumparare autoturisme!');


#
# Table structure for table `class_categories_no_ads`
#

DROP TABLE IF EXISTS `class_categories_no_ads`;
CREATE TABLE `class_categories_no_ads` (
  `category_id` int(4) NOT NULL,
  `field` varchar(40) NOT NULL,
  `val` varchar(64) NOT NULL,
  `no` int(10) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_categories_no_ads`
#



#
# Table structure for table `class_clickatell`
#

DROP TABLE IF EXISTS `class_clickatell`;
CREATE TABLE `class_clickatell` (
  `clickatell_username` varchar(50) DEFAULT NULL,
  `clickatell_password` varchar(50) DEFAULT NULL,
  `clickatell_api_id` varchar(30) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_clickatell`
#

INSERT INTO class_clickatell VALUES ('', '', '');


#
# Table structure for table `class_clickatell_log`
#

DROP TABLE IF EXISTS `class_clickatell_log`;
CREATE TABLE `class_clickatell_log` (
  `object_id` int(8) DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `success` tinyint(1) DEFAULT '0',
  `message_id` varchar(30) DEFAULT NULL,
  `error_code` varchar(10) DEFAULT NULL,
  `error_string` varchar(200) DEFAULT NULL,
  `details` text,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_clickatell_log`
#



#
# Table structure for table `class_coupons`
#

DROP TABLE IF EXISTS `class_coupons`;
CREATE TABLE `class_coupons` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `code` varchar(40) DEFAULT '',
  `type` varchar(20) DEFAULT 'fixed',
  `discount` double DEFAULT NULL,
  `ads` tinyint(1) DEFAULT '1',
  `store` tinyint(1) DEFAULT '1',
  `groups` varchar(30) DEFAULT '0',
  `allow` int(3) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_coupons`
#

INSERT INTO class_coupons VALUES ('1', 'ADMIN112', 'percent', '100', '1', '1', '-1', '0');
INSERT INTO class_coupons VALUES ('2', 'L2017', 'percent', '100', '1', '1', '-1', '0');


#
# Table structure for table `class_credits_packages`
#

DROP TABLE IF EXISTS `class_credits_packages`;
CREATE TABLE `class_credits_packages` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `no_credits` int(6) NOT NULL,
  `price` double DEFAULT NULL,
  `groups` varchar(250) DEFAULT '0',
  `order_no` int(5) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_credits_packages`
#

INSERT INTO class_credits_packages VALUES ('1', '10', '5', '0', '1');
INSERT INTO class_credits_packages VALUES ('2', '20', '10', '0', '2');
INSERT INTO class_credits_packages VALUES ('3', '50', '15', '0', '3');


#
# Table structure for table `class_credits_packages_lang`
#

DROP TABLE IF EXISTS `class_credits_packages_lang`;
CREATE TABLE `class_credits_packages_lang` (
  `id` int(2) NOT NULL,
  `lang_id` varchar(20) DEFAULT NULL,
  `name` varchar(200) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_credits_packages_lang`
#

INSERT INTO class_credits_packages_lang VALUES ('1', 'ro', '10 Credits');
INSERT INTO class_credits_packages_lang VALUES ('2', 'ro', '20 credite');
INSERT INTO class_credits_packages_lang VALUES ('3', 'ro', '50 credite');


#
# Table structure for table `class_credits_return`
#

DROP TABLE IF EXISTS `class_credits_return`;
CREATE TABLE `class_credits_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_credits_return`
#



#
# Table structure for table `class_credits_settings`
#

DROP TABLE IF EXISTS `class_credits_settings`;
CREATE TABLE `class_credits_settings` (
  `unit` double DEFAULT NULL,
  `groups` varchar(250) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_credits_settings`
#

INSERT INTO class_credits_settings VALUES ('1', '0');


#
# Table structure for table `class_currencies`
#

DROP TABLE IF EXISTS `class_currencies`;
CREATE TABLE `class_currencies` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `currency` varchar(16) DEFAULT NULL,
  `order_no` int(4) DEFAULT '1000',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_currencies`
#

INSERT INTO class_currencies VALUES ('1', '$', '3');
INSERT INTO class_currencies VALUES ('2', '', '2');
INSERT INTO class_currencies VALUES ('3', 'RON', '4');


#
# Table structure for table `class_custom_pages`
#

DROP TABLE IF EXISTS `class_custom_pages`;
CREATE TABLE `class_custom_pages` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `code` varchar(30) DEFAULT NULL,
  `type` tinyint(1) DEFAULT '1',
  `hreflink` varchar(200) DEFAULT NULL,
  `navlink` tinyint(1) DEFAULT '1',
  `blank` tinyint(1) DEFAULT '0',
  `parent_id` int(11) DEFAULT '0',
  `active` tinyint(1) DEFAULT '1',
  `read_only` tinyint(1) DEFAULT '0',
  `order_no` int(5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_active` (`active`),
  KEY `idx_type` (`type`),
  KEY `idx_order_no` (`order_no`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_custom_pages`
#

INSERT INTO class_custom_pages VALUES ('1', '', '1', '', '0', '0', '0', '1', '1', '1');
INSERT INTO class_custom_pages VALUES ('2', '', '1', '', '2', '0', '0', '1', '1', '2');
INSERT INTO class_custom_pages VALUES ('3', '', '1', '', '0', '0', '0', '0', '1', '3');
INSERT INTO class_custom_pages VALUES ('4', '', '1', '', '2', '0', '0', '1', '0', '4');
INSERT INTO class_custom_pages VALUES ('5', 'eu_cookie', '1', '', '0', '0', '0', '1', '1', '0');
INSERT INTO class_custom_pages VALUES ('6', '', '1', '', '1', '0', '0', '1', '0', '5');
INSERT INTO class_custom_pages VALUES ('7', '', '1', '', '1', '0', '0', '1', '0', '6');


#
# Table structure for table `class_custom_pages_lang`
#

DROP TABLE IF EXISTS `class_custom_pages_lang`;
CREATE TABLE `class_custom_pages_lang` (
  `id` int(3) NOT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  `title` varchar(128) DEFAULT NULL,
  `content` text,
  `meta_description` text,
  `meta_keywords` text,
  KEY `idx_id` (`id`),
  KEY `idx_lang_id` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_custom_pages_lang`
#

INSERT INTO class_custom_pages_lang VALUES ('1', 'eng', 'First Page Content', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('2', 'eng', 'Affiliates', '<p>Our affiliate program is a web-based program that compensates partner sites (&quot;affiliates&quot;) for generating sales.</p>\n\n<p>As an affiliate, you refer our site to other possible clients, and in return you receive a percentage of the revenue from the sale.<br />\nBecoming an Affiliate is easy and profitable. All you need to do is register on our site as an affiliate. You will receive an affiliate link which you can use to refer our site. The affiliate link contains an unique affiliate id which will be used to trace back to you the sales you generate.</p>\n\n<p>In order to get paid you will need to provide a PayPal account with your affiliate account. You can always login using your affiliate account and check your revenues and payments.</p>\n\n<p>Benefits include:</p>\n\n<ul>\n<li>X day cookie length</li>\n<li>Earn X% of each sale sale</li>\n<li>Free to join</li>\n</ul>\n\n<p>Join now for free as an affiliate for our site!</p>\n<div class=\"mt4 lfloat buttonwrapper space5\"><div class=\"button1-left\"><a href=\"register.php?group=2\"><span class=\"button1-right\">Register as an affiliate!</span></a></div></div><br/><br/>\n\n', '', '');
INSERT INTO class_custom_pages_lang VALUES ('3', 'eng', 'Bulk uploads help', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('1', 'esp', 'First Page Content', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('2', 'esp', 'Affiliates', '<p>Our affiliate program is a web-based program that compensates partner sites (&quot;affiliates&quot;) for generating sales.</p>\n\n<p>As an affiliate, you refer our site to other possible clients, and in return you receive a percentage of the revenue from the sale.<br />\nBecoming an Affiliate is easy and profitable. All you need to do is register on our site as an affiliate. You will receive an affiliate link which you can use to refer our site. The affiliate link contains an unique affiliate id which will be used to trace back to you the sales you generate.</p>\n\n<p>In order to get paid you will need to provide a PayPal account with your affiliate account. You can always login using your affiliate account and check your revenues and payments.</p>\n\n<p>Benefits include:</p>\n\n<ul>\n<li>X day cookie length</li>\n<li>Earn X% of each sale sale</li>\n<li>Free to join</li>\n</ul>\n\n<p>Join now for free as an affiliate for our site!</p>\n<div class=\"mt4 lfloat buttonwrapper space5\"><div class=\"button1-left\"><a href=\"register.php?group=2\"><span class=\"button1-right\">Register as an affiliate!</span></a></div></div><br/><br/>\n\n', '', '');
INSERT INTO class_custom_pages_lang VALUES ('3', 'esp', 'Bulk uploads help', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('1', 'french', 'First Page Content', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('2', 'french', 'Affiliates', '<p>Our affiliate program is a web-based program that compensates partner sites (&quot;affiliates&quot;) for generating sales.</p>\n\n<p>As an affiliate, you refer our site to other possible clients, and in return you receive a percentage of the revenue from the sale.<br />\nBecoming an Affiliate is easy and profitable. All you need to do is register on our site as an affiliate. You will receive an affiliate link which you can use to refer our site. The affiliate link contains an unique affiliate id which will be used to trace back to you the sales you generate.</p>\n\n<p>In order to get paid you will need to provide a PayPal account with your affiliate account. You can always login using your affiliate account and check your revenues and payments.</p>\n\n<p>Benefits include:</p>\n\n<ul>\n<li>X day cookie length</li>\n<li>Earn X% of each sale sale</li>\n<li>Free to join</li>\n</ul>\n\n<p>Join now for free as an affiliate for our site!</p>\n<div class=\"mt4 lfloat buttonwrapper space5\"><div class=\"button1-left\"><a href=\"register.php?group=2\"><span class=\"button1-right\">Register as an affiliate!</span></a></div></div><br/><br/>\n\n', '', '');
INSERT INTO class_custom_pages_lang VALUES ('3', 'french', 'Bulk uploads help', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('1', 'italian', 'First Page Content', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('2', 'italian', 'Affiliates', '<p>Our affiliate program is a web-based program that compensates partner sites (&quot;affiliates&quot;) for generating sales.</p>\n\n<p>As an affiliate, you refer our site to other possible clients, and in return you receive a percentage of the revenue from the sale.<br />\nBecoming an Affiliate is easy and profitable. All you need to do is register on our site as an affiliate. You will receive an affiliate link which you can use to refer our site. The affiliate link contains an unique affiliate id which will be used to trace back to you the sales you generate.</p>\n\n<p>In order to get paid you will need to provide a PayPal account with your affiliate account. You can always login using your affiliate account and check your revenues and payments.</p>\n\n<p>Benefits include:</p>\n\n<ul>\n<li>X day cookie length</li>\n<li>Earn X% of each sale sale</li>\n<li>Free to join</li>\n</ul>\n\n<p>Join now for free as an affiliate for our site!</p>\n<div class=\"mt4 lfloat buttonwrapper space5\"><div class=\"button1-left\"><a href=\"register.php?group=2\"><span class=\"button1-right\">Register as an affiliate!</span></a></div></div><br/><br/>\n\n', '', '');
INSERT INTO class_custom_pages_lang VALUES ('3', 'italian', 'Bulk uploads help', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('1', 'german', 'First Page Content', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('2', 'german', 'Affiliates', '<p>Our affiliate program is a web-based program that compensates partner sites (&quot;affiliates&quot;) for generating sales.</p>\n\n<p>As an affiliate, you refer our site to other possible clients, and in return you receive a percentage of the revenue from the sale.<br />\nBecoming an Affiliate is easy and profitable. All you need to do is register on our site as an affiliate. You will receive an affiliate link which you can use to refer our site. The affiliate link contains an unique affiliate id which will be used to trace back to you the sales you generate.</p>\n\n<p>In order to get paid you will need to provide a PayPal account with your affiliate account. You can always login using your affiliate account and check your revenues and payments.</p>\n\n<p>Benefits include:</p>\n\n<ul>\n<li>X day cookie length</li>\n<li>Earn X% of each sale sale</li>\n<li>Free to join</li>\n</ul>\n\n<p>Join now for free as an affiliate for our site!</p>\n<div class=\"mt4 lfloat buttonwrapper space5\"><div class=\"button1-left\"><a href=\"register.php?group=2\"><span class=\"button1-right\">Register as an affiliate!</span></a></div></div><br/><br/>\n\n', '', '');
INSERT INTO class_custom_pages_lang VALUES ('3', 'german', 'Bulk uploads help', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('1', 'ro', 'Weltcars - anunturi auto', '<h1 style=\"text-align: center;\"><span style=\"font-size:36px\"><strong>Site de anunturi auto online</strong></span></h1>\r\n', 'Site de anunturi auto gratuite online, piata auto din ROMANIA.', '');
INSERT INTO class_custom_pages_lang VALUES ('2', 'ro', 'Afiliaere', '<p>Programul&nbsp; nostru de afiliere este unul online unde partenerii nostrii (&quot;afiliatii&quot;) castiga prin generarea de vanzari in cadrul sielui.</p>\r\n\r\n<p>Ca si afiliat, ne trimiteti posibili clienti, iar in schimb dumneavoastr veti primii un procent din vanzari.<br />\r\nEste usor sa deveniti partener cu http://weltcars.com . Tot ce trebuie sa faceti este sa va inregistrati in cadrul siteului ca afiliat. O sa primiti un link prin care trebuie sa trimiteti cat mai multe persoane catre siteul nostru. Link-ul de afiliat este unic si contine id-ul contului dumneavoastra pentru a putea urmarii vanzarile.</p>\r\n\r\n<p><strong>TOATE CONTURILE DE AFILIAT VOR FI VERIFICATE DE UN ADIMINSTRATOR!</strong></p>\r\n\r\n<p>Pentru a putea sa va ridicati castigurile trebuie sa furnizati un cont de PayPal. Puteti oricand sa va autentificati pentru a verifica castigurile si platile.</p>\r\n\r\n<p>Beneficii:</p>\r\n\r\n<ul>\r\n\t<li>durata cookie 180</li>\r\n\t<li>Comision de 50%/vanzare</li>\r\n\t<li>Inscriere GRATUITA</li>\r\n\t<li>Plati la fiecare 30 de zile in limita a minimum 25 euro</li>\r\n</ul>\r\n\r\n<p>Inscriete acum ca si afliat al http://weltcars.com!</p>\r\n\r\n<div class=\"mt4 lfloat buttonwrapper space5\">\r\n<div class=\"button1-left\"><a href=\"register.php?group=2\">Inregistreaza-te acum ca si Afiliat!</a></div>\r\n</div>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n', 'Castiga acum cu weltcars.com .', 'afiliere weltcars, afiliati weltcars, castiga cu weltcars');
INSERT INTO class_custom_pages_lang VALUES ('3', 'ro', 'Bulk uploads help', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('1', 'hr', 'First Page Content', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('2', 'hr', 'Affiliates', '<p>Our affiliate program is a web-based program that compensates partner sites (&quot;affiliates&quot;) for generating sales.</p>\n\n<p>As an affiliate, you refer our site to other possible clients, and in return you receive a percentage of the revenue from the sale.<br />\nBecoming an Affiliate is easy and profitable. All you need to do is register on our site as an affiliate. You will receive an affiliate link which you can use to refer our site. The affiliate link contains an unique affiliate id which will be used to trace back to you the sales you generate.</p>\n\n<p>In order to get paid you will need to provide a PayPal account with your affiliate account. You can always login using your affiliate account and check your revenues and payments.</p>\n\n<p>Benefits include:</p>\n\n<ul>\n<li>X day cookie length</li>\n<li>Earn X% of each sale sale</li>\n<li>Free to join</li>\n</ul>\n\n<p>Join now for free as an affiliate for our site!</p>\n<div class=\"mt4 lfloat buttonwrapper space5\"><div class=\"button1-left\"><a href=\"register.php?group=2\"><span class=\"button1-right\">Register as an affiliate!</span></a></div></div><br/><br/>\n\n', '', '');
INSERT INTO class_custom_pages_lang VALUES ('3', 'hr', 'Bulk uploads help', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('1', 'hu', 'First Page Content', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('2', 'hu', 'Affiliates', '<p>Our affiliate program is a web-based program that compensates partner sites (&quot;affiliates&quot;) for generating sales.</p>\n\n<p>As an affiliate, you refer our site to other possible clients, and in return you receive a percentage of the revenue from the sale.<br />\nBecoming an Affiliate is easy and profitable. All you need to do is register on our site as an affiliate. You will receive an affiliate link which you can use to refer our site. The affiliate link contains an unique affiliate id which will be used to trace back to you the sales you generate.</p>\n\n<p>In order to get paid you will need to provide a PayPal account with your affiliate account. You can always login using your affiliate account and check your revenues and payments.</p>\n\n<p>Benefits include:</p>\n\n<ul>\n<li>X day cookie length</li>\n<li>Earn X% of each sale sale</li>\n<li>Free to join</li>\n</ul>\n\n<p>Join now for free as an affiliate for our site!</p>\n<div class=\"mt4 lfloat buttonwrapper space5\"><div class=\"button1-left\"><a href=\"register.php?group=2\"><span class=\"button1-right\">Register as an affiliate!</span></a></div></div><br/><br/>\n\n', '', '');
INSERT INTO class_custom_pages_lang VALUES ('3', 'hu', 'Bulk uploads help', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('1', 'bg', 'First Page Content', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('2', 'bg', 'Affiliates', '<p>Our affiliate program is a web-based program that compensates partner sites (&quot;affiliates&quot;) for generating sales.</p>\n\n<p>As an affiliate, you refer our site to other possible clients, and in return you receive a percentage of the revenue from the sale.<br />\nBecoming an Affiliate is easy and profitable. All you need to do is register on our site as an affiliate. You will receive an affiliate link which you can use to refer our site. The affiliate link contains an unique affiliate id which will be used to trace back to you the sales you generate.</p>\n\n<p>In order to get paid you will need to provide a PayPal account with your affiliate account. You can always login using your affiliate account and check your revenues and payments.</p>\n\n<p>Benefits include:</p>\n\n<ul>\n<li>X day cookie length</li>\n<li>Earn X% of each sale sale</li>\n<li>Free to join</li>\n</ul>\n\n<p>Join now for free as an affiliate for our site!</p>\n<div class=\"mt4 lfloat buttonwrapper space5\"><div class=\"button1-left\"><a href=\"register.php?group=2\"><span class=\"button1-right\">Register as an affiliate!</span></a></div></div><br/><br/>\n\n', '', '');
INSERT INTO class_custom_pages_lang VALUES ('3', 'bg', 'Bulk uploads help', '', '', '');
INSERT INTO class_custom_pages_lang VALUES ('4', 'ro', 'Termeni si conditii', '<h1 style=\"text-align: center;\"><span style=\"font-family:comic sans ms,cursive\"><strong>TERMENI SI CONDITII</strong></span></h1>\r\n\r\n<p>Te rug?m s? acorzi pu?in? aten?ie acestor termeni ?i condi?ii, &icirc;ntruc&acirc;t serviciile site-ului weltcars.com pot fi oferite doar persoanelor care sunt de acord cu termenii ?i condi?iile expuse &icirc;n continuare.</p>\r\n\r\n<p><strong>1. Termeni folosi?i - explica?i pe &icirc;n?elesul tuturor</strong>:</p>\r\n\r\n<p>Site = pagina web <a href=\"https://www.weltcars.com\" target=\"_blank\">weltcars.com</a> (?i moderatoriii s?i), cu toate aplica?iile ?i sec?iunile acesteia</p>\r\n\r\n<p>Utilizator = orice persoan? fizic? ?i/sau juridic?, &icirc;n v&acirc;rst? de cel pu?in 18 ani, care acceseaz? site-ul weltcars.com</p>\r\n\r\n<p>Anun? = ofert? public? lansat? de un Utilizator prin care este prezent un vehicul cu scopul v&acirc;nz?rii &nbsp;</p>\r\n\r\n<p>V&acirc;nz?tor = Utilizatorul site-lui CarZZ.ro care ofer? spre v&acirc;nzare unul sau mai multe vehicule sau produse conexe</p>\r\n\r\n<p>Cump?r?tor = Utilizatorul site-ului weltcars.com care cump?r? unul sau mai multe vehicule afi?ate pe weltcars.com</p>\r\n\r\n<p>Vehicul = autoturism, motociclet?, autoutilitar?, autocamion sau orice alt tip de autovehicul.&nbsp;</p>\r\n\r\n<p>Moderatori = persoanele care verific? un Anun? &icirc;nainte ca acesta s? apar? pe site.</p>\r\n\r\n<p>Voucher = cupon reprezentand o suma care poate fi folosita in cadrul siteului weltcars.com</p>\r\n\r\n<p>Termeni ?i condi?ii = prezentul contract de utilizare</p>\r\n\r\n<p>Furnizor = societatea SC WELTGRAF SRL, societate pe ac?iuni constituit? ?i func?ion&acirc;nd &icirc;n conformitate cu legisla?ia din Rom&acirc;nia, cu sediul social &icirc;n Str. C. Coposu nr.37, Zalau, Salaj, la Oficiul Registrului Comer?ului de pe l&acirc;nga Tribunalul Salaj sub nr. J31/232/1999, av&acirc;nd Codul Unic de &Icirc;nregistrare RO12469710.</p>\r\n\r\n<p><strong>2. Acceptarea condi?iilor</strong></p>\r\n\r\n<p>Folosirea site-ului weltcars.com presupune acceptarea necondi?ionat? ?i &icirc;n totalitate a acestor Termeni ?i Condi?ii. Prin folosirea site-ului weltcars.com, se intelege at&acirc;t accesarea, vizitarea, &icirc;nregistrarea unui cont pe site, c&acirc;t ?i/sau folosirea serviciilor de publicare pe Site a anun?urilor pentru v&acirc;nzarea sau cump?rarea unui Vehicul. Te rug?m s? acorzi c&acirc;teva minute pentru a le citi. Ne rezerv?m dreptul de a modifica ?i actualiza aceast? pagin? &icirc;n orice moment. Pagina Termeni ?i condi?ii este disponibil? permanent ?i poate fi consultat? oric&acirc;nd.</p>\r\n\r\n<p>Orice Utilizator care acceseaz? site-ul weltcars.com ?i/sau care ofer? informa?ii cu caracter personal prin intermediul formularelor disponibile pe Site &icirc;?i d? consim??m&acirc;ntul ca datele sale s? fie colectate ?i prelucrate de catre Furnizor pentru prestarea &icirc;n condi?ii optime a serviciilor precum ?i &icirc;n scopuri de marketing, inclusiv marketing direct, cu respectarea ?i f?r? a fi prejudiciate drepturile persoanei vizate &icirc;n contextul prelucr?rii datelor cu caracter personal, respectiv informarea persoanei vizate, dreptul de acces la date, dreptul de interven?ie asupra datelor, dreptul de opozi?ie, dreptul de a nu fi supus unei decizii individuale ?i dreptul de a se adresa justi?iei. Totodat?, Utilizatorul are dreptul s? se opun? prelucr?rii datelor personale care &icirc;l privesc ?i s? solicite ?tergerea datelor. Pentru exercitarea oric?ruia dintre aceste drepturi, Utilizatorul se poate adresa cu o cerere scris? &icirc;n acest sens, datat? ?i semnat?, la urm?toarea adres?: C. Coposu nr.37, Zalau, Salaj. Autorit??ile pot solicita anumite informa?ii care pot conduce la identificarea unui Utilizator, conform prevederilor legale aplicabile.</p>\r\n\r\n<p><strong>3. Descrierea serviciilor oferite</strong></p>\r\n\r\n<p>Weltcars.com este un site de anun?uri online unde po?i publica anun?uri cu Vehicule de v&acirc;nzare sau po?i c?uta printre anun?urile publicate deja de c?tre al?i Utilizatori.</p>\r\n\r\n<p><strong>3.1. Ad?ugarea unui anun?</strong></p>\r\n\r\n<p>Noi, echipa proiectului weltcars.com, ne dorim ca toate Anun?urile publicate s? fie scrise corect ?i s? fie conforme cu realitatea. Datorit? acestui motiv, aprobarea anun?urilor nu se face instantaneu, acestea fiind verificate de o echip? specializat? care are dreptul de a le corecta ?i publica ulterior acestor verific?ri, sau dup? caz, corecturi. Te rug?m s? acorzi aten?ie ?i s? ?ii cont de Regulile de postare ale unui Anun? (sec?iunea 6), &icirc;ntruc&acirc;t ne rezerv?m dreptul de a respinge ?i/sau ?terge anun?urile care nu respect? aceste reguli.</p>\r\n\r\n<p>Pentru a ad?uga un Anun? trebuie s? completezi formularul care se deschide la click pe butonul de &rdquo;<a href=\"https://weltcars.com/pre-submit.html\" target=\"_blank\">Adaug? un anun?</a>&rdquo;. Te rug?m s? completezi date reale de contact, astfel &icirc;nc&acirc;t s? po?i fi contactat de Cump?r?tori sau de utilizatorii care doresc mai multe informa?ii despre autoturismul, vehicului sau piesele oferite de tine.&nbsp;Num?rul maxim de anun?uri care poate fi publicat pe site-ul weltcars.com de pe aceea?i adres? de e-mail este infinit.</p>\r\n\r\n<p>Prin trimiterea anun?ului spre publicare c?tre Site, declari c? e?ti de acord &icirc;n totalitate ?i necondi?ionat cu toate clauzele prezentului document.</p>\r\n\r\n<p>Perioada de valabilitate a unui Anun? este de 30 de zile, cu posibilitatea de a prelungi acest termen ?i de a re&icirc;nnoi gratuit anun?ul t?u dupa acest interva. Prin re&icirc;nnoire, anun?ul t?u va reveni la &icirc;nceputul listei cu anun?uri ?i va beneficia de acela?i grad de vizibilitate precum publicarea sa ini?ial?.</p>\r\n\r\n<p><strong>3.2. Promovarea anunturilor pe weltcars.com</strong></p>\r\n\r\n<ul>\r\n\t<li>Anunt promovat - anunt care va aparea pe prima pagina pe toata perioada in lista de anunturi recomandata</li>\r\n\t<li>Anunt evidentiat - acest tip de anunt este evidentiat in listele cu anunturi de pe site, atat in listele de categorii sau de locatii precum si in listele de cautari.</li>\r\n\t<li>Anunt cu prioritate - aceste anunturi au prioritate in fata celorlalte anunturi in toate listele si metodele posibile, sunt trei prioritati si le enumeram in ordinea prioritatii acestora: silver, gold, platinum.</li>\r\n</ul>\r\n\r\n<p><strong>Metode de plata acceptate </strong></p>\r\n\r\n<p>Metodele de plat? disponibile sunt: Card de debit/credit (accept?m Visa, Visa Electron, Mastercard, Maestro), plata din contul weltcars.com (aceasta nu este disponibil? &icirc;n cazul &icirc;n care soldul creditului este zero).&nbsp;Toate platile se fac prin paypal.</p>\r\n\r\n<p>Un Utilizator poate alege s? &icirc;?i promoveze contra cost unul sau mai multe anun?uri. Acestea pot fi at&acirc;t anun?uri deja publicate pe site, c&acirc;t ?i anun?uri nou ad?ugate.</p>\r\n\r\n<p>Un anun? poate avea un singur produs de promovare la un moment dat. &Icirc;n cazul &icirc;n care un produs de promovare ?i-a atins scopul ?i produsul sau serviciul descris &icirc;n cadrul anun?ului a fost v&acirc;ndut, zilele r?mase nu se raporteaz? ?i nu pot fi utilizate pentru promovarea unui alt anun?. Asem?n?tor, &icirc;n cazul &icirc;n care dezactivezi un anun? pentru care ai ales un produs de promovare, zilele r?mase nu se raporteaz? ?i nu pot fi utilizate pentru promovarea unui alt anun?.</p>\r\n\r\n<p>&Icirc;n cazul &icirc;n care un anun? nou ad?ugat cu promovare nu respect? Reguile de utilizare ale Site-ului, acesta nu va fi publicat pe weltcars.com. Suma pl?tit? pentru promovarea anun?ului nu va fi restituit?, ci va fi restituita inapoi sub forma unui cod voucher reprezentand o reducere in cuantumul sumei platite.</p>\r\n\r\n<p>&Icirc;n cazul &icirc;n care un anun? deja afi?at pe weltcars.com este modificat ?i promovat &icirc;n acela?i timp,&nbsp;anun?ul va fi afi?at ca Promovat imediat, dar&nbsp;modific?rile vor fi verificate de moderatorii weltcars.com . Dac? modific?rile aduse nu vor fi aprobate de moderatorii Site-ului deoarece nu respect? Regulile de utilizare, anun?ul va r?m&acirc;ne afi?at ca Promovat, dar va publicat pe Site &icirc;n forma &icirc;n care a fost acceptat anterior modific?rii. Suma pl?tit? pentru promovarea acestuia nu va fi restituit? ?i nici nu va fi &icirc;nc?rcat? &icirc;n contul weltcars.com, &icirc;ntruc&acirc;t a fost deja folosit? pentru promovarea acelui anun?.</p>\r\n\r\n<p>&nbsp;Pre?urile pachetelor de promovare pe site-ul weltcars.com pot fi vizualizate oric&acirc;nd &icirc;n fi?ierul intitulat &rdquo;Pachete promovare weltcars.com&rdquo;, ata?at acesor Termeni ?i Condi?ii. &nbsp; &nbsp;</p>\r\n\r\n<p>Anun?urile pentru care un Utilizator a achizi?ionat un pachet de promovare vor fi afi?ate pe weltcars.com &icirc;n cel mai scurt timp posibil din punct de vedere tehnic. &Icirc;n cazul &icirc;n care un anun?, pentru care un Utilizator a achitat un pachet de promovare, nu poate fi afi?at pe Site &icirc;n 24 de ore dup? confirmarea pl??ii ?i moderare, din cauza unor motive tehnice sau oricare alte motive neprev?zute, suma pl?tit? pentru promovare nu se ramburseaz? ci va fi emis un voucher in cunatumul sumei. De asemenea, dac? un anun?, pentru care un Utilizator a achizi?ionat un pachet de promovare, nu este afi?at corespunz?tor pe weltcars.com din cauza unor motive tehnice, suma platit? de c?tre utilizator nu va fi rambursat?, ci va fi emis un voucher in cuantumul sumei.</p>\r\n\r\n<p>Dac?, din cauza unor motive tehnice, anun?ul nu este afi?at &icirc;n galeria cu Anun?uri Promovate pe toat? perioada, utilizatorul nu poate solicita rambursarea sumei aferente pachetului de promovare achizitionat sau a zilelor &icirc;n care anun?ul nu a fost afi?at &icirc;n galeria cu Anun?uri Promovate, &icirc;ntruc&acirc;t nu restituim sumele &icirc;n bani, dar compens?m orice inadverten?e &icirc;ntre serviciul pl?tit ?i durata de afi?are a anun?ului promovat sub forma de vouchere in cunatumul sumelor, &icirc;n func?ie de situa?ia neprev?zut? ap?rut?. Vouchere pot fi folosite in cadrul site-ului weltcars.com.</p>\r\n\r\n<p>Un Utilizator poate achizi?iona concomitent toate tipurile de promovare oferite de weltcars.com pentru un anunt postat.</p>\r\n\r\n<p>&nbsp;3.4 Op?iunea &rdquo;&Icirc;nc?rcare credit&rdquo; &icirc;n contul weltcars.com</p>\r\n\r\n<p>Utilizatorul are posibilitatea de a-?i &icirc;nc?rca sume prestabilite&nbsp;&icirc;n contul pe site-ul weltcars.com, sub form? de credit pe site. Prin sume prestabilite ne vom referi de acum &icirc;ncolo la &rdquo;pachete de credite&rdquo;. Creditul ob?inut &icirc;n urma achizi?ion?rii oric?rui pachet de credite va putea fi folosit pentru promovarea anun?urilor active pe site-ul weltcars.com, &icirc;n modul descris la punctul 3.2 &icirc;n ace?ti Termeni ?i Condi?ii.</p>\r\n\r\n<p>Un Utilizator poate achizi?iona unul sau mai multe pachete de credite cu scopul promov?rii anun?urilor sale pe site. Pachetele de credite sunt disponibile &icirc;n contul Utilizatorului pe site-ul weltcars.com &icirc;n sec?iunea Credite -&gt; Cumpara credite.</p>\r\n\r\n<p>Pachetele de credite vor fi afisate pentru achizitionare, fiecare pachet are un pret si un numar de credite oferit.</p>\r\n\r\n<p>Op?iunea &rdquo;Cumpara Credite&rdquo; nu este limitat? &icirc;n timp.&nbsp;Durata de valabilitate a creditului ob?inut &icirc;n urma achizi?ion?rii unuia sau mai multor pachete de credite este nelimitat?.</p>\r\n\r\n<p>Contravaloarea creditului sau a bonusului ob?inut &icirc;n urma achizi?ion?rii unuia sau mai multor pachete de credite nu poate fi restituit? sub form? de bani ?i nu poate fi transferat? de la un Utilizator la un altul sau &icirc;nafara site-ului weltcars.com.</p>\r\n\r\n<p><strong>4.</strong>&nbsp;<strong>Dreptul de autor</strong></p>\r\n\r\n<p>&Icirc;ntregul con?inut al paginii weltcars.com, prin con?inut &icirc;n?eleg&acirc;ndu-se imagini, texte, grafic?, inclusiv Anun?ul &icirc;n forma publicat? pe site pentru care V&acirc;nz?torul cedeaz? dreptul de utilizare, neexclusiv, &icirc;n favoarea Furnizorului, aplica?ii, link-uri ?i orice alt con?inut audio-vizual, c&acirc;t ?i design-ul grafic, codul surs? ?i orice alte date ?i informatii apar?in Site-ului, Furnizorului ?i afilia?ilor acestuia. Aceste informa?ii sunt protejate conform Legii drepturilor de autor ?i legilor care privesc dreptul de proprietate intelectual? ?i industrial?. Informa?iile publicate pe weltcars.com nu pot fi publicate, transmise, copiate prin orice metod? f?r? acordul scris al reprezentantului legal al Furnizorului. Nerespectarea acestor condi?ii se pedepse?te conform legii &icirc;n vigoare.</p>\r\n\r\n<p>Prin publicarea unui anun? pe site-ul weltcars.com tu afirmi, garantezi ?i sus?ii c? de?ii toate drepturile de autor pentru imagini, text ?i con?inut ?i nu &icirc;ncalci dreptul de proprietate intelectual? al unei ter?e p?r?i. Tu e?ti singurul r?spunz?tor pentru tot ceea ce postezi ?i de consecin?a public?rii unui Anun?.</p>\r\n\r\n<p>Public&acirc;nd anun?ul pe site-ul weltcars.com accep?i s? acorzi c?tre Furnizor o licen?? cu titlu gratuit, nelimitat? &icirc;n timp ?i irevocabil? prin care transmi?i c?tre Site toate drepturile asupra materialului postat. De asemenea, e?ti de acord ca Anun?urile publicate pe site-ulweltcars.com pot fi puse la dispozi?ia publicului de c?tre Furnizor pe toate ?i oricare dintre platformele sale on-line ?i prin oricare alte mijloace, precum: televiziune, radio, bannere, Internet, panouri publicitare sau comunicate de pres?.</p>\r\n\r\n<p><strong>5. Limitarea r?spunderii</strong></p>\r\n\r\n<p>Ne str?duim s? &icirc;?i oferim cel mai bun serviciu, dar nu &icirc;?i putem promite c? va fi perfect, drept urmare nu &icirc;?i putem oferi nici o garan?ie c? site-ul weltcars.com va fi disponibil ne&icirc;ntrerupt sau f?r? erori. &Icirc;n ceea ce prive?te materialele pe care le postezi pe weltcars.com, &icirc;?i reamintim c? tu e?ti direct r?spunz?tor de con?inutul ?i veridicitatea acestora. Furnizorul, site-ul weltcars.com ?i/sau moderatorii s?i nu garanteaz? &icirc;n nici un fel pentru disponibilitatea, calitatea sau cantitatea (sau oricare alte aspecte) produselor care fac obiectul Anun?urilor ?i nu &icirc;?i asum? nici un fel de r?spundere pentru veridicitatea Anun?urilor afi?ate pe weltcars.com. &Icirc;n niciun caz Furnizorul, site-ul weltcars.com ?i/sau moderatorii s?i nu vor fi r?spunz?tori pentru orice daune directe, indirecte, incidentale sau de consecin?ele ce rezult? din lipsa de acurate?e a con?inutului, erori, pierderi sau stric?ciuni de orice fel ap?rute &icirc;n urma folosirii oric?rui con?inut postat, transmis prin e-mail sau oricum altfel f?cut disponibil prin Site. De asemenea, Furnizorul, site-ul weltcars.com ?i/sau moderatorii s?i nu vor fi r?spunz?tori pentru activit??ile Utilizatorilor, &icirc;n special pentru furnizarea de con?inut sau date eronate &icirc;n ceea ce prive?te proprietatea care face obiectul unui Anun?.</p>\r\n\r\n<p>&Icirc;n cazul unui conflict, te rug?m sa ne contactezi ?i vom c?uta o rezolvare amiabil?, urm&acirc;nd &icirc;ndeaproape reglement?rile &icirc;n vigoare. &Icirc;n cazul agrav?rii conflictului ?i dac? rezolvarea amiabil? a e?uat, va fi necesar s? apel?m la instan?ele judec?tore?ti competente.</p>\r\n\r\n<p>Pentru siguran?a ta, &icirc;?i recomand?m s? verifici &icirc;ntotdeauna informa?ii legate de concursurile ?i campaniile organizate de noi pe pagina noastr? weltcars.com sau pe pagina oficial? de Facebook, <a href=\"https://www.facebook.com/weltcars/\" target=\"_blank\">Weltcars.com.</a></p>\r\n\r\n<p><strong>6. Reguli de postare ?i reguli de bun? conduit? pe site-ul weltcars.com</strong></p>\r\n\r\n<p>Pentru a crea un loc &icirc;n care toata lumea s? revin? cu pl?cere, fie c? este &icirc;n c?utarea ma?inii mult visate, fie c? are un autoturisml, tractor, pies? sau remorc? de v&acirc;nzare, Moderatorii site-ului weltcars.com vor &icirc;nl?tura anun?urile incomplete sau incorecte ?i pe acelea care nu respect? prevederile acestor Termeni ?i Condi?ii, a?adar, aprobarea anun?urilor <strong>nu</strong> se face automat ?i instantaneu. Pentru a evita o situa?ie nepl?cut? &icirc;n care un Anun? este respins, am creat c&acirc;teva reguli pe care te rug?m s? le ai &icirc;n vedere atunci c&acirc;nd adaugi un anun? pe weltcars.com:</p>\r\n\r\n<p>*** Pe weltcars.com sunt acceptate doar anun?urile care fac referire la: autoturisme, motociclete, atv, sctere, camioane, utilitare, ambarca?iuni, utilaje agricole, utilaje industriale, utilaje de construc?ii, piese utilaje agricole, piese utilaje industriale. &nbsp;Anun?urile care fac referire la oricare alt produs/serviciu vor fi respinse. Anun?urile cu con?inut ilegal, imoral sau care nu au leg?tur? cu tematica site-ului weltcars.com nu vor fi acceptate.</p>\r\n\r\n<p>*** Este permis? publicarea unui singur Anun? pentru acela?i Vehicul. Anun?urile care vor fi identificate ca fiind duble, vor fi respinse sau retrase ulterior de pe Site.</p>\r\n\r\n<p>*** Un Anun? este valabil pentru un singur Vehicul sau pies?; anun?urile care fac referire la mai multe Vehicule sau piese nu vor fi aprobate.</p>\r\n\r\n<p>*** Anun?ul publicat &icirc;ntr-un jude? este vizibil at&acirc;t &icirc;n toat? Rom&acirc;nia c&acirc;t ?i &icirc;n jude?ele vecine, de aceea nu este necesar? (?i nu va fi acceptat?) publicarea aceluia?i anun? &icirc;n mai multe jude?e.</p>\r\n\r\n<p>*** Te rug?m s? nu faci publice date cu caracter personal &icirc;n descrierea Anun?ului (serie ?i num?r carte identitate, CNP, cont bancar, etc) &nbsp;sau s? oferi ca date de contact numere de telefon cu supratax?, &icirc;ntruc&acirc;t aceste anun?uri nu vor fi acceptate.</p>\r\n\r\n<p>*** Te rug?m s? folose?ti majuscule numai acolo unde este necesar, adic? la &icirc;nceputul titlului ?i pentru numele unor m?rci/brand-uri. Titlurile scrise numai cu majuscule vor fi &icirc;nlocuite cu minuscule de c?tre moderatorii site-ului weltcars.com . De asemenea, vor fi eliminate din titlu cuvinte nerelevante pentru Vehiculul sau produsul comercializat (exemplu: v&acirc;nd, ofert?, urgent, etc.)</p>\r\n\r\n<p>*** Sunt acceptate doar Anun?uri prin care vinzi un Vehicul, nu ?i anun?urile de tip Cerere.</p>\r\n\r\n<p>*** Te rug?m s? publici anun?uri &icirc;n doar limba Rom&acirc;n? ?i s? folose?ti un limbaj corespunz?tor.</p>\r\n\r\n<p>*** Te rug?m s? nu adaugi link-uri c?tre alte website-uri &icirc;n descrierea anun?ului t?u, &icirc;ntruc&acirc;t moderatorii site-ului weltcars.com au dreptul de a le ?terge</p>\r\n\r\n<p>*** Anun?urile prin care utilizatorii site-ului weltcars.com s-ar putea sim?i discrimina?i pe criteriul rasei, na?ionalit??ii, limbii, religiei, sexului sau orient?rii sexuale, etniei, bolilor sau apartenen?ei la o categorie defavorizat?, nu vor fi publicate.</p>\r\n\r\n<p>*** Anun?urile care con?in pre?uri sau informa?ii care genereaz? confuzie sau sunt considerate neserioase de c?tre Furnizor (de exemplu, dar f?r? a se limita la: pre?uri de 1 euro sau pre?uri mult inferioare pie?ei ?i/sau statisticilor aflate la dispozi?ia Furnizorului) nu vor fi publicate.</p>\r\n\r\n<p>***Reguli referitoare la imagini:</p>\r\n\r\n<p>* Imaginile utilizate trebuie s? fie clare ?i s? reflecte starea actual? a Vehiculului;</p>\r\n\r\n<p>* Imaginile care nu au leg?tur? cu Vehicul vor fi ?terse de c?tre moderatorii weltcars.com iar anun?ul va fi publicat f?r? imagini;</p>\r\n\r\n<p>* Imaginile care con?in watermark-uri, sigle sau alte &icirc;nsemne ale altor website-uri concurente vor fi ?terse de c?tre moderatorii weltcars.com;</p>\r\n\r\n<p>* Imaginile utilizate trebuie s? nu aib? nicio restric?ie, fiind interzis? utilizarea unor imagini care sunt grevate de drepturi ale unor ter?i, &icirc;n special de drepturi de proprietate intelectual? ale unor ter?i.</p>\r\n\r\n<p><strong>7. Eligibilitatea, &icirc;nregistrarea ?i anularea</strong></p>\r\n\r\n<ul>\r\n\t<li>site-ul weltcars.com este destinat persoanelor fizice ?i/sau juridice cu v&acirc;rsta de cel pu?in 18 ani ?i capacitate deplin? de exerci?iu.</li>\r\n\t<li>Crearea unui cont pe site-ul weltcars.com poate fi f?cut? fie prin &icirc;nregistrarea cu contul Facebook (recomand?m acest mod de autentificare) sau folosind adresa de e-mail ?i o parol?. Prin &icirc;nregistrare, Utilizatorul confirm? c? are cel pu?in 18 ani. Datele profilului creat pe site-ul weltcars.com trebuie s? fie reale, complete ?i actualizate. Nu sunt permise &icirc;nregistr?ri multiple cu aceea?i adres? e-mail.</li>\r\n\t<li>Datele de autentificare sunt confiden?iale. &Icirc;?i recomand?m s? &icirc;?i iei m?suri de precau?ie ?i s? &icirc;?i alegi o parol? puternic?, pe care s? nu o dai nim?nui.</li>\r\n\t<li>&Icirc;n cazul &icirc;n care, din diverse motive, dore?ti s? renun?i la contul t?u gratuit pe site-ul weltcars.com, trimite-ne un e-mail pe adresa info@weltcars.com ?i &icirc;?i vom dezactiva contul, iar toate anun?urile tale vor fi retrase de pe Site. Dup? dezactivarea contului, putem p?stra, pentru o perioad? de 12 luni, informa?ii referitoare la con?inutul publicat de tine. &Icirc;n acest caz, conform politicii de confiden?ialitate ?i a protec?iei datelor cu caracter personal, Site-ul poate furniza detalii referitoare la un Anun? (indiferent de natura lor) numai organelor competente, &icirc;n urma unei solicit?ri oficiale primite din partea acestora.</li>\r\n\t<li>Dup? dezactivarea contului ?i retragerea tuturor anun?urilor de pe site, nu putem garanta eliminarea imediat? a rezultatelor de c?utare &icirc;n motoarele de c?utare. Indexarea motoarelor de c?utare este independent? de site-ul weltcars.com</li>\r\n\t<li>Ne rezerv?m dreptul de a ?terge sau edita orice Anun? care nu respect? Termenii ?i Condi?iile, &icirc;n orice mod. Te vom informa despre motivul modific?rii. De asemenea, ne rezerv?m dreptul de a bloca sau dezactiva un cont dac? primim raport?ri repetate referitoare la unul sau mai multe anun?uri care nu respect? cele men?ionate &icirc;n prezentul document, al c?ror con?inut nu este conform cu realitatea ori &icirc;ncalc? &icirc;n orice alt mod vreo prevedere legal? ?i poate aduce prejudicii securit??ii activit??ilor altor utilizatori ai site-ului weltcars.com.</li>\r\n</ul>\r\n', 'termeni si conditii utilizare si postare anunturi pe weltcars.com', 'termeni si conditii');
INSERT INTO class_custom_pages_lang VALUES ('5', 'ro', 'Politica cookie', '<p>Pentru ca siteul sa functioneze cat mai usor si mai bine, folosim cookie.</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<h3>Ce sunt cookie-urile?</h3>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Cookie este un fisier micut care se salveaza in computer sau mobil. Ajuta la salvarea datelor precum (date de autentificare, limbaj, marime font si alte preferinte de design) pentru o perioada de timp, astfel ca nu sunteti obligat sa faceti aceste schimbari de fiecare data cand vizitati site-ul weltcars.com .</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<h3>Cum folseste cookie weltcars.com ?</h3>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Site-ul weltcars foloseste cookie in special pentru setari de afisare:</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<ul>\r\n\t<li>limbaj implicit - o data ce ati selectat limbajul, acesta ramane neschimbat la fiecare vizita.</li>\r\n\t<li>date de autentificare - in cazul in care bifati &quot;Tine minte&quot; in pagina de autentificare. Datele de autetificare se salveaza in fisierul cookie.</li>\r\n\t<li>preferinta de a vizualiza varianta de mobil cand nu sunteti pe mobil si viceversa, varinta de desktop cand sunteti pe mobil.</li>\r\n\t<li>Anunturile pe care le adaugati pentru comparare</li>\r\n\t<li>modul in care sunt afisate anunturile (tabel sau lista)</li>\r\n\t<li>partenerul din partea caruia ati vizitat site-ul.</li>\r\n</ul>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Cum sa controlati cookie-urile</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Puteti <strong>controla sau sterge</strong> aceste cookie-uri - pentru detalii vizitati <u><a href=\"http://www.aboutcookies.org/\">aboutcookies.org</a></u>. Puteti sa stergeti toate cooki-urile create de siteuri pe desktop sau mobil sau puteti seta ca aceste cookie-uri sa nu se salveze. Dar daca faceti setari de genul, s-ar putea ca unele site-uri sa nu functioneze corect.</p>\r\n\r\n<p>&nbsp;\r\n<p>&nbsp;\r\n<p>&nbsp;</p>\r\n</p>\r\n</p>\r\n\r\n<p>&nbsp;</p>\r\n', 'Politica cookie weltcars.com', '');
INSERT INTO class_custom_pages_lang VALUES ('6', 'ro', 'Despre noi', '<h1 style=\"text-align: center;\"><u><strong>DESPRE NOI</strong></u></h1>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>Site-ul weltcars.com este un site de anunturi auto cu vechime de peste 7 ani pe piata auto online, incercam sa oferim utilizatoriilor solutii cat mai ieftine in vanzarea autovehiculelor si pieselor sau accesoriilor.</p>\r\n\r\n<p>Totul a inceput de la ideea de a oferii gratuitate pentru adaugarea de anunturi auto.</p>\r\n', 'Despre weltcars.com site de anunturi auto online.', 'despre noi, depsre weltcars.com, despre weltcars');
INSERT INTO class_custom_pages_lang VALUES ('7', 'ro', 'Parteneri', '<p>&nbsp;</p>\r\n<div align=\"center\">\r\n<table border=\"2\" cellpadding=\"10\" cellspacing=\"10\" style=\"width:500px\">\r\n\t<tbody>\r\n\t\t<tr>\r\n\t\t\t<td style=\"text-align: center;\"><a href=\"https://sellonline.ro\" target=\"_blank\"><img alt=\"SellOnline.ro - licitatii si magazine online\" src=\"https://sellonline.ro/uploads/logo2-(1).png\" style=\"height:114px; width:279px\" /></a></td>\r\n\t\t\t<td style=\"text-align: center;\"><a href=\"http://teparul.ro\" target=\"_blank\"><img alt=\"Teparul.ro - afla care sunt teparii din Romania\" src=\"https://teparul.ro/template/skin_1/style/logo.gif\" style=\"height:123px; width:139px\" /></a></td>\r\n\t\t\t<td style=\"text-align: center;\"><a href=\"http://costbenzina.ro\" target=\"_blank\"><img alt=\"Cost Benzina - calculeaza-ti costul combustibilului.\" src=\"http://www.costbenzina.ro/images/cost-benzina-logo.png\" style=\"height:50px; width:200px\" /></a></td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td style=\"text-align: center;\">&nbsp;</td>\r\n\t\t\t<td style=\"text-align: center;\">&nbsp;</td>\r\n\t\t\t<td style=\"text-align: center;\">&nbsp;</td>\r\n\t\t</tr>\r\n\t\t<tr>\r\n\t\t\t<td style=\"text-align: center;\">&nbsp;</td>\r\n\t\t\t<td style=\"text-align: center;\">&nbsp;</td>\r\n\t\t\t<td style=\"text-align: center;\">&nbsp;</td>\r\n\t\t</tr>\r\n\t</tbody>\r\n</table>\r\n</div>\r\n\r\n\r\n', 'Parteneri ai siteului weltcars.com', 'parteneri weltcars');


#
# Table structure for table `class_db_backup`
#

DROP TABLE IF EXISTS `class_db_backup`;
CREATE TABLE `class_db_backup` (
  `enabled` tinyint(1) DEFAULT '0',
  `backup_compress` varchar(10) DEFAULT '0',
  `backup_freq` varchar(30) DEFAULT NULL,
  `keep` int(2) DEFAULT NULL,
  `generated_last` datetime DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_db_backup`
#

INSERT INTO class_db_backup VALUES ('0', '0', 'weekly', '5', '0000-00-00 00:00:00');


#
# Table structure for table `class_dealers_page_settings`
#

DROP TABLE IF EXISTS `class_dealers_page_settings`;
CREATE TABLE `class_dealers_page_settings` (
  `all_with_store` tinyint(1) DEFAULT '1',
  `groups` varchar(20) DEFAULT NULL,
  `link_to_navbar` tinyint(1) DEFAULT '1',
  `link_name_ro` varchar(80) DEFAULT NULL,
  `logo_field` varchar(50) DEFAULT NULL,
  `name_field` varchar(50) DEFAULT 'contact_name',
  `details_fields` varchar(200) DEFAULT NULL,
  `group_on_categories` tinyint(1) DEFAULT '0',
  `category_field` varchar(40) DEFAULT NULL,
  `categories_on_row` tinyint(1) DEFAULT '3',
  `search_fields` varchar(200) DEFAULT NULL,
  `title_ro` varchar(200) DEFAULT NULL,
  `meta_keywords_ro` text,
  `meta_description_ro` text,
  `enable_map_search` tinyint(1) DEFAULT '0',
  `map_visible` tinyint(1) DEFAULT '0',
  `search_location_fields` varchar(100) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_dealers_page_settings`
#

INSERT INTO class_dealers_page_settings VALUES ('0', '3', '1', 'Dealeri auto', 'store_banner', 'contact_name', 'contact_name,address,phone,webpage', '0', '', '3', 'contact_name,address', '', '', '', '0', '0', '');


#
# Table structure for table `class_depending_fields`
#

DROP TABLE IF EXISTS `class_depending_fields`;
CREATE TABLE `class_depending_fields` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `no` int(1) DEFAULT '2',
  `caption1` varchar(64) DEFAULT NULL,
  `caption2` varchar(64) DEFAULT NULL,
  `caption3` varchar(64) DEFAULT NULL,
  `caption4` varchar(64) DEFAULT NULL,
  `table1` varchar(64) DEFAULT NULL,
  `table2` varchar(64) DEFAULT NULL,
  `table3` varchar(64) DEFAULT NULL,
  `table4` varchar(64) DEFAULT NULL,
  `required1` tinyint(1) DEFAULT NULL,
  `required2` tinyint(1) DEFAULT NULL,
  `required3` tinyint(1) DEFAULT NULL,
  `required4` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_depending_fields`
#

INSERT INTO class_depending_fields VALUES ('3', '2', 'marca', 'model', '', '', 'marca', 'model', '', '', '1', '1', '0', '0');
INSERT INTO class_depending_fields VALUES ('6', '2', 'tara', 'judet', '', '', 'tara', 'judet', '', '', '1', '1', '0', '0');


#
# Table structure for table `class_depending_fields_lang`
#

DROP TABLE IF EXISTS `class_depending_fields_lang`;
CREATE TABLE `class_depending_fields_lang` (
  `id` int(2) NOT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  `name1` varchar(64) DEFAULT NULL,
  `name2` varchar(64) DEFAULT NULL,
  `name3` varchar(64) DEFAULT NULL,
  `name4` varchar(64) DEFAULT NULL,
  `top_str1` varchar(64) DEFAULT NULL,
  `top_str2` varchar(64) DEFAULT NULL,
  `top_str3` varchar(64) DEFAULT NULL,
  `top_str4` varchar(64) DEFAULT NULL,
  `error_message1` text,
  `error_message2` text,
  `error_message3` text,
  `error_message4` text,
  KEY `idx_lang` (`lang_id`),
  KEY `idx_id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_depending_fields_lang`
#

INSERT INTO class_depending_fields_lang VALUES ('6', 'ro', 'Tara', 'Judet', '', '', '', '', '', '', 'Nu ati selectat tara', 'Nu ati selectat judetul', '', '');
INSERT INTO class_depending_fields_lang VALUES ('3', 'ro', 'Marca', 'Model', '', '', '', '', '', '', 'Nu ati selectat marca!', 'Nu ati selectat nici un model!', '', '');
INSERT INTO class_depending_fields_lang VALUES ('3', 'eng', 'Make', 'Model', '', '', '', '', '', '', 'You have not selected make!', 'You have not selected any model!', '', '');
INSERT INTO class_depending_fields_lang VALUES ('3', 'german', 'Marke', 'Modell', '', '', '', '', '', '', 'Sie haben nicht ausgewhlt Marke!', 'Sie haben kein Modell ausgewhlt!', '', '');


#
# Table structure for table `class_discounts`
#

DROP TABLE IF EXISTS `class_discounts`;
CREATE TABLE `class_discounts` (
  `object_id` int(2) NOT NULL,
  `type` varchar(10) DEFAULT 'ad',
  `code` varchar(40) DEFAULT '',
  `user_id` int(10) DEFAULT NULL,
  KEY `idx_user_id` (`user_id`),
  KEY `idx_code` (`code`),
  KEY `idx_type` (`type`),
  KEY `idx_object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_discounts`
#

INSERT INTO class_discounts VALUES ('5', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('6', 'newad', 'ADMIN112', '0');
INSERT INTO class_discounts VALUES ('7', 'newad', 'ADMIN112', '0');
INSERT INTO class_discounts VALUES ('8', 'newad', 'ADMIN112', '0');
INSERT INTO class_discounts VALUES ('9', 'newad', 'ADMIN112', '0');
INSERT INTO class_discounts VALUES ('10', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('11', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('12', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('13', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('14', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('15', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('16', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('17', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('18', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('19', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('20', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('21', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('22', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('23', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('24', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('25', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('26', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('27', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('28', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('29', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('30', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('31', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('32', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('33', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('34', 'newad', 'admin112', '0');
INSERT INTO class_discounts VALUES ('35', 'newad', 'admin112', '0');


#
# Table structure for table `class_email_alerts`
#

DROP TABLE IF EXISTS `class_email_alerts`;
CREATE TABLE `class_email_alerts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `search` text,
  `frequency` varchar(20) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `key` varchar(200) DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `idx_user_id` (`user_id`),
  KEY `email` (`email`),
  KEY `idx_last_check` (`last_check`),
  KEY `idx_active` (`active`),
  KEY `ip` (`ip`),
  KEY `frequency` (`frequency`),
  KEY `date_2` (`date`,`frequency`),
  KEY `active_2` (`active`,`date`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_email_alerts`
#



#
# Table structure for table `class_epay_return`
#

DROP TABLE IF EXISTS `class_epay_return`;
CREATE TABLE `class_epay_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `tid` int(20) DEFAULT NULL,
  `orderid` varchar(50) DEFAULT NULL,
  `amount` int(20) DEFAULT NULL,
  `cur` int(3) DEFAULT NULL,
  `eKey` varchar(50) DEFAULT NULL,
  `fraud` int(1) DEFAULT NULL,
  `transfee` int(10) DEFAULT NULL,
  `HTTP_COOKIE` varchar(50) DEFAULT NULL,
  `subscriptionid` int(30) DEFAULT NULL,
  `cardid` int(50) DEFAULT NULL,
  `entirepost` text,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_epay_return`
#



#
# Table structure for table `class_epay_settings`
#

DROP TABLE IF EXISTS `class_epay_settings`;
CREATE TABLE `class_epay_settings` (
  `epay_merchantnumber` int(20) DEFAULT NULL,
  `epay_language` int(2) DEFAULT '1',
  `epay_currency` int(4) DEFAULT '208',
  `epay_md5key` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_epay_settings`
#

INSERT INTO class_epay_settings VALUES ('0', '1', '208', '');


#
# Table structure for table `class_ev_settings`
#

DROP TABLE IF EXISTS `class_ev_settings`;
CREATE TABLE `class_ev_settings` (
  `no` int(2) DEFAULT '10'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_ev_settings`
#

INSERT INTO class_ev_settings VALUES ('45');


#
# Table structure for table `class_experttexting`
#

DROP TABLE IF EXISTS `class_experttexting`;
CREATE TABLE `class_experttexting` (
  `experttexting_username` varchar(50) DEFAULT NULL,
  `experttexting_password` varchar(50) DEFAULT NULL,
  `experttexting_api_key` varchar(30) DEFAULT NULL,
  `experttexting_from` varchar(30) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_experttexting`
#

INSERT INTO class_experttexting VALUES ('', '', '', '');


#
# Table structure for table `class_experttexting_log`
#

DROP TABLE IF EXISTS `class_experttexting_log`;
CREATE TABLE `class_experttexting_log` (
  `success` int(1) DEFAULT '1',
  `status` int(1) DEFAULT '0',
  `message_id` varchar(30) DEFAULT NULL,
  `price` double DEFAULT NULL,
  `error_message` varchar(200) DEFAULT NULL,
  `details` text,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_experttexting_log`
#



#
# Table structure for table `class_failed_attempts`
#

DROP TABLE IF EXISTS `class_failed_attempts`;
CREATE TABLE `class_failed_attempts` (
  `is_admin` tinyint(1) DEFAULT '0',
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip` varchar(15) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_failed_attempts`
#



#
# Table structure for table `class_favourites`
#

DROP TABLE IF EXISTS `class_favourites`;
CREATE TABLE `class_favourites` (
  `ad_id` int(10) NOT NULL,
  `user_id` int(4) NOT NULL,
  KEY `idx_ad_id` (`ad_id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_favourites`
#



#
# Table structure for table `class_fields`
#

DROP TABLE IF EXISTS `class_fields`;
CREATE TABLE `class_fields` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `fieldset` varchar(200) DEFAULT NULL,
  `caption` varchar(200) DEFAULT NULL,
  `type` varchar(20) DEFAULT 'textbox',
  `order_no` int(2) DEFAULT NULL,
  `is_numeric` tinyint(1) DEFAULT '0',
  `validation_type` varchar(100) DEFAULT NULL,
  `size` varchar(10) DEFAULT NULL,
  `min` int(10) DEFAULT NULL,
  `max` int(10) DEFAULT NULL,
  `required` tinyint(1) DEFAULT '0',
  `editable` tinyint(1) DEFAULT '1',
  `advanced_search` tinyint(1) DEFAULT NULL,
  `quick_search` tinyint(1) DEFAULT NULL,
  `search_type` tinyint(1) DEFAULT '1',
  `max_uploaded_size` double DEFAULT NULL,
  `extensions` varchar(100) DEFAULT NULL,
  `image_resize` varchar(20) DEFAULT NULL,
  `dep_id` int(4) DEFAULT NULL,
  `other_val` tinyint(1) DEFAULT '0',
  `read_only` tinyint(1) DEFAULT '0',
  `unique` tinyint(1) DEFAULT '0',
  `ext1` tinyint(1) DEFAULT '0',
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_active` (`active`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_fields`
#

INSERT INTO class_fields VALUES ('1', '0', 'price', 'price', '1', '1', 'price', '7', '0', '0', '1', '1', '1', '1', '2', '0', '0|.|,', '', '0', '0', '1', '0', '0', '1');
INSERT INTO class_fields VALUES ('26', '7', 'vin', 'textbox', '6', '0', '', '', '', '', '0', '1', '0', '0', '1', '', '', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('25', '7', 'rulaj', 'textbox', '5', '1', '', '7', '', '', '0', '1', '1', '0', '2', '', '0|.|,', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('30', '7', 'combustibil', 'radio_group', '9', '0', '', '', '', '', '1', '1', '0', '0', '1', '', '', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('28', '7', 'caroserie', 'menu', '7', '0', '', '', '', '', '0', '1', '1', '0', '1', '', '', '', '', '1', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('29', '7', 'culoare', 'menu', '8', '0', '', '', '', '', '0', '1', '1', '0', '3', '', '', '', '', '1', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('31', '0', 'tip_pret', 'radio', '2', '0', '', '', '', '', '0', '1', '1', '0', '1', '', '', '', '', '0', '0', '0', '0', '0');
INSERT INTO class_fields VALUES ('32', '7', 'cilindree', 'textbox', '10', '0', '', '', '3', '5', '1', '1', '1', '0', '1', '', '', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('33', '7', 'putere', 'textbox', '11', '1', '', '4', '2', '', '1', '1', '1', '0', '1', '', '0|.|,', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('34', '12,7,8,9,10,13', 'tractiune', 'menu', '13', '0', '', '', '', '', '1', '1', '1', '0', '1', '', '', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('35', '7', 'dotari_siguranta', 'checkbox_group', '16', '0', '', '', '', '', '0', '1', '0', '0', '1', '', '', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('36', '7', 'dotari_comfoty', 'checkbox_group', '17', '0', '', '', '', '', '0', '1', '0', '0', '1', '', '', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('37', '7', 'cutie_de_viteze', 'menu', '12', '0', '', '', '', '', '0', '1', '1', '0', '1', '', '', '', '', '1', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('38', '7', 'norma_poluare', 'menu', '14', '0', '', '', '', '', '0', '1', '1', '0', '1', '', '', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('39', '7', 'emisii_co2', 'textbox', '15', '1', '', '', '', '', '0', '1', '0', '0', '1', '', '0|.|,', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('23', '7', 'marcamodel', 'depending', '3', '0', '', '', '', '', '0', '1', '1', '1', '1', '', '', '', '3', '1', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('24', '7', 'anul_fabricatiei', 'menu', '4', '0', '', '', '', '', '1', '1', '1', '1', '1', '', '', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('40', '7', 'detalii_istoric', 'checkbox_group', '19', '0', '', '', '', '', '0', '1', '0', '0', '1', '', '', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('41', '7', 'design_si_performanta', 'checkbox_group', '18', '0', '', '', '', '', '0', '1', '0', '0', '1', '', '', '', '', '0', '0', '0', '0', '1');
INSERT INTO class_fields VALUES ('44', '0', 'tarajudet', 'depending', '20', '0', '', '', '', '', '0', '1', '1', '1', '1', '', '', '', '6', '0', '0', '0', '0', '1');


#
# Table structure for table `class_fields_lang`
#

DROP TABLE IF EXISTS `class_fields_lang`;
CREATE TABLE `class_fields_lang` (
  `id` int(3) NOT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  `name` varchar(64) DEFAULT NULL,
  `top_str` varchar(64) DEFAULT NULL,
  `error_message` text,
  `error_message2` text,
  `info_message` text,
  `default_val` text,
  `prefix` varchar(64) DEFAULT NULL,
  `postfix` varchar(64) DEFAULT NULL,
  `elements` text,
  `search_elements` text,
  `date_format` varchar(30) DEFAULT NULL,
  KEY `idx_name` (`name`),
  KEY `idx_lang` (`lang_id`),
  KEY `idx_id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_fields_lang`
#

INSERT INTO class_fields_lang VALUES ('1', 'eng', 'Price', '', 'Invalid price!', '', 'Please enter a correct price format(only numbers accepted)', '', '', '', '', '500|1500|2000|2500|3000|3500|4000|4500|5000|6000|7000|8000|9000|10000|12500|15000|17500|20000|25000|30000|40000|50000|75000|100000', '');
INSERT INTO class_fields_lang VALUES ('44', 'ro', 'Tara&Judet', '', '', '', 'Selectati Tara si judetul', '', '', '', '', '', '');
INSERT INTO class_fields_lang VALUES ('25', 'german', 'Kilometerstand', '', 'Sie haben nicht eingegeben Umsatz!', '', 'Geben Sie die Anzahl der gefahrenen Kilometer das Auto!', '', '', 'km', '', '0|100|500|1000|1500|2000|3000|5000|10000|25000|50000|75000|100000|120000|150000|200000|300000|500000', '');
INSERT INTO class_fields_lang VALUES ('1', 'esp', 'Price', '', 'Invalid price!', '', '', '', '', '', '', '500|1500|2000|2500|3000|3500|4000|4500|5000|6000|7000|8000|9000|10000|12500|15000|17500|20000|25000|30000|40000|50000|75000|100000', '');
INSERT INTO class_fields_lang VALUES ('38', 'ro', 'Norma Poluare', '', '', '', '', '', '', '', 'Non-Euro|Euro 1|Euro 2|Euro 3|Euro 4|Euro 5|Euro 6', '', '');
INSERT INTO class_fields_lang VALUES ('39', 'ro', 'Emisii CO2', '', 'Nu ati introdus emisiile co2!', '', '', '', '', 'g/km', '', '', '');
INSERT INTO class_fields_lang VALUES ('40', 'ro', 'Detalii istoric', '', '', '', '', '', '', '', 'Primul Proprietar|Inmatriculat|Fara accident in istoric|Carte Service|Masina de epoca|Tuning', '', '');
INSERT INTO class_fields_lang VALUES ('41', 'ro', 'Design si Performanta', '', '', '', '', '', '', '', 'Cip-tuning|Chit Sport|Jante Aliaj|Evacuare Sport|Interior Piele|Interior Velur|Tuning Audio|Vopsea speciala', '', '');
INSERT INTO class_fields_lang VALUES ('25', 'eng', 'Mileage', '', 'You have not entered turnover!', '', 'Enter the number of kilometers the car has!', '', '', 'km', '', '0|100|500|1000|1500|2000|3000|5000|10000|25000|50000|75000|100000|120000|150000|200000|300000|500000', '');
INSERT INTO class_fields_lang VALUES ('1', 'french', 'Price', '', 'Invalid price!', '', '', '', '', '', '', '500|1500|2000|2500|3000|3500|4000|4500|5000|6000|7000|8000|9000|10000|12500|15000|17500|20000|25000|30000|40000|50000|75000|100000', '');
INSERT INTO class_fields_lang VALUES ('37', 'ro', 'Cutie de viteze', '', '', '', '', '', '', '', 'Automata|Automata(CVT)|Automata(dublu ambreiaj)|Manuala|Semi-automata(secventiala)', '', '');
INSERT INTO class_fields_lang VALUES ('1', 'italian', 'Price', '', 'Invalid price!', '', '', '', '', '', '', '500|1500|2000|2500|3000|3500|4000|4500|5000|6000|7000|8000|9000|10000|12500|15000|17500|20000|25000|30000|40000|50000|75000|100000', '');
INSERT INTO class_fields_lang VALUES ('35', 'ro', 'Dotari Siguranta', '', '', '', '', '', '', '', 'ABS|Airbag-uri Frontale|Airbag-uri Laterale|Airbag genunchi sofer|Airbag-uri cortina|Airbag-uri laterale spate|Controlul stabilitatii(ESP)|Controlul tractiunii(ASR)|Alarma|Lane Assist|Side Assist|Distronic|Limitator de viteza', '', '');
INSERT INTO class_fields_lang VALUES ('36', 'ro', 'Dotari Comfort', '', '', '', '', '', '', '', 'Aer conditionat|Aer conditionat doua zone|Aer conditionat patru zone|CD-player|CD-changer|DVD-player|Computer de bord|Servodirectie|Inchidere Centralizata|Geamuri fata electrice|Geamuri spate electrice|Bluetooth|Camera parcare spate|Comenzi Volan|Faruri Xenon|Faruri Bi-Xenon|Faruri Led|Geamuri fumurii spate|Geamuri cu tenta|Head-up display|Incalzire auxiliara|Intrare auxiliara|Lumini de zi|Navigatie|Oglinzi electrice|Oglinda centrala electrocromatica|Oglinzi retrovizoare electrocromatice|Oglinzi incalzite|Parbriz incalzit|Pilot automat|Scaune fata incalzite|Scaune spate incalzite|Senzori parcare spate|Senzori parcare fata-spate|Suspensie reglabila|Trapa|Trapa panoramica|TV', '', '');
INSERT INTO class_fields_lang VALUES ('24', 'ro', 'Anul Fabricatiei', '', 'Nu ati selectat anul fabricatiei!', '', 'Selectati anul fabricatiei al autoturismului, acesta poate fi gasit in actele autoturismului.', '2016', '', '', '1960|1961|1962|1963|1964|1965|1966|1967|1968|1969|1970|1971|1972|1973|1974|1975|1976|1977|1978|1979|1980|1981|1982|1983|1984|1985|1986|1987|1988|1989|1990|1991|1992|1993|1994|1995|1996|1997|1998|1999|2000|2001|2002|2003|2004|2005|2006|2007|2008|2009|2010|2011|2012|2013|2015|2016', '', '');
INSERT INTO class_fields_lang VALUES ('1', 'german', 'Preis', '', 'Ungltiger Preis!', '', 'Bitte geben Sie ein korrektes Preisformat ein (nur zahlen akzeptiert)', '', '', '', '', '500|1500|2000|2500|3000|3500|4000|4500|5000|6000|7000|8000|9000|10000|12500|15000|17500|20000|25000|30000|40000|50000|75000|100000', '');
INSERT INTO class_fields_lang VALUES ('31', 'ro', 'Tip pret', '', '', '', '', '', '', '', 'Pret fara TVA|Eligibil Finantare|Predare Leasing', '', '');
INSERT INTO class_fields_lang VALUES ('32', 'eng', 'Cilindree', '', 'Cilindree', '', '', '', '', '', '', '', '');
INSERT INTO class_fields_lang VALUES ('32', 'german', 'Cilindree', '', 'Cilindree', '', '', '', '', '', '', '', '');
INSERT INTO class_fields_lang VALUES ('32', 'ro', 'Cilindree', '', 'Nu ati introdus Capacitatea cilindrica', '', 'Introduceti cilindreea motorului.', '', '', 'cmc', '', '', '');
INSERT INTO class_fields_lang VALUES ('33', 'ro', 'Putere', '', 'Nu ati introdus puterea motorului.', '', 'Puterea motorului in Cai putere(Cp).', '', '', '', '', '', '');
INSERT INTO class_fields_lang VALUES ('34', 'ro', 'Tractiune', '', 'Nu ati selectat tractiunea autoturismului.', '', 'Selectati tipul de tractiune pentru autoturism.', '', '', '', 'Tractiune fata|Tractiune Spate|Tractiune Integrala|Tractiune 4x4', '', '');
INSERT INTO class_fields_lang VALUES ('1', 'ro', 'Pret', '', 'Pret invalid!', '', 'Va rugam sa introducei un pret(numai cifre acceptat)', '', '', '', '', '500|1500|2000|2500|3000|3500|4000|4500|5000|6000|7000|8000|9000|10000|12500|15000|17500|20000|25000|30000|40000|50000|75000|100000', '');
INSERT INTO class_fields_lang VALUES ('29', 'eng', 'Color', '', '', '', 'Select the exterior color of the car!', '', '', '', 'White|Blue|Silver|Brown|Golden|Gray|Black|Red|Verdant|Beige', '', '');
INSERT INTO class_fields_lang VALUES ('29', 'german', 'Farbe', '', '', '', 'Whlen Sie die Auenfarbe des Autos!', '', '', '', 'Wei|Blau|Silber|Braun|Golden|Grau|Schwarz|Rot|Grn|Beige', '', '');
INSERT INTO class_fields_lang VALUES ('29', 'ro', 'Culoare', '', '', '', 'Selectati culoarea exterioara a autoturismului!', '', '', '', 'Alb|Albastru|Argintiu|Maro|Auriu|Gri|Negru|Rosu|Verde|Bej', '', '');
INSERT INTO class_fields_lang VALUES ('24', 'german', 'Baujahr', '', 'Sie haben nicht das Jahr der Herstellung ausgewhlt!', '', 'Whlen Baujahr des Autos, kann es in den Papieren des Autos zu finden.', '2016', '', '', '1960|1961|1962|1963|1964|1965|1966|1967|1968|1969|1970|1971|1972|1973|1974|1975|1976|1977|1978|1979|1980|1981|1982|1983|1984|1985|1986|1987|1988|1989|1990|1991|1992|1993|1994|1995|1996|1997|1998|1999|2000|2001|2002|2003|2004|2005|2006|2007|2008|2009|2010|2011|2012|2013|2015|2016', '', '');
INSERT INTO class_fields_lang VALUES ('1', 'hr', 'Price', '', 'Invalid price!', '', '', '', '', '', '', '500|1500|2000|2500|3000|3500|4000|4500|5000|6000|7000|8000|9000|10000|12500|15000|17500|20000|25000|30000|40000|50000|75000|100000', '');
INSERT INTO class_fields_lang VALUES ('30', 'eng', 'Fuel', '', 'You have not selected the fuel that runs the car!', '', '', '', '', '', 'Petrol|Diesel|Electric|Ethanol|Hybrid|Hydrogen', '', '');
INSERT INTO class_fields_lang VALUES ('30', 'german', 'Kraftstoff', '', 'Sie haben nicht den brennstoff ausgewhlt, die das auto luft!', '', '', '', '', '', 'Benzin|Diesel|Elektrisch|Ethanol|Hybrid|Wasserstoff', '', '');
INSERT INTO class_fields_lang VALUES ('28', 'eng', 'Body', '', 'You have not selected body type!', '', 'Select body type!', '', '', '', 'Limousine|Break|Cabrio|Coupe|Hatchback|Monovolum|Off-Road|Pick-Up|Suv|Minivan', '', '');
INSERT INTO class_fields_lang VALUES ('28', 'german', 'Karosserie', '', 'Sie haben keine Karosserietyp ausgewhlt!', '', 'Whlen sie karosserietyp!', '', '', '', 'Limousine|Break|Cabrio|Coupe|Hatchback|Monovolum|Off-Road|Pick-Up|Suv|Minivan', '', '');
INSERT INTO class_fields_lang VALUES ('28', 'ro', 'Caroserie', '', 'Nu ati selectat tipul caroseriei!', '', 'Selectati tipul caroseriei !', '', '', '', 'Berlina|Break|Cabrio|Coupe|Hatchback|Monovolum|Off-Road|Pick-Up|Suv|Minivan', '', '');
INSERT INTO class_fields_lang VALUES ('1', 'hu', 'Price', '', 'Invalid price!', '', '', '', '', '', '', '500|1500|2000|2500|3000|3500|4000|4500|5000|6000|7000|8000|9000|10000|12500|15000|17500|20000|25000|30000|40000|50000|75000|100000', '');
INSERT INTO class_fields_lang VALUES ('26', 'ro', 'VIN', '', '', '', 'Introduceti seria de sasiu a autoturismului, aceasta poate fi gasita in actele masinii.', '', '', '', '', '', '');
INSERT INTO class_fields_lang VALUES ('31', 'eng', 'Price type', '', '', '', '', '', '', '', 'Price without VAT|Financing eligible |Leasing', '', '');
INSERT INTO class_fields_lang VALUES ('31', 'german', 'Kursart', '', '', '', '', '', '', '', 'Preis ohne MwSt|Frderfhigen Finanzierung|Leasing', '', '');
INSERT INTO class_fields_lang VALUES ('30', 'ro', 'Combustibil', '', 'Nu ati selectat combustibilul pe care ruleaza autoturismul!', '', 'Selectati tipul de combustibil folosit de autoturism.', '', '', '', 'Benzina|Diesel|Benzina+GPL|Benzina+CNG|Electric|Etanol|Hibrid|Hidrogen', '', '');
INSERT INTO class_fields_lang VALUES ('24', 'eng', 'Manufacturing year', '', 'You have not selected the year of manufacture!', '', 'Select year of manufacture of the car, it can be found in the papers of the car.', '2016', '', '', '1960|1961|1962|1963|1964|1965|1966|1967|1968|1969|1970|1971|1972|1973|1974|1975|1976|1977|1978|1979|1980|1981|1982|1983|1984|1985|1986|1987|1988|1989|1990|1991|1992|1993|1994|1995|1996|1997|1998|1999|2000|2001|2002|2003|2004|2005|2006|2007|2008|2009|2010|2011|2012|2013|2015|2016', '', '');
INSERT INTO class_fields_lang VALUES ('1', 'bg', 'Price', '', 'Invalid price!', '', '', '', '', '', '', '500|1500|2000|2500|3000|3500|4000|4500|5000|6000|7000|8000|9000|10000|12500|15000|17500|20000|25000|30000|40000|50000|75000|100000', '');
INSERT INTO class_fields_lang VALUES ('25', 'ro', 'Rulaj', '', 'Nu ati introdus rulajul!', '', 'Introduceti numarul de kilometrii al autoturismului!', '', '', 'km', '', '0|100|500|1000|1500|2000|3000|5000|10000|25000|50000|75000|100000|120000|150000|200000|300000|500000', '');
INSERT INTO class_fields_lang VALUES ('26', 'eng', 'VIN', '', '', '', 'Enter the VIN on the car, it can be found in car documents.', '', '', '', '', '', '');
INSERT INTO class_fields_lang VALUES ('26', 'german', 'VIN', '', '', '', 'Geben Sie die VIN auf dem Auto, kann es in die Fahrzeugpapiere gefunden werden.', '', '', '', '', '', '');
INSERT INTO class_fields_lang VALUES ('23', 'eng', 'Make&Model', '', '', '', 'Select the make and model of the car!', '', '', '', '', '', '');
INSERT INTO class_fields_lang VALUES ('23', 'german', 'Marke&Modell', '', '', '', 'Whlen Sie die Marke und das Modell des Autos!', '', '', '', '', '', '');
INSERT INTO class_fields_lang VALUES ('23', 'ro', 'Marca&Model', '', '', '', 'Selectati marca si modelul autoturismului!', '', '', '', '', '', '');


#
# Table structure for table `class_fieldsets`
#

DROP TABLE IF EXISTS `class_fieldsets`;
CREATE TABLE `class_fieldsets` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL,
  `description` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_fieldsets`
#

INSERT INTO class_fieldsets VALUES ('9', 'Camioane', 'Anunturi Camioane');
INSERT INTO class_fieldsets VALUES ('7', 'Autoturisme', 'Anunturi autoturisme');
INSERT INTO class_fieldsets VALUES ('8', 'Autoutilitare', 'Anunturi autoutilitare');
INSERT INTO class_fieldsets VALUES ('10', 'Moto si ATV', 'Anunturi motociclete si ATV');
INSERT INTO class_fieldsets VALUES ('11', 'Remorci si Rulote', 'Anunturi pentru remorci si rulote');
INSERT INTO class_fieldsets VALUES ('12', 'Autobuse', 'Anunturi pentru autobuse');
INSERT INTO class_fieldsets VALUES ('13', 'Utilaje', 'Anuntur utilaje pentru constructii si pentru industria agro');
INSERT INTO class_fieldsets VALUES ('14', 'Piese', 'Anuturi auto pentu piese auto');


#
# Table structure for table `class_fortumo_products`
#

DROP TABLE IF EXISTS `class_fortumo_products`;
CREATE TABLE `class_fortumo_products` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `price` float NOT NULL,
  `keyword` varchar(100) DEFAULT NULL,
  `short_code` char(10) DEFAULT NULL,
  `secret` char(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_fortumo_products`
#



#
# Table structure for table `class_fortumo_return`
#

DROP TABLE IF EXISTS `class_fortumo_return`;
CREATE TABLE `class_fortumo_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(20) DEFAULT '0',
  `message` varchar(100) DEFAULT NULL,
  `sender` varchar(50) DEFAULT NULL,
  `country` varchar(2) DEFAULT NULL,
  `price` float DEFAULT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `service_id` varchar(100) DEFAULT NULL,
  `message_id` varchar(50) DEFAULT NULL,
  `keyword` varchar(50) DEFAULT NULL,
  `shortcode` int(10) DEFAULT NULL,
  `operator` varchar(40) DEFAULT NULL,
  `billing_type` varchar(2) DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `test` varchar(5) DEFAULT NULL,
  `sig` varchar(50) DEFAULT NULL,
  `entirepost` text,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_fortumo_return`
#



#
# Table structure for table `class_fortumo_settings`
#

DROP TABLE IF EXISTS `class_fortumo_settings`;
CREATE TABLE `class_fortumo_settings` (
  `currency` varchar(3) DEFAULT NULL,
  `test` tinyint(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_fortumo_settings`
#

INSERT INTO class_fortumo_settings VALUES ('EUR', '0');


#
# Table structure for table `class_hipay_return`
#

DROP TABLE IF EXISTS `class_hipay_return`;
CREATE TABLE `class_hipay_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `entirepost` text,
  `operation` varchar(100) DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `time` varchar(130) DEFAULT NULL,
  `transid` varchar(130) DEFAULT NULL,
  `amount` varchar(130) DEFAULT NULL,
  `currency` varchar(130) DEFAULT NULL,
  `idformerchant` varchar(130) DEFAULT NULL,
  `merchantdatas` varchar(130) DEFAULT NULL,
  `emailClient` varchar(130) DEFAULT NULL,
  `subscriptionId` varchar(130) DEFAULT NULL,
  `refProduct` varchar(130) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_hipay_return`
#



#
# Table structure for table `class_hipay_settings`
#

DROP TABLE IF EXISTS `class_hipay_settings`;
CREATE TABLE `class_hipay_settings` (
  `member_account` varchar(128) DEFAULT NULL,
  `merchant_password` varchar(100) DEFAULT NULL,
  `website_id` varchar(10) DEFAULT NULL,
  `locale` varchar(20) DEFAULT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `notification_email` varchar(100) DEFAULT NULL,
  `category` varchar(10) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_hipay_settings`
#

INSERT INTO class_hipay_settings VALUES ('', '', '', 'en_GB', 'EUR', '', '');


#
# Table structure for table `class_icepay_ipn`
#

DROP TABLE IF EXISTS `class_icepay_ipn`;
CREATE TABLE `class_icepay_ipn` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `Status` varchar(10) DEFAULT NULL,
  `StatusCode` varchar(100) DEFAULT NULL,
  `Merchant` int(10) DEFAULT NULL,
  `OrderID` varchar(10) DEFAULT NULL,
  `PaymentID` int(10) DEFAULT NULL,
  `Reference` varchar(50) DEFAULT NULL,
  `TransactionID` varchar(50) DEFAULT NULL,
  `ConsumerName` varchar(100) DEFAULT NULL,
  `ConsumerAccountNumber` varchar(100) DEFAULT NULL,
  `ConsumerAddress` varchar(100) DEFAULT NULL,
  `ConsumerHouseNumber` varchar(10) DEFAULT NULL,
  `ConsumerPostCode` varchar(50) DEFAULT NULL,
  `ConsumerCity` varchar(100) DEFAULT NULL,
  `ConsumerCountry` varchar(100) DEFAULT NULL,
  `ConsumerEmail` varchar(200) DEFAULT NULL,
  `ConsumerPhoneNumber` varchar(50) DEFAULT NULL,
  `ConsumerIPAddress` varchar(50) DEFAULT NULL,
  `Amount` int(20) DEFAULT NULL,
  `Currency` varchar(3) DEFAULT NULL,
  `Duration` int(10) DEFAULT NULL,
  `Checksum` varchar(40) DEFAULT NULL,
  `PaymentMethod` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_icepay_ipn`
#



#
# Table structure for table `class_icepay_settings`
#

DROP TABLE IF EXISTS `class_icepay_settings`;
CREATE TABLE `class_icepay_settings` (
  `merchantID` int(10) DEFAULT NULL,
  `secretCode` varchar(50) DEFAULT NULL,
  `ic_language` varchar(3) DEFAULT NULL,
  `ic_country` varchar(3) DEFAULT NULL,
  `ic_currency` varchar(3) DEFAULT NULL,
  `description` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_icepay_settings`
#

INSERT INTO class_icepay_settings VALUES ('', '', '', '', '', '');


#
# Table structure for table `class_ie_settings`
#

DROP TABLE IF EXISTS `class_ie_settings`;
CREATE TABLE `class_ie_settings` (
  `bulk_type` varchar(20) DEFAULT NULL,
  `bulk_template` int(2) DEFAULT NULL,
  `bulk_plan` int(2) DEFAULT NULL,
  `csv_column_separator` varchar(10) DEFAULT NULL,
  `csv_field_separator` varchar(10) DEFAULT NULL,
  `custom_page_id` int(2) DEFAULT '3'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_ie_settings`
#

INSERT INTO class_ie_settings VALUES ('xml', '0', '1', ',', '\"', '3');


#
# Table structure for table `class_ie_templates`
#

DROP TABLE IF EXISTS `class_ie_templates`;
CREATE TABLE `class_ie_templates` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) DEFAULT NULL,
  `type` varchar(10) DEFAULT 'ad',
  `purpose` varchar(10) DEFAULT 'import',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_ie_templates`
#



#
# Table structure for table `class_ie_templates_fields`
#

DROP TABLE IF EXISTS `class_ie_templates_fields`;
CREATE TABLE `class_ie_templates_fields` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `template_id` int(2) DEFAULT NULL,
  `field` varchar(50) DEFAULT NULL,
  `alias` varchar(40) DEFAULT NULL,
  `cdata` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_ie_templates_fields`
#



#
# Table structure for table `class_info`
#

DROP TABLE IF EXISTS `class_info`;
CREATE TABLE `class_info` (
  `lang_id` varchar(20) DEFAULT 'eng',
  `code` varchar(50) NOT NULL,
  `content` text,
  `info` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_info`
#

INSERT INTO class_info VALUES ('eng', 'ad_publish_status', '{if $nologin && $activation}{* IF LISTING IS PLACED WITHOUT LOGIN AND IT NEEDS ACTIVATION *}\r\nPlease note that your listing is not active! You will shortly receive an email with an activation link. Follow the email instruction to activate your listing.\r\n<br>\r\n\r\n{/if}\r\n{if $manual} {* IF PAYMENT IS REQUIRED AND CHOSEN PAYMENT IS MANUAL *}\r\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n\r\n{elseif $ad_pending}\r\n\r\nYour ad is pending and will be published after it will be verified by administrator!\r\n<br><br>\r\n{elseif !$nologin || !$activation}\r\n\r\nYour ad is published! You can view your listing <a href=\"{$details_link}\">here</a>!\r\n<br><br>\r\n{/if}\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is posted. The message can contain information about ad status.');
INSERT INTO class_info VALUES ('eng', 'ad_options_upgrade_status', '{if $manual}\r\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}<br>\r\n{/if}\r\n\r\nYour ad upgrade details:<br>\r\n\r\nAd ID: <b>#{$ad_id}</b><br>\r\nAd upgrade status: <b>{$status}</b><br>\r\nInvoice no: <b>#{$invoice_no}</b><br>\r\nProcessor: <b>{$processor}</b><br>\r\n{if $featured}Feature Ad: <b>{$featured_price}</b><br>{/if}\r\n{if $highlited}Highlighted Ad: <b>{$highlited_price}</b><br>{/if}\r\n{if $priority}Priority: <b>{$priority_name} {$priority_price}</b><br>{/if}\r\n{if $video}Video: <b>{$video_price}</b><br>{/if}\r\n\r\n{if $discount}Discount: <b>{$discount}</b><br>{/if}\r\nTotal: <b>{$amount_formatted}</b><br><br>\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is upgraded. The message can contain information about upgrade status.');
INSERT INTO class_info VALUES ('eng', 'subscription_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $plan_pending}\r\n\r\nYour subscription is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour subscription is active, you can publish ads now!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Subscription details:</b><br/>\r\n<br/>\r\nSubscription: <b>{$plan.name}</b><br/>\r\nPlan price: <b>{$plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n<br/>{/if}\r\nNumber of ads: <b>{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}{/if}</b><br/>\r\nSubscription time: <b>{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</b><br/>\r\nAllowed pictures: <b>{$plan.no_pictures}</b><br/>\r\nWords: <b>{if $plan.no_words}{$plan.no_words}{else}{$unlimited}{/if}</b><br/>\r\nAds availability: <b>{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the subscription is posted. The message can contain information about subscription status.');
INSERT INTO class_info VALUES ('eng', 'buy_store_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $pending}\r\n\r\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated<br/><br/>\r\n\r\n{else}\r\n\r\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/><br/>\r\n\r\n{/if}\r\n\r\n<br>\r\n<b>Dealer Page details:</b><br>\r\n<br>\r\nAmount: <b>{$amount_formatted}</b><br>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n{/if}\r\nProcessor: <b>{$processor}</b><br>\r\nDealer Page availability: <b>{if $days}{$days}{else}{$unlimited}{/if} days</b><br>\r\nStatus: <b>{$status}</b>\r\n<br>\r\n\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the Dealer Page option is chosen and after passing payment. The message can contain information about Dealer Page option status.');
INSERT INTO class_info VALUES ('eng', 'bulk_uploads_info', 'Place here information regarding bulk uploads format.', 'Message which explains to users how to use bulk uploads feature.');
INSERT INTO class_info VALUES ('eng', 'password_recovery_mail_sent', 'An email has been sent to your email address with information how to recover your password.', 'The message the user gets after he submits for retrieving a lost password.');
INSERT INTO class_info VALUES ('eng', 'not_authorized', 'You are not authorized to view this page!<br /> \r\n\r\nPlease <a href=\"login.php\" class=\"info\">login</a> on your account, or if you do not have one, please <a href=\"register.php\" class=\"info\">register</a>!', 'The text which will appear if the person that browse a certain page does not have access to that page (for example access administrator settings pages without being logged as administrator)');
INSERT INTO class_info VALUES ('eng', 'password_recovery_key_invalid', 'You reached this page probably because you followed a link from a message which was sent to you with instructions to choose a password to access this site. However, that link is no longer valid. <br /> \r\n\r\nPlease submit your data again to recover your password!', 'The message shown to a user when trying to retrieve a lost password but the recovery key is invalid.');
INSERT INTO class_info VALUES ('eng', 'fortumo_info', 'Please send the code below to the number ::SHORT_CODE:::<br/> ::KEY:: <br/>You will be charged with: ::AMOUNT::', 'The message which appears when the user chooses to pay with Fortumo SMS payment.');
INSERT INTO class_info VALUES ('eng', 'fortumo_failed', 'The payment failed!', 'The SMS message which is sent back to user when the payment failed. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('eng', 'fortumo_success', 'Payment successful!', 'The SMS message which is sent back to user when the payment succeeded. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('eng', 'buy_credits_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $credits_pending}\r\n\r\nYour credits purchase is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour have successfully purchased extra credits!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Credits package details:</b><br/>\r\n<br/>\r\nPackage name: <b>{$credits_plan.name}</b><br/>\r\nPrice: <b>{$credits_plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br/>\r\nTotal: <b>{$amount_formatted}</b><br/>\r\n{/if}\r\nNumber of credits: <b>{$credits_plan.no_credits}</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after a credits package is ordered. The message can contain information about the credits package status.');
INSERT INTO class_info VALUES ('eng', 'account_removal', 'Your account removal request was sent. Your account will be removed shortly by the site administrator!', 'The message which shows after a user requests an account removal and confirms it using an activation link received in an email.');
INSERT INTO class_info VALUES ('esp', 'ad_publish_status', '{if $nologin && $activation}{* IF LISTING IS PLACED WITHOUT LOGIN AND IT NEEDS ACTIVATION *}\r\nPlease note that your listing is not active! You will shortly receive an email with an activation link. Follow the email instruction to activate your listing.\r\n<br>\r\n\r\n{/if}\r\n{if $manual} {* IF PAYMENT IS REQUIRED AND CHOSEN PAYMENT IS MANUAL *}\r\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n\r\n{elseif $ad_pending}\r\n\r\nYour ad is pending and will be published after it will be verified by administrator!\r\n<br><br>\r\n{elseif !$nologin || !$activation}\r\n\r\nYour ad is published! You can view your listing <a href=\"{$details_link}\">here</a>!\r\n<br><br>\r\n{/if}\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is posted. The message can contain information about ad status.');
INSERT INTO class_info VALUES ('esp', 'ad_options_upgrade_status', '{if $manual}\r\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}<br>\r\n{/if}\r\n\r\nYour ad upgrade details:<br>\r\n\r\nAd ID: <b>#{$ad_id}</b><br>\r\nAd upgrade status: <b>{$status}</b><br>\r\nInvoice no: <b>#{$invoice_no}</b><br>\r\nProcessor: <b>{$processor}</b><br>\r\n{if $featured}Feature Ad: <b>{$featured_price}</b><br>{/if}\r\n{if $highlited}Highlighted Ad: <b>{$highlited_price}</b><br>{/if}\r\n{if $priority}Priority: <b>{$priority_name} {$priority_price}</b><br>{/if}\r\n{if $video}Video: <b>{$video_price}</b><br>{/if}\r\n\r\n{if $discount}Discount: <b>{$discount}</b><br>{/if}\r\nTotal: <b>{$amount_formatted}</b><br><br>\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is upgraded. The message can contain information about upgrade status.');
INSERT INTO class_info VALUES ('esp', 'subscription_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $plan_pending}\r\n\r\nYour subscription is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour subscription is active, you can publish ads now!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Subscription details:</b><br/>\r\n<br/>\r\nSubscription: <b>{$plan.name}</b><br/>\r\nPlan price: <b>{$plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n<br/>{/if}\r\nNumber of ads: <b>{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}{/if}</b><br/>\r\nSubscription time: <b>{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</b><br/>\r\nAllowed pictures: <b>{$plan.no_pictures}</b><br/>\r\nWords: <b>{if $plan.no_words}{$plan.no_words}{else}{$unlimited}{/if}</b><br/>\r\nAds availability: <b>{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the subscription is posted. The message can contain information about subscription status.');
INSERT INTO class_info VALUES ('esp', 'buy_store_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $pending}\r\n\r\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated<br/><br/>\r\n\r\n{else}\r\n\r\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/><br/>\r\n\r\n{/if}\r\n\r\n<br>\r\n<b>Dealer Page details:</b><br>\r\n<br>\r\nAmount: <b>{$amount_formatted}</b><br>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n{/if}\r\nProcessor: <b>{$processor}</b><br>\r\nDealer Page availability: <b>{if $days}{$days}{else}{$unlimited}{/if} days</b><br>\r\nStatus: <b>{$status}</b>\r\n<br>\r\n\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the Dealer Page option is chosen and after passing payment. The message can contain information about Dealer Page option status.');
INSERT INTO class_info VALUES ('esp', 'bulk_uploads_info', 'Place here information regarding bulk uploads format.', 'Message which explains to users how to use bulk uploads feature.');
INSERT INTO class_info VALUES ('esp', 'password_recovery_mail_sent', 'An email has been sent to your email address with information how to recover your password.', 'The message the user gets after he submits for retrieving a lost password.');
INSERT INTO class_info VALUES ('esp', 'not_authorized', 'You are not authorized to view this page!<br /> \r\n\r\nPlease <a href=\"login.php\" class=\"info\">login</a> on your account, or if you do not have one, please <a href=\"register.php\" class=\"info\">register</a>!', 'The text which will appear if the person that browse a certain page does not have access to that page (for example access administrator settings pages without being logged as administrator)');
INSERT INTO class_info VALUES ('esp', 'password_recovery_key_invalid', 'You reached this page probably because you followed a link from a message which was sent to you with instructions to choose a password to access this site. However, that link is no longer valid. <br /> \r\n\r\nPlease submit your data again to recover your password!', 'The message shown to a user when trying to retrieve a lost password but the recovery key is invalid.');
INSERT INTO class_info VALUES ('esp', 'fortumo_info', 'Please send the code below to the number ::SHORT_CODE:::<br/> ::KEY:: <br/>You will be charged with: ::AMOUNT::', 'The message which appears when the user chooses to pay with Fortumo SMS payment.');
INSERT INTO class_info VALUES ('esp', 'fortumo_failed', 'The payment failed!', 'The SMS message which is sent back to user when the payment failed. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('esp', 'fortumo_success', 'Payment successful!', 'The SMS message which is sent back to user when the payment succeeded. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('esp', 'buy_credits_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $credits_pending}\r\n\r\nYour credits purchase is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour have successfully purchased extra credits!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Credits package details:</b><br/>\r\n<br/>\r\nPackage name: <b>{$credits_plan.name}</b><br/>\r\nPrice: <b>{$credits_plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br/>\r\nTotal: <b>{$amount_formatted}</b><br/>\r\n{/if}\r\nNumber of credits: <b>{$credits_plan.no_credits}</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after a credits package is ordered. The message can contain information about the credits package status.');
INSERT INTO class_info VALUES ('esp', 'account_removal', 'Your account removal request was sent. Your account will be removed shortly by the site administrator!', 'The message which shows after a user requests an account removal and confirms it using an activation link received in an email.');
INSERT INTO class_info VALUES ('french', 'ad_publish_status', '{if $nologin && $activation}{* IF LISTING IS PLACED WITHOUT LOGIN AND IT NEEDS ACTIVATION *}\r\nPlease note that your listing is not active! You will shortly receive an email with an activation link. Follow the email instruction to activate your listing.\r\n<br>\r\n\r\n{/if}\r\n{if $manual} {* IF PAYMENT IS REQUIRED AND CHOSEN PAYMENT IS MANUAL *}\r\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n\r\n{elseif $ad_pending}\r\n\r\nYour ad is pending and will be published after it will be verified by administrator!\r\n<br><br>\r\n{elseif !$nologin || !$activation}\r\n\r\nYour ad is published! You can view your listing <a href=\"{$details_link}\">here</a>!\r\n<br><br>\r\n{/if}\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is posted. The message can contain information about ad status.');
INSERT INTO class_info VALUES ('french', 'ad_options_upgrade_status', '{if $manual}\r\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}<br>\r\n{/if}\r\n\r\nYour ad upgrade details:<br>\r\n\r\nAd ID: <b>#{$ad_id}</b><br>\r\nAd upgrade status: <b>{$status}</b><br>\r\nInvoice no: <b>#{$invoice_no}</b><br>\r\nProcessor: <b>{$processor}</b><br>\r\n{if $featured}Feature Ad: <b>{$featured_price}</b><br>{/if}\r\n{if $highlited}Highlighted Ad: <b>{$highlited_price}</b><br>{/if}\r\n{if $priority}Priority: <b>{$priority_name} {$priority_price}</b><br>{/if}\r\n{if $video}Video: <b>{$video_price}</b><br>{/if}\r\n\r\n{if $discount}Discount: <b>{$discount}</b><br>{/if}\r\nTotal: <b>{$amount_formatted}</b><br><br>\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is upgraded. The message can contain information about upgrade status.');
INSERT INTO class_info VALUES ('french', 'subscription_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $plan_pending}\r\n\r\nYour subscription is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour subscription is active, you can publish ads now!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Subscription details:</b><br/>\r\n<br/>\r\nSubscription: <b>{$plan.name}</b><br/>\r\nPlan price: <b>{$plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n<br/>{/if}\r\nNumber of ads: <b>{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}{/if}</b><br/>\r\nSubscription time: <b>{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</b><br/>\r\nAllowed pictures: <b>{$plan.no_pictures}</b><br/>\r\nWords: <b>{if $plan.no_words}{$plan.no_words}{else}{$unlimited}{/if}</b><br/>\r\nAds availability: <b>{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the subscription is posted. The message can contain information about subscription status.');
INSERT INTO class_info VALUES ('french', 'buy_store_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $pending}\r\n\r\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated<br/><br/>\r\n\r\n{else}\r\n\r\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/><br/>\r\n\r\n{/if}\r\n\r\n<br>\r\n<b>Dealer Page details:</b><br>\r\n<br>\r\nAmount: <b>{$amount_formatted}</b><br>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n{/if}\r\nProcessor: <b>{$processor}</b><br>\r\nDealer Page availability: <b>{if $days}{$days}{else}{$unlimited}{/if} days</b><br>\r\nStatus: <b>{$status}</b>\r\n<br>\r\n\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the Dealer Page option is chosen and after passing payment. The message can contain information about Dealer Page option status.');
INSERT INTO class_info VALUES ('french', 'bulk_uploads_info', 'Place here information regarding bulk uploads format.', 'Message which explains to users how to use bulk uploads feature.');
INSERT INTO class_info VALUES ('french', 'password_recovery_mail_sent', 'An email has been sent to your email address with information how to recover your password.', 'The message the user gets after he submits for retrieving a lost password.');
INSERT INTO class_info VALUES ('french', 'not_authorized', 'You are not authorized to view this page!<br /> \r\n\r\nPlease <a href=\"login.php\" class=\"info\">login</a> on your account, or if you do not have one, please <a href=\"register.php\" class=\"info\">register</a>!', 'The text which will appear if the person that browse a certain page does not have access to that page (for example access administrator settings pages without being logged as administrator)');
INSERT INTO class_info VALUES ('french', 'password_recovery_key_invalid', 'You reached this page probably because you followed a link from a message which was sent to you with instructions to choose a password to access this site. However, that link is no longer valid. <br /> \r\n\r\nPlease submit your data again to recover your password!', 'The message shown to a user when trying to retrieve a lost password but the recovery key is invalid.');
INSERT INTO class_info VALUES ('french', 'fortumo_info', 'Please send the code below to the number ::SHORT_CODE:::<br/> ::KEY:: <br/>You will be charged with: ::AMOUNT::', 'The message which appears when the user chooses to pay with Fortumo SMS payment.');
INSERT INTO class_info VALUES ('french', 'fortumo_failed', 'The payment failed!', 'The SMS message which is sent back to user when the payment failed. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('french', 'fortumo_success', 'Payment successful!', 'The SMS message which is sent back to user when the payment succeeded. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('french', 'buy_credits_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $credits_pending}\r\n\r\nYour credits purchase is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour have successfully purchased extra credits!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Credits package details:</b><br/>\r\n<br/>\r\nPackage name: <b>{$credits_plan.name}</b><br/>\r\nPrice: <b>{$credits_plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br/>\r\nTotal: <b>{$amount_formatted}</b><br/>\r\n{/if}\r\nNumber of credits: <b>{$credits_plan.no_credits}</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after a credits package is ordered. The message can contain information about the credits package status.');
INSERT INTO class_info VALUES ('french', 'account_removal', 'Your account removal request was sent. Your account will be removed shortly by the site administrator!', 'The message which shows after a user requests an account removal and confirms it using an activation link received in an email.');
INSERT INTO class_info VALUES ('italian', 'ad_publish_status', '{if $nologin && $activation}{* IF LISTING IS PLACED WITHOUT LOGIN AND IT NEEDS ACTIVATION *}\r\nPlease note that your listing is not active! You will shortly receive an email with an activation link. Follow the email instruction to activate your listing.\r\n<br>\r\n\r\n{/if}\r\n{if $manual} {* IF PAYMENT IS REQUIRED AND CHOSEN PAYMENT IS MANUAL *}\r\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n\r\n{elseif $ad_pending}\r\n\r\nYour ad is pending and will be published after it will be verified by administrator!\r\n<br><br>\r\n{elseif !$nologin || !$activation}\r\n\r\nYour ad is published! You can view your listing <a href=\"{$details_link}\">here</a>!\r\n<br><br>\r\n{/if}\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is posted. The message can contain information about ad status.');
INSERT INTO class_info VALUES ('italian', 'ad_options_upgrade_status', '{if $manual}\r\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}<br>\r\n{/if}\r\n\r\nYour ad upgrade details:<br>\r\n\r\nAd ID: <b>#{$ad_id}</b><br>\r\nAd upgrade status: <b>{$status}</b><br>\r\nInvoice no: <b>#{$invoice_no}</b><br>\r\nProcessor: <b>{$processor}</b><br>\r\n{if $featured}Feature Ad: <b>{$featured_price}</b><br>{/if}\r\n{if $highlited}Highlighted Ad: <b>{$highlited_price}</b><br>{/if}\r\n{if $priority}Priority: <b>{$priority_name} {$priority_price}</b><br>{/if}\r\n{if $video}Video: <b>{$video_price}</b><br>{/if}\r\n\r\n{if $discount}Discount: <b>{$discount}</b><br>{/if}\r\nTotal: <b>{$amount_formatted}</b><br><br>\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is upgraded. The message can contain information about upgrade status.');
INSERT INTO class_info VALUES ('italian', 'subscription_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $plan_pending}\r\n\r\nYour subscription is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour subscription is active, you can publish ads now!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Subscription details:</b><br/>\r\n<br/>\r\nSubscription: <b>{$plan.name}</b><br/>\r\nPlan price: <b>{$plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n<br/>{/if}\r\nNumber of ads: <b>{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}{/if}</b><br/>\r\nSubscription time: <b>{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</b><br/>\r\nAllowed pictures: <b>{$plan.no_pictures}</b><br/>\r\nWords: <b>{if $plan.no_words}{$plan.no_words}{else}{$unlimited}{/if}</b><br/>\r\nAds availability: <b>{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the subscription is posted. The message can contain information about subscription status.');
INSERT INTO class_info VALUES ('italian', 'buy_store_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $pending}\r\n\r\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated<br/><br/>\r\n\r\n{else}\r\n\r\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/><br/>\r\n\r\n{/if}\r\n\r\n<br>\r\n<b>Dealer Page details:</b><br>\r\n<br>\r\nAmount: <b>{$amount_formatted}</b><br>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n{/if}\r\nProcessor: <b>{$processor}</b><br>\r\nDealer Page availability: <b>{if $days}{$days}{else}{$unlimited}{/if} days</b><br>\r\nStatus: <b>{$status}</b>\r\n<br>\r\n\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the Dealer Page option is chosen and after passing payment. The message can contain information about Dealer Page option status.');
INSERT INTO class_info VALUES ('italian', 'bulk_uploads_info', 'Place here information regarding bulk uploads format.', 'Message which explains to users how to use bulk uploads feature.');
INSERT INTO class_info VALUES ('italian', 'password_recovery_mail_sent', 'An email has been sent to your email address with information how to recover your password.', 'The message the user gets after he submits for retrieving a lost password.');
INSERT INTO class_info VALUES ('italian', 'not_authorized', 'You are not authorized to view this page!<br /> \r\n\r\nPlease <a href=\"login.php\" class=\"info\">login</a> on your account, or if you do not have one, please <a href=\"register.php\" class=\"info\">register</a>!', 'The text which will appear if the person that browse a certain page does not have access to that page (for example access administrator settings pages without being logged as administrator)');
INSERT INTO class_info VALUES ('italian', 'password_recovery_key_invalid', 'You reached this page probably because you followed a link from a message which was sent to you with instructions to choose a password to access this site. However, that link is no longer valid. <br /> \r\n\r\nPlease submit your data again to recover your password!', 'The message shown to a user when trying to retrieve a lost password but the recovery key is invalid.');
INSERT INTO class_info VALUES ('italian', 'fortumo_info', 'Please send the code below to the number ::SHORT_CODE:::<br/> ::KEY:: <br/>You will be charged with: ::AMOUNT::', 'The message which appears when the user chooses to pay with Fortumo SMS payment.');
INSERT INTO class_info VALUES ('italian', 'fortumo_failed', 'The payment failed!', 'The SMS message which is sent back to user when the payment failed. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('italian', 'fortumo_success', 'Payment successful!', 'The SMS message which is sent back to user when the payment succeeded. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('italian', 'buy_credits_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $credits_pending}\r\n\r\nYour credits purchase is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour have successfully purchased extra credits!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Credits package details:</b><br/>\r\n<br/>\r\nPackage name: <b>{$credits_plan.name}</b><br/>\r\nPrice: <b>{$credits_plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br/>\r\nTotal: <b>{$amount_formatted}</b><br/>\r\n{/if}\r\nNumber of credits: <b>{$credits_plan.no_credits}</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after a credits package is ordered. The message can contain information about the credits package status.');
INSERT INTO class_info VALUES ('italian', 'account_removal', 'Your account removal request was sent. Your account will be removed shortly by the site administrator!', 'The message which shows after a user requests an account removal and confirms it using an activation link received in an email.');
INSERT INTO class_info VALUES ('german', 'ad_publish_status', '{if $nologin && $activation}{* IF LISTING IS PLACED WITHOUT LOGIN AND IT NEEDS ACTIVATION *}\r\nPlease note that your listing is not active! You will shortly receive an email with an activation link. Follow the email instruction to activate your listing.\r\n<br>\r\n\r\n{/if}\r\n{if $manual} {* IF PAYMENT IS REQUIRED AND CHOSEN PAYMENT IS MANUAL *}\r\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n\r\n{elseif $ad_pending}\r\n\r\nYour ad is pending and will be published after it will be verified by administrator!\r\n<br><br>\r\n{elseif !$nologin || !$activation}\r\n\r\nYour ad is published! You can view your listing <a href=\"{$details_link}\">here</a>!\r\n<br><br>\r\n{/if}\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is posted. The message can contain information about ad status.');
INSERT INTO class_info VALUES ('german', 'ad_options_upgrade_status', '{if $manual}\r\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}<br>\r\n{/if}\r\n\r\nYour ad upgrade details:<br>\r\n\r\nAd ID: <b>#{$ad_id}</b><br>\r\nAd upgrade status: <b>{$status}</b><br>\r\nInvoice no: <b>#{$invoice_no}</b><br>\r\nProcessor: <b>{$processor}</b><br>\r\n{if $featured}Feature Ad: <b>{$featured_price}</b><br>{/if}\r\n{if $highlited}Highlighted Ad: <b>{$highlited_price}</b><br>{/if}\r\n{if $priority}Priority: <b>{$priority_name} {$priority_price}</b><br>{/if}\r\n{if $video}Video: <b>{$video_price}</b><br>{/if}\r\n\r\n{if $discount}Discount: <b>{$discount}</b><br>{/if}\r\nTotal: <b>{$amount_formatted}</b><br><br>\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is upgraded. The message can contain information about upgrade status.');
INSERT INTO class_info VALUES ('german', 'subscription_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $plan_pending}\r\n\r\nYour subscription is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour subscription is active, you can publish ads now!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Subscription details:</b><br/>\r\n<br/>\r\nSubscription: <b>{$plan.name}</b><br/>\r\nPlan price: <b>{$plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n<br/>{/if}\r\nNumber of ads: <b>{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}{/if}</b><br/>\r\nSubscription time: <b>{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</b><br/>\r\nAllowed pictures: <b>{$plan.no_pictures}</b><br/>\r\nWords: <b>{if $plan.no_words}{$plan.no_words}{else}{$unlimited}{/if}</b><br/>\r\nAds availability: <b>{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the subscription is posted. The message can contain information about subscription status.');
INSERT INTO class_info VALUES ('german', 'buy_store_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $pending}\r\n\r\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated<br/><br/>\r\n\r\n{else}\r\n\r\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/><br/>\r\n\r\n{/if}\r\n\r\n<br>\r\n<b>Dealer Page details:</b><br>\r\n<br>\r\nAmount: <b>{$amount_formatted}</b><br>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n{/if}\r\nProcessor: <b>{$processor}</b><br>\r\nDealer Page availability: <b>{if $days}{$days}{else}{$unlimited}{/if} days</b><br>\r\nStatus: <b>{$status}</b>\r\n<br>\r\n\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the Dealer Page option is chosen and after passing payment. The message can contain information about Dealer Page option status.');
INSERT INTO class_info VALUES ('german', 'bulk_uploads_info', 'Place here information regarding bulk uploads format.', 'Message which explains to users how to use bulk uploads feature.');
INSERT INTO class_info VALUES ('german', 'password_recovery_mail_sent', 'An email has been sent to your email address with information how to recover your password.', 'The message the user gets after he submits for retrieving a lost password.');
INSERT INTO class_info VALUES ('german', 'not_authorized', 'You are not authorized to view this page!<br /> \r\n\r\nPlease <a href=\"login.php\" class=\"info\">login</a> on your account, or if you do not have one, please <a href=\"register.php\" class=\"info\">register</a>!', 'The text which will appear if the person that browse a certain page does not have access to that page (for example access administrator settings pages without being logged as administrator)');
INSERT INTO class_info VALUES ('german', 'password_recovery_key_invalid', 'You reached this page probably because you followed a link from a message which was sent to you with instructions to choose a password to access this site. However, that link is no longer valid. <br /> \r\n\r\nPlease submit your data again to recover your password!', 'The message shown to a user when trying to retrieve a lost password but the recovery key is invalid.');
INSERT INTO class_info VALUES ('german', 'fortumo_info', 'Please send the code below to the number ::SHORT_CODE:::<br/> ::KEY:: <br/>You will be charged with: ::AMOUNT::', 'The message which appears when the user chooses to pay with Fortumo SMS payment.');
INSERT INTO class_info VALUES ('german', 'fortumo_failed', 'The payment failed!', 'The SMS message which is sent back to user when the payment failed. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('german', 'fortumo_success', 'Payment successful!', 'The SMS message which is sent back to user when the payment succeeded. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('german', 'buy_credits_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $credits_pending}\r\n\r\nYour credits purchase is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour have successfully purchased extra credits!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Credits package details:</b><br/>\r\n<br/>\r\nPackage name: <b>{$credits_plan.name}</b><br/>\r\nPrice: <b>{$credits_plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br/>\r\nTotal: <b>{$amount_formatted}</b><br/>\r\n{/if}\r\nNumber of credits: <b>{$credits_plan.no_credits}</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after a credits package is ordered. The message can contain information about the credits package status.');
INSERT INTO class_info VALUES ('german', 'account_removal', 'Your account removal request was sent. Your account will be removed shortly by the site administrator!', 'The message which shows after a user requests an account removal and confirms it using an activation link received in an email.');
INSERT INTO class_info VALUES ('ro', 'ad_publish_status', '{if $nologin && $activation}{* IF LISTING IS PLACED WITHOUT LOGIN AND IT NEEDS ACTIVATION *}\r\nAnuntul dumneavoastra este in asteptare! O sa primiti un email cu un link pentru activare. Urmariti instructiunile din email pentru a activa anuntul.\r\n<br>\r\n\r\n{/if}\r\n{if $manual} {* IF PAYMENT IS REQUIRED AND CHOSEN PAYMENT IS MANUAL *}\r\nMetoda de plata aleasa este una manuala. Acest lucru inseamnand ca modificarile raman in asteptare pana la confirmarea platii. Pentru a face plata va rugam sa folositi urmatoarele date:<br><br>\r\n\r\n{*  ------------ Date PLATA  ---------------- *}\r\n\r\n{elseif $ad_pending}\r\n\r\nAnuntul dumneavoastra este in asteptare pana la verificarea de catre un administrator!\r\n<br><br>\r\n{elseif !$nologin || !$activation}\r\n\r\nAnuntul dumneavoastra este publicat! Puteti vizualiza anuntul <a href=\"{$details_link}\">aici</a>!\r\n<br><br>\r\n{/if}\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Intoarcere la cont</a>\r\n{/if}', 'The info message which appears after the ad is posted. The message can contain information about ad status.');
INSERT INTO class_info VALUES ('ro', 'ad_options_upgrade_status', '{if $manual}\r\nMetoda de plata aleasa este una manuala. Acest lucru inseamnand ca modificarile raman in asteptare pana la confirmarea platii. Pentru a face plata va rugam sa folositi urmatoarele date:<br><br>\r\n\r\n{*  ------------ Date PLATA---------------- *}<br>\r\n{/if}\r\n\r\nDetalii modificari:<br>\r\n\r\nID anunt: <b>#{$ad_id}</b><br>\r\nStatus modificari: <b>{$status}</b><br>\r\nNr. Factura: <b>#{$invoice_no}</b><br>\r\nProcesor plata: <b>{$processor}</b><br>\r\n{if $featured}Anunt promovat: <b>{$featured_price}</b><br>{/if}\r\n{if $highlited}Anunt evidentiat: <b>{$highlited_price}</b><br>{/if}\r\n{if $priority}Prioritata: <b>{$priority_name} {$priority_price}</b><br>{/if}\r\n{if $video}Video: <b>{$video_price}</b><br>{/if}\r\n\r\n{if $discount}Discount: <b>{$discount}</b><br>{/if}\r\nTotal: <b>{$amount_formatted}</b><br><br>\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Intoarcere la cont</a>\r\n{/if}', 'The info message which appears after the ad is upgraded. The message can contain information about upgrade status.');
INSERT INTO class_info VALUES ('ro', 'subscription_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $plan_pending}\r\n\r\nYour subscription is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour subscription is active, you can publish ads now!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Subscription details:</b><br/>\r\n<br/>\r\nSubscription: <b>{$plan.name}</b><br/>\r\nPlan price: <b>{$plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n<br/>{/if}\r\nNumber of ads: <b>{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}{/if}</b><br/>\r\nSubscription time: <b>{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</b><br/>\r\nAllowed pictures: <b>{$plan.no_pictures}</b><br/>\r\nWords: <b>{if $plan.no_words}{$plan.no_words}{else}{$unlimited}{/if}</b><br/>\r\nAds availability: <b>{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the subscription is posted. The message can contain information about subscription status.');
INSERT INTO class_info VALUES ('ro', 'buy_store_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $pending}\r\n\r\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated<br/><br/>\r\n\r\n{else}\r\n\r\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/><br/>\r\n\r\n{/if}\r\n\r\n<br>\r\n<b>Dealer Page details:</b><br>\r\n<br>\r\nAmount: <b>{$amount_formatted}</b><br>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n{/if}\r\nProcessor: <b>{$processor}</b><br>\r\nDealer Page availability: <b>{if $days}{$days}{else}{$unlimited}{/if} days</b><br>\r\nStatus: <b>{$status}</b>\r\n<br>\r\n\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the Dealer Page option is chosen and after passing payment. The message can contain information about Dealer Page option status.');
INSERT INTO class_info VALUES ('ro', 'bulk_uploads_info', 'Place here information regarding bulk uploads format.', 'Message which explains to users how to use bulk uploads feature.');
INSERT INTO class_info VALUES ('ro', 'password_recovery_mail_sent', 'Un email cu informatiile necesare pentru resetarea parolei a fost trimis pe adresa de email furnizata.', 'The message the user gets after he submits for retrieving a lost password.');
INSERT INTO class_info VALUES ('ro', 'not_authorized', 'You are not authorized to view this page!<br /> \r\n\r\nPlease <a href=\"login.php\" class=\"info\">login</a> on your account, or if you do not have one, please <a href=\"register.php\" class=\"info\">register</a>!', 'The text which will appear if the person that browse a certain page does not have access to that page (for example access administrator settings pages without being logged as administrator)');
INSERT INTO class_info VALUES ('ro', 'password_recovery_key_invalid', 'Ati ajuns pe aceasta pagina in urma accesarii unui link dintr-un email pentru resetarea parolei. Cu toate acestea, acest link nu mai este valid. <br /> \r\n\r\nVa rugam sa cereti o noua restare a parolei!', 'The message shown to a user when trying to retrieve a lost password but the recovery key is invalid.');
INSERT INTO class_info VALUES ('ro', 'fortumo_info', 'Please send the code below to the number ::SHORT_CODE:::<br/> ::KEY:: <br/>You will be charged with: ::AMOUNT::', 'The message which appears when the user chooses to pay with Fortumo SMS payment.');
INSERT INTO class_info VALUES ('ro', 'fortumo_failed', 'The payment failed!', 'The SMS message which is sent back to user when the payment failed. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('ro', 'fortumo_success', 'Payment successful!', 'The SMS message which is sent back to user when the payment succeeded. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('ro', 'buy_credits_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $credits_pending}\r\n\r\nYour credits purchase is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour have successfully purchased extra credits!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Credits package details:</b><br/>\r\n<br/>\r\nPackage name: <b>{$credits_plan.name}</b><br/>\r\nPrice: <b>{$credits_plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br/>\r\nTotal: <b>{$amount_formatted}</b><br/>\r\n{/if}\r\nNumber of credits: <b>{$credits_plan.no_credits}</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after a credits package is ordered. The message can contain information about the credits package status.');
INSERT INTO class_info VALUES ('ro', 'account_removal', 'Cererea de stergere a contului a fost trimisa. Un administrator va sterge contul dumneavoastra cat de curand posibil!', 'The message which shows after a user requests an account removal and confirms it using an activation link received in an email.');
INSERT INTO class_info VALUES ('hr', 'ad_publish_status', '{if $nologin && $activation}{* IF LISTING IS PLACED WITHOUT LOGIN AND IT NEEDS ACTIVATION *}\r\nPlease note that your listing is not active! You will shortly receive an email with an activation link. Follow the email instruction to activate your listing.\r\n<br>\r\n\r\n{/if}\r\n{if $manual} {* IF PAYMENT IS REQUIRED AND CHOSEN PAYMENT IS MANUAL *}\r\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n\r\n{elseif $ad_pending}\r\n\r\nYour ad is pending and will be published after it will be verified by administrator!\r\n<br><br>\r\n{elseif !$nologin || !$activation}\r\n\r\nYour ad is published! You can view your listing <a href=\"{$details_link}\">here</a>!\r\n<br><br>\r\n{/if}\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is posted. The message can contain information about ad status.');
INSERT INTO class_info VALUES ('hr', 'ad_options_upgrade_status', '{if $manual}\r\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}<br>\r\n{/if}\r\n\r\nYour ad upgrade details:<br>\r\n\r\nAd ID: <b>#{$ad_id}</b><br>\r\nAd upgrade status: <b>{$status}</b><br>\r\nInvoice no: <b>#{$invoice_no}</b><br>\r\nProcessor: <b>{$processor}</b><br>\r\n{if $featured}Feature Ad: <b>{$featured_price}</b><br>{/if}\r\n{if $highlited}Highlighted Ad: <b>{$highlited_price}</b><br>{/if}\r\n{if $priority}Priority: <b>{$priority_name} {$priority_price}</b><br>{/if}\r\n{if $video}Video: <b>{$video_price}</b><br>{/if}\r\n\r\n{if $discount}Discount: <b>{$discount}</b><br>{/if}\r\nTotal: <b>{$amount_formatted}</b><br><br>\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is upgraded. The message can contain information about upgrade status.');
INSERT INTO class_info VALUES ('hr', 'subscription_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $plan_pending}\r\n\r\nYour subscription is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour subscription is active, you can publish ads now!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Subscription details:</b><br/>\r\n<br/>\r\nSubscription: <b>{$plan.name}</b><br/>\r\nPlan price: <b>{$plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n<br/>{/if}\r\nNumber of ads: <b>{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}{/if}</b><br/>\r\nSubscription time: <b>{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</b><br/>\r\nAllowed pictures: <b>{$plan.no_pictures}</b><br/>\r\nWords: <b>{if $plan.no_words}{$plan.no_words}{else}{$unlimited}{/if}</b><br/>\r\nAds availability: <b>{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the subscription is posted. The message can contain information about subscription status.');
INSERT INTO class_info VALUES ('hr', 'buy_store_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $pending}\r\n\r\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated<br/><br/>\r\n\r\n{else}\r\n\r\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/><br/>\r\n\r\n{/if}\r\n\r\n<br>\r\n<b>Dealer Page details:</b><br>\r\n<br>\r\nAmount: <b>{$amount_formatted}</b><br>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n{/if}\r\nProcessor: <b>{$processor}</b><br>\r\nDealer Page availability: <b>{if $days}{$days}{else}{$unlimited}{/if} days</b><br>\r\nStatus: <b>{$status}</b>\r\n<br>\r\n\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the Dealer Page option is chosen and after passing payment. The message can contain information about Dealer Page option status.');
INSERT INTO class_info VALUES ('hr', 'bulk_uploads_info', 'Place here information regarding bulk uploads format.', 'Message which explains to users how to use bulk uploads feature.');
INSERT INTO class_info VALUES ('hr', 'password_recovery_mail_sent', 'An email has been sent to your email address with information how to recover your password.', 'The message the user gets after he submits for retrieving a lost password.');
INSERT INTO class_info VALUES ('hr', 'not_authorized', 'You are not authorized to view this page!<br /> \r\n\r\nPlease <a href=\"login.php\" class=\"info\">login</a> on your account, or if you do not have one, please <a href=\"register.php\" class=\"info\">register</a>!', 'The text which will appear if the person that browse a certain page does not have access to that page (for example access administrator settings pages without being logged as administrator)');
INSERT INTO class_info VALUES ('hr', 'password_recovery_key_invalid', 'You reached this page probably because you followed a link from a message which was sent to you with instructions to choose a password to access this site. However, that link is no longer valid. <br /> \r\n\r\nPlease submit your data again to recover your password!', 'The message shown to a user when trying to retrieve a lost password but the recovery key is invalid.');
INSERT INTO class_info VALUES ('hr', 'fortumo_info', 'Please send the code below to the number ::SHORT_CODE:::<br/> ::KEY:: <br/>You will be charged with: ::AMOUNT::', 'The message which appears when the user chooses to pay with Fortumo SMS payment.');
INSERT INTO class_info VALUES ('hr', 'fortumo_failed', 'The payment failed!', 'The SMS message which is sent back to user when the payment failed. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('hr', 'fortumo_success', 'Payment successful!', 'The SMS message which is sent back to user when the payment succeeded. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('hr', 'buy_credits_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $credits_pending}\r\n\r\nYour credits purchase is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour have successfully purchased extra credits!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Credits package details:</b><br/>\r\n<br/>\r\nPackage name: <b>{$credits_plan.name}</b><br/>\r\nPrice: <b>{$credits_plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br/>\r\nTotal: <b>{$amount_formatted}</b><br/>\r\n{/if}\r\nNumber of credits: <b>{$credits_plan.no_credits}</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after a credits package is ordered. The message can contain information about the credits package status.');
INSERT INTO class_info VALUES ('hr', 'account_removal', 'Your account removal request was sent. Your account will be removed shortly by the site administrator!', 'The message which shows after a user requests an account removal and confirms it using an activation link received in an email.');
INSERT INTO class_info VALUES ('hu', 'ad_publish_status', '{if $nologin && $activation}{* IF LISTING IS PLACED WITHOUT LOGIN AND IT NEEDS ACTIVATION *}\r\nPlease note that your listing is not active! You will shortly receive an email with an activation link. Follow the email instruction to activate your listing.\r\n<br>\r\n\r\n{/if}\r\n{if $manual} {* IF PAYMENT IS REQUIRED AND CHOSEN PAYMENT IS MANUAL *}\r\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n\r\n{elseif $ad_pending}\r\n\r\nYour ad is pending and will be published after it will be verified by administrator!\r\n<br><br>\r\n{elseif !$nologin || !$activation}\r\n\r\nYour ad is published! You can view your listing <a href=\"{$details_link}\">here</a>!\r\n<br><br>\r\n{/if}\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is posted. The message can contain information about ad status.');
INSERT INTO class_info VALUES ('hu', 'ad_options_upgrade_status', '{if $manual}\r\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}<br>\r\n{/if}\r\n\r\nYour ad upgrade details:<br>\r\n\r\nAd ID: <b>#{$ad_id}</b><br>\r\nAd upgrade status: <b>{$status}</b><br>\r\nInvoice no: <b>#{$invoice_no}</b><br>\r\nProcessor: <b>{$processor}</b><br>\r\n{if $featured}Feature Ad: <b>{$featured_price}</b><br>{/if}\r\n{if $highlited}Highlighted Ad: <b>{$highlited_price}</b><br>{/if}\r\n{if $priority}Priority: <b>{$priority_name} {$priority_price}</b><br>{/if}\r\n{if $video}Video: <b>{$video_price}</b><br>{/if}\r\n\r\n{if $discount}Discount: <b>{$discount}</b><br>{/if}\r\nTotal: <b>{$amount_formatted}</b><br><br>\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is upgraded. The message can contain information about upgrade status.');
INSERT INTO class_info VALUES ('hu', 'subscription_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $plan_pending}\r\n\r\nYour subscription is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour subscription is active, you can publish ads now!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Subscription details:</b><br/>\r\n<br/>\r\nSubscription: <b>{$plan.name}</b><br/>\r\nPlan price: <b>{$plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n<br/>{/if}\r\nNumber of ads: <b>{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}{/if}</b><br/>\r\nSubscription time: <b>{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</b><br/>\r\nAllowed pictures: <b>{$plan.no_pictures}</b><br/>\r\nWords: <b>{if $plan.no_words}{$plan.no_words}{else}{$unlimited}{/if}</b><br/>\r\nAds availability: <b>{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the subscription is posted. The message can contain information about subscription status.');
INSERT INTO class_info VALUES ('hu', 'buy_store_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $pending}\r\n\r\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated<br/><br/>\r\n\r\n{else}\r\n\r\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/><br/>\r\n\r\n{/if}\r\n\r\n<br>\r\n<b>Dealer Page details:</b><br>\r\n<br>\r\nAmount: <b>{$amount_formatted}</b><br>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n{/if}\r\nProcessor: <b>{$processor}</b><br>\r\nDealer Page availability: <b>{if $days}{$days}{else}{$unlimited}{/if} days</b><br>\r\nStatus: <b>{$status}</b>\r\n<br>\r\n\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the Dealer Page option is chosen and after passing payment. The message can contain information about Dealer Page option status.');
INSERT INTO class_info VALUES ('hu', 'bulk_uploads_info', 'Place here information regarding bulk uploads format.', 'Message which explains to users how to use bulk uploads feature.');
INSERT INTO class_info VALUES ('hu', 'password_recovery_mail_sent', 'An email has been sent to your email address with information how to recover your password.', 'The message the user gets after he submits for retrieving a lost password.');
INSERT INTO class_info VALUES ('hu', 'not_authorized', 'You are not authorized to view this page!<br /> \r\n\r\nPlease <a href=\"login.php\" class=\"info\">login</a> on your account, or if you do not have one, please <a href=\"register.php\" class=\"info\">register</a>!', 'The text which will appear if the person that browse a certain page does not have access to that page (for example access administrator settings pages without being logged as administrator)');
INSERT INTO class_info VALUES ('hu', 'password_recovery_key_invalid', 'You reached this page probably because you followed a link from a message which was sent to you with instructions to choose a password to access this site. However, that link is no longer valid. <br /> \r\n\r\nPlease submit your data again to recover your password!', 'The message shown to a user when trying to retrieve a lost password but the recovery key is invalid.');
INSERT INTO class_info VALUES ('hu', 'fortumo_info', 'Please send the code below to the number ::SHORT_CODE:::<br/> ::KEY:: <br/>You will be charged with: ::AMOUNT::', 'The message which appears when the user chooses to pay with Fortumo SMS payment.');
INSERT INTO class_info VALUES ('hu', 'fortumo_failed', 'The payment failed!', 'The SMS message which is sent back to user when the payment failed. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('hu', 'fortumo_success', 'Payment successful!', 'The SMS message which is sent back to user when the payment succeeded. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('hu', 'buy_credits_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $credits_pending}\r\n\r\nYour credits purchase is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour have successfully purchased extra credits!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Credits package details:</b><br/>\r\n<br/>\r\nPackage name: <b>{$credits_plan.name}</b><br/>\r\nPrice: <b>{$credits_plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br/>\r\nTotal: <b>{$amount_formatted}</b><br/>\r\n{/if}\r\nNumber of credits: <b>{$credits_plan.no_credits}</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after a credits package is ordered. The message can contain information about the credits package status.');
INSERT INTO class_info VALUES ('hu', 'account_removal', 'Your account removal request was sent. Your account will be removed shortly by the site administrator!', 'The message which shows after a user requests an account removal and confirms it using an activation link received in an email.');
INSERT INTO class_info VALUES ('bg', 'ad_publish_status', '{if $nologin && $activation}{* IF LISTING IS PLACED WITHOUT LOGIN AND IT NEEDS ACTIVATION *}\r\nPlease note that your listing is not active! You will shortly receive an email with an activation link. Follow the email instruction to activate your listing.\r\n<br>\r\n\r\n{/if}\r\n{if $manual} {* IF PAYMENT IS REQUIRED AND CHOSEN PAYMENT IS MANUAL *}\r\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n\r\n{elseif $ad_pending}\r\n\r\nYour ad is pending and will be published after it will be verified by administrator!\r\n<br><br>\r\n{elseif !$nologin || !$activation}\r\n\r\nYour ad is published! You can view your listing <a href=\"{$details_link}\">here</a>!\r\n<br><br>\r\n{/if}\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is posted. The message can contain information about ad status.');
INSERT INTO class_info VALUES ('bg', 'ad_options_upgrade_status', '{if $manual}\r\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br><br>\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}<br>\r\n{/if}\r\n\r\nYour ad upgrade details:<br>\r\n\r\nAd ID: <b>#{$ad_id}</b><br>\r\nAd upgrade status: <b>{$status}</b><br>\r\nInvoice no: <b>#{$invoice_no}</b><br>\r\nProcessor: <b>{$processor}</b><br>\r\n{if $featured}Feature Ad: <b>{$featured_price}</b><br>{/if}\r\n{if $highlited}Highlighted Ad: <b>{$highlited_price}</b><br>{/if}\r\n{if $priority}Priority: <b>{$priority_name} {$priority_price}</b><br>{/if}\r\n{if $video}Video: <b>{$video_price}</b><br>{/if}\r\n\r\n{if $discount}Discount: <b>{$discount}</b><br>{/if}\r\nTotal: <b>{$amount_formatted}</b><br><br>\r\n\r\n{if !$nologin}\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>\r\n{/if}', 'The info message which appears after the ad is upgraded. The message can contain information about upgrade status.');
INSERT INTO class_info VALUES ('bg', 'subscription_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $plan_pending}\r\n\r\nYour subscription is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour subscription is active, you can publish ads now!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Subscription details:</b><br/>\r\n<br/>\r\nSubscription: <b>{$plan.name}</b><br/>\r\nPlan price: <b>{$plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n<br/>{/if}\r\nNumber of ads: <b>{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}{/if}</b><br/>\r\nSubscription time: <b>{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</b><br/>\r\nAllowed pictures: <b>{$plan.no_pictures}</b><br/>\r\nWords: <b>{if $plan.no_words}{$plan.no_words}{else}{$unlimited}{/if}</b><br/>\r\nAds availability: <b>{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the subscription is posted. The message can contain information about subscription status.');
INSERT INTO class_info VALUES ('bg', 'buy_store_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen to subscribe is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $pending}\r\n\r\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated<br/><br/>\r\n\r\n{else}\r\n\r\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/><br/>\r\n\r\n{/if}\r\n\r\n<br>\r\n<b>Dealer Page details:</b><br>\r\n<br>\r\nAmount: <b>{$amount_formatted}</b><br>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br>\r\nTotal: <b>{$amount_formatted}</b><br>\r\n{/if}\r\nProcessor: <b>{$processor}</b><br>\r\nDealer Page availability: <b>{if $days}{$days}{else}{$unlimited}{/if} days</b><br>\r\nStatus: <b>{$status}</b>\r\n<br>\r\n\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after the Dealer Page option is chosen and after passing payment. The message can contain information about Dealer Page option status.');
INSERT INTO class_info VALUES ('bg', 'bulk_uploads_info', 'Place here information regarding bulk uploads format.', 'Message which explains to users how to use bulk uploads feature.');
INSERT INTO class_info VALUES ('bg', 'password_recovery_mail_sent', 'An email has been sent to your email address with information how to recover your password.', 'The message the user gets after he submits for retrieving a lost password.');
INSERT INTO class_info VALUES ('bg', 'not_authorized', 'You are not authorized to view this page!<br /> \r\n\r\nPlease <a href=\"login.php\" class=\"info\">login</a> on your account, or if you do not have one, please <a href=\"register.php\" class=\"info\">register</a>!', 'The text which will appear if the person that browse a certain page does not have access to that page (for example access administrator settings pages without being logged as administrator)');
INSERT INTO class_info VALUES ('bg', 'password_recovery_key_invalid', 'You reached this page probably because you followed a link from a message which was sent to you with instructions to choose a password to access this site. However, that link is no longer valid. <br /> \r\n\r\nPlease submit your data again to recover your password!', 'The message shown to a user when trying to retrieve a lost password but the recovery key is invalid.');
INSERT INTO class_info VALUES ('bg', 'fortumo_info', 'Please send the code below to the number ::SHORT_CODE:::<br/> ::KEY:: <br/>You will be charged with: ::AMOUNT::', 'The message which appears when the user chooses to pay with Fortumo SMS payment.');
INSERT INTO class_info VALUES ('bg', 'fortumo_failed', 'The payment failed!', 'The SMS message which is sent back to user when the payment failed. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('bg', 'fortumo_success', 'Payment successful!', 'The SMS message which is sent back to user when the payment succeeded. Please limit to 16 characters!');
INSERT INTO class_info VALUES ('bg', 'buy_credits_status', '{if $manual}{*  ####  Manual payment - edit and add payment method #### *}\r\n\r\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:\r\n\r\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\r\n<br /><br />\r\n\r\n{elseif $credits_pending}\r\n\r\nYour credits purchase is pending and will be shortly be activated after being reviewed by administrator<br/><br/>\r\n\r\n{else}\r\n\r\nYour have successfully purchased extra credits!<br/><br/>\r\n\r\n{/if}\r\n\r\n<b>Credits package details:</b><br/>\r\n<br/>\r\nPackage name: <b>{$credits_plan.name}</b><br/>\r\nPrice: <b>{$credits_plan.price_curr}</b><br/>\r\n{if $discount}\r\nDiscount: <b>{$discount}</b><br/>\r\nTotal: <b>{$amount_formatted}</b><br/>\r\n{/if}\r\nNumber of credits: <b>{$credits_plan.no_credits}</b><br/>\r\nStatus: <b>{$status}</b>\r\n<br/>\r\n<a href=\"{$site_url}/useraccount.php\">Return to your account</a>', 'The info message which appears after a credits package is ordered. The message can contain information about the credits package status.');
INSERT INTO class_info VALUES ('bg', 'account_removal', 'Your account removal request was sent. Your account will be removed shortly by the site administrator!', 'The message which shows after a user requests an account removal and confirms it using an activation link received in an email.');
INSERT INTO class_info VALUES ('ro', 'eu_cookie', 'Acest site foloseste cookie. Prin continuarea navigarii in cadrul site-ului weltcars.com sunteti implicit deacord cu aceste cookie-uri. Citeste mai multe <a href=\"##SITE_URL##/content.php?code=eu_cookie\">aici</a>.', 'The notification which will appear on top of your site informing that your site uses cookies');


#
# Table structure for table `class_instamojo_return`
#

DROP TABLE IF EXISTS `class_instamojo_return`;
CREATE TABLE `class_instamojo_return` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `entirepost` text,
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `ukey` (`ukey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_instamojo_return`
#



#
# Table structure for table `class_instamojo_settings`
#

DROP TABLE IF EXISTS `class_instamojo_settings`;
CREATE TABLE `class_instamojo_settings` (
  `instamojo_api_key` varchar(50) DEFAULT NULL,
  `instamojo_auth_token` varchar(50) DEFAULT NULL,
  `instamojo_salt` varchar(50) DEFAULT NULL,
  `instamojo_test` int(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_instamojo_settings`
#

INSERT INTO class_instamojo_settings VALUES ('', '', '', '0');


#
# Table structure for table `class_invoice_settings`
#

DROP TABLE IF EXISTS `class_invoice_settings`;
CREATE TABLE `class_invoice_settings` (
  `enable_invoices` tinyint(1) DEFAULT '0',
  `seller_details` text,
  `invoice_logo` varchar(100) DEFAULT NULL,
  `user_fields` varchar(150) DEFAULT NULL,
  `custom_text` text,
  `filename` varchar(20) DEFAULT 'invoice'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_invoice_settings`
#

INSERT INTO class_invoice_settings VALUES ('0', '', '', 'contact_name,email', '', 'invoice');


#
# Table structure for table `class_invoices`
#

DROP TABLE IF EXISTS `class_invoices`;
CREATE TABLE `class_invoices` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) DEFAULT NULL,
  `processor` varchar(40) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `payment_action` int(20) NOT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `amount` float DEFAULT NULL,
  `tax` float DEFAULT '0',
  `seller_details` text,
  `invoice_logo` varchar(100) DEFAULT NULL,
  `user_details` varchar(150) DEFAULT NULL,
  `custom_text` text,
  `payment_details` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_invoices`
#



#
# Table structure for table `class_judet`
#

DROP TABLE IF EXISTS `class_judet`;
CREATE TABLE `class_judet` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `dep` int(2) DEFAULT NULL,
  `name` varchar(64) DEFAULT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  KEY `id` (`id`),
  KEY `idx_lang_id` (`lang_id`),
  KEY `idx_dep` (`dep`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_judet`
#

INSERT INTO class_judet VALUES ('7', '1', 'Alba', 'ro');
INSERT INTO class_judet VALUES ('8', '1', 'Arad', 'ro');
INSERT INTO class_judet VALUES ('10', '1', 'Bacau', 'ro');
INSERT INTO class_judet VALUES ('9', '1', 'Arges', 'ro');
INSERT INTO class_judet VALUES ('11', '1', 'Bihor', 'ro');
INSERT INTO class_judet VALUES ('12', '1', 'Bistrita Nasaud', 'ro');
INSERT INTO class_judet VALUES ('13', '1', 'Botosani', 'ro');
INSERT INTO class_judet VALUES ('14', '1', 'Braila', 'ro');
INSERT INTO class_judet VALUES ('15', '1', 'Brasov', 'ro');
INSERT INTO class_judet VALUES ('16', '1', 'Bucuresti', 'ro');
INSERT INTO class_judet VALUES ('17', '1', 'Buzau', 'ro');
INSERT INTO class_judet VALUES ('18', '1', 'Calarasi', 'ro');
INSERT INTO class_judet VALUES ('19', '1', 'Caras Severin', 'ro');
INSERT INTO class_judet VALUES ('20', '1', 'Cluj', 'ro');
INSERT INTO class_judet VALUES ('21', '1', 'Constanta', 'ro');
INSERT INTO class_judet VALUES ('22', '1', 'Covasna', 'ro');
INSERT INTO class_judet VALUES ('23', '1', 'Dambovita', 'ro');
INSERT INTO class_judet VALUES ('24', '1', 'Dolj', 'ro');
INSERT INTO class_judet VALUES ('25', '1', 'Galati', 'ro');
INSERT INTO class_judet VALUES ('26', '1', 'Giurgiu', 'ro');
INSERT INTO class_judet VALUES ('27', '1', 'Gorj', 'ro');
INSERT INTO class_judet VALUES ('28', '1', 'Harghita', 'ro');
INSERT INTO class_judet VALUES ('29', '1', 'Hunedoara', 'ro');
INSERT INTO class_judet VALUES ('30', '1', 'Ialomita', 'ro');
INSERT INTO class_judet VALUES ('31', '1', 'Iasi', 'ro');
INSERT INTO class_judet VALUES ('32', '1', 'Ilfov', 'ro');
INSERT INTO class_judet VALUES ('33', '1', 'Maramures', 'ro');
INSERT INTO class_judet VALUES ('34', '1', 'Mehedinti', 'ro');
INSERT INTO class_judet VALUES ('35', '1', 'Mures', 'ro');
INSERT INTO class_judet VALUES ('36', '1', 'Neamt', 'ro');
INSERT INTO class_judet VALUES ('37', '1', 'Olt', 'ro');
INSERT INTO class_judet VALUES ('38', '1', 'Prahova', 'ro');
INSERT INTO class_judet VALUES ('39', '1', 'Salaj', 'ro');
INSERT INTO class_judet VALUES ('40', '1', 'Satu Mare', 'ro');
INSERT INTO class_judet VALUES ('41', '1', 'Sibiu', 'ro');
INSERT INTO class_judet VALUES ('42', '1', 'Suceava', 'ro');
INSERT INTO class_judet VALUES ('43', '1', 'Teleorman', 'ro');
INSERT INTO class_judet VALUES ('44', '1', 'Timis', 'ro');
INSERT INTO class_judet VALUES ('45', '1', 'Tulcea', 'ro');
INSERT INTO class_judet VALUES ('46', '1', 'Valcea', 'ro');
INSERT INTO class_judet VALUES ('47', '1', 'Vaslui', 'ro');
INSERT INTO class_judet VALUES ('48', '1', 'Vrancea', 'ro');


#
# Table structure for table `class_klarna_return`
#

DROP TABLE IF EXISTS `class_klarna_return`;
CREATE TABLE `class_klarna_return` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `entirepost` text,
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `ukey` (`ukey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_klarna_return`
#



#
# Table structure for table `class_klarna_settings`
#

DROP TABLE IF EXISTS `class_klarna_settings`;
CREATE TABLE `class_klarna_settings` (
  `merchant_id` varchar(20) DEFAULT NULL,
  `sharedSecret` varchar(50) DEFAULT NULL,
  `test` varchar(50) DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `country` varchar(10) DEFAULT NULL,
  `locale` varchar(10) DEFAULT NULL,
  `terms_uri` varchar(200) DEFAULT NULL,
  `payment_desc` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_klarna_settings`
#

INSERT INTO class_klarna_settings VALUES ('200', 'test', '1', 'SEK', 'SE', 'se-se', '', '');


#
# Table structure for table `class_languages`
#

DROP TABLE IF EXISTS `class_languages`;
CREATE TABLE `class_languages` (
  `id` varchar(20) NOT NULL,
  `code` varchar(2) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `image` varchar(50) DEFAULT NULL,
  `characters_map` varchar(50) DEFAULT NULL,
  `default` tinyint(1) DEFAULT '0',
  `enabled` tinyint(1) DEFAULT '1',
  `order_no` int(2) DEFAULT '1',
  `direction` varchar(3) NOT NULL DEFAULT 'ltr',
  PRIMARY KEY (`id`),
  KEY `idx_enabled` (`enabled`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_languages`
#

INSERT INTO class_languages VALUES ('eng', 'en', 'English', 'english.gif', '', '0', '0', '1', 'ltr');
INSERT INTO class_languages VALUES ('esp', 'es', 'Spanish', 'spanish.gif', '', '0', '0', '2', 'ltr');
INSERT INTO class_languages VALUES ('french', 'fr', 'French', 'french.gif', '', '0', '0', '3', 'ltr');
INSERT INTO class_languages VALUES ('italian', 'it', 'Italian', 'italian.gif', '', '0', '0', '4', 'ltr');
INSERT INTO class_languages VALUES ('dutch', 'nl', 'Dutch', 'dutch.gif', '', '0', '0', '5', 'ltr');
INSERT INTO class_languages VALUES ('german', 'de', 'German', 'german.gif', '', '0', '0', '6', 'ltr');
INSERT INTO class_languages VALUES ('portuguese', 'pt', 'Portuguese', 'portuguese.gif', '', '0', '0', '7', 'ltr');
INSERT INTO class_languages VALUES ('ru', 'ru', 'Russian', 'russian.gif', '', '0', '0', '8', 'ltr');
INSERT INTO class_languages VALUES ('arabic', 'ar', 'Arabic', 'sa.gif', '', '0', '0', '9', 'rtl');
INSERT INTO class_languages VALUES ('hebrew', 'he', 'Hebrew', 'hebrew.gif', '', '0', '0', '10', 'ltr');
INSERT INTO class_languages VALUES ('tr', 'tr', 'Turkish', 'turkish.gif', '', '0', '0', '11', 'ltr');
INSERT INTO class_languages VALUES ('ro', 'ro', 'Romanian', 'romanian.gif', '', '1', '1', '12', 'ltr');
INSERT INTO class_languages VALUES ('greek', 'el', 'Greek', 'greek.gif', '', '0', '0', '13', 'ltr');
INSERT INTO class_languages VALUES ('polish', 'pl', 'Polish', 'polish.gif', '', '0', '0', '14', 'ltr');
INSERT INTO class_languages VALUES ('hr', 'hr', 'Croatian', 'croatian.gif', '', '0', '0', '15', 'ltr');
INSERT INTO class_languages VALUES ('ms', 'ms', 'Malay', 'malay.gif', '', '0', '0', '16', 'ltr');
INSERT INTO class_languages VALUES ('lv', 'lv', 'Latvian', 'latvian.gif', '', '0', '0', '17', 'ltr');
INSERT INTO class_languages VALUES ('hu', 'hu', 'Hungarian', 'hungarian.gif', '', '0', '0', '18', 'ltr');
INSERT INTO class_languages VALUES ('bg', 'bg', 'Bulgarian', 'bulgarian.gif', '', '0', '0', '19', 'ltr');
INSERT INTO class_languages VALUES ('afr', 'af', 'Afrikaans', 'afrikaans.gif', '', '0', '0', '20', 'ltr');
INSERT INTO class_languages VALUES ('danish', 'da', 'Danish', 'danish.gif', '', '0', '0', '21', 'ltr');
INSERT INTO class_languages VALUES ('nor', 'no', 'Norwegian', 'norwegian.gif', '', '0', '0', '22', 'ltr');


#
# Table structure for table `class_location_no_ads`
#

DROP TABLE IF EXISTS `class_location_no_ads`;
CREATE TABLE `class_location_no_ads` (
  `field` varchar(64) NOT NULL,
  `val` varchar(64) NOT NULL,
  `no` int(10) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_location_no_ads`
#



#
# Table structure for table `class_login_history`
#

DROP TABLE IF EXISTS `class_login_history`;
CREATE TABLE `class_login_history` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `auth_name` varchar(60) DEFAULT NULL,
  `date_login` datetime DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `succeeded` tinyint(1) DEFAULT '0',
  `blocked` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_auth_name` (`auth_name`),
  KEY `idx_date` (`date_login`)
) ENGINE=MyISAM AUTO_INCREMENT=161 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_login_history`
#

INSERT INTO class_login_history VALUES ('123', 'admin', '2017-03-07 00:00:53', '85.120.67.173', '1', '0');
INSERT INTO class_login_history VALUES ('158', 'admin', '2017-03-26 13:37:01', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('157', 'admin', '2017-03-25 09:48:57', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('155', 'admin', '2017-03-24 09:11:44', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('156', 'admin', '2017-03-24 12:52:44', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('153', 'admin', '2017-03-22 07:39:04', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('154', 'admin', '2017-03-23 17:51:05', '85.120.67.173', '1', '0');
INSERT INTO class_login_history VALUES ('129', 'test', '2017-03-10 11:38:01', '94.53.210.21', '0', '0');
INSERT INTO class_login_history VALUES ('124', 'admin', '2017-03-07 08:53:17', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('121', 'admin', '2017-03-05 21:21:58', '85.120.67.173', '1', '0');
INSERT INTO class_login_history VALUES ('120', 'admin', '2017-03-04 18:04:11', '85.120.67.173', '1', '0');
INSERT INTO class_login_history VALUES ('160', 'admin', '2017-04-03 08:14:59', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('122', 'admin', '2017-03-06 10:13:27', '109.166.138.140', '1', '0');
INSERT INTO class_login_history VALUES ('128', 'test', '2017-03-10 11:37:58', '94.53.210.21', '0', '0');
INSERT INTO class_login_history VALUES ('127', 'admin', '2017-03-10 11:36:29', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('126', 'admin', '2017-03-10 11:03:37', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('125', 'admin', '2017-03-09 15:38:20', '85.120.67.173', '1', '0');
INSERT INTO class_login_history VALUES ('142', 'admin', '2017-03-12 00:43:16', '85.120.67.173', '1', '0');
INSERT INTO class_login_history VALUES ('144', 'admin', '2017-03-13 09:10:15', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('149', 'admin', '2017-03-15 18:17:59', '85.120.67.173', '1', '0');
INSERT INTO class_login_history VALUES ('148', 'admin', '2017-03-15 12:05:00', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('151', 'admin', '2017-03-16 09:55:00', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('150', 'admin', '2017-03-16 07:21:05', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('152', 'admin', '2017-03-17 13:51:00', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('159', 'admin', '2017-03-28 07:10:27', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('130', 'admin', '2017-03-10 11:38:08', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('131', 'test', '2017-03-10 11:38:32', '94.53.210.21', '0', '0');
INSERT INTO class_login_history VALUES ('132', 'test', '2017-03-10 11:38:34', '94.53.210.21', '0', '0');
INSERT INTO class_login_history VALUES ('133', 'admin', '2017-03-10 11:38:42', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('134', 'test', '2017-03-10 11:39:15', '94.53.210.21', '0', '0');
INSERT INTO class_login_history VALUES ('135', 'test', '2017-03-10 11:39:16', '94.53.210.21', '0', '0');
INSERT INTO class_login_history VALUES ('136', 'test', '2017-03-10 11:39:25', '94.53.210.21', '0', '0');
INSERT INTO class_login_history VALUES ('137', 'admin', '2017-03-10 11:39:37', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('138', 'test', '2017-03-10 11:39:53', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('139', 'admin', '2017-03-10 11:41:16', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('140', 'test', '2017-03-10 11:41:32', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('141', 'admin', '2017-03-10 11:42:04', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('143', 'admin', '2017-03-12 17:21:55', '5.2.177.248', '1', '0');
INSERT INTO class_login_history VALUES ('145', 'admin', '2017-03-14 10:08:00', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('146', 'admin', '2017-03-14 10:19:41', '94.53.210.21', '1', '0');
INSERT INTO class_login_history VALUES ('147', 'admin', '2017-03-14 11:32:34', '94.53.210.21', '1', '0');


#
# Table structure for table `class_mails`
#

DROP TABLE IF EXISTS `class_mails`;
CREATE TABLE `class_mails` (
  `lang_id` varchar(20) DEFAULT 'eng',
  `code` varchar(50) NOT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `content` text,
  `info` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_mails`
#

INSERT INTO class_mails VALUES ('eng', 'registration', 'Your account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration with this account on {$site_name}<br/>\n{else}\nYour account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>{if isset($phone) && $phone}Phone number: <strong>{$phone}</strong><br/>{/if}<br/>\n\n{if $activation==1}{*    ### If the account needs activation    ###  *}\nTo activate your account please go to the following link:<br/>\n{$link}<br/><br/>\n{elseif $activation==2}You should receive an SMS on your phone containing an activation code. If you skipped the activation process after registration, access the following link and enter the activation code in the box:<br/>\n{$link}<br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after registration with account information and account activation link if the case.');
INSERT INTO class_mails VALUES ('eng', 'mailto', '{$site_name} new message', 'Hello {$contact_name},<br/><br/>\n\n<strong>{$sender_name}</strong> is interested in your listing below: <br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nSender email: <br/>\n<font color=\"#2995b5\">{$sender_email}</font><br/><br/>\n', 'The email sent to a listing owner when a guest fills in the contact user form attached to every ad.');
INSERT INTO class_mails VALUES ('eng', 'recommend_ad', '{$sender_name} recommended you this ad!', 'Hello <strong>{$name}</strong>,<br/><br/>\n\n<strong>{$sender_name}</strong> thought you would be interested in the following resource:<br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nBest Regards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/><br/>\n', 'The email which is sent to the when a user or guest recommends an ad to a friend using the \"Share\" link on every ad details page.');
INSERT INTO class_mails VALUES ('eng', 'password_recovery', 'Password recovery for {$site_name}', 'To initiate the process for resetting the password for your {$site_name} account, visit the link below:<br/><br/>\n\n{$link}<br/><br/>\n', 'The email which a user receives after initiating a password recovery process.');
INSERT INTO class_mails VALUES ('eng', 'listing_expired', 'Your listing on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour listing with the id #{$ad_id} expired!<br/><br/>\n\nIf you want to renew your listing please go to your account \"Browse Listings\" section and use the \"Renew\" icon assigned to this ad, or use the following link: <br/>\n{$renew_link} <br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives after a listing expired.');
INSERT INTO class_mails VALUES ('eng', 'listing_will_expire', 'Your listing on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your listing will expire in {$days_expire} days!<br/><br/>\n\nIf you want to renew your listing, you can renew it from your account after it expires, or if you want to renew it before it expires you can use the following link:<br/>\n{$renew_link}<br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives before a listing expires.');
INSERT INTO class_mails VALUES ('eng', 'admin_announce_pending', 'New {$processor} pending on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n{if $ad_id && $ad_pending} {* ---- announce pending listing -------- *}\n<tr><td>Pending Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n{/if}\n{if $plan.type==\"sub\" && $plan_pending} {* ---- announce pending subscription -------- *}\n<tr><td>Pending Plan:</td><td class=\"right\">#{$plan_name}</td></tr>\n{/if}\n{if $credits_pending} {* ---- announce pending credits package -------- *}\n<tr><td>Pending credits package:</td><td class=\"right\">#{$credits_plan_name}</td></tr>\n{/if}\n{if $upgrade}\n<tr><td>Pending Upgrades for Ad ID:</td><td class=\"right\">#{$ad_id}</td>\n{/if}\n{if $store}\n<tr><td>Pending Dealer Page for user:</td><td class=\"right\">#{$username}</td></tr>\n{/if}\n</table><br/><br/>\n', 'The email sent to administrator to notify a pending action: new ad, subscription, upgrade ad etc.');
INSERT INTO class_mails VALUES ('eng', 'admin_new_account', 'New {if $user.affiliate}affiliate {/if}user registered on {$site_name}', 'A new {if $user.affiliate}affiliate {/if}user registered on <strong>{$site_name}</strong><br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Account Details</td></tr>\n{if $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>{else}<tr><td>Email:</td><td class=\"right\">{$email}</td></tr>{/if}\n<tr><td>Group:</td><td class=\"right\">{$group}</td></tr>\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n', 'The email which is sent to the administrator to notify a new user registered.');
INSERT INTO class_mails VALUES ('eng', 'report_ad', 'Report Abusive Ad on {$site_name}', 'The following ad was reported as abusive:<br/>\n{$ad_link}<br/><br/>\n\nThe report was sent by:<br/>\nName: <strong>{$name}</strong><br/>\nEmail: <strong>{$email}</strong><br/>\nComments: {$message}<br/><br/>\n', 'The email sent to admin when someone reports an ad as abusive');
INSERT INTO class_mails VALUES ('eng', 'ad_publish_status', 'Your listing on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $nologin && $activation}{* ------- Text which appears when the ad is placed without login and it requires activation -------- *}\n{if $activation==1}\nIMPORTANT! Your ad is not yet active. To activate your ad, click the link below or copy and paste the entire link into your web browser:<br/>\n{$activation_link}<br/>\n{else}\nIMPORTANT! Your listing requires SMS activation. You should have received a code via SMS. If you skipped this step after posting your listing, then in order to activate it, click on the link below and enter the activation code you received via SMS:<br/>\n{$activation_link}<br/>\n{/if}\n{/if}\n{if $manual}\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $ad_pending}\nYour ad is pending and will be published after the administrator review!<br/>\n\n{elseif $active}\nYour ad is published!<br/>\n\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Ad Details</td></tr>\n<tr><td>ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Plan:</td><td class=\"right\">{$plan_name}</td></tr>\n{if $plan.amount}<tr><td>Plan amount:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $featured || $highlited || $priority || $video}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff;\">Options</td></tr>\n{if $featured}<tr><td>Featured</td><td class=\"right\">{$featured_price}</td></tr>{/if}\n{if $highlited}<tr><td>Highlighted</td><td class=\"right\">{$highlited_price}</td></tr>{/if}\n{if $priority}<tr><td>Priority</td><td class=\"right\">{$priority_name} - {$priority_price}</td></tr>{/if}\n{if $video}<tr><td>Video</td><td class=\"right\">{$video_price}</td></tr>{/if}{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>{/if}\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $amount}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>{/if}\n{/if}\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n{if $amount}<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\n{if $nologin && !$activation} {* send management link if posted without login *}\nYou can use the following link to manage your listing:<br/>\n{$details_link}<br/>\n{elseif !$nologin}\nView your listing details: <br/>\n{$details_link}<br/>\n{/if}\n<br/>\n\n{if $plan.type==\"sub\" && $new_subscription}  {* - details if new subscription - *}\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Plan name:</td><td class=\"right\">{$plan.name}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$plan.price_curr}</td></tr>\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n</table><br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the listing owner after the listing is posted. The email contains information about the ad status.');
INSERT INTO class_mails VALUES ('eng', 'ad_options_upgrade_status', 'Listing upgrade status on {$site_name}', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\n{if $manual}\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/><br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{/if}\n\nYour ad upgrade request has been registered. You can see below the status of your upgrade:<br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Status</td></tr>\n<tr><td class=\"right\">Ad ID:</td><td>#{$ad_id}\n<tr><td class=\"right\">Ad upgrade status:</td><td>{$status}</td></tr>\n<tr><td class=\"right\">Invoice no:</td><td>#{$invoice_no}</td></tr>\n{if $amount}\n<tr><td class=\"right\">Processor:</td><td>{$processor}</td></tr>\n{/if}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade options</td></tr>\n{if $featured}\n<tr><td>Feature Ad:</td><td class=\"right\">{$featured_price}</td></tr>\n{/if}\n{if $highlited}\n<tr><td>Highlighted Ad:</td><td class=\"right\">{$highlited_price}</td></tr>\n{/if}\n{if $priority}\n<tr><td>Priority:</td><td class=\"right\">{$priority_name} {$priority_price}</td></tr>\n{/if}\n{if $video}\n<tr><td>Video:</td><td class=\"right\">{$video_price}</td></tr>\n{/if}\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n{/if}\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after a listing is upgraded. The email contains information about the upgrade status.');
INSERT INTO class_mails VALUES ('eng', 'subscription_status', 'Your subscription on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $plan_pending}\nYour subscription is pending and will be shortly activated by administrator.<br/>\n{else}\nYour subscription is active and you can start publishing ads.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Subscription:</td><td class=\"right\">{$plan.name}</td></tr>\n{if $plan_price}<tr><td>Plan price:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n{if $processor}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n{/if}\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a subscription is ordered. The email contains information about the subscription status.');
INSERT INTO class_mails VALUES ('eng', 'subscription_expired', 'Your subscription on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\n{if $time_expired}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> expired!<br/><br/>\n{else}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> reached the maximum number or ads allowed and was deactivated!\n<br/><br/>\n{/if}\n\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('eng', 'subscription_will_expire', 'Your subscription on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your subscription  with the id <strong>#{$subscription_id}</strong> will expire in {$days_expire} days!<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives before a subscription expires.');
INSERT INTO class_mails VALUES ('eng', 'store_expired', 'Your Dealer Page on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour Dealer Page feature expired! <br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives after the Dealer Page expires.');
INSERT INTO class_mails VALUES ('eng', 'ad_options_expired', 'Your ad options on {$site_name} expired', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\nYour following ad options for ad id #{$id} expired: {$expired_options}!<br/><br/>\n\nView the content of your ad: <br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('eng', 'buy_store_status', 'Your Dealer Page on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $store_pending}\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated.<br/>\n\n{else}\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/>\n\n{/if}\n<br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Dealer Page details:</td></tr>\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n{/if}\n{/if}\n<tr><td>Dealer Page availability:</td><td class=\"right\">{if $days}{$days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Dealer Page status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after choosing Dealer Page option for an account. The email contains information about the Dealer Page option status.');
INSERT INTO class_mails VALUES ('eng', 'email_alert', '{$site_name} {if $no>1}{$no} new listings{else}1 new listing{/if} for {$search}', 'Hello,<br/><br/>\n\nThere {if $no>1}are {$no} new listings{else}is 1 new listing{/if} for <strong>{$search}</strong>!<br/><br/>\n\nPlease click the following link to see the  new {if $no==1}listing{else}listings{/if} for your search:<br/><br/>\n\n{$link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives when new listings appear for the alert search terms.');
INSERT INTO class_mails VALUES ('eng', 'email_alert_confirmation', 'Your email alert for {$search}', 'Hello,<br/><br/>\n\nYou asked to be announced when something new comes up on <font color=\"#2995b5\">{$site_name}</font> for the following search:<br/>\n<strong>{$search}</strong><br/><br/>\n{if $confirmation}\nPlease confirm your email alert by clicking on the link below.<br/>\n\n{$confirmation_link}<br/><br/>\n{/if}\nIf you want to stop receiving email alerts please use the unsubscribe link below:<br/>\n\n{$unsubscribe_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The confirmation email which a user receives when choosing to subscribe for an email alert. This email will contain instructions how to activate the alert (is not already active) and how to disable the alert.');
INSERT INTO class_mails VALUES ('eng', 'ad_options_upgrade_done', 'Your ad upgrade', 'Hello {$contact_name},<br/><br/>\n\nYour listing #{$ad_id} was successfully upgraded with the following options:<br/><br/>\n\n<table width=\"400\">\n<tr><td style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Details</td></tr>\n{if $featured}<tr><td class=\"right\">Featured</td></tr>{/if}\n{if $highlited}<tr><td class=\"right\">Highlighted</td></tr>{/if}\n{if $video}<tr><td class=\"right\">Video Classifieds</td></tr>{/if}\n{if $priority}<tr><td class=\"right\">Priority: {$priority}</td></tr>{/if}\n</table><br/><br/>\n\nView your listing details page:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The info message which appears after the ad upgrade was accepted by administrator. The message will contain information about upgrade status.');
INSERT INTO class_mails VALUES ('eng', 'new_comment', 'New comment for listing #{$ad_id}', 'Hello {$contact_name},<br/><br/>\n\nYou have a new comment for listing #{$ad_id}:<br/><br/>\n\n{$message}<br/><br/>\n\nPosted by: {$contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces a new comment');
INSERT INTO class_mails VALUES ('eng', 'admin_new_ad', 'New listing on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n<tr><td>Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n</table><br/><br/>\n', 'The email sent to administrator to notify a new listing');
INSERT INTO class_mails VALUES ('eng', 'reply', 'Message reply on {$site_name}', 'A new reply has been made on {$site_name}:<br/><br/>{$message}', 'The email which a user receives when a reply is made for a message');
INSERT INTO class_mails VALUES ('eng', 'report_message', 'Message id {$id} reported as spam', 'The message id {$id} was reported as spam.', 'The message the administrator receives when a user reports a message as spam.');
INSERT INTO class_mails VALUES ('eng', 'buy_credits_status', 'Your credits purchase on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $credits_pending}\nYour credits purchase is pending and will be shortly activated by administrator.<br/>\n{else}\nYou have successfully purchased extra credits.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Credits package details</td></tr>\n<tr><td>Package name:</td><td class=\"right\">{$credits_plan.name}</td></tr>\n<tr><td>Price:</td><td class=\"right\">{$credits_plan.price_curr}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}<tr><td>Number of credits:</td><td class=\"right\">{$credits_plan.no_credits}</td></tr>\n<tr><td>Package status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a credits package is ordered. The email contains information about the credits package status.');
INSERT INTO class_mails VALUES ('eng', 'account_removal', 'Account removal request', 'An account removal request was filed for your account. <br/><br/>\n\n<font color=\"f00\">Note that this action will result in the complete removal of your user account and user details from our site, as well as the complete removal of any listings added with this account!</font><br/><br/>\n\nTo confirm it, please click on the link below:<br/>\n{$removal_link}<br/><br/>\n\nIf you did not intended to remove your account please disregard this email.<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message sent to the user when the account removal is asked. It asks for confirmation for the removal process.');
INSERT INTO class_mails VALUES ('eng', 'admin_account_removal', 'Account removal requested for user id #{$id}', 'An account removal was requested for user id #{$id}.<br/><br/>\n\n{if $enable_username}Username: {$user.username}{else}Email: {$user.email}{/if}<br/>\nContact name: {$user.contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the site administrator a request for an account removal.');
INSERT INTO class_mails VALUES ('eng', 'affiliate_registration', 'Your affiliate account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration as an affiliate on {$site_name}<br/>\n{else}\nYour affiliate account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>\nAffiliate id: <strong>{$affiliate_id}</strong><br/>\nAffiliate link: <strong>{$affiliate_link}</strong><br/>\n<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nTo activate your affiliate account please go to the following link:<br/>\n{$link}<br/><br/>\n{else}\n{* -------- PLACE HERE INFORMATION REGARDING PAYMENTS TOWARDS AFFILIATES AND ANY OTHER INFORMATION REGARDING USING THE AFFILIATE ACCOUNT ------- *}\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which an affiliate receives after registration with account information, affiliate link and account activation link if the case.');
INSERT INTO class_mails VALUES ('eng', 'admin_pending_edited', 'Listing #{$ad_id} was modified', 'Listing #{$ad_id} ({$ad_title}) was modified. You can review the listing with the following link:<br/><br/>\n\n{$review_link}<br/>\n', 'The message which announces the administrator that a listing was modified. Only used when Pending Edited option is enabled.');
INSERT INTO class_mails VALUES ('eng', 'pending_edited', 'Your listing modifications were {$action}', 'Hello {$contact_name},<br/><br/>\n\nYour listing id #{$ad_id} ({$ad_title}) changes were {$action} by administrator:<br/><br/>\n\n{$details_link}\n<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the user that its modified listing was accepted or denied by the site administrator');
INSERT INTO class_mails VALUES ('eng', 'new_auction_bid', 'New auction bid for your listing #{$ad_id} on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\nA new bid was made for your listing #{$ad_id} ({$ad_title}):<br/><br/>\n\n{$message}<br/>\n<br/>\nPosted by: {$sender_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message that announces a new auction bid for a listing');
INSERT INTO class_mails VALUES ('esp', 'registration', 'Your account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration with this account on {$site_name}<br/>\n{else}\nYour account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>{if isset($phone) && $phone}Phone number: <strong>{$phone}</strong><br/>{/if}<br/>\n\n{if $activation==1}{*    ### If the account needs activation    ###  *}\nTo activate your account please go to the following link:<br/>\n{$link}<br/><br/>\n{elseif $activation==2}You should receive an SMS on your phone containing an activation code. If you skipped the activation process after registration, access the following link and enter the activation code in the box:<br/>\n{$link}<br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after registration with account information and account activation link if the case.');
INSERT INTO class_mails VALUES ('esp', 'mailto', '{$site_name} new message', 'Hello {$contact_name},<br/><br/>\n\n<strong>{$sender_name}</strong> is interested in your listing below: <br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nSender email: <br/>\n<font color=\"#2995b5\">{$sender_email}</font><br/><br/>\n', 'The email sent to a listing owner when a guest fills in the contact user form attached to every ad.');
INSERT INTO class_mails VALUES ('esp', 'recommend_ad', '{$sender_name} recommended you this ad!', 'Hello <strong>{$name}</strong>,<br/><br/>\n\n<strong>{$sender_name}</strong> thought you would be interested in the following resource:<br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nBest Regards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/><br/>\n', 'The email which is sent to the when a user or guest recommends an ad to a friend using the \"Share\" link on every ad details page.');
INSERT INTO class_mails VALUES ('esp', 'password_recovery', 'Password recovery for {$site_name}', 'To initiate the process for resetting the password for your {$site_name} account, visit the link below:<br/><br/>\n\n{$link}<br/><br/>\n', 'The email which a user receives after initiating a password recovery process.');
INSERT INTO class_mails VALUES ('esp', 'listing_expired', 'Your listing on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour listing with the id #{$ad_id} expired!<br/><br/>\n\nIf you want to renew your listing please go to your account \"Browse Listings\" section and use the \"Renew\" icon assigned to this ad, or use the following link: <br/>\n{$renew_link} <br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives after a listing expired.');
INSERT INTO class_mails VALUES ('esp', 'listing_will_expire', 'Your listing on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your listing will expire in {$days_expire} days!<br/><br/>\n\nIf you want to renew your listing, you can renew it from your account after it expires, or if you want to renew it before it expires you can use the following link:<br/>\n{$renew_link}<br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives before a listing expires.');
INSERT INTO class_mails VALUES ('esp', 'admin_announce_pending', 'New {$processor} pending on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n{if $ad_id && $ad_pending} {* ---- announce pending listing -------- *}\n<tr><td>Pending Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n{/if}\n{if $plan.type==\"sub\" && $plan_pending} {* ---- announce pending subscription -------- *}\n<tr><td>Pending Plan:</td><td class=\"right\">#{$plan_name}</td></tr>\n{/if}\n{if $credits_pending} {* ---- announce pending credits package -------- *}\n<tr><td>Pending credits package:</td><td class=\"right\">#{$credits_plan_name}</td></tr>\n{/if}\n{if $upgrade}\n<tr><td>Pending Upgrades for Ad ID:</td><td class=\"right\">#{$ad_id}</td>\n{/if}\n{if $store}\n<tr><td>Pending Dealer Page for user:</td><td class=\"right\">#{$username}</td></tr>\n{/if}\n</table><br/><br/>\n', 'The email sent to administrator to notify a pending action: new ad, subscription, upgrade ad etc.');
INSERT INTO class_mails VALUES ('esp', 'admin_new_account', 'New {if $user.affiliate}affiliate {/if}user registered on {$site_name}', 'A new {if $user.affiliate}affiliate {/if}user registered on <strong>{$site_name}</strong><br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Account Details</td></tr>\n{if $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>{else}<tr><td>Email:</td><td class=\"right\">{$email}</td></tr>{/if}\n<tr><td>Group:</td><td class=\"right\">{$group}</td></tr>\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n', 'The email which is sent to the administrator to notify a new user registered.');
INSERT INTO class_mails VALUES ('esp', 'report_ad', 'Report Abusive Ad on {$site_name}', 'The following ad was reported as abusive:<br/>\n{$ad_link}<br/><br/>\n\nThe report was sent by:<br/>\nName: <strong>{$name}</strong><br/>\nEmail: <strong>{$email}</strong><br/>\nComments: {$message}<br/><br/>\n', 'The email sent to admin when someone reports an ad as abusive');
INSERT INTO class_mails VALUES ('esp', 'ad_publish_status', 'Your listing on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $nologin && $activation}{* ------- Text which appears when the ad is placed without login and it requires activation -------- *}\n{if $activation==1}\nIMPORTANT! Your ad is not yet active. To activate your ad, click the link below or copy and paste the entire link into your web browser:<br/>\n{$activation_link}<br/>\n{else}\nIMPORTANT! Your listing requires SMS activation. You should have received a code via SMS. If you skipped this step after posting your listing, then in order to activate it, click on the link below and enter the activation code you received via SMS:<br/>\n{$activation_link}<br/>\n{/if}\n{/if}\n{if $manual}\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $ad_pending}\nYour ad is pending and will be published after the administrator review!<br/>\n\n{elseif $active}\nYour ad is published!<br/>\n\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Ad Details</td></tr>\n<tr><td>ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Plan:</td><td class=\"right\">{$plan_name}</td></tr>\n{if $plan.amount}<tr><td>Plan amount:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $featured || $highlited || $priority || $video}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff;\">Options</td></tr>\n{if $featured}<tr><td>Featured</td><td class=\"right\">{$featured_price}</td></tr>{/if}\n{if $highlited}<tr><td>Highlighted</td><td class=\"right\">{$highlited_price}</td></tr>{/if}\n{if $priority}<tr><td>Priority</td><td class=\"right\">{$priority_name} - {$priority_price}</td></tr>{/if}\n{if $video}<tr><td>Video</td><td class=\"right\">{$video_price}</td></tr>{/if}{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>{/if}\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $amount}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>{/if}\n{/if}\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n{if $amount}<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\n{if $nologin && !$activation} {* send management link if posted without login *}\nYou can use the following link to manage your listing:<br/>\n{$details_link}<br/>\n{elseif !$nologin}\nView your listing details: <br/>\n{$details_link}<br/>\n{/if}\n<br/>\n\n{if $plan.type==\"sub\" && $new_subscription}  {* - details if new subscription - *}\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Plan name:</td><td class=\"right\">{$plan.name}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$plan.price_curr}</td></tr>\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n</table><br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the listing owner after the listing is posted. The email contains information about the ad status.');
INSERT INTO class_mails VALUES ('esp', 'ad_options_upgrade_status', 'Listing upgrade status on {$site_name}', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\n{if $manual}\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/><br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{/if}\n\nYour ad upgrade request has been registered. You can see below the status of your upgrade:<br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Status</td></tr>\n<tr><td class=\"right\">Ad ID:</td><td>#{$ad_id}\n<tr><td class=\"right\">Ad upgrade status:</td><td>{$status}</td></tr>\n<tr><td class=\"right\">Invoice no:</td><td>#{$invoice_no}</td></tr>\n{if $amount}\n<tr><td class=\"right\">Processor:</td><td>{$processor}</td></tr>\n{/if}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade options</td></tr>\n{if $featured}\n<tr><td>Feature Ad:</td><td class=\"right\">{$featured_price}</td></tr>\n{/if}\n{if $highlited}\n<tr><td>Highlighted Ad:</td><td class=\"right\">{$highlited_price}</td></tr>\n{/if}\n{if $priority}\n<tr><td>Priority:</td><td class=\"right\">{$priority_name} {$priority_price}</td></tr>\n{/if}\n{if $video}\n<tr><td>Video:</td><td class=\"right\">{$video_price}</td></tr>\n{/if}\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n{/if}\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after a listing is upgraded. The email contains information about the upgrade status.');
INSERT INTO class_mails VALUES ('esp', 'subscription_status', 'Your subscription on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $plan_pending}\nYour subscription is pending and will be shortly activated by administrator.<br/>\n{else}\nYour subscription is active and you can start publishing ads.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Subscription:</td><td class=\"right\">{$plan.name}</td></tr>\n{if $plan_price}<tr><td>Plan price:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n{if $processor}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n{/if}\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a subscription is ordered. The email contains information about the subscription status.');
INSERT INTO class_mails VALUES ('esp', 'subscription_expired', 'Your subscription on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\n{if $time_expired}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> expired!<br/><br/>\n{else}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> reached the maximum number or ads allowed and was deactivated!\n<br/><br/>\n{/if}\n\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('esp', 'subscription_will_expire', 'Your subscription on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your subscription  with the id <strong>#{$subscription_id}</strong> will expire in {$days_expire} days!<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives before a subscription expires.');
INSERT INTO class_mails VALUES ('esp', 'store_expired', 'Your Dealer Page on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour Dealer Page feature expired! <br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives after the Dealer Page expires.');
INSERT INTO class_mails VALUES ('esp', 'ad_options_expired', 'Your ad options on {$site_name} expired', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\nYour following ad options for ad id #{$id} expired: {$expired_options}!<br/><br/>\n\nView the content of your ad: <br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('esp', 'buy_store_status', 'Your Dealer Page on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $store_pending}\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated.<br/>\n\n{else}\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/>\n\n{/if}\n<br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Dealer Page details:</td></tr>\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n{/if}\n{/if}\n<tr><td>Dealer Page availability:</td><td class=\"right\">{if $days}{$days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Dealer Page status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after choosing Dealer Page option for an account. The email contains information about the Dealer Page option status.');
INSERT INTO class_mails VALUES ('esp', 'email_alert', '{$site_name} {if $no>1}{$no} new listings{else}1 new listing{/if} for {$search}', 'Hello,<br/><br/>\n\nThere {if $no>1}are {$no} new listings{else}is 1 new listing{/if} for <strong>{$search}</strong>!<br/><br/>\n\nPlease click the following link to see the  new {if $no==1}listing{else}listings{/if} for your search:<br/><br/>\n\n{$link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives when new listings appear for the alert search terms.');
INSERT INTO class_mails VALUES ('esp', 'email_alert_confirmation', 'Your email alert for {$search}', 'Hello,<br/><br/>\n\nYou asked to be announced when something new comes up on <font color=\"#2995b5\">{$site_name}</font> for the following search:<br/>\n<strong>{$search}</strong><br/><br/>\n{if $confirmation}\nPlease confirm your email alert by clicking on the link below.<br/>\n\n{$confirmation_link}<br/><br/>\n{/if}\nIf you want to stop receiving email alerts please use the unsubscribe link below:<br/>\n\n{$unsubscribe_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The confirmation email which a user receives when choosing to subscribe for an email alert. This email will contain instructions how to activate the alert (is not already active) and how to disable the alert.');
INSERT INTO class_mails VALUES ('esp', 'ad_options_upgrade_done', 'Your ad upgrade', 'Hello {$contact_name},<br/><br/>\n\nYour listing #{$ad_id} was successfully upgraded with the following options:<br/><br/>\n\n<table width=\"400\">\n<tr><td style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Details</td></tr>\n{if $featured}<tr><td class=\"right\">Featured</td></tr>{/if}\n{if $highlited}<tr><td class=\"right\">Highlighted</td></tr>{/if}\n{if $video}<tr><td class=\"right\">Video Classifieds</td></tr>{/if}\n{if $priority}<tr><td class=\"right\">Priority: {$priority}</td></tr>{/if}\n</table><br/><br/>\n\nView your listing details page:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The info message which appears after the ad upgrade was accepted by administrator. The message will contain information about upgrade status.');
INSERT INTO class_mails VALUES ('esp', 'new_comment', 'New comment for listing #{$ad_id}', 'Hello {$contact_name},<br/><br/>\n\nYou have a new comment for listing #{$ad_id}:<br/><br/>\n\n{$message}<br/><br/>\n\nPosted by: {$contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces a new comment');
INSERT INTO class_mails VALUES ('esp', 'admin_new_ad', 'New listing on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n<tr><td>Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n</table><br/><br/>\n', 'The email sent to administrator to notify a new listing');
INSERT INTO class_mails VALUES ('esp', 'reply', 'Message reply on {$site_name}', 'A new reply has been made on {$site_name}:<br/><br/>{$message}', 'The email which a user receives when a reply is made for a message');
INSERT INTO class_mails VALUES ('esp', 'report_message', 'Message id {$id} reported as spam', 'The message id {$id} was reported as spam.', 'The message the administrator receives when a user reports a message as spam.');
INSERT INTO class_mails VALUES ('esp', 'buy_credits_status', 'Your credits purchase on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $credits_pending}\nYour credits purchase is pending and will be shortly activated by administrator.<br/>\n{else}\nYou have successfully purchased extra credits.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Credits package details</td></tr>\n<tr><td>Package name:</td><td class=\"right\">{$credits_plan.name}</td></tr>\n<tr><td>Price:</td><td class=\"right\">{$credits_plan.price_curr}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}<tr><td>Number of credits:</td><td class=\"right\">{$credits_plan.no_credits}</td></tr>\n<tr><td>Package status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a credits package is ordered. The email contains information about the credits package status.');
INSERT INTO class_mails VALUES ('esp', 'account_removal', 'Account removal request', 'An account removal request was filed for your account. <br/><br/>\n\n<font color=\"f00\">Note that this action will result in the complete removal of your user account and user details from our site, as well as the complete removal of any listings added with this account!</font><br/><br/>\n\nTo confirm it, please click on the link below:<br/>\n{$removal_link}<br/><br/>\n\nIf you did not intended to remove your account please disregard this email.<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message sent to the user when the account removal is asked. It asks for confirmation for the removal process.');
INSERT INTO class_mails VALUES ('esp', 'admin_account_removal', 'Account removal requested for user id #{$id}', 'An account removal was requested for user id #{$id}.<br/><br/>\n\n{if $enable_username}Username: {$user.username}{else}Email: {$user.email}{/if}<br/>\nContact name: {$user.contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the site administrator a request for an account removal.');
INSERT INTO class_mails VALUES ('esp', 'affiliate_registration', 'Your affiliate account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration as an affiliate on {$site_name}<br/>\n{else}\nYour affiliate account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>\nAffiliate id: <strong>{$affiliate_id}</strong><br/>\nAffiliate link: <strong>{$affiliate_link}</strong><br/>\n<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nTo activate your affiliate account please go to the following link:<br/>\n{$link}<br/><br/>\n{else}\n{* -------- PLACE HERE INFORMATION REGARDING PAYMENTS TOWARDS AFFILIATES AND ANY OTHER INFORMATION REGARDING USING THE AFFILIATE ACCOUNT ------- *}\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which an affiliate receives after registration with account information, affiliate link and account activation link if the case.');
INSERT INTO class_mails VALUES ('esp', 'admin_pending_edited', 'Listing #{$ad_id} was modified', 'Listing #{$ad_id} ({$ad_title}) was modified. You can review the listing with the following link:<br/><br/>\n\n{$review_link}<br/>\n', 'The message which announces the administrator that a listing was modified. Only used when Pending Edited option is enabled.');
INSERT INTO class_mails VALUES ('esp', 'pending_edited', 'Your listing modifications were {$action}', 'Hello {$contact_name},<br/><br/>\n\nYour listing id #{$ad_id} ({$ad_title}) changes were {$action} by administrator:<br/><br/>\n\n{$details_link}\n<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the user that its modified listing was accepted or denied by the site administrator');
INSERT INTO class_mails VALUES ('esp', 'new_auction_bid', 'New auction bid for your listing #{$ad_id} on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\nA new bid was made for your listing #{$ad_id} ({$ad_title}):<br/><br/>\n\n{$message}<br/>\n<br/>\nPosted by: {$sender_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message that announces a new auction bid for a listing');
INSERT INTO class_mails VALUES ('french', 'registration', 'Your account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration with this account on {$site_name}<br/>\n{else}\nYour account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>{if isset($phone) && $phone}Phone number: <strong>{$phone}</strong><br/>{/if}<br/>\n\n{if $activation==1}{*    ### If the account needs activation    ###  *}\nTo activate your account please go to the following link:<br/>\n{$link}<br/><br/>\n{elseif $activation==2}You should receive an SMS on your phone containing an activation code. If you skipped the activation process after registration, access the following link and enter the activation code in the box:<br/>\n{$link}<br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after registration with account information and account activation link if the case.');
INSERT INTO class_mails VALUES ('french', 'mailto', '{$site_name} new message', 'Hello {$contact_name},<br/><br/>\n\n<strong>{$sender_name}</strong> is interested in your listing below: <br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nSender email: <br/>\n<font color=\"#2995b5\">{$sender_email}</font><br/><br/>\n', 'The email sent to a listing owner when a guest fills in the contact user form attached to every ad.');
INSERT INTO class_mails VALUES ('french', 'recommend_ad', '{$sender_name} recommended you this ad!', 'Hello <strong>{$name}</strong>,<br/><br/>\n\n<strong>{$sender_name}</strong> thought you would be interested in the following resource:<br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nBest Regards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/><br/>\n', 'The email which is sent to the when a user or guest recommends an ad to a friend using the \"Share\" link on every ad details page.');
INSERT INTO class_mails VALUES ('french', 'password_recovery', 'Password recovery for {$site_name}', 'To initiate the process for resetting the password for your {$site_name} account, visit the link below:<br/><br/>\n\n{$link}<br/><br/>\n', 'The email which a user receives after initiating a password recovery process.');
INSERT INTO class_mails VALUES ('french', 'listing_expired', 'Your listing on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour listing with the id #{$ad_id} expired!<br/><br/>\n\nIf you want to renew your listing please go to your account \"Browse Listings\" section and use the \"Renew\" icon assigned to this ad, or use the following link: <br/>\n{$renew_link} <br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives after a listing expired.');
INSERT INTO class_mails VALUES ('french', 'listing_will_expire', 'Your listing on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your listing will expire in {$days_expire} days!<br/><br/>\n\nIf you want to renew your listing, you can renew it from your account after it expires, or if you want to renew it before it expires you can use the following link:<br/>\n{$renew_link}<br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives before a listing expires.');
INSERT INTO class_mails VALUES ('french', 'admin_announce_pending', 'New {$processor} pending on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n{if $ad_id && $ad_pending} {* ---- announce pending listing -------- *}\n<tr><td>Pending Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n{/if}\n{if $plan.type==\"sub\" && $plan_pending} {* ---- announce pending subscription -------- *}\n<tr><td>Pending Plan:</td><td class=\"right\">#{$plan_name}</td></tr>\n{/if}\n{if $credits_pending} {* ---- announce pending credits package -------- *}\n<tr><td>Pending credits package:</td><td class=\"right\">#{$credits_plan_name}</td></tr>\n{/if}\n{if $upgrade}\n<tr><td>Pending Upgrades for Ad ID:</td><td class=\"right\">#{$ad_id}</td>\n{/if}\n{if $store}\n<tr><td>Pending Dealer Page for user:</td><td class=\"right\">#{$username}</td></tr>\n{/if}\n</table><br/><br/>\n', 'The email sent to administrator to notify a pending action: new ad, subscription, upgrade ad etc.');
INSERT INTO class_mails VALUES ('french', 'admin_new_account', 'New {if $user.affiliate}affiliate {/if}user registered on {$site_name}', 'A new {if $user.affiliate}affiliate {/if}user registered on <strong>{$site_name}</strong><br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Account Details</td></tr>\n{if $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>{else}<tr><td>Email:</td><td class=\"right\">{$email}</td></tr>{/if}\n<tr><td>Group:</td><td class=\"right\">{$group}</td></tr>\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n', 'The email which is sent to the administrator to notify a new user registered.');
INSERT INTO class_mails VALUES ('french', 'report_ad', 'Report Abusive Ad on {$site_name}', 'The following ad was reported as abusive:<br/>\n{$ad_link}<br/><br/>\n\nThe report was sent by:<br/>\nName: <strong>{$name}</strong><br/>\nEmail: <strong>{$email}</strong><br/>\nComments: {$message}<br/><br/>\n', 'The email sent to admin when someone reports an ad as abusive');
INSERT INTO class_mails VALUES ('french', 'ad_publish_status', 'Your listing on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $nologin && $activation}{* ------- Text which appears when the ad is placed without login and it requires activation -------- *}\n{if $activation==1}\nIMPORTANT! Your ad is not yet active. To activate your ad, click the link below or copy and paste the entire link into your web browser:<br/>\n{$activation_link}<br/>\n{else}\nIMPORTANT! Your listing requires SMS activation. You should have received a code via SMS. If you skipped this step after posting your listing, then in order to activate it, click on the link below and enter the activation code you received via SMS:<br/>\n{$activation_link}<br/>\n{/if}\n{/if}\n{if $manual}\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $ad_pending}\nYour ad is pending and will be published after the administrator review!<br/>\n\n{elseif $active}\nYour ad is published!<br/>\n\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Ad Details</td></tr>\n<tr><td>ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Plan:</td><td class=\"right\">{$plan_name}</td></tr>\n{if $plan.amount}<tr><td>Plan amount:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $featured || $highlited || $priority || $video}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff;\">Options</td></tr>\n{if $featured}<tr><td>Featured</td><td class=\"right\">{$featured_price}</td></tr>{/if}\n{if $highlited}<tr><td>Highlighted</td><td class=\"right\">{$highlited_price}</td></tr>{/if}\n{if $priority}<tr><td>Priority</td><td class=\"right\">{$priority_name} - {$priority_price}</td></tr>{/if}\n{if $video}<tr><td>Video</td><td class=\"right\">{$video_price}</td></tr>{/if}{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>{/if}\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $amount}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>{/if}\n{/if}\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n{if $amount}<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\n{if $nologin && !$activation} {* send management link if posted without login *}\nYou can use the following link to manage your listing:<br/>\n{$details_link}<br/>\n{elseif !$nologin}\nView your listing details: <br/>\n{$details_link}<br/>\n{/if}\n<br/>\n\n{if $plan.type==\"sub\" && $new_subscription}  {* - details if new subscription - *}\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Plan name:</td><td class=\"right\">{$plan.name}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$plan.price_curr}</td></tr>\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n</table><br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the listing owner after the listing is posted. The email contains information about the ad status.');
INSERT INTO class_mails VALUES ('french', 'ad_options_upgrade_status', 'Listing upgrade status on {$site_name}', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\n{if $manual}\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/><br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{/if}\n\nYour ad upgrade request has been registered. You can see below the status of your upgrade:<br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Status</td></tr>\n<tr><td class=\"right\">Ad ID:</td><td>#{$ad_id}\n<tr><td class=\"right\">Ad upgrade status:</td><td>{$status}</td></tr>\n<tr><td class=\"right\">Invoice no:</td><td>#{$invoice_no}</td></tr>\n{if $amount}\n<tr><td class=\"right\">Processor:</td><td>{$processor}</td></tr>\n{/if}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade options</td></tr>\n{if $featured}\n<tr><td>Feature Ad:</td><td class=\"right\">{$featured_price}</td></tr>\n{/if}\n{if $highlited}\n<tr><td>Highlighted Ad:</td><td class=\"right\">{$highlited_price}</td></tr>\n{/if}\n{if $priority}\n<tr><td>Priority:</td><td class=\"right\">{$priority_name} {$priority_price}</td></tr>\n{/if}\n{if $video}\n<tr><td>Video:</td><td class=\"right\">{$video_price}</td></tr>\n{/if}\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n{/if}\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after a listing is upgraded. The email contains information about the upgrade status.');
INSERT INTO class_mails VALUES ('french', 'subscription_status', 'Your subscription on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $plan_pending}\nYour subscription is pending and will be shortly activated by administrator.<br/>\n{else}\nYour subscription is active and you can start publishing ads.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Subscription:</td><td class=\"right\">{$plan.name}</td></tr>\n{if $plan_price}<tr><td>Plan price:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n{if $processor}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n{/if}\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a subscription is ordered. The email contains information about the subscription status.');
INSERT INTO class_mails VALUES ('french', 'subscription_expired', 'Your subscription on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\n{if $time_expired}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> expired!<br/><br/>\n{else}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> reached the maximum number or ads allowed and was deactivated!\n<br/><br/>\n{/if}\n\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('french', 'subscription_will_expire', 'Your subscription on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your subscription  with the id <strong>#{$subscription_id}</strong> will expire in {$days_expire} days!<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives before a subscription expires.');
INSERT INTO class_mails VALUES ('french', 'store_expired', 'Your Dealer Page on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour Dealer Page feature expired! <br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives after the Dealer Page expires.');
INSERT INTO class_mails VALUES ('french', 'ad_options_expired', 'Your ad options on {$site_name} expired', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\nYour following ad options for ad id #{$id} expired: {$expired_options}!<br/><br/>\n\nView the content of your ad: <br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('french', 'buy_store_status', 'Your Dealer Page on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $store_pending}\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated.<br/>\n\n{else}\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/>\n\n{/if}\n<br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Dealer Page details:</td></tr>\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n{/if}\n{/if}\n<tr><td>Dealer Page availability:</td><td class=\"right\">{if $days}{$days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Dealer Page status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after choosing Dealer Page option for an account. The email contains information about the Dealer Page option status.');
INSERT INTO class_mails VALUES ('french', 'email_alert', '{$site_name} {if $no>1}{$no} new listings{else}1 new listing{/if} for {$search}', 'Hello,<br/><br/>\n\nThere {if $no>1}are {$no} new listings{else}is 1 new listing{/if} for <strong>{$search}</strong>!<br/><br/>\n\nPlease click the following link to see the  new {if $no==1}listing{else}listings{/if} for your search:<br/><br/>\n\n{$link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives when new listings appear for the alert search terms.');
INSERT INTO class_mails VALUES ('french', 'email_alert_confirmation', 'Your email alert for {$search}', 'Hello,<br/><br/>\n\nYou asked to be announced when something new comes up on <font color=\"#2995b5\">{$site_name}</font> for the following search:<br/>\n<strong>{$search}</strong><br/><br/>\n{if $confirmation}\nPlease confirm your email alert by clicking on the link below.<br/>\n\n{$confirmation_link}<br/><br/>\n{/if}\nIf you want to stop receiving email alerts please use the unsubscribe link below:<br/>\n\n{$unsubscribe_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The confirmation email which a user receives when choosing to subscribe for an email alert. This email will contain instructions how to activate the alert (is not already active) and how to disable the alert.');
INSERT INTO class_mails VALUES ('french', 'ad_options_upgrade_done', 'Your ad upgrade', 'Hello {$contact_name},<br/><br/>\n\nYour listing #{$ad_id} was successfully upgraded with the following options:<br/><br/>\n\n<table width=\"400\">\n<tr><td style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Details</td></tr>\n{if $featured}<tr><td class=\"right\">Featured</td></tr>{/if}\n{if $highlited}<tr><td class=\"right\">Highlighted</td></tr>{/if}\n{if $video}<tr><td class=\"right\">Video Classifieds</td></tr>{/if}\n{if $priority}<tr><td class=\"right\">Priority: {$priority}</td></tr>{/if}\n</table><br/><br/>\n\nView your listing details page:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The info message which appears after the ad upgrade was accepted by administrator. The message will contain information about upgrade status.');
INSERT INTO class_mails VALUES ('french', 'new_comment', 'New comment for listing #{$ad_id}', 'Hello {$contact_name},<br/><br/>\n\nYou have a new comment for listing #{$ad_id}:<br/><br/>\n\n{$message}<br/><br/>\n\nPosted by: {$contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces a new comment');
INSERT INTO class_mails VALUES ('french', 'admin_new_ad', 'New listing on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n<tr><td>Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n</table><br/><br/>\n', 'The email sent to administrator to notify a new listing');
INSERT INTO class_mails VALUES ('french', 'reply', 'Message reply on {$site_name}', 'A new reply has been made on {$site_name}:<br/><br/>{$message}', 'The email which a user receives when a reply is made for a message');
INSERT INTO class_mails VALUES ('french', 'report_message', 'Message id {$id} reported as spam', 'The message id {$id} was reported as spam.', 'The message the administrator receives when a user reports a message as spam.');
INSERT INTO class_mails VALUES ('french', 'buy_credits_status', 'Your credits purchase on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $credits_pending}\nYour credits purchase is pending and will be shortly activated by administrator.<br/>\n{else}\nYou have successfully purchased extra credits.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Credits package details</td></tr>\n<tr><td>Package name:</td><td class=\"right\">{$credits_plan.name}</td></tr>\n<tr><td>Price:</td><td class=\"right\">{$credits_plan.price_curr}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}<tr><td>Number of credits:</td><td class=\"right\">{$credits_plan.no_credits}</td></tr>\n<tr><td>Package status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a credits package is ordered. The email contains information about the credits package status.');
INSERT INTO class_mails VALUES ('french', 'account_removal', 'Account removal request', 'An account removal request was filed for your account. <br/><br/>\n\n<font color=\"f00\">Note that this action will result in the complete removal of your user account and user details from our site, as well as the complete removal of any listings added with this account!</font><br/><br/>\n\nTo confirm it, please click on the link below:<br/>\n{$removal_link}<br/><br/>\n\nIf you did not intended to remove your account please disregard this email.<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message sent to the user when the account removal is asked. It asks for confirmation for the removal process.');
INSERT INTO class_mails VALUES ('french', 'admin_account_removal', 'Account removal requested for user id #{$id}', 'An account removal was requested for user id #{$id}.<br/><br/>\n\n{if $enable_username}Username: {$user.username}{else}Email: {$user.email}{/if}<br/>\nContact name: {$user.contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the site administrator a request for an account removal.');
INSERT INTO class_mails VALUES ('french', 'affiliate_registration', 'Your affiliate account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration as an affiliate on {$site_name}<br/>\n{else}\nYour affiliate account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>\nAffiliate id: <strong>{$affiliate_id}</strong><br/>\nAffiliate link: <strong>{$affiliate_link}</strong><br/>\n<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nTo activate your affiliate account please go to the following link:<br/>\n{$link}<br/><br/>\n{else}\n{* -------- PLACE HERE INFORMATION REGARDING PAYMENTS TOWARDS AFFILIATES AND ANY OTHER INFORMATION REGARDING USING THE AFFILIATE ACCOUNT ------- *}\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which an affiliate receives after registration with account information, affiliate link and account activation link if the case.');
INSERT INTO class_mails VALUES ('french', 'admin_pending_edited', 'Listing #{$ad_id} was modified', 'Listing #{$ad_id} ({$ad_title}) was modified. You can review the listing with the following link:<br/><br/>\n\n{$review_link}<br/>\n', 'The message which announces the administrator that a listing was modified. Only used when Pending Edited option is enabled.');
INSERT INTO class_mails VALUES ('french', 'pending_edited', 'Your listing modifications were {$action}', 'Hello {$contact_name},<br/><br/>\n\nYour listing id #{$ad_id} ({$ad_title}) changes were {$action} by administrator:<br/><br/>\n\n{$details_link}\n<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the user that its modified listing was accepted or denied by the site administrator');
INSERT INTO class_mails VALUES ('french', 'new_auction_bid', 'New auction bid for your listing #{$ad_id} on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\nA new bid was made for your listing #{$ad_id} ({$ad_title}):<br/><br/>\n\n{$message}<br/>\n<br/>\nPosted by: {$sender_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message that announces a new auction bid for a listing');
INSERT INTO class_mails VALUES ('italian', 'registration', 'Your account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration with this account on {$site_name}<br/>\n{else}\nYour account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>{if isset($phone) && $phone}Phone number: <strong>{$phone}</strong><br/>{/if}<br/>\n\n{if $activation==1}{*    ### If the account needs activation    ###  *}\nTo activate your account please go to the following link:<br/>\n{$link}<br/><br/>\n{elseif $activation==2}You should receive an SMS on your phone containing an activation code. If you skipped the activation process after registration, access the following link and enter the activation code in the box:<br/>\n{$link}<br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after registration with account information and account activation link if the case.');
INSERT INTO class_mails VALUES ('italian', 'mailto', '{$site_name} new message', 'Hello {$contact_name},<br/><br/>\n\n<strong>{$sender_name}</strong> is interested in your listing below: <br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nSender email: <br/>\n<font color=\"#2995b5\">{$sender_email}</font><br/><br/>\n', 'The email sent to a listing owner when a guest fills in the contact user form attached to every ad.');
INSERT INTO class_mails VALUES ('italian', 'recommend_ad', '{$sender_name} recommended you this ad!', 'Hello <strong>{$name}</strong>,<br/><br/>\n\n<strong>{$sender_name}</strong> thought you would be interested in the following resource:<br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nBest Regards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/><br/>\n', 'The email which is sent to the when a user or guest recommends an ad to a friend using the \"Share\" link on every ad details page.');
INSERT INTO class_mails VALUES ('italian', 'password_recovery', 'Password recovery for {$site_name}', 'To initiate the process for resetting the password for your {$site_name} account, visit the link below:<br/><br/>\n\n{$link}<br/><br/>\n', 'The email which a user receives after initiating a password recovery process.');
INSERT INTO class_mails VALUES ('italian', 'listing_expired', 'Your listing on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour listing with the id #{$ad_id} expired!<br/><br/>\n\nIf you want to renew your listing please go to your account \"Browse Listings\" section and use the \"Renew\" icon assigned to this ad, or use the following link: <br/>\n{$renew_link} <br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives after a listing expired.');
INSERT INTO class_mails VALUES ('italian', 'listing_will_expire', 'Your listing on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your listing will expire in {$days_expire} days!<br/><br/>\n\nIf you want to renew your listing, you can renew it from your account after it expires, or if you want to renew it before it expires you can use the following link:<br/>\n{$renew_link}<br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives before a listing expires.');
INSERT INTO class_mails VALUES ('italian', 'admin_announce_pending', 'New {$processor} pending on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n{if $ad_id && $ad_pending} {* ---- announce pending listing -------- *}\n<tr><td>Pending Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n{/if}\n{if $plan.type==\"sub\" && $plan_pending} {* ---- announce pending subscription -------- *}\n<tr><td>Pending Plan:</td><td class=\"right\">#{$plan_name}</td></tr>\n{/if}\n{if $credits_pending} {* ---- announce pending credits package -------- *}\n<tr><td>Pending credits package:</td><td class=\"right\">#{$credits_plan_name}</td></tr>\n{/if}\n{if $upgrade}\n<tr><td>Pending Upgrades for Ad ID:</td><td class=\"right\">#{$ad_id}</td>\n{/if}\n{if $store}\n<tr><td>Pending Dealer Page for user:</td><td class=\"right\">#{$username}</td></tr>\n{/if}\n</table><br/><br/>\n', 'The email sent to administrator to notify a pending action: new ad, subscription, upgrade ad etc.');
INSERT INTO class_mails VALUES ('italian', 'admin_new_account', 'New {if $user.affiliate}affiliate {/if}user registered on {$site_name}', 'A new {if $user.affiliate}affiliate {/if}user registered on <strong>{$site_name}</strong><br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Account Details</td></tr>\n{if $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>{else}<tr><td>Email:</td><td class=\"right\">{$email}</td></tr>{/if}\n<tr><td>Group:</td><td class=\"right\">{$group}</td></tr>\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n', 'The email which is sent to the administrator to notify a new user registered.');
INSERT INTO class_mails VALUES ('italian', 'report_ad', 'Report Abusive Ad on {$site_name}', 'The following ad was reported as abusive:<br/>\n{$ad_link}<br/><br/>\n\nThe report was sent by:<br/>\nName: <strong>{$name}</strong><br/>\nEmail: <strong>{$email}</strong><br/>\nComments: {$message}<br/><br/>\n', 'The email sent to admin when someone reports an ad as abusive');
INSERT INTO class_mails VALUES ('italian', 'ad_publish_status', 'Your listing on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $nologin && $activation}{* ------- Text which appears when the ad is placed without login and it requires activation -------- *}\n{if $activation==1}\nIMPORTANT! Your ad is not yet active. To activate your ad, click the link below or copy and paste the entire link into your web browser:<br/>\n{$activation_link}<br/>\n{else}\nIMPORTANT! Your listing requires SMS activation. You should have received a code via SMS. If you skipped this step after posting your listing, then in order to activate it, click on the link below and enter the activation code you received via SMS:<br/>\n{$activation_link}<br/>\n{/if}\n{/if}\n{if $manual}\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $ad_pending}\nYour ad is pending and will be published after the administrator review!<br/>\n\n{elseif $active}\nYour ad is published!<br/>\n\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Ad Details</td></tr>\n<tr><td>ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Plan:</td><td class=\"right\">{$plan_name}</td></tr>\n{if $plan.amount}<tr><td>Plan amount:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $featured || $highlited || $priority || $video}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff;\">Options</td></tr>\n{if $featured}<tr><td>Featured</td><td class=\"right\">{$featured_price}</td></tr>{/if}\n{if $highlited}<tr><td>Highlighted</td><td class=\"right\">{$highlited_price}</td></tr>{/if}\n{if $priority}<tr><td>Priority</td><td class=\"right\">{$priority_name} - {$priority_price}</td></tr>{/if}\n{if $video}<tr><td>Video</td><td class=\"right\">{$video_price}</td></tr>{/if}{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>{/if}\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $amount}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>{/if}\n{/if}\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n{if $amount}<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\n{if $nologin && !$activation} {* send management link if posted without login *}\nYou can use the following link to manage your listing:<br/>\n{$details_link}<br/>\n{elseif !$nologin}\nView your listing details: <br/>\n{$details_link}<br/>\n{/if}\n<br/>\n\n{if $plan.type==\"sub\" && $new_subscription}  {* - details if new subscription - *}\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Plan name:</td><td class=\"right\">{$plan.name}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$plan.price_curr}</td></tr>\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n</table><br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the listing owner after the listing is posted. The email contains information about the ad status.');
INSERT INTO class_mails VALUES ('italian', 'ad_options_upgrade_status', 'Listing upgrade status on {$site_name}', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\n{if $manual}\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/><br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{/if}\n\nYour ad upgrade request has been registered. You can see below the status of your upgrade:<br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Status</td></tr>\n<tr><td class=\"right\">Ad ID:</td><td>#{$ad_id}\n<tr><td class=\"right\">Ad upgrade status:</td><td>{$status}</td></tr>\n<tr><td class=\"right\">Invoice no:</td><td>#{$invoice_no}</td></tr>\n{if $amount}\n<tr><td class=\"right\">Processor:</td><td>{$processor}</td></tr>\n{/if}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade options</td></tr>\n{if $featured}\n<tr><td>Feature Ad:</td><td class=\"right\">{$featured_price}</td></tr>\n{/if}\n{if $highlited}\n<tr><td>Highlighted Ad:</td><td class=\"right\">{$highlited_price}</td></tr>\n{/if}\n{if $priority}\n<tr><td>Priority:</td><td class=\"right\">{$priority_name} {$priority_price}</td></tr>\n{/if}\n{if $video}\n<tr><td>Video:</td><td class=\"right\">{$video_price}</td></tr>\n{/if}\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n{/if}\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after a listing is upgraded. The email contains information about the upgrade status.');
INSERT INTO class_mails VALUES ('italian', 'subscription_status', 'Your subscription on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $plan_pending}\nYour subscription is pending and will be shortly activated by administrator.<br/>\n{else}\nYour subscription is active and you can start publishing ads.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Subscription:</td><td class=\"right\">{$plan.name}</td></tr>\n{if $plan_price}<tr><td>Plan price:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n{if $processor}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n{/if}\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a subscription is ordered. The email contains information about the subscription status.');
INSERT INTO class_mails VALUES ('italian', 'subscription_expired', 'Your subscription on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\n{if $time_expired}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> expired!<br/><br/>\n{else}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> reached the maximum number or ads allowed and was deactivated!\n<br/><br/>\n{/if}\n\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('italian', 'subscription_will_expire', 'Your subscription on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your subscription  with the id <strong>#{$subscription_id}</strong> will expire in {$days_expire} days!<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives before a subscription expires.');
INSERT INTO class_mails VALUES ('italian', 'store_expired', 'Your Dealer Page on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour Dealer Page feature expired! <br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives after the Dealer Page expires.');
INSERT INTO class_mails VALUES ('italian', 'ad_options_expired', 'Your ad options on {$site_name} expired', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\nYour following ad options for ad id #{$id} expired: {$expired_options}!<br/><br/>\n\nView the content of your ad: <br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('italian', 'buy_store_status', 'Your Dealer Page on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $store_pending}\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated.<br/>\n\n{else}\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/>\n\n{/if}\n<br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Dealer Page details:</td></tr>\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n{/if}\n{/if}\n<tr><td>Dealer Page availability:</td><td class=\"right\">{if $days}{$days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Dealer Page status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after choosing Dealer Page option for an account. The email contains information about the Dealer Page option status.');
INSERT INTO class_mails VALUES ('italian', 'email_alert', '{$site_name} {if $no>1}{$no} new listings{else}1 new listing{/if} for {$search}', 'Hello,<br/><br/>\n\nThere {if $no>1}are {$no} new listings{else}is 1 new listing{/if} for <strong>{$search}</strong>!<br/><br/>\n\nPlease click the following link to see the  new {if $no==1}listing{else}listings{/if} for your search:<br/><br/>\n\n{$link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives when new listings appear for the alert search terms.');
INSERT INTO class_mails VALUES ('italian', 'email_alert_confirmation', 'Your email alert for {$search}', 'Hello,<br/><br/>\n\nYou asked to be announced when something new comes up on <font color=\"#2995b5\">{$site_name}</font> for the following search:<br/>\n<strong>{$search}</strong><br/><br/>\n{if $confirmation}\nPlease confirm your email alert by clicking on the link below.<br/>\n\n{$confirmation_link}<br/><br/>\n{/if}\nIf you want to stop receiving email alerts please use the unsubscribe link below:<br/>\n\n{$unsubscribe_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The confirmation email which a user receives when choosing to subscribe for an email alert. This email will contain instructions how to activate the alert (is not already active) and how to disable the alert.');
INSERT INTO class_mails VALUES ('italian', 'ad_options_upgrade_done', 'Your ad upgrade', 'Hello {$contact_name},<br/><br/>\n\nYour listing #{$ad_id} was successfully upgraded with the following options:<br/><br/>\n\n<table width=\"400\">\n<tr><td style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Details</td></tr>\n{if $featured}<tr><td class=\"right\">Featured</td></tr>{/if}\n{if $highlited}<tr><td class=\"right\">Highlighted</td></tr>{/if}\n{if $video}<tr><td class=\"right\">Video Classifieds</td></tr>{/if}\n{if $priority}<tr><td class=\"right\">Priority: {$priority}</td></tr>{/if}\n</table><br/><br/>\n\nView your listing details page:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The info message which appears after the ad upgrade was accepted by administrator. The message will contain information about upgrade status.');
INSERT INTO class_mails VALUES ('italian', 'new_comment', 'New comment for listing #{$ad_id}', 'Hello {$contact_name},<br/><br/>\n\nYou have a new comment for listing #{$ad_id}:<br/><br/>\n\n{$message}<br/><br/>\n\nPosted by: {$contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces a new comment');
INSERT INTO class_mails VALUES ('italian', 'admin_new_ad', 'New listing on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n<tr><td>Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n</table><br/><br/>\n', 'The email sent to administrator to notify a new listing');
INSERT INTO class_mails VALUES ('italian', 'reply', 'Message reply on {$site_name}', 'A new reply has been made on {$site_name}:<br/><br/>{$message}', 'The email which a user receives when a reply is made for a message');
INSERT INTO class_mails VALUES ('italian', 'report_message', 'Message id {$id} reported as spam', 'The message id {$id} was reported as spam.', 'The message the administrator receives when a user reports a message as spam.');
INSERT INTO class_mails VALUES ('italian', 'buy_credits_status', 'Your credits purchase on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $credits_pending}\nYour credits purchase is pending and will be shortly activated by administrator.<br/>\n{else}\nYou have successfully purchased extra credits.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Credits package details</td></tr>\n<tr><td>Package name:</td><td class=\"right\">{$credits_plan.name}</td></tr>\n<tr><td>Price:</td><td class=\"right\">{$credits_plan.price_curr}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}<tr><td>Number of credits:</td><td class=\"right\">{$credits_plan.no_credits}</td></tr>\n<tr><td>Package status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a credits package is ordered. The email contains information about the credits package status.');
INSERT INTO class_mails VALUES ('italian', 'account_removal', 'Account removal request', 'An account removal request was filed for your account. <br/><br/>\n\n<font color=\"f00\">Note that this action will result in the complete removal of your user account and user details from our site, as well as the complete removal of any listings added with this account!</font><br/><br/>\n\nTo confirm it, please click on the link below:<br/>\n{$removal_link}<br/><br/>\n\nIf you did not intended to remove your account please disregard this email.<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message sent to the user when the account removal is asked. It asks for confirmation for the removal process.');
INSERT INTO class_mails VALUES ('italian', 'admin_account_removal', 'Account removal requested for user id #{$id}', 'An account removal was requested for user id #{$id}.<br/><br/>\n\n{if $enable_username}Username: {$user.username}{else}Email: {$user.email}{/if}<br/>\nContact name: {$user.contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the site administrator a request for an account removal.');
INSERT INTO class_mails VALUES ('italian', 'affiliate_registration', 'Your affiliate account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration as an affiliate on {$site_name}<br/>\n{else}\nYour affiliate account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>\nAffiliate id: <strong>{$affiliate_id}</strong><br/>\nAffiliate link: <strong>{$affiliate_link}</strong><br/>\n<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nTo activate your affiliate account please go to the following link:<br/>\n{$link}<br/><br/>\n{else}\n{* -------- PLACE HERE INFORMATION REGARDING PAYMENTS TOWARDS AFFILIATES AND ANY OTHER INFORMATION REGARDING USING THE AFFILIATE ACCOUNT ------- *}\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which an affiliate receives after registration with account information, affiliate link and account activation link if the case.');
INSERT INTO class_mails VALUES ('italian', 'admin_pending_edited', 'Listing #{$ad_id} was modified', 'Listing #{$ad_id} ({$ad_title}) was modified. You can review the listing with the following link:<br/><br/>\n\n{$review_link}<br/>\n', 'The message which announces the administrator that a listing was modified. Only used when Pending Edited option is enabled.');
INSERT INTO class_mails VALUES ('italian', 'pending_edited', 'Your listing modifications were {$action}', 'Hello {$contact_name},<br/><br/>\n\nYour listing id #{$ad_id} ({$ad_title}) changes were {$action} by administrator:<br/><br/>\n\n{$details_link}\n<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the user that its modified listing was accepted or denied by the site administrator');
INSERT INTO class_mails VALUES ('italian', 'new_auction_bid', 'New auction bid for your listing #{$ad_id} on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\nA new bid was made for your listing #{$ad_id} ({$ad_title}):<br/><br/>\n\n{$message}<br/>\n<br/>\nPosted by: {$sender_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message that announces a new auction bid for a listing');
INSERT INTO class_mails VALUES ('german', 'registration', 'Your account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration with this account on {$site_name}<br/>\n{else}\nYour account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>{if isset($phone) && $phone}Phone number: <strong>{$phone}</strong><br/>{/if}<br/>\n\n{if $activation==1}{*    ### If the account needs activation    ###  *}\nTo activate your account please go to the following link:<br/>\n{$link}<br/><br/>\n{elseif $activation==2}You should receive an SMS on your phone containing an activation code. If you skipped the activation process after registration, access the following link and enter the activation code in the box:<br/>\n{$link}<br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after registration with account information and account activation link if the case.');
INSERT INTO class_mails VALUES ('german', 'mailto', '{$site_name} new message', 'Hello {$contact_name},<br/><br/>\n\n<strong>{$sender_name}</strong> is interested in your listing below: <br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nSender email: <br/>\n<font color=\"#2995b5\">{$sender_email}</font><br/><br/>\n', 'The email sent to a listing owner when a guest fills in the contact user form attached to every ad.');
INSERT INTO class_mails VALUES ('german', 'recommend_ad', '{$sender_name} recommended you this ad!', 'Hello <strong>{$name}</strong>,<br/><br/>\n\n<strong>{$sender_name}</strong> thought you would be interested in the following resource:<br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nBest Regards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/><br/>\n', 'The email which is sent to the when a user or guest recommends an ad to a friend using the \"Share\" link on every ad details page.');
INSERT INTO class_mails VALUES ('german', 'password_recovery', 'Password recovery for {$site_name}', 'To initiate the process for resetting the password for your {$site_name} account, visit the link below:<br/><br/>\n\n{$link}<br/><br/>\n', 'The email which a user receives after initiating a password recovery process.');
INSERT INTO class_mails VALUES ('german', 'listing_expired', 'Your listing on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour listing with the id #{$ad_id} expired!<br/><br/>\n\nIf you want to renew your listing please go to your account \"Browse Listings\" section and use the \"Renew\" icon assigned to this ad, or use the following link: <br/>\n{$renew_link} <br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives after a listing expired.');
INSERT INTO class_mails VALUES ('german', 'listing_will_expire', 'Your listing on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your listing will expire in {$days_expire} days!<br/><br/>\n\nIf you want to renew your listing, you can renew it from your account after it expires, or if you want to renew it before it expires you can use the following link:<br/>\n{$renew_link}<br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives before a listing expires.');
INSERT INTO class_mails VALUES ('german', 'admin_announce_pending', 'New {$processor} pending on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n{if $ad_id && $ad_pending} {* ---- announce pending listing -------- *}\n<tr><td>Pending Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n{/if}\n{if $plan.type==\"sub\" && $plan_pending} {* ---- announce pending subscription -------- *}\n<tr><td>Pending Plan:</td><td class=\"right\">#{$plan_name}</td></tr>\n{/if}\n{if $credits_pending} {* ---- announce pending credits package -------- *}\n<tr><td>Pending credits package:</td><td class=\"right\">#{$credits_plan_name}</td></tr>\n{/if}\n{if $upgrade}\n<tr><td>Pending Upgrades for Ad ID:</td><td class=\"right\">#{$ad_id}</td>\n{/if}\n{if $store}\n<tr><td>Pending Dealer Page for user:</td><td class=\"right\">#{$username}</td></tr>\n{/if}\n</table><br/><br/>\n', 'The email sent to administrator to notify a pending action: new ad, subscription, upgrade ad etc.');
INSERT INTO class_mails VALUES ('german', 'admin_new_account', 'New {if $user.affiliate}affiliate {/if}user registered on {$site_name}', 'A new {if $user.affiliate}affiliate {/if}user registered on <strong>{$site_name}</strong><br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Account Details</td></tr>\n{if $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>{else}<tr><td>Email:</td><td class=\"right\">{$email}</td></tr>{/if}\n<tr><td>Group:</td><td class=\"right\">{$group}</td></tr>\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n', 'The email which is sent to the administrator to notify a new user registered.');
INSERT INTO class_mails VALUES ('german', 'report_ad', 'Report Abusive Ad on {$site_name}', 'The following ad was reported as abusive:<br/>\n{$ad_link}<br/><br/>\n\nThe report was sent by:<br/>\nName: <strong>{$name}</strong><br/>\nEmail: <strong>{$email}</strong><br/>\nComments: {$message}<br/><br/>\n', 'The email sent to admin when someone reports an ad as abusive');
INSERT INTO class_mails VALUES ('german', 'ad_publish_status', 'Your listing on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $nologin && $activation}{* ------- Text which appears when the ad is placed without login and it requires activation -------- *}\n{if $activation==1}\nIMPORTANT! Your ad is not yet active. To activate your ad, click the link below or copy and paste the entire link into your web browser:<br/>\n{$activation_link}<br/>\n{else}\nIMPORTANT! Your listing requires SMS activation. You should have received a code via SMS. If you skipped this step after posting your listing, then in order to activate it, click on the link below and enter the activation code you received via SMS:<br/>\n{$activation_link}<br/>\n{/if}\n{/if}\n{if $manual}\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $ad_pending}\nYour ad is pending and will be published after the administrator review!<br/>\n\n{elseif $active}\nYour ad is published!<br/>\n\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Ad Details</td></tr>\n<tr><td>ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Plan:</td><td class=\"right\">{$plan_name}</td></tr>\n{if $plan.amount}<tr><td>Plan amount:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $featured || $highlited || $priority || $video}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff;\">Options</td></tr>\n{if $featured}<tr><td>Featured</td><td class=\"right\">{$featured_price}</td></tr>{/if}\n{if $highlited}<tr><td>Highlighted</td><td class=\"right\">{$highlited_price}</td></tr>{/if}\n{if $priority}<tr><td>Priority</td><td class=\"right\">{$priority_name} - {$priority_price}</td></tr>{/if}\n{if $video}<tr><td>Video</td><td class=\"right\">{$video_price}</td></tr>{/if}{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>{/if}\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $amount}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>{/if}\n{/if}\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n{if $amount}<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\n{if $nologin && !$activation} {* send management link if posted without login *}\nYou can use the following link to manage your listing:<br/>\n{$details_link}<br/>\n{elseif !$nologin}\nView your listing details: <br/>\n{$details_link}<br/>\n{/if}\n<br/>\n\n{if $plan.type==\"sub\" && $new_subscription}  {* - details if new subscription - *}\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Plan name:</td><td class=\"right\">{$plan.name}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$plan.price_curr}</td></tr>\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n</table><br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the listing owner after the listing is posted. The email contains information about the ad status.');
INSERT INTO class_mails VALUES ('german', 'ad_options_upgrade_status', 'Listing upgrade status on {$site_name}', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\n{if $manual}\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/><br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{/if}\n\nYour ad upgrade request has been registered. You can see below the status of your upgrade:<br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Status</td></tr>\n<tr><td class=\"right\">Ad ID:</td><td>#{$ad_id}\n<tr><td class=\"right\">Ad upgrade status:</td><td>{$status}</td></tr>\n<tr><td class=\"right\">Invoice no:</td><td>#{$invoice_no}</td></tr>\n{if $amount}\n<tr><td class=\"right\">Processor:</td><td>{$processor}</td></tr>\n{/if}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade options</td></tr>\n{if $featured}\n<tr><td>Feature Ad:</td><td class=\"right\">{$featured_price}</td></tr>\n{/if}\n{if $highlited}\n<tr><td>Highlighted Ad:</td><td class=\"right\">{$highlited_price}</td></tr>\n{/if}\n{if $priority}\n<tr><td>Priority:</td><td class=\"right\">{$priority_name} {$priority_price}</td></tr>\n{/if}\n{if $video}\n<tr><td>Video:</td><td class=\"right\">{$video_price}</td></tr>\n{/if}\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n{/if}\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after a listing is upgraded. The email contains information about the upgrade status.');
INSERT INTO class_mails VALUES ('german', 'subscription_status', 'Your subscription on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $plan_pending}\nYour subscription is pending and will be shortly activated by administrator.<br/>\n{else}\nYour subscription is active and you can start publishing ads.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Subscription:</td><td class=\"right\">{$plan.name}</td></tr>\n{if $plan_price}<tr><td>Plan price:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n{if $processor}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n{/if}\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a subscription is ordered. The email contains information about the subscription status.');
INSERT INTO class_mails VALUES ('german', 'subscription_expired', 'Your subscription on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\n{if $time_expired}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> expired!<br/><br/>\n{else}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> reached the maximum number or ads allowed and was deactivated!\n<br/><br/>\n{/if}\n\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('german', 'subscription_will_expire', 'Your subscription on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your subscription  with the id <strong>#{$subscription_id}</strong> will expire in {$days_expire} days!<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives before a subscription expires.');
INSERT INTO class_mails VALUES ('german', 'store_expired', 'Your Dealer Page on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour Dealer Page feature expired! <br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives after the Dealer Page expires.');
INSERT INTO class_mails VALUES ('german', 'ad_options_expired', 'Your ad options on {$site_name} expired', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\nYour following ad options for ad id #{$id} expired: {$expired_options}!<br/><br/>\n\nView the content of your ad: <br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('german', 'buy_store_status', 'Your Dealer Page on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $store_pending}\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated.<br/>\n\n{else}\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/>\n\n{/if}\n<br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Dealer Page details:</td></tr>\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n{/if}\n{/if}\n<tr><td>Dealer Page availability:</td><td class=\"right\">{if $days}{$days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Dealer Page status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after choosing Dealer Page option for an account. The email contains information about the Dealer Page option status.');
INSERT INTO class_mails VALUES ('german', 'email_alert', '{$site_name} {if $no>1}{$no} new listings{else}1 new listing{/if} for {$search}', 'Hello,<br/><br/>\n\nThere {if $no>1}are {$no} new listings{else}is 1 new listing{/if} for <strong>{$search}</strong>!<br/><br/>\n\nPlease click the following link to see the  new {if $no==1}listing{else}listings{/if} for your search:<br/><br/>\n\n{$link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives when new listings appear for the alert search terms.');
INSERT INTO class_mails VALUES ('german', 'email_alert_confirmation', 'Your email alert for {$search}', 'Hello,<br/><br/>\n\nYou asked to be announced when something new comes up on <font color=\"#2995b5\">{$site_name}</font> for the following search:<br/>\n<strong>{$search}</strong><br/><br/>\n{if $confirmation}\nPlease confirm your email alert by clicking on the link below.<br/>\n\n{$confirmation_link}<br/><br/>\n{/if}\nIf you want to stop receiving email alerts please use the unsubscribe link below:<br/>\n\n{$unsubscribe_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The confirmation email which a user receives when choosing to subscribe for an email alert. This email will contain instructions how to activate the alert (is not already active) and how to disable the alert.');
INSERT INTO class_mails VALUES ('german', 'ad_options_upgrade_done', 'Your ad upgrade', 'Hello {$contact_name},<br/><br/>\n\nYour listing #{$ad_id} was successfully upgraded with the following options:<br/><br/>\n\n<table width=\"400\">\n<tr><td style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Details</td></tr>\n{if $featured}<tr><td class=\"right\">Featured</td></tr>{/if}\n{if $highlited}<tr><td class=\"right\">Highlighted</td></tr>{/if}\n{if $video}<tr><td class=\"right\">Video Classifieds</td></tr>{/if}\n{if $priority}<tr><td class=\"right\">Priority: {$priority}</td></tr>{/if}\n</table><br/><br/>\n\nView your listing details page:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The info message which appears after the ad upgrade was accepted by administrator. The message will contain information about upgrade status.');
INSERT INTO class_mails VALUES ('german', 'new_comment', 'New comment for listing #{$ad_id}', 'Hello {$contact_name},<br/><br/>\n\nYou have a new comment for listing #{$ad_id}:<br/><br/>\n\n{$message}<br/><br/>\n\nPosted by: {$contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces a new comment');
INSERT INTO class_mails VALUES ('german', 'admin_new_ad', 'New listing on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n<tr><td>Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n</table><br/><br/>\n', 'The email sent to administrator to notify a new listing');
INSERT INTO class_mails VALUES ('german', 'reply', 'Message reply on {$site_name}', 'A new reply has been made on {$site_name}:<br/><br/>{$message}', 'The email which a user receives when a reply is made for a message');
INSERT INTO class_mails VALUES ('german', 'report_message', 'Message id {$id} reported as spam', 'The message id {$id} was reported as spam.', 'The message the administrator receives when a user reports a message as spam.');
INSERT INTO class_mails VALUES ('german', 'buy_credits_status', 'Your credits purchase on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $credits_pending}\nYour credits purchase is pending and will be shortly activated by administrator.<br/>\n{else}\nYou have successfully purchased extra credits.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Credits package details</td></tr>\n<tr><td>Package name:</td><td class=\"right\">{$credits_plan.name}</td></tr>\n<tr><td>Price:</td><td class=\"right\">{$credits_plan.price_curr}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}<tr><td>Number of credits:</td><td class=\"right\">{$credits_plan.no_credits}</td></tr>\n<tr><td>Package status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a credits package is ordered. The email contains information about the credits package status.');
INSERT INTO class_mails VALUES ('german', 'account_removal', 'Account removal request', 'An account removal request was filed for your account. <br/><br/>\n\n<font color=\"f00\">Note that this action will result in the complete removal of your user account and user details from our site, as well as the complete removal of any listings added with this account!</font><br/><br/>\n\nTo confirm it, please click on the link below:<br/>\n{$removal_link}<br/><br/>\n\nIf you did not intended to remove your account please disregard this email.<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message sent to the user when the account removal is asked. It asks for confirmation for the removal process.');
INSERT INTO class_mails VALUES ('german', 'admin_account_removal', 'Account removal requested for user id #{$id}', 'An account removal was requested for user id #{$id}.<br/><br/>\n\n{if $enable_username}Username: {$user.username}{else}Email: {$user.email}{/if}<br/>\nContact name: {$user.contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the site administrator a request for an account removal.');
INSERT INTO class_mails VALUES ('german', 'affiliate_registration', 'Your affiliate account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration as an affiliate on {$site_name}<br/>\n{else}\nYour affiliate account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>\nAffiliate id: <strong>{$affiliate_id}</strong><br/>\nAffiliate link: <strong>{$affiliate_link}</strong><br/>\n<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nTo activate your affiliate account please go to the following link:<br/>\n{$link}<br/><br/>\n{else}\n{* -------- PLACE HERE INFORMATION REGARDING PAYMENTS TOWARDS AFFILIATES AND ANY OTHER INFORMATION REGARDING USING THE AFFILIATE ACCOUNT ------- *}\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which an affiliate receives after registration with account information, affiliate link and account activation link if the case.');
INSERT INTO class_mails VALUES ('german', 'admin_pending_edited', 'Listing #{$ad_id} was modified', 'Listing #{$ad_id} ({$ad_title}) was modified. You can review the listing with the following link:<br/><br/>\n\n{$review_link}<br/>\n', 'The message which announces the administrator that a listing was modified. Only used when Pending Edited option is enabled.');
INSERT INTO class_mails VALUES ('german', 'pending_edited', 'Your listing modifications were {$action}', 'Hello {$contact_name},<br/><br/>\n\nYour listing id #{$ad_id} ({$ad_title}) changes were {$action} by administrator:<br/><br/>\n\n{$details_link}\n<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the user that its modified listing was accepted or denied by the site administrator');
INSERT INTO class_mails VALUES ('german', 'new_auction_bid', 'New auction bid for your listing #{$ad_id} on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\nA new bid was made for your listing #{$ad_id} ({$ad_title}):<br/><br/>\n\n{$message}<br/>\n<br/>\nPosted by: {$sender_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message that announces a new auction bid for a listing');
INSERT INTO class_mails VALUES ('ro', 'registration', 'Your account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration with this account on {$site_name}<br/>\n{else}\nYour account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>{if isset($phone) && $phone}Phone number: <strong>{$phone}</strong><br/>{/if}<br/>\n\n{if $activation==1}{*    ### If the account needs activation    ###  *}\nTo activate your account please go to the following link:<br/>\n{$link}<br/><br/>\n{elseif $activation==2}You should receive an SMS on your phone containing an activation code. If you skipped the activation process after registration, access the following link and enter the activation code in the box:<br/>\n{$link}<br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after registration with account information and account activation link if the case.');
INSERT INTO class_mails VALUES ('ro', 'mailto', '{$site_name} new message', 'Hello {$contact_name},<br/><br/>\n\n<strong>{$sender_name}</strong> is interested in your listing below: <br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nSender email: <br/>\n<font color=\"#2995b5\">{$sender_email}</font><br/><br/>\n', 'The email sent to a listing owner when a guest fills in the contact user form attached to every ad.');
INSERT INTO class_mails VALUES ('ro', 'recommend_ad', '{$sender_name} recommended you this ad!', 'Hello <strong>{$name}</strong>,<br/><br/>\n\n<strong>{$sender_name}</strong> thought you would be interested in the following resource:<br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nBest Regards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/><br/>\n', 'The email which is sent to the when a user or guest recommends an ad to a friend using the \"Share\" link on every ad details page.');
INSERT INTO class_mails VALUES ('ro', 'password_recovery', 'Password recovery for {$site_name}', 'To initiate the process for resetting the password for your {$site_name} account, visit the link below:<br/><br/>\n\n{$link}<br/><br/>\n', 'The email which a user receives after initiating a password recovery process.');
INSERT INTO class_mails VALUES ('ro', 'listing_expired', 'Your listing on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour listing with the id #{$ad_id} expired!<br/><br/>\n\nIf you want to renew your listing please go to your account \"Browse Listings\" section and use the \"Renew\" icon assigned to this ad, or use the following link: <br/>\n{$renew_link} <br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives after a listing expired.');
INSERT INTO class_mails VALUES ('ro', 'listing_will_expire', 'Your listing on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your listing will expire in {$days_expire} days!<br/><br/>\n\nIf you want to renew your listing, you can renew it from your account after it expires, or if you want to renew it before it expires you can use the following link:<br/>\n{$renew_link}<br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives before a listing expires.');
INSERT INTO class_mails VALUES ('ro', 'admin_announce_pending', 'Un nou anunt {$processor} pe{$site_name}', '<table width=\"400\">\r\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Detalii</td></tr>\r\n<tr><td>Nr. Factura:</td><td class=\"right\">#{$invoice_no}</td></tr>\r\n<tr><td>Procesor plata:</td><td class=\"right\">{$processor}</td></tr>\r\n{if !$nologin && $enable_username}<tr><td>Utilizator:</td><td class=\"right\">{$username}</td></tr>\r\n{else}<tr><td>Postat de:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\r\n{/if}\r\n{if $ad_id && $ad_pending} {* ---- announce pending listing -------- *}\r\n<tr><td>ID anunt in asteptare:</td><td class=\"right\">#{$ad_id}</td></tr>\r\n<tr><td>Detalii Anunt:</td><td class=\"right\">{$details_link}</td></tr>\r\n{/if}\r\n{if $plan.type==\"sub\" && $plan_pending} {* ---- announce pending subscription -------- *}\r\n<tr><td>Plan in asteptare:</td><td class=\"right\">#{$plan_name}</td></tr>\r\n{/if}\r\n{if $credits_pending} {* ---- announce pending credits package -------- *}\r\n<tr><td>Pachet credite in asteptare:</td><td class=\"right\">#{$credits_plan_name}</td></tr>\r\n{/if}\r\n{if $upgrade}\r\n<tr><td>Modificari in asteptare pentru anuntul cu ID-ul:</td><td class=\"right\">#{$ad_id}</td>\r\n{/if}\r\n{if $store}\r\n<tr><td>Pagina Dealer in asteptare pentru utilizatorul:</td><td class=\"right\">#{$username}</td></tr>\r\n{/if}\r\n</table><br/><br/>', 'The email sent to administrator to notify a pending action: new ad, subscription, upgrade ad etc.');
INSERT INTO class_mails VALUES ('ro', 'admin_new_account', 'Un nou {if $user.affiliate}afiliat {/if}s-a inregistrat pe{$site_name}', 'Un nou utilizator {if $user.affiliate}afiliat {/if}s-a inregistrat pe <strong>{$site_name}</strong><br/><br/>\r\n\r\n<table width=\"400\">\r\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Detalii cont</td></tr>\r\n{if $enable_username}<tr><td>Utilziator:</td><td class=\"right\">{$username}</td></tr>{else}<tr><td>Email:</td><td class=\"right\">{$email}</td></tr>{/if}\r\n<tr><td>Grup:</td><td class=\"right\">{$group}</td></tr>\r\n<tr><td>Statut:</td><td class=\"right\">{$status}</td></tr>\r\n</table><br/><br/>', 'The email which is sent to the administrator to notify a new user registered.');
INSERT INTO class_mails VALUES ('ro', 'report_ad', 'Report Abusive Ad on {$site_name}', 'The following ad was reported as abusive:<br/>\n{$ad_link}<br/><br/>\n\nThe report was sent by:<br/>\nName: <strong>{$name}</strong><br/>\nEmail: <strong>{$email}</strong><br/>\nComments: {$message}<br/><br/>\n', 'The email sent to admin when someone reports an ad as abusive');
INSERT INTO class_mails VALUES ('ro', 'ad_publish_status', 'Anuntul dumneavoastra pe {$site_name}', 'Buna {$contact_name},<br/><br/>\r\n\r\n{if $nologin && $activation}{* ------- Text which appears when the ad is placed without login and it requires activation -------- *}\r\n{if $activation==1}\r\nIMPORTANT! Anuntul dumneavoastra nu este inca activ. Pentru a activa anuntul, Accesati link-ul de mai jos sau copiatil in bara de navigare a browseru-lui:<br/>\r\n{$activation_link}<br/>\r\n{else}\r\nIMPORTANT! Anuntul dumneavoastra necesita verificare prin SMS. O sa primiti un cod prin SMS. Daca ati sarit peste acet pas cand ati adaugat anuntul, in acest caz pentru a activa anuntul, apasati pe link-ul de mai jos pentru a introduce codul de activare:<br/>\r\n{$activation_link}<br/>\r\n{/if}\r\n{/if}\r\n{if $manual}\r\nMetoda de plata aleasa este una manuala. Acest lucru inseamnand ca modificarile raman in asteptare pana la confirmarea platii. Pentru a face plata va rugam sa folositi urmatoarele date:<br/>\r\n{*  ------------ Plata Banca  ---------------- *}\r\n{elseif $ad_pending}\r\nAnuntul este in asteptare si va fi public dupa verificarea unui moderator!<br/>\r\n\r\n{elseif $active}\r\nAnuntul dumneavoastra este publicat!<br/>\r\n\r\n{/if}\r\n<br/>\r\n<table width=\"400\">\r\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Detalii Anunt</td></tr>\r\n<tr><td>ID:</td><td class=\"right\">#{$ad_id}</td></tr>\r\n<tr><td>Plan:</td><td class=\"right\">{$plan_name}</td></tr>\r\n{if $plan.amount}<tr><td>Cost Plan:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\r\n{if $featured || $highlited || $priority || $video}\r\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff;\">Optiuni</td></tr>\r\n{if $featured}<tr><td>Promovat</td><td class=\"right\">{$featured_price}</td></tr>{/if}\r\n{if $highlited}<tr><td>Evidentiat</td><td class=\"right\">{$highlited_price}</td></tr>{/if}\r\n{if $priority}<tr><td>Prioritate</td><td class=\"right\">{$priority_name} - {$priority_price}</td></tr>{/if}\r\n{if $video}<tr><td>Video</td><td class=\"right\">{$video_price}</td></tr>{/if}{/if}\r\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>{/if}\r\n{if !$admin_activated}\r\n<tr><td>Suma:</td><td class=\"right\">{$amount_formatted}</td></tr>\r\n{if $amount}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>{/if}\r\n{/if}\r\n<tr><td>Statut:</td><td class=\"right\">{$status}</td></tr>\r\n{if $amount}<tr><td>Nr. Factura:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\r\n</table><br/><br/>\r\n\r\n{if $nologin && !$activation} {* send management link if posted without login *}\r\nPuteti utiliza link-ul de mai jos pentru a administra anuntul:<br/>\r\n{$details_link}<br/>\r\n{elseif !$nologin}\r\nVizualizati detaliile anuntului: <br/>\r\n{$details_link}<br/>\r\n{/if}\r\n<br/>\r\n\r\n{if $plan.type==\"sub\" && $new_subscription}  {* - details if new subscription - *}\r\n<table width=\"400\">\r\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Detalii abonament</td></tr>\r\n<tr><td>Nume Plan:</td><td class=\"right\">{$plan.name}</td></tr>\r\n<tr><td>uma:</td><td class=\"right\">{$plan.price_curr}</td></tr>\r\n<tr><td>Numar anunturi:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>{/if}\r\n<tr><td>Perioada abonament:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} zile</td></tr>\r\n<tr><td>Imagini permise:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\r\n<tr><td>Cuvinte:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>{/if}\r\n<tr><td>Valabilitate anunt:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} zile</td></tr>\r\n<tr><td>Metoda de plata:</td><td class=\"right\">{$processor}</td></tr>\r\n<tr><td>Statut Plan:</td><td class=\"right\">{$status}</td></tr>\r\n<tr><td>Numar Factura:</td><td class=\"right\">#{$invoice_no}</td></tr>\r\n</table><br/><br/>\r\n{/if}\r\n\r\nCu stima,<br/>\r\n<font color=\"#2995b5\">{$administrator}</font><br/>\r\n{$site_url}<br/><br/>', 'The email sent to the listing owner after the listing is posted. The email contains information about the ad status.');
INSERT INTO class_mails VALUES ('ro', 'ad_options_upgrade_status', 'Modificare optiuni anunt pe {$site_name}', 'Buna <strong>{$contact_name}</strong>,<br/><br/>\r\n\r\n{if $manual}\r\nMetoda de plata aleasa este una manuala. Acest lucru inseamnand ca modificarile raman in asteptare pana la confirmarea platii. Pentru a face plata va rugam sa folositi urmatoarele date:<br/><br/>\r\n{*  ------------Date Banca  ---------------- *}\r\n{/if}\r\n\r\nCerere de modificare a fost inregistrata. Puteti vizualiza mai jos statutul modificarilor:<br/><br/>\r\n\r\n<table width=\"400\">\r\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Statut Modificari</td></tr>\r\n<tr><td class=\"right\">ID anunt:</td><td>#{$ad_id}\r\n<tr><td class=\"right\">Statut modificare anunt:</td><td>{$status}</td></tr>\r\n<tr><td class=\"right\">Nr. factura:</td><td>#{$invoice_no}</td></tr>\r\n{if $amount}\r\n<tr><td class=\"right\">Procesor plata:</td><td>{$processor}</td></tr>\r\n{/if}\r\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Optiuni modificare</td></tr>\r\n{if $featured}\r\n<tr><td>Anunt Promovat:</td><td class=\"right\">{$featured_price}</td></tr>\r\n{/if}\r\n{if $highlited}\r\n<tr><td>Anunt Evidentiat:</td><td class=\"right\">{$highlited_price}</td></tr>\r\n{/if}\r\n{if $priority}\r\n<tr><td>Prioritate:</td><td class=\"right\">{$priority_name} {$priority_price}</td></tr>\r\n{/if}\r\n{if $video}\r\n<tr><td>Video:</td><td class=\"right\">{$video_price}</td></tr>\r\n{/if}\r\n{if $discount}\r\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\r\n{/if}\r\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\r\n</table><br/><br/>\r\n\r\nCu stima,<br/>\r\n<font color=\"#2995b5\">{$administrator}</font><br/>\r\n{$site_url}<br/><br/>', 'The email sent to the user after a listing is upgraded. The email contains information about the upgrade status.');
INSERT INTO class_mails VALUES ('ro', 'subscription_status', 'Your subscription on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $plan_pending}\nYour subscription is pending and will be shortly activated by administrator.<br/>\n{else}\nYour subscription is active and you can start publishing ads.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Subscription:</td><td class=\"right\">{$plan.name}</td></tr>\n{if $plan_price}<tr><td>Plan price:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n{if $processor}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n{/if}\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a subscription is ordered. The email contains information about the subscription status.');
INSERT INTO class_mails VALUES ('ro', 'subscription_expired', 'Your subscription on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\n{if $time_expired}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> expired!<br/><br/>\n{else}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> reached the maximum number or ads allowed and was deactivated!\n<br/><br/>\n{/if}\n\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('ro', 'subscription_will_expire', 'Your subscription on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your subscription  with the id <strong>#{$subscription_id}</strong> will expire in {$days_expire} days!<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives before a subscription expires.');
INSERT INTO class_mails VALUES ('ro', 'store_expired', 'Your Dealer Page on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour Dealer Page feature expired! <br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives after the Dealer Page expires.');
INSERT INTO class_mails VALUES ('ro', 'ad_options_expired', 'Optiunile pentru anunt au expirat pe {$site_name}', 'Buna <strong>{$contact_name}</strong>,<br/><br/>\r\n\r\nUrmatoarele optiuni au expirat pentru anuntul #{$id}: {$expired_options}!<br/><br/>\r\n\r\nVizualizati continutul anuntului: <br/>\r\n{$details_link}<br/><br/>\r\n\r\nCu stima,<br/>\r\n<font color=\"#2995b5\">{$administrator}</font><br/>\r\n{$site_url}<br/><br/>', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('ro', 'buy_store_status', 'Your Dealer Page on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $store_pending}\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated.<br/>\n\n{else}\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/>\n\n{/if}\n<br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Dealer Page details:</td></tr>\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n{/if}\n{/if}\n<tr><td>Dealer Page availability:</td><td class=\"right\">{if $days}{$days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Dealer Page status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after choosing Dealer Page option for an account. The email contains information about the Dealer Page option status.');
INSERT INTO class_mails VALUES ('ro', 'email_alert', '{$site_name} {if $no>1}{$no} new listings{else}1 new listing{/if} for {$search}', 'Hello,<br/><br/>\n\nThere {if $no>1}are {$no} new listings{else}is 1 new listing{/if} for <strong>{$search}</strong>!<br/><br/>\n\nPlease click the following link to see the  new {if $no==1}listing{else}listings{/if} for your search:<br/><br/>\n\n{$link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives when new listings appear for the alert search terms.');
INSERT INTO class_mails VALUES ('ro', 'email_alert_confirmation', 'Your email alert for {$search}', 'Hello,<br/><br/>\n\nYou asked to be announced when something new comes up on <font color=\"#2995b5\">{$site_name}</font> for the following search:<br/>\n<strong>{$search}</strong><br/><br/>\n{if $confirmation}\nPlease confirm your email alert by clicking on the link below.<br/>\n\n{$confirmation_link}<br/><br/>\n{/if}\nIf you want to stop receiving email alerts please use the unsubscribe link below:<br/>\n\n{$unsubscribe_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The confirmation email which a user receives when choosing to subscribe for an email alert. This email will contain instructions how to activate the alert (is not already active) and how to disable the alert.');
INSERT INTO class_mails VALUES ('ro', 'ad_options_upgrade_done', 'Modificari anunt', 'Buna {$contact_name},<br/><br/>\r\n\r\nAnuntul dumneavoastra #{$ad_id} a fost modificat cu success avand urmatoarele optiuni:<br/><br/>\r\n\r\n<table width=\"400\">\r\n<tr><td style=\"background: #2885b5; color: #fff; font-weight: bold;\">Detalii modificari</td></tr>\r\n{if $featured}<tr><td class=\"right\">Promovat</td></tr>{/if}\r\n{if $highlited}<tr><td class=\"right\">Evidentiat</td></tr>{/if}\r\n{if $video}<tr><td class=\"right\">Video</td></tr>{/if}\r\n{if $priority}<tr><td class=\"right\">Prioritate: {$priority}</td></tr>{/if}\r\n</table><br/><br/>\r\n\r\nVizualitati anuntul:<br/>\r\n{$details_link}<br/><br/>\r\n\r\nCu stima,<br/>\r\n<font color=\"#2995b5\">{$administrator}</font><br/>\r\n{$site_url}<br/><br/>', 'The info message which appears after the ad upgrade was accepted by administrator. The message will contain information about upgrade status.');
INSERT INTO class_mails VALUES ('ro', 'new_comment', 'New comment for listing #{$ad_id}', 'Hello {$contact_name},<br/><br/>\n\nYou have a new comment for listing #{$ad_id}:<br/><br/>\n\n{$message}<br/><br/>\n\nPosted by: {$contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces a new comment');
INSERT INTO class_mails VALUES ('ro', 'admin_new_ad', 'Anunt nou pe {$site_name}', '<table width=\"400\">\r\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Detalii</td></tr>\r\n{if !$nologin && $enable_username}<tr><td>Utilizator:</td><td class=\"right\">{$username}</td></tr>\r\n{else}<tr><td>Postat de:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\r\n{/if}\r\n<tr><td>ID anunt:</td><td class=\"right\">#{$ad_id}</td></tr>\r\n<tr><td>Detalii anunt:</td><td class=\"right\">{$details_link}</td></tr>\r\n</table><br/><br/>', 'The email sent to administrator to notify a new listing');
INSERT INTO class_mails VALUES ('ro', 'reply', 'Message reply on {$site_name}', 'A new reply has been made on {$site_name}:<br/><br/>{$message}', 'The email which a user receives when a reply is made for a message');
INSERT INTO class_mails VALUES ('ro', 'report_message', 'Message id {$id} reported as spam', 'The message id {$id} was reported as spam.', 'The message the administrator receives when a user reports a message as spam.');
INSERT INTO class_mails VALUES ('ro', 'buy_credits_status', 'Your credits purchase on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $credits_pending}\nYour credits purchase is pending and will be shortly activated by administrator.<br/>\n{else}\nYou have successfully purchased extra credits.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Credits package details</td></tr>\n<tr><td>Package name:</td><td class=\"right\">{$credits_plan.name}</td></tr>\n<tr><td>Price:</td><td class=\"right\">{$credits_plan.price_curr}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}<tr><td>Number of credits:</td><td class=\"right\">{$credits_plan.no_credits}</td></tr>\n<tr><td>Package status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a credits package is ordered. The email contains information about the credits package status.');
INSERT INTO class_mails VALUES ('ro', 'account_removal', 'Sterge Cont', 'O cerere de stergere a contului a fost trimis pentru acest ont. <br/><br/>\r\n\r\n<font color=\"f00\">Atentie prin stergerea contului se vor sterge automat toate anunturile si detaliile dumneavoatra din cadrul site-ului weltcars.com!</font><br/><br/>\r\n\r\nPentru a confitma stergerea, va rugam sa accesati link-ul de mai jos:<br/>\r\n{$removal_link}<br/><br/>\r\n\r\nIn cazul in care nu doriti sa stergeti contul, ignorati acest email.<br/><br/>\r\n\r\nCu stima,<br/>\r\n<font color=\"#2995b5\">{$administrator}</font><br/>\r\n{$site_url}<br/><br/>', 'The message sent to the user when the account removal is asked. It asks for confirmation for the removal process.');
INSERT INTO class_mails VALUES ('ro', 'admin_account_removal', 'Cere sterger cont id #{$id}', 'O cerere de stergere a fost trimisa pentru utilizatorul cu id-ul #{$id}.<br/><br/>\r\n\r\n{if $enable_username}Utilizator: {$user.username}{else}Email: {$user.email}{/if}<br/>\r\nNume: {$user.contact_name}<br/><br/>\r\n\r\nCu stima,<br/>\r\n<font color=\"#2995b5\">{$administrator}</font><br/>\r\n{$site_url}<br/><br/>', 'The message which announces the site administrator a request for an account removal.');
INSERT INTO class_mails VALUES ('ro', 'affiliate_registration', 'Your affiliate account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration as an affiliate on {$site_name}<br/>\n{else}\nYour affiliate account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>\nAffiliate id: <strong>{$affiliate_id}</strong><br/>\nAffiliate link: <strong>{$affiliate_link}</strong><br/>\n<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nTo activate your affiliate account please go to the following link:<br/>\n{$link}<br/><br/>\n{else}\n{* -------- PLACE HERE INFORMATION REGARDING PAYMENTS TOWARDS AFFILIATES AND ANY OTHER INFORMATION REGARDING USING THE AFFILIATE ACCOUNT ------- *}\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which an affiliate receives after registration with account information, affiliate link and account activation link if the case.');
INSERT INTO class_mails VALUES ('ro', 'admin_pending_edited', 'Anuntul #{$ad_id} a fost modificat', 'Anuntul #{$ad_id} ({$ad_title}) a fost modificat. puteti verifica anuntul utilizand link-ul de mai jos:<br/><br/>\r\n\r\n{$review_link}<br/>', 'The message which announces the administrator that a listing was modified. Only used when Pending Edited option is enabled.');
INSERT INTO class_mails VALUES ('ro', 'pending_edited', 'Your listing modifications were {$action}', 'Hello {$contact_name},<br/><br/>\n\nYour listing id #{$ad_id} ({$ad_title}) changes were {$action} by administrator:<br/><br/>\n\n{$details_link}\n<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the user that its modified listing was accepted or denied by the site administrator');
INSERT INTO class_mails VALUES ('ro', 'new_auction_bid', 'New auction bid for your listing #{$ad_id} on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\nA new bid was made for your listing #{$ad_id} ({$ad_title}):<br/><br/>\n\n{$message}<br/>\n<br/>\nPosted by: {$sender_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message that announces a new auction bid for a listing');
INSERT INTO class_mails VALUES ('hr', 'registration', 'Your account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration with this account on {$site_name}<br/>\n{else}\nYour account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>{if isset($phone) && $phone}Phone number: <strong>{$phone}</strong><br/>{/if}<br/>\n\n{if $activation==1}{*    ### If the account needs activation    ###  *}\nTo activate your account please go to the following link:<br/>\n{$link}<br/><br/>\n{elseif $activation==2}You should receive an SMS on your phone containing an activation code. If you skipped the activation process after registration, access the following link and enter the activation code in the box:<br/>\n{$link}<br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after registration with account information and account activation link if the case.');
INSERT INTO class_mails VALUES ('hr', 'mailto', '{$site_name} new message', 'Hello {$contact_name},<br/><br/>\n\n<strong>{$sender_name}</strong> is interested in your listing below: <br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nSender email: <br/>\n<font color=\"#2995b5\">{$sender_email}</font><br/><br/>\n', 'The email sent to a listing owner when a guest fills in the contact user form attached to every ad.');
INSERT INTO class_mails VALUES ('hr', 'recommend_ad', '{$sender_name} recommended you this ad!', 'Hello <strong>{$name}</strong>,<br/><br/>\n\n<strong>{$sender_name}</strong> thought you would be interested in the following resource:<br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nBest Regards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/><br/>\n', 'The email which is sent to the when a user or guest recommends an ad to a friend using the \"Share\" link on every ad details page.');
INSERT INTO class_mails VALUES ('hr', 'password_recovery', 'Password recovery for {$site_name}', 'To initiate the process for resetting the password for your {$site_name} account, visit the link below:<br/><br/>\n\n{$link}<br/><br/>\n', 'The email which a user receives after initiating a password recovery process.');
INSERT INTO class_mails VALUES ('hr', 'listing_expired', 'Your listing on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour listing with the id #{$ad_id} expired!<br/><br/>\n\nIf you want to renew your listing please go to your account \"Browse Listings\" section and use the \"Renew\" icon assigned to this ad, or use the following link: <br/>\n{$renew_link} <br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives after a listing expired.');
INSERT INTO class_mails VALUES ('hr', 'listing_will_expire', 'Your listing on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your listing will expire in {$days_expire} days!<br/><br/>\n\nIf you want to renew your listing, you can renew it from your account after it expires, or if you want to renew it before it expires you can use the following link:<br/>\n{$renew_link}<br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives before a listing expires.');
INSERT INTO class_mails VALUES ('hr', 'admin_announce_pending', 'New {$processor} pending on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n{if $ad_id && $ad_pending} {* ---- announce pending listing -------- *}\n<tr><td>Pending Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n{/if}\n{if $plan.type==\"sub\" && $plan_pending} {* ---- announce pending subscription -------- *}\n<tr><td>Pending Plan:</td><td class=\"right\">#{$plan_name}</td></tr>\n{/if}\n{if $credits_pending} {* ---- announce pending credits package -------- *}\n<tr><td>Pending credits package:</td><td class=\"right\">#{$credits_plan_name}</td></tr>\n{/if}\n{if $upgrade}\n<tr><td>Pending Upgrades for Ad ID:</td><td class=\"right\">#{$ad_id}</td>\n{/if}\n{if $store}\n<tr><td>Pending Dealer Page for user:</td><td class=\"right\">#{$username}</td></tr>\n{/if}\n</table><br/><br/>\n', 'The email sent to administrator to notify a pending action: new ad, subscription, upgrade ad etc.');
INSERT INTO class_mails VALUES ('hr', 'admin_new_account', 'New {if $user.affiliate}affiliate {/if}user registered on {$site_name}', 'A new {if $user.affiliate}affiliate {/if}user registered on <strong>{$site_name}</strong><br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Account Details</td></tr>\n{if $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>{else}<tr><td>Email:</td><td class=\"right\">{$email}</td></tr>{/if}\n<tr><td>Group:</td><td class=\"right\">{$group}</td></tr>\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n', 'The email which is sent to the administrator to notify a new user registered.');
INSERT INTO class_mails VALUES ('hr', 'report_ad', 'Report Abusive Ad on {$site_name}', 'The following ad was reported as abusive:<br/>\n{$ad_link}<br/><br/>\n\nThe report was sent by:<br/>\nName: <strong>{$name}</strong><br/>\nEmail: <strong>{$email}</strong><br/>\nComments: {$message}<br/><br/>\n', 'The email sent to admin when someone reports an ad as abusive');
INSERT INTO class_mails VALUES ('hr', 'ad_publish_status', 'Your listing on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $nologin && $activation}{* ------- Text which appears when the ad is placed without login and it requires activation -------- *}\n{if $activation==1}\nIMPORTANT! Your ad is not yet active. To activate your ad, click the link below or copy and paste the entire link into your web browser:<br/>\n{$activation_link}<br/>\n{else}\nIMPORTANT! Your listing requires SMS activation. You should have received a code via SMS. If you skipped this step after posting your listing, then in order to activate it, click on the link below and enter the activation code you received via SMS:<br/>\n{$activation_link}<br/>\n{/if}\n{/if}\n{if $manual}\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $ad_pending}\nYour ad is pending and will be published after the administrator review!<br/>\n\n{elseif $active}\nYour ad is published!<br/>\n\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Ad Details</td></tr>\n<tr><td>ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Plan:</td><td class=\"right\">{$plan_name}</td></tr>\n{if $plan.amount}<tr><td>Plan amount:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $featured || $highlited || $priority || $video}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff;\">Options</td></tr>\n{if $featured}<tr><td>Featured</td><td class=\"right\">{$featured_price}</td></tr>{/if}\n{if $highlited}<tr><td>Highlighted</td><td class=\"right\">{$highlited_price}</td></tr>{/if}\n{if $priority}<tr><td>Priority</td><td class=\"right\">{$priority_name} - {$priority_price}</td></tr>{/if}\n{if $video}<tr><td>Video</td><td class=\"right\">{$video_price}</td></tr>{/if}{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>{/if}\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $amount}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>{/if}\n{/if}\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n{if $amount}<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\n{if $nologin && !$activation} {* send management link if posted without login *}\nYou can use the following link to manage your listing:<br/>\n{$details_link}<br/>\n{elseif !$nologin}\nView your listing details: <br/>\n{$details_link}<br/>\n{/if}\n<br/>\n\n{if $plan.type==\"sub\" && $new_subscription}  {* - details if new subscription - *}\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Plan name:</td><td class=\"right\">{$plan.name}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$plan.price_curr}</td></tr>\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n</table><br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the listing owner after the listing is posted. The email contains information about the ad status.');
INSERT INTO class_mails VALUES ('hr', 'ad_options_upgrade_status', 'Listing upgrade status on {$site_name}', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\n{if $manual}\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/><br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{/if}\n\nYour ad upgrade request has been registered. You can see below the status of your upgrade:<br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Status</td></tr>\n<tr><td class=\"right\">Ad ID:</td><td>#{$ad_id}\n<tr><td class=\"right\">Ad upgrade status:</td><td>{$status}</td></tr>\n<tr><td class=\"right\">Invoice no:</td><td>#{$invoice_no}</td></tr>\n{if $amount}\n<tr><td class=\"right\">Processor:</td><td>{$processor}</td></tr>\n{/if}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade options</td></tr>\n{if $featured}\n<tr><td>Feature Ad:</td><td class=\"right\">{$featured_price}</td></tr>\n{/if}\n{if $highlited}\n<tr><td>Highlighted Ad:</td><td class=\"right\">{$highlited_price}</td></tr>\n{/if}\n{if $priority}\n<tr><td>Priority:</td><td class=\"right\">{$priority_name} {$priority_price}</td></tr>\n{/if}\n{if $video}\n<tr><td>Video:</td><td class=\"right\">{$video_price}</td></tr>\n{/if}\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n{/if}\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after a listing is upgraded. The email contains information about the upgrade status.');
INSERT INTO class_mails VALUES ('hr', 'subscription_status', 'Your subscription on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $plan_pending}\nYour subscription is pending and will be shortly activated by administrator.<br/>\n{else}\nYour subscription is active and you can start publishing ads.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Subscription:</td><td class=\"right\">{$plan.name}</td></tr>\n{if $plan_price}<tr><td>Plan price:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n{if $processor}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n{/if}\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a subscription is ordered. The email contains information about the subscription status.');
INSERT INTO class_mails VALUES ('hr', 'subscription_expired', 'Your subscription on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\n{if $time_expired}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> expired!<br/><br/>\n{else}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> reached the maximum number or ads allowed and was deactivated!\n<br/><br/>\n{/if}\n\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('hr', 'subscription_will_expire', 'Your subscription on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your subscription  with the id <strong>#{$subscription_id}</strong> will expire in {$days_expire} days!<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives before a subscription expires.');
INSERT INTO class_mails VALUES ('hr', 'store_expired', 'Your Dealer Page on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour Dealer Page feature expired! <br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives after the Dealer Page expires.');
INSERT INTO class_mails VALUES ('hr', 'ad_options_expired', 'Your ad options on {$site_name} expired', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\nYour following ad options for ad id #{$id} expired: {$expired_options}!<br/><br/>\n\nView the content of your ad: <br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('hr', 'buy_store_status', 'Your Dealer Page on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $store_pending}\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated.<br/>\n\n{else}\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/>\n\n{/if}\n<br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Dealer Page details:</td></tr>\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n{/if}\n{/if}\n<tr><td>Dealer Page availability:</td><td class=\"right\">{if $days}{$days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Dealer Page status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after choosing Dealer Page option for an account. The email contains information about the Dealer Page option status.');
INSERT INTO class_mails VALUES ('hr', 'email_alert', '{$site_name} {if $no>1}{$no} new listings{else}1 new listing{/if} for {$search}', 'Hello,<br/><br/>\n\nThere {if $no>1}are {$no} new listings{else}is 1 new listing{/if} for <strong>{$search}</strong>!<br/><br/>\n\nPlease click the following link to see the  new {if $no==1}listing{else}listings{/if} for your search:<br/><br/>\n\n{$link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives when new listings appear for the alert search terms.');
INSERT INTO class_mails VALUES ('hr', 'email_alert_confirmation', 'Your email alert for {$search}', 'Hello,<br/><br/>\n\nYou asked to be announced when something new comes up on <font color=\"#2995b5\">{$site_name}</font> for the following search:<br/>\n<strong>{$search}</strong><br/><br/>\n{if $confirmation}\nPlease confirm your email alert by clicking on the link below.<br/>\n\n{$confirmation_link}<br/><br/>\n{/if}\nIf you want to stop receiving email alerts please use the unsubscribe link below:<br/>\n\n{$unsubscribe_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The confirmation email which a user receives when choosing to subscribe for an email alert. This email will contain instructions how to activate the alert (is not already active) and how to disable the alert.');
INSERT INTO class_mails VALUES ('hr', 'ad_options_upgrade_done', 'Your ad upgrade', 'Hello {$contact_name},<br/><br/>\n\nYour listing #{$ad_id} was successfully upgraded with the following options:<br/><br/>\n\n<table width=\"400\">\n<tr><td style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Details</td></tr>\n{if $featured}<tr><td class=\"right\">Featured</td></tr>{/if}\n{if $highlited}<tr><td class=\"right\">Highlighted</td></tr>{/if}\n{if $video}<tr><td class=\"right\">Video Classifieds</td></tr>{/if}\n{if $priority}<tr><td class=\"right\">Priority: {$priority}</td></tr>{/if}\n</table><br/><br/>\n\nView your listing details page:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The info message which appears after the ad upgrade was accepted by administrator. The message will contain information about upgrade status.');
INSERT INTO class_mails VALUES ('hr', 'new_comment', 'New comment for listing #{$ad_id}', 'Hello {$contact_name},<br/><br/>\n\nYou have a new comment for listing #{$ad_id}:<br/><br/>\n\n{$message}<br/><br/>\n\nPosted by: {$contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces a new comment');
INSERT INTO class_mails VALUES ('hr', 'admin_new_ad', 'New listing on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n<tr><td>Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n</table><br/><br/>\n', 'The email sent to administrator to notify a new listing');
INSERT INTO class_mails VALUES ('hr', 'reply', 'Message reply on {$site_name}', 'A new reply has been made on {$site_name}:<br/><br/>{$message}', 'The email which a user receives when a reply is made for a message');
INSERT INTO class_mails VALUES ('hr', 'report_message', 'Message id {$id} reported as spam', 'The message id {$id} was reported as spam.', 'The message the administrator receives when a user reports a message as spam.');
INSERT INTO class_mails VALUES ('hr', 'buy_credits_status', 'Your credits purchase on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $credits_pending}\nYour credits purchase is pending and will be shortly activated by administrator.<br/>\n{else}\nYou have successfully purchased extra credits.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Credits package details</td></tr>\n<tr><td>Package name:</td><td class=\"right\">{$credits_plan.name}</td></tr>\n<tr><td>Price:</td><td class=\"right\">{$credits_plan.price_curr}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}<tr><td>Number of credits:</td><td class=\"right\">{$credits_plan.no_credits}</td></tr>\n<tr><td>Package status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a credits package is ordered. The email contains information about the credits package status.');
INSERT INTO class_mails VALUES ('hr', 'account_removal', 'Account removal request', 'An account removal request was filed for your account. <br/><br/>\n\n<font color=\"f00\">Note that this action will result in the complete removal of your user account and user details from our site, as well as the complete removal of any listings added with this account!</font><br/><br/>\n\nTo confirm it, please click on the link below:<br/>\n{$removal_link}<br/><br/>\n\nIf you did not intended to remove your account please disregard this email.<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message sent to the user when the account removal is asked. It asks for confirmation for the removal process.');
INSERT INTO class_mails VALUES ('hr', 'admin_account_removal', 'Account removal requested for user id #{$id}', 'An account removal was requested for user id #{$id}.<br/><br/>\n\n{if $enable_username}Username: {$user.username}{else}Email: {$user.email}{/if}<br/>\nContact name: {$user.contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the site administrator a request for an account removal.');
INSERT INTO class_mails VALUES ('hr', 'affiliate_registration', 'Your affiliate account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration as an affiliate on {$site_name}<br/>\n{else}\nYour affiliate account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>\nAffiliate id: <strong>{$affiliate_id}</strong><br/>\nAffiliate link: <strong>{$affiliate_link}</strong><br/>\n<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nTo activate your affiliate account please go to the following link:<br/>\n{$link}<br/><br/>\n{else}\n{* -------- PLACE HERE INFORMATION REGARDING PAYMENTS TOWARDS AFFILIATES AND ANY OTHER INFORMATION REGARDING USING THE AFFILIATE ACCOUNT ------- *}\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which an affiliate receives after registration with account information, affiliate link and account activation link if the case.');
INSERT INTO class_mails VALUES ('hr', 'admin_pending_edited', 'Listing #{$ad_id} was modified', 'Listing #{$ad_id} ({$ad_title}) was modified. You can review the listing with the following link:<br/><br/>\n\n{$review_link}<br/>\n', 'The message which announces the administrator that a listing was modified. Only used when Pending Edited option is enabled.');
INSERT INTO class_mails VALUES ('hr', 'pending_edited', 'Your listing modifications were {$action}', 'Hello {$contact_name},<br/><br/>\n\nYour listing id #{$ad_id} ({$ad_title}) changes were {$action} by administrator:<br/><br/>\n\n{$details_link}\n<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the user that its modified listing was accepted or denied by the site administrator');
INSERT INTO class_mails VALUES ('hr', 'new_auction_bid', 'New auction bid for your listing #{$ad_id} on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\nA new bid was made for your listing #{$ad_id} ({$ad_title}):<br/><br/>\n\n{$message}<br/>\n<br/>\nPosted by: {$sender_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message that announces a new auction bid for a listing');
INSERT INTO class_mails VALUES ('hu', 'registration', 'Your account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration with this account on {$site_name}<br/>\n{else}\nYour account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>{if isset($phone) && $phone}Phone number: <strong>{$phone}</strong><br/>{/if}<br/>\n\n{if $activation==1}{*    ### If the account needs activation    ###  *}\nTo activate your account please go to the following link:<br/>\n{$link}<br/><br/>\n{elseif $activation==2}You should receive an SMS on your phone containing an activation code. If you skipped the activation process after registration, access the following link and enter the activation code in the box:<br/>\n{$link}<br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after registration with account information and account activation link if the case.');
INSERT INTO class_mails VALUES ('hu', 'mailto', '{$site_name} new message', 'Hello {$contact_name},<br/><br/>\n\n<strong>{$sender_name}</strong> is interested in your listing below: <br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nSender email: <br/>\n<font color=\"#2995b5\">{$sender_email}</font><br/><br/>\n', 'The email sent to a listing owner when a guest fills in the contact user form attached to every ad.');
INSERT INTO class_mails VALUES ('hu', 'recommend_ad', '{$sender_name} recommended you this ad!', 'Hello <strong>{$name}</strong>,<br/><br/>\n\n<strong>{$sender_name}</strong> thought you would be interested in the following resource:<br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nBest Regards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/><br/>\n', 'The email which is sent to the when a user or guest recommends an ad to a friend using the \"Share\" link on every ad details page.');
INSERT INTO class_mails VALUES ('hu', 'password_recovery', 'Password recovery for {$site_name}', 'To initiate the process for resetting the password for your {$site_name} account, visit the link below:<br/><br/>\n\n{$link}<br/><br/>\n', 'The email which a user receives after initiating a password recovery process.');
INSERT INTO class_mails VALUES ('hu', 'listing_expired', 'Your listing on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour listing with the id #{$ad_id} expired!<br/><br/>\n\nIf you want to renew your listing please go to your account \"Browse Listings\" section and use the \"Renew\" icon assigned to this ad, or use the following link: <br/>\n{$renew_link} <br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives after a listing expired.');
INSERT INTO class_mails VALUES ('hu', 'listing_will_expire', 'Your listing on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your listing will expire in {$days_expire} days!<br/><br/>\n\nIf you want to renew your listing, you can renew it from your account after it expires, or if you want to renew it before it expires you can use the following link:<br/>\n{$renew_link}<br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives before a listing expires.');
INSERT INTO class_mails VALUES ('hu', 'admin_announce_pending', 'New {$processor} pending on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n{if $ad_id && $ad_pending} {* ---- announce pending listing -------- *}\n<tr><td>Pending Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n{/if}\n{if $plan.type==\"sub\" && $plan_pending} {* ---- announce pending subscription -------- *}\n<tr><td>Pending Plan:</td><td class=\"right\">#{$plan_name}</td></tr>\n{/if}\n{if $credits_pending} {* ---- announce pending credits package -------- *}\n<tr><td>Pending credits package:</td><td class=\"right\">#{$credits_plan_name}</td></tr>\n{/if}\n{if $upgrade}\n<tr><td>Pending Upgrades for Ad ID:</td><td class=\"right\">#{$ad_id}</td>\n{/if}\n{if $store}\n<tr><td>Pending Dealer Page for user:</td><td class=\"right\">#{$username}</td></tr>\n{/if}\n</table><br/><br/>\n', 'The email sent to administrator to notify a pending action: new ad, subscription, upgrade ad etc.');
INSERT INTO class_mails VALUES ('hu', 'admin_new_account', 'New {if $user.affiliate}affiliate {/if}user registered on {$site_name}', 'A new {if $user.affiliate}affiliate {/if}user registered on <strong>{$site_name}</strong><br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Account Details</td></tr>\n{if $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>{else}<tr><td>Email:</td><td class=\"right\">{$email}</td></tr>{/if}\n<tr><td>Group:</td><td class=\"right\">{$group}</td></tr>\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n', 'The email which is sent to the administrator to notify a new user registered.');
INSERT INTO class_mails VALUES ('hu', 'report_ad', 'Report Abusive Ad on {$site_name}', 'The following ad was reported as abusive:<br/>\n{$ad_link}<br/><br/>\n\nThe report was sent by:<br/>\nName: <strong>{$name}</strong><br/>\nEmail: <strong>{$email}</strong><br/>\nComments: {$message}<br/><br/>\n', 'The email sent to admin when someone reports an ad as abusive');
INSERT INTO class_mails VALUES ('hu', 'ad_publish_status', 'Your listing on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $nologin && $activation}{* ------- Text which appears when the ad is placed without login and it requires activation -------- *}\n{if $activation==1}\nIMPORTANT! Your ad is not yet active. To activate your ad, click the link below or copy and paste the entire link into your web browser:<br/>\n{$activation_link}<br/>\n{else}\nIMPORTANT! Your listing requires SMS activation. You should have received a code via SMS. If you skipped this step after posting your listing, then in order to activate it, click on the link below and enter the activation code you received via SMS:<br/>\n{$activation_link}<br/>\n{/if}\n{/if}\n{if $manual}\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $ad_pending}\nYour ad is pending and will be published after the administrator review!<br/>\n\n{elseif $active}\nYour ad is published!<br/>\n\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Ad Details</td></tr>\n<tr><td>ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Plan:</td><td class=\"right\">{$plan_name}</td></tr>\n{if $plan.amount}<tr><td>Plan amount:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $featured || $highlited || $priority || $video}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff;\">Options</td></tr>\n{if $featured}<tr><td>Featured</td><td class=\"right\">{$featured_price}</td></tr>{/if}\n{if $highlited}<tr><td>Highlighted</td><td class=\"right\">{$highlited_price}</td></tr>{/if}\n{if $priority}<tr><td>Priority</td><td class=\"right\">{$priority_name} - {$priority_price}</td></tr>{/if}\n{if $video}<tr><td>Video</td><td class=\"right\">{$video_price}</td></tr>{/if}{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>{/if}\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $amount}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>{/if}\n{/if}\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n{if $amount}<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\n{if $nologin && !$activation} {* send management link if posted without login *}\nYou can use the following link to manage your listing:<br/>\n{$details_link}<br/>\n{elseif !$nologin}\nView your listing details: <br/>\n{$details_link}<br/>\n{/if}\n<br/>\n\n{if $plan.type==\"sub\" && $new_subscription}  {* - details if new subscription - *}\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Plan name:</td><td class=\"right\">{$plan.name}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$plan.price_curr}</td></tr>\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n</table><br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the listing owner after the listing is posted. The email contains information about the ad status.');
INSERT INTO class_mails VALUES ('hu', 'ad_options_upgrade_status', 'Listing upgrade status on {$site_name}', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\n{if $manual}\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/><br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{/if}\n\nYour ad upgrade request has been registered. You can see below the status of your upgrade:<br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Status</td></tr>\n<tr><td class=\"right\">Ad ID:</td><td>#{$ad_id}\n<tr><td class=\"right\">Ad upgrade status:</td><td>{$status}</td></tr>\n<tr><td class=\"right\">Invoice no:</td><td>#{$invoice_no}</td></tr>\n{if $amount}\n<tr><td class=\"right\">Processor:</td><td>{$processor}</td></tr>\n{/if}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade options</td></tr>\n{if $featured}\n<tr><td>Feature Ad:</td><td class=\"right\">{$featured_price}</td></tr>\n{/if}\n{if $highlited}\n<tr><td>Highlighted Ad:</td><td class=\"right\">{$highlited_price}</td></tr>\n{/if}\n{if $priority}\n<tr><td>Priority:</td><td class=\"right\">{$priority_name} {$priority_price}</td></tr>\n{/if}\n{if $video}\n<tr><td>Video:</td><td class=\"right\">{$video_price}</td></tr>\n{/if}\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n{/if}\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after a listing is upgraded. The email contains information about the upgrade status.');
INSERT INTO class_mails VALUES ('hu', 'subscription_status', 'Your subscription on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $plan_pending}\nYour subscription is pending and will be shortly activated by administrator.<br/>\n{else}\nYour subscription is active and you can start publishing ads.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Subscription:</td><td class=\"right\">{$plan.name}</td></tr>\n{if $plan_price}<tr><td>Plan price:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n{if $processor}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n{/if}\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a subscription is ordered. The email contains information about the subscription status.');
INSERT INTO class_mails VALUES ('hu', 'subscription_expired', 'Your subscription on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\n{if $time_expired}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> expired!<br/><br/>\n{else}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> reached the maximum number or ads allowed and was deactivated!\n<br/><br/>\n{/if}\n\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('hu', 'subscription_will_expire', 'Your subscription on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your subscription  with the id <strong>#{$subscription_id}</strong> will expire in {$days_expire} days!<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives before a subscription expires.');
INSERT INTO class_mails VALUES ('hu', 'store_expired', 'Your Dealer Page on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour Dealer Page feature expired! <br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives after the Dealer Page expires.');
INSERT INTO class_mails VALUES ('hu', 'ad_options_expired', 'Your ad options on {$site_name} expired', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\nYour following ad options for ad id #{$id} expired: {$expired_options}!<br/><br/>\n\nView the content of your ad: <br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('hu', 'buy_store_status', 'Your Dealer Page on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $store_pending}\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated.<br/>\n\n{else}\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/>\n\n{/if}\n<br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Dealer Page details:</td></tr>\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n{/if}\n{/if}\n<tr><td>Dealer Page availability:</td><td class=\"right\">{if $days}{$days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Dealer Page status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after choosing Dealer Page option for an account. The email contains information about the Dealer Page option status.');
INSERT INTO class_mails VALUES ('hu', 'email_alert', '{$site_name} {if $no>1}{$no} new listings{else}1 new listing{/if} for {$search}', 'Hello,<br/><br/>\n\nThere {if $no>1}are {$no} new listings{else}is 1 new listing{/if} for <strong>{$search}</strong>!<br/><br/>\n\nPlease click the following link to see the  new {if $no==1}listing{else}listings{/if} for your search:<br/><br/>\n\n{$link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives when new listings appear for the alert search terms.');
INSERT INTO class_mails VALUES ('hu', 'email_alert_confirmation', 'Your email alert for {$search}', 'Hello,<br/><br/>\n\nYou asked to be announced when something new comes up on <font color=\"#2995b5\">{$site_name}</font> for the following search:<br/>\n<strong>{$search}</strong><br/><br/>\n{if $confirmation}\nPlease confirm your email alert by clicking on the link below.<br/>\n\n{$confirmation_link}<br/><br/>\n{/if}\nIf you want to stop receiving email alerts please use the unsubscribe link below:<br/>\n\n{$unsubscribe_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The confirmation email which a user receives when choosing to subscribe for an email alert. This email will contain instructions how to activate the alert (is not already active) and how to disable the alert.');
INSERT INTO class_mails VALUES ('hu', 'ad_options_upgrade_done', 'Your ad upgrade', 'Hello {$contact_name},<br/><br/>\n\nYour listing #{$ad_id} was successfully upgraded with the following options:<br/><br/>\n\n<table width=\"400\">\n<tr><td style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Details</td></tr>\n{if $featured}<tr><td class=\"right\">Featured</td></tr>{/if}\n{if $highlited}<tr><td class=\"right\">Highlighted</td></tr>{/if}\n{if $video}<tr><td class=\"right\">Video Classifieds</td></tr>{/if}\n{if $priority}<tr><td class=\"right\">Priority: {$priority}</td></tr>{/if}\n</table><br/><br/>\n\nView your listing details page:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The info message which appears after the ad upgrade was accepted by administrator. The message will contain information about upgrade status.');
INSERT INTO class_mails VALUES ('hu', 'new_comment', 'New comment for listing #{$ad_id}', 'Hello {$contact_name},<br/><br/>\n\nYou have a new comment for listing #{$ad_id}:<br/><br/>\n\n{$message}<br/><br/>\n\nPosted by: {$contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces a new comment');
INSERT INTO class_mails VALUES ('hu', 'admin_new_ad', 'New listing on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n<tr><td>Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n</table><br/><br/>\n', 'The email sent to administrator to notify a new listing');
INSERT INTO class_mails VALUES ('hu', 'reply', 'Message reply on {$site_name}', 'A new reply has been made on {$site_name}:<br/><br/>{$message}', 'The email which a user receives when a reply is made for a message');
INSERT INTO class_mails VALUES ('hu', 'report_message', 'Message id {$id} reported as spam', 'The message id {$id} was reported as spam.', 'The message the administrator receives when a user reports a message as spam.');
INSERT INTO class_mails VALUES ('hu', 'buy_credits_status', 'Your credits purchase on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $credits_pending}\nYour credits purchase is pending and will be shortly activated by administrator.<br/>\n{else}\nYou have successfully purchased extra credits.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Credits package details</td></tr>\n<tr><td>Package name:</td><td class=\"right\">{$credits_plan.name}</td></tr>\n<tr><td>Price:</td><td class=\"right\">{$credits_plan.price_curr}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}<tr><td>Number of credits:</td><td class=\"right\">{$credits_plan.no_credits}</td></tr>\n<tr><td>Package status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a credits package is ordered. The email contains information about the credits package status.');
INSERT INTO class_mails VALUES ('hu', 'account_removal', 'Account removal request', 'An account removal request was filed for your account. <br/><br/>\n\n<font color=\"f00\">Note that this action will result in the complete removal of your user account and user details from our site, as well as the complete removal of any listings added with this account!</font><br/><br/>\n\nTo confirm it, please click on the link below:<br/>\n{$removal_link}<br/><br/>\n\nIf you did not intended to remove your account please disregard this email.<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message sent to the user when the account removal is asked. It asks for confirmation for the removal process.');
INSERT INTO class_mails VALUES ('hu', 'admin_account_removal', 'Account removal requested for user id #{$id}', 'An account removal was requested for user id #{$id}.<br/><br/>\n\n{if $enable_username}Username: {$user.username}{else}Email: {$user.email}{/if}<br/>\nContact name: {$user.contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the site administrator a request for an account removal.');
INSERT INTO class_mails VALUES ('hu', 'affiliate_registration', 'Your affiliate account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration as an affiliate on {$site_name}<br/>\n{else}\nYour affiliate account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>\nAffiliate id: <strong>{$affiliate_id}</strong><br/>\nAffiliate link: <strong>{$affiliate_link}</strong><br/>\n<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nTo activate your affiliate account please go to the following link:<br/>\n{$link}<br/><br/>\n{else}\n{* -------- PLACE HERE INFORMATION REGARDING PAYMENTS TOWARDS AFFILIATES AND ANY OTHER INFORMATION REGARDING USING THE AFFILIATE ACCOUNT ------- *}\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which an affiliate receives after registration with account information, affiliate link and account activation link if the case.');
INSERT INTO class_mails VALUES ('hu', 'admin_pending_edited', 'Listing #{$ad_id} was modified', 'Listing #{$ad_id} ({$ad_title}) was modified. You can review the listing with the following link:<br/><br/>\n\n{$review_link}<br/>\n', 'The message which announces the administrator that a listing was modified. Only used when Pending Edited option is enabled.');
INSERT INTO class_mails VALUES ('hu', 'pending_edited', 'Your listing modifications were {$action}', 'Hello {$contact_name},<br/><br/>\n\nYour listing id #{$ad_id} ({$ad_title}) changes were {$action} by administrator:<br/><br/>\n\n{$details_link}\n<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the user that its modified listing was accepted or denied by the site administrator');
INSERT INTO class_mails VALUES ('hu', 'new_auction_bid', 'New auction bid for your listing #{$ad_id} on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\nA new bid was made for your listing #{$ad_id} ({$ad_title}):<br/><br/>\n\n{$message}<br/>\n<br/>\nPosted by: {$sender_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message that announces a new auction bid for a listing');
INSERT INTO class_mails VALUES ('bg', 'registration', 'Your account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration with this account on {$site_name}<br/>\n{else}\nYour account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>{if isset($phone) && $phone}Phone number: <strong>{$phone}</strong><br/>{/if}<br/>\n\n{if $activation==1}{*    ### If the account needs activation    ###  *}\nTo activate your account please go to the following link:<br/>\n{$link}<br/><br/>\n{elseif $activation==2}You should receive an SMS on your phone containing an activation code. If you skipped the activation process after registration, access the following link and enter the activation code in the box:<br/>\n{$link}<br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after registration with account information and account activation link if the case.');
INSERT INTO class_mails VALUES ('bg', 'mailto', '{$site_name} new message', 'Hello {$contact_name},<br/><br/>\n\n<strong>{$sender_name}</strong> is interested in your listing below: <br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nSender email: <br/>\n<font color=\"#2995b5\">{$sender_email}</font><br/><br/>\n', 'The email sent to a listing owner when a guest fills in the contact user form attached to every ad.');
INSERT INTO class_mails VALUES ('bg', 'recommend_ad', '{$sender_name} recommended you this ad!', 'Hello <strong>{$name}</strong>,<br/><br/>\n\n<strong>{$sender_name}</strong> thought you would be interested in the following resource:<br/>\n{$ad_link}<br/><br/>\n\n{$message}<br/><br/>\n\nBest Regards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/><br/>\n', 'The email which is sent to the when a user or guest recommends an ad to a friend using the \"Share\" link on every ad details page.');
INSERT INTO class_mails VALUES ('bg', 'password_recovery', 'Password recovery for {$site_name}', 'To initiate the process for resetting the password for your {$site_name} account, visit the link below:<br/><br/>\n\n{$link}<br/><br/>\n', 'The email which a user receives after initiating a password recovery process.');
INSERT INTO class_mails VALUES ('bg', 'listing_expired', 'Your listing on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour listing with the id #{$ad_id} expired!<br/><br/>\n\nIf you want to renew your listing please go to your account \"Browse Listings\" section and use the \"Renew\" icon assigned to this ad, or use the following link: <br/>\n{$renew_link} <br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives after a listing expired.');
INSERT INTO class_mails VALUES ('bg', 'listing_will_expire', 'Your listing on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your listing will expire in {$days_expire} days!<br/><br/>\n\nIf you want to renew your listing, you can renew it from your account after it expires, or if you want to renew it before it expires you can use the following link:<br/>\n{$renew_link}<br/><br/>\n\nTo view the content of your ad check the following link:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a listing owner receives before a listing expires.');
INSERT INTO class_mails VALUES ('bg', 'admin_announce_pending', 'New {$processor} pending on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n{if $ad_id && $ad_pending} {* ---- announce pending listing -------- *}\n<tr><td>Pending Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n{/if}\n{if $plan.type==\"sub\" && $plan_pending} {* ---- announce pending subscription -------- *}\n<tr><td>Pending Plan:</td><td class=\"right\">#{$plan_name}</td></tr>\n{/if}\n{if $credits_pending} {* ---- announce pending credits package -------- *}\n<tr><td>Pending credits package:</td><td class=\"right\">#{$credits_plan_name}</td></tr>\n{/if}\n{if $upgrade}\n<tr><td>Pending Upgrades for Ad ID:</td><td class=\"right\">#{$ad_id}</td>\n{/if}\n{if $store}\n<tr><td>Pending Dealer Page for user:</td><td class=\"right\">#{$username}</td></tr>\n{/if}\n</table><br/><br/>\n', 'The email sent to administrator to notify a pending action: new ad, subscription, upgrade ad etc.');
INSERT INTO class_mails VALUES ('bg', 'admin_new_account', 'New {if $user.affiliate}affiliate {/if}user registered on {$site_name}', 'A new {if $user.affiliate}affiliate {/if}user registered on <strong>{$site_name}</strong><br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Account Details</td></tr>\n{if $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>{else}<tr><td>Email:</td><td class=\"right\">{$email}</td></tr>{/if}\n<tr><td>Group:</td><td class=\"right\">{$group}</td></tr>\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n', 'The email which is sent to the administrator to notify a new user registered.');
INSERT INTO class_mails VALUES ('bg', 'report_ad', 'Report Abusive Ad on {$site_name}', 'The following ad was reported as abusive:<br/>\n{$ad_link}<br/><br/>\n\nThe report was sent by:<br/>\nName: <strong>{$name}</strong><br/>\nEmail: <strong>{$email}</strong><br/>\nComments: {$message}<br/><br/>\n', 'The email sent to admin when someone reports an ad as abusive');
INSERT INTO class_mails VALUES ('bg', 'ad_publish_status', 'Your listing on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $nologin && $activation}{* ------- Text which appears when the ad is placed without login and it requires activation -------- *}\n{if $activation==1}\nIMPORTANT! Your ad is not yet active. To activate your ad, click the link below or copy and paste the entire link into your web browser:<br/>\n{$activation_link}<br/>\n{else}\nIMPORTANT! Your listing requires SMS activation. You should have received a code via SMS. If you skipped this step after posting your listing, then in order to activate it, click on the link below and enter the activation code you received via SMS:<br/>\n{$activation_link}<br/>\n{/if}\n{/if}\n{if $manual}\nThe payment type you have chosen to post this listing is manual. This means that your ad will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $ad_pending}\nYour ad is pending and will be published after the administrator review!<br/>\n\n{elseif $active}\nYour ad is published!<br/>\n\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Ad Details</td></tr>\n<tr><td>ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Plan:</td><td class=\"right\">{$plan_name}</td></tr>\n{if $plan.amount}<tr><td>Plan amount:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $featured || $highlited || $priority || $video}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff;\">Options</td></tr>\n{if $featured}<tr><td>Featured</td><td class=\"right\">{$featured_price}</td></tr>{/if}\n{if $highlited}<tr><td>Highlighted</td><td class=\"right\">{$highlited_price}</td></tr>{/if}\n{if $priority}<tr><td>Priority</td><td class=\"right\">{$priority_name} - {$priority_price}</td></tr>{/if}\n{if $video}<tr><td>Video</td><td class=\"right\">{$video_price}</td></tr>{/if}{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>{/if}\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $amount}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>{/if}\n{/if}\n<tr><td>Status:</td><td class=\"right\">{$status}</td></tr>\n{if $amount}<tr><td>Invoice no:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\n{if $nologin && !$activation} {* send management link if posted without login *}\nYou can use the following link to manage your listing:<br/>\n{$details_link}<br/>\n{elseif !$nologin}\nView your listing details: <br/>\n{$details_link}<br/>\n{/if}\n<br/>\n\n{if $plan.type==\"sub\" && $new_subscription}  {* - details if new subscription - *}\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Plan name:</td><td class=\"right\">{$plan.name}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$plan.price_curr}</td></tr>\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n</table><br/><br/>\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the listing owner after the listing is posted. The email contains information about the ad status.');
INSERT INTO class_mails VALUES ('bg', 'ad_options_upgrade_status', 'Listing upgrade status on {$site_name}', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\n{if $manual}\nThe payment type you have chosen for this upgrade is manual. This means that your upgrade features will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/><br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{/if}\n\nYour ad upgrade request has been registered. You can see below the status of your upgrade:<br/><br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Status</td></tr>\n<tr><td class=\"right\">Ad ID:</td><td>#{$ad_id}\n<tr><td class=\"right\">Ad upgrade status:</td><td>{$status}</td></tr>\n<tr><td class=\"right\">Invoice no:</td><td>#{$invoice_no}</td></tr>\n{if $amount}\n<tr><td class=\"right\">Processor:</td><td>{$processor}</td></tr>\n{/if}\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade options</td></tr>\n{if $featured}\n<tr><td>Feature Ad:</td><td class=\"right\">{$featured_price}</td></tr>\n{/if}\n{if $highlited}\n<tr><td>Highlighted Ad:</td><td class=\"right\">{$highlited_price}</td></tr>\n{/if}\n{if $priority}\n<tr><td>Priority:</td><td class=\"right\">{$priority_name} {$priority_price}</td></tr>\n{/if}\n{if $video}\n<tr><td>Video:</td><td class=\"right\">{$video_price}</td></tr>\n{/if}\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n{/if}\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after a listing is upgraded. The email contains information about the upgrade status.');
INSERT INTO class_mails VALUES ('bg', 'subscription_status', 'Your subscription on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen to subscribe is manual. This means that your subscription will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $plan_pending}\nYour subscription is pending and will be shortly activated by administrator.<br/>\n{else}\nYour subscription is active and you can start publishing ads.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Subscription Details</td></tr>\n<tr><td>Subscription:</td><td class=\"right\">{$plan.name}</td></tr>\n{if $plan_price}<tr><td>Plan price:</td><td class=\"right\">{$plan_price}</td></tr>{/if}\n{if $discount}<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Number of ads:</td><td class=\"right\">{if $plan.no_ads}{$plan.no_ads}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Subscription time:</td><td class=\"right\">{if $plan.subscription_time}{$plan.subscription_time}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Allowed pictures:</td><td class=\"right\">{$plan.no_pictures}</td></tr>\n<tr><td>Words:</td><td class=\"right\">{if $plan.no_words}{$plan.no_words}{else}{$unlimited}</td></tr>\n{/if}\n<tr><td>Ads availability:</td><td class=\"right\">{if $plan.no_days}{$plan.no_days}{else}{$unlimited}{/if} days</td></tr>\n{if $processor}<tr><td>Payment method:</td><td class=\"right\">{$processor}</td></tr>\n{/if}\n<tr><td>Plan status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a subscription is ordered. The email contains information about the subscription status.');
INSERT INTO class_mails VALUES ('bg', 'subscription_expired', 'Your subscription on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\n{if $time_expired}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> expired!<br/><br/>\n{else}\n\nYour subscription with the id <strong>#{$subscription_id}</strong> reached the maximum number or ads allowed and was deactivated!\n<br/><br/>\n{/if}\n\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('bg', 'subscription_will_expire', 'Your subscription on {$site_name} will expire', 'Hello {$contact_name},<br/><br/>\n\nThis is a notification message! Your subscription  with the id <strong>#{$subscription_id}</strong> will expire in {$days_expire} days!<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives before a subscription expires.');
INSERT INTO class_mails VALUES ('bg', 'store_expired', 'Your Dealer Page on {$site_name} expired', 'Hello {$contact_name},<br/><br/>\n\nYour Dealer Page feature expired! <br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives after the Dealer Page expires.');
INSERT INTO class_mails VALUES ('bg', 'ad_options_expired', 'Your ad options on {$site_name} expired', 'Hello <strong>{$contact_name}</strong>,<br/><br/>\n\nYour following ad options for ad id #{$id} expired: {$expired_options}!<br/><br/>\n\nView the content of your ad: <br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which a user receives after a subcription expires.');
INSERT INTO class_mails VALUES ('bg', 'buy_store_status', 'Your Dealer Page on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that Dealer Page option for your account will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $store_pending}\nYour account upgrade to enable Dealer Page is waiting for administrator verification. You will be notified when activated.<br/>\n\n{else}\nYour account has been upgraded. You will now have your own Dealer Page on our site where you can customize your own top banner!<br/>\n\n{/if}\n<br/>\n\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Dealer Page details:</td></tr>\n{if !$admin_activated}\n<tr><td>Amount:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}\n<tr><td>Processor:</td><td class=\"right\">{$processor}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>\n{/if}\n{/if}\n<tr><td>Dealer Page availability:</td><td class=\"right\">{if $days}{$days}{else}{$unlimited}{/if} days</td></tr>\n<tr><td>Dealer Page status:</td><td class=\"right\">{$status}</td></tr>\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to the user after choosing Dealer Page option for an account. The email contains information about the Dealer Page option status.');
INSERT INTO class_mails VALUES ('bg', 'email_alert', '{$site_name} {if $no>1}{$no} new listings{else}1 new listing{/if} for {$search}', 'Hello,<br/><br/>\n\nThere {if $no>1}are {$no} new listings{else}is 1 new listing{/if} for <strong>{$search}</strong>!<br/><br/>\n\nPlease click the following link to see the  new {if $no==1}listing{else}listings{/if} for your search:<br/><br/>\n\n{$link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which the user receives when new listings appear for the alert search terms.');
INSERT INTO class_mails VALUES ('bg', 'email_alert_confirmation', 'Your email alert for {$search}', 'Hello,<br/><br/>\n\nYou asked to be announced when something new comes up on <font color=\"#2995b5\">{$site_name}</font> for the following search:<br/>\n<strong>{$search}</strong><br/><br/>\n{if $confirmation}\nPlease confirm your email alert by clicking on the link below.<br/>\n\n{$confirmation_link}<br/><br/>\n{/if}\nIf you want to stop receiving email alerts please use the unsubscribe link below:<br/>\n\n{$unsubscribe_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The confirmation email which a user receives when choosing to subscribe for an email alert. This email will contain instructions how to activate the alert (is not already active) and how to disable the alert.');
INSERT INTO class_mails VALUES ('bg', 'ad_options_upgrade_done', 'Your ad upgrade', 'Hello {$contact_name},<br/><br/>\n\nYour listing #{$ad_id} was successfully upgraded with the following options:<br/><br/>\n\n<table width=\"400\">\n<tr><td style=\"background: #2885b5; color: #fff; font-weight: bold;\">Upgrade Details</td></tr>\n{if $featured}<tr><td class=\"right\">Featured</td></tr>{/if}\n{if $highlited}<tr><td class=\"right\">Highlighted</td></tr>{/if}\n{if $video}<tr><td class=\"right\">Video Classifieds</td></tr>{/if}\n{if $priority}<tr><td class=\"right\">Priority: {$priority}</td></tr>{/if}\n</table><br/><br/>\n\nView your listing details page:<br/>\n{$details_link}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The info message which appears after the ad upgrade was accepted by administrator. The message will contain information about upgrade status.');
INSERT INTO class_mails VALUES ('bg', 'new_comment', 'New comment for listing #{$ad_id}', 'Hello {$contact_name},<br/><br/>\n\nYou have a new comment for listing #{$ad_id}:<br/><br/>\n\n{$message}<br/><br/>\n\nPosted by: {$contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces a new comment');
INSERT INTO class_mails VALUES ('bg', 'admin_new_ad', 'New listing on {$site_name}', '<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Details</td></tr>\n{if !$nologin && $enable_username}<tr><td>Username:</td><td class=\"right\">{$username}</td></tr>\n{else}<tr><td>Posted by:</td><td class=\"right\">{$email}{if $contact_name}, {$contact_name}{/if}</td></tr>\n{/if}\n<tr><td>Ad ID:</td><td class=\"right\">#{$ad_id}</td></tr>\n<tr><td>Listing Details:</td><td class=\"right\">{$details_link}</td></tr>\n</table><br/><br/>\n', 'The email sent to administrator to notify a new listing');
INSERT INTO class_mails VALUES ('bg', 'reply', 'Message reply on {$site_name}', 'A new reply has been made on {$site_name}:<br/><br/>{$message}', 'The email which a user receives when a reply is made for a message');
INSERT INTO class_mails VALUES ('bg', 'report_message', 'Message id {$id} reported as spam', 'The message id {$id} was reported as spam.', 'The message the administrator receives when a user reports a message as spam.');
INSERT INTO class_mails VALUES ('bg', 'buy_credits_status', 'Your credits purchase on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $manual}{*   ######   The user chosen a manual payment  ###### *}\nThe payment type you have chosen is manual. This means that your credits purchase will remain pending until the payment is completed. To complete the payment please see below the payment details:<br/>\n{*  ------------ PLACE HERE THE BANK ACCOUNT, CHECK ADDRESS OR ANY OTHER METHOD TO PAY MANUALLY  ---------------- *}\n{elseif $credits_pending}\nYour credits purchase is pending and will be shortly activated by administrator.<br/>\n{else}\nYou have successfully purchased extra credits.<br/>\n{/if}\n<br/>\n<table width=\"400\">\n<tr><td colspan=\"2\" style=\"background: #2885b5; color: #fff; font-weight: bold;\">Credits package details</td></tr>\n<tr><td>Package name:</td><td class=\"right\">{$credits_plan.name}</td></tr>\n<tr><td>Price:</td><td class=\"right\">{$credits_plan.price_curr}</td></tr>\n{if $discount}\n<tr><td>Discount:</td><td class=\"right\">{$discount}</td></tr>\n<tr><td>Total:</td><td class=\"right\">{$amount_formatted}</td></tr>\n{/if}<tr><td>Number of credits:</td><td class=\"right\">{$credits_plan.no_credits}</td></tr>\n<tr><td>Package status:</td><td class=\"right\">{$status}</td></tr>\n{if $invoice_no}<tr><td>Invoice number:</td><td class=\"right\">#{$invoice_no}</td></tr>{/if}\n</table><br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email sent to a user after a credits package is ordered. The email contains information about the credits package status.');
INSERT INTO class_mails VALUES ('bg', 'account_removal', 'Account removal request', 'An account removal request was filed for your account. <br/><br/>\n\n<font color=\"f00\">Note that this action will result in the complete removal of your user account and user details from our site, as well as the complete removal of any listings added with this account!</font><br/><br/>\n\nTo confirm it, please click on the link below:<br/>\n{$removal_link}<br/><br/>\n\nIf you did not intended to remove your account please disregard this email.<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message sent to the user when the account removal is asked. It asks for confirmation for the removal process.');
INSERT INTO class_mails VALUES ('bg', 'admin_account_removal', 'Account removal requested for user id #{$id}', 'An account removal was requested for user id #{$id}.<br/><br/>\n\n{if $enable_username}Username: {$user.username}{else}Email: {$user.email}{/if}<br/>\nContact name: {$user.contact_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the site administrator a request for an account removal.');
INSERT INTO class_mails VALUES ('bg', 'affiliate_registration', 'Your affiliate account on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nYou received this email because there has been a request for a registration as an affiliate on {$site_name}<br/>\n{else}\nYour affiliate account on {$site_name} has been created.<br/>\n{/if}\n<br/>\n\nYour account information are:<br/>\n{if $enable_username}Username: <strong>{$username}</strong>{else}Email: <strong>{$email}</strong>{/if}{if $password}<br/>\nPassword: <strong>{$password}</strong>{/if}<br/>\nAffiliate id: <strong>{$affiliate_id}</strong><br/>\nAffiliate link: <strong>{$affiliate_link}</strong><br/>\n<br/><br/>\n\n{if $activation}{*    ### If the account needs activation    ###  *}\nTo activate your affiliate account please go to the following link:<br/>\n{$link}<br/><br/>\n{else}\n{* -------- PLACE HERE INFORMATION REGARDING PAYMENTS TOWARDS AFFILIATES AND ANY OTHER INFORMATION REGARDING USING THE AFFILIATE ACCOUNT ------- *}\n{/if}\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The email which an affiliate receives after registration with account information, affiliate link and account activation link if the case.');
INSERT INTO class_mails VALUES ('bg', 'admin_pending_edited', 'Listing #{$ad_id} was modified', 'Listing #{$ad_id} ({$ad_title}) was modified. You can review the listing with the following link:<br/><br/>\n\n{$review_link}<br/>\n', 'The message which announces the administrator that a listing was modified. Only used when Pending Edited option is enabled.');
INSERT INTO class_mails VALUES ('bg', 'pending_edited', 'Your listing modifications were {$action}', 'Hello {$contact_name},<br/><br/>\n\nYour listing id #{$ad_id} ({$ad_title}) changes were {$action} by administrator:<br/><br/>\n\n{$details_link}\n<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message which announces the user that its modified listing was accepted or denied by the site administrator');
INSERT INTO class_mails VALUES ('bg', 'new_auction_bid', 'New auction bid for your listing #{$ad_id} on {$site_name}', 'Hello {$contact_name},<br/><br/>\n\nA new bid was made for your listing #{$ad_id} ({$ad_title}):<br/><br/>\n\n{$message}<br/>\n<br/>\nPosted by: {$sender_name}<br/><br/>\n\nRegards,<br/>\n<font color=\"#2995b5\">{$administrator}</font><br/>\n{$site_url}<br/><br/>\n', 'The message that announces a new auction bid for a listing');
INSERT INTO class_mails VALUES ('ro', 'price_drop_alert', 'Scadere de pret pe {$site_name}', 'Buna {$contact_name},<br/><br/>\r\n\r\nPretul pentru anuntul \"{$title}\" a scazut de la{$price_from} la {$price_to}.<br/>\r\nPentru a vedea anuntul, accesati link-ul de mai jos: <br/>\r\n{$details_link}<br/>\r\n<br/>\r\nDaca doriti sa stergeti notificarile de scadere de pret pentru acest anunt, va rugam sa accesati link-ul de mai jos:<br/>\r\nCu stima,<br/>\r\n<font color=\"#2995b5\">{$administrator}</font><br/>\r\n{$site_url}<br/><br/>', 'Send notifications when the price for a listing drops.');


#
# Table structure for table `class_mails_settings`
#

DROP TABLE IF EXISTS `class_mails_settings`;
CREATE TABLE `class_mails_settings` (
  `html_mails` tinyint(1) DEFAULT '1',
  `use_smtp_auth` tinyint(1) DEFAULT '0',
  `ssl` tinyint(1) NOT NULL DEFAULT '0',
  `smtp_server` varchar(40) DEFAULT NULL,
  `port` int(5) DEFAULT NULL,
  `username` varchar(70) DEFAULT NULL,
  `password` varchar(40) DEFAULT NULL,
  `bcc_to` varchar(70) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_mails_settings`
#

INSERT INTO class_mails_settings VALUES ('1', '0', '0', '', '25', '', '', '');


#
# Table structure for table `class_manual_return`
#

DROP TABLE IF EXISTS `class_manual_return`;
CREATE TABLE `class_manual_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_manual_return`
#



#
# Table structure for table `class_marca`
#

DROP TABLE IF EXISTS `class_marca`;
CREATE TABLE `class_marca` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  `set_id` int(3) DEFAULT '0',
  KEY `id` (`id`),
  KEY `idx_lang_id` (`lang_id`),
  KEY `idx_set_id` (`set_id`)
) ENGINE=MyISAM AUTO_INCREMENT=132 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_marca`
#

INSERT INTO class_marca VALUES ('1', 'Acura', 'ro', '7');
INSERT INTO class_marca VALUES ('1', 'Acura', 'eng', '7');
INSERT INTO class_marca VALUES ('1', 'Acura', 'german', '7');
INSERT INTO class_marca VALUES ('2', 'Aixam', 'ro', '7');
INSERT INTO class_marca VALUES ('2', 'Aixam', 'eng', '7');
INSERT INTO class_marca VALUES ('2', 'Aixam', 'german', '7');
INSERT INTO class_marca VALUES ('3', 'Alfa Romeo', 'ro', '7');
INSERT INTO class_marca VALUES ('3', 'Alfa Romeo', 'eng', '7');
INSERT INTO class_marca VALUES ('3', 'Alfa Romeo', 'german', '7');
INSERT INTO class_marca VALUES ('4', 'Aro', 'ro', '7');
INSERT INTO class_marca VALUES ('4', 'Aro', 'eng', '7');
INSERT INTO class_marca VALUES ('4', 'Aro', 'german', '7');
INSERT INTO class_marca VALUES ('5', 'Asia', 'ro', '7');
INSERT INTO class_marca VALUES ('5', 'Asia', 'eng', '7');
INSERT INTO class_marca VALUES ('5', 'Asia', 'german', '7');
INSERT INTO class_marca VALUES ('6', 'Aston Martin', 'ro', '7');
INSERT INTO class_marca VALUES ('6', 'Aston Martin', 'eng', '7');
INSERT INTO class_marca VALUES ('6', 'Aston Martin', 'german', '7');
INSERT INTO class_marca VALUES ('7', 'Audi', 'ro', '7');
INSERT INTO class_marca VALUES ('7', 'Audi', 'eng', '7');
INSERT INTO class_marca VALUES ('7', 'Audi', 'german', '7');
INSERT INTO class_marca VALUES ('8', 'Austin', 'ro', '7');
INSERT INTO class_marca VALUES ('8', 'Austin', 'eng', '7');
INSERT INTO class_marca VALUES ('8', 'Austin', 'german', '7');
INSERT INTO class_marca VALUES ('9', 'Autobianchi', 'ro', '7');
INSERT INTO class_marca VALUES ('9', 'Autobianchi', 'eng', '7');
INSERT INTO class_marca VALUES ('9', 'Autobianchi', 'german', '7');
INSERT INTO class_marca VALUES ('10', 'Bentley', 'ro', '7');
INSERT INTO class_marca VALUES ('10', 'Bentley', 'eng', '7');
INSERT INTO class_marca VALUES ('10', 'Bentley', 'german', '7');
INSERT INTO class_marca VALUES ('11', 'BMW', 'ro', '7');
INSERT INTO class_marca VALUES ('11', 'BMW', 'eng', '7');
INSERT INTO class_marca VALUES ('11', 'BMW', 'german', '7');
INSERT INTO class_marca VALUES ('12', 'Brilliance', 'ro', '7');
INSERT INTO class_marca VALUES ('12', 'Brilliance', 'eng', '7');
INSERT INTO class_marca VALUES ('12', 'Brilliance', 'german', '7');
INSERT INTO class_marca VALUES ('13', 'Bugatti', 'ro', '7');
INSERT INTO class_marca VALUES ('13', 'Bugatti', 'eng', '7');
INSERT INTO class_marca VALUES ('13', 'Bugatti', 'german', '7');
INSERT INTO class_marca VALUES ('14', 'Buick', 'ro', '7');
INSERT INTO class_marca VALUES ('14', 'Buick', 'eng', '7');
INSERT INTO class_marca VALUES ('14', 'Buick', 'german', '7');
INSERT INTO class_marca VALUES ('15', 'Cadillac', 'ro', '7');
INSERT INTO class_marca VALUES ('15', 'Cadillac', 'eng', '7');
INSERT INTO class_marca VALUES ('15', 'Cadillac', 'german', '7');
INSERT INTO class_marca VALUES ('16', 'Caterham', 'ro', '7');
INSERT INTO class_marca VALUES ('16', 'Caterham', 'eng', '7');
INSERT INTO class_marca VALUES ('16', 'Caterham', 'german', '7');
INSERT INTO class_marca VALUES ('17', 'Chatenet', 'ro', '7');
INSERT INTO class_marca VALUES ('17', 'Chatenet', 'eng', '7');
INSERT INTO class_marca VALUES ('17', 'Chatenet', 'german', '7');
INSERT INTO class_marca VALUES ('18', 'Chery', 'ro', '7');
INSERT INTO class_marca VALUES ('18', 'Chery', 'eng', '7');
INSERT INTO class_marca VALUES ('18', 'Chery', 'german', '7');
INSERT INTO class_marca VALUES ('19', 'Chevrolet', 'ro', '7');
INSERT INTO class_marca VALUES ('19', 'Chevrolet', 'eng', '7');
INSERT INTO class_marca VALUES ('19', 'Chevrolet', 'german', '7');
INSERT INTO class_marca VALUES ('20', 'Chrysler', 'ro', '7');
INSERT INTO class_marca VALUES ('20', 'Chrysler', 'eng', '7');
INSERT INTO class_marca VALUES ('20', 'Chrysler', 'german', '7');
INSERT INTO class_marca VALUES ('21', 'Citroen', 'ro', '7');
INSERT INTO class_marca VALUES ('21', 'Citroen', 'eng', '7');
INSERT INTO class_marca VALUES ('21', 'Citroen', 'german', '7');
INSERT INTO class_marca VALUES ('22', 'Comarth', 'ro', '7');
INSERT INTO class_marca VALUES ('22', 'Comarth', 'eng', '7');
INSERT INTO class_marca VALUES ('22', 'Comarth', 'german', '7');
INSERT INTO class_marca VALUES ('23', 'Dacia', 'ro', '7');
INSERT INTO class_marca VALUES ('23', 'Dacia', 'eng', '7');
INSERT INTO class_marca VALUES ('23', 'Dacia', 'german', '7');
INSERT INTO class_marca VALUES ('24', 'Daewoo', 'ro', '7');
INSERT INTO class_marca VALUES ('24', 'Daewoo', 'eng', '7');
INSERT INTO class_marca VALUES ('24', 'Daewoo', 'german', '7');
INSERT INTO class_marca VALUES ('25', 'Daihatsu', 'ro', '7');
INSERT INTO class_marca VALUES ('25', 'Daihatsu', 'eng', '7');
INSERT INTO class_marca VALUES ('25', 'Daihatsu', 'german', '7');
INSERT INTO class_marca VALUES ('26', 'De Lorean', 'ro', '7');
INSERT INTO class_marca VALUES ('26', 'De Lorean', 'eng', '7');
INSERT INTO class_marca VALUES ('26', 'De Lorean', 'german', '7');
INSERT INTO class_marca VALUES ('27', 'DFSK', 'ro', '7');
INSERT INTO class_marca VALUES ('27', 'DFSK', 'eng', '7');
INSERT INTO class_marca VALUES ('27', 'DFSK', 'german', '7');
INSERT INTO class_marca VALUES ('28', 'DKW', 'ro', '7');
INSERT INTO class_marca VALUES ('28', 'DKW', 'eng', '7');
INSERT INTO class_marca VALUES ('28', 'DKW', 'german', '7');
INSERT INTO class_marca VALUES ('29', 'Dodge', 'ro', '7');
INSERT INTO class_marca VALUES ('29', 'Dodge', 'eng', '7');
INSERT INTO class_marca VALUES ('29', 'Dodge', 'german', '7');
INSERT INTO class_marca VALUES ('30', 'DR', 'ro', '7');
INSERT INTO class_marca VALUES ('30', 'DR', 'eng', '7');
INSERT INTO class_marca VALUES ('30', 'DR', 'german', '7');
INSERT INTO class_marca VALUES ('31', 'Eagle', 'ro', '7');
INSERT INTO class_marca VALUES ('31', 'Eagle', 'eng', '7');
INSERT INTO class_marca VALUES ('31', 'Eagle', 'german', '7');
INSERT INTO class_marca VALUES ('32', 'Excalibur', 'ro', '7');
INSERT INTO class_marca VALUES ('32', 'Excalibur', 'eng', '7');
INSERT INTO class_marca VALUES ('32', 'Excalibur', 'german', '7');
INSERT INTO class_marca VALUES ('33', 'FAW', 'ro', '7');
INSERT INTO class_marca VALUES ('33', 'FAW', 'eng', '7');
INSERT INTO class_marca VALUES ('33', 'FAW', 'german', '7');
INSERT INTO class_marca VALUES ('34', 'Ferrari', 'ro', '7');
INSERT INTO class_marca VALUES ('34', 'Ferrari', 'eng', '7');
INSERT INTO class_marca VALUES ('34', 'Ferrari', 'german', '7');
INSERT INTO class_marca VALUES ('35', 'Fiat', 'ro', '7');
INSERT INTO class_marca VALUES ('35', 'Fiat', 'eng', '7');
INSERT INTO class_marca VALUES ('35', 'Fiat', 'german', '7');
INSERT INTO class_marca VALUES ('36', 'Ford', 'ro', '7');
INSERT INTO class_marca VALUES ('36', 'Ford', 'eng', '7');
INSERT INTO class_marca VALUES ('36', 'Ford', 'german', '7');
INSERT INTO class_marca VALUES ('37', 'Galloper', 'ro', '7');
INSERT INTO class_marca VALUES ('37', 'Galloper', 'eng', '7');
INSERT INTO class_marca VALUES ('37', 'Galloper', 'german', '7');
INSERT INTO class_marca VALUES ('38', 'Gaz', 'ro', '7');
INSERT INTO class_marca VALUES ('38', 'Gaz', 'eng', '7');
INSERT INTO class_marca VALUES ('38', 'Gaz', 'german', '7');
INSERT INTO class_marca VALUES ('39', 'Geely', 'ro', '7');
INSERT INTO class_marca VALUES ('39', 'Geely', 'eng', '7');
INSERT INTO class_marca VALUES ('39', 'Geely', 'german', '7');
INSERT INTO class_marca VALUES ('40', 'GMC', 'ro', '7');
INSERT INTO class_marca VALUES ('40', 'GMC', 'eng', '7');
INSERT INTO class_marca VALUES ('40', 'GMC', 'german', '7');
INSERT INTO class_marca VALUES ('41', 'Gonow', 'ro', '7');
INSERT INTO class_marca VALUES ('41', 'Gonow', 'eng', '7');
INSERT INTO class_marca VALUES ('41', 'Gonow', 'german', '7');
INSERT INTO class_marca VALUES ('42', 'Grecav', 'ro', '7');
INSERT INTO class_marca VALUES ('42', 'Grecav', 'eng', '7');
INSERT INTO class_marca VALUES ('42', 'Grecav', 'german', '7');
INSERT INTO class_marca VALUES ('43', 'GWM', 'ro', '7');
INSERT INTO class_marca VALUES ('43', 'GWM', 'eng', '7');
INSERT INTO class_marca VALUES ('43', 'GWM', 'german', '7');
INSERT INTO class_marca VALUES ('44', 'Holden', 'ro', '7');
INSERT INTO class_marca VALUES ('44', 'Holden', 'eng', '7');
INSERT INTO class_marca VALUES ('44', 'Holden', 'german', '7');
INSERT INTO class_marca VALUES ('45', 'Honda', 'ro', '7');
INSERT INTO class_marca VALUES ('45', 'Honda', 'eng', '7');
INSERT INTO class_marca VALUES ('45', 'Honda', 'german', '7');
INSERT INTO class_marca VALUES ('46', 'Hummer', 'ro', '7');
INSERT INTO class_marca VALUES ('46', 'Hummer', 'eng', '7');
INSERT INTO class_marca VALUES ('46', 'Hummer', 'german', '7');
INSERT INTO class_marca VALUES ('47', 'Hyundai', 'ro', '7');
INSERT INTO class_marca VALUES ('47', 'Hyundai', 'eng', '7');
INSERT INTO class_marca VALUES ('47', 'Hyundai', 'german', '7');
INSERT INTO class_marca VALUES ('48', 'Infiniti', 'ro', '7');
INSERT INTO class_marca VALUES ('48', 'Infiniti', 'eng', '7');
INSERT INTO class_marca VALUES ('48', 'Infiniti', 'german', '7');
INSERT INTO class_marca VALUES ('49', 'Isuzu', 'ro', '7');
INSERT INTO class_marca VALUES ('49', 'Isuzu', 'eng', '7');
INSERT INTO class_marca VALUES ('49', 'Isuzu', 'german', '7');
INSERT INTO class_marca VALUES ('50', 'Iveco', 'ro', '7');
INSERT INTO class_marca VALUES ('50', 'Iveco', 'eng', '7');
INSERT INTO class_marca VALUES ('50', 'Iveco', 'german', '7');
INSERT INTO class_marca VALUES ('51', 'Jaguar', 'ro', '7');
INSERT INTO class_marca VALUES ('51', 'Jaguar', 'eng', '7');
INSERT INTO class_marca VALUES ('51', 'Jaguar', 'german', '7');
INSERT INTO class_marca VALUES ('52', 'Jeep', 'ro', '7');
INSERT INTO class_marca VALUES ('52', 'Jeep', 'eng', '7');
INSERT INTO class_marca VALUES ('52', 'Jeep', 'german', '7');
INSERT INTO class_marca VALUES ('53', 'Kaipan', 'ro', '7');
INSERT INTO class_marca VALUES ('53', 'Kaipan', 'eng', '7');
INSERT INTO class_marca VALUES ('53', 'Kaipan', 'german', '7');
INSERT INTO class_marca VALUES ('54', 'Kia', 'ro', '7');
INSERT INTO class_marca VALUES ('54', 'Kia', 'eng', '7');
INSERT INTO class_marca VALUES ('54', 'Kia', 'german', '7');
INSERT INTO class_marca VALUES ('55', 'Lada', 'ro', '7');
INSERT INTO class_marca VALUES ('55', 'Lada', 'eng', '7');
INSERT INTO class_marca VALUES ('55', 'Lada', 'german', '7');
INSERT INTO class_marca VALUES ('56', 'Lamborghini', 'ro', '7');
INSERT INTO class_marca VALUES ('56', 'Lamborghini', 'eng', '7');
INSERT INTO class_marca VALUES ('56', 'Lamborghini', 'german', '7');
INSERT INTO class_marca VALUES ('57', 'Lancia', 'ro', '7');
INSERT INTO class_marca VALUES ('57', 'Lancia', 'eng', '7');
INSERT INTO class_marca VALUES ('57', 'Lancia', 'german', '7');
INSERT INTO class_marca VALUES ('58', 'Land Rover', 'ro', '7');
INSERT INTO class_marca VALUES ('58', 'Land Rover', 'eng', '7');
INSERT INTO class_marca VALUES ('58', 'Land Rover', 'german', '7');
INSERT INTO class_marca VALUES ('59', 'Lexus', 'ro', '7');
INSERT INTO class_marca VALUES ('59', 'Lexus', 'eng', '7');
INSERT INTO class_marca VALUES ('59', 'Lexus', 'german', '7');
INSERT INTO class_marca VALUES ('60', 'Ligier', 'ro', '7');
INSERT INTO class_marca VALUES ('60', 'Ligier', 'eng', '7');
INSERT INTO class_marca VALUES ('60', 'Ligier', 'german', '7');
INSERT INTO class_marca VALUES ('61', 'Lincoln', 'ro', '7');
INSERT INTO class_marca VALUES ('61', 'Lincoln', 'eng', '7');
INSERT INTO class_marca VALUES ('61', 'Lincoln', 'german', '7');
INSERT INTO class_marca VALUES ('62', 'Lotus', 'ro', '7');
INSERT INTO class_marca VALUES ('62', 'Lotus', 'eng', '7');
INSERT INTO class_marca VALUES ('62', 'Lotus', 'german', '7');
INSERT INTO class_marca VALUES ('63', 'LTI', 'ro', '7');
INSERT INTO class_marca VALUES ('63', 'LTI', 'eng', '7');
INSERT INTO class_marca VALUES ('63', 'LTI', 'german', '7');
INSERT INTO class_marca VALUES ('64', 'LuAZ', 'ro', '7');
INSERT INTO class_marca VALUES ('64', 'LuAZ', 'eng', '7');
INSERT INTO class_marca VALUES ('64', 'LuAZ', 'german', '7');
INSERT INTO class_marca VALUES ('65', 'Mahindra', 'ro', '7');
INSERT INTO class_marca VALUES ('65', 'Mahindra', 'eng', '7');
INSERT INTO class_marca VALUES ('65', 'Mahindra', 'german', '7');
INSERT INTO class_marca VALUES ('66', 'Maruti', 'ro', '7');
INSERT INTO class_marca VALUES ('66', 'Maruti', 'eng', '7');
INSERT INTO class_marca VALUES ('66', 'Maruti', 'german', '7');
INSERT INTO class_marca VALUES ('67', 'Maserati', 'ro', '7');
INSERT INTO class_marca VALUES ('67', 'Maserati', 'eng', '7');
INSERT INTO class_marca VALUES ('67', 'Maserati', 'german', '7');
INSERT INTO class_marca VALUES ('68', 'Maybach', 'ro', '7');
INSERT INTO class_marca VALUES ('68', 'Maybach', 'eng', '7');
INSERT INTO class_marca VALUES ('68', 'Maybach', 'german', '7');
INSERT INTO class_marca VALUES ('69', 'Mazda', 'ro', '7');
INSERT INTO class_marca VALUES ('69', 'Mazda', 'eng', '7');
INSERT INTO class_marca VALUES ('69', 'Mazda', 'german', '7');
INSERT INTO class_marca VALUES ('70', 'McLaren', 'ro', '7');
INSERT INTO class_marca VALUES ('70', 'McLaren', 'eng', '7');
INSERT INTO class_marca VALUES ('70', 'McLaren', 'german', '7');
INSERT INTO class_marca VALUES ('71', 'Mercedes-Benz', 'ro', '7');
INSERT INTO class_marca VALUES ('71', 'Mercedes-Benz', 'eng', '7');
INSERT INTO class_marca VALUES ('71', 'Mercedes-Benz', 'german', '7');
INSERT INTO class_marca VALUES ('72', 'Mercury', 'ro', '7');
INSERT INTO class_marca VALUES ('72', 'Mercury', 'eng', '7');
INSERT INTO class_marca VALUES ('72', 'Mercury', 'german', '7');
INSERT INTO class_marca VALUES ('73', 'MG', 'ro', '7');
INSERT INTO class_marca VALUES ('73', 'MG', 'eng', '7');
INSERT INTO class_marca VALUES ('73', 'MG', 'german', '7');
INSERT INTO class_marca VALUES ('74', 'Microcar', 'ro', '7');
INSERT INTO class_marca VALUES ('74', 'Microcar', 'eng', '7');
INSERT INTO class_marca VALUES ('74', 'Microcar', 'german', '7');
INSERT INTO class_marca VALUES ('75', 'Mini', 'ro', '7');
INSERT INTO class_marca VALUES ('75', 'Mini', 'eng', '7');
INSERT INTO class_marca VALUES ('75', 'Mini', 'german', '7');
INSERT INTO class_marca VALUES ('76', 'Mitsubishi', 'ro', '7');
INSERT INTO class_marca VALUES ('76', 'Mitsubishi', 'eng', '7');
INSERT INTO class_marca VALUES ('76', 'Mitsubishi', 'german', '7');
INSERT INTO class_marca VALUES ('77', 'Morgan', 'ro', '7');
INSERT INTO class_marca VALUES ('77', 'Morgan', 'eng', '7');
INSERT INTO class_marca VALUES ('77', 'Morgan', 'german', '7');
INSERT INTO class_marca VALUES ('78', 'Moskwicz', 'ro', '7');
INSERT INTO class_marca VALUES ('78', 'Moskwicz', 'eng', '7');
INSERT INTO class_marca VALUES ('78', 'Moskwicz', 'german', '7');
INSERT INTO class_marca VALUES ('79', 'Nissan', 'ro', '7');
INSERT INTO class_marca VALUES ('79', 'Nissan', 'eng', '7');
INSERT INTO class_marca VALUES ('79', 'Nissan', 'german', '7');
INSERT INTO class_marca VALUES ('80', 'NSU', 'ro', '7');
INSERT INTO class_marca VALUES ('80', 'NSU', 'eng', '7');
INSERT INTO class_marca VALUES ('80', 'NSU', 'german', '7');
INSERT INTO class_marca VALUES ('81', 'Nysa', 'ro', '7');
INSERT INTO class_marca VALUES ('81', 'Nysa', 'eng', '7');
INSERT INTO class_marca VALUES ('81', 'Nysa', 'german', '7');
INSERT INTO class_marca VALUES ('82', 'Oldsmobile', 'ro', '7');
INSERT INTO class_marca VALUES ('82', 'Oldsmobile', 'eng', '7');
INSERT INTO class_marca VALUES ('82', 'Oldsmobile', 'german', '7');
INSERT INTO class_marca VALUES ('83', 'Oltcit', 'ro', '7');
INSERT INTO class_marca VALUES ('83', 'Oltcit', 'eng', '7');
INSERT INTO class_marca VALUES ('83', 'Oltcit', 'german', '7');
INSERT INTO class_marca VALUES ('84', 'Opel', 'ro', '7');
INSERT INTO class_marca VALUES ('84', 'Opel', 'eng', '7');
INSERT INTO class_marca VALUES ('84', 'Opel', 'german', '7');
INSERT INTO class_marca VALUES ('85', 'Peugeot', 'ro', '7');
INSERT INTO class_marca VALUES ('85', 'Peugeot', 'eng', '7');
INSERT INTO class_marca VALUES ('85', 'Peugeot', 'german', '7');
INSERT INTO class_marca VALUES ('86', 'Piaggio', 'ro', '7');
INSERT INTO class_marca VALUES ('86', 'Piaggio', 'eng', '7');
INSERT INTO class_marca VALUES ('86', 'Piaggio', 'german', '7');
INSERT INTO class_marca VALUES ('87', 'Plymouth', 'ro', '7');
INSERT INTO class_marca VALUES ('87', 'Plymouth', 'eng', '7');
INSERT INTO class_marca VALUES ('87', 'Plymouth', 'german', '7');
INSERT INTO class_marca VALUES ('88', 'Polonez', 'ro', '7');
INSERT INTO class_marca VALUES ('88', 'Polonez', 'eng', '7');
INSERT INTO class_marca VALUES ('88', 'Polonez', 'german', '7');
INSERT INTO class_marca VALUES ('89', 'Pontiac', 'ro', '7');
INSERT INTO class_marca VALUES ('89', 'Pontiac', 'eng', '7');
INSERT INTO class_marca VALUES ('89', 'Pontiac', 'german', '7');
INSERT INTO class_marca VALUES ('90', 'Porsche', 'ro', '7');
INSERT INTO class_marca VALUES ('90', 'Porsche', 'eng', '7');
INSERT INTO class_marca VALUES ('90', 'Porsche', 'german', '7');
INSERT INTO class_marca VALUES ('91', 'Proton', 'ro', '7');
INSERT INTO class_marca VALUES ('91', 'Proton', 'eng', '7');
INSERT INTO class_marca VALUES ('91', 'Proton', 'german', '7');
INSERT INTO class_marca VALUES ('92', 'Rayton Fissore', 'ro', '7');
INSERT INTO class_marca VALUES ('92', 'Rayton Fissore', 'eng', '7');
INSERT INTO class_marca VALUES ('92', 'Rayton Fissore', 'german', '7');
INSERT INTO class_marca VALUES ('93', 'Renault', 'ro', '7');
INSERT INTO class_marca VALUES ('93', 'Renault', 'eng', '7');
INSERT INTO class_marca VALUES ('93', 'Renault', 'german', '7');
INSERT INTO class_marca VALUES ('94', 'Rolls-Royce', 'ro', '7');
INSERT INTO class_marca VALUES ('94', 'Rolls-Royce', 'eng', '7');
INSERT INTO class_marca VALUES ('94', 'Rolls-Royce', 'german', '7');
INSERT INTO class_marca VALUES ('95', 'Rover', 'ro', '7');
INSERT INTO class_marca VALUES ('95', 'Rover', 'eng', '7');
INSERT INTO class_marca VALUES ('95', 'Rover', 'german', '7');
INSERT INTO class_marca VALUES ('96', 'Saab', 'ro', '7');
INSERT INTO class_marca VALUES ('96', 'Saab', 'eng', '7');
INSERT INTO class_marca VALUES ('96', 'Saab', 'german', '7');
INSERT INTO class_marca VALUES ('97', 'Samsung', 'ro', '7');
INSERT INTO class_marca VALUES ('97', 'Samsung', 'eng', '7');
INSERT INTO class_marca VALUES ('97', 'Samsung', 'german', '7');
INSERT INTO class_marca VALUES ('98', 'Santana', 'ro', '7');
INSERT INTO class_marca VALUES ('98', 'Santana', 'eng', '7');
INSERT INTO class_marca VALUES ('98', 'Santana', 'german', '7');
INSERT INTO class_marca VALUES ('99', 'Saturn', 'ro', '7');
INSERT INTO class_marca VALUES ('99', 'Saturn', 'eng', '7');
INSERT INTO class_marca VALUES ('99', 'Saturn', 'german', '7');
INSERT INTO class_marca VALUES ('100', 'Scion', 'ro', '7');
INSERT INTO class_marca VALUES ('100', 'Scion', 'eng', '7');
INSERT INTO class_marca VALUES ('100', 'Scion', 'german', '7');
INSERT INTO class_marca VALUES ('101', 'Seat', 'ro', '7');
INSERT INTO class_marca VALUES ('101', 'Seat', 'eng', '7');
INSERT INTO class_marca VALUES ('101', 'Seat', 'german', '7');
INSERT INTO class_marca VALUES ('102', 'Shuanghuan', 'ro', '7');
INSERT INTO class_marca VALUES ('102', 'Shuanghuan', 'eng', '7');
INSERT INTO class_marca VALUES ('102', 'Shuanghuan', 'german', '7');
INSERT INTO class_marca VALUES ('103', 'Skoda', 'ro', '7');
INSERT INTO class_marca VALUES ('103', 'Skoda', 'eng', '7');
INSERT INTO class_marca VALUES ('103', 'Skoda', 'german', '7');
INSERT INTO class_marca VALUES ('104', 'Smart', 'ro', '7');
INSERT INTO class_marca VALUES ('104', 'Smart', 'eng', '7');
INSERT INTO class_marca VALUES ('104', 'Smart', 'german', '7');
INSERT INTO class_marca VALUES ('105', 'SsangYong', 'ro', '7');
INSERT INTO class_marca VALUES ('105', 'SsangYong', 'eng', '7');
INSERT INTO class_marca VALUES ('105', 'SsangYong', 'german', '7');
INSERT INTO class_marca VALUES ('106', 'Subaru', 'ro', '7');
INSERT INTO class_marca VALUES ('106', 'Subaru', 'eng', '7');
INSERT INTO class_marca VALUES ('106', 'Subaru', 'german', '7');
INSERT INTO class_marca VALUES ('107', 'Suzuki', 'ro', '7');
INSERT INTO class_marca VALUES ('107', 'Suzuki', 'eng', '7');
INSERT INTO class_marca VALUES ('107', 'Suzuki', 'german', '7');
INSERT INTO class_marca VALUES ('108', 'Syrena', 'ro', '7');
INSERT INTO class_marca VALUES ('108', 'Syrena', 'eng', '7');
INSERT INTO class_marca VALUES ('108', 'Syrena', 'german', '7');
INSERT INTO class_marca VALUES ('109', 'Talbot', 'ro', '7');
INSERT INTO class_marca VALUES ('109', 'Talbot', 'eng', '7');
INSERT INTO class_marca VALUES ('109', 'Talbot', 'german', '7');
INSERT INTO class_marca VALUES ('110', 'Tarpan', 'ro', '7');
INSERT INTO class_marca VALUES ('110', 'Tarpan', 'eng', '7');
INSERT INTO class_marca VALUES ('110', 'Tarpan', 'german', '7');
INSERT INTO class_marca VALUES ('111', 'Tata', 'ro', '7');
INSERT INTO class_marca VALUES ('111', 'Tata', 'eng', '7');
INSERT INTO class_marca VALUES ('111', 'Tata', 'german', '7');
INSERT INTO class_marca VALUES ('112', 'Tatra', 'ro', '7');
INSERT INTO class_marca VALUES ('112', 'Tatra', 'eng', '7');
INSERT INTO class_marca VALUES ('112', 'Tatra', 'german', '7');
INSERT INTO class_marca VALUES ('113', 'Tavria', 'ro', '7');
INSERT INTO class_marca VALUES ('113', 'Tavria', 'eng', '7');
INSERT INTO class_marca VALUES ('113', 'Tavria', 'german', '7');
INSERT INTO class_marca VALUES ('114', 'Tesla', 'ro', '7');
INSERT INTO class_marca VALUES ('114', 'Tesla', 'eng', '7');
INSERT INTO class_marca VALUES ('114', 'Tesla', 'german', '7');
INSERT INTO class_marca VALUES ('115', 'Toyota', 'ro', '7');
INSERT INTO class_marca VALUES ('115', 'Toyota', 'eng', '7');
INSERT INTO class_marca VALUES ('115', 'Toyota', 'german', '7');
INSERT INTO class_marca VALUES ('116', 'Trabant', 'ro', '7');
INSERT INTO class_marca VALUES ('116', 'Trabant', 'eng', '7');
INSERT INTO class_marca VALUES ('116', 'Trabant', 'german', '7');
INSERT INTO class_marca VALUES ('117', 'Triumph', 'ro', '7');
INSERT INTO class_marca VALUES ('117', 'Triumph', 'eng', '7');
INSERT INTO class_marca VALUES ('117', 'Triumph', 'german', '7');
INSERT INTO class_marca VALUES ('118', 'TVR', 'ro', '7');
INSERT INTO class_marca VALUES ('118', 'TVR', 'eng', '7');
INSERT INTO class_marca VALUES ('118', 'TVR', 'german', '7');
INSERT INTO class_marca VALUES ('119', 'Uaz', 'ro', '7');
INSERT INTO class_marca VALUES ('119', 'Uaz', 'eng', '7');
INSERT INTO class_marca VALUES ('119', 'Uaz', 'german', '7');
INSERT INTO class_marca VALUES ('120', 'Vauxhall', 'ro', '7');
INSERT INTO class_marca VALUES ('120', 'Vauxhall', 'eng', '7');
INSERT INTO class_marca VALUES ('120', 'Vauxhall', 'german', '7');
INSERT INTO class_marca VALUES ('121', 'Volkswagen', 'ro', '7');
INSERT INTO class_marca VALUES ('121', 'Volkswagen', 'eng', '7');
INSERT INTO class_marca VALUES ('121', 'Volkswagen', 'german', '7');
INSERT INTO class_marca VALUES ('122', 'Volvo', 'ro', '7');
INSERT INTO class_marca VALUES ('122', 'Volvo', 'eng', '7');
INSERT INTO class_marca VALUES ('122', 'Volvo', 'german', '7');
INSERT INTO class_marca VALUES ('123', 'Warszawa', 'ro', '7');
INSERT INTO class_marca VALUES ('123', 'Warszawa', 'eng', '7');
INSERT INTO class_marca VALUES ('123', 'Warszawa', 'german', '7');
INSERT INTO class_marca VALUES ('124', 'Wartburg', 'ro', '7');
INSERT INTO class_marca VALUES ('124', 'Wartburg', 'eng', '7');
INSERT INTO class_marca VALUES ('124', 'Wartburg', 'german', '7');
INSERT INTO class_marca VALUES ('125', 'Weismann', 'ro', '7');
INSERT INTO class_marca VALUES ('125', 'Weismann', 'eng', '7');
INSERT INTO class_marca VALUES ('125', 'Weismann', 'german', '7');
INSERT INTO class_marca VALUES ('131', 'Wolga', 'german', '7');
INSERT INTO class_marca VALUES ('131', 'Wolga', 'eng', '7');
INSERT INTO class_marca VALUES ('131', 'Wolga', 'ro', '7');
INSERT INTO class_marca VALUES ('127', 'Yugo', 'ro', '7');
INSERT INTO class_marca VALUES ('127', 'Yugo', 'eng', '7');
INSERT INTO class_marca VALUES ('127', 'Yugo', 'german', '7');
INSERT INTO class_marca VALUES ('128', 'Zaporozec', 'ro', '7');
INSERT INTO class_marca VALUES ('128', 'Zaporozec', 'eng', '7');
INSERT INTO class_marca VALUES ('128', 'Zaporozec', 'german', '7');
INSERT INTO class_marca VALUES ('129', 'Zastawa', 'ro', '7');
INSERT INTO class_marca VALUES ('129', 'Zastawa', 'eng', '7');
INSERT INTO class_marca VALUES ('129', 'Zastawa', 'german', '7');
INSERT INTO class_marca VALUES ('130', 'Zuk', 'ro', '7');
INSERT INTO class_marca VALUES ('130', 'Zuk', 'eng', '7');
INSERT INTO class_marca VALUES ('130', 'Zuk', 'german', '7');


#
# Table structure for table `class_mb_return`
#

DROP TABLE IF EXISTS `class_mb_return`;
CREATE TABLE `class_mb_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `pay_to_email` varchar(128) DEFAULT NULL,
  `pay_from_email` varchar(128) DEFAULT NULL,
  `merchant_id` varchar(100) DEFAULT NULL,
  `customer_id` varchar(100) DEFAULT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `mb_transaction_id` varchar(50) DEFAULT NULL,
  `mb_amount` varchar(30) DEFAULT NULL,
  `mb_currency` varchar(10) DEFAULT NULL,
  `status` varchar(3) DEFAULT NULL,
  `md5sig` varchar(128) DEFAULT NULL,
  `amount` varchar(30) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `payment_type` varchar(50) DEFAULT NULL,
  `entirepost` text,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_mb_return`
#



#
# Table structure for table `class_mb_settings`
#

DROP TABLE IF EXISTS `class_mb_settings`;
CREATE TABLE `class_mb_settings` (
  `mb_email` varchar(128) DEFAULT NULL,
  `mb_secret` varchar(10) DEFAULT NULL,
  `mb_currency` char(3) DEFAULT NULL,
  `mb_language` char(3) DEFAULT NULL,
  `mb_pay_title` varchar(128) DEFAULT NULL,
  `mb_demo` tinyint(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_mb_settings`
#

INSERT INTO class_mb_settings VALUES ('email@yoursite.com', '', 'USD', 'EN', 'Classifieds Payment', '0');


#
# Table structure for table `class_messages`
#

DROP TABLE IF EXISTS `class_messages`;
CREATE TABLE `class_messages` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `from` int(10) DEFAULT NULL,
  `from_email` varchar(50) DEFAULT NULL,
  `to` int(10) DEFAULT NULL,
  `to_email` varchar(50) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ip` varchar(15) DEFAULT NULL,
  `ad_id` int(10) DEFAULT NULL,
  `message` text,
  `report` tinyint(1) DEFAULT '0',
  `reply_to` int(10) DEFAULT '0',
  `starting` int(10) DEFAULT '0',
  `pending` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_from` (`from`),
  KEY `idx_to` (`to`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_messages`
#



#
# Table structure for table `class_mobile_settings`
#

DROP TABLE IF EXISTS `class_mobile_settings`;
CREATE TABLE `class_mobile_settings` (
  `enable_mobile_templates` tinyint(1) DEFAULT '1',
  `mobile_template` varchar(40) DEFAULT NULL,
  `enable_mobile_subdomain` tinyint(1) DEFAULT '0',
  `mobile_thmb_width` int(4) DEFAULT '65',
  `mobile_thmb_height` int(4) DEFAULT '50',
  `mobile_big_thmb_width` int(4) DEFAULT '250',
  `mobile_big_thmb_height` int(4) DEFAULT '220',
  `mobile_nopic` varchar(128) DEFAULT NULL,
  `mobile_big_nopic` varchar(128) DEFAULT NULL,
  `mobile_show_header` tinyint(1) DEFAULT '1',
  `mobile_header_pic` varchar(128) DEFAULT NULL,
  `mobile_header_pic_link` varchar(128) DEFAULT NULL,
  `mobile_ads_per_page` int(2) DEFAULT '10'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_mobile_settings`
#

INSERT INTO class_mobile_settings VALUES ('1', 'minimal_blue', '0', '65', '50', '250', '220', 'noimage_mobile.jpg', 'mobile_big_nopic.gif', '1', 'mobile_logo.png', '', '10');


#
# Table structure for table `class_model`
#

DROP TABLE IF EXISTS `class_model`;
CREATE TABLE `class_model` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `dep` int(2) DEFAULT NULL,
  `name` varchar(64) DEFAULT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  KEY `id` (`id`),
  KEY `idx_lang_id` (`lang_id`),
  KEY `idx_dep` (`dep`)
) ENGINE=MyISAM AUTO_INCREMENT=1734 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_model`
#

INSERT INTO class_model VALUES ('1', '1', 'CL', 'ro');
INSERT INTO class_model VALUES ('1', '1', 'CL', 'eng');
INSERT INTO class_model VALUES ('1', '1', 'CL', 'german');
INSERT INTO class_model VALUES ('2', '1', 'Integra', 'ro');
INSERT INTO class_model VALUES ('2', '1', 'Integra', 'eng');
INSERT INTO class_model VALUES ('2', '1', 'Integra', 'german');
INSERT INTO class_model VALUES ('3', '1', 'Legend', 'ro');
INSERT INTO class_model VALUES ('3', '1', 'Legend', 'eng');
INSERT INTO class_model VALUES ('3', '1', 'Legend', 'german');
INSERT INTO class_model VALUES ('4', '1', 'MDX', 'ro');
INSERT INTO class_model VALUES ('4', '1', 'MDX', 'eng');
INSERT INTO class_model VALUES ('4', '1', 'MDX', 'german');
INSERT INTO class_model VALUES ('5', '1', 'NSX', 'ro');
INSERT INTO class_model VALUES ('5', '1', 'NSX', 'eng');
INSERT INTO class_model VALUES ('5', '1', 'NSX', 'german');
INSERT INTO class_model VALUES ('6', '1', 'RDX', 'ro');
INSERT INTO class_model VALUES ('6', '1', 'RDX', 'eng');
INSERT INTO class_model VALUES ('6', '1', 'RDX', 'german');
INSERT INTO class_model VALUES ('7', '1', 'RL', 'ro');
INSERT INTO class_model VALUES ('7', '1', 'RL', 'eng');
INSERT INTO class_model VALUES ('7', '1', 'RL', 'german');
INSERT INTO class_model VALUES ('8', '1', 'RSX', 'ro');
INSERT INTO class_model VALUES ('8', '1', 'RSX', 'eng');
INSERT INTO class_model VALUES ('8', '1', 'RSX', 'german');
INSERT INTO class_model VALUES ('9', '1', 'TL]TSX', 'ro');
INSERT INTO class_model VALUES ('9', '1', 'TL]TSX', 'eng');
INSERT INTO class_model VALUES ('9', '1', 'TL]TSX', 'german');
INSERT INTO class_model VALUES ('10', '1', 'Vigor', 'ro');
INSERT INTO class_model VALUES ('10', '1', 'Vigor', 'eng');
INSERT INTO class_model VALUES ('10', '1', 'Vigor', 'german');
INSERT INTO class_model VALUES ('11', '1', 'ZDX', 'ro');
INSERT INTO class_model VALUES ('11', '1', 'ZDX', 'eng');
INSERT INTO class_model VALUES ('11', '1', 'ZDX', 'german');
INSERT INTO class_model VALUES ('12', '2', 'A721', 'ro');
INSERT INTO class_model VALUES ('12', '2', 'A721', 'eng');
INSERT INTO class_model VALUES ('12', '2', 'A721', 'german');
INSERT INTO class_model VALUES ('13', '2', 'A741', 'ro');
INSERT INTO class_model VALUES ('13', '2', 'A741', 'eng');
INSERT INTO class_model VALUES ('13', '2', 'A741', 'german');
INSERT INTO class_model VALUES ('14', '2', 'A751', 'ro');
INSERT INTO class_model VALUES ('14', '2', 'A751', 'eng');
INSERT INTO class_model VALUES ('14', '2', 'A751', 'german');
INSERT INTO class_model VALUES ('15', '2', 'City', 'ro');
INSERT INTO class_model VALUES ('15', '2', 'City', 'eng');
INSERT INTO class_model VALUES ('15', '2', 'City', 'german');
INSERT INTO class_model VALUES ('16', '2', 'Coupe', 'ro');
INSERT INTO class_model VALUES ('16', '2', 'Coupe', 'eng');
INSERT INTO class_model VALUES ('16', '2', 'Coupe', 'german');
INSERT INTO class_model VALUES ('17', '2', 'Crossline', 'ro');
INSERT INTO class_model VALUES ('17', '2', 'Crossline', 'eng');
INSERT INTO class_model VALUES ('17', '2', 'Crossline', 'german');
INSERT INTO class_model VALUES ('18', '2', 'Crossover', 'ro');
INSERT INTO class_model VALUES ('18', '2', 'Crossover', 'eng');
INSERT INTO class_model VALUES ('18', '2', 'Crossover', 'german');
INSERT INTO class_model VALUES ('19', '2', 'GTO', 'ro');
INSERT INTO class_model VALUES ('19', '2', 'GTO', 'eng');
INSERT INTO class_model VALUES ('19', '2', 'GTO', 'german');
INSERT INTO class_model VALUES ('20', '2', 'Roadline', 'ro');
INSERT INTO class_model VALUES ('20', '2', 'Roadline', 'eng');
INSERT INTO class_model VALUES ('20', '2', 'Roadline', 'german');
INSERT INTO class_model VALUES ('21', '2', 'Scouty', 'ro');
INSERT INTO class_model VALUES ('21', '2', 'Scouty', 'eng');
INSERT INTO class_model VALUES ('21', '2', 'Scouty', 'german');
INSERT INTO class_model VALUES ('22', '2', 'Scouty R', 'ro');
INSERT INTO class_model VALUES ('22', '2', 'Scouty R', 'eng');
INSERT INTO class_model VALUES ('22', '2', 'Scouty R', 'german');
INSERT INTO class_model VALUES ('23', '3', '145', 'ro');
INSERT INTO class_model VALUES ('23', '3', '145', 'eng');
INSERT INTO class_model VALUES ('23', '3', '145', 'german');
INSERT INTO class_model VALUES ('24', '3', '146', 'ro');
INSERT INTO class_model VALUES ('24', '3', '146', 'eng');
INSERT INTO class_model VALUES ('24', '3', '146', 'german');
INSERT INTO class_model VALUES ('25', '3', '147', 'ro');
INSERT INTO class_model VALUES ('25', '3', '147', 'eng');
INSERT INTO class_model VALUES ('25', '3', '147', 'german');
INSERT INTO class_model VALUES ('26', '3', '155', 'ro');
INSERT INTO class_model VALUES ('26', '3', '155', 'eng');
INSERT INTO class_model VALUES ('26', '3', '155', 'german');
INSERT INTO class_model VALUES ('27', '3', '156', 'ro');
INSERT INTO class_model VALUES ('27', '3', '156', 'eng');
INSERT INTO class_model VALUES ('27', '3', '156', 'german');
INSERT INTO class_model VALUES ('28', '3', '159', 'ro');
INSERT INTO class_model VALUES ('28', '3', '159', 'eng');
INSERT INTO class_model VALUES ('28', '3', '159', 'german');
INSERT INTO class_model VALUES ('29', '3', '164', 'ro');
INSERT INTO class_model VALUES ('29', '3', '164', 'eng');
INSERT INTO class_model VALUES ('29', '3', '164', 'german');
INSERT INTO class_model VALUES ('30', '3', '166', 'ro');
INSERT INTO class_model VALUES ('30', '3', '166', 'eng');
INSERT INTO class_model VALUES ('30', '3', '166', 'german');
INSERT INTO class_model VALUES ('31', '3', '33', 'ro');
INSERT INTO class_model VALUES ('31', '3', '33', 'eng');
INSERT INTO class_model VALUES ('31', '3', '33', 'german');
INSERT INTO class_model VALUES ('32', '3', '4C', 'ro');
INSERT INTO class_model VALUES ('32', '3', '4C', 'eng');
INSERT INTO class_model VALUES ('32', '3', '4C', 'german');
INSERT INTO class_model VALUES ('33', '3', '75', 'ro');
INSERT INTO class_model VALUES ('33', '3', '75', 'eng');
INSERT INTO class_model VALUES ('33', '3', '75', 'german');
INSERT INTO class_model VALUES ('34', '3', '90', 'ro');
INSERT INTO class_model VALUES ('34', '3', '90', 'eng');
INSERT INTO class_model VALUES ('34', '3', '90', 'german');
INSERT INTO class_model VALUES ('35', '3', 'Alfasud', 'ro');
INSERT INTO class_model VALUES ('35', '3', 'Alfasud', 'eng');
INSERT INTO class_model VALUES ('35', '3', 'Alfasud', 'german');
INSERT INTO class_model VALUES ('36', '3', 'Alfetta', 'ro');
INSERT INTO class_model VALUES ('36', '3', 'Alfetta', 'eng');
INSERT INTO class_model VALUES ('36', '3', 'Alfetta', 'german');
INSERT INTO class_model VALUES ('37', '3', 'Brera', 'ro');
INSERT INTO class_model VALUES ('37', '3', 'Brera', 'eng');
INSERT INTO class_model VALUES ('37', '3', 'Brera', 'german');
INSERT INTO class_model VALUES ('38', '3', 'Crosswagon', 'ro');
INSERT INTO class_model VALUES ('38', '3', 'Crosswagon', 'eng');
INSERT INTO class_model VALUES ('38', '3', 'Crosswagon', 'german');
INSERT INTO class_model VALUES ('39', '3', 'GT', 'ro');
INSERT INTO class_model VALUES ('39', '3', 'GT', 'eng');
INSERT INTO class_model VALUES ('39', '3', 'GT', 'german');
INSERT INTO class_model VALUES ('40', '3', 'GTV', 'ro');
INSERT INTO class_model VALUES ('40', '3', 'GTV', 'eng');
INSERT INTO class_model VALUES ('40', '3', 'GTV', 'german');
INSERT INTO class_model VALUES ('41', '3', 'Giulia', 'ro');
INSERT INTO class_model VALUES ('41', '3', 'Giulia', 'eng');
INSERT INTO class_model VALUES ('41', '3', 'Giulia', 'german');
INSERT INTO class_model VALUES ('42', '3', 'Giulietta', 'ro');
INSERT INTO class_model VALUES ('42', '3', 'Giulietta', 'eng');
INSERT INTO class_model VALUES ('42', '3', 'Giulietta', 'german');
INSERT INTO class_model VALUES ('43', '3', 'Mito', 'ro');
INSERT INTO class_model VALUES ('43', '3', 'Mito', 'eng');
INSERT INTO class_model VALUES ('43', '3', 'Mito', 'german');
INSERT INTO class_model VALUES ('44', '3', 'RS', 'ro');
INSERT INTO class_model VALUES ('44', '3', 'RS', 'eng');
INSERT INTO class_model VALUES ('44', '3', 'RS', 'german');
INSERT INTO class_model VALUES ('45', '3', 'Spider', 'ro');
INSERT INTO class_model VALUES ('45', '3', 'Spider', 'eng');
INSERT INTO class_model VALUES ('45', '3', 'Spider', 'german');
INSERT INTO class_model VALUES ('46', '3', 'Sportwagon', 'ro');
INSERT INTO class_model VALUES ('46', '3', 'Sportwagon', 'eng');
INSERT INTO class_model VALUES ('46', '3', 'Sportwagon', 'german');
INSERT INTO class_model VALUES ('47', '3', 'Sprint', 'ro');
INSERT INTO class_model VALUES ('47', '3', 'Sprint', 'eng');
INSERT INTO class_model VALUES ('47', '3', 'Sprint', 'german');
INSERT INTO class_model VALUES ('48', '4', '10-4', 'ro');
INSERT INTO class_model VALUES ('48', '4', '10-4', 'eng');
INSERT INTO class_model VALUES ('48', '4', '10-4', 'german');
INSERT INTO class_model VALUES ('49', '4', '11-4', 'ro');
INSERT INTO class_model VALUES ('49', '4', '11-4', 'eng');
INSERT INTO class_model VALUES ('49', '4', '11-4', 'german');
INSERT INTO class_model VALUES ('50', '4', '242', 'ro');
INSERT INTO class_model VALUES ('50', '4', '242', 'eng');
INSERT INTO class_model VALUES ('50', '4', '242', 'german');
INSERT INTO class_model VALUES ('51', '4', '243', 'ro');
INSERT INTO class_model VALUES ('51', '4', '243', 'eng');
INSERT INTO class_model VALUES ('51', '4', '243', 'german');
INSERT INTO class_model VALUES ('52', '4', '246', 'ro');
INSERT INTO class_model VALUES ('52', '4', '246', 'eng');
INSERT INTO class_model VALUES ('52', '4', '246', 'german');
INSERT INTO class_model VALUES ('53', '4', 'Dragon', 'ro');
INSERT INTO class_model VALUES ('53', '4', 'Dragon', 'eng');
INSERT INTO class_model VALUES ('53', '4', 'Dragon', 'german');
INSERT INTO class_model VALUES ('54', '4', 'M 461', 'ro');
INSERT INTO class_model VALUES ('54', '4', 'M 461', 'eng');
INSERT INTO class_model VALUES ('54', '4', 'M 461', 'german');
INSERT INTO class_model VALUES ('55', '4', 'Muscel', 'ro');
INSERT INTO class_model VALUES ('55', '4', 'Muscel', 'eng');
INSERT INTO class_model VALUES ('55', '4', 'Muscel', 'german');
INSERT INTO class_model VALUES ('56', '4', 'Spartana', 'ro');
INSERT INTO class_model VALUES ('56', '4', 'Spartana', 'eng');
INSERT INTO class_model VALUES ('56', '4', 'Spartana', 'german');
INSERT INTO class_model VALUES ('57', '4', 'Seria 10', 'ro');
INSERT INTO class_model VALUES ('57', '4', 'Seria 10', 'eng');
INSERT INTO class_model VALUES ('57', '4', 'Seria 10', 'german');
INSERT INTO class_model VALUES ('58', '4', 'Seria 240', 'ro');
INSERT INTO class_model VALUES ('58', '4', 'Seria 240', 'eng');
INSERT INTO class_model VALUES ('58', '4', 'Seria 240', 'german');
INSERT INTO class_model VALUES ('59', '4', 'Seria 320', 'ro');
INSERT INTO class_model VALUES ('59', '4', 'Seria 320', 'eng');
INSERT INTO class_model VALUES ('59', '4', 'Seria 320', 'german');
INSERT INTO class_model VALUES ('60', '5', 'Rocsta', 'ro');
INSERT INTO class_model VALUES ('60', '5', 'Rocsta', 'eng');
INSERT INTO class_model VALUES ('60', '5', 'Rocsta', 'german');
INSERT INTO class_model VALUES ('61', '6', 'Bulldog', 'ro');
INSERT INTO class_model VALUES ('61', '6', 'Bulldog', 'eng');
INSERT INTO class_model VALUES ('61', '6', 'Bulldog', 'german');
INSERT INTO class_model VALUES ('62', '6', 'Cygnet', 'ro');
INSERT INTO class_model VALUES ('62', '6', 'Cygnet', 'eng');
INSERT INTO class_model VALUES ('62', '6', 'Cygnet', 'german');
INSERT INTO class_model VALUES ('63', '6', 'DB', 'ro');
INSERT INTO class_model VALUES ('63', '6', 'DB', 'eng');
INSERT INTO class_model VALUES ('63', '6', 'DB', 'german');
INSERT INTO class_model VALUES ('64', '6', 'DB Mk III', 'ro');
INSERT INTO class_model VALUES ('64', '6', 'DB Mk III', 'eng');
INSERT INTO class_model VALUES ('64', '6', 'DB Mk III', 'german');
INSERT INTO class_model VALUES ('65', '6', 'DB1', 'ro');
INSERT INTO class_model VALUES ('65', '6', 'DB1', 'eng');
INSERT INTO class_model VALUES ('65', '6', 'DB1', 'german');
INSERT INTO class_model VALUES ('66', '6', 'DB2', 'ro');
INSERT INTO class_model VALUES ('66', '6', 'DB2', 'eng');
INSERT INTO class_model VALUES ('66', '6', 'DB2', 'german');
INSERT INTO class_model VALUES ('67', '6', 'DB4', 'ro');
INSERT INTO class_model VALUES ('67', '6', 'DB4', 'eng');
INSERT INTO class_model VALUES ('67', '6', 'DB4', 'german');
INSERT INTO class_model VALUES ('68', '6', 'DB5', 'ro');
INSERT INTO class_model VALUES ('68', '6', 'DB5', 'eng');
INSERT INTO class_model VALUES ('68', '6', 'DB5', 'german');
INSERT INTO class_model VALUES ('69', '6', 'DB6', 'ro');
INSERT INTO class_model VALUES ('69', '6', 'DB6', 'eng');
INSERT INTO class_model VALUES ('69', '6', 'DB6', 'german');
INSERT INTO class_model VALUES ('70', '6', 'DB7', 'ro');
INSERT INTO class_model VALUES ('70', '6', 'DB7', 'eng');
INSERT INTO class_model VALUES ('70', '6', 'DB7', 'german');
INSERT INTO class_model VALUES ('71', '6', 'DB9', 'ro');
INSERT INTO class_model VALUES ('71', '6', 'DB9', 'eng');
INSERT INTO class_model VALUES ('71', '6', 'DB9', 'german');
INSERT INTO class_model VALUES ('72', '6', 'DB9 Volante', 'ro');
INSERT INTO class_model VALUES ('72', '6', 'DB9 Volante', 'eng');
INSERT INTO class_model VALUES ('72', '6', 'DB9 Volante', 'german');
INSERT INTO class_model VALUES ('73', '6', 'DBS', 'ro');
INSERT INTO class_model VALUES ('73', '6', 'DBS', 'eng');
INSERT INTO class_model VALUES ('73', '6', 'DBS', 'german');
INSERT INTO class_model VALUES ('74', '6', 'Lagonda', 'ro');
INSERT INTO class_model VALUES ('74', '6', 'Lagonda', 'eng');
INSERT INTO class_model VALUES ('74', '6', 'Lagonda', 'german');
INSERT INTO class_model VALUES ('75', '6', 'One-77', 'ro');
INSERT INTO class_model VALUES ('75', '6', 'One-77', 'eng');
INSERT INTO class_model VALUES ('75', '6', 'One-77', 'german');
INSERT INTO class_model VALUES ('76', '6', 'Rapide', 'ro');
INSERT INTO class_model VALUES ('76', '6', 'Rapide', 'eng');
INSERT INTO class_model VALUES ('76', '6', 'Rapide', 'german');
INSERT INTO class_model VALUES ('77', '6', 'V12 Vanquish', 'ro');
INSERT INTO class_model VALUES ('77', '6', 'V12 Vanquish', 'eng');
INSERT INTO class_model VALUES ('77', '6', 'V12 Vanquish', 'german');
INSERT INTO class_model VALUES ('78', '6', 'V12 Vantage', 'ro');
INSERT INTO class_model VALUES ('78', '6', 'V12 Vantage', 'eng');
INSERT INTO class_model VALUES ('78', '6', 'V12 Vantage', 'german');
INSERT INTO class_model VALUES ('79', '6', 'V8', 'ro');
INSERT INTO class_model VALUES ('79', '6', 'V8', 'eng');
INSERT INTO class_model VALUES ('79', '6', 'V8', 'german');
INSERT INTO class_model VALUES ('80', '6', 'V8 Vantage', 'ro');
INSERT INTO class_model VALUES ('80', '6', 'V8 Vantage', 'eng');
INSERT INTO class_model VALUES ('80', '6', 'V8 Vantage', 'german');
INSERT INTO class_model VALUES ('81', '6', 'V8 Vantage Roadster', 'ro');
INSERT INTO class_model VALUES ('81', '6', 'V8 Vantage Roadster', 'eng');
INSERT INTO class_model VALUES ('81', '6', 'V8 Vantage Roadster', 'german');
INSERT INTO class_model VALUES ('82', '6', 'V8 Zagato', 'ro');
INSERT INTO class_model VALUES ('82', '6', 'V8 Zagato', 'eng');
INSERT INTO class_model VALUES ('82', '6', 'V8 Zagato', 'german');
INSERT INTO class_model VALUES ('83', '6', 'Vanquish', 'ro');
INSERT INTO class_model VALUES ('83', '6', 'Vanquish', 'eng');
INSERT INTO class_model VALUES ('83', '6', 'Vanquish', 'german');
INSERT INTO class_model VALUES ('84', '6', 'VantageVirage', 'ro');
INSERT INTO class_model VALUES ('84', '6', 'VantageVirage', 'eng');
INSERT INTO class_model VALUES ('84', '6', 'VantageVirage', 'german');
INSERT INTO class_model VALUES ('85', '6', 'Volante', 'ro');
INSERT INTO class_model VALUES ('85', '6', 'Volante', 'eng');
INSERT INTO class_model VALUES ('85', '6', 'Volante', 'german');
INSERT INTO class_model VALUES ('86', '7', '100', 'ro');
INSERT INTO class_model VALUES ('86', '7', '100', 'eng');
INSERT INTO class_model VALUES ('86', '7', '100', 'german');
INSERT INTO class_model VALUES ('87', '7', '200', 'ro');
INSERT INTO class_model VALUES ('87', '7', '200', 'eng');
INSERT INTO class_model VALUES ('87', '7', '200', 'german');
INSERT INTO class_model VALUES ('88', '7', '80', 'ro');
INSERT INTO class_model VALUES ('88', '7', '80', 'eng');
INSERT INTO class_model VALUES ('88', '7', '80', 'german');
INSERT INTO class_model VALUES ('89', '7', '90', 'ro');
INSERT INTO class_model VALUES ('89', '7', '90', 'eng');
INSERT INTO class_model VALUES ('89', '7', '90', 'german');
INSERT INTO class_model VALUES ('90', '7', 'A1', 'ro');
INSERT INTO class_model VALUES ('90', '7', 'A1', 'eng');
INSERT INTO class_model VALUES ('90', '7', 'A1', 'german');
INSERT INTO class_model VALUES ('91', '7', 'A2', 'ro');
INSERT INTO class_model VALUES ('91', '7', 'A2', 'eng');
INSERT INTO class_model VALUES ('91', '7', 'A2', 'german');
INSERT INTO class_model VALUES ('92', '7', 'A3', 'ro');
INSERT INTO class_model VALUES ('92', '7', 'A3', 'eng');
INSERT INTO class_model VALUES ('92', '7', 'A3', 'german');
INSERT INTO class_model VALUES ('93', '7', 'A4', 'ro');
INSERT INTO class_model VALUES ('93', '7', 'A4', 'eng');
INSERT INTO class_model VALUES ('93', '7', 'A4', 'german');
INSERT INTO class_model VALUES ('94', '7', 'A4 Allroad', 'ro');
INSERT INTO class_model VALUES ('94', '7', 'A4 Allroad', 'eng');
INSERT INTO class_model VALUES ('94', '7', 'A4 Allroad', 'german');
INSERT INTO class_model VALUES ('95', '7', 'A5', 'ro');
INSERT INTO class_model VALUES ('95', '7', 'A5', 'eng');
INSERT INTO class_model VALUES ('95', '7', 'A5', 'german');
INSERT INTO class_model VALUES ('96', '7', 'A6', 'ro');
INSERT INTO class_model VALUES ('96', '7', 'A6', 'eng');
INSERT INTO class_model VALUES ('96', '7', 'A6', 'german');
INSERT INTO class_model VALUES ('97', '7', 'A6 AllroadA7', 'ro');
INSERT INTO class_model VALUES ('97', '7', 'A6 AllroadA7', 'eng');
INSERT INTO class_model VALUES ('97', '7', 'A6 AllroadA7', 'german');
INSERT INTO class_model VALUES ('98', '7', 'A8', 'ro');
INSERT INTO class_model VALUES ('98', '7', 'A8', 'eng');
INSERT INTO class_model VALUES ('98', '7', 'A8', 'german');
INSERT INTO class_model VALUES ('99', '7', 'Cabriolet', 'ro');
INSERT INTO class_model VALUES ('99', '7', 'Cabriolet', 'eng');
INSERT INTO class_model VALUES ('99', '7', 'Cabriolet', 'german');
INSERT INTO class_model VALUES ('100', '7', 'Coupe', 'ro');
INSERT INTO class_model VALUES ('100', '7', 'Coupe', 'eng');
INSERT INTO class_model VALUES ('100', '7', 'Coupe', 'german');
INSERT INTO class_model VALUES ('101', '7', 'Q3', 'ro');
INSERT INTO class_model VALUES ('101', '7', 'Q3', 'eng');
INSERT INTO class_model VALUES ('101', '7', 'Q3', 'german');
INSERT INTO class_model VALUES ('102', '7', 'Q5', 'ro');
INSERT INTO class_model VALUES ('102', '7', 'Q5', 'eng');
INSERT INTO class_model VALUES ('102', '7', 'Q5', 'german');
INSERT INTO class_model VALUES ('103', '7', 'Q7', 'ro');
INSERT INTO class_model VALUES ('103', '7', 'Q7', 'eng');
INSERT INTO class_model VALUES ('103', '7', 'Q7', 'german');
INSERT INTO class_model VALUES ('104', '7', 'Quattro', 'ro');
INSERT INTO class_model VALUES ('104', '7', 'Quattro', 'eng');
INSERT INTO class_model VALUES ('104', '7', 'Quattro', 'german');
INSERT INTO class_model VALUES ('105', '7', 'R8', 'ro');
INSERT INTO class_model VALUES ('105', '7', 'R8', 'eng');
INSERT INTO class_model VALUES ('105', '7', 'R8', 'german');
INSERT INTO class_model VALUES ('106', '7', 'RS2', 'ro');
INSERT INTO class_model VALUES ('106', '7', 'RS2', 'eng');
INSERT INTO class_model VALUES ('106', '7', 'RS2', 'german');
INSERT INTO class_model VALUES ('107', '7', 'RS3', 'ro');
INSERT INTO class_model VALUES ('107', '7', 'RS3', 'eng');
INSERT INTO class_model VALUES ('107', '7', 'RS3', 'german');
INSERT INTO class_model VALUES ('108', '7', 'RS4', 'ro');
INSERT INTO class_model VALUES ('108', '7', 'RS4', 'eng');
INSERT INTO class_model VALUES ('108', '7', 'RS4', 'german');
INSERT INTO class_model VALUES ('109', '7', 'RS5', 'ro');
INSERT INTO class_model VALUES ('109', '7', 'RS5', 'eng');
INSERT INTO class_model VALUES ('109', '7', 'RS5', 'german');
INSERT INTO class_model VALUES ('110', '7', 'RS6', 'ro');
INSERT INTO class_model VALUES ('110', '7', 'RS6', 'eng');
INSERT INTO class_model VALUES ('110', '7', 'RS6', 'german');
INSERT INTO class_model VALUES ('111', '7', 'RS7', 'ro');
INSERT INTO class_model VALUES ('111', '7', 'RS7', 'eng');
INSERT INTO class_model VALUES ('111', '7', 'RS7', 'german');
INSERT INTO class_model VALUES ('112', '7', 'S2', 'ro');
INSERT INTO class_model VALUES ('112', '7', 'S2', 'eng');
INSERT INTO class_model VALUES ('112', '7', 'S2', 'german');
INSERT INTO class_model VALUES ('113', '7', 'S3', 'ro');
INSERT INTO class_model VALUES ('113', '7', 'S3', 'eng');
INSERT INTO class_model VALUES ('113', '7', 'S3', 'german');
INSERT INTO class_model VALUES ('114', '7', 'S4', 'ro');
INSERT INTO class_model VALUES ('114', '7', 'S4', 'eng');
INSERT INTO class_model VALUES ('114', '7', 'S4', 'german');
INSERT INTO class_model VALUES ('115', '7', 'S5', 'ro');
INSERT INTO class_model VALUES ('115', '7', 'S5', 'eng');
INSERT INTO class_model VALUES ('115', '7', 'S5', 'german');
INSERT INTO class_model VALUES ('116', '7', 'S6', 'ro');
INSERT INTO class_model VALUES ('116', '7', 'S6', 'eng');
INSERT INTO class_model VALUES ('116', '7', 'S6', 'german');
INSERT INTO class_model VALUES ('117', '7', 'S7', 'ro');
INSERT INTO class_model VALUES ('117', '7', 'S7', 'eng');
INSERT INTO class_model VALUES ('117', '7', 'S7', 'german');
INSERT INTO class_model VALUES ('118', '7', 'S8', 'ro');
INSERT INTO class_model VALUES ('118', '7', 'S8', 'eng');
INSERT INTO class_model VALUES ('118', '7', 'S8', 'german');
INSERT INTO class_model VALUES ('119', '7', 'SQ5', 'ro');
INSERT INTO class_model VALUES ('119', '7', 'SQ5', 'eng');
INSERT INTO class_model VALUES ('119', '7', 'SQ5', 'german');
INSERT INTO class_model VALUES ('120', '7', 'TT', 'ro');
INSERT INTO class_model VALUES ('120', '7', 'TT', 'eng');
INSERT INTO class_model VALUES ('120', '7', 'TT', 'german');
INSERT INTO class_model VALUES ('121', '7', 'TT RS2', 'ro');
INSERT INTO class_model VALUES ('121', '7', 'TT RS2', 'eng');
INSERT INTO class_model VALUES ('121', '7', 'TT RS2', 'german');
INSERT INTO class_model VALUES ('122', '7', 'TT S2', 'ro');
INSERT INTO class_model VALUES ('122', '7', 'TT S2', 'eng');
INSERT INTO class_model VALUES ('122', '7', 'TT S2', 'german');
INSERT INTO class_model VALUES ('123', '7', 'V8', 'ro');
INSERT INTO class_model VALUES ('123', '7', 'V8', 'eng');
INSERT INTO class_model VALUES ('123', '7', 'V8', 'german');
INSERT INTO class_model VALUES ('124', '7', 'Q2', 'ro');
INSERT INTO class_model VALUES ('124', '7', 'Q2', 'eng');
INSERT INTO class_model VALUES ('124', '7', 'Q2', 'german');
INSERT INTO class_model VALUES ('125', '8', 'Allegro', 'ro');
INSERT INTO class_model VALUES ('125', '8', 'Allegro', 'eng');
INSERT INTO class_model VALUES ('125', '8', 'Allegro', 'german');
INSERT INTO class_model VALUES ('1724', '131', '2410', 'german');
INSERT INTO class_model VALUES ('1724', '131', '2410', 'eng');
INSERT INTO class_model VALUES ('1724', '131', '2410', 'ro');
INSERT INTO class_model VALUES ('127', '8', 'Healey', 'ro');
INSERT INTO class_model VALUES ('127', '8', 'Healey', 'eng');
INSERT INTO class_model VALUES ('127', '8', 'Healey', 'german');
INSERT INTO class_model VALUES ('128', '8', 'Maxi', 'ro');
INSERT INTO class_model VALUES ('128', '8', 'Maxi', 'eng');
INSERT INTO class_model VALUES ('128', '8', 'Maxi', 'german');
INSERT INTO class_model VALUES ('129', '8', 'Metro', 'ro');
INSERT INTO class_model VALUES ('129', '8', 'Metro', 'eng');
INSERT INTO class_model VALUES ('129', '8', 'Metro', 'german');
INSERT INTO class_model VALUES ('130', '8', 'Mini', 'ro');
INSERT INTO class_model VALUES ('130', '8', 'Mini', 'eng');
INSERT INTO class_model VALUES ('130', '8', 'Mini', 'german');
INSERT INTO class_model VALUES ('131', '8', 'Montego', 'ro');
INSERT INTO class_model VALUES ('131', '8', 'Montego', 'eng');
INSERT INTO class_model VALUES ('131', '8', 'Montego', 'german');
INSERT INTO class_model VALUES ('132', '9', 'Bianchina', 'ro');
INSERT INTO class_model VALUES ('132', '9', 'Bianchina', 'eng');
INSERT INTO class_model VALUES ('132', '9', 'Bianchina', 'german');
INSERT INTO class_model VALUES ('133', '10', 'Arnage', 'ro');
INSERT INTO class_model VALUES ('133', '10', 'Arnage', 'eng');
INSERT INTO class_model VALUES ('133', '10', 'Arnage', 'german');
INSERT INTO class_model VALUES ('134', '10', 'Azure', 'ro');
INSERT INTO class_model VALUES ('134', '10', 'Azure', 'eng');
INSERT INTO class_model VALUES ('134', '10', 'Azure', 'german');
INSERT INTO class_model VALUES ('135', '10', 'Brooklands', 'ro');
INSERT INTO class_model VALUES ('135', '10', 'Brooklands', 'eng');
INSERT INTO class_model VALUES ('135', '10', 'Brooklands', 'german');
INSERT INTO class_model VALUES ('136', '10', 'Continental', 'ro');
INSERT INTO class_model VALUES ('136', '10', 'Continental', 'eng');
INSERT INTO class_model VALUES ('136', '10', 'Continental', 'german');
INSERT INTO class_model VALUES ('137', '10', 'Eight', 'ro');
INSERT INTO class_model VALUES ('137', '10', 'Eight', 'eng');
INSERT INTO class_model VALUES ('137', '10', 'Eight', 'german');
INSERT INTO class_model VALUES ('138', '10', 'Mulsanne', 'ro');
INSERT INTO class_model VALUES ('138', '10', 'Mulsanne', 'eng');
INSERT INTO class_model VALUES ('138', '10', 'Mulsanne', 'german');
INSERT INTO class_model VALUES ('139', '10', 'Turbo R', 'ro');
INSERT INTO class_model VALUES ('139', '10', 'Turbo R', 'eng');
INSERT INTO class_model VALUES ('139', '10', 'Turbo R', 'german');
INSERT INTO class_model VALUES ('140', '10', 'Turbo RT', 'ro');
INSERT INTO class_model VALUES ('140', '10', 'Turbo RT', 'eng');
INSERT INTO class_model VALUES ('140', '10', 'Turbo RT', 'german');
INSERT INTO class_model VALUES ('141', '10', 'Turbo S', 'ro');
INSERT INTO class_model VALUES ('141', '10', 'Turbo S', 'eng');
INSERT INTO class_model VALUES ('141', '10', 'Turbo S', 'german');
INSERT INTO class_model VALUES ('142', '10', 'Mulliner', 'ro');
INSERT INTO class_model VALUES ('142', '10', 'Mulliner', 'eng');
INSERT INTO class_model VALUES ('142', '10', 'Mulliner', 'german');
INSERT INTO class_model VALUES ('143', '10', 'Bentayga', 'ro');
INSERT INTO class_model VALUES ('143', '10', 'Bentayga', 'eng');
INSERT INTO class_model VALUES ('143', '10', 'Bentayga', 'german');
INSERT INTO class_model VALUES ('144', '11', '840', 'ro');
INSERT INTO class_model VALUES ('144', '11', '840', 'eng');
INSERT INTO class_model VALUES ('144', '11', '840', 'german');
INSERT INTO class_model VALUES ('145', '11', '850', 'ro');
INSERT INTO class_model VALUES ('145', '11', '850', 'eng');
INSERT INTO class_model VALUES ('145', '11', '850', 'german');
INSERT INTO class_model VALUES ('146', '11', 'ALPINA', 'ro');
INSERT INTO class_model VALUES ('146', '11', 'ALPINA', 'eng');
INSERT INTO class_model VALUES ('146', '11', 'ALPINA', 'german');
INSERT INTO class_model VALUES ('147', '11', 'M', 'ro');
INSERT INTO class_model VALUES ('147', '11', 'M', 'eng');
INSERT INTO class_model VALUES ('147', '11', 'M', 'german');
INSERT INTO class_model VALUES ('148', '11', 'Seria 1', 'ro');
INSERT INTO class_model VALUES ('148', '11', 'Seria 1', 'eng');
INSERT INTO class_model VALUES ('148', '11', 'Seria 1', 'german');
INSERT INTO class_model VALUES ('149', '11', 'Seria 2', 'ro');
INSERT INTO class_model VALUES ('149', '11', 'Seria 2', 'eng');
INSERT INTO class_model VALUES ('149', '11', 'Seria 2', 'german');
INSERT INTO class_model VALUES ('150', '11', 'Seria 3', 'ro');
INSERT INTO class_model VALUES ('150', '11', 'Seria 3', 'eng');
INSERT INTO class_model VALUES ('150', '11', 'Seria 3', 'german');
INSERT INTO class_model VALUES ('151', '11', 'Seria 4', 'ro');
INSERT INTO class_model VALUES ('151', '11', 'Seria 4', 'eng');
INSERT INTO class_model VALUES ('151', '11', 'Seria 4', 'german');
INSERT INTO class_model VALUES ('152', '11', 'Seria 5', 'ro');
INSERT INTO class_model VALUES ('152', '11', 'Seria 5', 'eng');
INSERT INTO class_model VALUES ('152', '11', 'Seria 5', 'german');
INSERT INTO class_model VALUES ('153', '11', 'Seria 6', 'ro');
INSERT INTO class_model VALUES ('153', '11', 'Seria 6', 'eng');
INSERT INTO class_model VALUES ('153', '11', 'Seria 6', 'german');
INSERT INTO class_model VALUES ('154', '11', 'Seria 7', 'ro');
INSERT INTO class_model VALUES ('154', '11', 'Seria 7', 'eng');
INSERT INTO class_model VALUES ('154', '11', 'Seria 7', 'german');
INSERT INTO class_model VALUES ('155', '11', 'X', 'ro');
INSERT INTO class_model VALUES ('155', '11', 'X', 'eng');
INSERT INTO class_model VALUES ('155', '11', 'X', 'german');
INSERT INTO class_model VALUES ('156', '11', 'Z', 'ro');
INSERT INTO class_model VALUES ('156', '11', 'Z', 'eng');
INSERT INTO class_model VALUES ('156', '11', 'Z', 'german');
INSERT INTO class_model VALUES ('157', '11', 'i3', 'ro');
INSERT INTO class_model VALUES ('157', '11', 'i3', 'eng');
INSERT INTO class_model VALUES ('157', '11', 'i3', 'german');
INSERT INTO class_model VALUES ('158', '11', 'i8', 'ro');
INSERT INTO class_model VALUES ('158', '11', 'i8', 'eng');
INSERT INTO class_model VALUES ('158', '11', 'i8', 'german');
INSERT INTO class_model VALUES ('159', '12', 'BC3', 'ro');
INSERT INTO class_model VALUES ('159', '12', 'BC3', 'eng');
INSERT INTO class_model VALUES ('159', '12', 'BC3', 'german');
INSERT INTO class_model VALUES ('160', '12', 'BS2', 'ro');
INSERT INTO class_model VALUES ('160', '12', 'BS2', 'eng');
INSERT INTO class_model VALUES ('160', '12', 'BS2', 'german');
INSERT INTO class_model VALUES ('161', '12', 'BS4', 'ro');
INSERT INTO class_model VALUES ('161', '12', 'BS4', 'eng');
INSERT INTO class_model VALUES ('161', '12', 'BS4', 'german');
INSERT INTO class_model VALUES ('162', '12', 'BS6', 'ro');
INSERT INTO class_model VALUES ('162', '12', 'BS6', 'eng');
INSERT INTO class_model VALUES ('162', '12', 'BS6', 'german');
INSERT INTO class_model VALUES ('163', '13', 'EB 110', 'ro');
INSERT INTO class_model VALUES ('163', '13', 'EB 110', 'eng');
INSERT INTO class_model VALUES ('163', '13', 'EB 110', 'german');
INSERT INTO class_model VALUES ('164', '13', 'Veyron', 'ro');
INSERT INTO class_model VALUES ('164', '13', 'Veyron', 'eng');
INSERT INTO class_model VALUES ('164', '13', 'Veyron', 'german');
INSERT INTO class_model VALUES ('165', '14', 'Centurion', 'ro');
INSERT INTO class_model VALUES ('165', '14', 'Centurion', 'eng');
INSERT INTO class_model VALUES ('165', '14', 'Centurion', 'german');
INSERT INTO class_model VALUES ('166', '14', 'Century', 'ro');
INSERT INTO class_model VALUES ('166', '14', 'Century', 'eng');
INSERT INTO class_model VALUES ('166', '14', 'Century', 'german');
INSERT INTO class_model VALUES ('167', '14', 'Electra', 'ro');
INSERT INTO class_model VALUES ('167', '14', 'Electra', 'eng');
INSERT INTO class_model VALUES ('167', '14', 'Electra', 'german');
INSERT INTO class_model VALUES ('168', '14', 'Enclave', 'ro');
INSERT INTO class_model VALUES ('168', '14', 'Enclave', 'eng');
INSERT INTO class_model VALUES ('168', '14', 'Enclave', 'german');
INSERT INTO class_model VALUES ('169', '14', 'Lacrosse', 'ro');
INSERT INTO class_model VALUES ('169', '14', 'Lacrosse', 'eng');
INSERT INTO class_model VALUES ('169', '14', 'Lacrosse', 'german');
INSERT INTO class_model VALUES ('170', '14', 'Le Sabre', 'ro');
INSERT INTO class_model VALUES ('170', '14', 'Le Sabre', 'eng');
INSERT INTO class_model VALUES ('170', '14', 'Le Sabre', 'german');
INSERT INTO class_model VALUES ('171', '14', 'Lucerne', 'ro');
INSERT INTO class_model VALUES ('171', '14', 'Lucerne', 'eng');
INSERT INTO class_model VALUES ('171', '14', 'Lucerne', 'german');
INSERT INTO class_model VALUES ('172', '14', 'Park Avenue', 'ro');
INSERT INTO class_model VALUES ('172', '14', 'Park Avenue', 'eng');
INSERT INTO class_model VALUES ('172', '14', 'Park Avenue', 'german');
INSERT INTO class_model VALUES ('173', '14', 'Reatta', 'ro');
INSERT INTO class_model VALUES ('173', '14', 'Reatta', 'eng');
INSERT INTO class_model VALUES ('173', '14', 'Reatta', 'german');
INSERT INTO class_model VALUES ('174', '14', 'Regal', 'ro');
INSERT INTO class_model VALUES ('174', '14', 'Regal', 'eng');
INSERT INTO class_model VALUES ('174', '14', 'Regal', 'german');
INSERT INTO class_model VALUES ('175', '14', 'Rendezvous', 'ro');
INSERT INTO class_model VALUES ('175', '14', 'Rendezvous', 'eng');
INSERT INTO class_model VALUES ('175', '14', 'Rendezvous', 'german');
INSERT INTO class_model VALUES ('176', '14', 'Riviera', 'ro');
INSERT INTO class_model VALUES ('176', '14', 'Riviera', 'eng');
INSERT INTO class_model VALUES ('176', '14', 'Riviera', 'german');
INSERT INTO class_model VALUES ('177', '14', 'Roadmaster', 'ro');
INSERT INTO class_model VALUES ('177', '14', 'Roadmaster', 'eng');
INSERT INTO class_model VALUES ('177', '14', 'Roadmaster', 'german');
INSERT INTO class_model VALUES ('178', '14', 'Skyhawk', 'ro');
INSERT INTO class_model VALUES ('178', '14', 'Skyhawk', 'eng');
INSERT INTO class_model VALUES ('178', '14', 'Skyhawk', 'german');
INSERT INTO class_model VALUES ('179', '14', 'Skylark', 'ro');
INSERT INTO class_model VALUES ('179', '14', 'Skylark', 'eng');
INSERT INTO class_model VALUES ('179', '14', 'Skylark', 'german');
INSERT INTO class_model VALUES ('180', '15', 'Allante', 'ro');
INSERT INTO class_model VALUES ('180', '15', 'Allante', 'eng');
INSERT INTO class_model VALUES ('180', '15', 'Allante', 'german');
INSERT INTO class_model VALUES ('181', '15', 'BLS', 'ro');
INSERT INTO class_model VALUES ('181', '15', 'BLS', 'eng');
INSERT INTO class_model VALUES ('181', '15', 'BLS', 'german');
INSERT INTO class_model VALUES ('182', '15', 'Brougham', 'ro');
INSERT INTO class_model VALUES ('182', '15', 'Brougham', 'eng');
INSERT INTO class_model VALUES ('182', '15', 'Brougham', 'german');
INSERT INTO class_model VALUES ('183', '15', 'CTS', 'ro');
INSERT INTO class_model VALUES ('183', '15', 'CTS', 'eng');
INSERT INTO class_model VALUES ('183', '15', 'CTS', 'german');
INSERT INTO class_model VALUES ('184', '15', 'Cimarron', 'ro');
INSERT INTO class_model VALUES ('184', '15', 'Cimarron', 'eng');
INSERT INTO class_model VALUES ('184', '15', 'Cimarron', 'german');
INSERT INTO class_model VALUES ('185', '15', 'DTS', 'ro');
INSERT INTO class_model VALUES ('185', '15', 'DTS', 'eng');
INSERT INTO class_model VALUES ('185', '15', 'DTS', 'german');
INSERT INTO class_model VALUES ('186', '15', 'Deville', 'ro');
INSERT INTO class_model VALUES ('186', '15', 'Deville', 'eng');
INSERT INTO class_model VALUES ('186', '15', 'Deville', 'german');
INSERT INTO class_model VALUES ('187', '15', 'Eldorado', 'ro');
INSERT INTO class_model VALUES ('187', '15', 'Eldorado', 'eng');
INSERT INTO class_model VALUES ('187', '15', 'Eldorado', 'german');
INSERT INTO class_model VALUES ('188', '15', 'Escalade', 'ro');
INSERT INTO class_model VALUES ('188', '15', 'Escalade', 'eng');
INSERT INTO class_model VALUES ('188', '15', 'Escalade', 'german');
INSERT INTO class_model VALUES ('189', '15', 'Fleetwood', 'ro');
INSERT INTO class_model VALUES ('189', '15', 'Fleetwood', 'eng');
INSERT INTO class_model VALUES ('189', '15', 'Fleetwood', 'german');
INSERT INTO class_model VALUES ('190', '15', 'SRX', 'ro');
INSERT INTO class_model VALUES ('190', '15', 'SRX', 'eng');
INSERT INTO class_model VALUES ('190', '15', 'SRX', 'german');
INSERT INTO class_model VALUES ('191', '15', 'STS', 'ro');
INSERT INTO class_model VALUES ('191', '15', 'STS', 'eng');
INSERT INTO class_model VALUES ('191', '15', 'STS', 'german');
INSERT INTO class_model VALUES ('192', '15', 'STS-V', 'ro');
INSERT INTO class_model VALUES ('192', '15', 'STS-V', 'eng');
INSERT INTO class_model VALUES ('192', '15', 'STS-V', 'german');
INSERT INTO class_model VALUES ('193', '15', 'Seville', 'ro');
INSERT INTO class_model VALUES ('193', '15', 'Seville', 'eng');
INSERT INTO class_model VALUES ('193', '15', 'Seville', 'german');
INSERT INTO class_model VALUES ('194', '15', 'XLR', 'ro');
INSERT INTO class_model VALUES ('194', '15', 'XLR', 'eng');
INSERT INTO class_model VALUES ('194', '15', 'XLR', 'german');
INSERT INTO class_model VALUES ('195', '15', 'XLR-V', 'ro');
INSERT INTO class_model VALUES ('195', '15', 'XLR-V', 'eng');
INSERT INTO class_model VALUES ('195', '15', 'XLR-V', 'german');
INSERT INTO class_model VALUES ('196', '16', 'Academy', 'ro');
INSERT INTO class_model VALUES ('196', '16', 'Academy', 'eng');
INSERT INTO class_model VALUES ('196', '16', 'Academy', 'german');
INSERT INTO class_model VALUES ('197', '16', 'CSR', 'ro');
INSERT INTO class_model VALUES ('197', '16', 'CSR', 'eng');
INSERT INTO class_model VALUES ('197', '16', 'CSR', 'german');
INSERT INTO class_model VALUES ('198', '16', 'Roadsport', 'ro');
INSERT INTO class_model VALUES ('198', '16', 'Roadsport', 'eng');
INSERT INTO class_model VALUES ('198', '16', 'Roadsport', 'german');
INSERT INTO class_model VALUES ('199', '16', 'Seven', 'ro');
INSERT INTO class_model VALUES ('199', '16', 'Seven', 'eng');
INSERT INTO class_model VALUES ('199', '16', 'Seven', 'german');
INSERT INTO class_model VALUES ('200', '16', 'Super Seven', 'ro');
INSERT INTO class_model VALUES ('200', '16', 'Super Seven', 'eng');
INSERT INTO class_model VALUES ('200', '16', 'Super Seven', 'german');
INSERT INTO class_model VALUES ('201', '17', 'Barooder', 'ro');
INSERT INTO class_model VALUES ('201', '17', 'Barooder', 'eng');
INSERT INTO class_model VALUES ('201', '17', 'Barooder', 'german');
INSERT INTO class_model VALUES ('202', '17', 'CH26', 'ro');
INSERT INTO class_model VALUES ('202', '17', 'CH26', 'eng');
INSERT INTO class_model VALUES ('202', '17', 'CH26', 'german');
INSERT INTO class_model VALUES ('203', '17', 'CH30', 'ro');
INSERT INTO class_model VALUES ('203', '17', 'CH30', 'eng');
INSERT INTO class_model VALUES ('203', '17', 'CH30', 'german');
INSERT INTO class_model VALUES ('204', '17', 'CH32', 'ro');
INSERT INTO class_model VALUES ('204', '17', 'CH32', 'eng');
INSERT INTO class_model VALUES ('204', '17', 'CH32', 'german');
INSERT INTO class_model VALUES ('205', '17', 'Speedino', 'ro');
INSERT INTO class_model VALUES ('205', '17', 'Speedino', 'eng');
INSERT INTO class_model VALUES ('205', '17', 'Speedino', 'german');
INSERT INTO class_model VALUES ('206', '18', 'A1', 'ro');
INSERT INTO class_model VALUES ('206', '18', 'A1', 'eng');
INSERT INTO class_model VALUES ('206', '18', 'A1', 'german');
INSERT INTO class_model VALUES ('207', '18', 'A3', 'ro');
INSERT INTO class_model VALUES ('207', '18', 'A3', 'eng');
INSERT INTO class_model VALUES ('207', '18', 'A3', 'german');
INSERT INTO class_model VALUES ('208', '18', 'A5', 'ro');
INSERT INTO class_model VALUES ('208', '18', 'A5', 'eng');
INSERT INTO class_model VALUES ('208', '18', 'A5', 'german');
INSERT INTO class_model VALUES ('209', '18', 'Arrizo 7', 'ro');
INSERT INTO class_model VALUES ('209', '18', 'Arrizo 7', 'eng');
INSERT INTO class_model VALUES ('209', '18', 'Arrizo 7', 'german');
INSERT INTO class_model VALUES ('210', '18', 'Cowin', 'ro');
INSERT INTO class_model VALUES ('210', '18', 'Cowin', 'eng');
INSERT INTO class_model VALUES ('210', '18', 'Cowin', 'german');
INSERT INTO class_model VALUES ('211', '18', 'E5', 'ro');
INSERT INTO class_model VALUES ('211', '18', 'E5', 'eng');
INSERT INTO class_model VALUES ('211', '18', 'E5', 'german');
INSERT INTO class_model VALUES ('212', '18', 'Eastar 5(V5)', 'ro');
INSERT INTO class_model VALUES ('212', '18', 'Eastar 5(V5)', 'eng');
INSERT INTO class_model VALUES ('212', '18', 'Eastar 5(V5)', 'german');
INSERT INTO class_model VALUES ('213', '18', 'G5', 'ro');
INSERT INTO class_model VALUES ('213', '18', 'G5', 'eng');
INSERT INTO class_model VALUES ('213', '18', 'G5', 'german');
INSERT INTO class_model VALUES ('214', '18', 'H5', 'ro');
INSERT INTO class_model VALUES ('214', '18', 'H5', 'eng');
INSERT INTO class_model VALUES ('214', '18', 'H5', 'german');
INSERT INTO class_model VALUES ('215', '18', 'M1', 'ro');
INSERT INTO class_model VALUES ('215', '18', 'M1', 'eng');
INSERT INTO class_model VALUES ('215', '18', 'M1', 'german');
INSERT INTO class_model VALUES ('216', '18', 'Q21', 'ro');
INSERT INTO class_model VALUES ('216', '18', 'Q21', 'eng');
INSERT INTO class_model VALUES ('216', '18', 'Q21', 'german');
INSERT INTO class_model VALUES ('217', '18', 'Q22', 'ro');
INSERT INTO class_model VALUES ('217', '18', 'Q22', 'eng');
INSERT INTO class_model VALUES ('217', '18', 'Q22', 'german');
INSERT INTO class_model VALUES ('218', '18', 'QQ', 'ro');
INSERT INTO class_model VALUES ('218', '18', 'QQ', 'eng');
INSERT INTO class_model VALUES ('218', '18', 'QQ', 'german');
INSERT INTO class_model VALUES ('219', '18', 'QQ3', 'ro');
INSERT INTO class_model VALUES ('219', '18', 'QQ3', 'eng');
INSERT INTO class_model VALUES ('219', '18', 'QQ3', 'german');
INSERT INTO class_model VALUES ('220', '18', 'QQ6', 'ro');
INSERT INTO class_model VALUES ('220', '18', 'QQ6', 'eng');
INSERT INTO class_model VALUES ('220', '18', 'QQ6', 'german');
INSERT INTO class_model VALUES ('221', '18', 'QQme', 'ro');
INSERT INTO class_model VALUES ('221', '18', 'QQme', 'eng');
INSERT INTO class_model VALUES ('221', '18', 'QQme', 'german');
INSERT INTO class_model VALUES ('222', '18', 'S22', 'ro');
INSERT INTO class_model VALUES ('222', '18', 'S22', 'eng');
INSERT INTO class_model VALUES ('222', '18', 'S22', 'german');
INSERT INTO class_model VALUES ('223', '18', 'Tiggo', 'ro');
INSERT INTO class_model VALUES ('223', '18', 'Tiggo', 'eng');
INSERT INTO class_model VALUES ('223', '18', 'Tiggo', 'german');
INSERT INTO class_model VALUES ('224', '18', 'X1', 'ro');
INSERT INTO class_model VALUES ('224', '18', 'X1', 'eng');
INSERT INTO class_model VALUES ('224', '18', 'X1', 'german');
INSERT INTO class_model VALUES ('225', '18', 'X5', 'ro');
INSERT INTO class_model VALUES ('225', '18', 'X5', 'eng');
INSERT INTO class_model VALUES ('225', '18', 'X5', 'german');
INSERT INTO class_model VALUES ('226', '19', '1500', 'ro');
INSERT INTO class_model VALUES ('226', '19', '1500', 'eng');
INSERT INTO class_model VALUES ('226', '19', '1500', 'german');
INSERT INTO class_model VALUES ('227', '19', '2500', 'ro');
INSERT INTO class_model VALUES ('227', '19', '2500', 'eng');
INSERT INTO class_model VALUES ('227', '19', '2500', 'german');
INSERT INTO class_model VALUES ('228', '19', '3500', 'ro');
INSERT INTO class_model VALUES ('228', '19', '3500', 'eng');
INSERT INTO class_model VALUES ('228', '19', '3500', 'german');
INSERT INTO class_model VALUES ('229', '19', 'Alero', 'ro');
INSERT INTO class_model VALUES ('229', '19', 'Alero', 'eng');
INSERT INTO class_model VALUES ('229', '19', 'Alero', 'german');
INSERT INTO class_model VALUES ('230', '19', 'Apache', 'ro');
INSERT INTO class_model VALUES ('230', '19', 'Apache', 'eng');
INSERT INTO class_model VALUES ('230', '19', 'Apache', 'german');
INSERT INTO class_model VALUES ('231', '19', 'Astro', 'ro');
INSERT INTO class_model VALUES ('231', '19', 'Astro', 'eng');
INSERT INTO class_model VALUES ('231', '19', 'Astro', 'german');
INSERT INTO class_model VALUES ('232', '19', 'Avalanche', 'ro');
INSERT INTO class_model VALUES ('232', '19', 'Avalanche', 'eng');
INSERT INTO class_model VALUES ('232', '19', 'Avalanche', 'german');
INSERT INTO class_model VALUES ('233', '19', 'Aveo', 'ro');
INSERT INTO class_model VALUES ('233', '19', 'Aveo', 'eng');
INSERT INTO class_model VALUES ('233', '19', 'Aveo', 'german');
INSERT INTO class_model VALUES ('234', '19', 'Bel Air', 'ro');
INSERT INTO class_model VALUES ('234', '19', 'Bel Air', 'eng');
INSERT INTO class_model VALUES ('234', '19', 'Bel Air', 'german');
INSERT INTO class_model VALUES ('235', '19', 'Beretta', 'ro');
INSERT INTO class_model VALUES ('235', '19', 'Beretta', 'eng');
INSERT INTO class_model VALUES ('235', '19', 'Beretta', 'german');
INSERT INTO class_model VALUES ('236', '19', 'Blazer', 'ro');
INSERT INTO class_model VALUES ('236', '19', 'Blazer', 'eng');
INSERT INTO class_model VALUES ('236', '19', 'Blazer', 'german');
INSERT INTO class_model VALUES ('237', '19', 'C-10', 'ro');
INSERT INTO class_model VALUES ('237', '19', 'C-10', 'eng');
INSERT INTO class_model VALUES ('237', '19', 'C-10', 'german');
INSERT INTO class_model VALUES ('238', '19', 'C-20', 'ro');
INSERT INTO class_model VALUES ('238', '19', 'C-20', 'eng');
INSERT INTO class_model VALUES ('238', '19', 'C-20', 'german');
INSERT INTO class_model VALUES ('239', '19', 'C-30', 'ro');
INSERT INTO class_model VALUES ('239', '19', 'C-30', 'eng');
INSERT INTO class_model VALUES ('239', '19', 'C-30', 'german');
INSERT INTO class_model VALUES ('240', '19', 'Camaro', 'ro');
INSERT INTO class_model VALUES ('240', '19', 'Camaro', 'eng');
INSERT INTO class_model VALUES ('240', '19', 'Camaro', 'german');
INSERT INTO class_model VALUES ('241', '19', 'Caprice', 'ro');
INSERT INTO class_model VALUES ('241', '19', 'Caprice', 'eng');
INSERT INTO class_model VALUES ('241', '19', 'Caprice', 'german');
INSERT INTO class_model VALUES ('242', '19', 'Captiva', 'ro');
INSERT INTO class_model VALUES ('242', '19', 'Captiva', 'eng');
INSERT INTO class_model VALUES ('242', '19', 'Captiva', 'german');
INSERT INTO class_model VALUES ('243', '19', 'Cavalier', 'ro');
INSERT INTO class_model VALUES ('243', '19', 'Cavalier', 'eng');
INSERT INTO class_model VALUES ('243', '19', 'Cavalier', 'german');
INSERT INTO class_model VALUES ('244', '19', 'Clebrity', 'ro');
INSERT INTO class_model VALUES ('244', '19', 'Clebrity', 'eng');
INSERT INTO class_model VALUES ('244', '19', 'Clebrity', 'german');
INSERT INTO class_model VALUES ('245', '19', 'Chevelle', 'ro');
INSERT INTO class_model VALUES ('245', '19', 'Chevelle', 'eng');
INSERT INTO class_model VALUES ('245', '19', 'Chevelle', 'german');
INSERT INTO class_model VALUES ('246', '19', 'Chevy Van', 'ro');
INSERT INTO class_model VALUES ('246', '19', 'Chevy Van', 'eng');
INSERT INTO class_model VALUES ('246', '19', 'Chevy Van', 'german');
INSERT INTO class_model VALUES ('247', '19', 'Citation', 'ro');
INSERT INTO class_model VALUES ('247', '19', 'Citation', 'eng');
INSERT INTO class_model VALUES ('247', '19', 'Citation', 'german');
INSERT INTO class_model VALUES ('248', '19', 'Cobalt', 'ro');
INSERT INTO class_model VALUES ('248', '19', 'Cobalt', 'eng');
INSERT INTO class_model VALUES ('248', '19', 'Cobalt', 'german');
INSERT INTO class_model VALUES ('249', '19', 'Colorado', 'ro');
INSERT INTO class_model VALUES ('249', '19', 'Colorado', 'eng');
INSERT INTO class_model VALUES ('249', '19', 'Colorado', 'german');
INSERT INTO class_model VALUES ('250', '19', 'Corsica', 'ro');
INSERT INTO class_model VALUES ('250', '19', 'Corsica', 'eng');
INSERT INTO class_model VALUES ('250', '19', 'Corsica', 'german');
INSERT INTO class_model VALUES ('251', '19', 'Corvette', 'ro');
INSERT INTO class_model VALUES ('251', '19', 'Corvette', 'eng');
INSERT INTO class_model VALUES ('251', '19', 'Corvette', 'german');
INSERT INTO class_model VALUES ('252', '19', 'Cruze', 'ro');
INSERT INTO class_model VALUES ('252', '19', 'Cruze', 'eng');
INSERT INTO class_model VALUES ('252', '19', 'Cruze', 'german');
INSERT INTO class_model VALUES ('253', '19', 'El Camino', 'ro');
INSERT INTO class_model VALUES ('253', '19', 'El Camino', 'eng');
INSERT INTO class_model VALUES ('253', '19', 'El Camino', 'german');
INSERT INTO class_model VALUES ('254', '19', 'Epica', 'ro');
INSERT INTO class_model VALUES ('254', '19', 'Epica', 'eng');
INSERT INTO class_model VALUES ('254', '19', 'Epica', 'german');
INSERT INTO class_model VALUES ('255', '19', 'Equinox', 'ro');
INSERT INTO class_model VALUES ('255', '19', 'Equinox', 'eng');
INSERT INTO class_model VALUES ('255', '19', 'Equinox', 'german');
INSERT INTO class_model VALUES ('256', '19', 'Evanda', 'ro');
INSERT INTO class_model VALUES ('256', '19', 'Evanda', 'eng');
INSERT INTO class_model VALUES ('256', '19', 'Evanda', 'german');
INSERT INTO class_model VALUES ('257', '19', 'Express', 'ro');
INSERT INTO class_model VALUES ('257', '19', 'Express', 'eng');
INSERT INTO class_model VALUES ('257', '19', 'Express', 'german');
INSERT INTO class_model VALUES ('258', '19', 'G', 'ro');
INSERT INTO class_model VALUES ('258', '19', 'G', 'eng');
INSERT INTO class_model VALUES ('258', '19', 'G', 'german');
INSERT INTO class_model VALUES ('259', '19', 'HHR', 'ro');
INSERT INTO class_model VALUES ('259', '19', 'HHR', 'eng');
INSERT INTO class_model VALUES ('259', '19', 'HHR', 'german');
INSERT INTO class_model VALUES ('260', '19', 'Impala', 'ro');
INSERT INTO class_model VALUES ('260', '19', 'Impala', 'eng');
INSERT INTO class_model VALUES ('260', '19', 'Impala', 'german');
INSERT INTO class_model VALUES ('261', '19', 'K1500', 'ro');
INSERT INTO class_model VALUES ('261', '19', 'K1500', 'eng');
INSERT INTO class_model VALUES ('261', '19', 'K1500', 'german');
INSERT INTO class_model VALUES ('262', '19', 'K30', 'ro');
INSERT INTO class_model VALUES ('262', '19', 'K30', 'eng');
INSERT INTO class_model VALUES ('262', '19', 'K30', 'german');
INSERT INTO class_model VALUES ('263', '19', 'Kalos', 'ro');
INSERT INTO class_model VALUES ('263', '19', 'Kalos', 'eng');
INSERT INTO class_model VALUES ('263', '19', 'Kalos', 'german');
INSERT INTO class_model VALUES ('264', '19', 'Lacetti', 'ro');
INSERT INTO class_model VALUES ('264', '19', 'Lacetti', 'eng');
INSERT INTO class_model VALUES ('264', '19', 'Lacetti', 'german');
INSERT INTO class_model VALUES ('265', '19', 'Lumina', 'ro');
INSERT INTO class_model VALUES ('265', '19', 'Lumina', 'eng');
INSERT INTO class_model VALUES ('265', '19', 'Lumina', 'german');
INSERT INTO class_model VALUES ('266', '19', 'Malibu', 'ro');
INSERT INTO class_model VALUES ('266', '19', 'Malibu', 'eng');
INSERT INTO class_model VALUES ('266', '19', 'Malibu', 'german');
INSERT INTO class_model VALUES ('267', '19', 'Matiz', 'ro');
INSERT INTO class_model VALUES ('267', '19', 'Matiz', 'eng');
INSERT INTO class_model VALUES ('267', '19', 'Matiz', 'german');
INSERT INTO class_model VALUES ('268', '19', 'Monte Carlo', 'ro');
INSERT INTO class_model VALUES ('268', '19', 'Monte Carlo', 'eng');
INSERT INTO class_model VALUES ('268', '19', 'Monte Carlo', 'german');
INSERT INTO class_model VALUES ('269', '19', 'Monza', 'ro');
INSERT INTO class_model VALUES ('269', '19', 'Monza', 'eng');
INSERT INTO class_model VALUES ('269', '19', 'Monza', 'german');
INSERT INTO class_model VALUES ('270', '19', 'Nova', 'ro');
INSERT INTO class_model VALUES ('270', '19', 'Nova', 'eng');
INSERT INTO class_model VALUES ('270', '19', 'Nova', 'german');
INSERT INTO class_model VALUES ('271', '19', 'Nubira', 'ro');
INSERT INTO class_model VALUES ('271', '19', 'Nubira', 'eng');
INSERT INTO class_model VALUES ('271', '19', 'Nubira', 'german');
INSERT INTO class_model VALUES ('272', '19', 'Orlando', 'ro');
INSERT INTO class_model VALUES ('272', '19', 'Orlando', 'eng');
INSERT INTO class_model VALUES ('272', '19', 'Orlando', 'german');
INSERT INTO class_model VALUES ('273', '19', 'Rezzo', 'ro');
INSERT INTO class_model VALUES ('273', '19', 'Rezzo', 'eng');
INSERT INTO class_model VALUES ('273', '19', 'Rezzo', 'german');
INSERT INTO class_model VALUES ('274', '19', 'S-10', 'ro');
INSERT INTO class_model VALUES ('274', '19', 'S-10', 'eng');
INSERT INTO class_model VALUES ('274', '19', 'S-10', 'german');
INSERT INTO class_model VALUES ('275', '19', 'SSR', 'ro');
INSERT INTO class_model VALUES ('275', '19', 'SSR', 'eng');
INSERT INTO class_model VALUES ('275', '19', 'SSR', 'german');
INSERT INTO class_model VALUES ('276', '19', 'Silverado', 'ro');
INSERT INTO class_model VALUES ('276', '19', 'Silverado', 'eng');
INSERT INTO class_model VALUES ('276', '19', 'Silverado', 'german');
INSERT INTO class_model VALUES ('277', '19', 'Spark', 'ro');
INSERT INTO class_model VALUES ('277', '19', 'Spark', 'eng');
INSERT INTO class_model VALUES ('277', '19', 'Spark', 'german');
INSERT INTO class_model VALUES ('278', '19', 'Spectrum', 'ro');
INSERT INTO class_model VALUES ('278', '19', 'Spectrum', 'eng');
INSERT INTO class_model VALUES ('278', '19', 'Spectrum', 'german');
INSERT INTO class_model VALUES ('279', '19', 'Suburban', 'ro');
INSERT INTO class_model VALUES ('279', '19', 'Suburban', 'eng');
INSERT INTO class_model VALUES ('279', '19', 'Suburban', 'german');
INSERT INTO class_model VALUES ('280', '19', 'Tacuma', 'ro');
INSERT INTO class_model VALUES ('280', '19', 'Tacuma', 'eng');
INSERT INTO class_model VALUES ('280', '19', 'Tacuma', 'german');
INSERT INTO class_model VALUES ('281', '19', 'Tahoe', 'ro');
INSERT INTO class_model VALUES ('281', '19', 'Tahoe', 'eng');
INSERT INTO class_model VALUES ('281', '19', 'Tahoe', 'german');
INSERT INTO class_model VALUES ('282', '19', 'Trailblazer', 'ro');
INSERT INTO class_model VALUES ('282', '19', 'Trailblazer', 'eng');
INSERT INTO class_model VALUES ('282', '19', 'Trailblazer', 'german');
INSERT INTO class_model VALUES ('283', '19', 'Trans Sport', 'ro');
INSERT INTO class_model VALUES ('283', '19', 'Trans Sport', 'eng');
INSERT INTO class_model VALUES ('283', '19', 'Trans Sport', 'german');
INSERT INTO class_model VALUES ('284', '19', 'Traverse', 'ro');
INSERT INTO class_model VALUES ('284', '19', 'Traverse', 'eng');
INSERT INTO class_model VALUES ('284', '19', 'Traverse', 'german');
INSERT INTO class_model VALUES ('285', '19', 'Trax', 'ro');
INSERT INTO class_model VALUES ('285', '19', 'Trax', 'eng');
INSERT INTO class_model VALUES ('285', '19', 'Trax', 'german');
INSERT INTO class_model VALUES ('286', '19', 'Venture', 'ro');
INSERT INTO class_model VALUES ('286', '19', 'Venture', 'eng');
INSERT INTO class_model VALUES ('286', '19', 'Venture', 'german');
INSERT INTO class_model VALUES ('287', '19', 'Volt', 'ro');
INSERT INTO class_model VALUES ('287', '19', 'Volt', 'eng');
INSERT INTO class_model VALUES ('287', '19', 'Volt', 'german');
INSERT INTO class_model VALUES ('288', '20', '300C', 'ro');
INSERT INTO class_model VALUES ('288', '20', '300C', 'eng');
INSERT INTO class_model VALUES ('288', '20', '300C', 'german');
INSERT INTO class_model VALUES ('289', '20', '300M', 'ro');
INSERT INTO class_model VALUES ('289', '20', '300M', 'eng');
INSERT INTO class_model VALUES ('289', '20', '300M', 'german');
INSERT INTO class_model VALUES ('290', '20', 'Aspen', 'ro');
INSERT INTO class_model VALUES ('290', '20', 'Aspen', 'eng');
INSERT INTO class_model VALUES ('290', '20', 'Aspen', 'german');
INSERT INTO class_model VALUES ('291', '20', 'Caravan', 'ro');
INSERT INTO class_model VALUES ('291', '20', 'Caravan', 'eng');
INSERT INTO class_model VALUES ('291', '20', 'Caravan', 'german');
INSERT INTO class_model VALUES ('292', '20', 'Concorde', 'ro');
INSERT INTO class_model VALUES ('292', '20', 'Concorde', 'eng');
INSERT INTO class_model VALUES ('292', '20', 'Concorde', 'german');
INSERT INTO class_model VALUES ('293', '20', 'Crossfire', 'ro');
INSERT INTO class_model VALUES ('293', '20', 'Crossfire', 'eng');
INSERT INTO class_model VALUES ('293', '20', 'Crossfire', 'german');
INSERT INTO class_model VALUES ('294', '20', 'Daytona', 'ro');
INSERT INTO class_model VALUES ('294', '20', 'Daytona', 'eng');
INSERT INTO class_model VALUES ('294', '20', 'Daytona', 'german');
INSERT INTO class_model VALUES ('295', '20', 'ES', 'ro');
INSERT INTO class_model VALUES ('295', '20', 'ES', 'eng');
INSERT INTO class_model VALUES ('295', '20', 'ES', 'german');
INSERT INTO class_model VALUES ('296', '20', 'GS', 'ro');
INSERT INTO class_model VALUES ('296', '20', 'GS', 'eng');
INSERT INTO class_model VALUES ('296', '20', 'GS', 'german');
INSERT INTO class_model VALUES ('297', '20', 'GTS', 'ro');
INSERT INTO class_model VALUES ('297', '20', 'GTS', 'eng');
INSERT INTO class_model VALUES ('297', '20', 'GTS', 'german');
INSERT INTO class_model VALUES ('298', '20', 'Grand Voyager', 'ro');
INSERT INTO class_model VALUES ('298', '20', 'Grand Voyager', 'eng');
INSERT INTO class_model VALUES ('298', '20', 'Grand Voyager', 'german');
INSERT INTO class_model VALUES ('299', '20', 'LHS', 'ro');
INSERT INTO class_model VALUES ('299', '20', 'LHS', 'eng');
INSERT INTO class_model VALUES ('299', '20', 'LHS', 'german');
INSERT INTO class_model VALUES ('300', '20', 'Le Baron', 'ro');
INSERT INTO class_model VALUES ('300', '20', 'Le Baron', 'eng');
INSERT INTO class_model VALUES ('300', '20', 'Le Baron', 'german');
INSERT INTO class_model VALUES ('301', '20', 'Neon', 'ro');
INSERT INTO class_model VALUES ('301', '20', 'Neon', 'eng');
INSERT INTO class_model VALUES ('301', '20', 'Neon', 'german');
INSERT INTO class_model VALUES ('302', '20', 'New Yorker', 'ro');
INSERT INTO class_model VALUES ('302', '20', 'New Yorker', 'eng');
INSERT INTO class_model VALUES ('302', '20', 'New Yorker', 'german');
INSERT INTO class_model VALUES ('303', '20', 'PT Cruiser', 'ro');
INSERT INTO class_model VALUES ('303', '20', 'PT Cruiser', 'eng');
INSERT INTO class_model VALUES ('303', '20', 'PT Cruiser', 'german');
INSERT INTO class_model VALUES ('304', '20', 'Pacifica', 'ro');
INSERT INTO class_model VALUES ('304', '20', 'Pacifica', 'eng');
INSERT INTO class_model VALUES ('304', '20', 'Pacifica', 'german');
INSERT INTO class_model VALUES ('305', '20', 'Prowler', 'ro');
INSERT INTO class_model VALUES ('305', '20', 'Prowler', 'eng');
INSERT INTO class_model VALUES ('305', '20', 'Prowler', 'german');
INSERT INTO class_model VALUES ('306', '20', 'Saratoga', 'ro');
INSERT INTO class_model VALUES ('306', '20', 'Saratoga', 'eng');
INSERT INTO class_model VALUES ('306', '20', 'Saratoga', 'german');
INSERT INTO class_model VALUES ('307', '20', 'Sebring', 'ro');
INSERT INTO class_model VALUES ('307', '20', 'Sebring', 'eng');
INSERT INTO class_model VALUES ('307', '20', 'Sebring', 'german');
INSERT INTO class_model VALUES ('308', '20', 'Stratus', 'ro');
INSERT INTO class_model VALUES ('308', '20', 'Stratus', 'eng');
INSERT INTO class_model VALUES ('308', '20', 'Stratus', 'german');
INSERT INTO class_model VALUES ('309', '20', 'Town & Country', 'ro');
INSERT INTO class_model VALUES ('309', '20', 'Town & Country', 'eng');
INSERT INTO class_model VALUES ('309', '20', 'Town & Country', 'german');
INSERT INTO class_model VALUES ('310', '20', 'Valiant', 'ro');
INSERT INTO class_model VALUES ('310', '20', 'Valiant', 'eng');
INSERT INTO class_model VALUES ('310', '20', 'Valiant', 'german');
INSERT INTO class_model VALUES ('311', '20', 'Viper', 'ro');
INSERT INTO class_model VALUES ('311', '20', 'Viper', 'eng');
INSERT INTO class_model VALUES ('311', '20', 'Viper', 'german');
INSERT INTO class_model VALUES ('312', '20', 'Vision', 'ro');
INSERT INTO class_model VALUES ('312', '20', 'Vision', 'eng');
INSERT INTO class_model VALUES ('312', '20', 'Vision', 'german');
INSERT INTO class_model VALUES ('313', '20', 'Voyager', 'ro');
INSERT INTO class_model VALUES ('313', '20', 'Voyager', 'eng');
INSERT INTO class_model VALUES ('313', '20', 'Voyager', 'german');
INSERT INTO class_model VALUES ('314', '21', '2 CV', 'ro');
INSERT INTO class_model VALUES ('314', '21', '2 CV', 'eng');
INSERT INTO class_model VALUES ('314', '21', '2 CV', 'german');
INSERT INTO class_model VALUES ('315', '21', 'AX', 'ro');
INSERT INTO class_model VALUES ('315', '21', 'AX', 'eng');
INSERT INTO class_model VALUES ('315', '21', 'AX', 'german');
INSERT INTO class_model VALUES ('316', '21', 'Axel', 'ro');
INSERT INTO class_model VALUES ('316', '21', 'Axel', 'eng');
INSERT INTO class_model VALUES ('316', '21', 'Axel', 'german');
INSERT INTO class_model VALUES ('317', '21', 'BX', 'ro');
INSERT INTO class_model VALUES ('317', '21', 'BX', 'eng');
INSERT INTO class_model VALUES ('317', '21', 'BX', 'german');
INSERT INTO class_model VALUES ('318', '21', 'Berlingo', 'ro');
INSERT INTO class_model VALUES ('318', '21', 'Berlingo', 'eng');
INSERT INTO class_model VALUES ('318', '21', 'Berlingo', 'german');
INSERT INTO class_model VALUES ('319', '21', 'C-Crosser', 'ro');
INSERT INTO class_model VALUES ('319', '21', 'C-Crosser', 'eng');
INSERT INTO class_model VALUES ('319', '21', 'C-Crosser', 'german');
INSERT INTO class_model VALUES ('320', '21', 'C-Elysee', 'ro');
INSERT INTO class_model VALUES ('320', '21', 'C-Elysee', 'eng');
INSERT INTO class_model VALUES ('320', '21', 'C-Elysee', 'german');
INSERT INTO class_model VALUES ('321', '21', 'C1', 'ro');
INSERT INTO class_model VALUES ('321', '21', 'C1', 'eng');
INSERT INTO class_model VALUES ('321', '21', 'C1', 'german');
INSERT INTO class_model VALUES ('322', '21', 'C2', 'ro');
INSERT INTO class_model VALUES ('322', '21', 'C2', 'eng');
INSERT INTO class_model VALUES ('322', '21', 'C2', 'german');
INSERT INTO class_model VALUES ('323', '21', 'C3', 'ro');
INSERT INTO class_model VALUES ('323', '21', 'C3', 'eng');
INSERT INTO class_model VALUES ('323', '21', 'C3', 'german');
INSERT INTO class_model VALUES ('324', '21', 'C3 Picasso', 'ro');
INSERT INTO class_model VALUES ('324', '21', 'C3 Picasso', 'eng');
INSERT INTO class_model VALUES ('324', '21', 'C3 Picasso', 'german');
INSERT INTO class_model VALUES ('325', '21', 'C3 Pluriel', 'ro');
INSERT INTO class_model VALUES ('325', '21', 'C3 Pluriel', 'eng');
INSERT INTO class_model VALUES ('325', '21', 'C3 Pluriel', 'german');
INSERT INTO class_model VALUES ('326', '21', 'C4', 'ro');
INSERT INTO class_model VALUES ('326', '21', 'C4', 'eng');
INSERT INTO class_model VALUES ('326', '21', 'C4', 'german');
INSERT INTO class_model VALUES ('327', '21', 'C4 Aircross', 'ro');
INSERT INTO class_model VALUES ('327', '21', 'C4 Aircross', 'eng');
INSERT INTO class_model VALUES ('327', '21', 'C4 Aircross', 'german');
INSERT INTO class_model VALUES ('328', '21', 'C4 Picasso', 'ro');
INSERT INTO class_model VALUES ('328', '21', 'C4 Picasso', 'eng');
INSERT INTO class_model VALUES ('328', '21', 'C4 Picasso', 'german');
INSERT INTO class_model VALUES ('329', '21', 'C5', 'ro');
INSERT INTO class_model VALUES ('329', '21', 'C5', 'eng');
INSERT INTO class_model VALUES ('329', '21', 'C5', 'german');
INSERT INTO class_model VALUES ('330', '21', 'C6', 'ro');
INSERT INTO class_model VALUES ('330', '21', 'C6', 'eng');
INSERT INTO class_model VALUES ('330', '21', 'C6', 'german');
INSERT INTO class_model VALUES ('331', '21', 'C8', 'ro');
INSERT INTO class_model VALUES ('331', '21', 'C8', 'eng');
INSERT INTO class_model VALUES ('331', '21', 'C8', 'german');
INSERT INTO class_model VALUES ('332', '21', 'CX', 'ro');
INSERT INTO class_model VALUES ('332', '21', 'CX', 'eng');
INSERT INTO class_model VALUES ('332', '21', 'CX', 'german');
INSERT INTO class_model VALUES ('333', '21', 'Cactus', 'ro');
INSERT INTO class_model VALUES ('333', '21', 'Cactus', 'eng');
INSERT INTO class_model VALUES ('333', '21', 'Cactus', 'german');
INSERT INTO class_model VALUES ('334', '21', 'DS', 'ro');
INSERT INTO class_model VALUES ('334', '21', 'DS', 'eng');
INSERT INTO class_model VALUES ('334', '21', 'DS', 'german');
INSERT INTO class_model VALUES ('335', '21', 'DS3', 'ro');
INSERT INTO class_model VALUES ('335', '21', 'DS3', 'eng');
INSERT INTO class_model VALUES ('335', '21', 'DS3', 'german');
INSERT INTO class_model VALUES ('336', '21', 'DS4', 'ro');
INSERT INTO class_model VALUES ('336', '21', 'DS4', 'eng');
INSERT INTO class_model VALUES ('336', '21', 'DS4', 'german');
INSERT INTO class_model VALUES ('337', '21', 'DS5', 'ro');
INSERT INTO class_model VALUES ('337', '21', 'DS5', 'eng');
INSERT INTO class_model VALUES ('337', '21', 'DS5', 'german');
INSERT INTO class_model VALUES ('338', '21', 'Evasion', 'ro');
INSERT INTO class_model VALUES ('338', '21', 'Evasion', 'eng');
INSERT INTO class_model VALUES ('338', '21', 'Evasion', 'german');
INSERT INTO class_model VALUES ('339', '21', 'GSA', 'ro');
INSERT INTO class_model VALUES ('339', '21', 'GSA', 'eng');
INSERT INTO class_model VALUES ('339', '21', 'GSA', 'german');
INSERT INTO class_model VALUES ('340', '21', 'Jumpy Combi', 'ro');
INSERT INTO class_model VALUES ('340', '21', 'Jumpy Combi', 'eng');
INSERT INTO class_model VALUES ('340', '21', 'Jumpy Combi', 'german');
INSERT INTO class_model VALUES ('341', '21', 'Nemo', 'ro');
INSERT INTO class_model VALUES ('341', '21', 'Nemo', 'eng');
INSERT INTO class_model VALUES ('341', '21', 'Nemo', 'german');
INSERT INTO class_model VALUES ('342', '21', 'SM', 'ro');
INSERT INTO class_model VALUES ('342', '21', 'SM', 'eng');
INSERT INTO class_model VALUES ('342', '21', 'SM', 'german');
INSERT INTO class_model VALUES ('343', '21', 'Saxo', 'ro');
INSERT INTO class_model VALUES ('343', '21', 'Saxo', 'eng');
INSERT INTO class_model VALUES ('343', '21', 'Saxo', 'german');
INSERT INTO class_model VALUES ('344', '21', 'Visa', 'ro');
INSERT INTO class_model VALUES ('344', '21', 'Visa', 'eng');
INSERT INTO class_model VALUES ('344', '21', 'Visa', 'german');
INSERT INTO class_model VALUES ('345', '21', 'XM', 'ro');
INSERT INTO class_model VALUES ('345', '21', 'XM', 'eng');
INSERT INTO class_model VALUES ('345', '21', 'XM', 'german');
INSERT INTO class_model VALUES ('346', '21', 'Xantia', 'ro');
INSERT INTO class_model VALUES ('346', '21', 'Xantia', 'eng');
INSERT INTO class_model VALUES ('346', '21', 'Xantia', 'german');
INSERT INTO class_model VALUES ('347', '21', 'Xsara', 'ro');
INSERT INTO class_model VALUES ('347', '21', 'Xsara', 'eng');
INSERT INTO class_model VALUES ('347', '21', 'Xsara', 'german');
INSERT INTO class_model VALUES ('348', '21', 'Xsara Picasso', 'ro');
INSERT INTO class_model VALUES ('348', '21', 'Xsara Picasso', 'eng');
INSERT INTO class_model VALUES ('348', '21', 'Xsara Picasso', 'german');
INSERT INTO class_model VALUES ('349', '21', 'ZX', 'ro');
INSERT INTO class_model VALUES ('349', '21', 'ZX', 'eng');
INSERT INTO class_model VALUES ('349', '21', 'ZX', 'german');
INSERT INTO class_model VALUES ('350', '21', 'C4 Grand Picasso', 'ro');
INSERT INTO class_model VALUES ('350', '21', 'C4 Grand Picasso', 'eng');
INSERT INTO class_model VALUES ('350', '21', 'C4 Grand Picasso', 'german');
INSERT INTO class_model VALUES ('351', '22', 'S1', 'ro');
INSERT INTO class_model VALUES ('351', '22', 'S1', 'eng');
INSERT INTO class_model VALUES ('351', '22', 'S1', 'german');
INSERT INTO class_model VALUES ('352', '23', '1300', 'ro');
INSERT INTO class_model VALUES ('352', '23', '1300', 'eng');
INSERT INTO class_model VALUES ('352', '23', '1300', 'german');
INSERT INTO class_model VALUES ('353', '23', '1310', 'ro');
INSERT INTO class_model VALUES ('353', '23', '1310', 'eng');
INSERT INTO class_model VALUES ('353', '23', '1310', 'german');
INSERT INTO class_model VALUES ('354', '23', '1400', 'ro');
INSERT INTO class_model VALUES ('354', '23', '1400', 'eng');
INSERT INTO class_model VALUES ('354', '23', '1400', 'german');
INSERT INTO class_model VALUES ('355', '23', '1410', 'ro');
INSERT INTO class_model VALUES ('355', '23', '1410', 'eng');
INSERT INTO class_model VALUES ('355', '23', '1410', 'german');
INSERT INTO class_model VALUES ('356', '23', 'Dokker', 'ro');
INSERT INTO class_model VALUES ('356', '23', 'Dokker', 'eng');
INSERT INTO class_model VALUES ('356', '23', 'Dokker', 'german');
INSERT INTO class_model VALUES ('357', '23', 'Dokker Van', 'ro');
INSERT INTO class_model VALUES ('357', '23', 'Dokker Van', 'eng');
INSERT INTO class_model VALUES ('357', '23', 'Dokker Van', 'german');
INSERT INTO class_model VALUES ('358', '23', 'Duster', 'ro');
INSERT INTO class_model VALUES ('358', '23', 'Duster', 'eng');
INSERT INTO class_model VALUES ('358', '23', 'Duster', 'german');
INSERT INTO class_model VALUES ('359', '23', 'Lodgy', 'ro');
INSERT INTO class_model VALUES ('359', '23', 'Lodgy', 'eng');
INSERT INTO class_model VALUES ('359', '23', 'Lodgy', 'german');
INSERT INTO class_model VALUES ('360', '23', 'Logan', 'ro');
INSERT INTO class_model VALUES ('360', '23', 'Logan', 'eng');
INSERT INTO class_model VALUES ('360', '23', 'Logan', 'german');
INSERT INTO class_model VALUES ('361', '23', 'Logan Van', 'ro');
INSERT INTO class_model VALUES ('361', '23', 'Logan Van', 'eng');
INSERT INTO class_model VALUES ('361', '23', 'Logan Van', 'german');
INSERT INTO class_model VALUES ('362', '23', 'Nova', 'ro');
INSERT INTO class_model VALUES ('362', '23', 'Nova', 'eng');
INSERT INTO class_model VALUES ('362', '23', 'Nova', 'german');
INSERT INTO class_model VALUES ('363', '23', 'Pick Up', 'ro');
INSERT INTO class_model VALUES ('363', '23', 'Pick Up', 'eng');
INSERT INTO class_model VALUES ('363', '23', 'Pick Up', 'german');
INSERT INTO class_model VALUES ('364', '23', 'Sandero', 'ro');
INSERT INTO class_model VALUES ('364', '23', 'Sandero', 'eng');
INSERT INTO class_model VALUES ('364', '23', 'Sandero', 'german');
INSERT INTO class_model VALUES ('365', '23', 'Sandero Stepway', 'ro');
INSERT INTO class_model VALUES ('365', '23', 'Sandero Stepway', 'eng');
INSERT INTO class_model VALUES ('365', '23', 'Sandero Stepway', 'german');
INSERT INTO class_model VALUES ('366', '23', 'Solenza', 'ro');
INSERT INTO class_model VALUES ('366', '23', 'Solenza', 'eng');
INSERT INTO class_model VALUES ('366', '23', 'Solenza', 'german');
INSERT INTO class_model VALUES ('367', '23', 'Super Nova', 'ro');
INSERT INTO class_model VALUES ('367', '23', 'Super Nova', 'eng');
INSERT INTO class_model VALUES ('367', '23', 'Super Nova', 'german');
INSERT INTO class_model VALUES ('368', '24', 'Chairman', 'ro');
INSERT INTO class_model VALUES ('368', '24', 'Chairman', 'eng');
INSERT INTO class_model VALUES ('368', '24', 'Chairman', 'german');
INSERT INTO class_model VALUES ('369', '24', 'Cielo', 'ro');
INSERT INTO class_model VALUES ('369', '24', 'Cielo', 'eng');
INSERT INTO class_model VALUES ('369', '24', 'Cielo', 'german');
INSERT INTO class_model VALUES ('370', '24', 'Espero', 'ro');
INSERT INTO class_model VALUES ('370', '24', 'Espero', 'eng');
INSERT INTO class_model VALUES ('370', '24', 'Espero', 'german');
INSERT INTO class_model VALUES ('371', '24', 'Evanda', 'ro');
INSERT INTO class_model VALUES ('371', '24', 'Evanda', 'eng');
INSERT INTO class_model VALUES ('371', '24', 'Evanda', 'german');
INSERT INTO class_model VALUES ('372', '24', 'Kalos', 'ro');
INSERT INTO class_model VALUES ('372', '24', 'Kalos', 'eng');
INSERT INTO class_model VALUES ('372', '24', 'Kalos', 'german');
INSERT INTO class_model VALUES ('373', '24', 'Korando', 'ro');
INSERT INTO class_model VALUES ('373', '24', 'Korando', 'eng');
INSERT INTO class_model VALUES ('373', '24', 'Korando', 'german');
INSERT INTO class_model VALUES ('374', '24', 'Lacetti', 'ro');
INSERT INTO class_model VALUES ('374', '24', 'Lacetti', 'eng');
INSERT INTO class_model VALUES ('374', '24', 'Lacetti', 'german');
INSERT INTO class_model VALUES ('375', '24', 'Lanos', 'ro');
INSERT INTO class_model VALUES ('375', '24', 'Lanos', 'eng');
INSERT INTO class_model VALUES ('375', '24', 'Lanos', 'german');
INSERT INTO class_model VALUES ('376', '24', 'Leganza', 'ro');
INSERT INTO class_model VALUES ('376', '24', 'Leganza', 'eng');
INSERT INTO class_model VALUES ('376', '24', 'Leganza', 'german');
INSERT INTO class_model VALUES ('377', '24', 'Matiz', 'ro');
INSERT INTO class_model VALUES ('377', '24', 'Matiz', 'eng');
INSERT INTO class_model VALUES ('377', '24', 'Matiz', 'german');
INSERT INTO class_model VALUES ('378', '24', 'Musso', 'ro');
INSERT INTO class_model VALUES ('378', '24', 'Musso', 'eng');
INSERT INTO class_model VALUES ('378', '24', 'Musso', 'german');
INSERT INTO class_model VALUES ('379', '24', 'Nexia', 'ro');
INSERT INTO class_model VALUES ('379', '24', 'Nexia', 'eng');
INSERT INTO class_model VALUES ('379', '24', 'Nexia', 'german');
INSERT INTO class_model VALUES ('380', '24', 'Nubira', 'ro');
INSERT INTO class_model VALUES ('380', '24', 'Nubira', 'eng');
INSERT INTO class_model VALUES ('380', '24', 'Nubira', 'german');
INSERT INTO class_model VALUES ('381', '24', 'Racer', 'ro');
INSERT INTO class_model VALUES ('381', '24', 'Racer', 'eng');
INSERT INTO class_model VALUES ('381', '24', 'Racer', 'german');
INSERT INTO class_model VALUES ('382', '24', 'Rezzo', 'ro');
INSERT INTO class_model VALUES ('382', '24', 'Rezzo', 'eng');
INSERT INTO class_model VALUES ('382', '24', 'Rezzo', 'german');
INSERT INTO class_model VALUES ('383', '24', 'Tacuma', 'ro');
INSERT INTO class_model VALUES ('383', '24', 'Tacuma', 'eng');
INSERT INTO class_model VALUES ('383', '24', 'Tacuma', 'german');
INSERT INTO class_model VALUES ('384', '24', 'Tico', 'ro');
INSERT INTO class_model VALUES ('384', '24', 'Tico', 'eng');
INSERT INTO class_model VALUES ('384', '24', 'Tico', 'german');
INSERT INTO class_model VALUES ('385', '25', 'Applause', 'ro');
INSERT INTO class_model VALUES ('385', '25', 'Applause', 'eng');
INSERT INTO class_model VALUES ('385', '25', 'Applause', 'german');
INSERT INTO class_model VALUES ('386', '25', 'Charade', 'ro');
INSERT INTO class_model VALUES ('386', '25', 'Charade', 'eng');
INSERT INTO class_model VALUES ('386', '25', 'Charade', 'german');
INSERT INTO class_model VALUES ('387', '25', 'Charmant', 'ro');
INSERT INTO class_model VALUES ('387', '25', 'Charmant', 'eng');
INSERT INTO class_model VALUES ('387', '25', 'Charmant', 'german');
INSERT INTO class_model VALUES ('388', '25', 'Copen', 'ro');
INSERT INTO class_model VALUES ('388', '25', 'Copen', 'eng');
INSERT INTO class_model VALUES ('388', '25', 'Copen', 'german');
INSERT INTO class_model VALUES ('389', '25', 'Cuore', 'ro');
INSERT INTO class_model VALUES ('389', '25', 'Cuore', 'eng');
INSERT INTO class_model VALUES ('389', '25', 'Cuore', 'german');
INSERT INTO class_model VALUES ('390', '25', 'Feroza', 'ro');
INSERT INTO class_model VALUES ('390', '25', 'Feroza', 'eng');
INSERT INTO class_model VALUES ('390', '25', 'Feroza', 'german');
INSERT INTO class_model VALUES ('391', '25', 'Fourtrak', 'ro');
INSERT INTO class_model VALUES ('391', '25', 'Fourtrak', 'eng');
INSERT INTO class_model VALUES ('391', '25', 'Fourtrak', 'german');
INSERT INTO class_model VALUES ('392', '25', 'Freeclimber', 'ro');
INSERT INTO class_model VALUES ('392', '25', 'Freeclimber', 'eng');
INSERT INTO class_model VALUES ('392', '25', 'Freeclimber', 'german');
INSERT INTO class_model VALUES ('393', '25', 'Gran Move', 'ro');
INSERT INTO class_model VALUES ('393', '25', 'Gran Move', 'eng');
INSERT INTO class_model VALUES ('393', '25', 'Gran Move', 'german');
INSERT INTO class_model VALUES ('394', '25', 'Hijet', 'ro');
INSERT INTO class_model VALUES ('394', '25', 'Hijet', 'eng');
INSERT INTO class_model VALUES ('394', '25', 'Hijet', 'german');
INSERT INTO class_model VALUES ('395', '25', 'Materia', 'ro');
INSERT INTO class_model VALUES ('395', '25', 'Materia', 'eng');
INSERT INTO class_model VALUES ('395', '25', 'Materia', 'german');
INSERT INTO class_model VALUES ('396', '25', 'Move', 'ro');
INSERT INTO class_model VALUES ('396', '25', 'Move', 'eng');
INSERT INTO class_model VALUES ('396', '25', 'Move', 'german');
INSERT INTO class_model VALUES ('397', '25', 'Rocky', 'ro');
INSERT INTO class_model VALUES ('397', '25', 'Rocky', 'eng');
INSERT INTO class_model VALUES ('397', '25', 'Rocky', 'german');
INSERT INTO class_model VALUES ('398', '25', 'Sirion', 'ro');
INSERT INTO class_model VALUES ('398', '25', 'Sirion', 'eng');
INSERT INTO class_model VALUES ('398', '25', 'Sirion', 'german');
INSERT INTO class_model VALUES ('399', '25', 'Sportrak', 'ro');
INSERT INTO class_model VALUES ('399', '25', 'Sportrak', 'eng');
INSERT INTO class_model VALUES ('399', '25', 'Sportrak', 'german');
INSERT INTO class_model VALUES ('400', '25', 'Terios', 'ro');
INSERT INTO class_model VALUES ('400', '25', 'Terios', 'eng');
INSERT INTO class_model VALUES ('400', '25', 'Terios', 'german');
INSERT INTO class_model VALUES ('401', '25', 'Trevis', 'ro');
INSERT INTO class_model VALUES ('401', '25', 'Trevis', 'eng');
INSERT INTO class_model VALUES ('401', '25', 'Trevis', 'german');
INSERT INTO class_model VALUES ('402', '25', 'YRV', 'ro');
INSERT INTO class_model VALUES ('402', '25', 'YRV', 'eng');
INSERT INTO class_model VALUES ('402', '25', 'YRV', 'german');
INSERT INTO class_model VALUES ('403', '26', 'DMC 12', 'ro');
INSERT INTO class_model VALUES ('403', '26', 'DMC 12', 'eng');
INSERT INTO class_model VALUES ('403', '26', 'DMC 12', 'german');
INSERT INTO class_model VALUES ('404', '27', 'Double Cab', 'ro');
INSERT INTO class_model VALUES ('404', '27', 'Double Cab', 'eng');
INSERT INTO class_model VALUES ('404', '27', 'Double Cab', 'german');
INSERT INTO class_model VALUES ('405', '27', 'Mini Bus', 'ro');
INSERT INTO class_model VALUES ('405', '27', 'Mini Bus', 'eng');
INSERT INTO class_model VALUES ('405', '27', 'Mini Bus', 'german');
INSERT INTO class_model VALUES ('406', '27', 'Mini Van', 'ro');
INSERT INTO class_model VALUES ('406', '27', 'Mini Van', 'eng');
INSERT INTO class_model VALUES ('406', '27', 'Mini Van', 'german');
INSERT INTO class_model VALUES ('407', '27', 'Pick Up', 'ro');
INSERT INTO class_model VALUES ('407', '27', 'Pick Up', 'eng');
INSERT INTO class_model VALUES ('407', '27', 'Pick Up', 'german');
INSERT INTO class_model VALUES ('408', '29', 'Avenger', 'ro');
INSERT INTO class_model VALUES ('408', '29', 'Avenger', 'eng');
INSERT INTO class_model VALUES ('408', '29', 'Avenger', 'german');
INSERT INTO class_model VALUES ('409', '29', 'Caliber', 'ro');
INSERT INTO class_model VALUES ('409', '29', 'Caliber', 'eng');
INSERT INTO class_model VALUES ('409', '29', 'Caliber', 'german');
INSERT INTO class_model VALUES ('410', '29', 'Caravan', 'ro');
INSERT INTO class_model VALUES ('410', '29', 'Caravan', 'eng');
INSERT INTO class_model VALUES ('410', '29', 'Caravan', 'german');
INSERT INTO class_model VALUES ('411', '29', 'Challenger', 'ro');
INSERT INTO class_model VALUES ('411', '29', 'Challenger', 'eng');
INSERT INTO class_model VALUES ('411', '29', 'Challenger', 'german');
INSERT INTO class_model VALUES ('412', '29', 'Charger', 'ro');
INSERT INTO class_model VALUES ('412', '29', 'Charger', 'eng');
INSERT INTO class_model VALUES ('412', '29', 'Charger', 'german');
INSERT INTO class_model VALUES ('413', '29', 'Dakota', 'ro');
INSERT INTO class_model VALUES ('413', '29', 'Dakota', 'eng');
INSERT INTO class_model VALUES ('413', '29', 'Dakota', 'german');
INSERT INTO class_model VALUES ('414', '29', 'Dart', 'ro');
INSERT INTO class_model VALUES ('414', '29', 'Dart', 'eng');
INSERT INTO class_model VALUES ('414', '29', 'Dart', 'german');
INSERT INTO class_model VALUES ('415', '29', 'Daytona', 'ro');
INSERT INTO class_model VALUES ('415', '29', 'Daytona', 'eng');
INSERT INTO class_model VALUES ('415', '29', 'Daytona', 'german');
INSERT INTO class_model VALUES ('416', '29', 'Diplomat', 'ro');
INSERT INTO class_model VALUES ('416', '29', 'Diplomat', 'eng');
INSERT INTO class_model VALUES ('416', '29', 'Diplomat', 'german');
INSERT INTO class_model VALUES ('417', '29', 'Durango', 'ro');
INSERT INTO class_model VALUES ('417', '29', 'Durango', 'eng');
INSERT INTO class_model VALUES ('417', '29', 'Durango', 'german');
INSERT INTO class_model VALUES ('418', '29', 'Dynasty', 'ro');
INSERT INTO class_model VALUES ('418', '29', 'Dynasty', 'eng');
INSERT INTO class_model VALUES ('418', '29', 'Dynasty', 'german');
INSERT INTO class_model VALUES ('419', '29', 'Grand Caravan', 'ro');
INSERT INTO class_model VALUES ('419', '29', 'Grand Caravan', 'eng');
INSERT INTO class_model VALUES ('419', '29', 'Grand Caravan', 'german');
INSERT INTO class_model VALUES ('420', '29', 'Hornet', 'ro');
INSERT INTO class_model VALUES ('420', '29', 'Hornet', 'eng');
INSERT INTO class_model VALUES ('420', '29', 'Hornet', 'german');
INSERT INTO class_model VALUES ('421', '29', 'Intrepid', 'ro');
INSERT INTO class_model VALUES ('421', '29', 'Intrepid', 'eng');
INSERT INTO class_model VALUES ('421', '29', 'Intrepid', 'german');
INSERT INTO class_model VALUES ('422', '29', 'Journey', 'ro');
INSERT INTO class_model VALUES ('422', '29', 'Journey', 'eng');
INSERT INTO class_model VALUES ('422', '29', 'Journey', 'german');
INSERT INTO class_model VALUES ('423', '29', 'Magnum', 'ro');
INSERT INTO class_model VALUES ('423', '29', 'Magnum', 'eng');
INSERT INTO class_model VALUES ('423', '29', 'Magnum', 'german');
INSERT INTO class_model VALUES ('424', '29', 'Monaco', 'ro');
INSERT INTO class_model VALUES ('424', '29', 'Monaco', 'eng');
INSERT INTO class_model VALUES ('424', '29', 'Monaco', 'german');
INSERT INTO class_model VALUES ('425', '29', 'Neon', 'ro');
INSERT INTO class_model VALUES ('425', '29', 'Neon', 'eng');
INSERT INTO class_model VALUES ('425', '29', 'Neon', 'german');
INSERT INTO class_model VALUES ('426', '29', 'Nitro', 'ro');
INSERT INTO class_model VALUES ('426', '29', 'Nitro', 'eng');
INSERT INTO class_model VALUES ('426', '29', 'Nitro', 'german');
INSERT INTO class_model VALUES ('427', '29', 'Omni', 'ro');
INSERT INTO class_model VALUES ('427', '29', 'Omni', 'eng');
INSERT INTO class_model VALUES ('427', '29', 'Omni', 'german');
INSERT INTO class_model VALUES ('428', '29', 'RAM', 'ro');
INSERT INTO class_model VALUES ('428', '29', 'RAM', 'eng');
INSERT INTO class_model VALUES ('428', '29', 'RAM', 'german');
INSERT INTO class_model VALUES ('429', '29', 'Spirit', 'ro');
INSERT INTO class_model VALUES ('429', '29', 'Spirit', 'eng');
INSERT INTO class_model VALUES ('429', '29', 'Spirit', 'german');
INSERT INTO class_model VALUES ('430', '29', 'Stealth', 'ro');
INSERT INTO class_model VALUES ('430', '29', 'Stealth', 'eng');
INSERT INTO class_model VALUES ('430', '29', 'Stealth', 'german');
INSERT INTO class_model VALUES ('431', '29', 'Stratus', 'ro');
INSERT INTO class_model VALUES ('431', '29', 'Stratus', 'eng');
INSERT INTO class_model VALUES ('431', '29', 'Stratus', 'german');
INSERT INTO class_model VALUES ('432', '29', 'Viper', 'ro');
INSERT INTO class_model VALUES ('432', '29', 'Viper', 'eng');
INSERT INTO class_model VALUES ('432', '29', 'Viper', 'german');
INSERT INTO class_model VALUES ('433', '30', 'DR1', 'ro');
INSERT INTO class_model VALUES ('433', '30', 'DR1', 'eng');
INSERT INTO class_model VALUES ('433', '30', 'DR1', 'german');
INSERT INTO class_model VALUES ('434', '30', 'DR2', 'ro');
INSERT INTO class_model VALUES ('434', '30', 'DR2', 'eng');
INSERT INTO class_model VALUES ('434', '30', 'DR2', 'german');
INSERT INTO class_model VALUES ('435', '30', 'DR3', 'ro');
INSERT INTO class_model VALUES ('435', '30', 'DR3', 'eng');
INSERT INTO class_model VALUES ('435', '30', 'DR3', 'german');
INSERT INTO class_model VALUES ('436', '30', 'DR5', 'ro');
INSERT INTO class_model VALUES ('436', '30', 'DR5', 'eng');
INSERT INTO class_model VALUES ('436', '30', 'DR5', 'german');
INSERT INTO class_model VALUES ('437', '31', 'Medallion', 'ro');
INSERT INTO class_model VALUES ('437', '31', 'Medallion', 'eng');
INSERT INTO class_model VALUES ('437', '31', 'Medallion', 'german');
INSERT INTO class_model VALUES ('438', '31', 'Premier', 'ro');
INSERT INTO class_model VALUES ('438', '31', 'Premier', 'eng');
INSERT INTO class_model VALUES ('438', '31', 'Premier', 'german');
INSERT INTO class_model VALUES ('439', '31', 'Summit', 'ro');
INSERT INTO class_model VALUES ('439', '31', 'Summit', 'eng');
INSERT INTO class_model VALUES ('439', '31', 'Summit', 'german');
INSERT INTO class_model VALUES ('440', '31', 'Talon', 'ro');
INSERT INTO class_model VALUES ('440', '31', 'Talon', 'eng');
INSERT INTO class_model VALUES ('440', '31', 'Talon', 'german');
INSERT INTO class_model VALUES ('441', '31', 'Vision', 'ro');
INSERT INTO class_model VALUES ('441', '31', 'Vision', 'eng');
INSERT INTO class_model VALUES ('441', '31', 'Vision', 'german');
INSERT INTO class_model VALUES ('442', '32', 'Phaeton', 'ro');
INSERT INTO class_model VALUES ('442', '32', 'Phaeton', 'eng');
INSERT INTO class_model VALUES ('442', '32', 'Phaeton', 'german');
INSERT INTO class_model VALUES ('443', '32', 'Roadster', 'ro');
INSERT INTO class_model VALUES ('443', '32', 'Roadster', 'eng');
INSERT INTO class_model VALUES ('443', '32', 'Roadster', 'german');
INSERT INTO class_model VALUES ('444', '33', 'HQ', 'ro');
INSERT INTO class_model VALUES ('444', '33', 'HQ', 'eng');
INSERT INTO class_model VALUES ('444', '33', 'HQ', 'german');
INSERT INTO class_model VALUES ('445', '34', '208', 'ro');
INSERT INTO class_model VALUES ('445', '34', '208', 'eng');
INSERT INTO class_model VALUES ('445', '34', '208', 'german');
INSERT INTO class_model VALUES ('446', '34', '248', 'ro');
INSERT INTO class_model VALUES ('446', '34', '248', 'eng');
INSERT INTO class_model VALUES ('446', '34', '248', 'german');
INSERT INTO class_model VALUES ('447', '34', '250', 'ro');
INSERT INTO class_model VALUES ('447', '34', '250', 'eng');
INSERT INTO class_model VALUES ('447', '34', '250', 'german');
INSERT INTO class_model VALUES ('448', '34', '288', 'ro');
INSERT INTO class_model VALUES ('448', '34', '288', 'eng');
INSERT INTO class_model VALUES ('448', '34', '288', 'german');
INSERT INTO class_model VALUES ('449', '34', '308', 'ro');
INSERT INTO class_model VALUES ('449', '34', '308', 'eng');
INSERT INTO class_model VALUES ('449', '34', '308', 'german');
INSERT INTO class_model VALUES ('450', '34', '328', 'ro');
INSERT INTO class_model VALUES ('450', '34', '328', 'eng');
INSERT INTO class_model VALUES ('450', '34', '328', 'german');
INSERT INTO class_model VALUES ('451', '34', '330', 'ro');
INSERT INTO class_model VALUES ('451', '34', '330', 'eng');
INSERT INTO class_model VALUES ('451', '34', '330', 'german');
INSERT INTO class_model VALUES ('452', '34', '348', 'ro');
INSERT INTO class_model VALUES ('452', '34', '348', 'eng');
INSERT INTO class_model VALUES ('452', '34', '348', 'german');
INSERT INTO class_model VALUES ('453', '34', '360', 'ro');
INSERT INTO class_model VALUES ('453', '34', '360', 'eng');
INSERT INTO class_model VALUES ('453', '34', '360', 'german');
INSERT INTO class_model VALUES ('454', '34', '365', 'ro');
INSERT INTO class_model VALUES ('454', '34', '365', 'eng');
INSERT INTO class_model VALUES ('454', '34', '365', 'german');
INSERT INTO class_model VALUES ('455', '34', '400', 'ro');
INSERT INTO class_model VALUES ('455', '34', '400', 'eng');
INSERT INTO class_model VALUES ('455', '34', '400', 'german');
INSERT INTO class_model VALUES ('456', '34', '412', 'ro');
INSERT INTO class_model VALUES ('456', '34', '412', 'eng');
INSERT INTO class_model VALUES ('456', '34', '412', 'german');
INSERT INTO class_model VALUES ('457', '34', '456', 'ro');
INSERT INTO class_model VALUES ('457', '34', '456', 'eng');
INSERT INTO class_model VALUES ('457', '34', '456', 'german');
INSERT INTO class_model VALUES ('458', '34', '458 Italia', 'ro');
INSERT INTO class_model VALUES ('458', '34', '458 Italia', 'eng');
INSERT INTO class_model VALUES ('458', '34', '458 Italia', 'german');
INSERT INTO class_model VALUES ('459', '34', '512', 'ro');
INSERT INTO class_model VALUES ('459', '34', '512', 'eng');
INSERT INTO class_model VALUES ('459', '34', '512', 'german');
INSERT INTO class_model VALUES ('460', '34', '575', 'ro');
INSERT INTO class_model VALUES ('460', '34', '575', 'eng');
INSERT INTO class_model VALUES ('460', '34', '575', 'german');
INSERT INTO class_model VALUES ('461', '34', '599GTB', 'ro');
INSERT INTO class_model VALUES ('461', '34', '599GTB', 'eng');
INSERT INTO class_model VALUES ('461', '34', '599GTB', 'german');
INSERT INTO class_model VALUES ('462', '34', '612', 'ro');
INSERT INTO class_model VALUES ('462', '34', '612', 'eng');
INSERT INTO class_model VALUES ('462', '34', '612', 'german');
INSERT INTO class_model VALUES ('463', '34', '750', 'ro');
INSERT INTO class_model VALUES ('463', '34', '750', 'eng');
INSERT INTO class_model VALUES ('463', '34', '750', 'german');
INSERT INTO class_model VALUES ('464', '34', 'California', 'ro');
INSERT INTO class_model VALUES ('464', '34', 'California', 'eng');
INSERT INTO class_model VALUES ('464', '34', 'California', 'german');
INSERT INTO class_model VALUES ('465', '34', 'Daytona', 'ro');
INSERT INTO class_model VALUES ('465', '34', 'Daytona', 'eng');
INSERT INTO class_model VALUES ('465', '34', 'Daytona', 'german');
INSERT INTO class_model VALUES ('466', '34', 'Dino GT4', 'ro');
INSERT INTO class_model VALUES ('466', '34', 'Dino GT4', 'eng');
INSERT INTO class_model VALUES ('466', '34', 'Dino GT4', 'german');
INSERT INTO class_model VALUES ('467', '34', 'Enzo', 'ro');
INSERT INTO class_model VALUES ('467', '34', 'Enzo', 'eng');
INSERT INTO class_model VALUES ('467', '34', 'Enzo', 'german');
INSERT INTO class_model VALUES ('468', '34', 'F12', 'ro');
INSERT INTO class_model VALUES ('468', '34', 'F12', 'eng');
INSERT INTO class_model VALUES ('468', '34', 'F12', 'german');
INSERT INTO class_model VALUES ('469', '34', 'F355', 'ro');
INSERT INTO class_model VALUES ('469', '34', 'F355', 'eng');
INSERT INTO class_model VALUES ('469', '34', 'F355', 'german');
INSERT INTO class_model VALUES ('470', '34', 'F360', 'ro');
INSERT INTO class_model VALUES ('470', '34', 'F360', 'eng');
INSERT INTO class_model VALUES ('470', '34', 'F360', 'german');
INSERT INTO class_model VALUES ('471', '34', 'F40', 'ro');
INSERT INTO class_model VALUES ('471', '34', 'F40', 'eng');
INSERT INTO class_model VALUES ('471', '34', 'F40', 'german');
INSERT INTO class_model VALUES ('472', '34', 'F430', 'ro');
INSERT INTO class_model VALUES ('472', '34', 'F430', 'eng');
INSERT INTO class_model VALUES ('472', '34', 'F430', 'german');
INSERT INTO class_model VALUES ('473', '34', 'F50', 'ro');
INSERT INTO class_model VALUES ('473', '34', 'F50', 'eng');
INSERT INTO class_model VALUES ('473', '34', 'F50', 'german');
INSERT INTO class_model VALUES ('474', '34', 'F550', 'ro');
INSERT INTO class_model VALUES ('474', '34', 'F550', 'eng');
INSERT INTO class_model VALUES ('474', '34', 'F550', 'german');
INSERT INTO class_model VALUES ('475', '34', 'FF', 'ro');
INSERT INTO class_model VALUES ('475', '34', 'FF', 'eng');
INSERT INTO class_model VALUES ('475', '34', 'FF', 'german');
INSERT INTO class_model VALUES ('476', '34', 'LaFerrari', 'ro');
INSERT INTO class_model VALUES ('476', '34', 'LaFerrari', 'eng');
INSERT INTO class_model VALUES ('476', '34', 'LaFerrari', 'german');
INSERT INTO class_model VALUES ('477', '34', 'Mondial', 'ro');
INSERT INTO class_model VALUES ('477', '34', 'Mondial', 'eng');
INSERT INTO class_model VALUES ('477', '34', 'Mondial', 'german');
INSERT INTO class_model VALUES ('478', '34', 'Superamerica', 'ro');
INSERT INTO class_model VALUES ('478', '34', 'Superamerica', 'eng');
INSERT INTO class_model VALUES ('478', '34', 'Superamerica', 'german');
INSERT INTO class_model VALUES ('479', '34', 'Testarosa', 'ro');
INSERT INTO class_model VALUES ('479', '34', 'Testarosa', 'eng');
INSERT INTO class_model VALUES ('479', '34', 'Testarosa', 'german');
INSERT INTO class_model VALUES ('480', '35', '124', 'ro');
INSERT INTO class_model VALUES ('480', '35', '124', 'eng');
INSERT INTO class_model VALUES ('480', '35', '124', 'german');
INSERT INTO class_model VALUES ('481', '35', '125p', 'ro');
INSERT INTO class_model VALUES ('481', '35', '125p', 'eng');
INSERT INTO class_model VALUES ('481', '35', '125p', 'german');
INSERT INTO class_model VALUES ('482', '35', '126', 'ro');
INSERT INTO class_model VALUES ('482', '35', '126', 'eng');
INSERT INTO class_model VALUES ('482', '35', '126', 'german');
INSERT INTO class_model VALUES ('483', '35', '127', 'ro');
INSERT INTO class_model VALUES ('483', '35', '127', 'eng');
INSERT INTO class_model VALUES ('483', '35', '127', 'german');
INSERT INTO class_model VALUES ('484', '35', '128', 'ro');
INSERT INTO class_model VALUES ('484', '35', '128', 'eng');
INSERT INTO class_model VALUES ('484', '35', '128', 'german');
INSERT INTO class_model VALUES ('485', '35', '130', 'ro');
INSERT INTO class_model VALUES ('485', '35', '130', 'eng');
INSERT INTO class_model VALUES ('485', '35', '130', 'german');
INSERT INTO class_model VALUES ('486', '35', '131', 'ro');
INSERT INTO class_model VALUES ('486', '35', '131', 'eng');
INSERT INTO class_model VALUES ('486', '35', '131', 'german');
INSERT INTO class_model VALUES ('487', '35', '132', 'ro');
INSERT INTO class_model VALUES ('487', '35', '132', 'eng');
INSERT INTO class_model VALUES ('487', '35', '132', 'german');
INSERT INTO class_model VALUES ('488', '35', '500', 'ro');
INSERT INTO class_model VALUES ('488', '35', '500', 'eng');
INSERT INTO class_model VALUES ('488', '35', '500', 'german');
INSERT INTO class_model VALUES ('489', '35', '500L', 'ro');
INSERT INTO class_model VALUES ('489', '35', '500L', 'eng');
INSERT INTO class_model VALUES ('489', '35', '500L', 'german');
INSERT INTO class_model VALUES ('490', '35', '600', 'ro');
INSERT INTO class_model VALUES ('490', '35', '600', 'eng');
INSERT INTO class_model VALUES ('490', '35', '600', 'german');
INSERT INTO class_model VALUES ('491', '35', '850', 'ro');
INSERT INTO class_model VALUES ('491', '35', '850', 'eng');
INSERT INTO class_model VALUES ('491', '35', '850', 'german');
INSERT INTO class_model VALUES ('492', '35', 'Albea', 'ro');
INSERT INTO class_model VALUES ('492', '35', 'Albea', 'eng');
INSERT INTO class_model VALUES ('492', '35', 'Albea', 'german');
INSERT INTO class_model VALUES ('493', '35', 'Barchetta', 'ro');
INSERT INTO class_model VALUES ('493', '35', 'Barchetta', 'eng');
INSERT INTO class_model VALUES ('493', '35', 'Barchetta', 'german');
INSERT INTO class_model VALUES ('494', '35', 'Brava', 'ro');
INSERT INTO class_model VALUES ('494', '35', 'Brava', 'eng');
INSERT INTO class_model VALUES ('494', '35', 'Brava', 'german');
INSERT INTO class_model VALUES ('495', '35', 'Bravo', 'ro');
INSERT INTO class_model VALUES ('495', '35', 'Bravo', 'eng');
INSERT INTO class_model VALUES ('495', '35', 'Bravo', 'german');
INSERT INTO class_model VALUES ('496', '35', 'Cinquecento', 'ro');
INSERT INTO class_model VALUES ('496', '35', 'Cinquecento', 'eng');
INSERT INTO class_model VALUES ('496', '35', 'Cinquecento', 'german');
INSERT INTO class_model VALUES ('497', '35', 'Coupe', 'ro');
INSERT INTO class_model VALUES ('497', '35', 'Coupe', 'eng');
INSERT INTO class_model VALUES ('497', '35', 'Coupe', 'german');
INSERT INTO class_model VALUES ('498', '35', 'Croma', 'ro');
INSERT INTO class_model VALUES ('498', '35', 'Croma', 'eng');
INSERT INTO class_model VALUES ('498', '35', 'Croma', 'german');
INSERT INTO class_model VALUES ('499', '35', 'Dino', 'ro');
INSERT INTO class_model VALUES ('499', '35', 'Dino', 'eng');
INSERT INTO class_model VALUES ('499', '35', 'Dino', 'german');
INSERT INTO class_model VALUES ('500', '35', 'Doblo', 'ro');
INSERT INTO class_model VALUES ('500', '35', 'Doblo', 'eng');
INSERT INTO class_model VALUES ('500', '35', 'Doblo', 'german');
INSERT INTO class_model VALUES ('501', '35', 'Ducato', 'ro');
INSERT INTO class_model VALUES ('501', '35', 'Ducato', 'eng');
INSERT INTO class_model VALUES ('501', '35', 'Ducato', 'german');
INSERT INTO class_model VALUES ('502', '35', 'Fiorino', 'ro');
INSERT INTO class_model VALUES ('502', '35', 'Fiorino', 'eng');
INSERT INTO class_model VALUES ('502', '35', 'Fiorino', 'german');
INSERT INTO class_model VALUES ('503', '35', 'Freemont', 'ro');
INSERT INTO class_model VALUES ('503', '35', 'Freemont', 'eng');
INSERT INTO class_model VALUES ('503', '35', 'Freemont', 'german');
INSERT INTO class_model VALUES ('504', '35', 'Grande Punto', 'ro');
INSERT INTO class_model VALUES ('504', '35', 'Grande Punto', 'eng');
INSERT INTO class_model VALUES ('504', '35', 'Grande Punto', 'german');
INSERT INTO class_model VALUES ('505', '35', 'Idea', 'ro');
INSERT INTO class_model VALUES ('505', '35', 'Idea', 'eng');
INSERT INTO class_model VALUES ('505', '35', 'Idea', 'german');
INSERT INTO class_model VALUES ('506', '35', 'Linea', 'ro');
INSERT INTO class_model VALUES ('506', '35', 'Linea', 'eng');
INSERT INTO class_model VALUES ('506', '35', 'Linea', 'german');
INSERT INTO class_model VALUES ('507', '35', 'Marea', 'ro');
INSERT INTO class_model VALUES ('507', '35', 'Marea', 'eng');
INSERT INTO class_model VALUES ('507', '35', 'Marea', 'german');
INSERT INTO class_model VALUES ('508', '35', 'Multipla', 'ro');
INSERT INTO class_model VALUES ('508', '35', 'Multipla', 'eng');
INSERT INTO class_model VALUES ('508', '35', 'Multipla', 'german');
INSERT INTO class_model VALUES ('509', '35', 'Palio', 'ro');
INSERT INTO class_model VALUES ('509', '35', 'Palio', 'eng');
INSERT INTO class_model VALUES ('509', '35', 'Palio', 'german');
INSERT INTO class_model VALUES ('510', '35', 'Panda', 'ro');
INSERT INTO class_model VALUES ('510', '35', 'Panda', 'eng');
INSERT INTO class_model VALUES ('510', '35', 'Panda', 'german');
INSERT INTO class_model VALUES ('511', '35', 'Punto', 'ro');
INSERT INTO class_model VALUES ('511', '35', 'Punto', 'eng');
INSERT INTO class_model VALUES ('511', '35', 'Punto', 'german');
INSERT INTO class_model VALUES ('512', '35', 'Punto Evo', 'ro');
INSERT INTO class_model VALUES ('512', '35', 'Punto Evo', 'eng');
INSERT INTO class_model VALUES ('512', '35', 'Punto Evo', 'german');
INSERT INTO class_model VALUES ('513', '35', 'Qubo', 'ro');
INSERT INTO class_model VALUES ('513', '35', 'Qubo', 'eng');
INSERT INTO class_model VALUES ('513', '35', 'Qubo', 'german');
INSERT INTO class_model VALUES ('514', '35', 'Regata', 'ro');
INSERT INTO class_model VALUES ('514', '35', 'Regata', 'eng');
INSERT INTO class_model VALUES ('514', '35', 'Regata', 'german');
INSERT INTO class_model VALUES ('515', '35', 'Ritmo', 'ro');
INSERT INTO class_model VALUES ('515', '35', 'Ritmo', 'eng');
INSERT INTO class_model VALUES ('515', '35', 'Ritmo', 'german');
INSERT INTO class_model VALUES ('516', '35', 'Scudo', 'ro');
INSERT INTO class_model VALUES ('516', '35', 'Scudo', 'eng');
INSERT INTO class_model VALUES ('516', '35', 'Scudo', 'german');
INSERT INTO class_model VALUES ('517', '35', 'Sedici', 'ro');
INSERT INTO class_model VALUES ('517', '35', 'Sedici', 'eng');
INSERT INTO class_model VALUES ('517', '35', 'Sedici', 'german');
INSERT INTO class_model VALUES ('518', '35', 'Seicento', 'ro');
INSERT INTO class_model VALUES ('518', '35', 'Seicento', 'eng');
INSERT INTO class_model VALUES ('518', '35', 'Seicento', 'german');
INSERT INTO class_model VALUES ('519', '35', 'Siena', 'ro');
INSERT INTO class_model VALUES ('519', '35', 'Siena', 'eng');
INSERT INTO class_model VALUES ('519', '35', 'Siena', 'german');
INSERT INTO class_model VALUES ('520', '35', 'Spider Europa', 'ro');
INSERT INTO class_model VALUES ('520', '35', 'Spider Europa', 'eng');
INSERT INTO class_model VALUES ('520', '35', 'Spider Europa', 'german');
INSERT INTO class_model VALUES ('521', '35', 'Stilo', 'ro');
INSERT INTO class_model VALUES ('521', '35', 'Stilo', 'eng');
INSERT INTO class_model VALUES ('521', '35', 'Stilo', 'german');
INSERT INTO class_model VALUES ('522', '35', 'Strada', 'ro');
INSERT INTO class_model VALUES ('522', '35', 'Strada', 'eng');
INSERT INTO class_model VALUES ('522', '35', 'Strada', 'german');
INSERT INTO class_model VALUES ('523', '35', 'Tempra', 'ro');
INSERT INTO class_model VALUES ('523', '35', 'Tempra', 'eng');
INSERT INTO class_model VALUES ('523', '35', 'Tempra', 'german');
INSERT INTO class_model VALUES ('524', '35', 'Tipo', 'ro');
INSERT INTO class_model VALUES ('524', '35', 'Tipo', 'eng');
INSERT INTO class_model VALUES ('524', '35', 'Tipo', 'german');
INSERT INTO class_model VALUES ('525', '35', 'Ulysse', 'ro');
INSERT INTO class_model VALUES ('525', '35', 'Ulysse', 'eng');
INSERT INTO class_model VALUES ('525', '35', 'Ulysse', 'german');
INSERT INTO class_model VALUES ('526', '35', 'Uno', 'ro');
INSERT INTO class_model VALUES ('526', '35', 'Uno', 'eng');
INSERT INTO class_model VALUES ('526', '35', 'Uno', 'german');
INSERT INTO class_model VALUES ('527', '35', 'X 1', 'ro');
INSERT INTO class_model VALUES ('527', '35', 'X 1', 'eng');
INSERT INTO class_model VALUES ('527', '35', 'X 1', 'german');
INSERT INTO class_model VALUES ('528', '35', '500X', 'ro');
INSERT INTO class_model VALUES ('528', '35', '500X', 'eng');
INSERT INTO class_model VALUES ('528', '35', '500X', 'german');
INSERT INTO class_model VALUES ('529', '36', 'Aerostar', 'ro');
INSERT INTO class_model VALUES ('529', '36', 'Aerostar', 'eng');
INSERT INTO class_model VALUES ('529', '36', 'Aerostar', 'german');
INSERT INTO class_model VALUES ('530', '36', 'Aspire', 'ro');
INSERT INTO class_model VALUES ('530', '36', 'Aspire', 'eng');
INSERT INTO class_model VALUES ('530', '36', 'Aspire', 'german');
INSERT INTO class_model VALUES ('531', '36', 'B-MAX', 'ro');
INSERT INTO class_model VALUES ('531', '36', 'B-MAX', 'eng');
INSERT INTO class_model VALUES ('531', '36', 'B-MAX', 'german');
INSERT INTO class_model VALUES ('532', '36', 'Bronco', 'ro');
INSERT INTO class_model VALUES ('532', '36', 'Bronco', 'eng');
INSERT INTO class_model VALUES ('532', '36', 'Bronco', 'german');
INSERT INTO class_model VALUES ('533', '36', 'C-MAX', 'ro');
INSERT INTO class_model VALUES ('533', '36', 'C-MAX', 'eng');
INSERT INTO class_model VALUES ('533', '36', 'C-MAX', 'german');
INSERT INTO class_model VALUES ('534', '36', 'Capri', 'ro');
INSERT INTO class_model VALUES ('534', '36', 'Capri', 'eng');
INSERT INTO class_model VALUES ('534', '36', 'Capri', 'german');
INSERT INTO class_model VALUES ('535', '36', 'Contour', 'ro');
INSERT INTO class_model VALUES ('535', '36', 'Contour', 'eng');
INSERT INTO class_model VALUES ('535', '36', 'Contour', 'german');
INSERT INTO class_model VALUES ('536', '36', 'Cougar', 'ro');
INSERT INTO class_model VALUES ('536', '36', 'Cougar', 'eng');
INSERT INTO class_model VALUES ('536', '36', 'Cougar', 'german');
INSERT INTO class_model VALUES ('537', '36', 'Courier', 'ro');
INSERT INTO class_model VALUES ('537', '36', 'Courier', 'eng');
INSERT INTO class_model VALUES ('537', '36', 'Courier', 'german');
INSERT INTO class_model VALUES ('538', '36', 'Crown', 'ro');
INSERT INTO class_model VALUES ('538', '36', 'Crown', 'eng');
INSERT INTO class_model VALUES ('538', '36', 'Crown', 'german');
INSERT INTO class_model VALUES ('539', '36', 'EDGE', 'ro');
INSERT INTO class_model VALUES ('539', '36', 'EDGE', 'eng');
INSERT INTO class_model VALUES ('539', '36', 'EDGE', 'german');
INSERT INTO class_model VALUES ('540', '36', 'Econoline', 'ro');
INSERT INTO class_model VALUES ('540', '36', 'Econoline', 'eng');
INSERT INTO class_model VALUES ('540', '36', 'Econoline', 'german');
INSERT INTO class_model VALUES ('541', '36', 'Econovan', 'ro');
INSERT INTO class_model VALUES ('541', '36', 'Econovan', 'eng');
INSERT INTO class_model VALUES ('541', '36', 'Econovan', 'german');
INSERT INTO class_model VALUES ('542', '36', 'Escape', 'ro');
INSERT INTO class_model VALUES ('542', '36', 'Escape', 'eng');
INSERT INTO class_model VALUES ('542', '36', 'Escape', 'german');
INSERT INTO class_model VALUES ('543', '36', 'Escort', 'ro');
INSERT INTO class_model VALUES ('543', '36', 'Escort', 'eng');
INSERT INTO class_model VALUES ('543', '36', 'Escort', 'german');
INSERT INTO class_model VALUES ('544', '36', 'Excursion', 'ro');
INSERT INTO class_model VALUES ('544', '36', 'Excursion', 'eng');
INSERT INTO class_model VALUES ('544', '36', 'Excursion', 'german');
INSERT INTO class_model VALUES ('545', '36', 'Expedition', 'ro');
INSERT INTO class_model VALUES ('545', '36', 'Expedition', 'eng');
INSERT INTO class_model VALUES ('545', '36', 'Expedition', 'german');
INSERT INTO class_model VALUES ('546', '36', 'Explorer', 'ro');
INSERT INTO class_model VALUES ('546', '36', 'Explorer', 'eng');
INSERT INTO class_model VALUES ('546', '36', 'Explorer', 'german');
INSERT INTO class_model VALUES ('547', '36', 'F150', 'ro');
INSERT INTO class_model VALUES ('547', '36', 'F150', 'eng');
INSERT INTO class_model VALUES ('547', '36', 'F150', 'german');
INSERT INTO class_model VALUES ('548', '36', 'F250', 'ro');
INSERT INTO class_model VALUES ('548', '36', 'F250', 'eng');
INSERT INTO class_model VALUES ('548', '36', 'F250', 'german');
INSERT INTO class_model VALUES ('549', '36', 'F350', 'ro');
INSERT INTO class_model VALUES ('549', '36', 'F350', 'eng');
INSERT INTO class_model VALUES ('549', '36', 'F350', 'german');
INSERT INTO class_model VALUES ('550', '36', 'Fairlane', 'ro');
INSERT INTO class_model VALUES ('550', '36', 'Fairlane', 'eng');
INSERT INTO class_model VALUES ('550', '36', 'Fairlane', 'german');
INSERT INTO class_model VALUES ('551', '36', 'Falcon', 'ro');
INSERT INTO class_model VALUES ('551', '36', 'Falcon', 'eng');
INSERT INTO class_model VALUES ('551', '36', 'Falcon', 'german');
INSERT INTO class_model VALUES ('552', '36', 'Festiva', 'ro');
INSERT INTO class_model VALUES ('552', '36', 'Festiva', 'eng');
INSERT INTO class_model VALUES ('552', '36', 'Festiva', 'german');
INSERT INTO class_model VALUES ('553', '36', 'Fiesta', 'ro');
INSERT INTO class_model VALUES ('553', '36', 'Fiesta', 'eng');
INSERT INTO class_model VALUES ('553', '36', 'Fiesta', 'german');
INSERT INTO class_model VALUES ('554', '36', 'Focus', 'ro');
INSERT INTO class_model VALUES ('554', '36', 'Focus', 'eng');
INSERT INTO class_model VALUES ('554', '36', 'Focus', 'german');
INSERT INTO class_model VALUES ('555', '36', 'Focus C-Max', 'ro');
INSERT INTO class_model VALUES ('555', '36', 'Focus C-Max', 'eng');
INSERT INTO class_model VALUES ('555', '36', 'Focus C-Max', 'german');
INSERT INTO class_model VALUES ('556', '36', 'Freestar', 'ro');
INSERT INTO class_model VALUES ('556', '36', 'Freestar', 'eng');
INSERT INTO class_model VALUES ('556', '36', 'Freestar', 'german');
INSERT INTO class_model VALUES ('557', '36', 'Freestyle', 'ro');
INSERT INTO class_model VALUES ('557', '36', 'Freestyle', 'eng');
INSERT INTO class_model VALUES ('557', '36', 'Freestyle', 'german');
INSERT INTO class_model VALUES ('558', '36', 'Fusion', 'ro');
INSERT INTO class_model VALUES ('558', '36', 'Fusion', 'eng');
INSERT INTO class_model VALUES ('558', '36', 'Fusion', 'german');
INSERT INTO class_model VALUES ('559', '36', 'GT', 'ro');
INSERT INTO class_model VALUES ('559', '36', 'GT', 'eng');
INSERT INTO class_model VALUES ('559', '36', 'GT', 'german');
INSERT INTO class_model VALUES ('560', '36', 'Galaxy', 'ro');
INSERT INTO class_model VALUES ('560', '36', 'Galaxy', 'eng');
INSERT INTO class_model VALUES ('560', '36', 'Galaxy', 'german');
INSERT INTO class_model VALUES ('561', '36', 'Granada', 'ro');
INSERT INTO class_model VALUES ('561', '36', 'Granada', 'eng');
INSERT INTO class_model VALUES ('561', '36', 'Granada', 'german');
INSERT INTO class_model VALUES ('562', '36', 'KA', 'ro');
INSERT INTO class_model VALUES ('562', '36', 'KA', 'eng');
INSERT INTO class_model VALUES ('562', '36', 'KA', 'german');
INSERT INTO class_model VALUES ('563', '36', 'Kuga', 'ro');
INSERT INTO class_model VALUES ('563', '36', 'Kuga', 'eng');
INSERT INTO class_model VALUES ('563', '36', 'Kuga', 'german');
INSERT INTO class_model VALUES ('564', '36', 'Maverick', 'ro');
INSERT INTO class_model VALUES ('564', '36', 'Maverick', 'eng');
INSERT INTO class_model VALUES ('564', '36', 'Maverick', 'german');
INSERT INTO class_model VALUES ('565', '36', 'Mecury', 'ro');
INSERT INTO class_model VALUES ('565', '36', 'Mecury', 'eng');
INSERT INTO class_model VALUES ('565', '36', 'Mecury', 'german');
INSERT INTO class_model VALUES ('566', '36', 'Mondeo', 'ro');
INSERT INTO class_model VALUES ('566', '36', 'Mondeo', 'eng');
INSERT INTO class_model VALUES ('566', '36', 'Mondeo', 'german');
INSERT INTO class_model VALUES ('567', '36', 'Mustang', 'ro');
INSERT INTO class_model VALUES ('567', '36', 'Mustang', 'eng');
INSERT INTO class_model VALUES ('567', '36', 'Mustang', 'german');
INSERT INTO class_model VALUES ('568', '36', 'Orion', 'ro');
INSERT INTO class_model VALUES ('568', '36', 'Orion', 'eng');
INSERT INTO class_model VALUES ('568', '36', 'Orion', 'german');
INSERT INTO class_model VALUES ('569', '36', 'Probe', 'ro');
INSERT INTO class_model VALUES ('569', '36', 'Probe', 'eng');
INSERT INTO class_model VALUES ('569', '36', 'Probe', 'german');
INSERT INTO class_model VALUES ('570', '36', 'Puma', 'ro');
INSERT INTO class_model VALUES ('570', '36', 'Puma', 'eng');
INSERT INTO class_model VALUES ('570', '36', 'Puma', 'german');
INSERT INTO class_model VALUES ('571', '36', 'Ranchero', 'ro');
INSERT INTO class_model VALUES ('571', '36', 'Ranchero', 'eng');
INSERT INTO class_model VALUES ('571', '36', 'Ranchero', 'german');
INSERT INTO class_model VALUES ('572', '36', 'Ranger', 'ro');
INSERT INTO class_model VALUES ('572', '36', 'Ranger', 'eng');
INSERT INTO class_model VALUES ('572', '36', 'Ranger', 'german');
INSERT INTO class_model VALUES ('573', '36', 'S-MAX', 'ro');
INSERT INTO class_model VALUES ('573', '36', 'S-MAX', 'eng');
INSERT INTO class_model VALUES ('573', '36', 'S-MAX', 'german');
INSERT INTO class_model VALUES ('574', '36', 'Scorpio', 'ro');
INSERT INTO class_model VALUES ('574', '36', 'Scorpio', 'eng');
INSERT INTO class_model VALUES ('574', '36', 'Scorpio', 'german');
INSERT INTO class_model VALUES ('575', '36', 'Sierra', 'ro');
INSERT INTO class_model VALUES ('575', '36', 'Sierra', 'eng');
INSERT INTO class_model VALUES ('575', '36', 'Sierra', 'german');
INSERT INTO class_model VALUES ('576', '36', 'StreetKa', 'ro');
INSERT INTO class_model VALUES ('576', '36', 'StreetKa', 'eng');
INSERT INTO class_model VALUES ('576', '36', 'StreetKa', 'german');
INSERT INTO class_model VALUES ('577', '36', 'Taunus', 'ro');
INSERT INTO class_model VALUES ('577', '36', 'Taunus', 'eng');
INSERT INTO class_model VALUES ('577', '36', 'Taunus', 'german');
INSERT INTO class_model VALUES ('578', '36', 'Taurus', 'ro');
INSERT INTO class_model VALUES ('578', '36', 'Taurus', 'eng');
INSERT INTO class_model VALUES ('578', '36', 'Taurus', 'german');
INSERT INTO class_model VALUES ('579', '36', 'Tempo', 'ro');
INSERT INTO class_model VALUES ('579', '36', 'Tempo', 'eng');
INSERT INTO class_model VALUES ('579', '36', 'Tempo', 'german');
INSERT INTO class_model VALUES ('580', '36', 'Thunderbird', 'ro');
INSERT INTO class_model VALUES ('580', '36', 'Thunderbird', 'eng');
INSERT INTO class_model VALUES ('580', '36', 'Thunderbird', 'german');
INSERT INTO class_model VALUES ('581', '36', 'Tourneo', 'ro');
INSERT INTO class_model VALUES ('581', '36', 'Tourneo', 'eng');
INSERT INTO class_model VALUES ('581', '36', 'Tourneo', 'german');
INSERT INTO class_model VALUES ('582', '36', 'Transit', 'ro');
INSERT INTO class_model VALUES ('582', '36', 'Transit', 'eng');
INSERT INTO class_model VALUES ('582', '36', 'Transit', 'german');
INSERT INTO class_model VALUES ('583', '36', 'Transit Connect', 'ro');
INSERT INTO class_model VALUES ('583', '36', 'Transit Connect', 'eng');
INSERT INTO class_model VALUES ('583', '36', 'Transit Connect', 'german');
INSERT INTO class_model VALUES ('584', '36', 'Windstar', 'ro');
INSERT INTO class_model VALUES ('584', '36', 'Windstar', 'eng');
INSERT INTO class_model VALUES ('584', '36', 'Windstar', 'german');
INSERT INTO class_model VALUES ('585', '36', 'Tourneo Connect', 'ro');
INSERT INTO class_model VALUES ('585', '36', 'Tourneo Connect', 'eng');
INSERT INTO class_model VALUES ('585', '36', 'Tourneo Connect', 'german');
INSERT INTO class_model VALUES ('586', '37', 'Super Exceed', 'ro');
INSERT INTO class_model VALUES ('586', '37', 'Super Exceed', 'eng');
INSERT INTO class_model VALUES ('586', '37', 'Super Exceed', 'german');
INSERT INTO class_model VALUES ('587', '38', '67', 'ro');
INSERT INTO class_model VALUES ('587', '38', '67', 'eng');
INSERT INTO class_model VALUES ('587', '38', '67', 'german');
INSERT INTO class_model VALUES ('588', '38', '69', 'ro');
INSERT INTO class_model VALUES ('588', '38', '69', 'eng');
INSERT INTO class_model VALUES ('588', '38', '69', 'german');
INSERT INTO class_model VALUES ('589', '39', 'Ck', 'ro');
INSERT INTO class_model VALUES ('589', '39', 'Ck', 'eng');
INSERT INTO class_model VALUES ('589', '39', 'Ck', 'german');
INSERT INTO class_model VALUES ('590', '40', 'Acadia', 'ro');
INSERT INTO class_model VALUES ('590', '40', 'Acadia', 'eng');
INSERT INTO class_model VALUES ('590', '40', 'Acadia', 'german');
INSERT INTO class_model VALUES ('591', '40', 'Envoy', 'ro');
INSERT INTO class_model VALUES ('591', '40', 'Envoy', 'eng');
INSERT INTO class_model VALUES ('591', '40', 'Envoy', 'german');
INSERT INTO class_model VALUES ('592', '40', 'Safari', 'ro');
INSERT INTO class_model VALUES ('592', '40', 'Safari', 'eng');
INSERT INTO class_model VALUES ('592', '40', 'Safari', 'german');
INSERT INTO class_model VALUES ('593', '40', 'Savana', 'ro');
INSERT INTO class_model VALUES ('593', '40', 'Savana', 'eng');
INSERT INTO class_model VALUES ('593', '40', 'Savana', 'german');
INSERT INTO class_model VALUES ('594', '40', 'Sierra', 'ro');
INSERT INTO class_model VALUES ('594', '40', 'Sierra', 'eng');
INSERT INTO class_model VALUES ('594', '40', 'Sierra', 'german');
INSERT INTO class_model VALUES ('595', '40', 'Sonoma', 'ro');
INSERT INTO class_model VALUES ('595', '40', 'Sonoma', 'eng');
INSERT INTO class_model VALUES ('595', '40', 'Sonoma', 'german');
INSERT INTO class_model VALUES ('596', '40', 'Syclone', 'ro');
INSERT INTO class_model VALUES ('596', '40', 'Syclone', 'eng');
INSERT INTO class_model VALUES ('596', '40', 'Syclone', 'german');
INSERT INTO class_model VALUES ('597', '40', 'Typhoon', 'ro');
INSERT INTO class_model VALUES ('597', '40', 'Typhoon', 'eng');
INSERT INTO class_model VALUES ('597', '40', 'Typhoon', 'german');
INSERT INTO class_model VALUES ('598', '40', 'Vandura', 'ro');
INSERT INTO class_model VALUES ('598', '40', 'Vandura', 'eng');
INSERT INTO class_model VALUES ('598', '40', 'Vandura', 'german');
INSERT INTO class_model VALUES ('599', '40', 'Yukon', 'ro');
INSERT INTO class_model VALUES ('599', '40', 'Yukon', 'eng');
INSERT INTO class_model VALUES ('599', '40', 'Yukon', 'german');
INSERT INTO class_model VALUES ('600', '42', 'Sonique', 'ro');
INSERT INTO class_model VALUES ('600', '42', 'Sonique', 'eng');
INSERT INTO class_model VALUES ('600', '42', 'Sonique', 'german');
INSERT INTO class_model VALUES ('601', '43', 'Cowry', 'ro');
INSERT INTO class_model VALUES ('601', '43', 'Cowry', 'eng');
INSERT INTO class_model VALUES ('601', '43', 'Cowry', 'german');
INSERT INTO class_model VALUES ('602', '43', 'Haval H5', 'ro');
INSERT INTO class_model VALUES ('602', '43', 'Haval H5', 'eng');
INSERT INTO class_model VALUES ('602', '43', 'Haval H5', 'german');
INSERT INTO class_model VALUES ('603', '43', 'Hover', 'ro');
INSERT INTO class_model VALUES ('603', '43', 'Hover', 'eng');
INSERT INTO class_model VALUES ('603', '43', 'Hover', 'german');
INSERT INTO class_model VALUES ('604', '43', 'Steed', 'ro');
INSERT INTO class_model VALUES ('604', '43', 'Steed', 'eng');
INSERT INTO class_model VALUES ('604', '43', 'Steed', 'german');
INSERT INTO class_model VALUES ('605', '43', 'Voleex', 'ro');
INSERT INTO class_model VALUES ('605', '43', 'Voleex', 'eng');
INSERT INTO class_model VALUES ('605', '43', 'Voleex', 'german');
INSERT INTO class_model VALUES ('606', '44', 'Adventra', 'ro');
INSERT INTO class_model VALUES ('606', '44', 'Adventra', 'eng');
INSERT INTO class_model VALUES ('606', '44', 'Adventra', 'german');
INSERT INTO class_model VALUES ('607', '44', 'Astra', 'ro');
INSERT INTO class_model VALUES ('607', '44', 'Astra', 'eng');
INSERT INTO class_model VALUES ('607', '44', 'Astra', 'german');
INSERT INTO class_model VALUES ('608', '44', 'Baria', 'ro');
INSERT INTO class_model VALUES ('608', '44', 'Baria', 'eng');
INSERT INTO class_model VALUES ('608', '44', 'Baria', 'german');
INSERT INTO class_model VALUES ('609', '44', 'Berlina', 'ro');
INSERT INTO class_model VALUES ('609', '44', 'Berlina', 'eng');
INSERT INTO class_model VALUES ('609', '44', 'Berlina', 'german');
INSERT INTO class_model VALUES ('610', '44', 'Calais', 'ro');
INSERT INTO class_model VALUES ('610', '44', 'Calais', 'eng');
INSERT INTO class_model VALUES ('610', '44', 'Calais', 'german');
INSERT INTO class_model VALUES ('611', '44', 'Caprice', 'ro');
INSERT INTO class_model VALUES ('611', '44', 'Caprice', 'eng');
INSERT INTO class_model VALUES ('611', '44', 'Caprice', 'german');
INSERT INTO class_model VALUES ('612', '44', 'Captiva', 'ro');
INSERT INTO class_model VALUES ('612', '44', 'Captiva', 'eng');
INSERT INTO class_model VALUES ('612', '44', 'Captiva', 'german');
INSERT INTO class_model VALUES ('613', '44', 'Colorado', 'ro');
INSERT INTO class_model VALUES ('613', '44', 'Colorado', 'eng');
INSERT INTO class_model VALUES ('613', '44', 'Colorado', 'german');
INSERT INTO class_model VALUES ('614', '44', 'Commodore', 'ro');
INSERT INTO class_model VALUES ('614', '44', 'Commodore', 'eng');
INSERT INTO class_model VALUES ('614', '44', 'Commodore', 'german');
INSERT INTO class_model VALUES ('615', '44', 'Crewman', 'ro');
INSERT INTO class_model VALUES ('615', '44', 'Crewman', 'eng');
INSERT INTO class_model VALUES ('615', '44', 'Crewman', 'german');
INSERT INTO class_model VALUES ('616', '44', 'Cruze', 'ro');
INSERT INTO class_model VALUES ('616', '44', 'Cruze', 'eng');
INSERT INTO class_model VALUES ('616', '44', 'Cruze', 'german');
INSERT INTO class_model VALUES ('617', '44', 'Epica', 'ro');
INSERT INTO class_model VALUES ('617', '44', 'Epica', 'eng');
INSERT INTO class_model VALUES ('617', '44', 'Epica', 'german');
INSERT INTO class_model VALUES ('618', '44', 'Jackaroo', 'ro');
INSERT INTO class_model VALUES ('618', '44', 'Jackaroo', 'eng');
INSERT INTO class_model VALUES ('618', '44', 'Jackaroo', 'german');
INSERT INTO class_model VALUES ('619', '44', 'Statesman', 'ro');
INSERT INTO class_model VALUES ('619', '44', 'Statesman', 'eng');
INSERT INTO class_model VALUES ('619', '44', 'Statesman', 'german');
INSERT INTO class_model VALUES ('620', '44', 'Ute', 'ro');
INSERT INTO class_model VALUES ('620', '44', 'Ute', 'eng');
INSERT INTO class_model VALUES ('620', '44', 'Ute', 'german');
INSERT INTO class_model VALUES ('621', '44', 'Viva', 'ro');
INSERT INTO class_model VALUES ('621', '44', 'Viva', 'eng');
INSERT INTO class_model VALUES ('621', '44', 'Viva', 'german');
INSERT INTO class_model VALUES ('622', '45', 'Accord', 'ro');
INSERT INTO class_model VALUES ('622', '45', 'Accord', 'eng');
INSERT INTO class_model VALUES ('622', '45', 'Accord', 'german');
INSERT INTO class_model VALUES ('623', '45', 'Aerodeck', 'ro');
INSERT INTO class_model VALUES ('623', '45', 'Aerodeck', 'eng');
INSERT INTO class_model VALUES ('623', '45', 'Aerodeck', 'german');
INSERT INTO class_model VALUES ('624', '45', 'CR-V', 'ro');
INSERT INTO class_model VALUES ('624', '45', 'CR-V', 'eng');
INSERT INTO class_model VALUES ('624', '45', 'CR-V', 'german');
INSERT INTO class_model VALUES ('625', '45', 'CR-Z', 'ro');
INSERT INTO class_model VALUES ('625', '45', 'CR-Z', 'eng');
INSERT INTO class_model VALUES ('625', '45', 'CR-Z', 'german');
INSERT INTO class_model VALUES ('626', '45', 'CRX', 'ro');
INSERT INTO class_model VALUES ('626', '45', 'CRX', 'eng');
INSERT INTO class_model VALUES ('626', '45', 'CRX', 'german');
INSERT INTO class_model VALUES ('627', '45', 'City', 'ro');
INSERT INTO class_model VALUES ('627', '45', 'City', 'eng');
INSERT INTO class_model VALUES ('627', '45', 'City', 'german');
INSERT INTO class_model VALUES ('628', '45', 'Civic', 'ro');
INSERT INTO class_model VALUES ('628', '45', 'Civic', 'eng');
INSERT INTO class_model VALUES ('628', '45', 'Civic', 'german');
INSERT INTO class_model VALUES ('629', '45', 'Concerto', 'ro');
INSERT INTO class_model VALUES ('629', '45', 'Concerto', 'eng');
INSERT INTO class_model VALUES ('629', '45', 'Concerto', 'german');
INSERT INTO class_model VALUES ('630', '45', 'Element', 'ro');
INSERT INTO class_model VALUES ('630', '45', 'Element', 'eng');
INSERT INTO class_model VALUES ('630', '45', 'Element', 'german');
INSERT INTO class_model VALUES ('631', '45', 'FR-V', 'ro');
INSERT INTO class_model VALUES ('631', '45', 'FR-V', 'eng');
INSERT INTO class_model VALUES ('631', '45', 'FR-V', 'german');
INSERT INTO class_model VALUES ('632', '45', 'HR-V', 'ro');
INSERT INTO class_model VALUES ('632', '45', 'HR-V', 'eng');
INSERT INTO class_model VALUES ('632', '45', 'HR-V', 'german');
INSERT INTO class_model VALUES ('633', '45', 'Insight', 'ro');
INSERT INTO class_model VALUES ('633', '45', 'Insight', 'eng');
INSERT INTO class_model VALUES ('633', '45', 'Insight', 'german');
INSERT INTO class_model VALUES ('634', '45', 'Integra', 'ro');
INSERT INTO class_model VALUES ('634', '45', 'Integra', 'eng');
INSERT INTO class_model VALUES ('634', '45', 'Integra', 'german');
INSERT INTO class_model VALUES ('635', '45', 'Jazz', 'ro');
INSERT INTO class_model VALUES ('635', '45', 'Jazz', 'eng');
INSERT INTO class_model VALUES ('635', '45', 'Jazz', 'german');
INSERT INTO class_model VALUES ('636', '45', 'Legend', 'ro');
INSERT INTO class_model VALUES ('636', '45', 'Legend', 'eng');
INSERT INTO class_model VALUES ('636', '45', 'Legend', 'german');
INSERT INTO class_model VALUES ('637', '45', 'Logo', 'ro');
INSERT INTO class_model VALUES ('637', '45', 'Logo', 'eng');
INSERT INTO class_model VALUES ('637', '45', 'Logo', 'german');
INSERT INTO class_model VALUES ('638', '45', 'NSX', 'ro');
INSERT INTO class_model VALUES ('638', '45', 'NSX', 'eng');
INSERT INTO class_model VALUES ('638', '45', 'NSX', 'german');
INSERT INTO class_model VALUES ('639', '45', 'Odyssey', 'ro');
INSERT INTO class_model VALUES ('639', '45', 'Odyssey', 'eng');
INSERT INTO class_model VALUES ('639', '45', 'Odyssey', 'german');
INSERT INTO class_model VALUES ('640', '45', 'Pilot', 'ro');
INSERT INTO class_model VALUES ('640', '45', 'Pilot', 'eng');
INSERT INTO class_model VALUES ('640', '45', 'Pilot', 'german');
INSERT INTO class_model VALUES ('641', '45', 'Prelude', 'ro');
INSERT INTO class_model VALUES ('641', '45', 'Prelude', 'eng');
INSERT INTO class_model VALUES ('641', '45', 'Prelude', 'german');
INSERT INTO class_model VALUES ('642', '45', 'Ridgeline', 'ro');
INSERT INTO class_model VALUES ('642', '45', 'Ridgeline', 'eng');
INSERT INTO class_model VALUES ('642', '45', 'Ridgeline', 'german');
INSERT INTO class_model VALUES ('643', '45', 'S 2000', 'ro');
INSERT INTO class_model VALUES ('643', '45', 'S 2000', 'eng');
INSERT INTO class_model VALUES ('643', '45', 'S 2000', 'german');
INSERT INTO class_model VALUES ('644', '45', 'Shuttle', 'ro');
INSERT INTO class_model VALUES ('644', '45', 'Shuttle', 'eng');
INSERT INTO class_model VALUES ('644', '45', 'Shuttle', 'german');
INSERT INTO class_model VALUES ('645', '45', 'Stream', 'ro');
INSERT INTO class_model VALUES ('645', '45', 'Stream', 'eng');
INSERT INTO class_model VALUES ('645', '45', 'Stream', 'german');
INSERT INTO class_model VALUES ('646', '46', 'H1', 'ro');
INSERT INTO class_model VALUES ('646', '46', 'H1', 'eng');
INSERT INTO class_model VALUES ('646', '46', 'H1', 'german');
INSERT INTO class_model VALUES ('647', '46', 'H2', 'ro');
INSERT INTO class_model VALUES ('647', '46', 'H2', 'eng');
INSERT INTO class_model VALUES ('647', '46', 'H2', 'german');
INSERT INTO class_model VALUES ('648', '46', 'H3', 'ro');
INSERT INTO class_model VALUES ('648', '46', 'H3', 'eng');
INSERT INTO class_model VALUES ('648', '46', 'H3', 'german');
INSERT INTO class_model VALUES ('649', '47', 'Accent', 'ro');
INSERT INTO class_model VALUES ('649', '47', 'Accent', 'eng');
INSERT INTO class_model VALUES ('649', '47', 'Accent', 'german');
INSERT INTO class_model VALUES ('650', '47', 'Atos', 'ro');
INSERT INTO class_model VALUES ('650', '47', 'Atos', 'eng');
INSERT INTO class_model VALUES ('650', '47', 'Atos', 'german');
INSERT INTO class_model VALUES ('651', '47', 'Avante', 'ro');
INSERT INTO class_model VALUES ('651', '47', 'Avante', 'eng');
INSERT INTO class_model VALUES ('651', '47', 'Avante', 'german');
INSERT INTO class_model VALUES ('652', '47', 'Azera', 'ro');
INSERT INTO class_model VALUES ('652', '47', 'Azera', 'eng');
INSERT INTO class_model VALUES ('652', '47', 'Azera', 'german');
INSERT INTO class_model VALUES ('653', '47', 'Coupe', 'ro');
INSERT INTO class_model VALUES ('653', '47', 'Coupe', 'eng');
INSERT INTO class_model VALUES ('653', '47', 'Coupe', 'german');
INSERT INTO class_model VALUES ('654', '47', 'Elantra', 'ro');
INSERT INTO class_model VALUES ('654', '47', 'Elantra', 'eng');
INSERT INTO class_model VALUES ('654', '47', 'Elantra', 'german');
INSERT INTO class_model VALUES ('655', '47', 'Equus', 'ro');
INSERT INTO class_model VALUES ('655', '47', 'Equus', 'eng');
INSERT INTO class_model VALUES ('655', '47', 'Equus', 'german');
INSERT INTO class_model VALUES ('656', '47', 'Excel', 'ro');
INSERT INTO class_model VALUES ('656', '47', 'Excel', 'eng');
INSERT INTO class_model VALUES ('656', '47', 'Excel', 'german');
INSERT INTO class_model VALUES ('657', '47', 'Galloper', 'ro');
INSERT INTO class_model VALUES ('657', '47', 'Galloper', 'eng');
INSERT INTO class_model VALUES ('657', '47', 'Galloper', 'german');
INSERT INTO class_model VALUES ('658', '47', 'Genesis', 'ro');
INSERT INTO class_model VALUES ('658', '47', 'Genesis', 'eng');
INSERT INTO class_model VALUES ('658', '47', 'Genesis', 'german');
INSERT INTO class_model VALUES ('659', '47', 'Genesis Coupe', 'ro');
INSERT INTO class_model VALUES ('659', '47', 'Genesis Coupe', 'eng');
INSERT INTO class_model VALUES ('659', '47', 'Genesis Coupe', 'german');
INSERT INTO class_model VALUES ('660', '47', 'Getz', 'ro');
INSERT INTO class_model VALUES ('660', '47', 'Getz', 'eng');
INSERT INTO class_model VALUES ('660', '47', 'Getz', 'german');
INSERT INTO class_model VALUES ('661', '47', 'Grandeur', 'ro');
INSERT INTO class_model VALUES ('661', '47', 'Grandeur', 'eng');
INSERT INTO class_model VALUES ('661', '47', 'Grandeur', 'german');
INSERT INTO class_model VALUES ('662', '47', 'H-1', 'ro');
INSERT INTO class_model VALUES ('662', '47', 'H-1', 'eng');
INSERT INTO class_model VALUES ('662', '47', 'H-1', 'german');
INSERT INTO class_model VALUES ('663', '47', 'H-1 Starex', 'ro');
INSERT INTO class_model VALUES ('663', '47', 'H-1 Starex', 'eng');
INSERT INTO class_model VALUES ('663', '47', 'H-1 Starex', 'german');
INSERT INTO class_model VALUES ('664', '47', 'H200', 'ro');
INSERT INTO class_model VALUES ('664', '47', 'H200', 'eng');
INSERT INTO class_model VALUES ('664', '47', 'H200', 'german');
INSERT INTO class_model VALUES ('665', '47', 'Lantra', 'ro');
INSERT INTO class_model VALUES ('665', '47', 'Lantra', 'eng');
INSERT INTO class_model VALUES ('665', '47', 'Lantra', 'german');
INSERT INTO class_model VALUES ('666', '47', 'Matrix', 'ro');
INSERT INTO class_model VALUES ('666', '47', 'Matrix', 'eng');
INSERT INTO class_model VALUES ('666', '47', 'Matrix', 'german');
INSERT INTO class_model VALUES ('667', '47', 'Pony', 'ro');
INSERT INTO class_model VALUES ('667', '47', 'Pony', 'eng');
INSERT INTO class_model VALUES ('667', '47', 'Pony', 'german');
INSERT INTO class_model VALUES ('668', '47', 'S-Coupe', 'ro');
INSERT INTO class_model VALUES ('668', '47', 'S-Coupe', 'eng');
INSERT INTO class_model VALUES ('668', '47', 'S-Coupe', 'german');
INSERT INTO class_model VALUES ('669', '47', 'Santa Fe', 'ro');
INSERT INTO class_model VALUES ('669', '47', 'Santa Fe', 'eng');
INSERT INTO class_model VALUES ('669', '47', 'Santa Fe', 'german');
INSERT INTO class_model VALUES ('670', '47', 'Santamo', 'ro');
INSERT INTO class_model VALUES ('670', '47', 'Santamo', 'eng');
INSERT INTO class_model VALUES ('670', '47', 'Santamo', 'german');
INSERT INTO class_model VALUES ('671', '47', 'Sonata', 'ro');
INSERT INTO class_model VALUES ('671', '47', 'Sonata', 'eng');
INSERT INTO class_model VALUES ('671', '47', 'Sonata', 'german');
INSERT INTO class_model VALUES ('672', '47', 'Sonica', 'ro');
INSERT INTO class_model VALUES ('672', '47', 'Sonica', 'eng');
INSERT INTO class_model VALUES ('672', '47', 'Sonica', 'german');
INSERT INTO class_model VALUES ('673', '47', 'Terracan', 'ro');
INSERT INTO class_model VALUES ('673', '47', 'Terracan', 'eng');
INSERT INTO class_model VALUES ('673', '47', 'Terracan', 'german');
INSERT INTO class_model VALUES ('674', '47', 'Trajet', 'ro');
INSERT INTO class_model VALUES ('674', '47', 'Trajet', 'eng');
INSERT INTO class_model VALUES ('674', '47', 'Trajet', 'german');
INSERT INTO class_model VALUES ('675', '47', 'Tucson', 'ro');
INSERT INTO class_model VALUES ('675', '47', 'Tucson', 'eng');
INSERT INTO class_model VALUES ('675', '47', 'Tucson', 'german');
INSERT INTO class_model VALUES ('676', '47', 'Veloster', 'ro');
INSERT INTO class_model VALUES ('676', '47', 'Veloster', 'eng');
INSERT INTO class_model VALUES ('676', '47', 'Veloster', 'german');
INSERT INTO class_model VALUES ('677', '47', 'Veracruz', 'ro');
INSERT INTO class_model VALUES ('677', '47', 'Veracruz', 'eng');
INSERT INTO class_model VALUES ('677', '47', 'Veracruz', 'german');
INSERT INTO class_model VALUES ('678', '47', 'XG 30', 'ro');
INSERT INTO class_model VALUES ('678', '47', 'XG 30', 'eng');
INSERT INTO class_model VALUES ('678', '47', 'XG 30', 'german');
INSERT INTO class_model VALUES ('679', '47', 'XG 350', 'ro');
INSERT INTO class_model VALUES ('679', '47', 'XG 350', 'eng');
INSERT INTO class_model VALUES ('679', '47', 'XG 350', 'german');
INSERT INTO class_model VALUES ('680', '47', 'i10', 'ro');
INSERT INTO class_model VALUES ('680', '47', 'i10', 'eng');
INSERT INTO class_model VALUES ('680', '47', 'i10', 'german');
INSERT INTO class_model VALUES ('681', '47', 'i20', 'ro');
INSERT INTO class_model VALUES ('681', '47', 'i20', 'eng');
INSERT INTO class_model VALUES ('681', '47', 'i20', 'german');
INSERT INTO class_model VALUES ('682', '47', 'i25', 'ro');
INSERT INTO class_model VALUES ('682', '47', 'i25', 'eng');
INSERT INTO class_model VALUES ('682', '47', 'i25', 'german');
INSERT INTO class_model VALUES ('683', '47', 'i30', 'ro');
INSERT INTO class_model VALUES ('683', '47', 'i30', 'eng');
INSERT INTO class_model VALUES ('683', '47', 'i30', 'german');
INSERT INTO class_model VALUES ('684', '47', 'i40', 'ro');
INSERT INTO class_model VALUES ('684', '47', 'i40', 'eng');
INSERT INTO class_model VALUES ('684', '47', 'i40', 'german');
INSERT INTO class_model VALUES ('685', '47', 'ix20', 'ro');
INSERT INTO class_model VALUES ('685', '47', 'ix20', 'eng');
INSERT INTO class_model VALUES ('685', '47', 'ix20', 'german');
INSERT INTO class_model VALUES ('686', '47', 'ix35', 'ro');
INSERT INTO class_model VALUES ('686', '47', 'ix35', 'eng');
INSERT INTO class_model VALUES ('686', '47', 'ix35', 'german');
INSERT INTO class_model VALUES ('687', '47', 'ix55', 'ro');
INSERT INTO class_model VALUES ('687', '47', 'ix55', 'eng');
INSERT INTO class_model VALUES ('687', '47', 'ix55', 'german');
INSERT INTO class_model VALUES ('688', '48', 'EX', 'ro');
INSERT INTO class_model VALUES ('688', '48', 'EX', 'eng');
INSERT INTO class_model VALUES ('688', '48', 'EX', 'german');
INSERT INTO class_model VALUES ('689', '48', 'EX 30d', 'ro');
INSERT INTO class_model VALUES ('689', '48', 'EX 30d', 'eng');
INSERT INTO class_model VALUES ('689', '48', 'EX 30d', 'german');
INSERT INTO class_model VALUES ('690', '48', 'EX 35', 'ro');
INSERT INTO class_model VALUES ('690', '48', 'EX 35', 'eng');
INSERT INTO class_model VALUES ('690', '48', 'EX 35', 'german');
INSERT INTO class_model VALUES ('691', '48', 'EX 37', 'ro');
INSERT INTO class_model VALUES ('691', '48', 'EX 37', 'eng');
INSERT INTO class_model VALUES ('691', '48', 'EX 37', 'german');
INSERT INTO class_model VALUES ('692', '48', 'FX', 'ro');
INSERT INTO class_model VALUES ('692', '48', 'FX', 'eng');
INSERT INTO class_model VALUES ('692', '48', 'FX', 'german');
INSERT INTO class_model VALUES ('693', '48', 'FX 35', 'ro');
INSERT INTO class_model VALUES ('693', '48', 'FX 35', 'eng');
INSERT INTO class_model VALUES ('693', '48', 'FX 35', 'german');
INSERT INTO class_model VALUES ('694', '48', 'FX 37', 'ro');
INSERT INTO class_model VALUES ('694', '48', 'FX 37', 'eng');
INSERT INTO class_model VALUES ('694', '48', 'FX 37', 'german');
INSERT INTO class_model VALUES ('695', '48', 'FX 45', 'ro');
INSERT INTO class_model VALUES ('695', '48', 'FX 45', 'eng');
INSERT INTO class_model VALUES ('695', '48', 'FX 45', 'german');
INSERT INTO class_model VALUES ('696', '48', 'FX 50', 'ro');
INSERT INTO class_model VALUES ('696', '48', 'FX 50', 'eng');
INSERT INTO class_model VALUES ('696', '48', 'FX 50', 'german');
INSERT INTO class_model VALUES ('697', '48', 'FX30d', 'ro');
INSERT INTO class_model VALUES ('697', '48', 'FX30d', 'eng');
INSERT INTO class_model VALUES ('697', '48', 'FX30d', 'german');
INSERT INTO class_model VALUES ('698', '48', 'G', 'ro');
INSERT INTO class_model VALUES ('698', '48', 'G', 'eng');
INSERT INTO class_model VALUES ('698', '48', 'G', 'german');
INSERT INTO class_model VALUES ('699', '48', 'G20', 'ro');
INSERT INTO class_model VALUES ('699', '48', 'G20', 'eng');
INSERT INTO class_model VALUES ('699', '48', 'G20', 'german');
INSERT INTO class_model VALUES ('700', '48', 'G35', 'ro');
INSERT INTO class_model VALUES ('700', '48', 'G35', 'eng');
INSERT INTO class_model VALUES ('700', '48', 'G35', 'german');
INSERT INTO class_model VALUES ('701', '48', 'G37', 'ro');
INSERT INTO class_model VALUES ('701', '48', 'G37', 'eng');
INSERT INTO class_model VALUES ('701', '48', 'G37', 'german');
INSERT INTO class_model VALUES ('702', '48', 'I30', 'ro');
INSERT INTO class_model VALUES ('702', '48', 'I30', 'eng');
INSERT INTO class_model VALUES ('702', '48', 'I30', 'german');
INSERT INTO class_model VALUES ('703', '48', 'I35', 'ro');
INSERT INTO class_model VALUES ('703', '48', 'I35', 'eng');
INSERT INTO class_model VALUES ('703', '48', 'I35', 'german');
INSERT INTO class_model VALUES ('704', '48', 'J30', 'ro');
INSERT INTO class_model VALUES ('704', '48', 'J30', 'eng');
INSERT INTO class_model VALUES ('704', '48', 'J30', 'german');
INSERT INTO class_model VALUES ('705', '48', 'M', 'ro');
INSERT INTO class_model VALUES ('705', '48', 'M', 'eng');
INSERT INTO class_model VALUES ('705', '48', 'M', 'german');
INSERT INTO class_model VALUES ('706', '48', 'M30d', 'ro');
INSERT INTO class_model VALUES ('706', '48', 'M30d', 'eng');
INSERT INTO class_model VALUES ('706', '48', 'M30d', 'german');
INSERT INTO class_model VALUES ('707', '48', 'M35', 'ro');
INSERT INTO class_model VALUES ('707', '48', 'M35', 'eng');
INSERT INTO class_model VALUES ('707', '48', 'M35', 'german');
INSERT INTO class_model VALUES ('708', '48', 'M35h', 'ro');
INSERT INTO class_model VALUES ('708', '48', 'M35h', 'eng');
INSERT INTO class_model VALUES ('708', '48', 'M35h', 'german');
INSERT INTO class_model VALUES ('709', '48', 'M37', 'ro');
INSERT INTO class_model VALUES ('709', '48', 'M37', 'eng');
INSERT INTO class_model VALUES ('709', '48', 'M37', 'german');
INSERT INTO class_model VALUES ('710', '48', 'M45', 'ro');
INSERT INTO class_model VALUES ('710', '48', 'M45', 'eng');
INSERT INTO class_model VALUES ('710', '48', 'M45', 'german');
INSERT INTO class_model VALUES ('711', '48', 'Q45', 'ro');
INSERT INTO class_model VALUES ('711', '48', 'Q45', 'eng');
INSERT INTO class_model VALUES ('711', '48', 'Q45', 'german');
INSERT INTO class_model VALUES ('712', '48', 'QX56', 'ro');
INSERT INTO class_model VALUES ('712', '48', 'QX56', 'eng');
INSERT INTO class_model VALUES ('712', '48', 'QX56', 'german');
INSERT INTO class_model VALUES ('713', '49', 'Campo', 'ro');
INSERT INTO class_model VALUES ('713', '49', 'Campo', 'eng');
INSERT INTO class_model VALUES ('713', '49', 'Campo', 'german');
INSERT INTO class_model VALUES ('714', '49', 'D-Max', 'ro');
INSERT INTO class_model VALUES ('714', '49', 'D-Max', 'eng');
INSERT INTO class_model VALUES ('714', '49', 'D-Max', 'german');
INSERT INTO class_model VALUES ('715', '49', 'Gemini', 'ro');
INSERT INTO class_model VALUES ('715', '49', 'Gemini', 'eng');
INSERT INTO class_model VALUES ('715', '49', 'Gemini', 'german');
INSERT INTO class_model VALUES ('716', '49', 'Midi', 'ro');
INSERT INTO class_model VALUES ('716', '49', 'Midi', 'eng');
INSERT INTO class_model VALUES ('716', '49', 'Midi', 'german');
INSERT INTO class_model VALUES ('717', '49', 'Pick Up', 'ro');
INSERT INTO class_model VALUES ('717', '49', 'Pick Up', 'eng');
INSERT INTO class_model VALUES ('717', '49', 'Pick Up', 'german');
INSERT INTO class_model VALUES ('718', '49', 'Trooper', 'ro');
INSERT INTO class_model VALUES ('718', '49', 'Trooper', 'eng');
INSERT INTO class_model VALUES ('718', '49', 'Trooper', 'german');
INSERT INTO class_model VALUES ('719', '50', 'Massif', 'ro');
INSERT INTO class_model VALUES ('719', '50', 'Massif', 'eng');
INSERT INTO class_model VALUES ('719', '50', 'Massif', 'german');
INSERT INTO class_model VALUES ('720', '51', 'Daimler', 'ro');
INSERT INTO class_model VALUES ('720', '51', 'Daimler', 'eng');
INSERT INTO class_model VALUES ('720', '51', 'Daimler', 'german');
INSERT INTO class_model VALUES ('721', '51', 'E-Type', 'ro');
INSERT INTO class_model VALUES ('721', '51', 'E-Type', 'eng');
INSERT INTO class_model VALUES ('721', '51', 'E-Type', 'german');
INSERT INTO class_model VALUES ('722', '51', 'F-Type', 'ro');
INSERT INTO class_model VALUES ('722', '51', 'F-Type', 'eng');
INSERT INTO class_model VALUES ('722', '51', 'F-Type', 'german');
INSERT INTO class_model VALUES ('723', '51', 'F-Pace', 'ro');
INSERT INTO class_model VALUES ('723', '51', 'F-Pace', 'eng');
INSERT INTO class_model VALUES ('723', '51', 'F-Pace', 'german');
INSERT INTO class_model VALUES ('724', '51', 'MK II', 'ro');
INSERT INTO class_model VALUES ('724', '51', 'MK II', 'eng');
INSERT INTO class_model VALUES ('724', '51', 'MK II', 'german');
INSERT INTO class_model VALUES ('725', '51', 'S-Type', 'ro');
INSERT INTO class_model VALUES ('725', '51', 'S-Type', 'eng');
INSERT INTO class_model VALUES ('725', '51', 'S-Type', 'german');
INSERT INTO class_model VALUES ('726', '51', 'S-Type R', 'ro');
INSERT INTO class_model VALUES ('726', '51', 'S-Type R', 'eng');
INSERT INTO class_model VALUES ('726', '51', 'S-Type R', 'german');
INSERT INTO class_model VALUES ('727', '51', 'X-Type', 'ro');
INSERT INTO class_model VALUES ('727', '51', 'X-Type', 'eng');
INSERT INTO class_model VALUES ('727', '51', 'X-Type', 'german');
INSERT INTO class_model VALUES ('728', '51', 'XF', 'ro');
INSERT INTO class_model VALUES ('728', '51', 'XF', 'eng');
INSERT INTO class_model VALUES ('728', '51', 'XF', 'german');
INSERT INTO class_model VALUES ('729', '51', 'XJ', 'ro');
INSERT INTO class_model VALUES ('729', '51', 'XJ', 'eng');
INSERT INTO class_model VALUES ('729', '51', 'XJ', 'german');
INSERT INTO class_model VALUES ('730', '51', 'XJ12', 'ro');
INSERT INTO class_model VALUES ('730', '51', 'XJ12', 'eng');
INSERT INTO class_model VALUES ('730', '51', 'XJ12', 'german');
INSERT INTO class_model VALUES ('731', '51', 'XJ40', 'ro');
INSERT INTO class_model VALUES ('731', '51', 'XJ40', 'eng');
INSERT INTO class_model VALUES ('731', '51', 'XJ40', 'german');
INSERT INTO class_model VALUES ('732', '51', 'XJ6', 'ro');
INSERT INTO class_model VALUES ('732', '51', 'XJ6', 'eng');
INSERT INTO class_model VALUES ('732', '51', 'XJ6', 'german');
INSERT INTO class_model VALUES ('733', '51', 'XJ8', 'ro');
INSERT INTO class_model VALUES ('733', '51', 'XJ8', 'eng');
INSERT INTO class_model VALUES ('733', '51', 'XJ8', 'german');
INSERT INTO class_model VALUES ('734', '51', 'XJR', 'ro');
INSERT INTO class_model VALUES ('734', '51', 'XJR', 'eng');
INSERT INTO class_model VALUES ('734', '51', 'XJR', 'german');
INSERT INTO class_model VALUES ('735', '51', 'XJS', 'ro');
INSERT INTO class_model VALUES ('735', '51', 'XJS', 'eng');
INSERT INTO class_model VALUES ('735', '51', 'XJS', 'german');
INSERT INTO class_model VALUES ('736', '51', 'XJSC', 'ro');
INSERT INTO class_model VALUES ('736', '51', 'XJSC', 'eng');
INSERT INTO class_model VALUES ('736', '51', 'XJSC', 'german');
INSERT INTO class_model VALUES ('737', '51', 'XK', 'ro');
INSERT INTO class_model VALUES ('737', '51', 'XK', 'eng');
INSERT INTO class_model VALUES ('737', '51', 'XK', 'german');
INSERT INTO class_model VALUES ('738', '51', 'XK8', 'ro');
INSERT INTO class_model VALUES ('738', '51', 'XK8', 'eng');
INSERT INTO class_model VALUES ('738', '51', 'XK8', 'german');
INSERT INTO class_model VALUES ('739', '51', 'XE', 'ro');
INSERT INTO class_model VALUES ('739', '51', 'XE', 'eng');
INSERT INTO class_model VALUES ('739', '51', 'XE', 'german');
INSERT INTO class_model VALUES ('740', '52', 'CJ', 'ro');
INSERT INTO class_model VALUES ('740', '52', 'CJ', 'eng');
INSERT INTO class_model VALUES ('740', '52', 'CJ', 'german');
INSERT INTO class_model VALUES ('741', '52', 'Cherokee', 'ro');
INSERT INTO class_model VALUES ('741', '52', 'Cherokee', 'eng');
INSERT INTO class_model VALUES ('741', '52', 'Cherokee', 'german');
INSERT INTO class_model VALUES ('742', '52', 'Comache', 'ro');
INSERT INTO class_model VALUES ('742', '52', 'Comache', 'eng');
INSERT INTO class_model VALUES ('742', '52', 'Comache', 'german');
INSERT INTO class_model VALUES ('743', '52', 'Commander', 'ro');
INSERT INTO class_model VALUES ('743', '52', 'Commander', 'eng');
INSERT INTO class_model VALUES ('743', '52', 'Commander', 'german');
INSERT INTO class_model VALUES ('744', '52', 'Compass', 'ro');
INSERT INTO class_model VALUES ('744', '52', 'Compass', 'eng');
INSERT INTO class_model VALUES ('744', '52', 'Compass', 'german');
INSERT INTO class_model VALUES ('745', '52', 'Grand Cherokee', 'ro');
INSERT INTO class_model VALUES ('745', '52', 'Grand Cherokee', 'eng');
INSERT INTO class_model VALUES ('745', '52', 'Grand Cherokee', 'german');
INSERT INTO class_model VALUES ('746', '52', 'Liberty', 'ro');
INSERT INTO class_model VALUES ('746', '52', 'Liberty', 'eng');
INSERT INTO class_model VALUES ('746', '52', 'Liberty', 'german');
INSERT INTO class_model VALUES ('747', '52', 'Patriot', 'ro');
INSERT INTO class_model VALUES ('747', '52', 'Patriot', 'eng');
INSERT INTO class_model VALUES ('747', '52', 'Patriot', 'german');
INSERT INTO class_model VALUES ('748', '52', 'Renegade', 'ro');
INSERT INTO class_model VALUES ('748', '52', 'Renegade', 'eng');
INSERT INTO class_model VALUES ('748', '52', 'Renegade', 'german');
INSERT INTO class_model VALUES ('749', '52', 'Wagoneer', 'ro');
INSERT INTO class_model VALUES ('749', '52', 'Wagoneer', 'eng');
INSERT INTO class_model VALUES ('749', '52', 'Wagoneer', 'german');
INSERT INTO class_model VALUES ('750', '52', 'Willys', 'ro');
INSERT INTO class_model VALUES ('750', '52', 'Willys', 'eng');
INSERT INTO class_model VALUES ('750', '52', 'Willys', 'german');
INSERT INTO class_model VALUES ('751', '52', 'Wrangler', 'ro');
INSERT INTO class_model VALUES ('751', '52', 'Wrangler', 'eng');
INSERT INTO class_model VALUES ('751', '52', 'Wrangler', 'german');
INSERT INTO class_model VALUES ('752', '53', '47', 'ro');
INSERT INTO class_model VALUES ('752', '53', '47', 'eng');
INSERT INTO class_model VALUES ('752', '53', '47', 'german');
INSERT INTO class_model VALUES ('753', '54', 'Asia Rocsta', 'ro');
INSERT INTO class_model VALUES ('753', '54', 'Asia Rocsta', 'eng');
INSERT INTO class_model VALUES ('753', '54', 'Asia Rocsta', 'german');
INSERT INTO class_model VALUES ('754', '54', 'Besta', 'ro');
INSERT INTO class_model VALUES ('754', '54', 'Besta', 'eng');
INSERT INTO class_model VALUES ('754', '54', 'Besta', 'german');
INSERT INTO class_model VALUES ('755', '54', 'Carens', 'ro');
INSERT INTO class_model VALUES ('755', '54', 'Carens', 'eng');
INSERT INTO class_model VALUES ('755', '54', 'Carens', 'german');
INSERT INTO class_model VALUES ('756', '54', 'Carnival', 'ro');
INSERT INTO class_model VALUES ('756', '54', 'Carnival', 'eng');
INSERT INTO class_model VALUES ('756', '54', 'Carnival', 'german');
INSERT INTO class_model VALUES ('757', '54', 'Cee\'d', 'ro');
INSERT INTO class_model VALUES ('757', '54', 'Cee\'d', 'eng');
INSERT INTO class_model VALUES ('757', '54', 'Cee\'d', 'german');
INSERT INTO class_model VALUES ('758', '54', 'Cerato', 'ro');
INSERT INTO class_model VALUES ('758', '54', 'Cerato', 'eng');
INSERT INTO class_model VALUES ('758', '54', 'Cerato', 'german');
INSERT INTO class_model VALUES ('759', '54', 'Clarus', 'ro');
INSERT INTO class_model VALUES ('759', '54', 'Clarus', 'eng');
INSERT INTO class_model VALUES ('759', '54', 'Clarus', 'german');
INSERT INTO class_model VALUES ('760', '54', 'Elan', 'ro');
INSERT INTO class_model VALUES ('760', '54', 'Elan', 'eng');
INSERT INTO class_model VALUES ('760', '54', 'Elan', 'german');
INSERT INTO class_model VALUES ('761', '54', 'Joice', 'ro');
INSERT INTO class_model VALUES ('761', '54', 'Joice', 'eng');
INSERT INTO class_model VALUES ('761', '54', 'Joice', 'german');
INSERT INTO class_model VALUES ('762', '54', 'Leo', 'ro');
INSERT INTO class_model VALUES ('762', '54', 'Leo', 'eng');
INSERT INTO class_model VALUES ('762', '54', 'Leo', 'german');
INSERT INTO class_model VALUES ('763', '54', 'Magentis', 'ro');
INSERT INTO class_model VALUES ('763', '54', 'Magentis', 'eng');
INSERT INTO class_model VALUES ('763', '54', 'Magentis', 'german');
INSERT INTO class_model VALUES ('764', '54', 'Mentor', 'ro');
INSERT INTO class_model VALUES ('764', '54', 'Mentor', 'eng');
INSERT INTO class_model VALUES ('764', '54', 'Mentor', 'german');
INSERT INTO class_model VALUES ('765', '54', 'Opirus', 'ro');
INSERT INTO class_model VALUES ('765', '54', 'Opirus', 'eng');
INSERT INTO class_model VALUES ('765', '54', 'Opirus', 'german');
INSERT INTO class_model VALUES ('766', '54', 'Optima', 'ro');
INSERT INTO class_model VALUES ('766', '54', 'Optima', 'eng');
INSERT INTO class_model VALUES ('766', '54', 'Optima', 'german');
INSERT INTO class_model VALUES ('767', '54', 'Picanto', 'ro');
INSERT INTO class_model VALUES ('767', '54', 'Picanto', 'eng');
INSERT INTO class_model VALUES ('767', '54', 'Picanto', 'german');
INSERT INTO class_model VALUES ('768', '54', 'Pregio', 'ro');
INSERT INTO class_model VALUES ('768', '54', 'Pregio', 'eng');
INSERT INTO class_model VALUES ('768', '54', 'Pregio', 'german');
INSERT INTO class_model VALUES ('769', '54', 'Pride', 'ro');
INSERT INTO class_model VALUES ('769', '54', 'Pride', 'eng');
INSERT INTO class_model VALUES ('769', '54', 'Pride', 'german');
INSERT INTO class_model VALUES ('770', '54', 'Pro Cee\'d', 'ro');
INSERT INTO class_model VALUES ('770', '54', 'Pro Cee\'d', 'eng');
INSERT INTO class_model VALUES ('770', '54', 'Pro Cee\'d', 'german');
INSERT INTO class_model VALUES ('771', '54', 'Retona', 'ro');
INSERT INTO class_model VALUES ('771', '54', 'Retona', 'eng');
INSERT INTO class_model VALUES ('771', '54', 'Retona', 'german');
INSERT INTO class_model VALUES ('772', '54', 'Rio', 'ro');
INSERT INTO class_model VALUES ('772', '54', 'Rio', 'eng');
INSERT INTO class_model VALUES ('772', '54', 'Rio', 'german');
INSERT INTO class_model VALUES ('773', '54', 'Roadster', 'ro');
INSERT INTO class_model VALUES ('773', '54', 'Roadster', 'eng');
INSERT INTO class_model VALUES ('773', '54', 'Roadster', 'german');
INSERT INTO class_model VALUES ('774', '54', 'Rocsta', 'ro');
INSERT INTO class_model VALUES ('774', '54', 'Rocsta', 'eng');
INSERT INTO class_model VALUES ('774', '54', 'Rocsta', 'german');
INSERT INTO class_model VALUES ('775', '54', 'Sedona', 'ro');
INSERT INTO class_model VALUES ('775', '54', 'Sedona', 'eng');
INSERT INTO class_model VALUES ('775', '54', 'Sedona', 'german');
INSERT INTO class_model VALUES ('776', '54', 'Sephia', 'ro');
INSERT INTO class_model VALUES ('776', '54', 'Sephia', 'eng');
INSERT INTO class_model VALUES ('776', '54', 'Sephia', 'german');
INSERT INTO class_model VALUES ('777', '54', 'Shuma', 'ro');
INSERT INTO class_model VALUES ('777', '54', 'Shuma', 'eng');
INSERT INTO class_model VALUES ('777', '54', 'Shuma', 'german');
INSERT INTO class_model VALUES ('778', '54', 'Shuma II', 'ro');
INSERT INTO class_model VALUES ('778', '54', 'Shuma II', 'eng');
INSERT INTO class_model VALUES ('778', '54', 'Shuma II', 'german');
INSERT INTO class_model VALUES ('779', '54', 'Sorento', 'ro');
INSERT INTO class_model VALUES ('779', '54', 'Sorento', 'eng');
INSERT INTO class_model VALUES ('779', '54', 'Sorento', 'german');
INSERT INTO class_model VALUES ('780', '54', 'Soul', 'ro');
INSERT INTO class_model VALUES ('780', '54', 'Soul', 'eng');
INSERT INTO class_model VALUES ('780', '54', 'Soul', 'german');
INSERT INTO class_model VALUES ('781', '54', 'Spectra', 'ro');
INSERT INTO class_model VALUES ('781', '54', 'Spectra', 'eng');
INSERT INTO class_model VALUES ('781', '54', 'Spectra', 'german');
INSERT INTO class_model VALUES ('782', '54', 'Sportage', 'ro');
INSERT INTO class_model VALUES ('782', '54', 'Sportage', 'eng');
INSERT INTO class_model VALUES ('782', '54', 'Sportage', 'german');
INSERT INTO class_model VALUES ('783', '54', 'Venga', 'ro');
INSERT INTO class_model VALUES ('783', '54', 'Venga', 'eng');
INSERT INTO class_model VALUES ('783', '54', 'Venga', 'german');
INSERT INTO class_model VALUES ('784', '55', '110', 'ro');
INSERT INTO class_model VALUES ('784', '55', '110', 'eng');
INSERT INTO class_model VALUES ('784', '55', '110', 'german');
INSERT INTO class_model VALUES ('785', '55', '111', 'ro');
INSERT INTO class_model VALUES ('785', '55', '111', 'eng');
INSERT INTO class_model VALUES ('785', '55', '111', 'german');
INSERT INTO class_model VALUES ('786', '55', '1117', 'ro');
INSERT INTO class_model VALUES ('786', '55', '1117', 'eng');
INSERT INTO class_model VALUES ('786', '55', '1117', 'german');
INSERT INTO class_model VALUES ('787', '55', '1118', 'ro');
INSERT INTO class_model VALUES ('787', '55', '1118', 'eng');
INSERT INTO class_model VALUES ('787', '55', '1118', 'german');
INSERT INTO class_model VALUES ('788', '55', '1119', 'ro');
INSERT INTO class_model VALUES ('788', '55', '1119', 'eng');
INSERT INTO class_model VALUES ('788', '55', '1119', 'german');
INSERT INTO class_model VALUES ('789', '55', '112', 'ro');
INSERT INTO class_model VALUES ('789', '55', '112', 'eng');
INSERT INTO class_model VALUES ('789', '55', '112', 'german');
INSERT INTO class_model VALUES ('790', '55', '1200', 'ro');
INSERT INTO class_model VALUES ('790', '55', '1200', 'eng');
INSERT INTO class_model VALUES ('790', '55', '1200', 'german');
INSERT INTO class_model VALUES ('791', '55', '1300', 'ro');
INSERT INTO class_model VALUES ('791', '55', '1300', 'eng');
INSERT INTO class_model VALUES ('791', '55', '1300', 'german');
INSERT INTO class_model VALUES ('792', '55', '1500', 'ro');
INSERT INTO class_model VALUES ('792', '55', '1500', 'eng');
INSERT INTO class_model VALUES ('792', '55', '1500', 'german');
INSERT INTO class_model VALUES ('793', '55', '2101', 'ro');
INSERT INTO class_model VALUES ('793', '55', '2101', 'eng');
INSERT INTO class_model VALUES ('793', '55', '2101', 'german');
INSERT INTO class_model VALUES ('794', '55', '2103', 'ro');
INSERT INTO class_model VALUES ('794', '55', '2103', 'eng');
INSERT INTO class_model VALUES ('794', '55', '2103', 'german');
INSERT INTO class_model VALUES ('795', '55', '2104', 'ro');
INSERT INTO class_model VALUES ('795', '55', '2104', 'eng');
INSERT INTO class_model VALUES ('795', '55', '2104', 'german');
INSERT INTO class_model VALUES ('796', '55', '2105', 'ro');
INSERT INTO class_model VALUES ('796', '55', '2105', 'eng');
INSERT INTO class_model VALUES ('796', '55', '2105', 'german');
INSERT INTO class_model VALUES ('797', '55', '2106', 'ro');
INSERT INTO class_model VALUES ('797', '55', '2106', 'eng');
INSERT INTO class_model VALUES ('797', '55', '2106', 'german');
INSERT INTO class_model VALUES ('798', '55', '2107', 'ro');
INSERT INTO class_model VALUES ('798', '55', '2107', 'eng');
INSERT INTO class_model VALUES ('798', '55', '2107', 'german');
INSERT INTO class_model VALUES ('799', '55', '2108', 'ro');
INSERT INTO class_model VALUES ('799', '55', '2108', 'eng');
INSERT INTO class_model VALUES ('799', '55', '2108', 'german');
INSERT INTO class_model VALUES ('800', '55', '2109', 'ro');
INSERT INTO class_model VALUES ('800', '55', '2109', 'eng');
INSERT INTO class_model VALUES ('800', '55', '2109', 'german');
INSERT INTO class_model VALUES ('801', '55', '2110', 'ro');
INSERT INTO class_model VALUES ('801', '55', '2110', 'eng');
INSERT INTO class_model VALUES ('801', '55', '2110', 'german');
INSERT INTO class_model VALUES ('802', '55', '2111', 'ro');
INSERT INTO class_model VALUES ('802', '55', '2111', 'eng');
INSERT INTO class_model VALUES ('802', '55', '2111', 'german');
INSERT INTO class_model VALUES ('803', '55', '2112', 'ro');
INSERT INTO class_model VALUES ('803', '55', '2112', 'eng');
INSERT INTO class_model VALUES ('803', '55', '2112', 'german');
INSERT INTO class_model VALUES ('804', '55', '2170', 'ro');
INSERT INTO class_model VALUES ('804', '55', '2170', 'eng');
INSERT INTO class_model VALUES ('804', '55', '2170', 'german');
INSERT INTO class_model VALUES ('805', '55', 'Aleko', 'ro');
INSERT INTO class_model VALUES ('805', '55', 'Aleko', 'eng');
INSERT INTO class_model VALUES ('805', '55', 'Aleko', 'german');
INSERT INTO class_model VALUES ('806', '55', 'Forma', 'ro');
INSERT INTO class_model VALUES ('806', '55', 'Forma', 'eng');
INSERT INTO class_model VALUES ('806', '55', 'Forma', 'german');
INSERT INTO class_model VALUES ('807', '55', 'Kalina', 'ro');
INSERT INTO class_model VALUES ('807', '55', 'Kalina', 'eng');
INSERT INTO class_model VALUES ('807', '55', 'Kalina', 'german');
INSERT INTO class_model VALUES ('808', '55', 'Niva', 'ro');
INSERT INTO class_model VALUES ('808', '55', 'Niva', 'eng');
INSERT INTO class_model VALUES ('808', '55', 'Niva', 'german');
INSERT INTO class_model VALUES ('809', '55', 'Nova', 'ro');
INSERT INTO class_model VALUES ('809', '55', 'Nova', 'eng');
INSERT INTO class_model VALUES ('809', '55', 'Nova', 'german');
INSERT INTO class_model VALUES ('810', '55', 'Priora', 'ro');
INSERT INTO class_model VALUES ('810', '55', 'Priora', 'eng');
INSERT INTO class_model VALUES ('810', '55', 'Priora', 'german');
INSERT INTO class_model VALUES ('811', '55', 'Samara', 'ro');
INSERT INTO class_model VALUES ('811', '55', 'Samara', 'eng');
INSERT INTO class_model VALUES ('811', '55', 'Samara', 'german');
INSERT INTO class_model VALUES ('812', '56', 'Aventador', 'ro');
INSERT INTO class_model VALUES ('812', '56', 'Aventador', 'eng');
INSERT INTO class_model VALUES ('812', '56', 'Aventador', 'german');
INSERT INTO class_model VALUES ('813', '56', 'Countach', 'ro');
INSERT INTO class_model VALUES ('813', '56', 'Countach', 'eng');
INSERT INTO class_model VALUES ('813', '56', 'Countach', 'german');
INSERT INTO class_model VALUES ('814', '56', 'Diablo', 'ro');
INSERT INTO class_model VALUES ('814', '56', 'Diablo', 'eng');
INSERT INTO class_model VALUES ('814', '56', 'Diablo', 'german');
INSERT INTO class_model VALUES ('815', '56', 'Espada', 'ro');
INSERT INTO class_model VALUES ('815', '56', 'Espada', 'eng');
INSERT INTO class_model VALUES ('815', '56', 'Espada', 'german');
INSERT INTO class_model VALUES ('816', '56', 'Gallardo', 'ro');
INSERT INTO class_model VALUES ('816', '56', 'Gallardo', 'eng');
INSERT INTO class_model VALUES ('816', '56', 'Gallardo', 'german');
INSERT INTO class_model VALUES ('817', '56', 'Jalpa', 'ro');
INSERT INTO class_model VALUES ('817', '56', 'Jalpa', 'eng');
INSERT INTO class_model VALUES ('817', '56', 'Jalpa', 'german');
INSERT INTO class_model VALUES ('818', '56', 'LM', 'ro');
INSERT INTO class_model VALUES ('818', '56', 'LM', 'eng');
INSERT INTO class_model VALUES ('818', '56', 'LM', 'german');
INSERT INTO class_model VALUES ('819', '56', 'Miura', 'ro');
INSERT INTO class_model VALUES ('819', '56', 'Miura', 'eng');
INSERT INTO class_model VALUES ('819', '56', 'Miura', 'german');
INSERT INTO class_model VALUES ('820', '56', 'Murcielago', 'ro');
INSERT INTO class_model VALUES ('820', '56', 'Murcielago', 'eng');
INSERT INTO class_model VALUES ('820', '56', 'Murcielago', 'german');
INSERT INTO class_model VALUES ('821', '56', 'Urraco', 'ro');
INSERT INTO class_model VALUES ('821', '56', 'Urraco', 'eng');
INSERT INTO class_model VALUES ('821', '56', 'Urraco', 'german');
INSERT INTO class_model VALUES ('822', '56', 'Huracan', 'ro');
INSERT INTO class_model VALUES ('822', '56', 'Huracan', 'eng');
INSERT INTO class_model VALUES ('822', '56', 'Huracan', 'german');
INSERT INTO class_model VALUES ('823', '57', 'Beta', 'ro');
INSERT INTO class_model VALUES ('823', '57', 'Beta', 'eng');
INSERT INTO class_model VALUES ('823', '57', 'Beta', 'german');
INSERT INTO class_model VALUES ('824', '57', 'Dedra', 'ro');
INSERT INTO class_model VALUES ('824', '57', 'Dedra', 'eng');
INSERT INTO class_model VALUES ('824', '57', 'Dedra', 'german');
INSERT INTO class_model VALUES ('825', '57', 'Delta', 'ro');
INSERT INTO class_model VALUES ('825', '57', 'Delta', 'eng');
INSERT INTO class_model VALUES ('825', '57', 'Delta', 'german');
INSERT INTO class_model VALUES ('826', '57', 'Flamina', 'ro');
INSERT INTO class_model VALUES ('826', '57', 'Flamina', 'eng');
INSERT INTO class_model VALUES ('826', '57', 'Flamina', 'german');
INSERT INTO class_model VALUES ('827', '57', 'Fulvia', 'ro');
INSERT INTO class_model VALUES ('827', '57', 'Fulvia', 'eng');
INSERT INTO class_model VALUES ('827', '57', 'Fulvia', 'german');
INSERT INTO class_model VALUES ('828', '57', 'Gamma', 'ro');
INSERT INTO class_model VALUES ('828', '57', 'Gamma', 'eng');
INSERT INTO class_model VALUES ('828', '57', 'Gamma', 'german');
INSERT INTO class_model VALUES ('829', '57', 'Kappa', 'ro');
INSERT INTO class_model VALUES ('829', '57', 'Kappa', 'eng');
INSERT INTO class_model VALUES ('829', '57', 'Kappa', 'german');
INSERT INTO class_model VALUES ('830', '57', 'Lybra', 'ro');
INSERT INTO class_model VALUES ('830', '57', 'Lybra', 'eng');
INSERT INTO class_model VALUES ('830', '57', 'Lybra', 'german');
INSERT INTO class_model VALUES ('831', '57', 'Musa', 'ro');
INSERT INTO class_model VALUES ('831', '57', 'Musa', 'eng');
INSERT INTO class_model VALUES ('831', '57', 'Musa', 'german');
INSERT INTO class_model VALUES ('832', '57', 'Phedra', 'ro');
INSERT INTO class_model VALUES ('832', '57', 'Phedra', 'eng');
INSERT INTO class_model VALUES ('832', '57', 'Phedra', 'german');
INSERT INTO class_model VALUES ('833', '57', 'Prisma', 'ro');
INSERT INTO class_model VALUES ('833', '57', 'Prisma', 'eng');
INSERT INTO class_model VALUES ('833', '57', 'Prisma', 'german');
INSERT INTO class_model VALUES ('834', '57', 'Stratos', 'ro');
INSERT INTO class_model VALUES ('834', '57', 'Stratos', 'eng');
INSERT INTO class_model VALUES ('834', '57', 'Stratos', 'german');
INSERT INTO class_model VALUES ('835', '57', 'Thema', 'ro');
INSERT INTO class_model VALUES ('835', '57', 'Thema', 'eng');
INSERT INTO class_model VALUES ('835', '57', 'Thema', 'german');
INSERT INTO class_model VALUES ('836', '57', 'Thesis', 'ro');
INSERT INTO class_model VALUES ('836', '57', 'Thesis', 'eng');
INSERT INTO class_model VALUES ('836', '57', 'Thesis', 'german');
INSERT INTO class_model VALUES ('837', '57', 'Voyager', 'ro');
INSERT INTO class_model VALUES ('837', '57', 'Voyager', 'eng');
INSERT INTO class_model VALUES ('837', '57', 'Voyager', 'german');
INSERT INTO class_model VALUES ('838', '57', 'Ypsilon', 'ro');
INSERT INTO class_model VALUES ('838', '57', 'Ypsilon', 'eng');
INSERT INTO class_model VALUES ('838', '57', 'Ypsilon', 'german');
INSERT INTO class_model VALUES ('839', '57', 'Zeta', 'ro');
INSERT INTO class_model VALUES ('839', '57', 'Zeta', 'eng');
INSERT INTO class_model VALUES ('839', '57', 'Zeta', 'german');
INSERT INTO class_model VALUES ('840', '58', 'Defender', 'ro');
INSERT INTO class_model VALUES ('840', '58', 'Defender', 'eng');
INSERT INTO class_model VALUES ('840', '58', 'Defender', 'german');
INSERT INTO class_model VALUES ('841', '58', 'Discovery', 'ro');
INSERT INTO class_model VALUES ('841', '58', 'Discovery', 'eng');
INSERT INTO class_model VALUES ('841', '58', 'Discovery', 'german');
INSERT INTO class_model VALUES ('842', '58', 'Discovery Sport', 'ro');
INSERT INTO class_model VALUES ('842', '58', 'Discovery Sport', 'eng');
INSERT INTO class_model VALUES ('842', '58', 'Discovery Sport', 'german');
INSERT INTO class_model VALUES ('843', '58', 'Freelander', 'ro');
INSERT INTO class_model VALUES ('843', '58', 'Freelander', 'eng');
INSERT INTO class_model VALUES ('843', '58', 'Freelander', 'german');
INSERT INTO class_model VALUES ('844', '58', 'Range Rover', 'ro');
INSERT INTO class_model VALUES ('844', '58', 'Range Rover', 'eng');
INSERT INTO class_model VALUES ('844', '58', 'Range Rover', 'german');
INSERT INTO class_model VALUES ('845', '58', 'Range Rover Evoque', 'ro');
INSERT INTO class_model VALUES ('845', '58', 'Range Rover Evoque', 'eng');
INSERT INTO class_model VALUES ('845', '58', 'Range Rover Evoque', 'german');
INSERT INTO class_model VALUES ('846', '58', 'Range Rover Sport', 'ro');
INSERT INTO class_model VALUES ('846', '58', 'Range Rover Sport', 'eng');
INSERT INTO class_model VALUES ('846', '58', 'Range Rover Sport', 'german');
INSERT INTO class_model VALUES ('847', '59', 'CT', 'ro');
INSERT INTO class_model VALUES ('847', '59', 'CT', 'eng');
INSERT INTO class_model VALUES ('847', '59', 'CT', 'german');
INSERT INTO class_model VALUES ('848', '59', 'GX470', 'ro');
INSERT INTO class_model VALUES ('848', '59', 'GX470', 'eng');
INSERT INTO class_model VALUES ('848', '59', 'GX470', 'german');
INSERT INTO class_model VALUES ('849', '59', 'HS 250h', 'ro');
INSERT INTO class_model VALUES ('849', '59', 'HS 250h', 'eng');
INSERT INTO class_model VALUES ('849', '59', 'HS 250h', 'german');
INSERT INTO class_model VALUES ('850', '59', 'LFA', 'ro');
INSERT INTO class_model VALUES ('850', '59', 'LFA', 'eng');
INSERT INTO class_model VALUES ('850', '59', 'LFA', 'german');
INSERT INTO class_model VALUES ('851', '59', 'NX', 'ro');
INSERT INTO class_model VALUES ('851', '59', 'NX', 'eng');
INSERT INTO class_model VALUES ('851', '59', 'NX', 'german');
INSERT INTO class_model VALUES ('852', '59', 'SC300', 'ro');
INSERT INTO class_model VALUES ('852', '59', 'SC300', 'eng');
INSERT INTO class_model VALUES ('852', '59', 'SC300', 'german');
INSERT INTO class_model VALUES ('853', '59', 'Seria ES', 'ro');
INSERT INTO class_model VALUES ('853', '59', 'Seria ES', 'eng');
INSERT INTO class_model VALUES ('853', '59', 'Seria ES', 'german');
INSERT INTO class_model VALUES ('854', '59', 'Seria GS', 'ro');
INSERT INTO class_model VALUES ('854', '59', 'Seria GS', 'eng');
INSERT INTO class_model VALUES ('854', '59', 'Seria GS', 'german');
INSERT INTO class_model VALUES ('855', '59', 'Seria JS', 'ro');
INSERT INTO class_model VALUES ('855', '59', 'Seria JS', 'eng');
INSERT INTO class_model VALUES ('855', '59', 'Seria JS', 'german');
INSERT INTO class_model VALUES ('856', '59', 'Seria LS', 'ro');
INSERT INTO class_model VALUES ('856', '59', 'Seria LS', 'eng');
INSERT INTO class_model VALUES ('856', '59', 'Seria LS', 'german');
INSERT INTO class_model VALUES ('857', '59', 'Seria LX', 'ro');
INSERT INTO class_model VALUES ('857', '59', 'Seria LX', 'eng');
INSERT INTO class_model VALUES ('857', '59', 'Seria LX', 'german');
INSERT INTO class_model VALUES ('858', '59', 'Seria NX', 'ro');
INSERT INTO class_model VALUES ('858', '59', 'Seria NX', 'eng');
INSERT INTO class_model VALUES ('858', '59', 'Seria NX', 'german');
INSERT INTO class_model VALUES ('859', '59', 'Seria RX', 'ro');
INSERT INTO class_model VALUES ('859', '59', 'Seria RX', 'eng');
INSERT INTO class_model VALUES ('859', '59', 'Seria RX', 'german');
INSERT INTO class_model VALUES ('860', '59', 'Seria SC', 'ro');
INSERT INTO class_model VALUES ('860', '59', 'Seria SC', 'eng');
INSERT INTO class_model VALUES ('860', '59', 'Seria SC', 'german');
INSERT INTO class_model VALUES ('861', '60', 'Ambra', 'ro');
INSERT INTO class_model VALUES ('861', '60', 'Ambra', 'eng');
INSERT INTO class_model VALUES ('861', '60', 'Ambra', 'german');
INSERT INTO class_model VALUES ('862', '60', 'Nova', 'ro');
INSERT INTO class_model VALUES ('862', '60', 'Nova', 'eng');
INSERT INTO class_model VALUES ('862', '60', 'Nova', 'german');
INSERT INTO class_model VALUES ('863', '60', 'Optima', 'ro');
INSERT INTO class_model VALUES ('863', '60', 'Optima', 'eng');
INSERT INTO class_model VALUES ('863', '60', 'Optima', 'german');
INSERT INTO class_model VALUES ('864', '60', 'X-Too', 'ro');
INSERT INTO class_model VALUES ('864', '60', 'X-Too', 'eng');
INSERT INTO class_model VALUES ('864', '60', 'X-Too', 'german');
INSERT INTO class_model VALUES ('865', '61', 'Aviator', 'ro');
INSERT INTO class_model VALUES ('865', '61', 'Aviator', 'eng');
INSERT INTO class_model VALUES ('865', '61', 'Aviator', 'german');
INSERT INTO class_model VALUES ('866', '61', 'Continental', 'ro');
INSERT INTO class_model VALUES ('866', '61', 'Continental', 'eng');
INSERT INTO class_model VALUES ('866', '61', 'Continental', 'german');
INSERT INTO class_model VALUES ('867', '61', 'LS', 'ro');
INSERT INTO class_model VALUES ('867', '61', 'LS', 'eng');
INSERT INTO class_model VALUES ('867', '61', 'LS', 'german');
INSERT INTO class_model VALUES ('868', '61', 'MKX', 'ro');
INSERT INTO class_model VALUES ('868', '61', 'MKX', 'eng');
INSERT INTO class_model VALUES ('868', '61', 'MKX', 'german');
INSERT INTO class_model VALUES ('869', '61', 'MKZ', 'ro');
INSERT INTO class_model VALUES ('869', '61', 'MKZ', 'eng');
INSERT INTO class_model VALUES ('869', '61', 'MKZ', 'german');
INSERT INTO class_model VALUES ('870', '61', 'Mark', 'ro');
INSERT INTO class_model VALUES ('870', '61', 'Mark', 'eng');
INSERT INTO class_model VALUES ('870', '61', 'Mark', 'german');
INSERT INTO class_model VALUES ('871', '61', 'Mark LT', 'ro');
INSERT INTO class_model VALUES ('871', '61', 'Mark LT', 'eng');
INSERT INTO class_model VALUES ('871', '61', 'Mark LT', 'german');
INSERT INTO class_model VALUES ('872', '61', 'Navigator', 'ro');
INSERT INTO class_model VALUES ('872', '61', 'Navigator', 'eng');
INSERT INTO class_model VALUES ('872', '61', 'Navigator', 'german');
INSERT INTO class_model VALUES ('873', '61', 'Town Car', 'ro');
INSERT INTO class_model VALUES ('873', '61', 'Town Car', 'eng');
INSERT INTO class_model VALUES ('873', '61', 'Town Car', 'german');
INSERT INTO class_model VALUES ('874', '62', '340R', 'ro');
INSERT INTO class_model VALUES ('874', '62', '340R', 'eng');
INSERT INTO class_model VALUES ('874', '62', '340R', 'german');
INSERT INTO class_model VALUES ('875', '62', 'Cortina', 'ro');
INSERT INTO class_model VALUES ('875', '62', 'Cortina', 'eng');
INSERT INTO class_model VALUES ('875', '62', 'Cortina', 'german');
INSERT INTO class_model VALUES ('876', '62', 'Elan', 'ro');
INSERT INTO class_model VALUES ('876', '62', 'Elan', 'eng');
INSERT INTO class_model VALUES ('876', '62', 'Elan', 'german');
INSERT INTO class_model VALUES ('877', '62', 'Elise', 'ro');
INSERT INTO class_model VALUES ('877', '62', 'Elise', 'eng');
INSERT INTO class_model VALUES ('877', '62', 'Elise', 'german');
INSERT INTO class_model VALUES ('878', '62', 'Elite', 'ro');
INSERT INTO class_model VALUES ('878', '62', 'Elite', 'eng');
INSERT INTO class_model VALUES ('878', '62', 'Elite', 'german');
INSERT INTO class_model VALUES ('879', '62', 'Esprit', 'ro');
INSERT INTO class_model VALUES ('879', '62', 'Esprit', 'eng');
INSERT INTO class_model VALUES ('879', '62', 'Esprit', 'german');
INSERT INTO class_model VALUES ('880', '62', 'Europa', 'ro');
INSERT INTO class_model VALUES ('880', '62', 'Europa', 'eng');
INSERT INTO class_model VALUES ('880', '62', 'Europa', 'german');
INSERT INTO class_model VALUES ('881', '62', 'Evora', 'ro');
INSERT INTO class_model VALUES ('881', '62', 'Evora', 'eng');
INSERT INTO class_model VALUES ('881', '62', 'Evora', 'german');
INSERT INTO class_model VALUES ('882', '62', 'Excel', 'ro');
INSERT INTO class_model VALUES ('882', '62', 'Excel', 'eng');
INSERT INTO class_model VALUES ('882', '62', 'Excel', 'german');
INSERT INTO class_model VALUES ('883', '62', 'Exige', 'ro');
INSERT INTO class_model VALUES ('883', '62', 'Exige', 'eng');
INSERT INTO class_model VALUES ('883', '62', 'Exige', 'german');
INSERT INTO class_model VALUES ('884', '62', 'Super Seven', 'ro');
INSERT INTO class_model VALUES ('884', '62', 'Super Seven', 'eng');
INSERT INTO class_model VALUES ('884', '62', 'Super Seven', 'german');
INSERT INTO class_model VALUES ('885', '62', 'V8', 'ro');
INSERT INTO class_model VALUES ('885', '62', 'V8', 'eng');
INSERT INTO class_model VALUES ('885', '62', 'V8', 'german');
INSERT INTO class_model VALUES ('886', '63', 'Fairway', 'ro');
INSERT INTO class_model VALUES ('886', '63', 'Fairway', 'eng');
INSERT INTO class_model VALUES ('886', '63', 'Fairway', 'german');
INSERT INTO class_model VALUES ('887', '63', 'TX2', 'ro');
INSERT INTO class_model VALUES ('887', '63', 'TX2', 'eng');
INSERT INTO class_model VALUES ('887', '63', 'TX2', 'german');
INSERT INTO class_model VALUES ('888', '63', 'TX4', 'ro');
INSERT INTO class_model VALUES ('888', '63', 'TX4', 'eng');
INSERT INTO class_model VALUES ('888', '63', 'TX4', 'german');
INSERT INTO class_model VALUES ('889', '64', '969', 'ro');
INSERT INTO class_model VALUES ('889', '64', '969', 'eng');
INSERT INTO class_model VALUES ('889', '64', '969', 'german');
INSERT INTO class_model VALUES ('890', '66', '800', 'ro');
INSERT INTO class_model VALUES ('890', '66', '800', 'eng');
INSERT INTO class_model VALUES ('890', '66', '800', 'german');
INSERT INTO class_model VALUES ('891', '67', '222', 'ro');
INSERT INTO class_model VALUES ('891', '67', '222', 'eng');
INSERT INTO class_model VALUES ('891', '67', '222', 'german');
INSERT INTO class_model VALUES ('892', '67', '224', 'ro');
INSERT INTO class_model VALUES ('892', '67', '224', 'eng');
INSERT INTO class_model VALUES ('892', '67', '224', 'german');
INSERT INTO class_model VALUES ('893', '67', '228', 'ro');
INSERT INTO class_model VALUES ('893', '67', '228', 'eng');
INSERT INTO class_model VALUES ('893', '67', '228', 'german');
INSERT INTO class_model VALUES ('894', '67', '3200', 'ro');
INSERT INTO class_model VALUES ('894', '67', '3200', 'eng');
INSERT INTO class_model VALUES ('894', '67', '3200', 'german');
INSERT INTO class_model VALUES ('895', '67', '418', 'ro');
INSERT INTO class_model VALUES ('895', '67', '418', 'eng');
INSERT INTO class_model VALUES ('895', '67', '418', 'german');
INSERT INTO class_model VALUES ('896', '67', '420', 'ro');
INSERT INTO class_model VALUES ('896', '67', '420', 'eng');
INSERT INTO class_model VALUES ('896', '67', '420', 'german');
INSERT INTO class_model VALUES ('897', '67', '4200', 'ro');
INSERT INTO class_model VALUES ('897', '67', '4200', 'eng');
INSERT INTO class_model VALUES ('897', '67', '4200', 'german');
INSERT INTO class_model VALUES ('898', '67', '422', 'ro');
INSERT INTO class_model VALUES ('898', '67', '422', 'eng');
INSERT INTO class_model VALUES ('898', '67', '422', 'german');
INSERT INTO class_model VALUES ('899', '67', '424', 'ro');
INSERT INTO class_model VALUES ('899', '67', '424', 'eng');
INSERT INTO class_model VALUES ('899', '67', '424', 'german');
INSERT INTO class_model VALUES ('900', '67', '430', 'ro');
INSERT INTO class_model VALUES ('900', '67', '430', 'eng');
INSERT INTO class_model VALUES ('900', '67', '430', 'german');
INSERT INTO class_model VALUES ('901', '67', 'Biturbo', 'ro');
INSERT INTO class_model VALUES ('901', '67', 'Biturbo', 'eng');
INSERT INTO class_model VALUES ('901', '67', 'Biturbo', 'german');
INSERT INTO class_model VALUES ('902', '67', 'Coupe', 'ro');
INSERT INTO class_model VALUES ('902', '67', 'Coupe', 'eng');
INSERT INTO class_model VALUES ('902', '67', 'Coupe', 'german');
INSERT INTO class_model VALUES ('903', '67', 'Ghibli', 'ro');
INSERT INTO class_model VALUES ('903', '67', 'Ghibli', 'eng');
INSERT INTO class_model VALUES ('903', '67', 'Ghibli', 'german');
INSERT INTO class_model VALUES ('904', '67', 'GranCabrio', 'ro');
INSERT INTO class_model VALUES ('904', '67', 'GranCabrio', 'eng');
INSERT INTO class_model VALUES ('904', '67', 'GranCabrio', 'german');
INSERT INTO class_model VALUES ('905', '67', 'GranTurismo', 'ro');
INSERT INTO class_model VALUES ('905', '67', 'GranTurismo', 'eng');
INSERT INTO class_model VALUES ('905', '67', 'GranTurismo', 'german');
INSERT INTO class_model VALUES ('906', '67', 'Gransport', 'ro');
INSERT INTO class_model VALUES ('906', '67', 'Gransport', 'eng');
INSERT INTO class_model VALUES ('906', '67', 'Gransport', 'german');
INSERT INTO class_model VALUES ('907', '67', 'Indy', 'ro');
INSERT INTO class_model VALUES ('907', '67', 'Indy', 'eng');
INSERT INTO class_model VALUES ('907', '67', 'Indy', 'german');
INSERT INTO class_model VALUES ('908', '67', 'Karif', 'ro');
INSERT INTO class_model VALUES ('908', '67', 'Karif', 'eng');
INSERT INTO class_model VALUES ('908', '67', 'Karif', 'german');
INSERT INTO class_model VALUES ('909', '67', 'MC Stradale', 'ro');
INSERT INTO class_model VALUES ('909', '67', 'MC Stradale', 'eng');
INSERT INTO class_model VALUES ('909', '67', 'MC Stradale', 'german');
INSERT INTO class_model VALUES ('910', '67', 'MC12', 'ro');
INSERT INTO class_model VALUES ('910', '67', 'MC12', 'eng');
INSERT INTO class_model VALUES ('910', '67', 'MC12', 'german');
INSERT INTO class_model VALUES ('911', '67', 'Merak', 'ro');
INSERT INTO class_model VALUES ('911', '67', 'Merak', 'eng');
INSERT INTO class_model VALUES ('911', '67', 'Merak', 'german');
INSERT INTO class_model VALUES ('912', '67', 'Quattroporte', 'ro');
INSERT INTO class_model VALUES ('912', '67', 'Quattroporte', 'eng');
INSERT INTO class_model VALUES ('912', '67', 'Quattroporte', 'german');
INSERT INTO class_model VALUES ('913', '67', 'Shamal', 'ro');
INSERT INTO class_model VALUES ('913', '67', 'Shamal', 'eng');
INSERT INTO class_model VALUES ('913', '67', 'Shamal', 'german');
INSERT INTO class_model VALUES ('914', '67', 'Spyder', 'ro');
INSERT INTO class_model VALUES ('914', '67', 'Spyder', 'eng');
INSERT INTO class_model VALUES ('914', '67', 'Spyder', 'german');
INSERT INTO class_model VALUES ('915', '67', 'Levante', 'ro');
INSERT INTO class_model VALUES ('915', '67', 'Levante', 'eng');
INSERT INTO class_model VALUES ('915', '67', 'Levante', 'german');
INSERT INTO class_model VALUES ('916', '68', '57', 'ro');
INSERT INTO class_model VALUES ('916', '68', '57', 'eng');
INSERT INTO class_model VALUES ('916', '68', '57', 'german');
INSERT INTO class_model VALUES ('917', '68', '62', 'ro');
INSERT INTO class_model VALUES ('917', '68', '62', 'eng');
INSERT INTO class_model VALUES ('917', '68', '62', 'german');
INSERT INTO class_model VALUES ('918', '69', '121', 'ro');
INSERT INTO class_model VALUES ('918', '69', '121', 'eng');
INSERT INTO class_model VALUES ('918', '69', '121', 'german');
INSERT INTO class_model VALUES ('919', '69', '2', 'ro');
INSERT INTO class_model VALUES ('919', '69', '2', 'eng');
INSERT INTO class_model VALUES ('919', '69', '2', 'german');
INSERT INTO class_model VALUES ('920', '69', '3', 'ro');
INSERT INTO class_model VALUES ('920', '69', '3', 'eng');
INSERT INTO class_model VALUES ('920', '69', '3', 'german');
INSERT INTO class_model VALUES ('921', '69', '323', 'ro');
INSERT INTO class_model VALUES ('921', '69', '323', 'eng');
INSERT INTO class_model VALUES ('921', '69', '323', 'german');
INSERT INTO class_model VALUES ('922', '69', '323F', 'ro');
INSERT INTO class_model VALUES ('922', '69', '323F', 'eng');
INSERT INTO class_model VALUES ('922', '69', '323F', 'german');
INSERT INTO class_model VALUES ('923', '69', '5', 'ro');
INSERT INTO class_model VALUES ('923', '69', '5', 'eng');
INSERT INTO class_model VALUES ('923', '69', '5', 'german');
INSERT INTO class_model VALUES ('924', '69', '6', 'ro');
INSERT INTO class_model VALUES ('924', '69', '6', 'eng');
INSERT INTO class_model VALUES ('924', '69', '6', 'german');
INSERT INTO class_model VALUES ('925', '69', '626', 'ro');
INSERT INTO class_model VALUES ('925', '69', '626', 'eng');
INSERT INTO class_model VALUES ('925', '69', '626', 'german');
INSERT INTO class_model VALUES ('926', '69', '929', 'ro');
INSERT INTO class_model VALUES ('926', '69', '929', 'eng');
INSERT INTO class_model VALUES ('926', '69', '929', 'german');
INSERT INTO class_model VALUES ('927', '69', 'BT-50', 'ro');
INSERT INTO class_model VALUES ('927', '69', 'BT-50', 'eng');
INSERT INTO class_model VALUES ('927', '69', 'BT-50', 'german');
INSERT INTO class_model VALUES ('928', '69', 'Bongo', 'ro');
INSERT INTO class_model VALUES ('928', '69', 'Bongo', 'eng');
INSERT INTO class_model VALUES ('928', '69', 'Bongo', 'german');
INSERT INTO class_model VALUES ('929', '69', 'CX-3', 'ro');
INSERT INTO class_model VALUES ('929', '69', 'CX-3', 'eng');
INSERT INTO class_model VALUES ('929', '69', 'CX-3', 'german');
INSERT INTO class_model VALUES ('930', '69', 'CX-5', 'ro');
INSERT INTO class_model VALUES ('930', '69', 'CX-5', 'eng');
INSERT INTO class_model VALUES ('930', '69', 'CX-5', 'german');
INSERT INTO class_model VALUES ('931', '69', 'CX-7', 'ro');
INSERT INTO class_model VALUES ('931', '69', 'CX-7', 'eng');
INSERT INTO class_model VALUES ('931', '69', 'CX-7', 'german');
INSERT INTO class_model VALUES ('932', '69', 'CX-9', 'ro');
INSERT INTO class_model VALUES ('932', '69', 'CX-9', 'eng');
INSERT INTO class_model VALUES ('932', '69', 'CX-9', 'german');
INSERT INTO class_model VALUES ('933', '69', 'Demio', 'ro');
INSERT INTO class_model VALUES ('933', '69', 'Demio', 'eng');
INSERT INTO class_model VALUES ('933', '69', 'Demio', 'german');
INSERT INTO class_model VALUES ('934', '69', 'MPV', 'ro');
INSERT INTO class_model VALUES ('934', '69', 'MPV', 'eng');
INSERT INTO class_model VALUES ('934', '69', 'MPV', 'german');
INSERT INTO class_model VALUES ('935', '69', 'MX-3', 'ro');
INSERT INTO class_model VALUES ('935', '69', 'MX-3', 'eng');
INSERT INTO class_model VALUES ('935', '69', 'MX-3', 'german');
INSERT INTO class_model VALUES ('936', '69', 'MX-5', 'ro');
INSERT INTO class_model VALUES ('936', '69', 'MX-5', 'eng');
INSERT INTO class_model VALUES ('936', '69', 'MX-5', 'german');
INSERT INTO class_model VALUES ('937', '69', 'MX-6', 'ro');
INSERT INTO class_model VALUES ('937', '69', 'MX-6', 'eng');
INSERT INTO class_model VALUES ('937', '69', 'MX-6', 'german');
INSERT INTO class_model VALUES ('938', '69', 'Millenia', 'ro');
INSERT INTO class_model VALUES ('938', '69', 'Millenia', 'eng');
INSERT INTO class_model VALUES ('938', '69', 'Millenia', 'german');
INSERT INTO class_model VALUES ('939', '69', 'Premacy', 'ro');
INSERT INTO class_model VALUES ('939', '69', 'Premacy', 'eng');
INSERT INTO class_model VALUES ('939', '69', 'Premacy', 'german');
INSERT INTO class_model VALUES ('940', '69', 'Protege', 'ro');
INSERT INTO class_model VALUES ('940', '69', 'Protege', 'eng');
INSERT INTO class_model VALUES ('940', '69', 'Protege', 'german');
INSERT INTO class_model VALUES ('941', '69', 'RX-6', 'ro');
INSERT INTO class_model VALUES ('941', '69', 'RX-6', 'eng');
INSERT INTO class_model VALUES ('941', '69', 'RX-6', 'german');
INSERT INTO class_model VALUES ('942', '69', 'RX-7', 'ro');
INSERT INTO class_model VALUES ('942', '69', 'RX-7', 'eng');
INSERT INTO class_model VALUES ('942', '69', 'RX-7', 'german');
INSERT INTO class_model VALUES ('943', '69', 'RX-8', 'ro');
INSERT INTO class_model VALUES ('943', '69', 'RX-8', 'eng');
INSERT INTO class_model VALUES ('943', '69', 'RX-8', 'german');
INSERT INTO class_model VALUES ('944', '69', 'Seria B', 'ro');
INSERT INTO class_model VALUES ('944', '69', 'Seria B', 'eng');
INSERT INTO class_model VALUES ('944', '69', 'Seria B', 'german');
INSERT INTO class_model VALUES ('945', '69', 'Seria E', 'ro');
INSERT INTO class_model VALUES ('945', '69', 'Seria E', 'eng');
INSERT INTO class_model VALUES ('945', '69', 'Seria E', 'german');
INSERT INTO class_model VALUES ('946', '69', 'Tribute', 'ro');
INSERT INTO class_model VALUES ('946', '69', 'Tribute', 'eng');
INSERT INTO class_model VALUES ('946', '69', 'Tribute', 'german');
INSERT INTO class_model VALUES ('947', '69', 'Xedos', 'ro');
INSERT INTO class_model VALUES ('947', '69', 'Xedos', 'eng');
INSERT INTO class_model VALUES ('947', '69', 'Xedos', 'german');
INSERT INTO class_model VALUES ('948', '70', 'MP4-12C', 'ro');
INSERT INTO class_model VALUES ('948', '70', 'MP4-12C', 'eng');
INSERT INTO class_model VALUES ('948', '70', 'MP4-12C', 'german');
INSERT INTO class_model VALUES ('949', '71', '180', 'ro');
INSERT INTO class_model VALUES ('949', '71', '180', 'eng');
INSERT INTO class_model VALUES ('949', '71', '180', 'german');
INSERT INTO class_model VALUES ('950', '71', '190', 'ro');
INSERT INTO class_model VALUES ('950', '71', '190', 'eng');
INSERT INTO class_model VALUES ('950', '71', '190', 'german');
INSERT INTO class_model VALUES ('951', '71', '200', 'ro');
INSERT INTO class_model VALUES ('951', '71', '200', 'eng');
INSERT INTO class_model VALUES ('951', '71', '200', 'german');
INSERT INTO class_model VALUES ('952', '71', '219', 'ro');
INSERT INTO class_model VALUES ('952', '71', '219', 'eng');
INSERT INTO class_model VALUES ('952', '71', '219', 'german');
INSERT INTO class_model VALUES ('953', '71', '220', 'ro');
INSERT INTO class_model VALUES ('953', '71', '220', 'eng');
INSERT INTO class_model VALUES ('953', '71', '220', 'german');
INSERT INTO class_model VALUES ('954', '71', '230', 'ro');
INSERT INTO class_model VALUES ('954', '71', '230', 'eng');
INSERT INTO class_model VALUES ('954', '71', '230', 'german');
INSERT INTO class_model VALUES ('955', '71', '240', 'ro');
INSERT INTO class_model VALUES ('955', '71', '240', 'eng');
INSERT INTO class_model VALUES ('955', '71', '240', 'german');
INSERT INTO class_model VALUES ('956', '71', '250', 'ro');
INSERT INTO class_model VALUES ('956', '71', '250', 'eng');
INSERT INTO class_model VALUES ('956', '71', '250', 'german');
INSERT INTO class_model VALUES ('957', '71', '260', 'ro');
INSERT INTO class_model VALUES ('957', '71', '260', 'eng');
INSERT INTO class_model VALUES ('957', '71', '260', 'german');
INSERT INTO class_model VALUES ('958', '71', '270', 'ro');
INSERT INTO class_model VALUES ('958', '71', '270', 'eng');
INSERT INTO class_model VALUES ('958', '71', '270', 'german');
INSERT INTO class_model VALUES ('959', '71', '280', 'ro');
INSERT INTO class_model VALUES ('959', '71', '280', 'eng');
INSERT INTO class_model VALUES ('959', '71', '280', 'german');
INSERT INTO class_model VALUES ('960', '71', '290', 'ro');
INSERT INTO class_model VALUES ('960', '71', '290', 'eng');
INSERT INTO class_model VALUES ('960', '71', '290', 'german');
INSERT INTO class_model VALUES ('961', '71', '300', 'ro');
INSERT INTO class_model VALUES ('961', '71', '300', 'eng');
INSERT INTO class_model VALUES ('961', '71', '300', 'german');
INSERT INTO class_model VALUES ('962', '71', '320', 'ro');
INSERT INTO class_model VALUES ('962', '71', '320', 'eng');
INSERT INTO class_model VALUES ('962', '71', '320', 'german');
INSERT INTO class_model VALUES ('963', '71', '350', 'ro');
INSERT INTO class_model VALUES ('963', '71', '350', 'eng');
INSERT INTO class_model VALUES ('963', '71', '350', 'german');
INSERT INTO class_model VALUES ('964', '71', '380', 'ro');
INSERT INTO class_model VALUES ('964', '71', '380', 'eng');
INSERT INTO class_model VALUES ('964', '71', '380', 'german');
INSERT INTO class_model VALUES ('965', '71', '400', 'ro');
INSERT INTO class_model VALUES ('965', '71', '400', 'eng');
INSERT INTO class_model VALUES ('965', '71', '400', 'german');
INSERT INTO class_model VALUES ('966', '71', '416', 'ro');
INSERT INTO class_model VALUES ('966', '71', '416', 'eng');
INSERT INTO class_model VALUES ('966', '71', '416', 'german');
INSERT INTO class_model VALUES ('967', '71', '420', 'ro');
INSERT INTO class_model VALUES ('967', '71', '420', 'eng');
INSERT INTO class_model VALUES ('967', '71', '420', 'german');
INSERT INTO class_model VALUES ('968', '71', '450', 'ro');
INSERT INTO class_model VALUES ('968', '71', '450', 'eng');
INSERT INTO class_model VALUES ('968', '71', '450', 'german');
INSERT INTO class_model VALUES ('969', '71', '500', 'ro');
INSERT INTO class_model VALUES ('969', '71', '500', 'eng');
INSERT INTO class_model VALUES ('969', '71', '500', 'german');
INSERT INTO class_model VALUES ('970', '71', '560', 'ro');
INSERT INTO class_model VALUES ('970', '71', '560', 'eng');
INSERT INTO class_model VALUES ('970', '71', '560', 'german');
INSERT INTO class_model VALUES ('971', '71', '600', 'ro');
INSERT INTO class_model VALUES ('971', '71', '600', 'eng');
INSERT INTO class_model VALUES ('971', '71', '600', 'german');
INSERT INTO class_model VALUES ('972', '71', 'A', 'ro');
INSERT INTO class_model VALUES ('972', '71', 'A', 'eng');
INSERT INTO class_model VALUES ('972', '71', 'A', 'german');
INSERT INTO class_model VALUES ('973', '71', 'B', 'ro');
INSERT INTO class_model VALUES ('973', '71', 'B', 'eng');
INSERT INTO class_model VALUES ('973', '71', 'B', 'german');
INSERT INTO class_model VALUES ('974', '71', 'C', 'ro');
INSERT INTO class_model VALUES ('974', '71', 'C', 'eng');
INSERT INTO class_model VALUES ('974', '71', 'C', 'german');
INSERT INTO class_model VALUES ('975', '71', 'CE', 'ro');
INSERT INTO class_model VALUES ('975', '71', 'CE', 'eng');
INSERT INTO class_model VALUES ('975', '71', 'CE', 'german');
INSERT INTO class_model VALUES ('976', '71', 'CL', 'ro');
INSERT INTO class_model VALUES ('976', '71', 'CL', 'eng');
INSERT INTO class_model VALUES ('976', '71', 'CL', 'german');
INSERT INTO class_model VALUES ('977', '71', 'CLC', 'ro');
INSERT INTO class_model VALUES ('977', '71', 'CLC', 'eng');
INSERT INTO class_model VALUES ('977', '71', 'CLC', 'german');
INSERT INTO class_model VALUES ('978', '71', 'CLK', 'ro');
INSERT INTO class_model VALUES ('978', '71', 'CLK', 'eng');
INSERT INTO class_model VALUES ('978', '71', 'CLK', 'german');
INSERT INTO class_model VALUES ('979', '71', 'CLS', 'ro');
INSERT INTO class_model VALUES ('979', '71', 'CLS', 'eng');
INSERT INTO class_model VALUES ('979', '71', 'CLS', 'german');
INSERT INTO class_model VALUES ('980', '71', 'Citan', 'ro');
INSERT INTO class_model VALUES ('980', '71', 'Citan', 'eng');
INSERT INTO class_model VALUES ('980', '71', 'Citan', 'german');
INSERT INTO class_model VALUES ('981', '71', 'CLA', 'ro');
INSERT INTO class_model VALUES ('981', '71', 'CLA', 'eng');
INSERT INTO class_model VALUES ('981', '71', 'CLA', 'german');
INSERT INTO class_model VALUES ('982', '71', 'GLE', 'ro');
INSERT INTO class_model VALUES ('982', '71', 'GLE', 'eng');
INSERT INTO class_model VALUES ('982', '71', 'GLE', 'german');
INSERT INTO class_model VALUES ('983', '71', 'E', 'ro');
INSERT INTO class_model VALUES ('983', '71', 'E', 'eng');
INSERT INTO class_model VALUES ('983', '71', 'E', 'german');
INSERT INTO class_model VALUES ('984', '71', 'GL', 'ro');
INSERT INTO class_model VALUES ('984', '71', 'GL', 'eng');
INSERT INTO class_model VALUES ('984', '71', 'GL', 'german');
INSERT INTO class_model VALUES ('985', '71', 'GLA', 'ro');
INSERT INTO class_model VALUES ('985', '71', 'GLA', 'eng');
INSERT INTO class_model VALUES ('985', '71', 'GLA', 'german');
INSERT INTO class_model VALUES ('986', '71', 'GLC', 'ro');
INSERT INTO class_model VALUES ('986', '71', 'GLC', 'eng');
INSERT INTO class_model VALUES ('986', '71', 'GLC', 'german');
INSERT INTO class_model VALUES ('987', '71', 'GLK', 'ro');
INSERT INTO class_model VALUES ('987', '71', 'GLK', 'eng');
INSERT INTO class_model VALUES ('987', '71', 'GLK', 'german');
INSERT INTO class_model VALUES ('988', '71', 'GLS', 'ro');
INSERT INTO class_model VALUES ('988', '71', 'GLS', 'eng');
INSERT INTO class_model VALUES ('988', '71', 'GLS', 'german');
INSERT INTO class_model VALUES ('989', '71', 'M', 'ro');
INSERT INTO class_model VALUES ('989', '71', 'M', 'eng');
INSERT INTO class_model VALUES ('989', '71', 'M', 'german');
INSERT INTO class_model VALUES ('990', '71', 'MB 100', 'ro');
INSERT INTO class_model VALUES ('990', '71', 'MB 100', 'eng');
INSERT INTO class_model VALUES ('990', '71', 'MB 100', 'german');
INSERT INTO class_model VALUES ('991', '71', 'Monarch', 'ro');
INSERT INTO class_model VALUES ('991', '71', 'Monarch', 'eng');
INSERT INTO class_model VALUES ('991', '71', 'Monarch', 'german');
INSERT INTO class_model VALUES ('992', '71', 'R', 'ro');
INSERT INTO class_model VALUES ('992', '71', 'R', 'eng');
INSERT INTO class_model VALUES ('992', '71', 'R', 'german');
INSERT INTO class_model VALUES ('993', '71', 'S', 'ro');
INSERT INTO class_model VALUES ('993', '71', 'S', 'eng');
INSERT INTO class_model VALUES ('993', '71', 'S', 'german');
INSERT INTO class_model VALUES ('994', '71', 'SL', 'ro');
INSERT INTO class_model VALUES ('994', '71', 'SL', 'eng');
INSERT INTO class_model VALUES ('994', '71', 'SL', 'german');
INSERT INTO class_model VALUES ('995', '71', 'SLK', 'ro');
INSERT INTO class_model VALUES ('995', '71', 'SLK', 'eng');
INSERT INTO class_model VALUES ('995', '71', 'SLK', 'german');
INSERT INTO class_model VALUES ('996', '71', 'SLR', 'ro');
INSERT INTO class_model VALUES ('996', '71', 'SLR', 'eng');
INSERT INTO class_model VALUES ('996', '71', 'SLR', 'german');
INSERT INTO class_model VALUES ('997', '71', 'Sprinter', 'ro');
INSERT INTO class_model VALUES ('997', '71', 'Sprinter', 'eng');
INSERT INTO class_model VALUES ('997', '71', 'Sprinter', 'german');
INSERT INTO class_model VALUES ('998', '71', 'V', 'ro');
INSERT INTO class_model VALUES ('998', '71', 'V', 'eng');
INSERT INTO class_model VALUES ('998', '71', 'V', 'german');
INSERT INTO class_model VALUES ('999', '71', 'Vaneo', 'ro');
INSERT INTO class_model VALUES ('999', '71', 'Vaneo', 'eng');
INSERT INTO class_model VALUES ('999', '71', 'Vaneo', 'german');
INSERT INTO class_model VALUES ('1000', '71', 'Vario', 'ro');
INSERT INTO class_model VALUES ('1000', '71', 'Vario', 'eng');
INSERT INTO class_model VALUES ('1000', '71', 'Vario', 'german');
INSERT INTO class_model VALUES ('1001', '71', 'Viano', 'ro');
INSERT INTO class_model VALUES ('1001', '71', 'Viano', 'eng');
INSERT INTO class_model VALUES ('1001', '71', 'Viano', 'german');
INSERT INTO class_model VALUES ('1002', '71', 'Vito', 'ro');
INSERT INTO class_model VALUES ('1002', '71', 'Vito', 'eng');
INSERT INTO class_model VALUES ('1002', '71', 'Vito', 'german');
INSERT INTO class_model VALUES ('1003', '71', 'W123', 'ro');
INSERT INTO class_model VALUES ('1003', '71', 'W123', 'eng');
INSERT INTO class_model VALUES ('1003', '71', 'W123', 'german');
INSERT INTO class_model VALUES ('1004', '71', 'W124', 'ro');
INSERT INTO class_model VALUES ('1004', '71', 'W124', 'eng');
INSERT INTO class_model VALUES ('1004', '71', 'W124', 'german');
INSERT INTO class_model VALUES ('1005', '72', 'Comet', 'ro');
INSERT INTO class_model VALUES ('1005', '72', 'Comet', 'eng');
INSERT INTO class_model VALUES ('1005', '72', 'Comet', 'german');
INSERT INTO class_model VALUES ('1006', '72', 'Cougar', 'ro');
INSERT INTO class_model VALUES ('1006', '72', 'Cougar', 'eng');
INSERT INTO class_model VALUES ('1006', '72', 'Cougar', 'german');
INSERT INTO class_model VALUES ('1007', '72', 'Marauder', 'ro');
INSERT INTO class_model VALUES ('1007', '72', 'Marauder', 'eng');
INSERT INTO class_model VALUES ('1007', '72', 'Marauder', 'german');
INSERT INTO class_model VALUES ('1008', '72', 'Mariner', 'ro');
INSERT INTO class_model VALUES ('1008', '72', 'Mariner', 'eng');
INSERT INTO class_model VALUES ('1008', '72', 'Mariner', 'german');
INSERT INTO class_model VALUES ('1009', '72', 'Marquis', 'ro');
INSERT INTO class_model VALUES ('1009', '72', 'Marquis', 'eng');
INSERT INTO class_model VALUES ('1009', '72', 'Marquis', 'german');
INSERT INTO class_model VALUES ('1010', '72', 'Milan', 'ro');
INSERT INTO class_model VALUES ('1010', '72', 'Milan', 'eng');
INSERT INTO class_model VALUES ('1010', '72', 'Milan', 'german');
INSERT INTO class_model VALUES ('1011', '72', 'Montego', 'ro');
INSERT INTO class_model VALUES ('1011', '72', 'Montego', 'eng');
INSERT INTO class_model VALUES ('1011', '72', 'Montego', 'german');
INSERT INTO class_model VALUES ('1012', '72', 'Monterey', 'ro');
INSERT INTO class_model VALUES ('1012', '72', 'Monterey', 'eng');
INSERT INTO class_model VALUES ('1012', '72', 'Monterey', 'german');
INSERT INTO class_model VALUES ('1013', '72', 'Mountaineer', 'ro');
INSERT INTO class_model VALUES ('1013', '72', 'Mountaineer', 'eng');
INSERT INTO class_model VALUES ('1013', '72', 'Mountaineer', 'german');
INSERT INTO class_model VALUES ('1014', '72', 'Sable', 'ro');
INSERT INTO class_model VALUES ('1014', '72', 'Sable', 'eng');
INSERT INTO class_model VALUES ('1014', '72', 'Sable', 'german');
INSERT INTO class_model VALUES ('1015', '72', 'Tracer', 'ro');
INSERT INTO class_model VALUES ('1015', '72', 'Tracer', 'eng');
INSERT INTO class_model VALUES ('1015', '72', 'Tracer', 'german');
INSERT INTO class_model VALUES ('1016', '72', 'Villager', 'ro');
INSERT INTO class_model VALUES ('1016', '72', 'Villager', 'eng');
INSERT INTO class_model VALUES ('1016', '72', 'Villager', 'german');
INSERT INTO class_model VALUES ('1017', '72', 'Zephyr', 'ro');
INSERT INTO class_model VALUES ('1017', '72', 'Zephyr', 'eng');
INSERT INTO class_model VALUES ('1017', '72', 'Zephyr', 'german');
INSERT INTO class_model VALUES ('1018', '73', 'F', 'ro');
INSERT INTO class_model VALUES ('1018', '73', 'F', 'eng');
INSERT INTO class_model VALUES ('1018', '73', 'F', 'german');
INSERT INTO class_model VALUES ('1019', '73', 'MGA', 'ro');
INSERT INTO class_model VALUES ('1019', '73', 'MGA', 'eng');
INSERT INTO class_model VALUES ('1019', '73', 'MGA', 'german');
INSERT INTO class_model VALUES ('1020', '73', 'MGB', 'ro');
INSERT INTO class_model VALUES ('1020', '73', 'MGB', 'eng');
INSERT INTO class_model VALUES ('1020', '73', 'MGB', 'german');
INSERT INTO class_model VALUES ('1021', '73', 'MGF', 'ro');
INSERT INTO class_model VALUES ('1021', '73', 'MGF', 'eng');
INSERT INTO class_model VALUES ('1021', '73', 'MGF', 'german');
INSERT INTO class_model VALUES ('1022', '73', 'Midget', 'ro');
INSERT INTO class_model VALUES ('1022', '73', 'Midget', 'eng');
INSERT INTO class_model VALUES ('1022', '73', 'Midget', 'german');
INSERT INTO class_model VALUES ('1023', '73', 'Montego', 'ro');
INSERT INTO class_model VALUES ('1023', '73', 'Montego', 'eng');
INSERT INTO class_model VALUES ('1023', '73', 'Montego', 'german');
INSERT INTO class_model VALUES ('1024', '73', 'TD', 'ro');
INSERT INTO class_model VALUES ('1024', '73', 'TD', 'eng');
INSERT INTO class_model VALUES ('1024', '73', 'TD', 'german');
INSERT INTO class_model VALUES ('1025', '73', 'TF', 'ro');
INSERT INTO class_model VALUES ('1025', '73', 'TF', 'eng');
INSERT INTO class_model VALUES ('1025', '73', 'TF', 'german');
INSERT INTO class_model VALUES ('1026', '73', 'ZR', 'ro');
INSERT INTO class_model VALUES ('1026', '73', 'ZR', 'eng');
INSERT INTO class_model VALUES ('1026', '73', 'ZR', 'german');
INSERT INTO class_model VALUES ('1027', '73', 'ZS', 'ro');
INSERT INTO class_model VALUES ('1027', '73', 'ZS', 'eng');
INSERT INTO class_model VALUES ('1027', '73', 'ZS', 'german');
INSERT INTO class_model VALUES ('1028', '73', 'ZT', 'ro');
INSERT INTO class_model VALUES ('1028', '73', 'ZT', 'eng');
INSERT INTO class_model VALUES ('1028', '73', 'ZT', 'german');
INSERT INTO class_model VALUES ('1029', '74', 'M.GO', 'ro');
INSERT INTO class_model VALUES ('1029', '74', 'M.GO', 'eng');
INSERT INTO class_model VALUES ('1029', '74', 'M.GO', 'german');
INSERT INTO class_model VALUES ('1030', '75', '1000', 'ro');
INSERT INTO class_model VALUES ('1030', '75', '1000', 'eng');
INSERT INTO class_model VALUES ('1030', '75', '1000', 'german');
INSERT INTO class_model VALUES ('1031', '75', '1300', 'ro');
INSERT INTO class_model VALUES ('1031', '75', '1300', 'eng');
INSERT INTO class_model VALUES ('1031', '75', '1300', 'german');
INSERT INTO class_model VALUES ('1032', '75', 'Clubman', 'ro');
INSERT INTO class_model VALUES ('1032', '75', 'Clubman', 'eng');
INSERT INTO class_model VALUES ('1032', '75', 'Clubman', 'german');
INSERT INTO class_model VALUES ('1033', '75', 'Cooper', 'ro');
INSERT INTO class_model VALUES ('1033', '75', 'Cooper', 'eng');
INSERT INTO class_model VALUES ('1033', '75', 'Cooper', 'german');
INSERT INTO class_model VALUES ('1034', '75', 'Cooper S', 'ro');
INSERT INTO class_model VALUES ('1034', '75', 'Cooper S', 'eng');
INSERT INTO class_model VALUES ('1034', '75', 'Cooper S', 'german');
INSERT INTO class_model VALUES ('1035', '75', 'Countryman', 'ro');
INSERT INTO class_model VALUES ('1035', '75', 'Countryman', 'eng');
INSERT INTO class_model VALUES ('1035', '75', 'Countryman', 'german');
INSERT INTO class_model VALUES ('1036', '75', 'ONE', 'ro');
INSERT INTO class_model VALUES ('1036', '75', 'ONE', 'eng');
INSERT INTO class_model VALUES ('1036', '75', 'ONE', 'german');
INSERT INTO class_model VALUES ('1037', '75', 'Paceman', 'ro');
INSERT INTO class_model VALUES ('1037', '75', 'Paceman', 'eng');
INSERT INTO class_model VALUES ('1037', '75', 'Paceman', 'german');
INSERT INTO class_model VALUES ('1038', '76', '3000 GT', 'ro');
INSERT INTO class_model VALUES ('1038', '76', '3000 GT', 'eng');
INSERT INTO class_model VALUES ('1038', '76', '3000 GT', 'german');
INSERT INTO class_model VALUES ('1039', '76', 'ASX', 'ro');
INSERT INTO class_model VALUES ('1039', '76', 'ASX', 'eng');
INSERT INTO class_model VALUES ('1039', '76', 'ASX', 'german');
INSERT INTO class_model VALUES ('1040', '76', 'Canter', 'ro');
INSERT INTO class_model VALUES ('1040', '76', 'Canter', 'eng');
INSERT INTO class_model VALUES ('1040', '76', 'Canter', 'german');
INSERT INTO class_model VALUES ('1041', '76', 'Carisma', 'ro');
INSERT INTO class_model VALUES ('1041', '76', 'Carisma', 'eng');
INSERT INTO class_model VALUES ('1041', '76', 'Carisma', 'german');
INSERT INTO class_model VALUES ('1042', '76', 'Colt', 'ro');
INSERT INTO class_model VALUES ('1042', '76', 'Colt', 'eng');
INSERT INTO class_model VALUES ('1042', '76', 'Colt', 'german');
INSERT INTO class_model VALUES ('1043', '76', 'Cordia', 'ro');
INSERT INTO class_model VALUES ('1043', '76', 'Cordia', 'eng');
INSERT INTO class_model VALUES ('1043', '76', 'Cordia', 'german');
INSERT INTO class_model VALUES ('1044', '76', 'Cosmos', 'ro');
INSERT INTO class_model VALUES ('1044', '76', 'Cosmos', 'eng');
INSERT INTO class_model VALUES ('1044', '76', 'Cosmos', 'german');
INSERT INTO class_model VALUES ('1045', '76', 'Diamante', 'ro');
INSERT INTO class_model VALUES ('1045', '76', 'Diamante', 'eng');
INSERT INTO class_model VALUES ('1045', '76', 'Diamante', 'german');
INSERT INTO class_model VALUES ('1046', '76', 'Eclipse', 'ro');
INSERT INTO class_model VALUES ('1046', '76', 'Eclipse', 'eng');
INSERT INTO class_model VALUES ('1046', '76', 'Eclipse', 'german');
INSERT INTO class_model VALUES ('1047', '76', 'Endeavor', 'ro');
INSERT INTO class_model VALUES ('1047', '76', 'Endeavor', 'eng');
INSERT INTO class_model VALUES ('1047', '76', 'Endeavor', 'german');
INSERT INTO class_model VALUES ('1048', '76', 'FTO', 'ro');
INSERT INTO class_model VALUES ('1048', '76', 'FTO', 'eng');
INSERT INTO class_model VALUES ('1048', '76', 'FTO', 'german');
INSERT INTO class_model VALUES ('1049', '76', 'Galant', 'ro');
INSERT INTO class_model VALUES ('1049', '76', 'Galant', 'eng');
INSERT INTO class_model VALUES ('1049', '76', 'Galant', 'german');
INSERT INTO class_model VALUES ('1050', '76', 'Galloper', 'ro');
INSERT INTO class_model VALUES ('1050', '76', 'Galloper', 'eng');
INSERT INTO class_model VALUES ('1050', '76', 'Galloper', 'german');
INSERT INTO class_model VALUES ('1051', '76', 'Grandis', 'ro');
INSERT INTO class_model VALUES ('1051', '76', 'Grandis', 'eng');
INSERT INTO class_model VALUES ('1051', '76', 'Grandis', 'german');
INSERT INTO class_model VALUES ('1052', '76', 'L200', 'ro');
INSERT INTO class_model VALUES ('1052', '76', 'L200', 'eng');
INSERT INTO class_model VALUES ('1052', '76', 'L200', 'german');
INSERT INTO class_model VALUES ('1053', '76', 'L300', 'ro');
INSERT INTO class_model VALUES ('1053', '76', 'L300', 'eng');
INSERT INTO class_model VALUES ('1053', '76', 'L300', 'german');
INSERT INTO class_model VALUES ('1054', '76', 'L400', 'ro');
INSERT INTO class_model VALUES ('1054', '76', 'L400', 'eng');
INSERT INTO class_model VALUES ('1054', '76', 'L400', 'german');
INSERT INTO class_model VALUES ('1055', '76', 'Lancer', 'ro');
INSERT INTO class_model VALUES ('1055', '76', 'Lancer', 'eng');
INSERT INTO class_model VALUES ('1055', '76', 'Lancer', 'german');
INSERT INTO class_model VALUES ('1056', '76', 'Lancer EVO', 'ro');
INSERT INTO class_model VALUES ('1056', '76', 'Lancer EVO', 'eng');
INSERT INTO class_model VALUES ('1056', '76', 'Lancer EVO', 'german');
INSERT INTO class_model VALUES ('1057', '76', 'Montero', 'ro');
INSERT INTO class_model VALUES ('1057', '76', 'Montero', 'eng');
INSERT INTO class_model VALUES ('1057', '76', 'Montero', 'german');
INSERT INTO class_model VALUES ('1058', '76', 'Outlander', 'ro');
INSERT INTO class_model VALUES ('1058', '76', 'Outlander', 'eng');
INSERT INTO class_model VALUES ('1058', '76', 'Outlander', 'german');
INSERT INTO class_model VALUES ('1059', '76', 'Pajero', 'ro');
INSERT INTO class_model VALUES ('1059', '76', 'Pajero', 'eng');
INSERT INTO class_model VALUES ('1059', '76', 'Pajero', 'german');
INSERT INTO class_model VALUES ('1060', '76', 'Pajero Pinin', 'ro');
INSERT INTO class_model VALUES ('1060', '76', 'Pajero Pinin', 'eng');
INSERT INTO class_model VALUES ('1060', '76', 'Pajero Pinin', 'german');
INSERT INTO class_model VALUES ('1061', '76', 'Santamo', 'ro');
INSERT INTO class_model VALUES ('1061', '76', 'Santamo', 'eng');
INSERT INTO class_model VALUES ('1061', '76', 'Santamo', 'german');
INSERT INTO class_model VALUES ('1062', '76', 'Sapporo', 'ro');
INSERT INTO class_model VALUES ('1062', '76', 'Sapporo', 'eng');
INSERT INTO class_model VALUES ('1062', '76', 'Sapporo', 'german');
INSERT INTO class_model VALUES ('1063', '76', 'Sigma', 'ro');
INSERT INTO class_model VALUES ('1063', '76', 'Sigma', 'eng');
INSERT INTO class_model VALUES ('1063', '76', 'Sigma', 'german');
INSERT INTO class_model VALUES ('1064', '76', 'Space Gear', 'ro');
INSERT INTO class_model VALUES ('1064', '76', 'Space Gear', 'eng');
INSERT INTO class_model VALUES ('1064', '76', 'Space Gear', 'german');
INSERT INTO class_model VALUES ('1065', '76', 'Space Runner', 'ro');
INSERT INTO class_model VALUES ('1065', '76', 'Space Runner', 'eng');
INSERT INTO class_model VALUES ('1065', '76', 'Space Runner', 'german');
INSERT INTO class_model VALUES ('1066', '76', 'Space Star', 'ro');
INSERT INTO class_model VALUES ('1066', '76', 'Space Star', 'eng');
INSERT INTO class_model VALUES ('1066', '76', 'Space Star', 'german');
INSERT INTO class_model VALUES ('1067', '76', 'Space Wagon', 'ro');
INSERT INTO class_model VALUES ('1067', '76', 'Space Wagon', 'eng');
INSERT INTO class_model VALUES ('1067', '76', 'Space Wagon', 'german');
INSERT INTO class_model VALUES ('1068', '76', 'Starion', 'ro');
INSERT INTO class_model VALUES ('1068', '76', 'Starion', 'eng');
INSERT INTO class_model VALUES ('1068', '76', 'Starion', 'german');
INSERT INTO class_model VALUES ('1069', '76', 'Tredia', 'ro');
INSERT INTO class_model VALUES ('1069', '76', 'Tredia', 'eng');
INSERT INTO class_model VALUES ('1069', '76', 'Tredia', 'german');
INSERT INTO class_model VALUES ('1070', '76', 'i-MiEV', 'ro');
INSERT INTO class_model VALUES ('1070', '76', 'i-MiEV', 'eng');
INSERT INTO class_model VALUES ('1070', '76', 'i-MiEV', 'german');
INSERT INTO class_model VALUES ('1071', '77', 'Aero 8', 'ro');
INSERT INTO class_model VALUES ('1071', '77', 'Aero 8', 'eng');
INSERT INTO class_model VALUES ('1071', '77', 'Aero 8', 'german');
INSERT INTO class_model VALUES ('1072', '77', 'Plus 4', 'ro');
INSERT INTO class_model VALUES ('1072', '77', 'Plus 4', 'eng');
INSERT INTO class_model VALUES ('1072', '77', 'Plus 4', 'german');
INSERT INTO class_model VALUES ('1073', '77', 'Plus 8', 'ro');
INSERT INTO class_model VALUES ('1073', '77', 'Plus 8', 'eng');
INSERT INTO class_model VALUES ('1073', '77', 'Plus 8', 'german');
INSERT INTO class_model VALUES ('1074', '77', 'Roadster', 'ro');
INSERT INTO class_model VALUES ('1074', '77', 'Roadster', 'eng');
INSERT INTO class_model VALUES ('1074', '77', 'Roadster', 'german');
INSERT INTO class_model VALUES ('1075', '78', '1500', 'ro');
INSERT INTO class_model VALUES ('1075', '78', '1500', 'eng');
INSERT INTO class_model VALUES ('1075', '78', '1500', 'german');
INSERT INTO class_model VALUES ('1076', '78', '2138', 'ro');
INSERT INTO class_model VALUES ('1076', '78', '2138', 'eng');
INSERT INTO class_model VALUES ('1076', '78', '2138', 'german');
INSERT INTO class_model VALUES ('1077', '78', '2140', 'ro');
INSERT INTO class_model VALUES ('1077', '78', '2140', 'eng');
INSERT INTO class_model VALUES ('1077', '78', '2140', 'german');
INSERT INTO class_model VALUES ('1078', '78', '2141', 'ro');
INSERT INTO class_model VALUES ('1078', '78', '2141', 'eng');
INSERT INTO class_model VALUES ('1078', '78', '2141', 'german');
INSERT INTO class_model VALUES ('1079', '78', '2142', 'ro');
INSERT INTO class_model VALUES ('1079', '78', '2142', 'eng');
INSERT INTO class_model VALUES ('1079', '78', '2142', 'german');
INSERT INTO class_model VALUES ('1080', '78', '400', 'ro');
INSERT INTO class_model VALUES ('1080', '78', '400', 'eng');
INSERT INTO class_model VALUES ('1080', '78', '400', 'german');
INSERT INTO class_model VALUES ('1081', '78', '401', 'ro');
INSERT INTO class_model VALUES ('1081', '78', '401', 'eng');
INSERT INTO class_model VALUES ('1081', '78', '401', 'german');
INSERT INTO class_model VALUES ('1082', '78', '402', 'ro');
INSERT INTO class_model VALUES ('1082', '78', '402', 'eng');
INSERT INTO class_model VALUES ('1082', '78', '402', 'german');
INSERT INTO class_model VALUES ('1083', '78', '403', 'ro');
INSERT INTO class_model VALUES ('1083', '78', '403', 'eng');
INSERT INTO class_model VALUES ('1083', '78', '403', 'german');
INSERT INTO class_model VALUES ('1084', '78', '404', 'ro');
INSERT INTO class_model VALUES ('1084', '78', '404', 'eng');
INSERT INTO class_model VALUES ('1084', '78', '404', 'german');
INSERT INTO class_model VALUES ('1085', '78', '407', 'ro');
INSERT INTO class_model VALUES ('1085', '78', '407', 'eng');
INSERT INTO class_model VALUES ('1085', '78', '407', 'german');
INSERT INTO class_model VALUES ('1086', '78', '408', 'ro');
INSERT INTO class_model VALUES ('1086', '78', '408', 'eng');
INSERT INTO class_model VALUES ('1086', '78', '408', 'german');
INSERT INTO class_model VALUES ('1087', '78', '410', 'ro');
INSERT INTO class_model VALUES ('1087', '78', '410', 'eng');
INSERT INTO class_model VALUES ('1087', '78', '410', 'german');
INSERT INTO class_model VALUES ('1088', '78', '411', 'ro');
INSERT INTO class_model VALUES ('1088', '78', '411', 'eng');
INSERT INTO class_model VALUES ('1088', '78', '411', 'german');
INSERT INTO class_model VALUES ('1089', '78', '412', 'ro');
INSERT INTO class_model VALUES ('1089', '78', '412', 'eng');
INSERT INTO class_model VALUES ('1089', '78', '412', 'german');
INSERT INTO class_model VALUES ('1090', '78', '415', 'ro');
INSERT INTO class_model VALUES ('1090', '78', '415', 'eng');
INSERT INTO class_model VALUES ('1090', '78', '415', 'german');
INSERT INTO class_model VALUES ('1091', '78', '416', 'ro');
INSERT INTO class_model VALUES ('1091', '78', '416', 'eng');
INSERT INTO class_model VALUES ('1091', '78', '416', 'german');
INSERT INTO class_model VALUES ('1092', '78', '420', 'ro');
INSERT INTO class_model VALUES ('1092', '78', '420', 'eng');
INSERT INTO class_model VALUES ('1092', '78', '420', 'german');
INSERT INTO class_model VALUES ('1093', '78', '422', 'ro');
INSERT INTO class_model VALUES ('1093', '78', '422', 'eng');
INSERT INTO class_model VALUES ('1093', '78', '422', 'german');
INSERT INTO class_model VALUES ('1094', '78', '423', 'ro');
INSERT INTO class_model VALUES ('1094', '78', '423', 'eng');
INSERT INTO class_model VALUES ('1094', '78', '423', 'german');
INSERT INTO class_model VALUES ('1095', '78', '426', 'ro');
INSERT INTO class_model VALUES ('1095', '78', '426', 'eng');
INSERT INTO class_model VALUES ('1095', '78', '426', 'german');
INSERT INTO class_model VALUES ('1096', '78', '427', 'ro');
INSERT INTO class_model VALUES ('1096', '78', '427', 'eng');
INSERT INTO class_model VALUES ('1096', '78', '427', 'german');
INSERT INTO class_model VALUES ('1097', '78', '432', 'ro');
INSERT INTO class_model VALUES ('1097', '78', '432', 'eng');
INSERT INTO class_model VALUES ('1097', '78', '432', 'german');
INSERT INTO class_model VALUES ('1098', '78', '433', 'ro');
INSERT INTO class_model VALUES ('1098', '78', '433', 'eng');
INSERT INTO class_model VALUES ('1098', '78', '433', 'german');
INSERT INTO class_model VALUES ('1099', '78', '434', 'ro');
INSERT INTO class_model VALUES ('1099', '78', '434', 'eng');
INSERT INTO class_model VALUES ('1099', '78', '434', 'german');
INSERT INTO class_model VALUES ('1100', '78', '444', 'ro');
INSERT INTO class_model VALUES ('1100', '78', '444', 'eng');
INSERT INTO class_model VALUES ('1100', '78', '444', 'german');
INSERT INTO class_model VALUES ('1101', '78', 'Aleko', 'ro');
INSERT INTO class_model VALUES ('1101', '78', 'Aleko', 'eng');
INSERT INTO class_model VALUES ('1101', '78', 'Aleko', 'german');
INSERT INTO class_model VALUES ('1102', '78', 'G1', 'ro');
INSERT INTO class_model VALUES ('1102', '78', 'G1', 'eng');
INSERT INTO class_model VALUES ('1102', '78', 'G1', 'german');
INSERT INTO class_model VALUES ('1103', '78', 'G2', 'ro');
INSERT INTO class_model VALUES ('1103', '78', 'G2', 'eng');
INSERT INTO class_model VALUES ('1103', '78', 'G2', 'german');
INSERT INTO class_model VALUES ('1104', '78', 'G3', 'ro');
INSERT INTO class_model VALUES ('1104', '78', 'G3', 'eng');
INSERT INTO class_model VALUES ('1104', '78', 'G3', 'german');
INSERT INTO class_model VALUES ('1105', '78', 'G4', 'ro');
INSERT INTO class_model VALUES ('1105', '78', 'G4', 'eng');
INSERT INTO class_model VALUES ('1105', '78', 'G4', 'german');
INSERT INTO class_model VALUES ('1106', '78', 'G5', 'ro');
INSERT INTO class_model VALUES ('1106', '78', 'G5', 'eng');
INSERT INTO class_model VALUES ('1106', '78', 'G5', 'german');
INSERT INTO class_model VALUES ('1107', '79', '100 NX', 'ro');
INSERT INTO class_model VALUES ('1107', '79', '100 NX', 'eng');
INSERT INTO class_model VALUES ('1107', '79', '100 NX', 'german');
INSERT INTO class_model VALUES ('1108', '79', '200 SX', 'ro');
INSERT INTO class_model VALUES ('1108', '79', '200 SX', 'eng');
INSERT INTO class_model VALUES ('1108', '79', '200 SX', 'german');
INSERT INTO class_model VALUES ('1109', '79', '240 SX', 'ro');
INSERT INTO class_model VALUES ('1109', '79', '240 SX', 'eng');
INSERT INTO class_model VALUES ('1109', '79', '240 SX', 'german');
INSERT INTO class_model VALUES ('1110', '79', '280 ZX', 'ro');
INSERT INTO class_model VALUES ('1110', '79', '280 ZX', 'eng');
INSERT INTO class_model VALUES ('1110', '79', '280 ZX', 'german');
INSERT INTO class_model VALUES ('1111', '79', '300 ZX', 'ro');
INSERT INTO class_model VALUES ('1111', '79', '300 ZX', 'eng');
INSERT INTO class_model VALUES ('1111', '79', '300 ZX', 'german');
INSERT INTO class_model VALUES ('1112', '79', '350 Z', 'ro');
INSERT INTO class_model VALUES ('1112', '79', '350 Z', 'eng');
INSERT INTO class_model VALUES ('1112', '79', '350 Z', 'german');
INSERT INTO class_model VALUES ('1113', '79', '370 Z', 'ro');
INSERT INTO class_model VALUES ('1113', '79', '370 Z', 'eng');
INSERT INTO class_model VALUES ('1113', '79', '370 Z', 'german');
INSERT INTO class_model VALUES ('1114', '79', 'Almera', 'ro');
INSERT INTO class_model VALUES ('1114', '79', 'Almera', 'eng');
INSERT INTO class_model VALUES ('1114', '79', 'Almera', 'german');
INSERT INTO class_model VALUES ('1115', '79', 'Almera Tino', 'ro');
INSERT INTO class_model VALUES ('1115', '79', 'Almera Tino', 'eng');
INSERT INTO class_model VALUES ('1115', '79', 'Almera Tino', 'german');
INSERT INTO class_model VALUES ('1116', '79', 'Altima', 'ro');
INSERT INTO class_model VALUES ('1116', '79', 'Altima', 'eng');
INSERT INTO class_model VALUES ('1116', '79', 'Altima', 'german');
INSERT INTO class_model VALUES ('1117', '79', 'Armada', 'ro');
INSERT INTO class_model VALUES ('1117', '79', 'Armada', 'eng');
INSERT INTO class_model VALUES ('1117', '79', 'Armada', 'german');
INSERT INTO class_model VALUES ('1118', '79', 'Bluebird', 'ro');
INSERT INTO class_model VALUES ('1118', '79', 'Bluebird', 'eng');
INSERT INTO class_model VALUES ('1118', '79', 'Bluebird', 'german');
INSERT INTO class_model VALUES ('1119', '79', 'Cherry', 'ro');
INSERT INTO class_model VALUES ('1119', '79', 'Cherry', 'eng');
INSERT INTO class_model VALUES ('1119', '79', 'Cherry', 'german');
INSERT INTO class_model VALUES ('1120', '79', 'Cube', 'ro');
INSERT INTO class_model VALUES ('1120', '79', 'Cube', 'eng');
INSERT INTO class_model VALUES ('1120', '79', 'Cube', 'german');
INSERT INTO class_model VALUES ('1121', '79', 'Frontier', 'ro');
INSERT INTO class_model VALUES ('1121', '79', 'Frontier', 'eng');
INSERT INTO class_model VALUES ('1121', '79', 'Frontier', 'german');
INSERT INTO class_model VALUES ('1122', '79', 'GT-R', 'ro');
INSERT INTO class_model VALUES ('1122', '79', 'GT-R', 'eng');
INSERT INTO class_model VALUES ('1122', '79', 'GT-R', 'german');
INSERT INTO class_model VALUES ('1123', '79', 'Interstar', 'ro');
INSERT INTO class_model VALUES ('1123', '79', 'Interstar', 'eng');
INSERT INTO class_model VALUES ('1123', '79', 'Interstar', 'german');
INSERT INTO class_model VALUES ('1124', '79', 'Juke', 'ro');
INSERT INTO class_model VALUES ('1124', '79', 'Juke', 'eng');
INSERT INTO class_model VALUES ('1124', '79', 'Juke', 'german');
INSERT INTO class_model VALUES ('1125', '79', 'King Cab', 'ro');
INSERT INTO class_model VALUES ('1125', '79', 'King Cab', 'eng');
INSERT INTO class_model VALUES ('1125', '79', 'King Cab', 'german');
INSERT INTO class_model VALUES ('1126', '79', 'Kubistar', 'ro');
INSERT INTO class_model VALUES ('1126', '79', 'Kubistar', 'eng');
INSERT INTO class_model VALUES ('1126', '79', 'Kubistar', 'german');
INSERT INTO class_model VALUES ('1127', '79', 'Laurel', 'ro');
INSERT INTO class_model VALUES ('1127', '79', 'Laurel', 'eng');
INSERT INTO class_model VALUES ('1127', '79', 'Laurel', 'german');
INSERT INTO class_model VALUES ('1128', '79', 'Maxima', 'ro');
INSERT INTO class_model VALUES ('1128', '79', 'Maxima', 'eng');
INSERT INTO class_model VALUES ('1128', '79', 'Maxima', 'german');
INSERT INTO class_model VALUES ('1129', '79', 'Micra', 'ro');
INSERT INTO class_model VALUES ('1129', '79', 'Micra', 'eng');
INSERT INTO class_model VALUES ('1129', '79', 'Micra', 'german');
INSERT INTO class_model VALUES ('1130', '79', 'Murano', 'ro');
INSERT INTO class_model VALUES ('1130', '79', 'Murano', 'eng');
INSERT INTO class_model VALUES ('1130', '79', 'Murano', 'german');
INSERT INTO class_model VALUES ('1131', '79', 'NP300 Pickup', 'ro');
INSERT INTO class_model VALUES ('1131', '79', 'NP300 Pickup', 'eng');
INSERT INTO class_model VALUES ('1131', '79', 'NP300 Pickup', 'german');
INSERT INTO class_model VALUES ('1132', '79', 'NV200', 'ro');
INSERT INTO class_model VALUES ('1132', '79', 'NV200', 'eng');
INSERT INTO class_model VALUES ('1132', '79', 'NV200', 'german');
INSERT INTO class_model VALUES ('1133', '79', 'Navara', 'ro');
INSERT INTO class_model VALUES ('1133', '79', 'Navara', 'eng');
INSERT INTO class_model VALUES ('1133', '79', 'Navara', 'german');
INSERT INTO class_model VALUES ('1134', '79', 'Note', 'ro');
INSERT INTO class_model VALUES ('1134', '79', 'Note', 'eng');
INSERT INTO class_model VALUES ('1134', '79', 'Note', 'german');
INSERT INTO class_model VALUES ('1135', '79', 'Pathfinder', 'ro');
INSERT INTO class_model VALUES ('1135', '79', 'Pathfinder', 'eng');
INSERT INTO class_model VALUES ('1135', '79', 'Pathfinder', 'german');
INSERT INTO class_model VALUES ('1136', '79', 'Patrol', 'ro');
INSERT INTO class_model VALUES ('1136', '79', 'Patrol', 'eng');
INSERT INTO class_model VALUES ('1136', '79', 'Patrol', 'german');
INSERT INTO class_model VALUES ('1137', '79', 'Pickup', 'ro');
INSERT INTO class_model VALUES ('1137', '79', 'Pickup', 'eng');
INSERT INTO class_model VALUES ('1137', '79', 'Pickup', 'german');
INSERT INTO class_model VALUES ('1138', '79', 'Pixo', 'ro');
INSERT INTO class_model VALUES ('1138', '79', 'Pixo', 'eng');
INSERT INTO class_model VALUES ('1138', '79', 'Pixo', 'german');
INSERT INTO class_model VALUES ('1139', '79', 'Prairie', 'ro');
INSERT INTO class_model VALUES ('1139', '79', 'Prairie', 'eng');
INSERT INTO class_model VALUES ('1139', '79', 'Prairie', 'german');
INSERT INTO class_model VALUES ('1140', '79', 'Primastar', 'ro');
INSERT INTO class_model VALUES ('1140', '79', 'Primastar', 'eng');
INSERT INTO class_model VALUES ('1140', '79', 'Primastar', 'german');
INSERT INTO class_model VALUES ('1141', '79', 'Primera', 'ro');
INSERT INTO class_model VALUES ('1141', '79', 'Primera', 'eng');
INSERT INTO class_model VALUES ('1141', '79', 'Primera', 'german');
INSERT INTO class_model VALUES ('1142', '79', 'Pulsar', 'ro');
INSERT INTO class_model VALUES ('1142', '79', 'Pulsar', 'eng');
INSERT INTO class_model VALUES ('1142', '79', 'Pulsar', 'german');
INSERT INTO class_model VALUES ('1143', '79', 'Qashqi', 'ro');
INSERT INTO class_model VALUES ('1143', '79', 'Qashqi', 'eng');
INSERT INTO class_model VALUES ('1143', '79', 'Qashqi', 'german');
INSERT INTO class_model VALUES ('1144', '79', 'Quest', 'ro');
INSERT INTO class_model VALUES ('1144', '79', 'Quest', 'eng');
INSERT INTO class_model VALUES ('1144', '79', 'Quest', 'german');
INSERT INTO class_model VALUES ('1145', '79', 'Rogue', 'ro');
INSERT INTO class_model VALUES ('1145', '79', 'Rogue', 'eng');
INSERT INTO class_model VALUES ('1145', '79', 'Rogue', 'german');
INSERT INTO class_model VALUES ('1146', '79', 'Sentra', 'ro');
INSERT INTO class_model VALUES ('1146', '79', 'Sentra', 'eng');
INSERT INTO class_model VALUES ('1146', '79', 'Sentra', 'german');
INSERT INTO class_model VALUES ('1147', '79', 'Serena', 'ro');
INSERT INTO class_model VALUES ('1147', '79', 'Serena', 'eng');
INSERT INTO class_model VALUES ('1147', '79', 'Serena', 'german');
INSERT INTO class_model VALUES ('1148', '79', 'Silvia', 'ro');
INSERT INTO class_model VALUES ('1148', '79', 'Silvia', 'eng');
INSERT INTO class_model VALUES ('1148', '79', 'Silvia', 'german');
INSERT INTO class_model VALUES ('1149', '79', 'Skyline', 'ro');
INSERT INTO class_model VALUES ('1149', '79', 'Skyline', 'eng');
INSERT INTO class_model VALUES ('1149', '79', 'Skyline', 'german');
INSERT INTO class_model VALUES ('1150', '79', 'Stantza', 'ro');
INSERT INTO class_model VALUES ('1150', '79', 'Stantza', 'eng');
INSERT INTO class_model VALUES ('1150', '79', 'Stantza', 'german');
INSERT INTO class_model VALUES ('1151', '79', 'Sunny', 'ro');
INSERT INTO class_model VALUES ('1151', '79', 'Sunny', 'eng');
INSERT INTO class_model VALUES ('1151', '79', 'Sunny', 'german');
INSERT INTO class_model VALUES ('1152', '79', 'Terrano', 'ro');
INSERT INTO class_model VALUES ('1152', '79', 'Terrano', 'eng');
INSERT INTO class_model VALUES ('1152', '79', 'Terrano', 'german');
INSERT INTO class_model VALUES ('1153', '79', 'Tiida', 'ro');
INSERT INTO class_model VALUES ('1153', '79', 'Tiida', 'eng');
INSERT INTO class_model VALUES ('1153', '79', 'Tiida', 'german');
INSERT INTO class_model VALUES ('1154', '79', 'Trade', 'ro');
INSERT INTO class_model VALUES ('1154', '79', 'Trade', 'eng');
INSERT INTO class_model VALUES ('1154', '79', 'Trade', 'german');
INSERT INTO class_model VALUES ('1155', '79', 'Urvan', 'ro');
INSERT INTO class_model VALUES ('1155', '79', 'Urvan', 'eng');
INSERT INTO class_model VALUES ('1155', '79', 'Urvan', 'german');
INSERT INTO class_model VALUES ('1156', '79', 'Vanette', 'ro');
INSERT INTO class_model VALUES ('1156', '79', 'Vanette', 'eng');
INSERT INTO class_model VALUES ('1156', '79', 'Vanette', 'german');
INSERT INTO class_model VALUES ('1157', '79', 'X-trail', 'ro');
INSERT INTO class_model VALUES ('1157', '79', 'X-trail', 'eng');
INSERT INTO class_model VALUES ('1157', '79', 'X-trail', 'german');
INSERT INTO class_model VALUES ('1158', '79', 'Xterra', 'ro');
INSERT INTO class_model VALUES ('1158', '79', 'Xterra', 'eng');
INSERT INTO class_model VALUES ('1158', '79', 'Xterra', 'german');
INSERT INTO class_model VALUES ('1159', '80', '1000', 'ro');
INSERT INTO class_model VALUES ('1159', '80', '1000', 'eng');
INSERT INTO class_model VALUES ('1159', '80', '1000', 'german');
INSERT INTO class_model VALUES ('1160', '80', 'RO 80', 'ro');
INSERT INTO class_model VALUES ('1160', '80', 'RO 80', 'eng');
INSERT INTO class_model VALUES ('1160', '80', 'RO 80', 'german');
INSERT INTO class_model VALUES ('1161', '81', 'Seria 500', 'ro');
INSERT INTO class_model VALUES ('1161', '81', 'Seria 500', 'eng');
INSERT INTO class_model VALUES ('1161', '81', 'Seria 500', 'german');
INSERT INTO class_model VALUES ('1162', '81', 'Seria N', 'ro');
INSERT INTO class_model VALUES ('1162', '81', 'Seria N', 'eng');
INSERT INTO class_model VALUES ('1162', '81', 'Seria N', 'german');
INSERT INTO class_model VALUES ('1163', '82', 'Alero', 'ro');
INSERT INTO class_model VALUES ('1163', '82', 'Alero', 'eng');
INSERT INTO class_model VALUES ('1163', '82', 'Alero', 'german');
INSERT INTO class_model VALUES ('1164', '82', 'Aurora', 'ro');
INSERT INTO class_model VALUES ('1164', '82', 'Aurora', 'eng');
INSERT INTO class_model VALUES ('1164', '82', 'Aurora', 'german');
INSERT INTO class_model VALUES ('1165', '82', 'Bravada', 'ro');
INSERT INTO class_model VALUES ('1165', '82', 'Bravada', 'eng');
INSERT INTO class_model VALUES ('1165', '82', 'Bravada', 'german');
INSERT INTO class_model VALUES ('1166', '82', 'Custom Cruiser', 'ro');
INSERT INTO class_model VALUES ('1166', '82', 'Custom Cruiser', 'eng');
INSERT INTO class_model VALUES ('1166', '82', 'Custom Cruiser', 'german');
INSERT INTO class_model VALUES ('1167', '82', 'Cutlass', 'ro');
INSERT INTO class_model VALUES ('1167', '82', 'Cutlass', 'eng');
INSERT INTO class_model VALUES ('1167', '82', 'Cutlass', 'german');
INSERT INTO class_model VALUES ('1168', '82', 'Delta 88', 'ro');
INSERT INTO class_model VALUES ('1168', '82', 'Delta 88', 'eng');
INSERT INTO class_model VALUES ('1168', '82', 'Delta 88', 'german');
INSERT INTO class_model VALUES ('1169', '82', 'Eighty - Eight', 'ro');
INSERT INTO class_model VALUES ('1169', '82', 'Eighty - Eight', 'eng');
INSERT INTO class_model VALUES ('1169', '82', 'Eighty - Eight', 'german');
INSERT INTO class_model VALUES ('1170', '82', 'Intrigue', 'ro');
INSERT INTO class_model VALUES ('1170', '82', 'Intrigue', 'eng');
INSERT INTO class_model VALUES ('1170', '82', 'Intrigue', 'german');
INSERT INTO class_model VALUES ('1171', '82', 'Regency', 'ro');
INSERT INTO class_model VALUES ('1171', '82', 'Regency', 'eng');
INSERT INTO class_model VALUES ('1171', '82', 'Regency', 'german');
INSERT INTO class_model VALUES ('1172', '82', 'Silhouette', 'ro');
INSERT INTO class_model VALUES ('1172', '82', 'Silhouette', 'eng');
INSERT INTO class_model VALUES ('1172', '82', 'Silhouette', 'german');
INSERT INTO class_model VALUES ('1173', '82', 'Supreme', 'ro');
INSERT INTO class_model VALUES ('1173', '82', 'Supreme', 'eng');
INSERT INTO class_model VALUES ('1173', '82', 'Supreme', 'german');
INSERT INTO class_model VALUES ('1174', '82', 'Toronado', 'ro');
INSERT INTO class_model VALUES ('1174', '82', 'Toronado', 'eng');
INSERT INTO class_model VALUES ('1174', '82', 'Toronado', 'german');
INSERT INTO class_model VALUES ('1175', '83', 'Club', 'ro');
INSERT INTO class_model VALUES ('1175', '83', 'Club', 'eng');
INSERT INTO class_model VALUES ('1175', '83', 'Club', 'german');
INSERT INTO class_model VALUES ('1176', '83', 'Special', 'ro');
INSERT INTO class_model VALUES ('1176', '83', 'Special', 'eng');
INSERT INTO class_model VALUES ('1176', '83', 'Special', 'german');
INSERT INTO class_model VALUES ('1177', '84', 'Adam', 'ro');
INSERT INTO class_model VALUES ('1177', '84', 'Adam', 'eng');
INSERT INTO class_model VALUES ('1177', '84', 'Adam', 'german');
INSERT INTO class_model VALUES ('1178', '84', 'Agila', 'ro');
INSERT INTO class_model VALUES ('1178', '84', 'Agila', 'eng');
INSERT INTO class_model VALUES ('1178', '84', 'Agila', 'german');
INSERT INTO class_model VALUES ('1179', '84', 'Ampera', 'ro');
INSERT INTO class_model VALUES ('1179', '84', 'Ampera', 'eng');
INSERT INTO class_model VALUES ('1179', '84', 'Ampera', 'german');
INSERT INTO class_model VALUES ('1180', '84', 'Antara', 'ro');
INSERT INTO class_model VALUES ('1180', '84', 'Antara', 'eng');
INSERT INTO class_model VALUES ('1180', '84', 'Antara', 'german');
INSERT INTO class_model VALUES ('1181', '84', 'Arena', 'ro');
INSERT INTO class_model VALUES ('1181', '84', 'Arena', 'eng');
INSERT INTO class_model VALUES ('1181', '84', 'Arena', 'german');
INSERT INTO class_model VALUES ('1182', '84', 'Ascona', 'ro');
INSERT INTO class_model VALUES ('1182', '84', 'Ascona', 'eng');
INSERT INTO class_model VALUES ('1182', '84', 'Ascona', 'german');
INSERT INTO class_model VALUES ('1183', '84', 'Astra', 'ro');
INSERT INTO class_model VALUES ('1183', '84', 'Astra', 'eng');
INSERT INTO class_model VALUES ('1183', '84', 'Astra', 'german');
INSERT INTO class_model VALUES ('1184', '84', 'Calibra', 'ro');
INSERT INTO class_model VALUES ('1184', '84', 'Calibra', 'eng');
INSERT INTO class_model VALUES ('1184', '84', 'Calibra', 'german');
INSERT INTO class_model VALUES ('1185', '84', 'Campo', 'ro');
INSERT INTO class_model VALUES ('1185', '84', 'Campo', 'eng');
INSERT INTO class_model VALUES ('1185', '84', 'Campo', 'german');
INSERT INTO class_model VALUES ('1186', '84', 'Cascada', 'ro');
INSERT INTO class_model VALUES ('1186', '84', 'Cascada', 'eng');
INSERT INTO class_model VALUES ('1186', '84', 'Cascada', 'german');
INSERT INTO class_model VALUES ('1187', '84', 'Combo', 'ro');
INSERT INTO class_model VALUES ('1187', '84', 'Combo', 'eng');
INSERT INTO class_model VALUES ('1187', '84', 'Combo', 'german');
INSERT INTO class_model VALUES ('1188', '84', 'Commoder', 'ro');
INSERT INTO class_model VALUES ('1188', '84', 'Commoder', 'eng');
INSERT INTO class_model VALUES ('1188', '84', 'Commoder', 'german');
INSERT INTO class_model VALUES ('1189', '84', 'Corsa', 'ro');
INSERT INTO class_model VALUES ('1189', '84', 'Corsa', 'eng');
INSERT INTO class_model VALUES ('1189', '84', 'Corsa', 'german');
INSERT INTO class_model VALUES ('1190', '84', 'Diplomat', 'ro');
INSERT INTO class_model VALUES ('1190', '84', 'Diplomat', 'eng');
INSERT INTO class_model VALUES ('1190', '84', 'Diplomat', 'german');
INSERT INTO class_model VALUES ('1191', '84', 'Frontera', 'ro');
INSERT INTO class_model VALUES ('1191', '84', 'Frontera', 'eng');
INSERT INTO class_model VALUES ('1191', '84', 'Frontera', 'german');
INSERT INTO class_model VALUES ('1192', '84', 'GT', 'ro');
INSERT INTO class_model VALUES ('1192', '84', 'GT', 'eng');
INSERT INTO class_model VALUES ('1192', '84', 'GT', 'german');
INSERT INTO class_model VALUES ('1193', '84', 'Insignia', 'ro');
INSERT INTO class_model VALUES ('1193', '84', 'Insignia', 'eng');
INSERT INTO class_model VALUES ('1193', '84', 'Insignia', 'german');
INSERT INTO class_model VALUES ('1194', '84', 'Kadett', 'ro');
INSERT INTO class_model VALUES ('1194', '84', 'Kadett', 'eng');
INSERT INTO class_model VALUES ('1194', '84', 'Kadett', 'german');
INSERT INTO class_model VALUES ('1195', '84', 'Manta', 'ro');
INSERT INTO class_model VALUES ('1195', '84', 'Manta', 'eng');
INSERT INTO class_model VALUES ('1195', '84', 'Manta', 'german');
INSERT INTO class_model VALUES ('1196', '84', 'Meriva', 'ro');
INSERT INTO class_model VALUES ('1196', '84', 'Meriva', 'eng');
INSERT INTO class_model VALUES ('1196', '84', 'Meriva', 'german');
INSERT INTO class_model VALUES ('1197', '84', 'Mokka', 'ro');
INSERT INTO class_model VALUES ('1197', '84', 'Mokka', 'eng');
INSERT INTO class_model VALUES ('1197', '84', 'Mokka', 'german');
INSERT INTO class_model VALUES ('1198', '84', 'Monterey', 'ro');
INSERT INTO class_model VALUES ('1198', '84', 'Monterey', 'eng');
INSERT INTO class_model VALUES ('1198', '84', 'Monterey', 'german');
INSERT INTO class_model VALUES ('1199', '84', 'Monza', 'ro');
INSERT INTO class_model VALUES ('1199', '84', 'Monza', 'eng');
INSERT INTO class_model VALUES ('1199', '84', 'Monza', 'german');
INSERT INTO class_model VALUES ('1200', '84', 'Movano', 'ro');
INSERT INTO class_model VALUES ('1200', '84', 'Movano', 'eng');
INSERT INTO class_model VALUES ('1200', '84', 'Movano', 'german');
INSERT INTO class_model VALUES ('1201', '84', 'Nova', 'ro');
INSERT INTO class_model VALUES ('1201', '84', 'Nova', 'eng');
INSERT INTO class_model VALUES ('1201', '84', 'Nova', 'german');
INSERT INTO class_model VALUES ('1202', '84', 'Omega', 'ro');
INSERT INTO class_model VALUES ('1202', '84', 'Omega', 'eng');
INSERT INTO class_model VALUES ('1202', '84', 'Omega', 'german');
INSERT INTO class_model VALUES ('1203', '84', 'Pick up', 'ro');
INSERT INTO class_model VALUES ('1203', '84', 'Pick up', 'eng');
INSERT INTO class_model VALUES ('1203', '84', 'Pick up', 'german');
INSERT INTO class_model VALUES ('1204', '84', 'Sportcap', 'ro');
INSERT INTO class_model VALUES ('1204', '84', 'Sportcap', 'eng');
INSERT INTO class_model VALUES ('1204', '84', 'Sportcap', 'german');
INSERT INTO class_model VALUES ('1205', '84', 'Rekord', 'ro');
INSERT INTO class_model VALUES ('1205', '84', 'Rekord', 'eng');
INSERT INTO class_model VALUES ('1205', '84', 'Rekord', 'german');
INSERT INTO class_model VALUES ('1206', '84', 'Senator', 'ro');
INSERT INTO class_model VALUES ('1206', '84', 'Senator', 'eng');
INSERT INTO class_model VALUES ('1206', '84', 'Senator', 'german');
INSERT INTO class_model VALUES ('1207', '84', 'Signum', 'ro');
INSERT INTO class_model VALUES ('1207', '84', 'Signum', 'eng');
INSERT INTO class_model VALUES ('1207', '84', 'Signum', 'german');
INSERT INTO class_model VALUES ('1208', '84', 'Sintra', 'ro');
INSERT INTO class_model VALUES ('1208', '84', 'Sintra', 'eng');
INSERT INTO class_model VALUES ('1208', '84', 'Sintra', 'german');
INSERT INTO class_model VALUES ('1209', '84', 'Speedster', 'ro');
INSERT INTO class_model VALUES ('1209', '84', 'Speedster', 'eng');
INSERT INTO class_model VALUES ('1209', '84', 'Speedster', 'german');
INSERT INTO class_model VALUES ('1210', '84', 'Tigra', 'ro');
INSERT INTO class_model VALUES ('1210', '84', 'Tigra', 'eng');
INSERT INTO class_model VALUES ('1210', '84', 'Tigra', 'german');
INSERT INTO class_model VALUES ('1211', '84', 'Vectra', 'ro');
INSERT INTO class_model VALUES ('1211', '84', 'Vectra', 'eng');
INSERT INTO class_model VALUES ('1211', '84', 'Vectra', 'german');
INSERT INTO class_model VALUES ('1212', '84', 'Vivaro', 'ro');
INSERT INTO class_model VALUES ('1212', '84', 'Vivaro', 'eng');
INSERT INTO class_model VALUES ('1212', '84', 'Vivaro', 'german');
INSERT INTO class_model VALUES ('1213', '84', 'Zafira', 'ro');
INSERT INTO class_model VALUES ('1213', '84', 'Zafira', 'eng');
INSERT INTO class_model VALUES ('1213', '84', 'Zafira', 'german');
INSERT INTO class_model VALUES ('1214', '85', '1007', 'ro');
INSERT INTO class_model VALUES ('1214', '85', '1007', 'eng');
INSERT INTO class_model VALUES ('1214', '85', '1007', 'german');
INSERT INTO class_model VALUES ('1215', '85', '104', 'ro');
INSERT INTO class_model VALUES ('1215', '85', '104', 'eng');
INSERT INTO class_model VALUES ('1215', '85', '104', 'german');
INSERT INTO class_model VALUES ('1216', '85', '106', 'ro');
INSERT INTO class_model VALUES ('1216', '85', '106', 'eng');
INSERT INTO class_model VALUES ('1216', '85', '106', 'german');
INSERT INTO class_model VALUES ('1217', '85', '107', 'ro');
INSERT INTO class_model VALUES ('1217', '85', '107', 'eng');
INSERT INTO class_model VALUES ('1217', '85', '107', 'german');
INSERT INTO class_model VALUES ('1218', '85', '2008', 'ro');
INSERT INTO class_model VALUES ('1218', '85', '2008', 'eng');
INSERT INTO class_model VALUES ('1218', '85', '2008', 'german');
INSERT INTO class_model VALUES ('1219', '85', '204', 'ro');
INSERT INTO class_model VALUES ('1219', '85', '204', 'eng');
INSERT INTO class_model VALUES ('1219', '85', '204', 'german');
INSERT INTO class_model VALUES ('1220', '85', '205', 'ro');
INSERT INTO class_model VALUES ('1220', '85', '205', 'eng');
INSERT INTO class_model VALUES ('1220', '85', '205', 'german');
INSERT INTO class_model VALUES ('1221', '85', '206', 'ro');
INSERT INTO class_model VALUES ('1221', '85', '206', 'eng');
INSERT INTO class_model VALUES ('1221', '85', '206', 'german');
INSERT INTO class_model VALUES ('1222', '85', '206 CC', 'ro');
INSERT INTO class_model VALUES ('1222', '85', '206 CC', 'eng');
INSERT INTO class_model VALUES ('1222', '85', '206 CC', 'german');
INSERT INTO class_model VALUES ('1223', '85', '206 Plus', 'ro');
INSERT INTO class_model VALUES ('1223', '85', '206 Plus', 'eng');
INSERT INTO class_model VALUES ('1223', '85', '206 Plus', 'german');
INSERT INTO class_model VALUES ('1224', '85', '208', 'ro');
INSERT INTO class_model VALUES ('1224', '85', '208', 'eng');
INSERT INTO class_model VALUES ('1224', '85', '208', 'german');
INSERT INTO class_model VALUES ('1225', '85', '3008', 'ro');
INSERT INTO class_model VALUES ('1225', '85', '3008', 'eng');
INSERT INTO class_model VALUES ('1225', '85', '3008', 'german');
INSERT INTO class_model VALUES ('1226', '85', '301', 'ro');
INSERT INTO class_model VALUES ('1226', '85', '301', 'eng');
INSERT INTO class_model VALUES ('1226', '85', '301', 'german');
INSERT INTO class_model VALUES ('1227', '85', '304', 'ro');
INSERT INTO class_model VALUES ('1227', '85', '304', 'eng');
INSERT INTO class_model VALUES ('1227', '85', '304', 'german');
INSERT INTO class_model VALUES ('1228', '85', '305', 'ro');
INSERT INTO class_model VALUES ('1228', '85', '305', 'eng');
INSERT INTO class_model VALUES ('1228', '85', '305', 'german');
INSERT INTO class_model VALUES ('1229', '85', '306', 'ro');
INSERT INTO class_model VALUES ('1229', '85', '306', 'eng');
INSERT INTO class_model VALUES ('1229', '85', '306', 'german');
INSERT INTO class_model VALUES ('1230', '85', '307', 'ro');
INSERT INTO class_model VALUES ('1230', '85', '307', 'eng');
INSERT INTO class_model VALUES ('1230', '85', '307', 'german');
INSERT INTO class_model VALUES ('1231', '85', '307 CC', 'ro');
INSERT INTO class_model VALUES ('1231', '85', '307 CC', 'eng');
INSERT INTO class_model VALUES ('1231', '85', '307 CC', 'german');
INSERT INTO class_model VALUES ('1232', '85', '308', 'ro');
INSERT INTO class_model VALUES ('1232', '85', '308', 'eng');
INSERT INTO class_model VALUES ('1232', '85', '308', 'german');
INSERT INTO class_model VALUES ('1233', '85', '308 CC', 'ro');
INSERT INTO class_model VALUES ('1233', '85', '308 CC', 'eng');
INSERT INTO class_model VALUES ('1233', '85', '308 CC', 'german');
INSERT INTO class_model VALUES ('1234', '85', '309', 'ro');
INSERT INTO class_model VALUES ('1234', '85', '309', 'eng');
INSERT INTO class_model VALUES ('1234', '85', '309', 'german');
INSERT INTO class_model VALUES ('1235', '85', '395', 'ro');
INSERT INTO class_model VALUES ('1235', '85', '395', 'eng');
INSERT INTO class_model VALUES ('1235', '85', '395', 'german');
INSERT INTO class_model VALUES ('1236', '85', '4007', 'ro');
INSERT INTO class_model VALUES ('1236', '85', '4007', 'eng');
INSERT INTO class_model VALUES ('1236', '85', '4007', 'german');
INSERT INTO class_model VALUES ('1237', '85', '4008', 'ro');
INSERT INTO class_model VALUES ('1237', '85', '4008', 'eng');
INSERT INTO class_model VALUES ('1237', '85', '4008', 'german');
INSERT INTO class_model VALUES ('1238', '85', '404', 'ro');
INSERT INTO class_model VALUES ('1238', '85', '404', 'eng');
INSERT INTO class_model VALUES ('1238', '85', '404', 'german');
INSERT INTO class_model VALUES ('1239', '85', '405', 'ro');
INSERT INTO class_model VALUES ('1239', '85', '405', 'eng');
INSERT INTO class_model VALUES ('1239', '85', '405', 'german');
INSERT INTO class_model VALUES ('1240', '85', '406', 'ro');
INSERT INTO class_model VALUES ('1240', '85', '406', 'eng');
INSERT INTO class_model VALUES ('1240', '85', '406', 'german');
INSERT INTO class_model VALUES ('1241', '85', '407', 'ro');
INSERT INTO class_model VALUES ('1241', '85', '407', 'eng');
INSERT INTO class_model VALUES ('1241', '85', '407', 'german');
INSERT INTO class_model VALUES ('1242', '85', '5008', 'ro');
INSERT INTO class_model VALUES ('1242', '85', '5008', 'eng');
INSERT INTO class_model VALUES ('1242', '85', '5008', 'german');
INSERT INTO class_model VALUES ('1243', '85', '504', 'ro');
INSERT INTO class_model VALUES ('1243', '85', '504', 'eng');
INSERT INTO class_model VALUES ('1243', '85', '504', 'german');
INSERT INTO class_model VALUES ('1244', '85', '505', 'ro');
INSERT INTO class_model VALUES ('1244', '85', '505', 'eng');
INSERT INTO class_model VALUES ('1244', '85', '505', 'german');
INSERT INTO class_model VALUES ('1245', '85', '508', 'ro');
INSERT INTO class_model VALUES ('1245', '85', '508', 'eng');
INSERT INTO class_model VALUES ('1245', '85', '508', 'german');
INSERT INTO class_model VALUES ('1246', '85', '604', 'ro');
INSERT INTO class_model VALUES ('1246', '85', '604', 'eng');
INSERT INTO class_model VALUES ('1246', '85', '604', 'german');
INSERT INTO class_model VALUES ('1247', '85', '605', 'ro');
INSERT INTO class_model VALUES ('1247', '85', '605', 'eng');
INSERT INTO class_model VALUES ('1247', '85', '605', 'german');
INSERT INTO class_model VALUES ('1248', '85', '607', 'ro');
INSERT INTO class_model VALUES ('1248', '85', '607', 'eng');
INSERT INTO class_model VALUES ('1248', '85', '607', 'german');
INSERT INTO class_model VALUES ('1249', '85', '806', 'ro');
INSERT INTO class_model VALUES ('1249', '85', '806', 'eng');
INSERT INTO class_model VALUES ('1249', '85', '806', 'german');
INSERT INTO class_model VALUES ('1250', '85', '807', 'ro');
INSERT INTO class_model VALUES ('1250', '85', '807', 'eng');
INSERT INTO class_model VALUES ('1250', '85', '807', 'german');
INSERT INTO class_model VALUES ('1251', '85', 'Bipper', 'ro');
INSERT INTO class_model VALUES ('1251', '85', 'Bipper', 'eng');
INSERT INTO class_model VALUES ('1251', '85', 'Bipper', 'german');
INSERT INTO class_model VALUES ('1252', '85', 'Expert', 'ro');
INSERT INTO class_model VALUES ('1252', '85', 'Expert', 'eng');
INSERT INTO class_model VALUES ('1252', '85', 'Expert', 'german');
INSERT INTO class_model VALUES ('1253', '85', 'Partner', 'ro');
INSERT INTO class_model VALUES ('1253', '85', 'Partner', 'eng');
INSERT INTO class_model VALUES ('1253', '85', 'Partner', 'german');
INSERT INTO class_model VALUES ('1254', '85', 'RCZ', 'ro');
INSERT INTO class_model VALUES ('1254', '85', 'RCZ', 'eng');
INSERT INTO class_model VALUES ('1254', '85', 'RCZ', 'german');
INSERT INTO class_model VALUES ('1255', '86', 'Porter', 'ro');
INSERT INTO class_model VALUES ('1255', '86', 'Porter', 'eng');
INSERT INTO class_model VALUES ('1255', '86', 'Porter', 'german');
INSERT INTO class_model VALUES ('1256', '87', 'Belvedere', 'ro');
INSERT INTO class_model VALUES ('1256', '87', 'Belvedere', 'eng');
INSERT INTO class_model VALUES ('1256', '87', 'Belvedere', 'german');
INSERT INTO class_model VALUES ('1257', '87', 'Caravelle', 'ro');
INSERT INTO class_model VALUES ('1257', '87', 'Caravelle', 'eng');
INSERT INTO class_model VALUES ('1257', '87', 'Caravelle', 'german');
INSERT INTO class_model VALUES ('1258', '87', 'Duster', 'ro');
INSERT INTO class_model VALUES ('1258', '87', 'Duster', 'eng');
INSERT INTO class_model VALUES ('1258', '87', 'Duster', 'german');
INSERT INTO class_model VALUES ('1259', '87', 'Fury', 'ro');
INSERT INTO class_model VALUES ('1259', '87', 'Fury', 'eng');
INSERT INTO class_model VALUES ('1259', '87', 'Fury', 'german');
INSERT INTO class_model VALUES ('1260', '87', 'GTX', 'ro');
INSERT INTO class_model VALUES ('1260', '87', 'GTX', 'eng');
INSERT INTO class_model VALUES ('1260', '87', 'GTX', 'german');
INSERT INTO class_model VALUES ('1261', '87', 'Gran Fury', 'ro');
INSERT INTO class_model VALUES ('1261', '87', 'Gran Fury', 'eng');
INSERT INTO class_model VALUES ('1261', '87', 'Gran Fury', 'german');
INSERT INTO class_model VALUES ('1262', '87', 'Grand Voyager', 'ro');
INSERT INTO class_model VALUES ('1262', '87', 'Grand Voyager', 'eng');
INSERT INTO class_model VALUES ('1262', '87', 'Grand Voyager', 'german');
INSERT INTO class_model VALUES ('1263', '87', 'Horizon', 'ro');
INSERT INTO class_model VALUES ('1263', '87', 'Horizon', 'eng');
INSERT INTO class_model VALUES ('1263', '87', 'Horizon', 'german');
INSERT INTO class_model VALUES ('1264', '87', 'Laser', 'ro');
INSERT INTO class_model VALUES ('1264', '87', 'Laser', 'eng');
INSERT INTO class_model VALUES ('1264', '87', 'Laser', 'german');
INSERT INTO class_model VALUES ('1265', '87', 'Prowler', 'ro');
INSERT INTO class_model VALUES ('1265', '87', 'Prowler', 'eng');
INSERT INTO class_model VALUES ('1265', '87', 'Prowler', 'german');
INSERT INTO class_model VALUES ('1266', '87', 'Road Runner', 'ro');
INSERT INTO class_model VALUES ('1266', '87', 'Road Runner', 'eng');
INSERT INTO class_model VALUES ('1266', '87', 'Road Runner', 'german');
INSERT INTO class_model VALUES ('1267', '87', 'Satellite', 'ro');
INSERT INTO class_model VALUES ('1267', '87', 'Satellite', 'eng');
INSERT INTO class_model VALUES ('1267', '87', 'Satellite', 'german');
INSERT INTO class_model VALUES ('1268', '87', 'Superbird', 'ro');
INSERT INTO class_model VALUES ('1268', '87', 'Superbird', 'eng');
INSERT INTO class_model VALUES ('1268', '87', 'Superbird', 'german');
INSERT INTO class_model VALUES ('1269', '87', 'Turismo', 'ro');
INSERT INTO class_model VALUES ('1269', '87', 'Turismo', 'eng');
INSERT INTO class_model VALUES ('1269', '87', 'Turismo', 'german');
INSERT INTO class_model VALUES ('1270', '87', 'Valiant', 'ro');
INSERT INTO class_model VALUES ('1270', '87', 'Valiant', 'eng');
INSERT INTO class_model VALUES ('1270', '87', 'Valiant', 'german');
INSERT INTO class_model VALUES ('1271', '87', 'Voyager', 'ro');
INSERT INTO class_model VALUES ('1271', '87', 'Voyager', 'eng');
INSERT INTO class_model VALUES ('1271', '87', 'Voyager', 'german');
INSERT INTO class_model VALUES ('1272', '88', '1.5', 'ro');
INSERT INTO class_model VALUES ('1272', '88', '1.5', 'eng');
INSERT INTO class_model VALUES ('1272', '88', '1.5', 'german');
INSERT INTO class_model VALUES ('1273', '88', '1.6', 'ro');
INSERT INTO class_model VALUES ('1273', '88', '1.6', 'eng');
INSERT INTO class_model VALUES ('1273', '88', '1.6', 'german');
INSERT INTO class_model VALUES ('1274', '88', 'Atu', 'ro');
INSERT INTO class_model VALUES ('1274', '88', 'Atu', 'eng');
INSERT INTO class_model VALUES ('1274', '88', 'Atu', 'german');
INSERT INTO class_model VALUES ('1275', '88', 'Caro', 'ro');
INSERT INTO class_model VALUES ('1275', '88', 'Caro', 'eng');
INSERT INTO class_model VALUES ('1275', '88', 'Caro', 'german');
INSERT INTO class_model VALUES ('1276', '89', '1000', 'ro');
INSERT INTO class_model VALUES ('1276', '89', '1000', 'eng');
INSERT INTO class_model VALUES ('1276', '89', '1000', 'german');
INSERT INTO class_model VALUES ('1277', '89', '6000', 'ro');
INSERT INTO class_model VALUES ('1277', '89', '6000', 'eng');
INSERT INTO class_model VALUES ('1277', '89', '6000', 'german');
INSERT INTO class_model VALUES ('1278', '89', 'Bonneville', 'ro');
INSERT INTO class_model VALUES ('1278', '89', 'Bonneville', 'eng');
INSERT INTO class_model VALUES ('1278', '89', 'Bonneville', 'german');
INSERT INTO class_model VALUES ('1279', '89', 'Catalina', 'ro');
INSERT INTO class_model VALUES ('1279', '89', 'Catalina', 'eng');
INSERT INTO class_model VALUES ('1279', '89', 'Catalina', 'german');
INSERT INTO class_model VALUES ('1280', '89', 'Chieftain', 'ro');
INSERT INTO class_model VALUES ('1280', '89', 'Chieftain', 'eng');
INSERT INTO class_model VALUES ('1280', '89', 'Chieftain', 'german');
INSERT INTO class_model VALUES ('1281', '89', 'Fiero', 'ro');
INSERT INTO class_model VALUES ('1281', '89', 'Fiero', 'eng');
INSERT INTO class_model VALUES ('1281', '89', 'Fiero', 'german');
INSERT INTO class_model VALUES ('1282', '89', 'Firebird', 'ro');
INSERT INTO class_model VALUES ('1282', '89', 'Firebird', 'eng');
INSERT INTO class_model VALUES ('1282', '89', 'Firebird', 'german');
INSERT INTO class_model VALUES ('1283', '89', 'G6', 'ro');
INSERT INTO class_model VALUES ('1283', '89', 'G6', 'eng');
INSERT INTO class_model VALUES ('1283', '89', 'G6', 'german');
INSERT INTO class_model VALUES ('1284', '89', 'GTO', 'ro');
INSERT INTO class_model VALUES ('1284', '89', 'GTO', 'eng');
INSERT INTO class_model VALUES ('1284', '89', 'GTO', 'german');
INSERT INTO class_model VALUES ('1285', '89', 'Grand-Am', 'ro');
INSERT INTO class_model VALUES ('1285', '89', 'Grand-Am', 'eng');
INSERT INTO class_model VALUES ('1285', '89', 'Grand-Am', 'german');
INSERT INTO class_model VALUES ('1286', '89', 'Grand-Prix', 'ro');
INSERT INTO class_model VALUES ('1286', '89', 'Grand-Prix', 'eng');
INSERT INTO class_model VALUES ('1286', '89', 'Grand-Prix', 'german');
INSERT INTO class_model VALUES ('1287', '89', 'Le Mans', 'ro');
INSERT INTO class_model VALUES ('1287', '89', 'Le Mans', 'eng');
INSERT INTO class_model VALUES ('1287', '89', 'Le Mans', 'german');
INSERT INTO class_model VALUES ('1288', '89', 'Montana', 'ro');
INSERT INTO class_model VALUES ('1288', '89', 'Montana', 'eng');
INSERT INTO class_model VALUES ('1288', '89', 'Montana', 'german');
INSERT INTO class_model VALUES ('1289', '89', 'Solstice', 'ro');
INSERT INTO class_model VALUES ('1289', '89', 'Solstice', 'eng');
INSERT INTO class_model VALUES ('1289', '89', 'Solstice', 'german');
INSERT INTO class_model VALUES ('1290', '89', 'Sunbird', 'ro');
INSERT INTO class_model VALUES ('1290', '89', 'Sunbird', 'eng');
INSERT INTO class_model VALUES ('1290', '89', 'Sunbird', 'german');
INSERT INTO class_model VALUES ('1291', '89', 'Sunfire', 'ro');
INSERT INTO class_model VALUES ('1291', '89', 'Sunfire', 'eng');
INSERT INTO class_model VALUES ('1291', '89', 'Sunfire', 'german');
INSERT INTO class_model VALUES ('1292', '89', 'Trans Am', 'ro');
INSERT INTO class_model VALUES ('1292', '89', 'Trans Am', 'eng');
INSERT INTO class_model VALUES ('1292', '89', 'Trans Am', 'german');
INSERT INTO class_model VALUES ('1293', '89', 'Trans Sport', 'ro');
INSERT INTO class_model VALUES ('1293', '89', 'Trans Sport', 'eng');
INSERT INTO class_model VALUES ('1293', '89', 'Trans Sport', 'german');
INSERT INTO class_model VALUES ('1294', '89', 'Vibe', 'ro');
INSERT INTO class_model VALUES ('1294', '89', 'Vibe', 'eng');
INSERT INTO class_model VALUES ('1294', '89', 'Vibe', 'german');
INSERT INTO class_model VALUES ('1295', '90', '356', 'ro');
INSERT INTO class_model VALUES ('1295', '90', '356', 'eng');
INSERT INTO class_model VALUES ('1295', '90', '356', 'german');
INSERT INTO class_model VALUES ('1296', '90', '911', 'ro');
INSERT INTO class_model VALUES ('1296', '90', '911', 'eng');
INSERT INTO class_model VALUES ('1296', '90', '911', 'german');
INSERT INTO class_model VALUES ('1297', '90', '912', 'ro');
INSERT INTO class_model VALUES ('1297', '90', '912', 'eng');
INSERT INTO class_model VALUES ('1297', '90', '912', 'german');
INSERT INTO class_model VALUES ('1298', '90', '914', 'ro');
INSERT INTO class_model VALUES ('1298', '90', '914', 'eng');
INSERT INTO class_model VALUES ('1298', '90', '914', 'german');
INSERT INTO class_model VALUES ('1299', '90', '924', 'ro');
INSERT INTO class_model VALUES ('1299', '90', '924', 'eng');
INSERT INTO class_model VALUES ('1299', '90', '924', 'german');
INSERT INTO class_model VALUES ('1300', '90', '928', 'ro');
INSERT INTO class_model VALUES ('1300', '90', '928', 'eng');
INSERT INTO class_model VALUES ('1300', '90', '928', 'german');
INSERT INTO class_model VALUES ('1301', '90', '944', 'ro');
INSERT INTO class_model VALUES ('1301', '90', '944', 'eng');
INSERT INTO class_model VALUES ('1301', '90', '944', 'german');
INSERT INTO class_model VALUES ('1302', '90', '959', 'ro');
INSERT INTO class_model VALUES ('1302', '90', '959', 'eng');
INSERT INTO class_model VALUES ('1302', '90', '959', 'german');
INSERT INTO class_model VALUES ('1303', '90', '962', 'ro');
INSERT INTO class_model VALUES ('1303', '90', '962', 'eng');
INSERT INTO class_model VALUES ('1303', '90', '962', 'german');
INSERT INTO class_model VALUES ('1304', '90', '968', 'ro');
INSERT INTO class_model VALUES ('1304', '90', '968', 'eng');
INSERT INTO class_model VALUES ('1304', '90', '968', 'german');
INSERT INTO class_model VALUES ('1305', '90', 'Boxster', 'ro');
INSERT INTO class_model VALUES ('1305', '90', 'Boxster', 'eng');
INSERT INTO class_model VALUES ('1305', '90', 'Boxster', 'german');
INSERT INTO class_model VALUES ('1306', '90', 'Carrera GT', 'ro');
INSERT INTO class_model VALUES ('1306', '90', 'Carrera GT', 'eng');
INSERT INTO class_model VALUES ('1306', '90', 'Carrera GT', 'german');
INSERT INTO class_model VALUES ('1307', '90', 'Cayenne', 'ro');
INSERT INTO class_model VALUES ('1307', '90', 'Cayenne', 'eng');
INSERT INTO class_model VALUES ('1307', '90', 'Cayenne', 'german');
INSERT INTO class_model VALUES ('1308', '90', 'Cayenne GTS', 'ro');
INSERT INTO class_model VALUES ('1308', '90', 'Cayenne GTS', 'eng');
INSERT INTO class_model VALUES ('1308', '90', 'Cayenne GTS', 'german');
INSERT INTO class_model VALUES ('1309', '90', 'Cayenne S', 'ro');
INSERT INTO class_model VALUES ('1309', '90', 'Cayenne S', 'eng');
INSERT INTO class_model VALUES ('1309', '90', 'Cayenne S', 'german');
INSERT INTO class_model VALUES ('1310', '90', 'Cayenne Turbo', 'ro');
INSERT INTO class_model VALUES ('1310', '90', 'Cayenne Turbo', 'eng');
INSERT INTO class_model VALUES ('1310', '90', 'Cayenne Turbo', 'german');
INSERT INTO class_model VALUES ('1311', '90', 'Cayman', 'ro');
INSERT INTO class_model VALUES ('1311', '90', 'Cayman', 'eng');
INSERT INTO class_model VALUES ('1311', '90', 'Cayman', 'german');
INSERT INTO class_model VALUES ('1312', '90', 'Macan', 'ro');
INSERT INTO class_model VALUES ('1312', '90', 'Macan', 'eng');
INSERT INTO class_model VALUES ('1312', '90', 'Macan', 'german');
INSERT INTO class_model VALUES ('1313', '90', 'Panamera', 'ro');
INSERT INTO class_model VALUES ('1313', '90', 'Panamera', 'eng');
INSERT INTO class_model VALUES ('1313', '90', 'Panamera', 'german');
INSERT INTO class_model VALUES ('1314', '91', 'Seria 300', 'ro');
INSERT INTO class_model VALUES ('1314', '91', 'Seria 300', 'eng');
INSERT INTO class_model VALUES ('1314', '91', 'Seria 300', 'german');
INSERT INTO class_model VALUES ('1315', '91', 'Seria 400', 'ro');
INSERT INTO class_model VALUES ('1315', '91', 'Seria 400', 'eng');
INSERT INTO class_model VALUES ('1315', '91', 'Seria 400', 'german');
INSERT INTO class_model VALUES ('1316', '92', 'Magnum', 'ro');
INSERT INTO class_model VALUES ('1316', '92', 'Magnum', 'eng');
INSERT INTO class_model VALUES ('1316', '92', 'Magnum', 'german');
INSERT INTO class_model VALUES ('1317', '93', '10', 'ro');
INSERT INTO class_model VALUES ('1317', '93', '10', 'eng');
INSERT INTO class_model VALUES ('1317', '93', '10', 'german');
INSERT INTO class_model VALUES ('1318', '93', '11', 'ro');
INSERT INTO class_model VALUES ('1318', '93', '11', 'eng');
INSERT INTO class_model VALUES ('1318', '93', '11', 'german');
INSERT INTO class_model VALUES ('1319', '93', '12', 'ro');
INSERT INTO class_model VALUES ('1319', '93', '12', 'eng');
INSERT INTO class_model VALUES ('1319', '93', '12', 'german');
INSERT INTO class_model VALUES ('1320', '93', '14', 'ro');
INSERT INTO class_model VALUES ('1320', '93', '14', 'eng');
INSERT INTO class_model VALUES ('1320', '93', '14', 'german');
INSERT INTO class_model VALUES ('1321', '93', '16', 'ro');
INSERT INTO class_model VALUES ('1321', '93', '16', 'eng');
INSERT INTO class_model VALUES ('1321', '93', '16', 'german');
INSERT INTO class_model VALUES ('1322', '93', '18', 'ro');
INSERT INTO class_model VALUES ('1322', '93', '18', 'eng');
INSERT INTO class_model VALUES ('1322', '93', '18', 'german');
INSERT INTO class_model VALUES ('1323', '93', '19', 'ro');
INSERT INTO class_model VALUES ('1323', '93', '19', 'eng');
INSERT INTO class_model VALUES ('1323', '93', '19', 'german');
INSERT INTO class_model VALUES ('1324', '93', '20', 'ro');
INSERT INTO class_model VALUES ('1324', '93', '20', 'eng');
INSERT INTO class_model VALUES ('1324', '93', '20', 'german');
INSERT INTO class_model VALUES ('1325', '93', '21', 'ro');
INSERT INTO class_model VALUES ('1325', '93', '21', 'eng');
INSERT INTO class_model VALUES ('1325', '93', '21', 'german');
INSERT INTO class_model VALUES ('1326', '93', '25', 'ro');
INSERT INTO class_model VALUES ('1326', '93', '25', 'eng');
INSERT INTO class_model VALUES ('1326', '93', '25', 'german');
INSERT INTO class_model VALUES ('1327', '93', '30', 'ro');
INSERT INTO class_model VALUES ('1327', '93', '30', 'eng');
INSERT INTO class_model VALUES ('1327', '93', '30', 'german');
INSERT INTO class_model VALUES ('1328', '93', '4', 'ro');
INSERT INTO class_model VALUES ('1328', '93', '4', 'eng');
INSERT INTO class_model VALUES ('1328', '93', '4', 'german');
INSERT INTO class_model VALUES ('1329', '93', '5', 'ro');
INSERT INTO class_model VALUES ('1329', '93', '5', 'eng');
INSERT INTO class_model VALUES ('1329', '93', '5', 'german');
INSERT INTO class_model VALUES ('1330', '93', '8', 'ro');
INSERT INTO class_model VALUES ('1330', '93', '8', 'eng');
INSERT INTO class_model VALUES ('1330', '93', '8', 'german');
INSERT INTO class_model VALUES ('1331', '93', '9', 'ro');
INSERT INTO class_model VALUES ('1331', '93', '9', 'eng');
INSERT INTO class_model VALUES ('1331', '93', '9', 'german');
INSERT INTO class_model VALUES ('1332', '93', 'Alpine A110', 'ro');
INSERT INTO class_model VALUES ('1332', '93', 'Alpine A110', 'eng');
INSERT INTO class_model VALUES ('1332', '93', 'Alpine A110', 'german');
INSERT INTO class_model VALUES ('1333', '93', 'Alpine A310', 'ro');
INSERT INTO class_model VALUES ('1333', '93', 'Alpine A310', 'eng');
INSERT INTO class_model VALUES ('1333', '93', 'Alpine A310', 'german');
INSERT INTO class_model VALUES ('1334', '93', 'Alpine V6', 'ro');
INSERT INTO class_model VALUES ('1334', '93', 'Alpine V6', 'eng');
INSERT INTO class_model VALUES ('1334', '93', 'Alpine V6', 'german');
INSERT INTO class_model VALUES ('1335', '93', 'Avantime', 'ro');
INSERT INTO class_model VALUES ('1335', '93', 'Avantime', 'eng');
INSERT INTO class_model VALUES ('1335', '93', 'Avantime', 'german');
INSERT INTO class_model VALUES ('1336', '93', 'Captur', 'ro');
INSERT INTO class_model VALUES ('1336', '93', 'Captur', 'eng');
INSERT INTO class_model VALUES ('1336', '93', 'Captur', 'german');
INSERT INTO class_model VALUES ('1337', '93', 'Clio', 'ro');
INSERT INTO class_model VALUES ('1337', '93', 'Clio', 'eng');
INSERT INTO class_model VALUES ('1337', '93', 'Clio', 'german');
INSERT INTO class_model VALUES ('1338', '93', 'Clio RS', 'ro');
INSERT INTO class_model VALUES ('1338', '93', 'Clio RS', 'eng');
INSERT INTO class_model VALUES ('1338', '93', 'Clio RS', 'german');
INSERT INTO class_model VALUES ('1339', '93', 'Coupe', 'ro');
INSERT INTO class_model VALUES ('1339', '93', 'Coupe', 'eng');
INSERT INTO class_model VALUES ('1339', '93', 'Coupe', 'german');
INSERT INTO class_model VALUES ('1340', '93', 'Espace', 'ro');
INSERT INTO class_model VALUES ('1340', '93', 'Espace', 'eng');
INSERT INTO class_model VALUES ('1340', '93', 'Espace', 'german');
INSERT INTO class_model VALUES ('1341', '93', 'Express', 'ro');
INSERT INTO class_model VALUES ('1341', '93', 'Express', 'eng');
INSERT INTO class_model VALUES ('1341', '93', 'Express', 'german');
INSERT INTO class_model VALUES ('1342', '93', 'Fluence', 'ro');
INSERT INTO class_model VALUES ('1342', '93', 'Fluence', 'eng');
INSERT INTO class_model VALUES ('1342', '93', 'Fluence', 'german');
INSERT INTO class_model VALUES ('1343', '93', 'Fuego', 'ro');
INSERT INTO class_model VALUES ('1343', '93', 'Fuego', 'eng');
INSERT INTO class_model VALUES ('1343', '93', 'Fuego', 'german');
INSERT INTO class_model VALUES ('1344', '93', 'Grand Espace', 'ro');
INSERT INTO class_model VALUES ('1344', '93', 'Grand Espace', 'eng');
INSERT INTO class_model VALUES ('1344', '93', 'Grand Espace', 'german');
INSERT INTO class_model VALUES ('1345', '93', 'Grand Scenic', 'ro');
INSERT INTO class_model VALUES ('1345', '93', 'Grand Scenic', 'eng');
INSERT INTO class_model VALUES ('1345', '93', 'Grand Scenic', 'german');
INSERT INTO class_model VALUES ('1346', '93', 'Kangoo', 'ro');
INSERT INTO class_model VALUES ('1346', '93', 'Kangoo', 'eng');
INSERT INTO class_model VALUES ('1346', '93', 'Kangoo', 'german');
INSERT INTO class_model VALUES ('1347', '93', 'Koleos', 'ro');
INSERT INTO class_model VALUES ('1347', '93', 'Koleos', 'eng');
INSERT INTO class_model VALUES ('1347', '93', 'Koleos', 'german');
INSERT INTO class_model VALUES ('1348', '93', 'Laguna', 'ro');
INSERT INTO class_model VALUES ('1348', '93', 'Laguna', 'eng');
INSERT INTO class_model VALUES ('1348', '93', 'Laguna', 'german');
INSERT INTO class_model VALUES ('1349', '93', 'Latitude', 'ro');
INSERT INTO class_model VALUES ('1349', '93', 'Latitude', 'eng');
INSERT INTO class_model VALUES ('1349', '93', 'Latitude', 'german');
INSERT INTO class_model VALUES ('1350', '93', 'Megane', 'ro');
INSERT INTO class_model VALUES ('1350', '93', 'Megane', 'eng');
INSERT INTO class_model VALUES ('1350', '93', 'Megane', 'german');
INSERT INTO class_model VALUES ('1351', '93', 'Megane RS', 'ro');
INSERT INTO class_model VALUES ('1351', '93', 'Megane RS', 'eng');
INSERT INTO class_model VALUES ('1351', '93', 'Megane RS', 'german');
INSERT INTO class_model VALUES ('1352', '93', 'Modus', 'ro');
INSERT INTO class_model VALUES ('1352', '93', 'Modus', 'eng');
INSERT INTO class_model VALUES ('1352', '93', 'Modus', 'german');
INSERT INTO class_model VALUES ('1353', '93', 'Safrane', 'ro');
INSERT INTO class_model VALUES ('1353', '93', 'Safrane', 'eng');
INSERT INTO class_model VALUES ('1353', '93', 'Safrane', 'german');
INSERT INTO class_model VALUES ('1354', '93', 'Scenic', 'ro');
INSERT INTO class_model VALUES ('1354', '93', 'Scenic', 'eng');
INSERT INTO class_model VALUES ('1354', '93', 'Scenic', 'german');
INSERT INTO class_model VALUES ('1355', '93', 'Scenic Conquest', 'ro');
INSERT INTO class_model VALUES ('1355', '93', 'Scenic Conquest', 'eng');
INSERT INTO class_model VALUES ('1355', '93', 'Scenic Conquest', 'german');
INSERT INTO class_model VALUES ('1356', '93', 'Scenic RX4', 'ro');
INSERT INTO class_model VALUES ('1356', '93', 'Scenic RX4', 'eng');
INSERT INTO class_model VALUES ('1356', '93', 'Scenic RX4', 'german');
INSERT INTO class_model VALUES ('1357', '93', 'Symbol', 'ro');
INSERT INTO class_model VALUES ('1357', '93', 'Symbol', 'eng');
INSERT INTO class_model VALUES ('1357', '93', 'Symbol', 'german');
INSERT INTO class_model VALUES ('1358', '93', 'Thalia', 'ro');
INSERT INTO class_model VALUES ('1358', '93', 'Thalia', 'eng');
INSERT INTO class_model VALUES ('1358', '93', 'Thalia', 'german');
INSERT INTO class_model VALUES ('1359', '93', 'Trafic', 'ro');
INSERT INTO class_model VALUES ('1359', '93', 'Trafic', 'eng');
INSERT INTO class_model VALUES ('1359', '93', 'Trafic', 'german');
INSERT INTO class_model VALUES ('1360', '93', 'Twingo', 'ro');
INSERT INTO class_model VALUES ('1360', '93', 'Twingo', 'eng');
INSERT INTO class_model VALUES ('1360', '93', 'Twingo', 'german');
INSERT INTO class_model VALUES ('1361', '93', 'Twizy', 'ro');
INSERT INTO class_model VALUES ('1361', '93', 'Twizy', 'eng');
INSERT INTO class_model VALUES ('1361', '93', 'Twizy', 'german');
INSERT INTO class_model VALUES ('1362', '93', 'Vel Satis', 'ro');
INSERT INTO class_model VALUES ('1362', '93', 'Vel Satis', 'eng');
INSERT INTO class_model VALUES ('1362', '93', 'Vel Satis', 'german');
INSERT INTO class_model VALUES ('1363', '93', 'Wind', 'ro');
INSERT INTO class_model VALUES ('1363', '93', 'Wind', 'eng');
INSERT INTO class_model VALUES ('1363', '93', 'Wind', 'german');
INSERT INTO class_model VALUES ('1364', '93', 'Kadjar', 'ro');
INSERT INTO class_model VALUES ('1364', '93', 'Kadjar', 'eng');
INSERT INTO class_model VALUES ('1364', '93', 'Kadjar', 'german');
INSERT INTO class_model VALUES ('1365', '93', 'Talisman', 'ro');
INSERT INTO class_model VALUES ('1365', '93', 'Talisman', 'eng');
INSERT INTO class_model VALUES ('1365', '93', 'Talisman', 'german');
INSERT INTO class_model VALUES ('1366', '93', 'Cactus', 'ro');
INSERT INTO class_model VALUES ('1366', '93', 'Cactus', 'eng');
INSERT INTO class_model VALUES ('1366', '93', 'Cactus', 'german');
INSERT INTO class_model VALUES ('1367', '94', 'Corniche', 'ro');
INSERT INTO class_model VALUES ('1367', '94', 'Corniche', 'eng');
INSERT INTO class_model VALUES ('1367', '94', 'Corniche', 'german');
INSERT INTO class_model VALUES ('1368', '94', 'Flying Spur', 'ro');
INSERT INTO class_model VALUES ('1368', '94', 'Flying Spur', 'eng');
INSERT INTO class_model VALUES ('1368', '94', 'Flying Spur', 'german');
INSERT INTO class_model VALUES ('1369', '94', 'Ghost', 'ro');
INSERT INTO class_model VALUES ('1369', '94', 'Ghost', 'eng');
INSERT INTO class_model VALUES ('1369', '94', 'Ghost', 'german');
INSERT INTO class_model VALUES ('1370', '94', 'Park Ward', 'ro');
INSERT INTO class_model VALUES ('1370', '94', 'Park Ward', 'eng');
INSERT INTO class_model VALUES ('1370', '94', 'Park Ward', 'german');
INSERT INTO class_model VALUES ('1371', '94', 'Phantom', 'ro');
INSERT INTO class_model VALUES ('1371', '94', 'Phantom', 'eng');
INSERT INTO class_model VALUES ('1371', '94', 'Phantom', 'german');
INSERT INTO class_model VALUES ('1372', '94', 'Silver Cloud', 'ro');
INSERT INTO class_model VALUES ('1372', '94', 'Silver Cloud', 'eng');
INSERT INTO class_model VALUES ('1372', '94', 'Silver Cloud', 'german');
INSERT INTO class_model VALUES ('1373', '94', 'Silver Down', 'ro');
INSERT INTO class_model VALUES ('1373', '94', 'Silver Down', 'eng');
INSERT INTO class_model VALUES ('1373', '94', 'Silver Down', 'german');
INSERT INTO class_model VALUES ('1374', '94', 'Silver Seraph', 'ro');
INSERT INTO class_model VALUES ('1374', '94', 'Silver Seraph', 'eng');
INSERT INTO class_model VALUES ('1374', '94', 'Silver Seraph', 'german');
INSERT INTO class_model VALUES ('1375', '94', 'Silver Shadow', 'ro');
INSERT INTO class_model VALUES ('1375', '94', 'Silver Shadow', 'eng');
INSERT INTO class_model VALUES ('1375', '94', 'Silver Shadow', 'german');
INSERT INTO class_model VALUES ('1376', '94', 'Silver Spirit', 'ro');
INSERT INTO class_model VALUES ('1376', '94', 'Silver Spirit', 'eng');
INSERT INTO class_model VALUES ('1376', '94', 'Silver Spirit', 'german');
INSERT INTO class_model VALUES ('1377', '94', 'Silver Spur', 'ro');
INSERT INTO class_model VALUES ('1377', '94', 'Silver Spur', 'eng');
INSERT INTO class_model VALUES ('1377', '94', 'Silver Spur', 'german');
INSERT INTO class_model VALUES ('1378', '94', 'Touring Limousine', 'ro');
INSERT INTO class_model VALUES ('1378', '94', 'Touring Limousine', 'eng');
INSERT INTO class_model VALUES ('1378', '94', 'Touring Limousine', 'german');
INSERT INTO class_model VALUES ('1379', '95', '100', 'ro');
INSERT INTO class_model VALUES ('1379', '95', '100', 'eng');
INSERT INTO class_model VALUES ('1379', '95', '100', 'german');
INSERT INTO class_model VALUES ('1380', '95', '111', 'ro');
INSERT INTO class_model VALUES ('1380', '95', '111', 'eng');
INSERT INTO class_model VALUES ('1380', '95', '111', 'german');
INSERT INTO class_model VALUES ('1381', '95', '114', 'ro');
INSERT INTO class_model VALUES ('1381', '95', '114', 'eng');
INSERT INTO class_model VALUES ('1381', '95', '114', 'german');
INSERT INTO class_model VALUES ('1382', '95', '115', 'ro');
INSERT INTO class_model VALUES ('1382', '95', '115', 'eng');
INSERT INTO class_model VALUES ('1382', '95', '115', 'german');
INSERT INTO class_model VALUES ('1383', '95', '200', 'ro');
INSERT INTO class_model VALUES ('1383', '95', '200', 'eng');
INSERT INTO class_model VALUES ('1383', '95', '200', 'german');
INSERT INTO class_model VALUES ('1384', '95', '213', 'ro');
INSERT INTO class_model VALUES ('1384', '95', '213', 'eng');
INSERT INTO class_model VALUES ('1384', '95', '213', 'german');
INSERT INTO class_model VALUES ('1385', '95', '214', 'ro');
INSERT INTO class_model VALUES ('1385', '95', '214', 'eng');
INSERT INTO class_model VALUES ('1385', '95', '214', 'german');
INSERT INTO class_model VALUES ('1386', '95', '216', 'ro');
INSERT INTO class_model VALUES ('1386', '95', '216', 'eng');
INSERT INTO class_model VALUES ('1386', '95', '216', 'german');
INSERT INTO class_model VALUES ('1387', '95', '218', 'ro');
INSERT INTO class_model VALUES ('1387', '95', '218', 'eng');
INSERT INTO class_model VALUES ('1387', '95', '218', 'german');
INSERT INTO class_model VALUES ('1388', '95', '220', 'ro');
INSERT INTO class_model VALUES ('1388', '95', '220', 'eng');
INSERT INTO class_model VALUES ('1388', '95', '220', 'german');
INSERT INTO class_model VALUES ('1389', '95', '25', 'ro');
INSERT INTO class_model VALUES ('1389', '95', '25', 'eng');
INSERT INTO class_model VALUES ('1389', '95', '25', 'german');
INSERT INTO class_model VALUES ('1390', '95', '400', 'ro');
INSERT INTO class_model VALUES ('1390', '95', '400', 'eng');
INSERT INTO class_model VALUES ('1390', '95', '400', 'german');
INSERT INTO class_model VALUES ('1391', '95', '414', 'ro');
INSERT INTO class_model VALUES ('1391', '95', '414', 'eng');
INSERT INTO class_model VALUES ('1391', '95', '414', 'german');
INSERT INTO class_model VALUES ('1392', '95', '416', 'ro');
INSERT INTO class_model VALUES ('1392', '95', '416', 'eng');
INSERT INTO class_model VALUES ('1392', '95', '416', 'german');
INSERT INTO class_model VALUES ('1393', '95', '418', 'ro');
INSERT INTO class_model VALUES ('1393', '95', '418', 'eng');
INSERT INTO class_model VALUES ('1393', '95', '418', 'german');
INSERT INTO class_model VALUES ('1394', '95', '420', 'ro');
INSERT INTO class_model VALUES ('1394', '95', '420', 'eng');
INSERT INTO class_model VALUES ('1394', '95', '420', 'german');
INSERT INTO class_model VALUES ('1395', '95', '45', 'ro');
INSERT INTO class_model VALUES ('1395', '95', '45', 'eng');
INSERT INTO class_model VALUES ('1395', '95', '45', 'german');
INSERT INTO class_model VALUES ('1396', '95', '600', 'ro');
INSERT INTO class_model VALUES ('1396', '95', '600', 'eng');
INSERT INTO class_model VALUES ('1396', '95', '600', 'german');
INSERT INTO class_model VALUES ('1397', '95', '618', 'ro');
INSERT INTO class_model VALUES ('1397', '95', '618', 'eng');
INSERT INTO class_model VALUES ('1397', '95', '618', 'german');
INSERT INTO class_model VALUES ('1398', '95', '620', 'ro');
INSERT INTO class_model VALUES ('1398', '95', '620', 'eng');
INSERT INTO class_model VALUES ('1398', '95', '620', 'german');
INSERT INTO class_model VALUES ('1399', '95', '623', 'ro');
INSERT INTO class_model VALUES ('1399', '95', '623', 'eng');
INSERT INTO class_model VALUES ('1399', '95', '623', 'german');
INSERT INTO class_model VALUES ('1400', '95', '75', 'ro');
INSERT INTO class_model VALUES ('1400', '95', '75', 'eng');
INSERT INTO class_model VALUES ('1400', '95', '75', 'german');
INSERT INTO class_model VALUES ('1401', '95', '800', 'ro');
INSERT INTO class_model VALUES ('1401', '95', '800', 'eng');
INSERT INTO class_model VALUES ('1401', '95', '800', 'german');
INSERT INTO class_model VALUES ('1402', '95', '820', 'ro');
INSERT INTO class_model VALUES ('1402', '95', '820', 'eng');
INSERT INTO class_model VALUES ('1402', '95', '820', 'german');
INSERT INTO class_model VALUES ('1403', '95', '825', 'ro');
INSERT INTO class_model VALUES ('1403', '95', '825', 'eng');
INSERT INTO class_model VALUES ('1403', '95', '825', 'german');
INSERT INTO class_model VALUES ('1404', '95', '827', 'ro');
INSERT INTO class_model VALUES ('1404', '95', '827', 'eng');
INSERT INTO class_model VALUES ('1404', '95', '827', 'german');
INSERT INTO class_model VALUES ('1405', '95', 'City Rover', 'ro');
INSERT INTO class_model VALUES ('1405', '95', 'City Rover', 'eng');
INSERT INTO class_model VALUES ('1405', '95', 'City Rover', 'german');
INSERT INTO class_model VALUES ('1406', '95', 'MG', 'ro');
INSERT INTO class_model VALUES ('1406', '95', 'MG', 'eng');
INSERT INTO class_model VALUES ('1406', '95', 'MG', 'german');
INSERT INTO class_model VALUES ('1407', '95', 'Metro', 'ro');
INSERT INTO class_model VALUES ('1407', '95', 'Metro', 'eng');
INSERT INTO class_model VALUES ('1407', '95', 'Metro', 'german');
INSERT INTO class_model VALUES ('1408', '95', 'Mini', 'ro');
INSERT INTO class_model VALUES ('1408', '95', 'Mini', 'eng');
INSERT INTO class_model VALUES ('1408', '95', 'Mini', 'german');
INSERT INTO class_model VALUES ('1409', '95', 'Montego', 'ro');
INSERT INTO class_model VALUES ('1409', '95', 'Montego', 'eng');
INSERT INTO class_model VALUES ('1409', '95', 'Montego', 'german');
INSERT INTO class_model VALUES ('1410', '95', 'SD', 'ro');
INSERT INTO class_model VALUES ('1410', '95', 'SD', 'eng');
INSERT INTO class_model VALUES ('1410', '95', 'SD', 'german');
INSERT INTO class_model VALUES ('1411', '95', 'Streetwise', 'ro');
INSERT INTO class_model VALUES ('1411', '95', 'Streetwise', 'eng');
INSERT INTO class_model VALUES ('1411', '95', 'Streetwise', 'german');
INSERT INTO class_model VALUES ('1412', '96', '9-2X', 'ro');
INSERT INTO class_model VALUES ('1412', '96', '9-2X', 'eng');
INSERT INTO class_model VALUES ('1412', '96', '9-2X', 'german');
INSERT INTO class_model VALUES ('1413', '96', '9-3', 'ro');
INSERT INTO class_model VALUES ('1413', '96', '9-3', 'eng');
INSERT INTO class_model VALUES ('1413', '96', '9-3', 'german');
INSERT INTO class_model VALUES ('1414', '96', '9-3X SportKombi', 'ro');
INSERT INTO class_model VALUES ('1414', '96', '9-3X SportKombi', 'eng');
INSERT INTO class_model VALUES ('1414', '96', '9-3X SportKombi', 'german');
INSERT INTO class_model VALUES ('1415', '96', '9-5', 'ro');
INSERT INTO class_model VALUES ('1415', '96', '9-5', 'eng');
INSERT INTO class_model VALUES ('1415', '96', '9-5', 'german');
INSERT INTO class_model VALUES ('1416', '96', '9-7X', 'ro');
INSERT INTO class_model VALUES ('1416', '96', '9-7X', 'eng');
INSERT INTO class_model VALUES ('1416', '96', '9-7X', 'german');
INSERT INTO class_model VALUES ('1417', '96', '90', 'ro');
INSERT INTO class_model VALUES ('1417', '96', '90', 'eng');
INSERT INTO class_model VALUES ('1417', '96', '90', 'german');
INSERT INTO class_model VALUES ('1418', '96', '900', 'ro');
INSERT INTO class_model VALUES ('1418', '96', '900', 'eng');
INSERT INTO class_model VALUES ('1418', '96', '900', 'german');
INSERT INTO class_model VALUES ('1419', '96', '9000', 'ro');
INSERT INTO class_model VALUES ('1419', '96', '9000', 'eng');
INSERT INTO class_model VALUES ('1419', '96', '9000', 'german');
INSERT INTO class_model VALUES ('1420', '96', '96', 'ro');
INSERT INTO class_model VALUES ('1420', '96', '96', 'eng');
INSERT INTO class_model VALUES ('1420', '96', '96', 'german');
INSERT INTO class_model VALUES ('1421', '96', '99', 'ro');
INSERT INTO class_model VALUES ('1421', '96', '99', 'eng');
INSERT INTO class_model VALUES ('1421', '96', '99', 'german');
INSERT INTO class_model VALUES ('1422', '97', 'QM5', 'ro');
INSERT INTO class_model VALUES ('1422', '97', 'QM5', 'eng');
INSERT INTO class_model VALUES ('1422', '97', 'QM5', 'german');
INSERT INTO class_model VALUES ('1423', '98', 'PS-10', 'ro');
INSERT INTO class_model VALUES ('1423', '98', 'PS-10', 'eng');
INSERT INTO class_model VALUES ('1423', '98', 'PS-10', 'german');
INSERT INTO class_model VALUES ('1424', '98', 'PS-300', 'ro');
INSERT INTO class_model VALUES ('1424', '98', 'PS-300', 'eng');
INSERT INTO class_model VALUES ('1424', '98', 'PS-300', 'german');
INSERT INTO class_model VALUES ('1425', '98', 'PS-350', 'ro');
INSERT INTO class_model VALUES ('1425', '98', 'PS-350', 'eng');
INSERT INTO class_model VALUES ('1425', '98', 'PS-350', 'german');
INSERT INTO class_model VALUES ('1426', '99', 'Astra', 'ro');
INSERT INTO class_model VALUES ('1426', '99', 'Astra', 'eng');
INSERT INTO class_model VALUES ('1426', '99', 'Astra', 'german');
INSERT INTO class_model VALUES ('1427', '99', 'Aura', 'ro');
INSERT INTO class_model VALUES ('1427', '99', 'Aura', 'eng');
INSERT INTO class_model VALUES ('1427', '99', 'Aura', 'german');
INSERT INTO class_model VALUES ('1428', '99', 'ION Quad Coupe', 'ro');
INSERT INTO class_model VALUES ('1428', '99', 'ION Quad Coupe', 'eng');
INSERT INTO class_model VALUES ('1428', '99', 'ION Quad Coupe', 'german');
INSERT INTO class_model VALUES ('1429', '99', 'ION Sedan', 'ro');
INSERT INTO class_model VALUES ('1429', '99', 'ION Sedan', 'eng');
INSERT INTO class_model VALUES ('1429', '99', 'ION Sedan', 'german');
INSERT INTO class_model VALUES ('1430', '99', 'Outlook', 'ro');
INSERT INTO class_model VALUES ('1430', '99', 'Outlook', 'eng');
INSERT INTO class_model VALUES ('1430', '99', 'Outlook', 'german');
INSERT INTO class_model VALUES ('1431', '99', 'Relay', 'ro');
INSERT INTO class_model VALUES ('1431', '99', 'Relay', 'eng');
INSERT INTO class_model VALUES ('1431', '99', 'Relay', 'german');
INSERT INTO class_model VALUES ('1432', '99', 'SC', 'ro');
INSERT INTO class_model VALUES ('1432', '99', 'SC', 'eng');
INSERT INTO class_model VALUES ('1432', '99', 'SC', 'german');
INSERT INTO class_model VALUES ('1433', '99', 'SL', 'ro');
INSERT INTO class_model VALUES ('1433', '99', 'SL', 'eng');
INSERT INTO class_model VALUES ('1433', '99', 'SL', 'german');
INSERT INTO class_model VALUES ('1434', '99', 'SW', 'ro');
INSERT INTO class_model VALUES ('1434', '99', 'SW', 'eng');
INSERT INTO class_model VALUES ('1434', '99', 'SW', 'german');
INSERT INTO class_model VALUES ('1435', '99', 'Sky', 'ro');
INSERT INTO class_model VALUES ('1435', '99', 'Sky', 'eng');
INSERT INTO class_model VALUES ('1435', '99', 'Sky', 'german');
INSERT INTO class_model VALUES ('1436', '99', 'VUE', 'ro');
INSERT INTO class_model VALUES ('1436', '99', 'VUE', 'eng');
INSERT INTO class_model VALUES ('1436', '99', 'VUE', 'german');
INSERT INTO class_model VALUES ('1437', '100', 'tC', 'ro');
INSERT INTO class_model VALUES ('1437', '100', 'tC', 'eng');
INSERT INTO class_model VALUES ('1437', '100', 'tC', 'german');
INSERT INTO class_model VALUES ('1438', '100', 'xA', 'ro');
INSERT INTO class_model VALUES ('1438', '100', 'xA', 'eng');
INSERT INTO class_model VALUES ('1438', '100', 'xA', 'german');
INSERT INTO class_model VALUES ('1439', '100', 'XB', 'ro');
INSERT INTO class_model VALUES ('1439', '100', 'XB', 'eng');
INSERT INTO class_model VALUES ('1439', '100', 'XB', 'german');
INSERT INTO class_model VALUES ('1440', '100', 'xD', 'ro');
INSERT INTO class_model VALUES ('1440', '100', 'xD', 'eng');
INSERT INTO class_model VALUES ('1440', '100', 'xD', 'german');
INSERT INTO class_model VALUES ('1441', '101', 'Alhambra', 'ro');
INSERT INTO class_model VALUES ('1441', '101', 'Alhambra', 'eng');
INSERT INTO class_model VALUES ('1441', '101', 'Alhambra', 'german');
INSERT INTO class_model VALUES ('1442', '101', 'Altea', 'ro');
INSERT INTO class_model VALUES ('1442', '101', 'Altea', 'eng');
INSERT INTO class_model VALUES ('1442', '101', 'Altea', 'german');
INSERT INTO class_model VALUES ('1443', '101', 'Altea XL', 'ro');
INSERT INTO class_model VALUES ('1443', '101', 'Altea XL', 'eng');
INSERT INTO class_model VALUES ('1443', '101', 'Altea XL', 'german');
INSERT INTO class_model VALUES ('1444', '101', 'Arosa', 'ro');
INSERT INTO class_model VALUES ('1444', '101', 'Arosa', 'eng');
INSERT INTO class_model VALUES ('1444', '101', 'Arosa', 'german');
INSERT INTO class_model VALUES ('1445', '101', 'Ateca', 'ro');
INSERT INTO class_model VALUES ('1445', '101', 'Ateca', 'eng');
INSERT INTO class_model VALUES ('1445', '101', 'Ateca', 'german');
INSERT INTO class_model VALUES ('1446', '101', 'Cordoba', 'ro');
INSERT INTO class_model VALUES ('1446', '101', 'Cordoba', 'eng');
INSERT INTO class_model VALUES ('1446', '101', 'Cordoba', 'german');
INSERT INTO class_model VALUES ('1447', '101', 'Exeo', 'ro');
INSERT INTO class_model VALUES ('1447', '101', 'Exeo', 'eng');
INSERT INTO class_model VALUES ('1447', '101', 'Exeo', 'german');
INSERT INTO class_model VALUES ('1448', '101', 'Ibiza', 'ro');
INSERT INTO class_model VALUES ('1448', '101', 'Ibiza', 'eng');
INSERT INTO class_model VALUES ('1448', '101', 'Ibiza', 'german');
INSERT INTO class_model VALUES ('1449', '101', 'Inca', 'ro');
INSERT INTO class_model VALUES ('1449', '101', 'Inca', 'eng');
INSERT INTO class_model VALUES ('1449', '101', 'Inca', 'german');
INSERT INTO class_model VALUES ('1450', '101', 'Leon', 'ro');
INSERT INTO class_model VALUES ('1450', '101', 'Leon', 'eng');
INSERT INTO class_model VALUES ('1450', '101', 'Leon', 'german');
INSERT INTO class_model VALUES ('1451', '101', 'Malaga', 'ro');
INSERT INTO class_model VALUES ('1451', '101', 'Malaga', 'eng');
INSERT INTO class_model VALUES ('1451', '101', 'Malaga', 'german');
INSERT INTO class_model VALUES ('1452', '101', 'Marbella', 'ro');
INSERT INTO class_model VALUES ('1452', '101', 'Marbella', 'eng');
INSERT INTO class_model VALUES ('1452', '101', 'Marbella', 'german');
INSERT INTO class_model VALUES ('1453', '101', 'Mii', 'ro');
INSERT INTO class_model VALUES ('1453', '101', 'Mii', 'eng');
INSERT INTO class_model VALUES ('1453', '101', 'Mii', 'german');
INSERT INTO class_model VALUES ('1454', '101', 'Ronda', 'ro');
INSERT INTO class_model VALUES ('1454', '101', 'Ronda', 'eng');
INSERT INTO class_model VALUES ('1454', '101', 'Ronda', 'german');
INSERT INTO class_model VALUES ('1455', '101', 'Terra', 'ro');
INSERT INTO class_model VALUES ('1455', '101', 'Terra', 'eng');
INSERT INTO class_model VALUES ('1455', '101', 'Terra', 'german');
INSERT INTO class_model VALUES ('1456', '101', 'Toledo', 'ro');
INSERT INTO class_model VALUES ('1456', '101', 'Toledo', 'eng');
INSERT INTO class_model VALUES ('1456', '101', 'Toledo', 'german');
INSERT INTO class_model VALUES ('1457', '102', 'Sceo', 'ro');
INSERT INTO class_model VALUES ('1457', '102', 'Sceo', 'eng');
INSERT INTO class_model VALUES ('1457', '102', 'Sceo', 'german');
INSERT INTO class_model VALUES ('1458', '103', '100', 'ro');
INSERT INTO class_model VALUES ('1458', '103', '100', 'eng');
INSERT INTO class_model VALUES ('1458', '103', '100', 'german');
INSERT INTO class_model VALUES ('1459', '103', '105', 'ro');
INSERT INTO class_model VALUES ('1459', '103', '105', 'eng');
INSERT INTO class_model VALUES ('1459', '103', '105', 'german');
INSERT INTO class_model VALUES ('1460', '103', '120', 'ro');
INSERT INTO class_model VALUES ('1460', '103', '120', 'eng');
INSERT INTO class_model VALUES ('1460', '103', '120', 'german');
INSERT INTO class_model VALUES ('1461', '103', '130', 'ro');
INSERT INTO class_model VALUES ('1461', '103', '130', 'eng');
INSERT INTO class_model VALUES ('1461', '103', '130', 'german');
INSERT INTO class_model VALUES ('1462', '103', '135', 'ro');
INSERT INTO class_model VALUES ('1462', '103', '135', 'eng');
INSERT INTO class_model VALUES ('1462', '103', '135', 'german');
INSERT INTO class_model VALUES ('1463', '103', 'Citigo', 'ro');
INSERT INTO class_model VALUES ('1463', '103', 'Citigo', 'eng');
INSERT INTO class_model VALUES ('1463', '103', 'Citigo', 'german');
INSERT INTO class_model VALUES ('1464', '103', 'Fabia', 'ro');
INSERT INTO class_model VALUES ('1464', '103', 'Fabia', 'eng');
INSERT INTO class_model VALUES ('1464', '103', 'Fabia', 'german');
INSERT INTO class_model VALUES ('1465', '103', 'Favorit', 'ro');
INSERT INTO class_model VALUES ('1465', '103', 'Favorit', 'eng');
INSERT INTO class_model VALUES ('1465', '103', 'Favorit', 'german');
INSERT INTO class_model VALUES ('1466', '103', 'Felicia', 'ro');
INSERT INTO class_model VALUES ('1466', '103', 'Felicia', 'eng');
INSERT INTO class_model VALUES ('1466', '103', 'Felicia', 'german');
INSERT INTO class_model VALUES ('1467', '103', 'Forman', 'ro');
INSERT INTO class_model VALUES ('1467', '103', 'Forman', 'eng');
INSERT INTO class_model VALUES ('1467', '103', 'Forman', 'german');
INSERT INTO class_model VALUES ('1468', '103', 'Octavia', 'ro');
INSERT INTO class_model VALUES ('1468', '103', 'Octavia', 'eng');
INSERT INTO class_model VALUES ('1468', '103', 'Octavia', 'german');
INSERT INTO class_model VALUES ('1469', '103', 'Praktik', 'ro');
INSERT INTO class_model VALUES ('1469', '103', 'Praktik', 'eng');
INSERT INTO class_model VALUES ('1469', '103', 'Praktik', 'german');
INSERT INTO class_model VALUES ('1470', '103', 'RAPID', 'ro');
INSERT INTO class_model VALUES ('1470', '103', 'RAPID', 'eng');
INSERT INTO class_model VALUES ('1470', '103', 'RAPID', 'german');
INSERT INTO class_model VALUES ('1471', '103', 'Roomster', 'ro');
INSERT INTO class_model VALUES ('1471', '103', 'Roomster', 'eng');
INSERT INTO class_model VALUES ('1471', '103', 'Roomster', 'german');
INSERT INTO class_model VALUES ('1472', '103', 'Superb', 'ro');
INSERT INTO class_model VALUES ('1472', '103', 'Superb', 'eng');
INSERT INTO class_model VALUES ('1472', '103', 'Superb', 'german');
INSERT INTO class_model VALUES ('1473', '103', 'Yeti', 'ro');
INSERT INTO class_model VALUES ('1473', '103', 'Yeti', 'eng');
INSERT INTO class_model VALUES ('1473', '103', 'Yeti', 'german');
INSERT INTO class_model VALUES ('1474', '103', 'Kodiaq', 'ro');
INSERT INTO class_model VALUES ('1474', '103', 'Kodiaq', 'eng');
INSERT INTO class_model VALUES ('1474', '103', 'Kodiaq', 'german');
INSERT INTO class_model VALUES ('1475', '104', 'Crossblade', 'ro');
INSERT INTO class_model VALUES ('1475', '104', 'Crossblade', 'eng');
INSERT INTO class_model VALUES ('1475', '104', 'Crossblade', 'german');
INSERT INTO class_model VALUES ('1476', '104', 'Forfour', 'ro');
INSERT INTO class_model VALUES ('1476', '104', 'Forfour', 'eng');
INSERT INTO class_model VALUES ('1476', '104', 'Forfour', 'german');
INSERT INTO class_model VALUES ('1477', '104', 'Fortwo', 'ro');
INSERT INTO class_model VALUES ('1477', '104', 'Fortwo', 'eng');
INSERT INTO class_model VALUES ('1477', '104', 'Fortwo', 'german');
INSERT INTO class_model VALUES ('1478', '104', 'Roadster', 'ro');
INSERT INTO class_model VALUES ('1478', '104', 'Roadster', 'eng');
INSERT INTO class_model VALUES ('1478', '104', 'Roadster', 'german');
INSERT INTO class_model VALUES ('1479', '104', 'Roomster', 'ro');
INSERT INTO class_model VALUES ('1479', '104', 'Roomster', 'eng');
INSERT INTO class_model VALUES ('1479', '104', 'Roomster', 'german');
INSERT INTO class_model VALUES ('1480', '105', 'Actyon', 'ro');
INSERT INTO class_model VALUES ('1480', '105', 'Actyon', 'eng');
INSERT INTO class_model VALUES ('1480', '105', 'Actyon', 'german');
INSERT INTO class_model VALUES ('1481', '105', 'Family', 'ro');
INSERT INTO class_model VALUES ('1481', '105', 'Family', 'eng');
INSERT INTO class_model VALUES ('1481', '105', 'Family', 'german');
INSERT INTO class_model VALUES ('1482', '105', 'Korrando', 'ro');
INSERT INTO class_model VALUES ('1482', '105', 'Korrando', 'eng');
INSERT INTO class_model VALUES ('1482', '105', 'Korrando', 'german');
INSERT INTO class_model VALUES ('1483', '105', 'Kyron', 'ro');
INSERT INTO class_model VALUES ('1483', '105', 'Kyron', 'eng');
INSERT INTO class_model VALUES ('1483', '105', 'Kyron', 'german');
INSERT INTO class_model VALUES ('1484', '105', 'MUSSO', 'ro');
INSERT INTO class_model VALUES ('1484', '105', 'MUSSO', 'eng');
INSERT INTO class_model VALUES ('1484', '105', 'MUSSO', 'german');
INSERT INTO class_model VALUES ('1485', '105', 'REXTON', 'ro');
INSERT INTO class_model VALUES ('1485', '105', 'REXTON', 'eng');
INSERT INTO class_model VALUES ('1485', '105', 'REXTON', 'german');
INSERT INTO class_model VALUES ('1486', '105', 'Rodius', 'ro');
INSERT INTO class_model VALUES ('1486', '105', 'Rodius', 'eng');
INSERT INTO class_model VALUES ('1486', '105', 'Rodius', 'german');
INSERT INTO class_model VALUES ('1487', '105', 'Tivoli', 'ro');
INSERT INTO class_model VALUES ('1487', '105', 'Tivoli', 'eng');
INSERT INTO class_model VALUES ('1487', '105', 'Tivoli', 'german');
INSERT INTO class_model VALUES ('1488', '106', '1800 Coupe', 'ro');
INSERT INTO class_model VALUES ('1488', '106', '1800 Coupe', 'eng');
INSERT INTO class_model VALUES ('1488', '106', '1800 Coupe', 'german');
INSERT INTO class_model VALUES ('1489', '106', 'B9 Tribeca', 'ro');
INSERT INTO class_model VALUES ('1489', '106', 'B9 Tribeca', 'eng');
INSERT INTO class_model VALUES ('1489', '106', 'B9 Tribeca', 'german');
INSERT INTO class_model VALUES ('1490', '106', 'BRZ', 'ro');
INSERT INTO class_model VALUES ('1490', '106', 'BRZ', 'eng');
INSERT INTO class_model VALUES ('1490', '106', 'BRZ', 'german');
INSERT INTO class_model VALUES ('1491', '106', 'Baja', 'ro');
INSERT INTO class_model VALUES ('1491', '106', 'Baja', 'eng');
INSERT INTO class_model VALUES ('1491', '106', 'Baja', 'german');
INSERT INTO class_model VALUES ('1492', '106', 'Forester', 'ro');
INSERT INTO class_model VALUES ('1492', '106', 'Forester', 'eng');
INSERT INTO class_model VALUES ('1492', '106', 'Forester', 'german');
INSERT INTO class_model VALUES ('1493', '106', 'G3X Justy', 'ro');
INSERT INTO class_model VALUES ('1493', '106', 'G3X Justy', 'eng');
INSERT INTO class_model VALUES ('1493', '106', 'G3X Justy', 'german');
INSERT INTO class_model VALUES ('1494', '106', 'Impreza', 'ro');
INSERT INTO class_model VALUES ('1494', '106', 'Impreza', 'eng');
INSERT INTO class_model VALUES ('1494', '106', 'Impreza', 'german');
INSERT INTO class_model VALUES ('1495', '106', 'Justy', 'ro');
INSERT INTO class_model VALUES ('1495', '106', 'Justy', 'eng');
INSERT INTO class_model VALUES ('1495', '106', 'Justy', 'german');
INSERT INTO class_model VALUES ('1496', '106', 'Legacy', 'ro');
INSERT INTO class_model VALUES ('1496', '106', 'Legacy', 'eng');
INSERT INTO class_model VALUES ('1496', '106', 'Legacy', 'german');
INSERT INTO class_model VALUES ('1497', '106', 'OUTBACK', 'ro');
INSERT INTO class_model VALUES ('1497', '106', 'OUTBACK', 'eng');
INSERT INTO class_model VALUES ('1497', '106', 'OUTBACK', 'german');
INSERT INTO class_model VALUES ('1498', '106', 'SVX', 'ro');
INSERT INTO class_model VALUES ('1498', '106', 'SVX', 'eng');
INSERT INTO class_model VALUES ('1498', '106', 'SVX', 'german');
INSERT INTO class_model VALUES ('1499', '106', 'Trezia', 'ro');
INSERT INTO class_model VALUES ('1499', '106', 'Trezia', 'eng');
INSERT INTO class_model VALUES ('1499', '106', 'Trezia', 'german');
INSERT INTO class_model VALUES ('1500', '106', 'Tribeca', 'ro');
INSERT INTO class_model VALUES ('1500', '106', 'Tribeca', 'eng');
INSERT INTO class_model VALUES ('1500', '106', 'Tribeca', 'german');
INSERT INTO class_model VALUES ('1501', '106', 'Vivio', 'ro');
INSERT INTO class_model VALUES ('1501', '106', 'Vivio', 'eng');
INSERT INTO class_model VALUES ('1501', '106', 'Vivio', 'german');
INSERT INTO class_model VALUES ('1502', '106', 'XT', 'ro');
INSERT INTO class_model VALUES ('1502', '106', 'XT', 'eng');
INSERT INTO class_model VALUES ('1502', '106', 'XT', 'german');
INSERT INTO class_model VALUES ('1503', '106', 'XV', 'ro');
INSERT INTO class_model VALUES ('1503', '106', 'XV', 'eng');
INSERT INTO class_model VALUES ('1503', '106', 'XV', 'german');
INSERT INTO class_model VALUES ('1504', '107', 'Alto', 'ro');
INSERT INTO class_model VALUES ('1504', '107', 'Alto', 'eng');
INSERT INTO class_model VALUES ('1504', '107', 'Alto', 'german');
INSERT INTO class_model VALUES ('1505', '107', 'Baleno', 'ro');
INSERT INTO class_model VALUES ('1505', '107', 'Baleno', 'eng');
INSERT INTO class_model VALUES ('1505', '107', 'Baleno', 'german');
INSERT INTO class_model VALUES ('1506', '107', 'Cappucino', 'ro');
INSERT INTO class_model VALUES ('1506', '107', 'Cappucino', 'eng');
INSERT INTO class_model VALUES ('1506', '107', 'Cappucino', 'german');
INSERT INTO class_model VALUES ('1507', '107', 'Carry', 'ro');
INSERT INTO class_model VALUES ('1507', '107', 'Carry', 'eng');
INSERT INTO class_model VALUES ('1507', '107', 'Carry', 'german');
INSERT INTO class_model VALUES ('1508', '107', 'Grand Vitara', 'ro');
INSERT INTO class_model VALUES ('1508', '107', 'Grand Vitara', 'eng');
INSERT INTO class_model VALUES ('1508', '107', 'Grand Vitara', 'german');
INSERT INTO class_model VALUES ('1509', '107', 'Ignis', 'ro');
INSERT INTO class_model VALUES ('1509', '107', 'Ignis', 'eng');
INSERT INTO class_model VALUES ('1509', '107', 'Ignis', 'german');
INSERT INTO class_model VALUES ('1510', '107', 'Jimny', 'ro');
INSERT INTO class_model VALUES ('1510', '107', 'Jimny', 'eng');
INSERT INTO class_model VALUES ('1510', '107', 'Jimny', 'german');
INSERT INTO class_model VALUES ('1511', '107', 'Kizashi', 'ro');
INSERT INTO class_model VALUES ('1511', '107', 'Kizashi', 'eng');
INSERT INTO class_model VALUES ('1511', '107', 'Kizashi', 'german');
INSERT INTO class_model VALUES ('1512', '107', 'LJ', 'ro');
INSERT INTO class_model VALUES ('1512', '107', 'LJ', 'eng');
INSERT INTO class_model VALUES ('1512', '107', 'LJ', 'german');
INSERT INTO class_model VALUES ('1513', '107', 'Liana', 'ro');
INSERT INTO class_model VALUES ('1513', '107', 'Liana', 'eng');
INSERT INTO class_model VALUES ('1513', '107', 'Liana', 'german');
INSERT INTO class_model VALUES ('1514', '107', 'Reno', 'ro');
INSERT INTO class_model VALUES ('1514', '107', 'Reno', 'eng');
INSERT INTO class_model VALUES ('1514', '107', 'Reno', 'german');
INSERT INTO class_model VALUES ('1515', '107', 'SJ', 'ro');
INSERT INTO class_model VALUES ('1515', '107', 'SJ', 'eng');
INSERT INTO class_model VALUES ('1515', '107', 'SJ', 'german');
INSERT INTO class_model VALUES ('1516', '107', 'SX4', 'ro');
INSERT INTO class_model VALUES ('1516', '107', 'SX4', 'eng');
INSERT INTO class_model VALUES ('1516', '107', 'SX4', 'german');
INSERT INTO class_model VALUES ('1517', '107', 'SX4 S-Cross', 'ro');
INSERT INTO class_model VALUES ('1517', '107', 'SX4 S-Cross', 'eng');
INSERT INTO class_model VALUES ('1517', '107', 'SX4 S-Cross', 'german');
INSERT INTO class_model VALUES ('1518', '107', 'Samurai', 'ro');
INSERT INTO class_model VALUES ('1518', '107', 'Samurai', 'eng');
INSERT INTO class_model VALUES ('1518', '107', 'Samurai', 'german');
INSERT INTO class_model VALUES ('1519', '107', 'Splash', 'ro');
INSERT INTO class_model VALUES ('1519', '107', 'Splash', 'eng');
INSERT INTO class_model VALUES ('1519', '107', 'Splash', 'german');
INSERT INTO class_model VALUES ('1520', '107', 'Super-Carry', 'ro');
INSERT INTO class_model VALUES ('1520', '107', 'Super-Carry', 'eng');
INSERT INTO class_model VALUES ('1520', '107', 'Super-Carry', 'german');
INSERT INTO class_model VALUES ('1521', '107', 'Swift', 'ro');
INSERT INTO class_model VALUES ('1521', '107', 'Swift', 'eng');
INSERT INTO class_model VALUES ('1521', '107', 'Swift', 'german');
INSERT INTO class_model VALUES ('1522', '107', 'Vitara', 'ro');
INSERT INTO class_model VALUES ('1522', '107', 'Vitara', 'eng');
INSERT INTO class_model VALUES ('1522', '107', 'Vitara', 'german');
INSERT INTO class_model VALUES ('1523', '107', 'Wagon R+', 'ro');
INSERT INTO class_model VALUES ('1523', '107', 'Wagon R+', 'eng');
INSERT INTO class_model VALUES ('1523', '107', 'Wagon R+', 'german');
INSERT INTO class_model VALUES ('1524', '107', 'X-90', 'ro');
INSERT INTO class_model VALUES ('1524', '107', 'X-90', 'eng');
INSERT INTO class_model VALUES ('1524', '107', 'X-90', 'german');
INSERT INTO class_model VALUES ('1525', '107', 'XL7', 'ro');
INSERT INTO class_model VALUES ('1525', '107', 'XL7', 'eng');
INSERT INTO class_model VALUES ('1525', '107', 'XL7', 'german');
INSERT INTO class_model VALUES ('1526', '107', 'Celerio', 'ro');
INSERT INTO class_model VALUES ('1526', '107', 'Celerio', 'eng');
INSERT INTO class_model VALUES ('1526', '107', 'Celerio', 'german');
INSERT INTO class_model VALUES ('1527', '108', '101', 'ro');
INSERT INTO class_model VALUES ('1527', '108', '101', 'eng');
INSERT INTO class_model VALUES ('1527', '108', '101', 'german');
INSERT INTO class_model VALUES ('1528', '108', '102', 'ro');
INSERT INTO class_model VALUES ('1528', '108', '102', 'eng');
INSERT INTO class_model VALUES ('1528', '108', '102', 'german');
INSERT INTO class_model VALUES ('1529', '108', '103', 'ro');
INSERT INTO class_model VALUES ('1529', '108', '103', 'eng');
INSERT INTO class_model VALUES ('1529', '108', '103', 'german');
INSERT INTO class_model VALUES ('1530', '108', '104', 'ro');
INSERT INTO class_model VALUES ('1530', '108', '104', 'eng');
INSERT INTO class_model VALUES ('1530', '108', '104', 'german');
INSERT INTO class_model VALUES ('1531', '108', '105', 'ro');
INSERT INTO class_model VALUES ('1531', '108', '105', 'eng');
INSERT INTO class_model VALUES ('1531', '108', '105', 'german');
INSERT INTO class_model VALUES ('1532', '108', 'Bosto', 'ro');
INSERT INTO class_model VALUES ('1532', '108', 'Bosto', 'eng');
INSERT INTO class_model VALUES ('1532', '108', 'Bosto', 'german');
INSERT INTO class_model VALUES ('1533', '108', 'R-20', 'ro');
INSERT INTO class_model VALUES ('1533', '108', 'R-20', 'eng');
INSERT INTO class_model VALUES ('1533', '108', 'R-20', 'german');
INSERT INTO class_model VALUES ('1534', '109', 'Horizon', 'ro');
INSERT INTO class_model VALUES ('1534', '109', 'Horizon', 'eng');
INSERT INTO class_model VALUES ('1534', '109', 'Horizon', 'german');
INSERT INTO class_model VALUES ('1535', '109', 'Rancho', 'ro');
INSERT INTO class_model VALUES ('1535', '109', 'Rancho', 'eng');
INSERT INTO class_model VALUES ('1535', '109', 'Rancho', 'german');
INSERT INTO class_model VALUES ('1536', '109', 'Samba', 'ro');
INSERT INTO class_model VALUES ('1536', '109', 'Samba', 'eng');
INSERT INTO class_model VALUES ('1536', '109', 'Samba', 'german');
INSERT INTO class_model VALUES ('1537', '110', '233', 'ro');
INSERT INTO class_model VALUES ('1537', '110', '233', 'eng');
INSERT INTO class_model VALUES ('1537', '110', '233', 'german');
INSERT INTO class_model VALUES ('1538', '110', '235', 'ro');
INSERT INTO class_model VALUES ('1538', '110', '235', 'eng');
INSERT INTO class_model VALUES ('1538', '110', '235', 'german');
INSERT INTO class_model VALUES ('1539', '110', '237', 'ro');
INSERT INTO class_model VALUES ('1539', '110', '237', 'eng');
INSERT INTO class_model VALUES ('1539', '110', '237', 'german');
INSERT INTO class_model VALUES ('1540', '110', 'Honker', 'ro');
INSERT INTO class_model VALUES ('1540', '110', 'Honker', 'eng');
INSERT INTO class_model VALUES ('1540', '110', 'Honker', 'german');
INSERT INTO class_model VALUES ('1541', '111', 'Indica', 'ro');
INSERT INTO class_model VALUES ('1541', '111', 'Indica', 'eng');
INSERT INTO class_model VALUES ('1541', '111', 'Indica', 'german');
INSERT INTO class_model VALUES ('1542', '111', 'Indigo', 'ro');
INSERT INTO class_model VALUES ('1542', '111', 'Indigo', 'eng');
INSERT INTO class_model VALUES ('1542', '111', 'Indigo', 'german');
INSERT INTO class_model VALUES ('1543', '111', 'Nano', 'ro');
INSERT INTO class_model VALUES ('1543', '111', 'Nano', 'eng');
INSERT INTO class_model VALUES ('1543', '111', 'Nano', 'german');
INSERT INTO class_model VALUES ('1544', '111', 'Safari', 'ro');
INSERT INTO class_model VALUES ('1544', '111', 'Safari', 'eng');
INSERT INTO class_model VALUES ('1544', '111', 'Safari', 'german');
INSERT INTO class_model VALUES ('1545', '111', 'Xenon', 'ro');
INSERT INTO class_model VALUES ('1545', '111', 'Xenon', 'eng');
INSERT INTO class_model VALUES ('1545', '111', 'Xenon', 'german');
INSERT INTO class_model VALUES ('1546', '112', 'T613', 'ro');
INSERT INTO class_model VALUES ('1546', '112', 'T613', 'eng');
INSERT INTO class_model VALUES ('1546', '112', 'T613', 'german');
INSERT INTO class_model VALUES ('1547', '112', 'T613-4', 'ro');
INSERT INTO class_model VALUES ('1547', '112', 'T613-4', 'eng');
INSERT INTO class_model VALUES ('1547', '112', 'T613-4', 'german');
INSERT INTO class_model VALUES ('1548', '112', 'T700', 'ro');
INSERT INTO class_model VALUES ('1548', '112', 'T700', 'eng');
INSERT INTO class_model VALUES ('1548', '112', 'T700', 'german');
INSERT INTO class_model VALUES ('1549', '113', 'ZAZ 1102', 'ro');
INSERT INTO class_model VALUES ('1549', '113', 'ZAZ 1102', 'eng');
INSERT INTO class_model VALUES ('1549', '113', 'ZAZ 1102', 'german');
INSERT INTO class_model VALUES ('1550', '113', 'ZAZ 1103', 'ro');
INSERT INTO class_model VALUES ('1550', '113', 'ZAZ 1103', 'eng');
INSERT INTO class_model VALUES ('1550', '113', 'ZAZ 1103', 'german');
INSERT INTO class_model VALUES ('1551', '113', 'ZAZ 1105', 'ro');
INSERT INTO class_model VALUES ('1551', '113', 'ZAZ 1105', 'eng');
INSERT INTO class_model VALUES ('1551', '113', 'ZAZ 1105', 'german');
INSERT INTO class_model VALUES ('1552', '114', 'Roadster', 'ro');
INSERT INTO class_model VALUES ('1552', '114', 'Roadster', 'eng');
INSERT INTO class_model VALUES ('1552', '114', 'Roadster', 'german');
INSERT INTO class_model VALUES ('1553', '114', 'S', 'ro');
INSERT INTO class_model VALUES ('1553', '114', 'S', 'eng');
INSERT INTO class_model VALUES ('1553', '114', 'S', 'german');
INSERT INTO class_model VALUES ('1554', '115', '4-Runner', 'ro');
INSERT INTO class_model VALUES ('1554', '115', '4-Runner', 'eng');
INSERT INTO class_model VALUES ('1554', '115', '4-Runner', 'german');
INSERT INTO class_model VALUES ('1555', '115', 'Auris', 'ro');
INSERT INTO class_model VALUES ('1555', '115', 'Auris', 'eng');
INSERT INTO class_model VALUES ('1555', '115', 'Auris', 'german');
INSERT INTO class_model VALUES ('1556', '115', 'Auris Touring Sports', 'ro');
INSERT INTO class_model VALUES ('1556', '115', 'Auris Touring Sports', 'eng');
INSERT INTO class_model VALUES ('1556', '115', 'Auris Touring Sports', 'german');
INSERT INTO class_model VALUES ('1557', '115', 'Avalon', 'ro');
INSERT INTO class_model VALUES ('1557', '115', 'Avalon', 'eng');
INSERT INTO class_model VALUES ('1557', '115', 'Avalon', 'german');
INSERT INTO class_model VALUES ('1558', '115', 'Avensis', 'ro');
INSERT INTO class_model VALUES ('1558', '115', 'Avensis', 'eng');
INSERT INTO class_model VALUES ('1558', '115', 'Avensis', 'german');
INSERT INTO class_model VALUES ('1559', '115', 'Avensis Verso', 'ro');
INSERT INTO class_model VALUES ('1559', '115', 'Avensis Verso', 'eng');
INSERT INTO class_model VALUES ('1559', '115', 'Avensis Verso', 'german');
INSERT INTO class_model VALUES ('1560', '115', 'Aygo', 'ro');
INSERT INTO class_model VALUES ('1560', '115', 'Aygo', 'eng');
INSERT INTO class_model VALUES ('1560', '115', 'Aygo', 'german');
INSERT INTO class_model VALUES ('1561', '115', 'Camry', 'ro');
INSERT INTO class_model VALUES ('1561', '115', 'Camry', 'eng');
INSERT INTO class_model VALUES ('1561', '115', 'Camry', 'german');
INSERT INTO class_model VALUES ('1562', '115', 'Camry Solara', 'ro');
INSERT INTO class_model VALUES ('1562', '115', 'Camry Solara', 'eng');
INSERT INTO class_model VALUES ('1562', '115', 'Camry Solara', 'german');
INSERT INTO class_model VALUES ('1563', '115', 'Carina', 'ro');
INSERT INTO class_model VALUES ('1563', '115', 'Carina', 'eng');
INSERT INTO class_model VALUES ('1563', '115', 'Carina', 'german');
INSERT INTO class_model VALUES ('1564', '115', 'Celica', 'ro');
INSERT INTO class_model VALUES ('1564', '115', 'Celica', 'eng');
INSERT INTO class_model VALUES ('1564', '115', 'Celica', 'german');
INSERT INTO class_model VALUES ('1565', '115', 'Corolla', 'ro');
INSERT INTO class_model VALUES ('1565', '115', 'Corolla', 'eng');
INSERT INTO class_model VALUES ('1565', '115', 'Corolla', 'german');
INSERT INTO class_model VALUES ('1566', '115', 'Corolla Verso', 'ro');
INSERT INTO class_model VALUES ('1566', '115', 'Corolla Verso', 'eng');
INSERT INTO class_model VALUES ('1566', '115', 'Corolla Verso', 'german');
INSERT INTO class_model VALUES ('1567', '115', 'Cressida', 'ro');
INSERT INTO class_model VALUES ('1567', '115', 'Cressida', 'eng');
INSERT INTO class_model VALUES ('1567', '115', 'Cressida', 'german');
INSERT INTO class_model VALUES ('1568', '115', 'Crown', 'ro');
INSERT INTO class_model VALUES ('1568', '115', 'Crown', 'eng');
INSERT INTO class_model VALUES ('1568', '115', 'Crown', 'german');
INSERT INTO class_model VALUES ('1569', '115', 'Dyna', 'ro');
INSERT INTO class_model VALUES ('1569', '115', 'Dyna', 'eng');
INSERT INTO class_model VALUES ('1569', '115', 'Dyna', 'german');
INSERT INTO class_model VALUES ('1570', '115', 'FJ', 'ro');
INSERT INTO class_model VALUES ('1570', '115', 'FJ', 'eng');
INSERT INTO class_model VALUES ('1570', '115', 'FJ', 'german');
INSERT INTO class_model VALUES ('1571', '115', 'GT86', 'ro');
INSERT INTO class_model VALUES ('1571', '115', 'GT86', 'eng');
INSERT INTO class_model VALUES ('1571', '115', 'GT86', 'german');
INSERT INTO class_model VALUES ('1572', '115', 'Harrier', 'ro');
INSERT INTO class_model VALUES ('1572', '115', 'Harrier', 'eng');
INSERT INTO class_model VALUES ('1572', '115', 'Harrier', 'german');
INSERT INTO class_model VALUES ('1573', '115', 'Hiace', 'ro');
INSERT INTO class_model VALUES ('1573', '115', 'Hiace', 'eng');
INSERT INTO class_model VALUES ('1573', '115', 'Hiace', 'german');
INSERT INTO class_model VALUES ('1574', '115', 'Highlander', 'ro');
INSERT INTO class_model VALUES ('1574', '115', 'Highlander', 'eng');
INSERT INTO class_model VALUES ('1574', '115', 'Highlander', 'german');
INSERT INTO class_model VALUES ('1575', '115', 'Hilux', 'ro');
INSERT INTO class_model VALUES ('1575', '115', 'Hilux', 'eng');
INSERT INTO class_model VALUES ('1575', '115', 'Hilux', 'german');
INSERT INTO class_model VALUES ('1576', '115', 'Land Cruiser', 'ro');
INSERT INTO class_model VALUES ('1576', '115', 'Land Cruiser', 'eng');
INSERT INTO class_model VALUES ('1576', '115', 'Land Cruiser', 'german');
INSERT INTO class_model VALUES ('1577', '115', 'Lite-Ace', 'ro');
INSERT INTO class_model VALUES ('1577', '115', 'Lite-Ace', 'eng');
INSERT INTO class_model VALUES ('1577', '115', 'Lite-Ace', 'german');
INSERT INTO class_model VALUES ('1578', '115', 'MR2', 'ro');
INSERT INTO class_model VALUES ('1578', '115', 'MR2', 'eng');
INSERT INTO class_model VALUES ('1578', '115', 'MR2', 'german');
INSERT INTO class_model VALUES ('1579', '115', 'Matrix', 'ro');
INSERT INTO class_model VALUES ('1579', '115', 'Matrix', 'eng');
INSERT INTO class_model VALUES ('1579', '115', 'Matrix', 'german');
INSERT INTO class_model VALUES ('1580', '115', 'Paseo', 'ro');
INSERT INTO class_model VALUES ('1580', '115', 'Paseo', 'eng');
INSERT INTO class_model VALUES ('1580', '115', 'Paseo', 'german');
INSERT INTO class_model VALUES ('1581', '115', 'Picnic', 'ro');
INSERT INTO class_model VALUES ('1581', '115', 'Picnic', 'eng');
INSERT INTO class_model VALUES ('1581', '115', 'Picnic', 'german');
INSERT INTO class_model VALUES ('1582', '115', 'Previa', 'ro');
INSERT INTO class_model VALUES ('1582', '115', 'Previa', 'eng');
INSERT INTO class_model VALUES ('1582', '115', 'Previa', 'german');
INSERT INTO class_model VALUES ('1583', '115', 'Prius', 'ro');
INSERT INTO class_model VALUES ('1583', '115', 'Prius', 'eng');
INSERT INTO class_model VALUES ('1583', '115', 'Prius', 'german');
INSERT INTO class_model VALUES ('1584', '115', 'Proace', 'ro');
INSERT INTO class_model VALUES ('1584', '115', 'Proace', 'eng');
INSERT INTO class_model VALUES ('1584', '115', 'Proace', 'german');
INSERT INTO class_model VALUES ('1585', '115', 'RAV-4', 'ro');
INSERT INTO class_model VALUES ('1585', '115', 'RAV-4', 'eng');
INSERT INTO class_model VALUES ('1585', '115', 'RAV-4', 'german');
INSERT INTO class_model VALUES ('1586', '115', 'Sequoia', 'ro');
INSERT INTO class_model VALUES ('1586', '115', 'Sequoia', 'eng');
INSERT INTO class_model VALUES ('1586', '115', 'Sequoia', 'german');
INSERT INTO class_model VALUES ('1587', '115', 'Sienna', 'ro');
INSERT INTO class_model VALUES ('1587', '115', 'Sienna', 'eng');
INSERT INTO class_model VALUES ('1587', '115', 'Sienna', 'german');
INSERT INTO class_model VALUES ('1588', '115', 'Starlet', 'ro');
INSERT INTO class_model VALUES ('1588', '115', 'Starlet', 'eng');
INSERT INTO class_model VALUES ('1588', '115', 'Starlet', 'german');
INSERT INTO class_model VALUES ('1589', '115', 'Supra', 'ro');
INSERT INTO class_model VALUES ('1589', '115', 'Supra', 'eng');
INSERT INTO class_model VALUES ('1589', '115', 'Supra', 'german');
INSERT INTO class_model VALUES ('1590', '115', 'Tacoma', 'ro');
INSERT INTO class_model VALUES ('1590', '115', 'Tacoma', 'eng');
INSERT INTO class_model VALUES ('1590', '115', 'Tacoma', 'german');
INSERT INTO class_model VALUES ('1591', '115', 'Tercel', 'ro');
INSERT INTO class_model VALUES ('1591', '115', 'Tercel', 'eng');
INSERT INTO class_model VALUES ('1591', '115', 'Tercel', 'german');
INSERT INTO class_model VALUES ('1592', '115', 'Tundra', 'ro');
INSERT INTO class_model VALUES ('1592', '115', 'Tundra', 'eng');
INSERT INTO class_model VALUES ('1592', '115', 'Tundra', 'german');
INSERT INTO class_model VALUES ('1593', '115', 'Urban Cruiser', 'ro');
INSERT INTO class_model VALUES ('1593', '115', 'Urban Cruiser', 'eng');
INSERT INTO class_model VALUES ('1593', '115', 'Urban Cruiser', 'german');
INSERT INTO class_model VALUES ('1594', '115', 'Venza', 'ro');
INSERT INTO class_model VALUES ('1594', '115', 'Venza', 'eng');
INSERT INTO class_model VALUES ('1594', '115', 'Venza', 'german');
INSERT INTO class_model VALUES ('1595', '115', 'Verso', 'ro');
INSERT INTO class_model VALUES ('1595', '115', 'Verso', 'eng');
INSERT INTO class_model VALUES ('1595', '115', 'Verso', 'german');
INSERT INTO class_model VALUES ('1596', '115', 'Yaris', 'ro');
INSERT INTO class_model VALUES ('1596', '115', 'Yaris', 'eng');
INSERT INTO class_model VALUES ('1596', '115', 'Yaris', 'german');
INSERT INTO class_model VALUES ('1597', '115', 'Yaris Verso', 'ro');
INSERT INTO class_model VALUES ('1597', '115', 'Yaris Verso', 'eng');
INSERT INTO class_model VALUES ('1597', '115', 'Yaris Verso', 'german');
INSERT INTO class_model VALUES ('1598', '115', 'iQ', 'ro');
INSERT INTO class_model VALUES ('1598', '115', 'iQ', 'eng');
INSERT INTO class_model VALUES ('1598', '115', 'iQ', 'german');
INSERT INTO class_model VALUES ('1599', '115', 'C-HR', 'ro');
INSERT INTO class_model VALUES ('1599', '115', 'C-HR', 'eng');
INSERT INTO class_model VALUES ('1599', '115', 'C-HR', 'german');
INSERT INTO class_model VALUES ('1600', '116', '601', 'ro');
INSERT INTO class_model VALUES ('1600', '116', '601', 'eng');
INSERT INTO class_model VALUES ('1600', '116', '601', 'german');
INSERT INTO class_model VALUES ('1601', '116', 'P 50', 'ro');
INSERT INTO class_model VALUES ('1601', '116', 'P 50', 'eng');
INSERT INTO class_model VALUES ('1601', '116', 'P 50', 'german');
INSERT INTO class_model VALUES ('1602', '117', 'Dolomite', 'ro');
INSERT INTO class_model VALUES ('1602', '117', 'Dolomite', 'eng');
INSERT INTO class_model VALUES ('1602', '117', 'Dolomite', 'german');
INSERT INTO class_model VALUES ('1603', '117', 'Moss', 'ro');
INSERT INTO class_model VALUES ('1603', '117', 'Moss', 'eng');
INSERT INTO class_model VALUES ('1603', '117', 'Moss', 'german');
INSERT INTO class_model VALUES ('1604', '117', 'Spitfire', 'ro');
INSERT INTO class_model VALUES ('1604', '117', 'Spitfire', 'eng');
INSERT INTO class_model VALUES ('1604', '117', 'Spitfire', 'german');
INSERT INTO class_model VALUES ('1605', '117', 'TR3', 'ro');
INSERT INTO class_model VALUES ('1605', '117', 'TR3', 'eng');
INSERT INTO class_model VALUES ('1605', '117', 'TR3', 'german');
INSERT INTO class_model VALUES ('1606', '117', 'TR4', 'ro');
INSERT INTO class_model VALUES ('1606', '117', 'TR4', 'eng');
INSERT INTO class_model VALUES ('1606', '117', 'TR4', 'german');
INSERT INTO class_model VALUES ('1607', '117', 'TR5', 'ro');
INSERT INTO class_model VALUES ('1607', '117', 'TR5', 'eng');
INSERT INTO class_model VALUES ('1607', '117', 'TR5', 'german');
INSERT INTO class_model VALUES ('1608', '117', 'TR6', 'ro');
INSERT INTO class_model VALUES ('1608', '117', 'TR6', 'eng');
INSERT INTO class_model VALUES ('1608', '117', 'TR6', 'german');
INSERT INTO class_model VALUES ('1609', '117', 'TR7', 'ro');
INSERT INTO class_model VALUES ('1609', '117', 'TR7', 'eng');
INSERT INTO class_model VALUES ('1609', '117', 'TR7', 'german');
INSERT INTO class_model VALUES ('1610', '117', 'TR8', 'ro');
INSERT INTO class_model VALUES ('1610', '117', 'TR8', 'eng');
INSERT INTO class_model VALUES ('1610', '117', 'TR8', 'german');
INSERT INTO class_model VALUES ('1611', '118', 'Cerbera', 'ro');
INSERT INTO class_model VALUES ('1611', '118', 'Cerbera', 'eng');
INSERT INTO class_model VALUES ('1611', '118', 'Cerbera', 'german');
INSERT INTO class_model VALUES ('1612', '118', 'Chimaera', 'ro');
INSERT INTO class_model VALUES ('1612', '118', 'Chimaera', 'eng');
INSERT INTO class_model VALUES ('1612', '118', 'Chimaera', 'german');
INSERT INTO class_model VALUES ('1613', '118', 'Griffith', 'ro');
INSERT INTO class_model VALUES ('1613', '118', 'Griffith', 'eng');
INSERT INTO class_model VALUES ('1613', '118', 'Griffith', 'german');
INSERT INTO class_model VALUES ('1614', '118', 'Tamora', 'ro');
INSERT INTO class_model VALUES ('1614', '118', 'Tamora', 'eng');
INSERT INTO class_model VALUES ('1614', '118', 'Tamora', 'german');
INSERT INTO class_model VALUES ('1615', '118', 'Tasmin', 'ro');
INSERT INTO class_model VALUES ('1615', '118', 'Tasmin', 'eng');
INSERT INTO class_model VALUES ('1615', '118', 'Tasmin', 'german');
INSERT INTO class_model VALUES ('1616', '118', 'Tuscan', 'ro');
INSERT INTO class_model VALUES ('1616', '118', 'Tuscan', 'eng');
INSERT INTO class_model VALUES ('1616', '118', 'Tuscan', 'german');
INSERT INTO class_model VALUES ('1617', '118', 'Vixen', 'ro');
INSERT INTO class_model VALUES ('1617', '118', 'Vixen', 'eng');
INSERT INTO class_model VALUES ('1617', '118', 'Vixen', 'german');
INSERT INTO class_model VALUES ('1618', '119', '3153', 'ro');
INSERT INTO class_model VALUES ('1618', '119', '3153', 'eng');
INSERT INTO class_model VALUES ('1618', '119', '3153', 'german');
INSERT INTO class_model VALUES ('1619', '119', '3162', 'ro');
INSERT INTO class_model VALUES ('1619', '119', '3162', 'eng');
INSERT INTO class_model VALUES ('1619', '119', '3162', 'german');
INSERT INTO class_model VALUES ('1620', '119', '452', 'ro');
INSERT INTO class_model VALUES ('1620', '119', '452', 'eng');
INSERT INTO class_model VALUES ('1620', '119', '452', 'german');
INSERT INTO class_model VALUES ('1621', '119', '469 B', 'ro');
INSERT INTO class_model VALUES ('1621', '119', '469 B', 'eng');
INSERT INTO class_model VALUES ('1621', '119', '469 B', 'german');
INSERT INTO class_model VALUES ('1622', '120', 'Asta', 'ro');
INSERT INTO class_model VALUES ('1622', '120', 'Asta', 'eng');
INSERT INTO class_model VALUES ('1622', '120', 'Asta', 'german');
INSERT INTO class_model VALUES ('1623', '120', 'Frontera', 'ro');
INSERT INTO class_model VALUES ('1623', '120', 'Frontera', 'eng');
INSERT INTO class_model VALUES ('1623', '120', 'Frontera', 'german');
INSERT INTO class_model VALUES ('1624', '120', 'Omega', 'ro');
INSERT INTO class_model VALUES ('1624', '120', 'Omega', 'eng');
INSERT INTO class_model VALUES ('1624', '120', 'Omega', 'german');
INSERT INTO class_model VALUES ('1625', '120', 'Vectra', 'ro');
INSERT INTO class_model VALUES ('1625', '120', 'Vectra', 'eng');
INSERT INTO class_model VALUES ('1625', '120', 'Vectra', 'german');
INSERT INTO class_model VALUES ('1626', '121', '181', 'ro');
INSERT INTO class_model VALUES ('1626', '121', '181', 'eng');
INSERT INTO class_model VALUES ('1626', '121', '181', 'german');
INSERT INTO class_model VALUES ('1627', '121', 'Amarok', 'ro');
INSERT INTO class_model VALUES ('1627', '121', 'Amarok', 'eng');
INSERT INTO class_model VALUES ('1627', '121', 'Amarok', 'german');
INSERT INTO class_model VALUES ('1628', '121', 'Beetle', 'ro');
INSERT INTO class_model VALUES ('1628', '121', 'Beetle', 'eng');
INSERT INTO class_model VALUES ('1628', '121', 'Beetle', 'german');
INSERT INTO class_model VALUES ('1629', '121', 'Bora', 'ro');
INSERT INTO class_model VALUES ('1629', '121', 'Bora', 'eng');
INSERT INTO class_model VALUES ('1629', '121', 'Bora', 'german');
INSERT INTO class_model VALUES ('1630', '121', 'Buggy', 'ro');
INSERT INTO class_model VALUES ('1630', '121', 'Buggy', 'eng');
INSERT INTO class_model VALUES ('1630', '121', 'Buggy', 'german');
INSERT INTO class_model VALUES ('1631', '121', 'CC', 'ro');
INSERT INTO class_model VALUES ('1631', '121', 'CC', 'eng');
INSERT INTO class_model VALUES ('1631', '121', 'CC', 'german');
INSERT INTO class_model VALUES ('1632', '121', 'Caddy', 'ro');
INSERT INTO class_model VALUES ('1632', '121', 'Caddy', 'eng');
INSERT INTO class_model VALUES ('1632', '121', 'Caddy', 'german');
INSERT INTO class_model VALUES ('1633', '121', 'California', 'ro');
INSERT INTO class_model VALUES ('1633', '121', 'California', 'eng');
INSERT INTO class_model VALUES ('1633', '121', 'California', 'german');
INSERT INTO class_model VALUES ('1634', '121', 'Caravelle', 'ro');
INSERT INTO class_model VALUES ('1634', '121', 'Caravelle', 'eng');
INSERT INTO class_model VALUES ('1634', '121', 'Caravelle', 'german');
INSERT INTO class_model VALUES ('1635', '121', 'Corado', 'ro');
INSERT INTO class_model VALUES ('1635', '121', 'Corado', 'eng');
INSERT INTO class_model VALUES ('1635', '121', 'Corado', 'german');
INSERT INTO class_model VALUES ('1636', '121', 'Cross', 'ro');
INSERT INTO class_model VALUES ('1636', '121', 'Cross', 'eng');
INSERT INTO class_model VALUES ('1636', '121', 'Cross', 'german');
INSERT INTO class_model VALUES ('1637', '121', 'EOS', 'ro');
INSERT INTO class_model VALUES ('1637', '121', 'EOS', 'eng');
INSERT INTO class_model VALUES ('1637', '121', 'EOS', 'german');
INSERT INTO class_model VALUES ('1638', '121', 'Fox', 'ro');
INSERT INTO class_model VALUES ('1638', '121', 'Fox', 'eng');
INSERT INTO class_model VALUES ('1638', '121', 'Fox', 'german');
INSERT INTO class_model VALUES ('1639', '121', 'GTI', 'ro');
INSERT INTO class_model VALUES ('1639', '121', 'GTI', 'eng');
INSERT INTO class_model VALUES ('1639', '121', 'GTI', 'german');
INSERT INTO class_model VALUES ('1640', '121', 'Garbus', 'ro');
INSERT INTO class_model VALUES ('1640', '121', 'Garbus', 'eng');
INSERT INTO class_model VALUES ('1640', '121', 'Garbus', 'german');
INSERT INTO class_model VALUES ('1641', '121', 'Golf', 'ro');
INSERT INTO class_model VALUES ('1641', '121', 'Golf', 'eng');
INSERT INTO class_model VALUES ('1641', '121', 'Golf', 'german');
INSERT INTO class_model VALUES ('1642', '121', 'Gofl GTD', 'ro');
INSERT INTO class_model VALUES ('1642', '121', 'Gofl GTD', 'eng');
INSERT INTO class_model VALUES ('1642', '121', 'Gofl GTD', 'german');
INSERT INTO class_model VALUES ('1643', '121', 'Golf GTI', 'ro');
INSERT INTO class_model VALUES ('1643', '121', 'Golf GTI', 'eng');
INSERT INTO class_model VALUES ('1643', '121', 'Golf GTI', 'german');
INSERT INTO class_model VALUES ('1644', '121', 'Golf R', 'ro');
INSERT INTO class_model VALUES ('1644', '121', 'Golf R', 'eng');
INSERT INTO class_model VALUES ('1644', '121', 'Golf R', 'german');
INSERT INTO class_model VALUES ('1645', '121', 'Golf Plus', 'ro');
INSERT INTO class_model VALUES ('1645', '121', 'Golf Plus', 'eng');
INSERT INTO class_model VALUES ('1645', '121', 'Golf Plus', 'german');
INSERT INTO class_model VALUES ('1646', '121', 'Iltis', 'ro');
INSERT INTO class_model VALUES ('1646', '121', 'Iltis', 'eng');
INSERT INTO class_model VALUES ('1646', '121', 'Iltis', 'german');
INSERT INTO class_model VALUES ('1647', '121', 'Jetta', 'ro');
INSERT INTO class_model VALUES ('1647', '121', 'Jetta', 'eng');
INSERT INTO class_model VALUES ('1647', '121', 'Jetta', 'german');
INSERT INTO class_model VALUES ('1648', '121', 'Kafer', 'ro');
INSERT INTO class_model VALUES ('1648', '121', 'Kafer', 'eng');
INSERT INTO class_model VALUES ('1648', '121', 'Kafer', 'german');
INSERT INTO class_model VALUES ('1649', '121', 'Karmann Ghia', 'ro');
INSERT INTO class_model VALUES ('1649', '121', 'Karmann Ghia', 'eng');
INSERT INTO class_model VALUES ('1649', '121', 'Karmann Ghia', 'german');
INSERT INTO class_model VALUES ('1650', '121', 'Lupo', 'ro');
INSERT INTO class_model VALUES ('1650', '121', 'Lupo', 'eng');
INSERT INTO class_model VALUES ('1650', '121', 'Lupo', 'german');
INSERT INTO class_model VALUES ('1651', '121', 'Multivan', 'ro');
INSERT INTO class_model VALUES ('1651', '121', 'Multivan', 'eng');
INSERT INTO class_model VALUES ('1651', '121', 'Multivan', 'german');
INSERT INTO class_model VALUES ('1652', '121', 'New Beetle', 'ro');
INSERT INTO class_model VALUES ('1652', '121', 'New Beetle', 'eng');
INSERT INTO class_model VALUES ('1652', '121', 'New Beetle', 'german');
INSERT INTO class_model VALUES ('1653', '121', 'Passat', 'ro');
INSERT INTO class_model VALUES ('1653', '121', 'Passat', 'eng');
INSERT INTO class_model VALUES ('1653', '121', 'Passat', 'german');
INSERT INTO class_model VALUES ('1654', '121', 'Passat Alltrack', 'ro');
INSERT INTO class_model VALUES ('1654', '121', 'Passat Alltrack', 'eng');
INSERT INTO class_model VALUES ('1654', '121', 'Passat Alltrack', 'german');
INSERT INTO class_model VALUES ('1655', '121', 'Passat CC', 'ro');
INSERT INTO class_model VALUES ('1655', '121', 'Passat CC', 'eng');
INSERT INTO class_model VALUES ('1655', '121', 'Passat CC', 'german');
INSERT INTO class_model VALUES ('1656', '121', 'Phaeton', 'ro');
INSERT INTO class_model VALUES ('1656', '121', 'Phaeton', 'eng');
INSERT INTO class_model VALUES ('1656', '121', 'Phaeton', 'german');
INSERT INTO class_model VALUES ('1657', '121', 'Polo', 'ro');
INSERT INTO class_model VALUES ('1657', '121', 'Polo', 'eng');
INSERT INTO class_model VALUES ('1657', '121', 'Polo', 'german');
INSERT INTO class_model VALUES ('1658', '121', 'Santana', 'ro');
INSERT INTO class_model VALUES ('1658', '121', 'Santana', 'eng');
INSERT INTO class_model VALUES ('1658', '121', 'Santana', 'german');
INSERT INTO class_model VALUES ('1659', '121', 'Scirocco', 'ro');
INSERT INTO class_model VALUES ('1659', '121', 'Scirocco', 'eng');
INSERT INTO class_model VALUES ('1659', '121', 'Scirocco', 'german');
INSERT INTO class_model VALUES ('1660', '121', 'Sharan', 'ro');
INSERT INTO class_model VALUES ('1660', '121', 'Sharan', 'eng');
INSERT INTO class_model VALUES ('1660', '121', 'Sharan', 'german');
INSERT INTO class_model VALUES ('1661', '121', 'Tiguan', 'ro');
INSERT INTO class_model VALUES ('1661', '121', 'Tiguan', 'eng');
INSERT INTO class_model VALUES ('1661', '121', 'Tiguan', 'german');
INSERT INTO class_model VALUES ('1662', '121', 'Touareg', 'ro');
INSERT INTO class_model VALUES ('1662', '121', 'Touareg', 'eng');
INSERT INTO class_model VALUES ('1662', '121', 'Touareg', 'german');
INSERT INTO class_model VALUES ('1663', '121', 'Touran', 'ro');
INSERT INTO class_model VALUES ('1663', '121', 'Touran', 'eng');
INSERT INTO class_model VALUES ('1663', '121', 'Touran', 'german');
INSERT INTO class_model VALUES ('1664', '121', 'Transporter', 'ro');
INSERT INTO class_model VALUES ('1664', '121', 'Transporter', 'eng');
INSERT INTO class_model VALUES ('1664', '121', 'Transporter', 'german');
INSERT INTO class_model VALUES ('1665', '121', 'Vento', 'ro');
INSERT INTO class_model VALUES ('1665', '121', 'Vento', 'eng');
INSERT INTO class_model VALUES ('1665', '121', 'Vento', 'german');
INSERT INTO class_model VALUES ('1666', '121', 'up!', 'ro');
INSERT INTO class_model VALUES ('1666', '121', 'up!', 'eng');
INSERT INTO class_model VALUES ('1666', '121', 'up!', 'german');
INSERT INTO class_model VALUES ('1667', '121', 'Polo GTI', 'ro');
INSERT INTO class_model VALUES ('1667', '121', 'Polo GTI', 'eng');
INSERT INTO class_model VALUES ('1667', '121', 'Polo GTI', 'german');
INSERT INTO class_model VALUES ('1668', '122', '240', 'ro');
INSERT INTO class_model VALUES ('1668', '122', '240', 'eng');
INSERT INTO class_model VALUES ('1668', '122', '240', 'german');
INSERT INTO class_model VALUES ('1669', '122', '244', 'ro');
INSERT INTO class_model VALUES ('1669', '122', '244', 'eng');
INSERT INTO class_model VALUES ('1669', '122', '244', 'german');
INSERT INTO class_model VALUES ('1670', '122', '245', 'ro');
INSERT INTO class_model VALUES ('1670', '122', '245', 'eng');
INSERT INTO class_model VALUES ('1670', '122', '245', 'german');
INSERT INTO class_model VALUES ('1671', '122', '262', 'ro');
INSERT INTO class_model VALUES ('1671', '122', '262', 'eng');
INSERT INTO class_model VALUES ('1671', '122', '262', 'german');
INSERT INTO class_model VALUES ('1672', '122', '264', 'ro');
INSERT INTO class_model VALUES ('1672', '122', '264', 'eng');
INSERT INTO class_model VALUES ('1672', '122', '264', 'german');
INSERT INTO class_model VALUES ('1673', '122', '340', 'ro');
INSERT INTO class_model VALUES ('1673', '122', '340', 'eng');
INSERT INTO class_model VALUES ('1673', '122', '340', 'german');
INSERT INTO class_model VALUES ('1674', '122', '360', 'ro');
INSERT INTO class_model VALUES ('1674', '122', '360', 'eng');
INSERT INTO class_model VALUES ('1674', '122', '360', 'german');
INSERT INTO class_model VALUES ('1675', '122', '440', 'ro');
INSERT INTO class_model VALUES ('1675', '122', '440', 'eng');
INSERT INTO class_model VALUES ('1675', '122', '440', 'german');
INSERT INTO class_model VALUES ('1676', '122', '460', 'ro');
INSERT INTO class_model VALUES ('1676', '122', '460', 'eng');
INSERT INTO class_model VALUES ('1676', '122', '460', 'german');
INSERT INTO class_model VALUES ('1677', '122', '480', 'ro');
INSERT INTO class_model VALUES ('1677', '122', '480', 'eng');
INSERT INTO class_model VALUES ('1677', '122', '480', 'german');
INSERT INTO class_model VALUES ('1678', '122', '740', 'ro');
INSERT INTO class_model VALUES ('1678', '122', '740', 'eng');
INSERT INTO class_model VALUES ('1678', '122', '740', 'german');
INSERT INTO class_model VALUES ('1679', '122', '744', 'ro');
INSERT INTO class_model VALUES ('1679', '122', '744', 'eng');
INSERT INTO class_model VALUES ('1679', '122', '744', 'german');
INSERT INTO class_model VALUES ('1680', '122', '745', 'ro');
INSERT INTO class_model VALUES ('1680', '122', '745', 'eng');
INSERT INTO class_model VALUES ('1680', '122', '745', 'german');
INSERT INTO class_model VALUES ('1681', '122', '760', 'ro');
INSERT INTO class_model VALUES ('1681', '122', '760', 'eng');
INSERT INTO class_model VALUES ('1681', '122', '760', 'german');
INSERT INTO class_model VALUES ('1682', '122', '780', 'ro');
INSERT INTO class_model VALUES ('1682', '122', '780', 'eng');
INSERT INTO class_model VALUES ('1682', '122', '780', 'german');
INSERT INTO class_model VALUES ('1683', '122', '850', 'ro');
INSERT INTO class_model VALUES ('1683', '122', '850', 'eng');
INSERT INTO class_model VALUES ('1683', '122', '850', 'german');
INSERT INTO class_model VALUES ('1684', '122', '855', 'ro');
INSERT INTO class_model VALUES ('1684', '122', '855', 'eng');
INSERT INTO class_model VALUES ('1684', '122', '855', 'german');
INSERT INTO class_model VALUES ('1685', '122', '940', 'ro');
INSERT INTO class_model VALUES ('1685', '122', '940', 'eng');
INSERT INTO class_model VALUES ('1685', '122', '940', 'german');
INSERT INTO class_model VALUES ('1686', '122', '944', 'ro');
INSERT INTO class_model VALUES ('1686', '122', '944', 'eng');
INSERT INTO class_model VALUES ('1686', '122', '944', 'german');
INSERT INTO class_model VALUES ('1687', '122', '945', 'ro');
INSERT INTO class_model VALUES ('1687', '122', '945', 'eng');
INSERT INTO class_model VALUES ('1687', '122', '945', 'german');
INSERT INTO class_model VALUES ('1688', '122', '960', 'ro');
INSERT INTO class_model VALUES ('1688', '122', '960', 'eng');
INSERT INTO class_model VALUES ('1688', '122', '960', 'german');
INSERT INTO class_model VALUES ('1689', '122', '965', 'ro');
INSERT INTO class_model VALUES ('1689', '122', '965', 'eng');
INSERT INTO class_model VALUES ('1689', '122', '965', 'german');
INSERT INTO class_model VALUES ('1690', '122', 'Amazon', 'ro');
INSERT INTO class_model VALUES ('1690', '122', 'Amazon', 'eng');
INSERT INTO class_model VALUES ('1690', '122', 'Amazon', 'german');
INSERT INTO class_model VALUES ('1691', '122', 'C30', 'ro');
INSERT INTO class_model VALUES ('1691', '122', 'C30', 'eng');
INSERT INTO class_model VALUES ('1691', '122', 'C30', 'german');
INSERT INTO class_model VALUES ('1692', '122', 'C70', 'ro');
INSERT INTO class_model VALUES ('1692', '122', 'C70', 'eng');
INSERT INTO class_model VALUES ('1692', '122', 'C70', 'german');
INSERT INTO class_model VALUES ('1693', '122', 'Polar', 'ro');
INSERT INTO class_model VALUES ('1693', '122', 'Polar', 'eng');
INSERT INTO class_model VALUES ('1693', '122', 'Polar', 'german');
INSERT INTO class_model VALUES ('1694', '122', 'S40', 'ro');
INSERT INTO class_model VALUES ('1694', '122', 'S40', 'eng');
INSERT INTO class_model VALUES ('1694', '122', 'S40', 'german');
INSERT INTO class_model VALUES ('1695', '122', 'S60', 'ro');
INSERT INTO class_model VALUES ('1695', '122', 'S60', 'eng');
INSERT INTO class_model VALUES ('1695', '122', 'S60', 'german');
INSERT INTO class_model VALUES ('1696', '122', 'S70', 'ro');
INSERT INTO class_model VALUES ('1696', '122', 'S70', 'eng');
INSERT INTO class_model VALUES ('1696', '122', 'S70', 'german');
INSERT INTO class_model VALUES ('1697', '122', 'S80', 'ro');
INSERT INTO class_model VALUES ('1697', '122', 'S80', 'eng');
INSERT INTO class_model VALUES ('1697', '122', 'S80', 'german');
INSERT INTO class_model VALUES ('1698', '122', 'S90', 'ro');
INSERT INTO class_model VALUES ('1698', '122', 'S90', 'eng');
INSERT INTO class_model VALUES ('1698', '122', 'S90', 'german');
INSERT INTO class_model VALUES ('1699', '122', 'V40', 'ro');
INSERT INTO class_model VALUES ('1699', '122', 'V40', 'eng');
INSERT INTO class_model VALUES ('1699', '122', 'V40', 'german');
INSERT INTO class_model VALUES ('1700', '122', 'V50', 'ro');
INSERT INTO class_model VALUES ('1700', '122', 'V50', 'eng');
INSERT INTO class_model VALUES ('1700', '122', 'V50', 'german');
INSERT INTO class_model VALUES ('1701', '122', 'V60', 'ro');
INSERT INTO class_model VALUES ('1701', '122', 'V60', 'eng');
INSERT INTO class_model VALUES ('1701', '122', 'V60', 'german');
INSERT INTO class_model VALUES ('1702', '122', 'V70', 'ro');
INSERT INTO class_model VALUES ('1702', '122', 'V70', 'eng');
INSERT INTO class_model VALUES ('1702', '122', 'V70', 'german');
INSERT INTO class_model VALUES ('1703', '122', 'V90', 'ro');
INSERT INTO class_model VALUES ('1703', '122', 'V90', 'eng');
INSERT INTO class_model VALUES ('1703', '122', 'V90', 'german');
INSERT INTO class_model VALUES ('1704', '122', 'XC 60', 'ro');
INSERT INTO class_model VALUES ('1704', '122', 'XC 60', 'eng');
INSERT INTO class_model VALUES ('1704', '122', 'XC 60', 'german');
INSERT INTO class_model VALUES ('1705', '122', 'XC 70', 'ro');
INSERT INTO class_model VALUES ('1705', '122', 'XC 70', 'eng');
INSERT INTO class_model VALUES ('1705', '122', 'XC 70', 'german');
INSERT INTO class_model VALUES ('1706', '122', 'XC 90', 'ro');
INSERT INTO class_model VALUES ('1706', '122', 'XC 90', 'eng');
INSERT INTO class_model VALUES ('1706', '122', 'XC 90', 'german');
INSERT INTO class_model VALUES ('1707', '123', '203', 'ro');
INSERT INTO class_model VALUES ('1707', '123', '203', 'eng');
INSERT INTO class_model VALUES ('1707', '123', '203', 'german');
INSERT INTO class_model VALUES ('1708', '123', '204', 'ro');
INSERT INTO class_model VALUES ('1708', '123', '204', 'eng');
INSERT INTO class_model VALUES ('1708', '123', '204', 'german');
INSERT INTO class_model VALUES ('1709', '123', '223', 'ro');
INSERT INTO class_model VALUES ('1709', '123', '223', 'eng');
INSERT INTO class_model VALUES ('1709', '123', '223', 'german');
INSERT INTO class_model VALUES ('1710', '123', '224', 'ro');
INSERT INTO class_model VALUES ('1710', '123', '224', 'eng');
INSERT INTO class_model VALUES ('1710', '123', '224', 'german');
INSERT INTO class_model VALUES ('1711', '123', 'M-20', 'ro');
INSERT INTO class_model VALUES ('1711', '123', 'M-20', 'eng');
INSERT INTO class_model VALUES ('1711', '123', 'M-20', 'german');
INSERT INTO class_model VALUES ('1712', '123', 'Pick-up', 'ro');
INSERT INTO class_model VALUES ('1712', '123', 'Pick-up', 'eng');
INSERT INTO class_model VALUES ('1712', '123', 'Pick-up', 'german');
INSERT INTO class_model VALUES ('1713', '124', '1.3', 'ro');
INSERT INTO class_model VALUES ('1713', '124', '1.3', 'eng');
INSERT INTO class_model VALUES ('1713', '124', '1.3', 'german');
INSERT INTO class_model VALUES ('1714', '124', '311', 'ro');
INSERT INTO class_model VALUES ('1714', '124', '311', 'eng');
INSERT INTO class_model VALUES ('1714', '124', '311', 'german');
INSERT INTO class_model VALUES ('1715', '124', '312', 'ro');
INSERT INTO class_model VALUES ('1715', '124', '312', 'eng');
INSERT INTO class_model VALUES ('1715', '124', '312', 'german');
INSERT INTO class_model VALUES ('1716', '124', '313', 'ro');
INSERT INTO class_model VALUES ('1716', '124', '313', 'eng');
INSERT INTO class_model VALUES ('1716', '124', '313', 'german');
INSERT INTO class_model VALUES ('1717', '124', '353', 'ro');
INSERT INTO class_model VALUES ('1717', '124', '353', 'eng');
INSERT INTO class_model VALUES ('1717', '124', '353', 'german');
INSERT INTO class_model VALUES ('1718', '125', 'MF 25', 'ro');
INSERT INTO class_model VALUES ('1718', '125', 'MF 25', 'eng');
INSERT INTO class_model VALUES ('1718', '125', 'MF 25', 'german');
INSERT INTO class_model VALUES ('1719', '125', 'MF 28', 'ro');
INSERT INTO class_model VALUES ('1719', '125', 'MF 28', 'eng');
INSERT INTO class_model VALUES ('1719', '125', 'MF 28', 'german');
INSERT INTO class_model VALUES ('1720', '125', 'MF 3', 'ro');
INSERT INTO class_model VALUES ('1720', '125', 'MF 3', 'eng');
INSERT INTO class_model VALUES ('1720', '125', 'MF 3', 'german');
INSERT INTO class_model VALUES ('1721', '125', 'MF 30', 'ro');
INSERT INTO class_model VALUES ('1721', '125', 'MF 30', 'eng');
INSERT INTO class_model VALUES ('1721', '125', 'MF 30', 'german');
INSERT INTO class_model VALUES ('1722', '125', 'MF 35', 'ro');
INSERT INTO class_model VALUES ('1722', '125', 'MF 35', 'eng');
INSERT INTO class_model VALUES ('1722', '125', 'MF 35', 'german');
INSERT INTO class_model VALUES ('1723', '125', 'MF 4', 'ro');
INSERT INTO class_model VALUES ('1723', '125', 'MF 4', 'eng');
INSERT INTO class_model VALUES ('1723', '125', 'MF 4', 'german');
INSERT INTO class_model VALUES ('1725', '131', 'GAZ-21', 'ro');
INSERT INTO class_model VALUES ('1725', '131', 'GAZ-21', 'eng');
INSERT INTO class_model VALUES ('1725', '131', 'GAZ-21', 'german');
INSERT INTO class_model VALUES ('1726', '131', 'GAZ-24', 'ro');
INSERT INTO class_model VALUES ('1726', '131', 'GAZ-24', 'eng');
INSERT INTO class_model VALUES ('1726', '131', 'GAZ-24', 'german');
INSERT INTO class_model VALUES ('1727', '127', '102', 'ro');
INSERT INTO class_model VALUES ('1727', '127', '102', 'eng');
INSERT INTO class_model VALUES ('1727', '127', '102', 'german');
INSERT INTO class_model VALUES ('1728', '127', 'Florida', 'ro');
INSERT INTO class_model VALUES ('1728', '127', 'Florida', 'eng');
INSERT INTO class_model VALUES ('1728', '127', 'Florida', 'german');
INSERT INTO class_model VALUES ('1729', '127', 'Koral', 'ro');
INSERT INTO class_model VALUES ('1729', '127', 'Koral', 'eng');
INSERT INTO class_model VALUES ('1729', '127', 'Koral', 'german');
INSERT INTO class_model VALUES ('1730', '128', '965', 'ro');
INSERT INTO class_model VALUES ('1730', '128', '965', 'eng');
INSERT INTO class_model VALUES ('1730', '128', '965', 'german');
INSERT INTO class_model VALUES ('1731', '128', '968', 'ro');
INSERT INTO class_model VALUES ('1731', '128', '968', 'eng');
INSERT INTO class_model VALUES ('1731', '128', '968', 'german');
INSERT INTO class_model VALUES ('1732', '129', '1100', 'ro');
INSERT INTO class_model VALUES ('1732', '129', '1100', 'eng');
INSERT INTO class_model VALUES ('1732', '129', '1100', 'german');
INSERT INTO class_model VALUES ('1733', '129', '750', 'ro');
INSERT INTO class_model VALUES ('1733', '129', '750', 'eng');
INSERT INTO class_model VALUES ('1733', '129', '750', 'german');


#
# Table structure for table `class_modules`
#

DROP TABLE IF EXISTS `class_modules`;
CREATE TABLE `class_modules` (
  `id` varchar(50) NOT NULL,
  `name` varchar(50) DEFAULT NULL,
  `description` text,
  `enabled` tinyint(1) DEFAULT '1',
  UNIQUE KEY `id` (`id`),
  KEY `idx_enabled` (`enabled`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_modules`
#

INSERT INTO class_modules VALUES ('browse_make', 'Browse by Make', 'Display a box where users can browse listings by makes.', '1');
INSERT INTO class_modules VALUES ('browse_location', 'Browse by Location', 'Display a box where users can view locations and browse listings by location.', '1');
INSERT INTO class_modules VALUES ('eu_cookies', 'EU cookies regulation', 'Show a notification banner on your site which states that your site uses cookies, as European Union legislation requests.', '1');
INSERT INTO class_modules VALUES ('price_extra', 'Price extra configuration', 'Extra price field configuration module which allows you to enable Negotiable checkbox, enable Free word instead of 0 price value, allow alternate tags like Please Contact or Swap/Trade. You can make different such configurations for different fieldsets.', '1');
INSERT INTO class_modules VALUES ('extra_visits', 'Extra Visits', 'Add extra false numbers of visits every time someone accesses a listing. A random number of visits between 1 and a configured value is added.', '1');
INSERT INTO class_modules VALUES ('multicurrency', 'MultiCurrency', 'Allows correct price sorting and displaying prices in different currencies when using listing prices with multiple currencies. The prices are calculated according to defined ratios between the currencies defined in the system.', '1');
INSERT INTO class_modules VALUES ('spam_prevention', 'Spam Prevention', 'Checks email and IP addresses against a spammers list from stopforumspam.com.', '1');
INSERT INTO class_modules VALUES ('popular_ads', 'Popular Ads', 'Shows the most popular ads on the first page.', '1');
INSERT INTO class_modules VALUES ('dealers_page', 'List Dealers Page', 'Creates a page where all dealers are listed.', '1');
INSERT INTO class_modules VALUES ('listings_compare', 'Compare listings', 'Allow comparison between multiple listings.', '1');
INSERT INTO class_modules VALUES ('price_drop_alert', 'Price drop alert', 'Allow visitors to receive notifications when the price of a listing drops.', '1');
INSERT INTO class_modules VALUES ('similar_ads', 'Similar Ads', 'Shows a number of similar ads on listing details page.', '1');
INSERT INTO class_modules VALUES ('tag_cloud', 'Tag Cloud', 'Show the most searched words in a tag cloud.', '1');
INSERT INTO class_modules VALUES ('news', 'News', 'News module. Shows a short version for a number of news on the first page.', '1');


#
# Table structure for table `class_multicurrency`
#

DROP TABLE IF EXISTS `class_multicurrency`;
CREATE TABLE `class_multicurrency` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `currency` varchar(10) DEFAULT NULL,
  `default` tinyint(1) DEFAULT '0',
  `ratio` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_multicurrency`
#

INSERT INTO class_multicurrency VALUES ('1', '', '1', '1');
INSERT INTO class_multicurrency VALUES ('2', '$', '0', '0.93');
INSERT INTO class_multicurrency VALUES ('3', 'RON', '0', '0.22');


#
# Table structure for table `class_new_alerts`
#

DROP TABLE IF EXISTS `class_new_alerts`;
CREATE TABLE `class_new_alerts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `alert_id` int(10) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `listings` text,
  PRIMARY KEY (`id`),
  KEY `idx_alert_id` (`alert_id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_new_alerts`
#



#
# Table structure for table `class_news`
#

DROP TABLE IF EXISTS `class_news`;
CREATE TABLE `class_news` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `lang_id` varchar(20) DEFAULT 'eng',
  `title` varchar(200) DEFAULT NULL,
  `image` varchar(100) DEFAULT NULL,
  `summary` text,
  `content` text,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_news`
#



#
# Table structure for table `class_news_settings`
#

DROP TABLE IF EXISTS `class_news_settings`;
CREATE TABLE `class_news_settings` (
  `news_on_first_page` int(2) DEFAULT '2',
  `news_on_each_page` int(2) DEFAULT '4',
  `title_ro` varchar(100) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_news_settings`
#

INSERT INTO class_news_settings VALUES ('3', '5', 'Latest News');


#
# Table structure for table `class_options`
#

DROP TABLE IF EXISTS `class_options`;
CREATE TABLE `class_options` (
  `object_id` int(2) NOT NULL,
  `option` varchar(20) DEFAULT NULL,
  `date_added` datetime DEFAULT NULL,
  `date_expires` datetime DEFAULT NULL,
  KEY `idx_id` (`object_id`),
  KEY `idx_option` (`option`),
  KEY `idx_date` (`date_added`),
  KEY `idx_expires` (`date_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_options`
#

INSERT INTO class_options VALUES ('1', 'video', '2017-02-12 19:38:38', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('2', 'video', '2017-02-12 19:44:15', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('3', 'video', '2017-02-12 19:56:22', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('4', 'video', '2017-02-12 19:58:55', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('5', 'video', '2017-02-13 11:39:08', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('6', 'video', '2017-02-13 20:40:28', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('7', 'video', '2017-02-14 19:21:38', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('8', 'video', '2017-02-14 19:29:31', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('9', 'video', '2017-02-14 19:49:14', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('10', 'video', '2017-02-17 06:39:29', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('11', 'video', '2017-02-17 06:42:44', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('12', 'video', '2017-02-17 06:49:29', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('13', 'video', '2017-02-17 06:53:58', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('14', 'video', '2017-02-17 07:28:24', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('15', 'video', '2017-02-17 08:32:42', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('16', 'video', '2017-02-17 09:53:14', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('17', 'video', '2017-02-17 14:05:51', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('18', 'video', '2017-02-18 06:04:48', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('19', 'video', '2017-02-18 06:09:15', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('20', 'video', '2017-02-27 07:48:56', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('21', 'video', '2017-02-27 09:01:53', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('22', 'video', '2017-03-02 09:13:25', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('23', 'video', '2017-03-06 10:13:44', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('24', 'video', '2017-03-06 10:18:13', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('25', 'video', '2017-03-10 10:57:16', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('26', 'video', '2017-03-10 11:02:43', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('1', 'store', '2017-03-10 11:37:32', '2017-04-09 11:37:32');
INSERT INTO class_options VALUES ('27', 'video', '2017-03-14 10:13:19', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('28', 'video', '2017-03-14 10:15:57', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('29', 'video', '2017-03-14 10:19:21', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('30', 'video', '2017-03-16 09:54:48', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('31', 'video', '2017-03-24 12:50:05', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('32', 'video', '2017-03-24 12:52:31', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('33', 'video', '2017-03-28 06:43:53', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('34', 'video', '2017-03-28 06:48:05', '0000-00-00 00:00:00');
INSERT INTO class_options VALUES ('35', 'video', '2017-03-28 07:10:13', '0000-00-00 00:00:00');


#
# Table structure for table `class_packages`
#

DROP TABLE IF EXISTS `class_packages`;
CREATE TABLE `class_packages` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `type` varchar(10) DEFAULT 'ad',
  `amount` float DEFAULT '0',
  `no_words` int(5) DEFAULT '0',
  `no_days` int(4) DEFAULT '0',
  `no_pictures` int(2) DEFAULT NULL,
  `no_ads` int(3) DEFAULT '1',
  `subscription_time` int(5) DEFAULT '0',
  `groups` varchar(250) DEFAULT '0',
  `categories` text,
  `order_no` int(5) DEFAULT NULL,
  `featured` tinyint(1) DEFAULT '0',
  `highlited` tinyint(1) DEFAULT '0',
  `priority` int(4) DEFAULT '0',
  `video` tinyint(1) DEFAULT '0',
  `allow` int(2) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_packages`
#

INSERT INTO class_packages VALUES ('1', 'ad', '0', '1000', '30', '4', '1', '0', '0', '0', '1', '0', '0', '0', '0', '0');
INSERT INTO class_packages VALUES ('2', 'ad', '2', '1000', '30', '6', '1', '0', '0', '0', '2', '0', '1', '0', '0', '0');
INSERT INTO class_packages VALUES ('3', 'ad', '5', '1000', '0', '10', '1', '0', '0', '0', '3', '1', '0', '1', '0', '0');
INSERT INTO class_packages VALUES ('4', 'ad', '10', '10000', '0', '20', '1', '0', '0', '0', '6', '1', '1', '3', '1', '0');
INSERT INTO class_packages VALUES ('5', 'ad', '5', '1000', '0', '6', '1', '0', '0', '0', '4', '1', '0', '0', '1', '0');
INSERT INTO class_packages VALUES ('6', 'ad', '7', '1000', '0', '8', '1', '0', '0', '0', '5', '1', '1', '0', '1', '0');


#
# Table structure for table `class_packages_lang`
#

DROP TABLE IF EXISTS `class_packages_lang`;
CREATE TABLE `class_packages_lang` (
  `id` int(2) NOT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  `name` varchar(128) DEFAULT '',
  `description` text,
  KEY `idx_id` (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_lang` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_packages_lang`
#

INSERT INTO class_packages_lang VALUES ('1', 'eng', 'Free Ad Plan', 'Free listing with up to 100 words and 4 pictures.');
INSERT INTO class_packages_lang VALUES ('1', 'esp', 'Free Ad Plan', 'Free listing with up to 100 words and 4 pictures.');
INSERT INTO class_packages_lang VALUES ('1', 'french', 'Free Ad Plan', 'Free listing with up to 100 words and 4 pictures.');
INSERT INTO class_packages_lang VALUES ('1', 'italian', 'Free Ad Plan', 'Free listing with up to 100 words and 4 pictures.');
INSERT INTO class_packages_lang VALUES ('1', 'german', 'Free Ad Plan', 'Free listing with up to 100 words and 4 pictures.');
INSERT INTO class_packages_lang VALUES ('1', 'ro', 'Gratuit', 'Anunt gratuit cu maxim 4 imagini<br>');
INSERT INTO class_packages_lang VALUES ('1', 'hr', 'Free Ad Plan', 'Free listing with up to 100 words and 4 pictures.');
INSERT INTO class_packages_lang VALUES ('1', 'hu', 'Free Ad Plan', 'Free listing with up to 100 words and 4 pictures.');
INSERT INTO class_packages_lang VALUES ('1', 'bg', 'Free Ad Plan', 'Free listing with up to 100 words and 4 pictures.');
INSERT INTO class_packages_lang VALUES ('2', 'ro', 'Basic', 'Anunt basic cu anunt evidentiat si un numar maxim de 6 imagini.<br>');
INSERT INTO class_packages_lang VALUES ('3', 'ro', 'Gold', 'Anunt evidentiat si cu prioritate gold intre restul anunturilor, pana la 10 imagini.<br>');
INSERT INTO class_packages_lang VALUES ('4', 'ro', 'Platinum', '<font color=\"#339999\"><i><b>Cel mai recomandat pentru anunturi.</b></i></font><br><font color=\"#CC0000\"><b>20 de imagini</b><br><b>Anunt promovat</b><br><b>Anunt evidentiat</b><br><b>Anunt cu prioritate platinum</b><br><b>Posibilitate de adaugare video</b></font><br>');
INSERT INTO class_packages_lang VALUES ('5', 'ro', 'Premium', 'Anunt premium, <b>promovat</b> si cu <b>posibilitate de adaugare video</b>.<br>');
INSERT INTO class_packages_lang VALUES ('6', 'ro', 'Ultra', 'Anunt <b>promovat</b>, <b>evidentiat</b> si cu <b>posibilitate de adaugare video</b>.<br>');


#
# Table structure for table `class_pagseguro_return`
#

DROP TABLE IF EXISTS `class_pagseguro_return`;
CREATE TABLE `class_pagseguro_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `code` varchar(100) DEFAULT NULL,
  `reference` varchar(30) DEFAULT NULL,
  `status` int(2) DEFAULT NULL,
  `grossAmount` double DEFAULT NULL,
  `netAmount` double DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `areaCode` varchar(3) DEFAULT NULL,
  `number` varchar(30) DEFAULT NULL,
  `entirepost` text,
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `ukey` (`ukey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_pagseguro_return`
#



#
# Table structure for table `class_pagseguro_settings`
#

DROP TABLE IF EXISTS `class_pagseguro_settings`;
CREATE TABLE `class_pagseguro_settings` (
  `pagseguro_email` varchar(50) DEFAULT NULL,
  `pagseguro_token` varchar(50) DEFAULT NULL,
  `pagseguro_currency` varchar(3) DEFAULT NULL,
  `pagseguro_item_name` varchar(40) DEFAULT NULL,
  `pagseguro_item_description` text,
  `pagseguro_test` tinyint(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_pagseguro_settings`
#

INSERT INTO class_pagseguro_settings VALUES ('', '', 'BRL', 'Classified ads', 'Classified ads', '0');


#
# Table structure for table `class_payfast_return`
#

DROP TABLE IF EXISTS `class_payfast_return`;
CREATE TABLE `class_payfast_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `m_payment_id` varchar(100) DEFAULT NULL,
  `pf_payment_id` varchar(100) DEFAULT NULL,
  `payment_status` varchar(20) DEFAULT NULL,
  `item_name` varchar(100) DEFAULT NULL,
  `item_description` varchar(250) DEFAULT NULL,
  `amount_gross` varchar(20) DEFAULT NULL,
  `amount_fee` varchar(20) DEFAULT NULL,
  `amount_net` varchar(20) DEFAULT NULL,
  `name_first` varchar(50) DEFAULT NULL,
  `name_last` varchar(50) DEFAULT NULL,
  `email_address` varchar(60) DEFAULT NULL,
  `merchant_id` varchar(60) DEFAULT NULL,
  `entirepost` text,
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `ukey` (`ukey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_payfast_return`
#



#
# Table structure for table `class_payfast_settings`
#

DROP TABLE IF EXISTS `class_payfast_settings`;
CREATE TABLE `class_payfast_settings` (
  `merchant_id` varchar(20) DEFAULT NULL,
  `merchant_key` varchar(50) DEFAULT NULL,
  `item_name` varchar(100) DEFAULT NULL,
  `demo` tinyint(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_payfast_settings`
#

INSERT INTO class_payfast_settings VALUES ('10000100', '46f0cd694581a', 'Classifieds ad', '0');


#
# Table structure for table `class_payment_actions`
#

DROP TABLE IF EXISTS `class_payment_actions`;
CREATE TABLE `class_payment_actions` (
  `id` int(20) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) DEFAULT '0',
  `processor` varchar(30) DEFAULT NULL,
  `ukey` varchar(255) DEFAULT NULL,
  `amount` float DEFAULT NULL,
  `action` text,
  `post` text,
  `completed` tinyint(1) DEFAULT '0',
  `date` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  `subscr_signup` tinyint(1) DEFAULT '0',
  `subscr_payment` tinyint(1) DEFAULT '0',
  `subscr_id` varchar(40) DEFAULT NULL,
  `tax` float DEFAULT '0',
  `affiliate_id` varchar(8) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ukey` (`ukey`),
  KEY `idx_amount` (`amount`),
  KEY `idx_date` (`date`),
  KEY `idx_user` (`user_id`),
  KEY `idx_processor` (`processor`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_payment_actions`
#

INSERT INTO class_payment_actions VALUES ('1', '0', 'paypal', '64692b28a9babf3fc86e250d845e6ecc', '10', 'a:14:{s:5:\"ad_id\";i:1;s:6:\"pkg_id\";s:1:\"2\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:0:\"\";}', 'a:11:{s:8:\"business\";s:20:\"weltandrei@yahoo.com\";s:13:\"currency_code\";s:3:\"EUR\";s:9:\"item_name\";s:12:\"Weltcars.com\";s:2:\"lc\";s:2:\"EU\";s:2:\"rm\";s:1:\"2\";s:3:\"cmd\";s:7:\"_xclick\";s:7:\"charset\";s:5:\"UTF-8\";s:6:\"return\";s:101:\"https://weltcars.com/payment_return/paypal.php?mode=success&amp;ukey=64692b28a9babf3fc86e250d845e6ecc\";s:13:\"cancel_return\";s:100:\"https://weltcars.com/payment_return/paypal.php?mode=cancel&amp;ukey=64692b28a9babf3fc86e250d845e6ecc\";s:10:\"notify_url\";s:101:\"https://weltcars.com/payment_return/paypal.php?mode=process&amp;ukey=64692b28a9babf3fc86e250d845e6ecc\";s:6:\"amount\";s:5:\"10.00\";}', '0', '2017-02-12 19:38:38', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('2', '0', 'paypal', '6b3a8b6124663c1a111cfec978d04f1a', '10', 'a:14:{s:5:\"ad_id\";i:2;s:6:\"pkg_id\";s:1:\"3\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:0:\"\";}', 'a:11:{s:8:\"business\";s:20:\"weltandrei@yahoo.com\";s:13:\"currency_code\";s:3:\"EUR\";s:9:\"item_name\";s:12:\"Weltcars.com\";s:2:\"lc\";s:2:\"EU\";s:2:\"rm\";s:1:\"2\";s:3:\"cmd\";s:7:\"_xclick\";s:7:\"charset\";s:5:\"UTF-8\";s:6:\"return\";s:101:\"https://weltcars.com/payment_return/paypal.php?mode=success&amp;ukey=6b3a8b6124663c1a111cfec978d04f1a\";s:13:\"cancel_return\";s:100:\"https://weltcars.com/payment_return/paypal.php?mode=cancel&amp;ukey=6b3a8b6124663c1a111cfec978d04f1a\";s:10:\"notify_url\";s:101:\"https://weltcars.com/payment_return/paypal.php?mode=process&amp;ukey=6b3a8b6124663c1a111cfec978d04f1a\";s:6:\"amount\";s:5:\"10.00\";}', '0', '2017-02-12 19:44:15', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('3', '0', 'paypal', 'a3af18df716ee58d005b426e517de193', '10', 'a:14:{s:5:\"ad_id\";i:3;s:6:\"pkg_id\";s:1:\"4\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:0:\"\";}', 'a:11:{s:8:\"business\";s:20:\"weltandrei@yahoo.com\";s:13:\"currency_code\";s:3:\"EUR\";s:9:\"item_name\";s:12:\"Weltcars.com\";s:2:\"lc\";s:2:\"EU\";s:2:\"rm\";s:1:\"2\";s:3:\"cmd\";s:7:\"_xclick\";s:7:\"charset\";s:5:\"UTF-8\";s:6:\"return\";s:101:\"https://weltcars.com/payment_return/paypal.php?mode=success&amp;ukey=a3af18df716ee58d005b426e517de193\";s:13:\"cancel_return\";s:100:\"https://weltcars.com/payment_return/paypal.php?mode=cancel&amp;ukey=a3af18df716ee58d005b426e517de193\";s:10:\"notify_url\";s:101:\"https://weltcars.com/payment_return/paypal.php?mode=process&amp;ukey=a3af18df716ee58d005b426e517de193\";s:6:\"amount\";s:5:\"10.00\";}', '0', '2017-02-12 19:56:22', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('4', '0', 'paypal', '9e335c7106399a613cfb751e9ea717a3', '10', 'a:14:{s:5:\"ad_id\";i:4;s:6:\"pkg_id\";s:1:\"5\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:0:\"\";}', 'a:11:{s:8:\"business\";s:20:\"weltandrei@yahoo.com\";s:13:\"currency_code\";s:3:\"EUR\";s:9:\"item_name\";s:12:\"Weltcars.com\";s:2:\"lc\";s:2:\"EU\";s:2:\"rm\";s:1:\"2\";s:3:\"cmd\";s:7:\"_xclick\";s:7:\"charset\";s:5:\"UTF-8\";s:6:\"return\";s:101:\"https://weltcars.com/payment_return/paypal.php?mode=success&amp;ukey=9e335c7106399a613cfb751e9ea717a3\";s:13:\"cancel_return\";s:100:\"https://weltcars.com/payment_return/paypal.php?mode=cancel&amp;ukey=9e335c7106399a613cfb751e9ea717a3\";s:10:\"notify_url\";s:101:\"https://weltcars.com/payment_return/paypal.php?mode=process&amp;ukey=9e335c7106399a613cfb751e9ea717a3\";s:6:\"amount\";s:5:\"10.00\";}', '0', '2017-02-12 19:58:55', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('5', '0', 'free', 'ef377095e4c7dde2cf7c8ebdeaee0018', '0', 'a:14:{s:5:\"ad_id\";i:5;s:6:\"pkg_id\";s:1:\"6\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-13 11:39:08', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('6', '0', 'free', '038186c684dfcd22d1ea3bf12d0e6794', '0', 'a:14:{s:5:\"ad_id\";i:6;s:6:\"pkg_id\";s:1:\"7\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"ADMIN112\";}', 's:0:\"\";', '1', '2017-02-13 20:40:28', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('7', '0', 'free', '1abc92b48ab31871f1812e13b3eb03f8', '0', 'a:14:{s:5:\"ad_id\";i:7;s:6:\"pkg_id\";s:1:\"8\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"ADMIN112\";}', 's:0:\"\";', '1', '2017-02-14 19:21:38', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('8', '0', 'free', '980860cf96e469374e578ff32924d33e', '0', 'a:14:{s:5:\"ad_id\";i:8;s:6:\"pkg_id\";s:1:\"9\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"ADMIN112\";}', 's:0:\"\";', '1', '2017-02-14 19:29:31', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('9', '0', 'free', '7f1850c220d227e1c4d0299c28e86479', '0', 'a:14:{s:5:\"ad_id\";i:9;s:6:\"pkg_id\";s:2:\"10\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"ADMIN112\";}', 's:0:\"\";', '1', '2017-02-14 19:49:14', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('10', '0', 'free', 'b573870f85927195f478b2eb83fb7c46', '0', 'a:14:{s:5:\"ad_id\";i:10;s:6:\"pkg_id\";s:2:\"11\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-17 06:39:29', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('11', '0', 'free', '5b08240b25dc490b382137b794202f6e', '0', 'a:14:{s:5:\"ad_id\";i:11;s:6:\"pkg_id\";s:2:\"12\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-17 06:42:45', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('12', '0', 'free', '9d5462ac24d6f70ccade07512206ccbc', '0', 'a:14:{s:5:\"ad_id\";i:12;s:6:\"pkg_id\";s:2:\"13\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-17 06:49:29', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('13', '0', 'free', 'b2c95b207a811cbb14912159bf04c467', '0', 'a:14:{s:5:\"ad_id\";i:13;s:6:\"pkg_id\";s:2:\"14\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-17 06:53:58', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('14', '0', 'free', 'be2d67801427ab62110d1ced5745cd75', '0', 'a:14:{s:5:\"ad_id\";i:14;s:6:\"pkg_id\";s:2:\"15\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-17 07:28:24', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('15', '0', 'free', '49d62400f5f555269b5bda64360601bd', '0', 'a:14:{s:5:\"ad_id\";i:15;s:6:\"pkg_id\";s:2:\"16\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-17 08:32:42', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('16', '0', 'free', '3dfe86d691777f8aa0206c6dbf4b1397', '0', 'a:14:{s:5:\"ad_id\";i:16;s:6:\"pkg_id\";s:2:\"17\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-17 09:53:14', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('17', '0', 'free', '5dd1fc0bd5914ed01bd54763c2f2e7d0', '0', 'a:14:{s:5:\"ad_id\";i:17;s:6:\"pkg_id\";s:2:\"18\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-17 14:05:51', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('18', '0', 'free', 'ffd85cbd56e61fbe9cf79c1e605de010', '0', 'a:14:{s:5:\"ad_id\";i:18;s:6:\"pkg_id\";s:2:\"19\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-18 06:04:48', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('19', '0', 'free', '998d7ec497f643df4a6f9b0829c823d1', '0', 'a:14:{s:5:\"ad_id\";i:19;s:6:\"pkg_id\";s:2:\"20\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-18 06:09:15', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('20', '0', 'free', '51345e9489c769a5a014bdcdd296a250', '0', 'a:14:{s:5:\"ad_id\";i:20;s:6:\"pkg_id\";s:2:\"21\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-27 07:48:56', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('21', '0', 'free', '928e1d0fe26d4238763e88381d996310', '0', 'a:14:{s:5:\"ad_id\";i:21;s:6:\"pkg_id\";s:2:\"22\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-02-27 09:01:53', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('22', '0', 'free', 'a3ba6bddbf2647d76560e2a70b7d4c92', '0', 'a:14:{s:5:\"ad_id\";i:22;s:6:\"pkg_id\";s:2:\"23\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-02 09:13:26', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('23', '0', 'free', '370f6751fdd1f6dbeb0c0e8218e3987b', '0', 'a:14:{s:5:\"ad_id\";i:23;s:6:\"pkg_id\";s:2:\"24\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-06 10:13:44', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('24', '0', 'free', 'b2392acdb68280e69fda87735841e578', '0', 'a:14:{s:5:\"ad_id\";i:24;s:6:\"pkg_id\";s:2:\"25\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-06 10:18:13', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('25', '0', 'free', 'b048094f3cf62b907e5ea6569fe195c8', '0', 'a:14:{s:5:\"ad_id\";i:25;s:6:\"pkg_id\";s:2:\"26\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-10 10:57:16', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('26', '0', 'free', 'bcac26638d4f8ac64b367027e56b2b60', '0', 'a:14:{s:5:\"ad_id\";i:26;s:6:\"pkg_id\";s:2:\"27\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-10 11:02:43', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('27', '0', 'free', 'cd770293e5abcafbe1aac839ea25932f', '0', 'a:14:{s:5:\"ad_id\";i:27;s:6:\"pkg_id\";s:2:\"28\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-14 10:13:19', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('28', '0', 'free', 'daaee3e7da9c1c1e90b438f607c0404b', '0', 'a:14:{s:5:\"ad_id\";i:28;s:6:\"pkg_id\";s:2:\"29\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-14 10:15:58', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('29', '0', 'free', 'e864a0f03a24053b369b84d2873121f4', '0', 'a:14:{s:5:\"ad_id\";i:29;s:6:\"pkg_id\";s:2:\"30\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-14 10:19:22', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('30', '0', 'free', '79e9ef82e26c7d7998df15332a9d8f63', '0', 'a:14:{s:5:\"ad_id\";i:30;s:6:\"pkg_id\";s:2:\"31\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-16 09:54:48', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('31', '0', 'free', '28b490b6287d80aa8a0e7bba464a0404', '0', 'a:14:{s:5:\"ad_id\";i:31;s:6:\"pkg_id\";s:2:\"32\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-24 12:50:05', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('32', '0', 'free', '1e52cb7d7056484ca92e1bbca632f4b8', '0', 'a:14:{s:5:\"ad_id\";i:32;s:6:\"pkg_id\";s:2:\"33\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-24 12:52:31', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('33', '0', 'free', 'bb0919a8083b9a9607bef93976c3e6d8', '0', 'a:14:{s:5:\"ad_id\";i:33;s:6:\"pkg_id\";s:2:\"34\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-28 06:43:53', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('34', '0', 'free', '19a7798c230b3f4269c81c97b86afe77', '0', 'a:14:{s:5:\"ad_id\";i:34;s:6:\"pkg_id\";s:2:\"35\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-28 06:48:05', '0', '0', '', '0', '');
INSERT INTO class_payment_actions VALUES ('35', '0', 'free', '68198d09c44188a6b2457208fa2bdd19', '0', 'a:14:{s:5:\"ad_id\";i:35;s:6:\"pkg_id\";s:2:\"36\";s:14:\"credits_pkg_id\";i:0;s:5:\"newad\";a:2:{s:5:\"value\";i:1;s:5:\"price\";i:0;}s:7:\"renewad\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"featured\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:9:\"highlited\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:8:\"priority\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"video\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:6:\"newpkg\";a:2:{s:5:\"value\";i:1;s:5:\"price\";s:2:\"10\";}s:8:\"renewpkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:14:\"new_creditspkg\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:5:\"store\";a:2:{s:5:\"value\";i:0;s:5:\"price\";i:0;}s:13:\"discount_code\";s:8:\"admin112\";}', 's:0:\"\";', '1', '2017-03-28 07:10:14', '0', '0', '', '0', '');


#
# Table structure for table `class_payment_processors`
#

DROP TABLE IF EXISTS `class_payment_processors`;
CREATE TABLE `class_payment_processors` (
  `processor_name` varchar(50) DEFAULT NULL,
  `processor_title` varchar(100) DEFAULT NULL,
  `processor_code` varchar(20) DEFAULT NULL,
  `processor_table` varchar(30) DEFAULT NULL,
  `processor_class` varchar(30) DEFAULT NULL,
  `processor_ret_table` varchar(30) DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT '1',
  `manual` tinyint(1) DEFAULT '1',
  `free` tinyint(1) DEFAULT '0',
  `pending` tinyint(1) DEFAULT '0',
  `recurring` tinyint(1) DEFAULT '-1',
  `percent_tax` float DEFAULT '0',
  `fixed_tax` float DEFAULT '0',
  KEY `idx_code` (`processor_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_payment_processors`
#

INSERT INTO class_payment_processors VALUES ('PayPal', 'PayPal', 'paypal', 'paypal_settings', 'paypal', 'paypal_ipn', '1', '0', '0', '0', '0', '0', '0');
INSERT INTO class_payment_processors VALUES ('2Checkout', '2Checkout', '2co', '2co_settings', 'to_checkout', '2co_return', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('Skrill', 'Skrill', 'mb', 'mb_settings', 'moneybookers', 'mb_return', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('Authorize.net SIM', 'Authorize.net', 'authorize', 'authorize_settings', 'authorize', 'authorize_return', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('ePay', 'Credit Card by ePay', 'epay', 'epay_settings', 'epay', 'epay_return', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('Manual Payment', 'Check', 'manual', '', 'manual_payment', 'manual_return', '0', '1', '0', '1', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('Fortumo', 'Fortumo SMS payment', 'fortumo', 'fortumo_settings', 'fortumo', 'fortumo_return', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('ICEPAY', 'ICEPAY', 'icepay', 'icepay_settings', 'icepay', 'icepay_ipn', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('PayTPV', 'PayTPV', 'paytpv', 'paytpv_settings', 'paytpv', 'paytpv_return', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('Free', 'GRATUIT', 'free', '', 'free', '', '1', '0', '1', '0', '0', '0', '0');
INSERT INTO class_payment_processors VALUES ('Credits', 'Credite', 'credits', 'credits_settings', 'credits_payment', 'credits_return', '1', '0', '1', '0', '0', '0', '0');
INSERT INTO class_payment_processors VALUES ('Hipay', 'Hipay', 'hipay', 'hipay_settings', 'hipay', 'hipay_return', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('Payfast', 'PayFast', 'payfast', 'payfast_settings', 'payfast', 'payfast_return', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('Robokassa', 'Robokassa', 'robokassa', 'robokassa_settings', 'robokassa', 'robokassa_return', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('Klarna', 'Klarna', 'klarna', 'klarna_settings', 'klarna', 'klarna_return', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('Instamojo', 'Instamojo', 'instamojo', 'instamojo_settings', 'instamojo', 'instamojo_return', '0', '0', '0', '0', '-1', '0', '0');
INSERT INTO class_payment_processors VALUES ('Pagseguro', 'Pagseguro', 'pagseguro', 'pagseguro_settings', 'pagseguro', 'pagseguro_return', '0', '0', '0', '0', '-1', '0', '0');


#
# Table structure for table `class_paypal_ipn`
#

DROP TABLE IF EXISTS `class_paypal_ipn`;
CREATE TABLE `class_paypal_ipn` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `item_name` varchar(130) DEFAULT NULL,
  `receiver_email` varchar(125) DEFAULT NULL,
  `item_number` varchar(130) DEFAULT '0',
  `quantity` smallint(6) DEFAULT '0',
  `invoice` varchar(25) DEFAULT '0',
  `custom` varchar(60) DEFAULT NULL,
  `payment_status` set('Completed','Pending','Failed','Denied') DEFAULT 'Failed',
  `pending_reason` set('echeck','intl','verify','address','upgrade','unilateral','other') DEFAULT 'other',
  `payment_gross` float DEFAULT '0',
  `payment_fee` float DEFAULT '0',
  `payment_type` set('echeck','instant') DEFAULT 'instant',
  `payment_date` varchar(50) DEFAULT '0',
  `txn_id` varchar(20) DEFAULT '0',
  `payer_email` varchar(125) DEFAULT NULL,
  `payer_status` set('verified','unverified','intl_verified') DEFAULT 'unverified',
  `txn_type` set('web_accept','cart','send_money','subscr_signup','subscr_cancel','subscr_failed','subscr_payment','subscr_eot') DEFAULT 'subscr_payment',
  `first_name` varchar(35) DEFAULT NULL,
  `last_name` varchar(60) DEFAULT NULL,
  `address_city` varchar(60) DEFAULT NULL,
  `address_street` varchar(60) DEFAULT NULL,
  `address_state` varchar(60) DEFAULT NULL,
  `address_zip` varchar(15) DEFAULT NULL,
  `address_country` varchar(60) DEFAULT NULL,
  `address_status` set('confirmed','unconfirmed') DEFAULT 'unconfirmed',
  `subscr_date` varchar(50) DEFAULT '0',
  `period1` varchar(20) DEFAULT 'UNK',
  `period2` varchar(20) DEFAULT 'UNK',
  `period3` varchar(20) DEFAULT 'UNK',
  `amount1` float DEFAULT '0',
  `amount2` float DEFAULT '0',
  `amount3` float DEFAULT '0',
  `recurring` tinyint(4) DEFAULT '1',
  `reattempt` tinyint(4) DEFAULT '0',
  `retry_at` varchar(50) DEFAULT NULL,
  `recur_times` smallint(6) DEFAULT '0',
  `username` varchar(25) DEFAULT NULL,
  `password` varchar(20) DEFAULT NULL,
  `subscr_id` varchar(20) DEFAULT NULL,
  `entirepost` text,
  `paypal_verified` set('VERIFIED','INVALID') DEFAULT 'INVALID',
  `verify_sign` varchar(125) DEFAULT NULL,
  `mc_currency` varchar(20) DEFAULT 'USD',
  `mc_gross` float DEFAULT '0',
  `mc_amount1` float NOT NULL DEFAULT '0',
  `mc_amount2` float NOT NULL DEFAULT '0',
  `mc_amount3` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `txn_type` (`txn_type`),
  KEY `payment_status` (`payment_status`),
  KEY `pending_reason` (`pending_reason`),
  KEY `payer_status` (`payer_status`),
  KEY `payment_type` (`payment_type`),
  KEY `retry_at` (`retry_at`),
  KEY `receiver_email` (`receiver_email`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_paypal_ipn`
#



#
# Table structure for table `class_paypal_settings`
#

DROP TABLE IF EXISTS `class_paypal_settings`;
CREATE TABLE `class_paypal_settings` (
  `paypal_email` varchar(128) DEFAULT NULL,
  `paypal_currency` char(3) DEFAULT NULL,
  `paypal_pay_title` char(50) DEFAULT NULL,
  `paypal_demo` tinyint(1) DEFAULT '0',
  `paypal_lc` varchar(2) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_paypal_settings`
#

INSERT INTO class_paypal_settings VALUES ('weltandrei@yahoo.com', 'EUR', 'Weltcars.com', '0', 'EU');


#
# Table structure for table `class_paytpv_return`
#

DROP TABLE IF EXISTS `class_paytpv_return`;
CREATE TABLE `class_paytpv_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(20) DEFAULT '0',
  `i` varchar(20) DEFAULT NULL,
  `r` varchar(50) DEFAULT NULL,
  `ret` varchar(50) DEFAULT NULL,
  `deserror` varchar(100) DEFAULT NULL,
  `TransactionType` int(3) DEFAULT NULL,
  `TransactionName` varchar(50) DEFAULT NULL,
  `CardCountry` varchar(50) DEFAULT NULL,
  `BankDateTime` datetime DEFAULT NULL,
  `Signature` varchar(50) DEFAULT NULL,
  `Order` varchar(50) DEFAULT NULL,
  `Response` varchar(50) DEFAULT NULL,
  `ErrorID` int(3) DEFAULT NULL,
  `ErrorDescription` int(100) DEFAULT NULL,
  `AuthCode` varchar(50) DEFAULT NULL,
  `Currency` varchar(3) DEFAULT NULL,
  `Amount` int(10) DEFAULT NULL,
  `AmountEur` int(10) DEFAULT NULL,
  `Language` varchar(50) DEFAULT NULL,
  `AccountCode` varchar(50) DEFAULT NULL,
  `TpvID` int(5) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_paytpv_return`
#



#
# Table structure for table `class_paytpv_settings`
#

DROP TABLE IF EXISTS `class_paytpv_settings`;
CREATE TABLE `class_paytpv_settings` (
  `paytpv_account` varchar(300) DEFAULT NULL,
  `paytpv_usercode` varchar(30) DEFAULT NULL,
  `paytpv_terminal` int(4) DEFAULT NULL,
  `paytpv_currency` varchar(3) DEFAULT NULL,
  `paytpv_password` varchar(40) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_paytpv_settings`
#

INSERT INTO class_paytpv_settings VALUES ('', '', '0', 'EUR', '');


#
# Table structure for table `class_pending_edited`
#

DROP TABLE IF EXISTS `class_pending_edited`;
CREATE TABLE `class_pending_edited` (
  `ad_id` int(10) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `edited` text,
  `pictures_edited` text,
  `notification_sent` tinyint(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_pending_edited`
#



#
# Table structure for table `class_periodic`
#

DROP TABLE IF EXISTS `class_periodic`;
CREATE TABLE `class_periodic` (
  `last_affiliates_payment` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_periodic`
#

INSERT INTO class_periodic VALUES ('0000-00-00 00:00:00');


#
# Table structure for table `class_popular_ads`
#

DROP TABLE IF EXISTS `class_popular_ads`;
CREATE TABLE `class_popular_ads` (
  `title_ro` varchar(100) DEFAULT NULL,
  `no_ads` int(2) DEFAULT '4'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_popular_ads`
#

INSERT INTO class_popular_ads VALUES ('Anunturi populare', '6');


#
# Table structure for table `class_price_drop_alert`
#

DROP TABLE IF EXISTS `class_price_drop_alert`;
CREATE TABLE `class_price_drop_alert` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `key` varchar(200) DEFAULT NULL,
  `user_id` int(7) DEFAULT '0',
  `email` varchar(40) DEFAULT NULL,
  `ad_id` int(7) NOT NULL,
  `init_price` double DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_price_drop_alert`
#



#
# Table structure for table `class_price_extra_settings`
#

DROP TABLE IF EXISTS `class_price_extra_settings`;
CREATE TABLE `class_price_extra_settings` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `fieldset` varchar(200) DEFAULT NULL,
  `use_negotiable` tinyint(1) DEFAULT '0',
  `use_free` tinyint(1) DEFAULT '0',
  `use_tags` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_price_extra_settings`
#

INSERT INTO class_price_extra_settings VALUES ('1', '7', '1', '0', '1');
INSERT INTO class_price_extra_settings VALUES ('2', '14', '1', '0', '1');


#
# Table structure for table `class_price_extra_settings_lang`
#

DROP TABLE IF EXISTS `class_price_extra_settings_lang`;
CREATE TABLE `class_price_extra_settings_lang` (
  `id` int(2) NOT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  `negotiable` varchar(40) DEFAULT NULL,
  `free` varchar(40) DEFAULT NULL,
  `tags` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_price_extra_settings_lang`
#

INSERT INTO class_price_extra_settings_lang VALUES ('1', 'ro', 'Negociabil', '', 'Predare Leasing|Schimb');
INSERT INTO class_price_extra_settings_lang VALUES ('2', 'ro', 'Negociabil', '', 'Schimb');


#
# Table structure for table `class_priorities`
#

DROP TABLE IF EXISTS `class_priorities`;
CREATE TABLE `class_priorities` (
  `id` int(4) NOT NULL AUTO_INCREMENT,
  `price` double DEFAULT NULL,
  `order_no` int(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_order_no` (`order_no`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_priorities`
#

INSERT INTO class_priorities VALUES ('1', '2', '2');
INSERT INTO class_priorities VALUES ('2', '1', '1');
INSERT INTO class_priorities VALUES ('3', '5', '3');


#
# Table structure for table `class_priorities_lang`
#

DROP TABLE IF EXISTS `class_priorities_lang`;
CREATE TABLE `class_priorities_lang` (
  `id` int(4) NOT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  `name` varchar(50) DEFAULT NULL,
  KEY `idx_id` (`id`),
  KEY `idx_name` (`name`),
  KEY `idx_lang` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_priorities_lang`
#

INSERT INTO class_priorities_lang VALUES ('1', 'eng', 'Gold');
INSERT INTO class_priorities_lang VALUES ('2', 'eng', 'Silver');
INSERT INTO class_priorities_lang VALUES ('1', 'esp', 'Gold');
INSERT INTO class_priorities_lang VALUES ('2', 'esp', 'Silver');
INSERT INTO class_priorities_lang VALUES ('1', 'french', 'Gold');
INSERT INTO class_priorities_lang VALUES ('2', 'french', 'Silver');
INSERT INTO class_priorities_lang VALUES ('1', 'italian', 'Gold');
INSERT INTO class_priorities_lang VALUES ('2', 'italian', 'Silver');
INSERT INTO class_priorities_lang VALUES ('1', 'german', 'Gold');
INSERT INTO class_priorities_lang VALUES ('2', 'german', 'Silver');
INSERT INTO class_priorities_lang VALUES ('1', 'ro', 'Gold');
INSERT INTO class_priorities_lang VALUES ('2', 'ro', 'Silver');
INSERT INTO class_priorities_lang VALUES ('1', 'hr', 'Gold');
INSERT INTO class_priorities_lang VALUES ('2', 'hr', 'Silver');
INSERT INTO class_priorities_lang VALUES ('1', 'hu', 'Gold');
INSERT INTO class_priorities_lang VALUES ('2', 'hu', 'Silver');
INSERT INTO class_priorities_lang VALUES ('1', 'bg', 'Gold');
INSERT INTO class_priorities_lang VALUES ('2', 'bg', 'Silver');
INSERT INTO class_priorities_lang VALUES ('3', 'ro', 'Platinum');


#
# Table structure for table `class_robokassa_return`
#

DROP TABLE IF EXISTS `class_robokassa_return`;
CREATE TABLE `class_robokassa_return` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ukey` varchar(255) DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `OutSum` varchar(100) DEFAULT NULL,
  `InvId` varchar(100) DEFAULT NULL,
  `SignatureValue` varchar(100) DEFAULT NULL,
  `entirepost` text,
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `ukey` (`ukey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_robokassa_return`
#



#
# Table structure for table `class_robokassa_settings`
#

DROP TABLE IF EXISTS `class_robokassa_settings`;
CREATE TABLE `class_robokassa_settings` (
  `login` varchar(20) DEFAULT NULL,
  `password1` varchar(50) DEFAULT NULL,
  `password2` varchar(50) DEFAULT NULL,
  `currency` varchar(20) DEFAULT NULL,
  `language` varchar(10) DEFAULT NULL,
  `encoding` varchar(10) DEFAULT NULL,
  `payment_desc` text,
  `test` int(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_robokassa_settings`
#

INSERT INTO class_robokassa_settings VALUES ('', '', '', '', '', 'utf8', '', '0');


#
# Table structure for table `class_rss`
#

DROP TABLE IF EXISTS `class_rss`;
CREATE TABLE `class_rss` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) DEFAULT '1',
  `enabled` tinyint(1) DEFAULT NULL,
  `link` varchar(200) DEFAULT NULL,
  `language` varchar(20) DEFAULT NULL,
  `feedburner` varchar(250) DEFAULT NULL,
  `parameters` varchar(255) DEFAULT NULL,
  `no_items` int(2) DEFAULT NULL,
  `show_fields` text,
  `logo_field` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_enabled` (`enabled`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_rss`
#



#
# Table structure for table `class_rss_lang`
#

DROP TABLE IF EXISTS `class_rss_lang`;
CREATE TABLE `class_rss_lang` (
  `id` int(2) NOT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  `short_title` varchar(50) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_rss_lang`
#



#
# Table structure for table `class_rules`
#

DROP TABLE IF EXISTS `class_rules`;
CREATE TABLE `class_rules` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `type` varchar(20) NOT NULL,
  `category` text,
  `field` varchar(30) DEFAULT NULL,
  `selected_values` text,
  `second_field` varchar(30) DEFAULT NULL,
  `allowed_values` text,
  `required_field` varchar(30) DEFAULT NULL,
  `required_group` int(2) DEFAULT NULL,
  `error_message` varchar(250) DEFAULT NULL,
  `order_no` int(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_rules`
#



#
# Table structure for table `class_saved_searches`
#

DROP TABLE IF EXISTS `class_saved_searches`;
CREATE TABLE `class_saved_searches` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user_id` int(10) DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `search` text,
  `browser` varchar(200) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_date` (`date`),
  KEY `idx_ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_saved_searches`
#



#
# Table structure for table `class_scheduled_imports`
#

DROP TABLE IF EXISTS `class_scheduled_imports`;
CREATE TABLE `class_scheduled_imports` (
  `id` int(2) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `type` varchar(3) DEFAULT NULL,
  `access_type` varchar(10) DEFAULT 'url',
  `template` int(3) DEFAULT NULL,
  `category_id` int(5) DEFAULT '0',
  `package_id` int(2) DEFAULT '0',
  `url` varchar(250) DEFAULT NULL,
  `ftp_server` varchar(250) DEFAULT NULL,
  `ftp_login` varchar(100) DEFAULT NULL,
  `ftp_password` varchar(50) DEFAULT NULL,
  `ftp_filename` varchar(100) DEFAULT NULL,
  `user_id` int(10) DEFAULT NULL,
  `use_id_as_unique_field` int(1) DEFAULT '0',
  `delete_inexisting` tinyint(1) DEFAULT '0',
  `only_download_inexisting` int(1) DEFAULT '0',
  `key` varchar(30) DEFAULT NULL,
  `active` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_scheduled_imports`
#



#
# Table structure for table `class_security_settings`
#

DROP TABLE IF EXISTS `class_security_settings`;
CREATE TABLE `class_security_settings` (
  `block_admin_attempts` tinyint(1) DEFAULT '0',
  `allowed_admin_attempts` int(2) DEFAULT '3',
  `block_admin_attempts_for` int(4) DEFAULT '1',
  `block_user_attempts` tinyint(1) DEFAULT '0',
  `allowed_user_attempts` int(1) DEFAULT '5',
  `block_user_attempts_for` int(4) DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_security_settings`
#

INSERT INTO class_security_settings VALUES ('0', '3', '1', '0', '5', '1');


#
# Table structure for table `class_seo_pages`
#

DROP TABLE IF EXISTS `class_seo_pages`;
CREATE TABLE `class_seo_pages` (
  `lang_id` varchar(20) DEFAULT 'eng',
  `page` varchar(30) NOT NULL,
  `page_description` varchar(70) DEFAULT NULL,
  `title` text,
  `meta_description` text,
  `meta_keywords` text,
  `noindex` tinyint(1) DEFAULT '0',
  `order_no` int(2) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_seo_pages`
#

INSERT INTO class_seo_pages VALUES ('eng', 'index', 'Site index page', '', '', '', '0', '1');
INSERT INTO class_seo_pages VALUES ('eng', 'details', 'Listing details page', '%category_name - %title', '%category_name %description', '%category_name,%title,%description', '0', '2');
INSERT INTO class_seo_pages VALUES ('eng', 'listings', 'Search page', '', '', '', '0', '3');
INSERT INTO class_seo_pages VALUES ('eng', 'contact_details', 'Contact details page ( mobile only )', '', '', '', '0', '4');
INSERT INTO class_seo_pages VALUES ('eng', 'login', 'Login page', '', '', '', '0', '5');
INSERT INTO class_seo_pages VALUES ('eng', 'register', 'User registration page', '', '', '', '0', '6');
INSERT INTO class_seo_pages VALUES ('eng', 'pre-register', 'Pre-registration page ( user group choices )', '', '', '', '0', '7');
INSERT INTO class_seo_pages VALUES ('eng', 'pre-submit', 'Pre-submit ad page (choice between login or post wihtout a user accoun', '', '', '', '0', '8');
INSERT INTO class_seo_pages VALUES ('eng', 'recent_ads', 'Recent ads page', '', '', '', '0', '9');
INSERT INTO class_seo_pages VALUES ('eng', 'refine', 'Refine search page ( mobile only )', '', '', '', '0', '10');
INSERT INTO class_seo_pages VALUES ('eng', 'store', 'Dealer page', '', '', '', '0', '11');
INSERT INTO class_seo_pages VALUES ('eng', 'user_listings', 'Regular user page', '', '', '', '0', '12');
INSERT INTO class_seo_pages VALUES ('eng', 'notfound', 'Page not found', '', '', '', '0', '13');
INSERT INTO class_seo_pages VALUES ('eng', 'contact', 'Contact page', '', '', '', '0', '14');
INSERT INTO class_seo_pages VALUES ('eng', 'favorites', 'Favorites listings page', '', '', '', '0', '15');
INSERT INTO class_seo_pages VALUES ('esp', 'index', 'Site index page', '', '', '', '0', '1');
INSERT INTO class_seo_pages VALUES ('esp', 'details', 'Listing details page', '%category_name - %title', '%category_name %description', '%category_name,%title,%description', '0', '2');
INSERT INTO class_seo_pages VALUES ('esp', 'listings', 'Search page', '', '', '', '0', '3');
INSERT INTO class_seo_pages VALUES ('esp', 'contact_details', 'Contact details page ( mobile only )', '', '', '', '0', '4');
INSERT INTO class_seo_pages VALUES ('esp', 'login', 'Login page', '', '', '', '0', '5');
INSERT INTO class_seo_pages VALUES ('esp', 'register', 'User registration page', '', '', '', '0', '6');
INSERT INTO class_seo_pages VALUES ('esp', 'pre-register', 'Pre-registration page ( user group choices )', '', '', '', '0', '7');
INSERT INTO class_seo_pages VALUES ('esp', 'pre-submit', 'Pre-submit ad page (choice between login or post wihtout a user accoun', '', '', '', '0', '8');
INSERT INTO class_seo_pages VALUES ('esp', 'recent_ads', 'Recent ads page', '', '', '', '0', '9');
INSERT INTO class_seo_pages VALUES ('esp', 'refine', 'Refine search page ( mobile only )', '', '', '', '0', '10');
INSERT INTO class_seo_pages VALUES ('esp', 'store', 'Dealer page', '', '', '', '0', '11');
INSERT INTO class_seo_pages VALUES ('esp', 'user_listings', 'Regular user page', '', '', '', '0', '12');
INSERT INTO class_seo_pages VALUES ('esp', 'notfound', 'Page not found', '', '', '', '0', '13');
INSERT INTO class_seo_pages VALUES ('esp', 'contact', 'Contact page', '', '', '', '0', '14');
INSERT INTO class_seo_pages VALUES ('esp', 'favorites', 'Favorites listings page', '', '', '', '0', '15');
INSERT INTO class_seo_pages VALUES ('french', 'index', 'Site index page', '', '', '', '0', '1');
INSERT INTO class_seo_pages VALUES ('french', 'details', 'Listing details page', '%category_name - %title', '%category_name %description', '%category_name,%title,%description', '0', '2');
INSERT INTO class_seo_pages VALUES ('french', 'listings', 'Search page', '', '', '', '0', '3');
INSERT INTO class_seo_pages VALUES ('french', 'contact_details', 'Contact details page ( mobile only )', '', '', '', '0', '4');
INSERT INTO class_seo_pages VALUES ('french', 'login', 'Login page', '', '', '', '0', '5');
INSERT INTO class_seo_pages VALUES ('french', 'register', 'User registration page', '', '', '', '0', '6');
INSERT INTO class_seo_pages VALUES ('french', 'pre-register', 'Pre-registration page ( user group choices )', '', '', '', '0', '7');
INSERT INTO class_seo_pages VALUES ('french', 'pre-submit', 'Pre-submit ad page (choice between login or post wihtout a user accoun', '', '', '', '0', '8');
INSERT INTO class_seo_pages VALUES ('french', 'recent_ads', 'Recent ads page', '', '', '', '0', '9');
INSERT INTO class_seo_pages VALUES ('french', 'refine', 'Refine search page ( mobile only )', '', '', '', '0', '10');
INSERT INTO class_seo_pages VALUES ('french', 'store', 'Dealer page', '', '', '', '0', '11');
INSERT INTO class_seo_pages VALUES ('french', 'user_listings', 'Regular user page', '', '', '', '0', '12');
INSERT INTO class_seo_pages VALUES ('french', 'notfound', 'Page not found', '', '', '', '0', '13');
INSERT INTO class_seo_pages VALUES ('french', 'contact', 'Contact page', '', '', '', '0', '14');
INSERT INTO class_seo_pages VALUES ('french', 'favorites', 'Favorites listings page', '', '', '', '0', '15');
INSERT INTO class_seo_pages VALUES ('italian', 'index', 'Site index page', '', '', '', '0', '1');
INSERT INTO class_seo_pages VALUES ('italian', 'details', 'Listing details page', '%category_name - %title', '%category_name %description', '%category_name,%title,%description', '0', '2');
INSERT INTO class_seo_pages VALUES ('italian', 'listings', 'Search page', '', '', '', '0', '3');
INSERT INTO class_seo_pages VALUES ('italian', 'contact_details', 'Contact details page ( mobile only )', '', '', '', '0', '4');
INSERT INTO class_seo_pages VALUES ('italian', 'login', 'Login page', '', '', '', '0', '5');
INSERT INTO class_seo_pages VALUES ('italian', 'register', 'User registration page', '', '', '', '0', '6');
INSERT INTO class_seo_pages VALUES ('italian', 'pre-register', 'Pre-registration page ( user group choices )', '', '', '', '0', '7');
INSERT INTO class_seo_pages VALUES ('italian', 'pre-submit', 'Pre-submit ad page (choice between login or post wihtout a user accoun', '', '', '', '0', '8');
INSERT INTO class_seo_pages VALUES ('italian', 'recent_ads', 'Recent ads page', '', '', '', '0', '9');
INSERT INTO class_seo_pages VALUES ('italian', 'refine', 'Refine search page ( mobile only )', '', '', '', '0', '10');
INSERT INTO class_seo_pages VALUES ('italian', 'store', 'Dealer page', '', '', '', '0', '11');
INSERT INTO class_seo_pages VALUES ('italian', 'user_listings', 'Regular user page', '', '', '', '0', '12');
INSERT INTO class_seo_pages VALUES ('italian', 'notfound', 'Page not found', '', '', '', '0', '13');
INSERT INTO class_seo_pages VALUES ('italian', 'contact', 'Contact page', '', '', '', '0', '14');
INSERT INTO class_seo_pages VALUES ('italian', 'favorites', 'Favorites listings page', '', '', '', '0', '15');
INSERT INTO class_seo_pages VALUES ('german', 'index', 'Site index page', '', '', '', '0', '1');
INSERT INTO class_seo_pages VALUES ('german', 'details', 'Listing details page', '%category_name - %title', '%category_name %description', '%category_name,%title,%description', '0', '2');
INSERT INTO class_seo_pages VALUES ('german', 'listings', 'Search page', '', '', '', '0', '3');
INSERT INTO class_seo_pages VALUES ('german', 'contact_details', 'Contact details page ( mobile only )', '', '', '', '0', '4');
INSERT INTO class_seo_pages VALUES ('german', 'login', 'Login page', '', '', '', '0', '5');
INSERT INTO class_seo_pages VALUES ('german', 'register', 'User registration page', '', '', '', '0', '6');
INSERT INTO class_seo_pages VALUES ('german', 'pre-register', 'Pre-registration page ( user group choices )', '', '', '', '0', '7');
INSERT INTO class_seo_pages VALUES ('german', 'pre-submit', 'Pre-submit ad page (choice between login or post wihtout a user accoun', '', '', '', '0', '8');
INSERT INTO class_seo_pages VALUES ('german', 'recent_ads', 'Recent ads page', '', '', '', '0', '9');
INSERT INTO class_seo_pages VALUES ('german', 'refine', 'Refine search page ( mobile only )', '', '', '', '0', '10');
INSERT INTO class_seo_pages VALUES ('german', 'store', 'Dealer page', '', '', '', '0', '11');
INSERT INTO class_seo_pages VALUES ('german', 'user_listings', 'Regular user page', '', '', '', '0', '12');
INSERT INTO class_seo_pages VALUES ('german', 'notfound', 'Page not found', '', '', '', '0', '13');
INSERT INTO class_seo_pages VALUES ('german', 'contact', 'Contact page', '', '', '', '0', '14');
INSERT INTO class_seo_pages VALUES ('german', 'favorites', 'Favorites listings page', '', '', '', '0', '15');
INSERT INTO class_seo_pages VALUES ('ro', 'index', 'Site index page', 'Anunturi auto gratuite prin weltcars.com', 'Anunturi automobile gratuite prin weltcars.com', 'anunturi auto, piata auto, anunturi masini', '0', '1');
INSERT INTO class_seo_pages VALUES ('ro', 'details', 'Listing details page', '%category_name - %title', '%category_name %description', '%category_name,%title,%description', '0', '2');
INSERT INTO class_seo_pages VALUES ('ro', 'listings', 'Search page', '%category_name', '', '', '0', '3');
INSERT INTO class_seo_pages VALUES ('ro', 'contact_details', 'Contact details page ( mobile only )', '', '', '', '0', '4');
INSERT INTO class_seo_pages VALUES ('ro', 'login', 'Login page', '', '', '', '0', '5');
INSERT INTO class_seo_pages VALUES ('ro', 'register', 'User registration page', '', '', '', '0', '6');
INSERT INTO class_seo_pages VALUES ('ro', 'pre-register', 'Pre-registration page ( user group choices )', '', '', '', '0', '7');
INSERT INTO class_seo_pages VALUES ('ro', 'pre-submit', 'Pre-submit ad page (choice between login or post wihtout a user accoun', '', '', '', '0', '8');
INSERT INTO class_seo_pages VALUES ('ro', 'recent_ads', 'Recent ads page', '', '', '', '0', '9');
INSERT INTO class_seo_pages VALUES ('ro', 'refine', 'Refine search page ( mobile only )', '', '', '', '0', '10');
INSERT INTO class_seo_pages VALUES ('ro', 'store', 'Dealer page', '', '', '', '0', '11');
INSERT INTO class_seo_pages VALUES ('ro', 'user_listings', 'Regular user page', '', '', '', '0', '12');
INSERT INTO class_seo_pages VALUES ('ro', 'notfound', 'Page not found', '', '', '', '0', '13');
INSERT INTO class_seo_pages VALUES ('ro', 'contact', 'Contact page', '', '', '', '0', '14');
INSERT INTO class_seo_pages VALUES ('ro', 'favorites', 'Favorites listings page', '', '', '', '0', '15');
INSERT INTO class_seo_pages VALUES ('hr', 'index', 'Site index page', '', '', '', '0', '1');
INSERT INTO class_seo_pages VALUES ('hr', 'details', 'Listing details page', '%category_name - %title', '%category_name %description', '%category_name,%title,%description', '0', '2');
INSERT INTO class_seo_pages VALUES ('hr', 'listings', 'Search page', '', '', '', '0', '3');
INSERT INTO class_seo_pages VALUES ('hr', 'contact_details', 'Contact details page ( mobile only )', '', '', '', '0', '4');
INSERT INTO class_seo_pages VALUES ('hr', 'login', 'Login page', '', '', '', '0', '5');
INSERT INTO class_seo_pages VALUES ('hr', 'register', 'User registration page', '', '', '', '0', '6');
INSERT INTO class_seo_pages VALUES ('hr', 'pre-register', 'Pre-registration page ( user group choices )', '', '', '', '0', '7');
INSERT INTO class_seo_pages VALUES ('hr', 'pre-submit', 'Pre-submit ad page (choice between login or post wihtout a user accoun', '', '', '', '0', '8');
INSERT INTO class_seo_pages VALUES ('hr', 'recent_ads', 'Recent ads page', '', '', '', '0', '9');
INSERT INTO class_seo_pages VALUES ('hr', 'refine', 'Refine search page ( mobile only )', '', '', '', '0', '10');
INSERT INTO class_seo_pages VALUES ('hr', 'store', 'Dealer page', '', '', '', '0', '11');
INSERT INTO class_seo_pages VALUES ('hr', 'user_listings', 'Regular user page', '', '', '', '0', '12');
INSERT INTO class_seo_pages VALUES ('hr', 'notfound', 'Page not found', '', '', '', '0', '13');
INSERT INTO class_seo_pages VALUES ('hr', 'contact', 'Contact page', '', '', '', '0', '14');
INSERT INTO class_seo_pages VALUES ('hr', 'favorites', 'Favorites listings page', '', '', '', '0', '15');
INSERT INTO class_seo_pages VALUES ('hu', 'index', 'Site index page', '', '', '', '0', '1');
INSERT INTO class_seo_pages VALUES ('hu', 'details', 'Listing details page', '%category_name - %title', '%category_name %description', '%category_name,%title,%description', '0', '2');
INSERT INTO class_seo_pages VALUES ('hu', 'listings', 'Search page', '', '', '', '0', '3');
INSERT INTO class_seo_pages VALUES ('hu', 'contact_details', 'Contact details page ( mobile only )', '', '', '', '0', '4');
INSERT INTO class_seo_pages VALUES ('hu', 'login', 'Login page', '', '', '', '0', '5');
INSERT INTO class_seo_pages VALUES ('hu', 'register', 'User registration page', '', '', '', '0', '6');
INSERT INTO class_seo_pages VALUES ('hu', 'pre-register', 'Pre-registration page ( user group choices )', '', '', '', '0', '7');
INSERT INTO class_seo_pages VALUES ('hu', 'pre-submit', 'Pre-submit ad page (choice between login or post wihtout a user accoun', '', '', '', '0', '8');
INSERT INTO class_seo_pages VALUES ('hu', 'recent_ads', 'Recent ads page', '', '', '', '0', '9');
INSERT INTO class_seo_pages VALUES ('hu', 'refine', 'Refine search page ( mobile only )', '', '', '', '0', '10');
INSERT INTO class_seo_pages VALUES ('hu', 'store', 'Dealer page', '', '', '', '0', '11');
INSERT INTO class_seo_pages VALUES ('hu', 'user_listings', 'Regular user page', '', '', '', '0', '12');
INSERT INTO class_seo_pages VALUES ('hu', 'notfound', 'Page not found', '', '', '', '0', '13');
INSERT INTO class_seo_pages VALUES ('hu', 'contact', 'Contact page', '', '', '', '0', '14');
INSERT INTO class_seo_pages VALUES ('hu', 'favorites', 'Favorites listings page', '', '', '', '0', '15');
INSERT INTO class_seo_pages VALUES ('bg', 'index', 'Site index page', '', '', '', '0', '1');
INSERT INTO class_seo_pages VALUES ('bg', 'details', 'Listing details page', '%category_name - %title', '%category_name %description', '%category_name,%title,%description', '0', '2');
INSERT INTO class_seo_pages VALUES ('bg', 'listings', 'Search page', '', '', '', '0', '3');
INSERT INTO class_seo_pages VALUES ('bg', 'contact_details', 'Contact details page ( mobile only )', '', '', '', '0', '4');
INSERT INTO class_seo_pages VALUES ('bg', 'login', 'Login page', '', '', '', '0', '5');
INSERT INTO class_seo_pages VALUES ('bg', 'register', 'User registration page', '', '', '', '0', '6');
INSERT INTO class_seo_pages VALUES ('bg', 'pre-register', 'Pre-registration page ( user group choices )', '', '', '', '0', '7');
INSERT INTO class_seo_pages VALUES ('bg', 'pre-submit', 'Pre-submit ad page (choice between login or post wihtout a user accoun', '', '', '', '0', '8');
INSERT INTO class_seo_pages VALUES ('bg', 'recent_ads', 'Recent ads page', '', '', '', '0', '9');
INSERT INTO class_seo_pages VALUES ('bg', 'refine', 'Refine search page ( mobile only )', '', '', '', '0', '10');
INSERT INTO class_seo_pages VALUES ('bg', 'store', 'Dealer page', '', '', '', '0', '11');
INSERT INTO class_seo_pages VALUES ('bg', 'user_listings', 'Regular user page', '', '', '', '0', '12');
INSERT INTO class_seo_pages VALUES ('bg', 'notfound', 'Page not found', '', '', '', '0', '13');
INSERT INTO class_seo_pages VALUES ('bg', 'contact', 'Contact page', '', '', '', '0', '14');
INSERT INTO class_seo_pages VALUES ('bg', 'favorites', 'Favorites listings page', '', '', '', '0', '15');


#
# Table structure for table `class_seo_settings`
#

DROP TABLE IF EXISTS `class_seo_settings`;
CREATE TABLE `class_seo_settings` (
  `enable_mod_rewrite` tinyint(1) DEFAULT '0',
  `analytics_code` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_seo_settings`
#

INSERT INTO class_seo_settings VALUES ('1', '<script>\r\n  (function(i,s,o,g,r,a,m){i[\'GoogleAnalyticsObject\']=r;i[r]=i[r]||function(){\r\n  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),\r\n  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)\r\n  })(window,document,\'script\',\'https://www.google-analytics.com/analytics.js\',\'ga\');\r\n\r\n  ga(\'create\', \'UA-57109835-1\', \'auto\');\r\n  ga(\'send\', \'pageview\');\r\n\r\n</script>');


#
# Table structure for table `class_settings`
#

DROP TABLE IF EXISTS `class_settings`;
CREATE TABLE `class_settings` (
  `admin_username` varchar(50) DEFAULT NULL,
  `admin_password` varchar(50) DEFAULT NULL,
  `admin_email` varchar(128) DEFAULT NULL,
  `contact_email` varchar(128) DEFAULT NULL,
  `users_delete_ads` tinyint(1) DEFAULT '0',
  `users_feature_ads` tinyint(1) DEFAULT '1',
  `register_captcha` tinyint(1) DEFAULT '1',
  `contact_captcha` tinyint(1) DEFAULT '1',
  `login_captcha` tinyint(1) DEFAULT '0',
  `delete_login_older_than` int(4) DEFAULT NULL,
  `google_maps_default_long` double DEFAULT NULL,
  `google_maps_default_lat` double DEFAULT NULL,
  `google_maps_default_height` int(2) DEFAULT '4',
  `google_maps_api_key` varchar(50) DEFAULT NULL,
  `cron_simulator` tinyint(1) DEFAULT '1',
  `session_expires` int(8) DEFAULT '1440',
  `delete_expired` tinyint(1) DEFAULT '0',
  `days_del_expired` int(4) DEFAULT '30',
  `days_notify` int(1) DEFAULT '3',
  `send_mail_to_admin_when_pending` tinyint(1) DEFAULT '1',
  `send_mail_to_admin_when_new_ad` tinyint(1) DEFAULT '1',
  `send_mail_to_admin_when_registeres` tinyint(1) DEFAULT '1',
  `send_mail_to_user_when_expired` tinyint(1) DEFAULT '1',
  `send_mail_to_user_before_expires` tinyint(1) DEFAULT '1',
  `nologin_enabled` tinyint(1) DEFAULT '0',
  `nologin_activate_listing` tinyint(1) DEFAULT '1',
  `nologin_pending_listing` tinyint(1) DEFAULT '0',
  `nologin_allow_edit` tinyint(1) DEFAULT '1',
  `nologin_allow_delete` tinyint(1) DEFAULT '1',
  `nologin_extra_options` tinyint(1) DEFAULT '1',
  `nologin_image_verification` tinyint(1) DEFAULT '0',
  `internal_messaging` tinyint(1) DEFAULT '1',
  `enable_locations` tinyint(1) DEFAULT '0',
  `location_fields` varchar(100) DEFAULT NULL,
  `enable_subdomains` tinyint(1) DEFAULT '0',
  `subdomain_field` varchar(40) DEFAULT NULL,
  `enable_recaptcha` tinyint(1) DEFAULT '0',
  `recaptcha_public_key` varchar(50) DEFAULT NULL,
  `recaptcha_private_key` varchar(50) DEFAULT NULL,
  `contact_messages_pending` tinyint(1) DEFAULT '0',
  `users_can_ask_account_removal` tinyint(1) DEFAULT '0',
  `time_offset` int(5) DEFAULT '0',
  `enable_username` tinyint(1) DEFAULT '1',
  `contact_name_field` varchar(32) DEFAULT 'contact_name',
  `enable_affiliates` tinyint(1) DEFAULT '0',
  `affiliates_cookie_availability` int(4) DEFAULT '7',
  `affiliates_percentage` int(3) DEFAULT '50',
  `affiliates_payment_cycle` int(4) DEFAULT '30',
  `affiliates_auto_register` tinyint(1) DEFAULT '1',
  `affiliates_activate_account` tinyint(1) DEFAULT '1',
  `affiliates_admin_verification` tinyint(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_settings`
#

INSERT INTO class_settings VALUES ('admin', 'e6982d4a2215af8a1e9f8225fe86b70c', 'info@weltcars.com', 'info@weltcars.com', '1', '1', '1', '1', '0', '30', '-83.022206', '39.998264', '4', '', '1', '0', '0', '30', '3', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '0', '0', '1', '0', '', '0', 'judet', '1', '6LfuvxMUAAAAAPbbUEfkNmU9RQA5QQ4K1BrXSfA6', '6LfuvxMUAAAAAB-Hm_hx3_Tpqi5KCkjU_hTBZndW', '0', '0', '0', '1', 'contact_name', '0', '180', '50', '30', '1', '1', '0');


#
# Table structure for table `class_settings_lang`
#

DROP TABLE IF EXISTS `class_settings_lang`;
CREATE TABLE `class_settings_lang` (
  `lang_id` varchar(20) DEFAULT 'eng',
  `admin_name` varchar(128) DEFAULT NULL,
  `site_name` varchar(128) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_settings_lang`
#

INSERT INTO class_settings_lang VALUES ('eng', 'Site Administrator', 'Weltcars.com - site de anunturi auto online');
INSERT INTO class_settings_lang VALUES ('esp', 'Site Administrator', 'Weltcars.com - site de anunturi auto online');
INSERT INTO class_settings_lang VALUES ('french', 'Site Administrator', 'Weltcars.com - site de anunturi auto online');
INSERT INTO class_settings_lang VALUES ('italian', 'Site Administrator', 'Weltcars.com - site de anunturi auto online');
INSERT INTO class_settings_lang VALUES ('german', 'Site Administrator', 'Weltcars.com - site de anunturi auto online');
INSERT INTO class_settings_lang VALUES ('ro', 'Site Administrator', 'Weltcars.com - site de anunturi auto online');
INSERT INTO class_settings_lang VALUES ('hr', 'Site Administrator', 'Weltcars.com - site de anunturi auto online');
INSERT INTO class_settings_lang VALUES ('hu', 'Site Administrator', 'Weltcars.com - site de anunturi auto online');
INSERT INTO class_settings_lang VALUES ('bg', 'Site Administrator', 'Weltcars.com - site de anunturi auto online');


#
# Table structure for table `class_similar_ads`
#

DROP TABLE IF EXISTS `class_similar_ads`;
CREATE TABLE `class_similar_ads` (
  `title_ro` varchar(100) DEFAULT NULL,
  `no_ads` int(2) DEFAULT '4',
  `no_ads_on_row` int(2) DEFAULT '4',
  `match_category` tinyint(1) DEFAULT '1',
  `match_fields` varchar(100) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_similar_ads`
#

INSERT INTO class_similar_ads VALUES ('Anunturi similare', '5', '5', '1', 'marca,model');


#
# Table structure for table `class_sitemap`
#

DROP TABLE IF EXISTS `class_sitemap`;
CREATE TABLE `class_sitemap` (
  `enabled` tinyint(1) DEFAULT NULL,
  `write_categories` tinyint(1) DEFAULT '1',
  `write_listings` tinyint(1) DEFAULT '1',
  `write_custom_pages` tinyint(1) DEFAULT '1',
  `priority` double(4,2) DEFAULT NULL,
  `changefreq` varchar(20) DEFAULT NULL,
  `categories_priority` double(4,2) DEFAULT NULL,
  `categories_changefreq` varchar(20) DEFAULT NULL,
  `listings_priority` double(4,2) DEFAULT NULL,
  `listings_changefreq` varchar(20) DEFAULT NULL,
  `listings_no` int(10) DEFAULT NULL,
  `cp_priority` double(4,2) DEFAULT NULL,
  `cp_changefreq` varchar(20) DEFAULT NULL,
  `auto_write_freq` varchar(20) DEFAULT NULL,
  `generated_last` datetime DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_sitemap`
#

INSERT INTO class_sitemap VALUES ('1', '1', '1', '1', '0.25', 'monthly', '0.50', 'weekly', '0.75', 'daily', '100', '0.50', 'weekly', 'daily', '2017-04-02 00:00:11');


#
# Table structure for table `class_sms_gateways`
#

DROP TABLE IF EXISTS `class_sms_gateways`;
CREATE TABLE `class_sms_gateways` (
  `gateway_name` varchar(50) DEFAULT NULL,
  `gateway_title` varchar(50) DEFAULT NULL,
  `gateway_code` varchar(20) DEFAULT NULL,
  `gateway_table` varchar(30) DEFAULT NULL,
  `gateway_class` varchar(30) DEFAULT NULL,
  `gateway_ret_table` varchar(30) DEFAULT NULL,
  `default` tinyint(1) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_sms_gateways`
#

INSERT INTO class_sms_gateways VALUES ('Clickatell', 'Clickatell', 'clickatell', 'clickatell', 'clickatell', 'clickatell_log', '1');
INSERT INTO class_sms_gateways VALUES ('BulkSMS', 'BulkSMS', 'bulksms', 'bulksms', 'bulksms', 'bulksms_log', '0');
INSERT INTO class_sms_gateways VALUES ('Experttexting', 'Experttexting', 'experttexting', 'experttexting', 'experttexting', 'experttexting_log', '0');


#
# Table structure for table `class_spam_prevention`
#

DROP TABLE IF EXISTS `class_spam_prevention`;
CREATE TABLE `class_spam_prevention` (
  `check_registration` int(1) DEFAULT '1',
  `check_contact_forms` int(1) DEFAULT '1',
  `check_comments` int(1) DEFAULT '1',
  `check_reviews` int(1) DEFAULT '1',
  `block_tor_ips` int(1) DEFAULT '1',
  `block_networks` int(1) DEFAULT '0',
  `block_limit` int(3) DEFAULT '50',
  `block_for` int(4) DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_spam_prevention`
#

INSERT INTO class_spam_prevention VALUES ('1', '1', '1', '1', '1', '0', '50', '1');


#
# Table structure for table `class_spam_prevention_log`
#

DROP TABLE IF EXISTS `class_spam_prevention_log`;
CREATE TABLE `class_spam_prevention_log` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `email` varchar(150) DEFAULT NULL,
  `ip` varchar(15) DEFAULT NULL,
  `confidence` float DEFAULT NULL,
  `type` varchar(10) DEFAULT 'register',
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_spam_prevention_log`
#



#
# Table structure for table `class_tag_cloud`
#

DROP TABLE IF EXISTS `class_tag_cloud`;
CREATE TABLE `class_tag_cloud` (
  `title_ro` varchar(100) DEFAULT NULL,
  `no_tags` int(3) DEFAULT '50',
  `period` int(3) DEFAULT '30',
  `min_letters` int(3) DEFAULT '3',
  `exclude` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_tag_cloud`
#

INSERT INTO class_tag_cloud VALUES ('Cuvinte cautare', '50', '30', '3', 'pula,cur,tate');


#
# Table structure for table `class_tag_cloud_searches`
#

DROP TABLE IF EXISTS `class_tag_cloud_searches`;
CREATE TABLE `class_tag_cloud_searches` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `word` varchar(50) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `no` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `no` (`no`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_tag_cloud_searches`
#

INSERT INTO class_tag_cloud_searches VALUES ('35', 'audi', '2017-03-30 06:55:09', '1');


#
# Table structure for table `class_tara`
#

DROP TABLE IF EXISTS `class_tara`;
CREATE TABLE `class_tara` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) DEFAULT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  `set_id` int(3) DEFAULT '0',
  KEY `id` (`id`),
  KEY `idx_lang_id` (`lang_id`),
  KEY `idx_set_id` (`set_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_tara`
#

INSERT INTO class_tara VALUES ('1', 'Romania', 'ro', '0');


#
# Table structure for table `class_tpl_colorschemes`
#

DROP TABLE IF EXISTS `class_tpl_colorschemes`;
CREATE TABLE `class_tpl_colorschemes` (
  `tpl` varchar(30) DEFAULT NULL,
  `colorscheme` varchar(50) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_tpl_colorschemes`
#

INSERT INTO class_tpl_colorschemes VALUES ('momentum', 'blue');
INSERT INTO class_tpl_colorschemes VALUES ('momentum', 'red');
INSERT INTO class_tpl_colorschemes VALUES ('momentum', 'green');
INSERT INTO class_tpl_colorschemes VALUES ('momentum', 'dark_blue');
INSERT INTO class_tpl_colorschemes VALUES ('momentum', 'forest');
INSERT INTO class_tpl_colorschemes VALUES ('momentum', 'orange');
INSERT INTO class_tpl_colorschemes VALUES ('momentum', 'anthracite');
INSERT INTO class_tpl_colorschemes VALUES ('momentum', 'yellow');
INSERT INTO class_tpl_colorschemes VALUES ('momentum', 'raspberry');


#
# Table structure for table `class_user_fields`
#

DROP TABLE IF EXISTS `class_user_fields`;
CREATE TABLE `class_user_fields` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `caption` varchar(200) NOT NULL,
  `type` varchar(20) NOT NULL DEFAULT 'textbox',
  `order_no` int(2) DEFAULT NULL,
  `is_numeric` tinyint(1) NOT NULL DEFAULT '0',
  `validation_type` varchar(100) DEFAULT NULL,
  `size` varchar(10) DEFAULT NULL,
  `min` int(10) DEFAULT NULL,
  `max` int(10) DEFAULT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `editable` tinyint(1) NOT NULL DEFAULT '1',
  `max_uploaded_size` int(6) DEFAULT NULL,
  `extensions` varchar(100) DEFAULT NULL,
  `image_resize` varchar(20) DEFAULT NULL,
  `groups` varchar(100) DEFAULT NULL,
  `dep_id` int(4) DEFAULT NULL,
  `other_val` tinyint(1) DEFAULT '0',
  `read_only` tinyint(1) DEFAULT '0',
  `unique` tinyint(1) DEFAULT '0',
  `ext1` tinyint(1) DEFAULT '0',
  `public` tinyint(1) NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_user_fields`
#

INSERT INTO class_user_fields VALUES ('1', 'username', 'username', '1', '0', '', '30', '0', '0', '1', '0', '0', '', '', '0', '0', '0', '1', '0', '0', '0', '1');
INSERT INTO class_user_fields VALUES ('2', 'email', 'user_email', '2', '0', '', '40', '0', '0', '1', '1', '0', '', '', '0', '0', '0', '1', '0', '0', '0', '1');
INSERT INTO class_user_fields VALUES ('3', 'password', 'password', '9', '0', '', '20', '0', '0', '1', '0', '0', '', '', '0', '0', '0', '1', '0', '0', '0', '1');
INSERT INTO class_user_fields VALUES ('4', 'contact_name', 'textbox', '3', '0', '', '50', '0', '0', '1', '1', '0', '', '', '0', '0', '0', '0', '0', '0', '2', '1');
INSERT INTO class_user_fields VALUES ('5', 'address', 'textbox', '4', '0', '', '60', '0', '0', '0', '1', '0', '', '', '0', '0', '0', '0', '0', '0', '2', '1');
INSERT INTO class_user_fields VALUES ('6', 'phone', 'phone', '5', '0', '', '30', '0', '0', '0', '1', '0', '', '', '0', '0', '0', '0', '0', '0', '2', '1');
INSERT INTO class_user_fields VALUES ('7', 'webpage', 'url', '7', '0', '', '50', '0', '0', '0', '1', '0', '', '', '0', '0', '0', '0', '0', '0', '1', '1');
INSERT INTO class_user_fields VALUES ('12', 'termeni_si_conditii', 'terms', '8', '0', '', '80x10', '', '', '1', '1', '', '', '', '0', '', '0', '0', '0', '0', '1', '1');
INSERT INTO class_user_fields VALUES ('9', 'mgm_email', 'user_email', '8', '0', '', '40', '0', '0', '1', '1', '0', '', '', '-1', '0', '0', '1', '0', '0', '0', '1');
INSERT INTO class_user_fields VALUES ('10', 'mgm_name', 'textbox', '10', '0', '', '40', '0', '0', '0', '1', '0', '', '', '-1', '0', '0', '0', '0', '0', '2', '1');
INSERT INTO class_user_fields VALUES ('11', 'mgm_phone', 'phone', '11', '0', '', '40', '0', '0', '0', '1', '0', '', '', '-1', '0', '0', '0', '0', '0', '2', '1');
INSERT INTO class_user_fields VALUES ('13', 'termeni_si_conditii', 'terms', '12', '0', '', '80x10', '', '', '1', '1', '', '', '', '-1', '', '0', '0', '0', '0', '1', '1');


#
# Table structure for table `class_user_fields_lang`
#

DROP TABLE IF EXISTS `class_user_fields_lang`;
CREATE TABLE `class_user_fields_lang` (
  `id` int(3) NOT NULL,
  `lang_id` varchar(20) DEFAULT 'eng',
  `name` varchar(64) NOT NULL,
  `top_str` varchar(64) DEFAULT NULL,
  `error_message` text,
  `error_message2` text,
  `info_message` text,
  `default_val` text,
  `prefix` varchar(64) DEFAULT NULL,
  `postfix` varchar(64) DEFAULT NULL,
  `elements` text,
  `date_format` varchar(30) DEFAULT NULL,
  KEY `idx_name` (`name`),
  KEY `idx_lang` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;

#
# Dumping data for table `class_user_fields_lang`
#

INSERT INTO class_user_fields_lang VALUES ('1', 'eng', 'Username', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('2', 'eng', 'Email', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('3', 'eng', 'Password', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('4', 'eng', 'Contact Name', '', 'Please fill in contact name!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('5', 'eng', 'Address', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('6', 'eng', 'Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('7', 'eng', 'Webpage', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('9', 'eng', 'Your Email Address', '', 'Please fill in your email address. This will be used to manage your listing.', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('10', 'eng', 'Your Name', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('11', 'eng', 'Your Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('1', 'esp', 'Username', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('2', 'esp', 'Email', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('3', 'esp', 'Password', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('4', 'esp', 'Contact Name', '', 'Please fill in contact name!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('5', 'esp', 'Address', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('6', 'esp', 'Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('7', 'esp', 'Webpage', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('9', 'esp', 'Your Email Address', '', 'Please fill in your email address. This will be used to manage your listing.', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('10', 'esp', 'Your Name', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('11', 'esp', 'Your Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('1', 'french', 'Username', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('2', 'french', 'Email', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('3', 'french', 'Password', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('4', 'french', 'Contact Name', '', 'Please fill in contact name!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('5', 'french', 'Address', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('6', 'french', 'Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('7', 'french', 'Webpage', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('9', 'french', 'Your Email Address', '', 'Please fill in your email address. This will be used to manage your listing.', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('10', 'french', 'Your Name', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('11', 'french', 'Your Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('1', 'italian', 'Username', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('2', 'italian', 'Email', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('3', 'italian', 'Password', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('4', 'italian', 'Contact Name', '', 'Please fill in contact name!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('5', 'italian', 'Address', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('6', 'italian', 'Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('7', 'italian', 'Webpage', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('9', 'italian', 'Your Email Address', '', 'Please fill in your email address. This will be used to manage your listing.', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('10', 'italian', 'Your Name', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('11', 'italian', 'Your Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('1', 'german', 'Username', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('2', 'german', 'Email', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('3', 'german', 'Password', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('4', 'german', 'Contact Name', '', 'Please fill in contact name!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('5', 'german', 'Address', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('6', 'german', 'Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('7', 'german', 'Webpage', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('9', 'german', 'Your Email Address', '', 'Please fill in your email address. This will be used to manage your listing.', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('10', 'german', 'Your Name', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('11', 'german', 'Your Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('1', 'ro', 'Utilizator', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('2', 'ro', 'Email', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('3', 'ro', 'Parola', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('4', 'ro', 'Nume', '', 'Va rugam sa introduceti un nume.', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('5', 'ro', 'Adresa', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('6', 'ro', 'Telefon', '', 'Va rugam sa introduceti un numar de telefon.', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('7', 'ro', 'Pagina Web', '', 'Nu ati introdus o pagina web.', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('9', 'ro', 'Adresa E-mail', '', 'Va rugam sa introduceti o adresa de email valida.', '', 'Este necesara o adresa de email valida. se va trimite un email de confirmare.', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('10', 'ro', 'Numele', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('11', 'ro', 'Telefon', '', 'Va rugam sa introduceti un numar de telefon.', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('1', 'hr', 'Username', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('2', 'hr', 'Email', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('3', 'hr', 'Password', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('4', 'hr', 'Contact Name', '', 'Please fill in contact name!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('5', 'hr', 'Address', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('6', 'hr', 'Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('7', 'hr', 'Webpage', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('9', 'hr', 'Your Email Address', '', 'Please fill in your email address. This will be used to manage your listing.', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('10', 'hr', 'Your Name', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('11', 'hr', 'Your Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('1', 'hu', 'Username', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('2', 'hu', 'Email', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('3', 'hu', 'Password', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('4', 'hu', 'Contact Name', '', 'Please fill in contact name!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('5', 'hu', 'Address', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('6', 'hu', 'Phone', '', 'Please fill in your phone number!', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('7', 'hu', 'Webpage', '', '', '', '', '', '', '', '', '');
INSERT INTO class_user_fields_lang VALUES ('13', 'ro', 'Termeni si C