<?php
/*
	*	
	* OxyClassifieds.com : PHP Classifieds (http://www.oxyclassifieds.com)
	* version 9
	* (c) 2017 OxyClassifieds.com (office@oxyclassifieds.com).
	*
*/
require_once "include/include.php";
require_once "classes/groups.php";
require_once "classes/affiliates.php";

global $db;
global $lng;
$smarty = new Smarty;
$smarty = common($smarty);
$smarty->assign("lng",$lng);
$smarty->assign("section","account");

global $logged_in, $crt_usr;

if(!$logged_in) { header("Location: ".$config_live_site."/login.php?loc=affiliateaccount.php"); exit(0); }
$smarty->assign("username",$logged_in);

$usr = new users();
$user = $usr->getUser($crt_usr);
$smarty->assign("user",$user);


// number of auto register groups
global $config_vars;
$no_groups = $config_vars['no_groups'];
$smarty->assign("no_groups", $no_groups);
$groups = new groups();
$smarty->assign("group", $groups->getGroup($user['group']));

$auth = new auth();
$last_login=$auth->getLoginBefore($logged_in);

$aff = new affiliates;
$last_payment = $aff->getLastPayment($user['affiliate_id']);
$next_payment_date = $aff->nextPaymentDate();
$total_due = $aff->getTotalDue($user['affiliate_id']);
$total_payments = $aff->getTotalPayments($user['affiliate_id']);
$pending_payment = $aff->getPendingPayment($user['affiliate_id']);

$smarty->assign("last_login",$last_login);
$smarty->assign("last_payment", $last_payment);
$smarty->assign("next_payment_date", $next_payment_date);
$smarty->assign("total_due",$total_due);
$smarty->assign("total_payments",$total_payments);
$smarty->assign("pending_payment",$pending_payment);


$db->close();
if($db->error!='') { $db_error = $db->getError(); $smarty->assign('db_error',$db_error); }

$smarty->display('affiliateaccount.html');
close();
?>