<?php
/*
	*	
	* OxyClassifieds.com : PHP Classifieds (http://www.oxyclassifieds.com)
	* version 9
	* (c) 2017 OxyClassifieds.com (office@oxyclassifieds.com).
	*
*/
require_once "include/include.php";
require_once "include/payments.php";
require_once "classes/payment_actions.php";
require_once "classes/users_packages.php";
require_once "classes/payment.php";
require_once "classes/payment_processors.php";
require_once "classes/priorities.php";

global $db;
global $lng;
$smarty = new Smarty;
$smarty = common($smarty);
$smarty->assign("lng",$lng);
$smarty->assign("section","account");

$auth=new auth();
$username = $auth->loggedIn();
if(!$username) { header("Location: ".$config_live_site."/not_authorized.php"); exit(0); }
$smarty->assign("username",$username);
global $crt_usr;

$id = get_numeric_only("id");

$actions=new payment_actions();
$action = $actions->getPaymentAction($id);
if($action['user_id'] != $crt_usr) { header("Location: ".$config_live_site."/not_authorized.php"); exit(0); }
$smarty->assign("action",$action);

// recalculate amount
/*$calc_amount = $actions->recalculateAmount($crt_usr, unserialize($action['action']));
if($action['amount']!=$calc_amount) {

	$error = $lng['order_history']['invalid_order'];
	$smarty->assign("error",$error);

}
else {
*/
$total = add_currency(format_numeric($action['amount']));
$smarty->assign("total",$total);

$payment = new payment( $action['processor'] , $action['ukey'] );
$payment->setUserId($crt_usr);
$payment->setAmount($action['amount']);
$manual = $payment->getManual();
$payment->setFormTitle($lng['listings']['finalize']);
$payment_form = $payment->writeForm($action['id']);
$smarty->assign("pay_form",$payment_form);

//}

$db->close();
if($db->error!='') { $db_error = $db->getError(); $smarty->assign('db_error',$db_error); }

$smarty->display('complete_payment.html');
close();
?>
